;
;        FILE: ADVDATA2.ASM
;
;        DATA VARIABLES AND TABLES
;

;        VERB TABLE

VERBTB DB 'LOOK',1
       DB 'L   ',1
       DB 'EXAM',1
       DB 'INVE',2
       DB 'I   ',2
       DB 'G   ',3
       DB 'GET ',3
       DB 'TAKE',3
       DB 'GRAB',3
       DB 'PUT ',4
       DB 'DROP',4
       DB 'P   ',4
       DB 'THRO',4
       DB 'NORT',5
       DB 'N   ',5
       DB 'SOUT',6
       DB 'S   ',6
       DB 'EAST',7
       DB 'E   ',7
       DB 'WEST',8
       DB 'W   ',8
       DB 'UP  ',9
       DB 'U   ',9
       DB 'DOWN',10
       DB 'D   ',10
       DB 'GO  ',11
       DB 'WALK',11
       DB 'RUN ',11
       DB 'SAVE',13
       DB 'LOAD',14
       DB 'HELP',15
       DB 'SCOR',16
       DB 'QUIT',17
       DB 'OPEN',18
       DB 'CLIM',19
       DB 'READ',20
       DB 'PLAY',21
       DB 'CLOS',22
       DB 'UNLO',23
       DB 'BREA',24
       DB 'SMAS',24
       DB 'BUIL',25
       DB 'MAKE',25
       DB 'PULL',26
       DB 'HEAR',27
       DB 'LIST',27
       DB 'CUT ',28
       DB 'CLIP',28
       DB 'SAW ',28
       DB 'LIGH',29
       DB 'UNLI',30
       DB 'EXTI',30
       DB 'SNUF',30
       DB 'WEAR',31
       DB 'ENTE',32
       DB 'GIVE',33
       DB 'TAST',34
       DB 'DRIN',35
       DB 'DIG ',36
       DB 'SHOV',36
       DB 'INVO',37
       DB 0

;        NOUN TABLE

NOUNTB DB 'NORT',1
       DB 'SOUT',2
       DB 'EAST',3
       DB 'WEST',4
       DB 'UP  ',5
       DB 'DOWN',6
       DB 'INVE',7
       DB 'SNOW',9
       DB 'NEED',10
       DB 'JUG ',11
       DB 'WINE',11
       DB 'NET ',15
       DB 'MATC',16
       DB 'WOMA',17
       DB 'GIRL',17
       DB 'HOOD',18
       DB 'ROBE',18
       DB 'MANU',19
       DB 'PARC',20
       DB 'MUSI',20
       DB 'LANT',21
       DB 'LAMP',21
       DB 'KEY ',23
       DB 'KEYS',23
       DB 'SHEA',24
       DB 'SAW ',25
       DB 'RAVE',26
       DB 'HAMM',27
       DB 'BOAR',28
       DB 'NAIL',29
       DB 'HAIR',30
       DB 'SHEE',31
       DB 'SALT',32
       DB 'SHOV',33
       DB 'FEAT',34
       DB 'MESS',35
       DB 'NOTE',35
       DB 'EMBL',36
       DB 'SLEE',36
       DB 'BACH',37
       DB 'FUGU',37
       DB 'ASH ',38
       DB 'ASHE',38
       DB 'EPIS',39
       DB 'PASS',100
       DB 'PINE',101
       DB 'TREE',101
       DB 'SKEL',104
       DB 'PLAQ',105
       DB 'BRON',105
       DB 'BOOK',106
       DB 'ALTA',107
       DB 'ALTE',107
       DB 'MANT',108
       DB 'CABI',110
       DB 'COFF',112
       DB 'VENT',114
       DB 'OPEN',114
       DB 'MAN ',115
       DB 'CARE',115
       DB 'LECT',116
       DB 'CIRC',117
       DB 'STAT',118
       DB 'ORGA',120
       DB 'MIRR',121
       DB 'CLOS',122
       DB 'BED ',123
       DB 'STAI',124
       DB 'STEP',124
       DB 'FIRE',125
       DB 'DOOR',127
       DB 'ALL ',128
       DB 'EVER',128
       DB 0

;******************************
;
; SPECIAL ACTION TABLE. LISTS
; VERB/NOUN COMBO'S THAT HAVE
; SPECIAL PROCESSING ROUTINES.
; FORMAT IS:
;
;  # BYTES       DEXCRIPTION
;  -------   ------------------
;     1      VERB NUMBER
;     1      NOUN NUMBER
;     2      SPECIAL RTN ADDR
;
;******************************

SPCRTN DW 016EH,LOOK01 ;LOOK CABIN
       DW 0109H,LOOK02 ;LOOK SNOW
       DW 016CH,LOOK03 ;LOOK MANTLE
       DW 0172H,LOOK04 ;LOOK VENT
       DW 016AH,LOOK05 ;LOOK BOOKS
       DW 017FH,LOOK06 ;LOOK DOOR
       DW 0124H,LOOK07 ;LOOK EMBLEM
       DW 011EH,LOOK08 ;LOOK HAIR
       DW 0111H,LOOK09 ;LOOK WOMAN
       DW 010AH,LOOK11 ;LOOK NEEDLES
       DW 0123H,LOOK12 ;LOOK NOTE
       DW 0168H,LOOK13 ;LOOK SKELETON
       DW 0120H,LOOK14 ;LOOK SALT
       DW 011CH,LOOK15 ;LOOK BOARDS
       DW 011DH,LOOK15 ;LOOK NAILS
       DW 0307H,VINVE  ;TAKE INVENTORY
       DW 0320H,GET01  ;GET SALT
       DW 0323H,GET02  ;GET NOTE
       DW 0309H,GET03  ;GET SNOW
       DW 030AH,GET04  ;GET NEEDLES
       DW 0317H,GET05  ;GET KEYS
       DW 0318H,GET05  ;GET SHEARS
       DW 0319H,GET05  ;GET SAW
       DW 0322H,GET07  ;GET FEATHER
       DW 031AH,GET08  ;GET RAVEN
       DW 0368H,GET09  ;GET SKELETON
       DW 031FH,GET10  ;GET SHEET
       DW 031EH,GET11  ;GET HAIR
       DW 036CH,GET12  ;GET MANTLE
       DW 0409H,PUT01  ;PUT SNOW
       DW 0426H,PUT02  ;PUT ASH
       DW 0B6EH,GO01   ;GO CABIN
       DW 0B7FH,GO02   ;GO DOOR
       DW 0B7AH,GO03   ;GO CLOSET
       DW 0B79H,GO04   ;GO MIRROR
       DW 0B7CH,GO05   ;GO STEPS
       DW 0B72H,GO06   ;GO VENT
       DW 0B64H,GO07   ;GO PASSAGE
       DW 127FH,OPEN01 ;OPEN DOOR
       DW 1270H,OPEN02 ;OPEN COFFIN
       DW 137CH,GO05   ;CLIMB STEPS
       DW 1413H,LOOKOB ;READ MANU
       DW 1423H,LOOK12 ;READ NOTE
       DW 1469H,LOOKOB ;READ PLAQUE
       DW 1414H,LOOKOB ;READ MUSIC
       DW 1525H,PLAY01 ;PLAY BACH
       DW 1514H,PLAY02 ;PLAY MUSIC
       DW 167FH,CLOS01 ;CLOSE DOOR
       DW 1A22H,GET07  ;PULL FEATHER
       DW 1F12H,VGET   ;WEAR ROBE
       DW 2079H,GO04   ;ENTER MIRROR
       DW 207AH,GO03   ;ENTER CLOSET
       DW 206EH,GO01   ;ENTER CABIN
       DW 2064H,GO07   ;ENTER PASSAGE
       DW 2072H,GO06   ;ENTER VENT
       DW 207FH,GO02   ;ENTER DOOR
       DW 210BH,VPUT   ;GIVE WINE
       DW 230BH,VTASTE ;DRINK WINE
       DW 0

; SPECIAL ACTION ON ENTRY TO A
; ROOM TABLE.  FORMAT IS:
;      ROOM#,RTNADDR

ENTRTB DB 5
       DW ENTR05
       DB 12
       DW ENTR12
       DB 13
       DW ENTR12
       DB 0

; SPECIAL ACTION ON EXIT FROM
; A ROOM TABLE.

EXITTB DB 11
       DW EXIT11
       DB 12
       DW EXIT12
       DB 13
       DW EXIT12
       DB 0

; SPECIAL ACTION FOR COMMANDS
; GIVEN WHILE IN A ROOM TABLE

INRMTB DB 5
       DW INRM05
       DB 13
       DW INRM13
       DB 18
       DW INRM18
       DB 0

; ROOM TO SHOW HOODED FIGURE

FIGRMS DB 8,9,14,15,16,17,19,21,22
       DB 0

; MESSAGE TABLE FOR GENERAL
; LOOK AT OBJECT ROUTINE
;
; FMT:       DB OBJ#
;          MSG# IF CARRYING
;          MSG# IF IN ROOM

OBJMSG DB 121,0,38   ;MIRROR
       DB 125,0,39   ;FIREPLACE
       DB 118,0,42   ;STATUES
       DB 116,0,43   ;LECTERN
       DB 19,45,10   ;MANUSCRIPT
       DB 18,46,46   ;ROBE
       DB 105,0,47   ;PLAQUE
       DB 123,0,51   ;BED
       DB 35,52,10   ;MESSAGE
       DB 20,59,10   ;MUSIC
       DB 98,0,68    ;STATUE OF WOMAN
       DB 11,53,53   ;JUG/WINE
       DB 12,22,22   ;JUG/EMPTY
       DB 13,54,54   ;JUG/SNOW
       DB 14,55,55   ;JUG/WATER
       DB 112,0,29   ;CLOSED COFFIN
       DB 111,0,81   ;OPEN COFFIN
       DB 21,32,32   ;UNLIT LAMP
       DB 22,31,31   ;LIT LAMP
       DB 117,0,90   ;CIRCLE OF SALT
       DB 113,0,93   ;STONE STEPS
       DB 120,0,94   ;ORGAN
       DB 119,0,94   ;ORGAN
       DB 0

; OBJECT EQUATE TABLE DEFINES
; OBJECTS THAT MAY HAVE MULTIPLE
; OBJECT NUMBERS.
;
; FORMAT:       DB X,Y,Y,Y,Y
;  WHERE: X = PRIMARY OBJ #
;         Y = SECONDARY OBJ #
;             OR ZERO FOR NONE

EQUTAB DB 112,111,0             ;COFFIN
       DB 127,126,103,102,122,0 ;DOOR
       DB 120,119,0             ;ORGAN
       DB 118,98,0              ;STATUES
       DB 115,99,0              ;OLD MAN
       DB 110,109,0             ;CABIN
       DB 11,12,13,14,0         ;JUG
       DB 21,22,0               ;LAMP
       DB 124,113,0             ;STEPS
       DB 28,103,0              ;BOARDS
       DB 0

; DEFINE OBJECTS THAT SHOULD
; BE REFERRED TO AS "THEM"
;
; FORMAT IS: OBJ#,TYPE
;      WHERE TYPE IS:
;            0 = IT
;            1 = THEM
;            2 = HER
;            3 = HIM
;

THEMTB DB 124,1  ;STAIRS
       DB 118,1  ;STATUES
       DB 115,3  ;OLD MAN
       DB 10,1   ;PINE NEEDLES
       DB 16,1   ;MATCHES
       DB 23,1   ;KEYS
       DB 24,1   ;SHEARS
       DB 28,1   ;BOARDS
       DB 29,1   ;NAILS
       DB 17,2   ;WOMAN
       DB 0

; LITERAL TABLE FOR IT,THEM,HIM
; HER MESSAGES.

LITTAB DB 'it.',0
       DB 'them.',0
       DB 'her.',0
       DB 'him.',0

; ROOM TABLE.  DEFINES THE
; LAYOUT OF THE ADVENTURE. EACH
; ENTRY HAS THE FOLLOWING
; FORMAT:
;
; # BYTES        DESCRIPTION
; -------   -------------------
;    1      ROOM # TO NORTH
;    1      ROOM # TO SOUTH
;    1      ROOM # TO EAST
;    1      ROOM # TO WEST
;    1      ROOM # UP
;    1      ROOM # DOWN

;ROOM 1
RMTBDF DB 2,2,0,2,0,0
;ROOM 2
       DB 2,3,2,2,0,0
;ROOM 3
       DB 2,2,1,2,0,0
;ROOM 4
       DB 0,0,0,1,0,0
;ROOM 5
       DB 0,0,0,0,0,0
;ROOM 6
       DB 0,0,0,0,0,5
;ROOM 7
       DB 0,0,0,6,0,0
;ROOM 8
       DB 0,9,0,0,0,0
;ROOM 9
       DB 8,0,19,14,0,0
;ROOM 10
       DB 9,0,0,0,0,0
;ROOM 11
       DB 0,0,0,0,0,0
;ROOM 12
       DB 13,0,0,0,0,0
;ROOM 13
       DB 0,12,0,0,0,0
;ROOM 14
       DB 15,21,9,0,0,0
;ROOM 15
       DB 0,14,0,16,0,0
;ROOM 16
       DB 19,17,15,0,0,0
;ROOM 17
       DB 16,0,0,0,0,0
;ROOM 18
       DB 0,0,0,0,0,17
;ROOM 19
       DB 20,16,0,9,0,0
;ROOM 20
       DB 0,19,21,0,0,0
;ROOM 21
       DB 14,22,0,20,0,0
;ROOM 22
       DB 21,0,23,0,0,0
;ROOM 23
       DB 0,0,0,22,0,0
;ROOM 24
       DB 0,0,0,0,0,0

;ROOM 1
RMOBDF DB 101,109,0
;ROOM 2
       DB 101,0
;ROOM 3
       DB 101,0
;ROOM 4
       DB 33,126,0
;ROOM 5
       DB 127,124,125,11,16+INV,15,0
;ROOM 6
       DB 122,123,124,17,31+INV,0
;ROOM 7
       DB 121,18,0
;ROOM 8
       DB 121,0
;ROOM 9
       DB 126,105,0
;ROOM 10
       DB 120,118,0
;ROOM 11
       DB 117,26,116,100,0
;ROOM 12
       DB 113,114,0
;ROOM 13
       DB 112,27,0
;ROOM 14
       DB 0
;ROOM 15
       DB 0
;ROOM 16
       DB 0
;ROOM 17
       DB 124,0
;ROOM 18
       DB 115,124,23,24,25,0
;ROOM 19
       DB 0
;ROOM 20
       DB 106,19+INV,20+INV,0
;ROOM 21
       DB 0
;ROOM 22
       DB 0
;ROOM 23
       DB 103,21,0
;ROOM 24
       DB 0
       DB 10 DUP(0)               ;RESERVE
RMTBEND  DB    0

; TREASURE POINT TABLE
; FORMAT:       DB TREASURE,POINTS

PNTTAB EQU $
       DB 0

; ROOM DIRECTION TABLE USED DURING GAME PLAY
; SOURCE IS RMTBDF

ROOMTB   DB    RMOBDF - RMTBDF DUP (?)

; ROOM OBJECT TABLE USED DURING GAME PLAY
; SOURCE IS RMOBDF

RMOBT1   DB    RMTBEND - RMOBDF DUP (?)
RMOBT2   DB    0

RMTB_LEN DW    RMTBEND - RMTBDF


; GRAPHIC SCREEN INDICATOR
; TABLE (BY ROOM)

SCRIND EQU $
;ROOM 1
       DB 6,1,2,0
;ROOM 2
       DB 6,3,0
;ROOM 3
       DB 6,3,0
;ROOM 4
       DB 5,5,0
;ROOM 5
       DB 1,59,18,19,20,21,12,13,16,17,15,0
;ROOM 6
       DB 4,59,27,26,28,29,30,58,0
;ROOM 7
       DB 7,34,38,41,42,32,33,39,35,36,37,0
;ROOM 8
       DB 8,43,44,45,8,9,10,11,0
;ROOM 9
       DB 8,46,48,8,9,10,11,0
;ROOM 10
       DB 1,110,111,114,115,117,118
       DB 119,120,112,113,0
;ROOM 11
       DB 2,109,105,106,107,108,98
       DB 101,102,103,0
;ROOM 12
       DB 9,51,52,46,60,61,62,63,64,0
;ROOM 13
       DB 9,51,52,47,94,95,0
;ROOM 14
       DB 8,46,47,8,9,10,11,0
;ROOM 15
       DB 9,46,51,52,53,56,8,11,0
;ROOM 16
       DB 8,46,47,8,9,10,11,0
;ROOM 17
       DB 9,47,54,51,52,53,56,8,11,0
;ROOM 18
       DB 4,72,84,85,90,92,0
;ROOM 19
       DB 8,47,8,9,10,11,0
;ROOM 20
       DB 1,72,75,68,69,70,71,0
;ROOM 21
       DB 8,46,8,9,10,11,0
;ROOM 22
       DB 9,51,52,53,56,46,8,11,0
;ROOM 23
       DB 1,72,75,80,71,0
;ROOM 24
       DB 2,109,105,106,107,108,137,138,0

; ANTIMATION ROUTINES BY ROOM
;
; FORMAT: ROOM #,RTN VECTOR

ANTTAB EQU $
       DB 1
       DW MOVSMO
       DB 2
       DW MOVCLO
       DB 3
       DW MOVCLO
       DB 5
       DW MOVFIR
       DB 8
       DW MOVTR4
       DB 9
       DW MOVTR4
       DB 11
       DW MOVEYE
       DB 14
       DW MOVTR4
       DB 15
       DW MOVTR2
       DB 16
       DW MOVTR4
       DB 17
       DW MOVTR2
       DB 19
       DW MOVTR4
       DB 21
       DW MOVTR4
       DB 22
       DW MOVTR2
       DB 0

; IF OBJECT DROPPED IN ROOM PUT IT IN ANOTHER ROOM TABLE
; FORMAT: CURR ROOM,NEW ROOM

PUTTAB DB 0

; MOVABLE OBJ TABLE
;
; OBJECT#,OVERLAY#,OVERLAY#,ROOM,...ROOM,0

MOVOBJ DB 33,125,126     ;SHOVEL
       DB 1,2,3,5,6,8,9,12,14,16,17,18,19
       DB 20,21,22,23,0

       DB 33,6,0         ;SHOVEL
       DB 4,0

       DB 126,4,0        ;DOOR
       DB 4,0

       DB 127,7,0        ;DOOR
       DB 4,0

       DB 127,22,57      ;DOOR
       DB 5,0

       DB 126,23,0       ;DOOR
       DB 5,0

       DB 126,49,0       ;DOOR
       DB 9,0

       DB 127,50,55      ;DOOR
       DB 9,0

       DB 102,82,83      ;DOOR
       DB 23,0

       DB 103,76,81      ;DOOR
       DB 23,0

       DB 96,66,67       ;DOOR
       DB 12,0

       DB 113,65,0       ;DOOR
       DB 12,0

       DB 16,24,0        ;MATCHES
       DB 5,0

       DB 97,25,0        ;SNOW
       DB 5,0

       DB 17,31,0        ;WOMAN
       DB 6,0

       DB 18,40,0        ;ROBE
       DB 7,0

       DB 19,73,0        ;MANUSCRIPT
       DB 20,0

       DB 20,74,0        ;PARCHMENT (MUSIC)
       DB 20,0

       DB 21,77,0        ;LANTERN
       DB 23,0

       DB 22,77,0        ;LANTERN
       DB 23,0

       DB 24,86,0        ;SHEARS
       DB 1,2,3,5,6,8,9,12,14,16,17,18
       DB 19,21,22,23,0

       DB 23,87,124      ;KEYS
       DB 1,2,3,5,6,7,8,9,12,14,15,16,17,18
       DB 19,20,21,22,23,0

       DB 25,88,89       ;HAND SAW
       DB 1,2,3,5,6,7,8,9,12,14,15,16,17,18
       DB 19,20,21,22,23,0

       DB 111,96,97      ;COFFIN
       DB 13,0

       DB 112,93,0       ;CLOSED COFFIN
       DB 13,0

       DB 28,78,79       ;BOARDS ON FLOOR
       DB 5,20,23,0

       DB 26,99,100      ;RAVEN
       DB 11,0

       DB 95,104,0       ;HOODED FIGURE
       DB 11,0

       DB 120,116,0      ;ORGAN
       DB 10,0

       DB 119,122,121    ;ORGAN
       DB 10,0

       DB 115,91,0       ;OLD MAN
       DB 18,0

       DB 99,123,0       ;OLD MAN
       DB 15,0

       DB 15,127,128     ;BUTTERFLY NET
       DB 1,2,3,5,6,8,12,13,14,15
       DB 16,17,18,19,20,21,22,23,0

       DB 11,129,0       ;JUG OF WINE
       DB 5,15,18,20,23,0

       DB 12,129,0       ;JUG OF WINE
       DB 5,15,18,20,23,0

       DB 14,129,0       ;JUG OF WINE
       DB 5,15,18,20,23,0

       DB 107,130,0      ;ALTAR
       DB 13,0

       DB 27,131,0       ;HAMMER
       DB 8,9,12,13,14,15,16,17
       DB 19,21,22,0

       DB 118,132,133    ;STATUES
       DB 10,0

       DB 94,134,135     ;FLAMING SALT
       DB 11,0

       DB 118,137,138    ;STATUE OF ME
       DB 11,0

       DB 98,139,140     ;STATUE OF WOMAN
       DB 11,0

       DB 34,136,0       ;FEATHER
       DB 11,0

       DB 0

;
; GRAPHIC SCREEN PNTR TABLE
;

SCRTAB DW SCRBLU,SCRBLK,SCRWHT
       DW SCRRED,SCRCAB,SCRWDS
       DW SCRCLO,SCRCOR,SCRCR1

;
; GRAPHIC OBJECT PNTR TABLE
;

SCROBJ EQU $
       DEFOVL  OVCBN1,29,85       ;001
       DEFOVL  OVCBN2,29,117      ;002
       DEFOVL  OVTRE1,53,85       ;003
       DEFOVL  OVDOR1,17,45       ;004
       DEFOVL  OVSNO1,83,1        ;005
       DEFOVL  OVSVL1,50,101      ;006
       DEFOVL  OVDOR2,17,45       ;007
       DEFOVL  OVTR12,25,29       ;008
       DEFOVL  OVTR22,31,49       ;009
       DEFOVL  OVTR32,32,77       ;010
       DEFOVL  OVTR42,25,93       ;011
       DEFOVL  OVFIR1,1,57        ;012
       DEFOVL  OVFIR2,30,49       ;013
       DEFOVL  OVFIR3,52,57       ;014
       DEFOVL  OVFIR4,52,57       ;015
       DEFOVL  OVSTA1,65,1        ;016
       DEFOVL  OVSTA2,73,13       ;017
       DEFOVL  OVWAL1,1,21        ;018
       DEFOVL  OVWAL2,1,105       ;019
       DEFOVL  OVWAL3,69,105      ;020
       DEFOVL  OVWAL4,69,13       ;021
       DEFOVL  OVDOR3,27,109      ;022
       DEFOVL  OVDOR4,27,125      ;023
       DEFOVL  OVMAT1,37,69       ;024
       DEFOVL  OVSNO2,28,117      ;025
       DEFOVL  OVBED1,1,1         ;026
       DEFOVL  OVBED2,1,21        ;027
       DEFOVL  OVBED3,63,1        ;028
       DEFOVL  OVBED4,76,13       ;029
       DEFOVL  OVBED5,71,101      ;030
       DEFOVL  OVBED6,78,5        ;031
       DEFOVL  OVCLS1,14,1        ;032
       DEFOVL  OVCLS2,14,81       ;033
       DEFOVL  OVCLS3,1,45        ;034
       DEFOVL  OVCLS4,4,53        ;035
       DEFOVL  OVCLS5,4,77        ;036
       DEFOVL  OVCLS6,4,57        ;037
       DEFOVL  OVCLS7,79,29       ;038
       DEFOVL  OVCLS8,18,21       ;039
       DEFOVL  OVCLS9,20,21       ;040
       DEFOVL  OVCLSA,1,41        ;041
       DEFOVL  OVCLSB,1,89        ;042
       DEFOVL  OVCOR1,30,1        ;043
       DEFOVL  OVCOR2,30,17       ;044
       DEFOVL  OVCOR3,30,5        ;045
       DEFOVL  OVCOR4,24,5        ;046
       DEFOVL  OVCOR5,23,101      ;047
       DEFOVL  OVCOR6,39,33       ;048
       DEFOVL  OVCOR7,31,105      ;049
       DEFOVL  OVCOR8,31,89       ;050
       DEFOVL  OVCOR9,1,37        ;051
       DEFOVL  OVCORA,1,89        ;052
       DEFOVL  OVTOR1,32,25       ;053
       DEFOVL  OVCORC,66,109      ;054
       DEFOVL  OVCORB,31,105      ;055
       DEFOVL  OVTOR4,31,93       ;056
       DEFOVL  OVDOR5,27,125      ;057
       DEFOVL  OVBED7,21,53       ;058
       DEFOVL  OVFLR2,69,1        ;059
       DEFOVL  OVPAS1,52,81       ;060
       DEFOVL  OVPAS2,1,53        ;061
       DEFOVL  OVPAS3,56,57       ;062
       DEFOVL  OVPAS4,62,53       ;063
       DEFOVL  OVPAS5,67,53       ;064
       DEFOVL  OVPAS6,15,57       ;065
       DEFOVL  OVPAS7,15,57       ;066
       DEFOVL  OVPAS8,15,61       ;067
       DEFOVL  OVSTD1,1,17        ;068
       DEFOVL  OVSTD2,1,81        ;069
       DEFOVL  OVSTD3,1,21        ;070
       DEFOVL  OVSTD4,20,1        ;071
       DEFOVL  OVFLR1,67,1        ;072
       DEFOVL  OVSTD5,72,53       ;073
       DEFOVL  OVSTD6,70,81       ;074
       DEFOVL  OVALC1,67,9        ;075
       DEFOVL  OVALC2,12,77       ;076
       DEFOVL  OVALC3,61,41       ;077
       DEFOVL  OVALC4,79,29       ;078
       DEFOVL  OVALC5,84,33       ;079
       DEFOVL  OVALC6,1,25        ;080
       DEFOVL  OVALC7,31,73       ;081
       DEFOVL  OVALC8,12,77       ;082
       DEFOVL  OVALC9,12,89       ;083
       DEFOVL  OVLFT1,70,1        ;084
       DEFOVL  OVLFT2,70,21       ;085
       DEFOVL  OVLFT3,70,77       ;086
       DEFOVL  OVLFT4,80,65       ;087
       DEFOVL  OVLFT5,83,73       ;088
       DEFOVL  OVLFT6,82,81       ;089
       DEFOVL  OVLFT7,1,113       ;090
       DEFOVL  OVLFT8,33,49       ;091
       DEFOVL  OVLFT9,68,113      ;092
       DEFOVL  OVCRY1,48,45       ;093
       DEFOVL  OVCRY2,55,45       ;094
       DEFOVL  OVCRY3,66,41       ;095
       DEFOVL  OVCRY4,33,45       ;096
       DEFOVL  OVCRY5,48,45       ;097
       DEFOVL  OVSTR1,83,41       ;098
       DEFOVL  OVSTR2,70,105      ;099
       DEFOVL  OVSTR3,73,109      ;100
       DEFOVL  OVSTR4,35,33       ;101
       DEFOVL  OVSTR5,39,37       ;102
       DEFOVL  OVSTR6,35,53       ;103
       DEFOVL  OVSTR7,22,41       ;104
       DEFOVL  OVSTR8,1,9         ;105
       DEFOVL  OVSTR9,1,113       ;106
       DEFOVL  OVSTRA,69,1        ;107
       DEFOVL  OVSTRB,69,117      ;108
       DEFOVL  OVSTRC,69,1        ;109
       DEFOVL  OVIMP1,82,1        ;110
       DEFOVL  OVIMP2,1,1         ;111
       DEFOVL  OVIMP3,4,57        ;112
       DEFOVL  OVIMP4,21,49       ;113
       DEFOVL  OVIMP5,9,29        ;114
       DEFOVL  OVIMP6,9,97        ;115
       DEFOVL  OVIMP7,65,53       ;116
       DEFOVL  OVIMP8,2,1         ;117
       DEFOVL  OVIMP9,82,1        ;118
       DEFOVL  OVIMPA,2,101       ;119
       DEFOVL  OVIMPB,82,101      ;120
       DEFOVL  OVIMPC,67,53       ;121
       DEFOVL  OVIMPD,65,65       ;122
       DEFOVL  OVMAN1,72,41       ;123
       DEFOVL  OVLFTA,81,69       ;124
       DEFOVL  OVSVL2,75,57       ;125
       DEFOVL  OVSVL3,77,61       ;126
       DEFOVL  OVNET1,76,81       ;127
       DEFOVL  OVNET2,72,97       ;128
       DEFOVL  OVJUG1,61,89       ;129
       DEFOVL  OVATR1,80,49       ;130
       DEFOVL  OVHAM1,83,93       ;131
       DEFOVL  OVSTX1,52,37       ;132
       DEFOVL  OVSTX2,52,93       ;133
       DEFOVL  OVSTRD,82,41       ;134
       DEFOVL  OVSTRE,62,57       ;135
       DEFOVL  OVSTRF,77,93       ;136
       DEFOVL  OVSTX3,28,81       ;137
       DEFOVL  OVSTX4,28,85       ;138
       DEFOVL  OVSTX5,28,93       ;139
       DEFOVL  OVSTX6,28,97       ;140
       DEFOVL  OVFIG1,29,33       ;141
       DEFOVL  OVFIG2,29,37       ;142
       DEFOVL  OVTR11,25,29       ;143
       DEFOVL  OVTR41,25,93       ;144
       DEFOVL  OVTR21,31,49       ;145
       DEFOVL  OVTR31,32,77       ;146

GENHLP EQU $
       DB 13,'T','r','y'+80H
       DB 'examinin','g'+80H
       DB 'things.',0

       DB 13,'N','o'+80H
       DB 'HEL','P'+80H
       DB 'available.',0

       DB 13,'U','s','e'+80H
       DB 'SAV','E'+80H
       DB 'whe','n'+80H
       DB 'enterin','g'+80H
       DB 'dangerou','s'+80H
       DB 'areas.',0

       DB 13,'I',QUOTE,'m'+80H
       DB 'stumpe','d'+80H
       DB 'too!',0

;******************************
;
; DIRECTION DESCRIPTIONS TABLE
;
;******************************

DIRECT EQU $
       DB 'North',0
       DB 'South',0
       DB 'East',0
       DB 'West',0
       DB 'Up',0
       DB 'Down',0

;******************************
;
; OBJECT DESCRIPTIONS TABLE
;
;******************************

OBJTAB EQU $

       DB 9
       DB 'snow',0

       DB 10
       DB 'pin','e'+80H
       DB 'needles',0

       DB 11,'a'+80H
       DB 'ju','g'+80H,C$OF
       DB 'wine',0

       DB 12,C$AN
       DB 'empt','y'+80H
       DB 'jug',0

       DB 13,'a'+80H
       DB 'ju','g'+80H
       DB 'ful','l'+80H,C$OF
       DB 'snow',0

       DB 14,'a'+80H
       DB 'ju','g'+80H
       DB 'ful','l'+80H,C$OF
       DB 'water',0

       DB 15,'a'+80H
       DB 'butterfl','y'+80H
       DB 'net',0

       DB 16
       DB 'matches',0

       DB 17,'a'+80H
       DB 'youn','g'+80H
       DB 'woman',0

       DB 18,'a'+80H
       DB 'hoode','d'+80H
       DB 'robe',0

       DB 19,C$AN
       DB 'ol','d'+80H
       DB 'manuscript',0

       DB 20,'a'+80H
       DB 'parchmen','t'+80H
       DB 'wit','h'+80H
       DB 'musica','l'+80H
       DB 'scoring',0

       DB 21,C$AN
       DB 'unli','t'+80H
       DB 'lantern',0

       DB 22,'a'+80H
       DB 'lighte','d'+80H
       DB 'lantern',0

       DB 23,'a'+80H
       DB 'rin','g'+80H,C$OF
       DB 'keys',0

       DB 24
       DB 'garde','n'+80H
       DB 'shears',0

       DB 25,'a'+80H
       DB 'han','d'+80H
       DB 'saw',0

       DB 26,'a'+80H,C$LARG
       DB 'blac','k'+80H
       DB 'raven',0

       DB 27,'a'+80H
       DB 'cla','w'+80H
       DB 'hammer',0

       DB 28
       DB 'woode','n'+80H
       DB 'boards',0

       DB 29
       DB 'nails',0

       DB 30,'a'+80H
       DB 'loc','k'+80H,C$OF
       DB 'hair',0

       DB 31,'a'+80H
       DB 'whit','e'+80H
       DB 'sheet',0

       DB 32
       DB 'salt',0

       DB 33,'a'+80H
       DB 'shovel',0

       DB 34,'a'+80H
       DB 'blac','k'+80H
       DB 'feather',0

       DB 35,'a'+80H
       DB 'handwritte','n'+80H
       DB 'message',0

       DB 38
       DB 'ashes',0

       DB 95
       DB 'hoode','d'+80H
       DB 'figures',0

       DB 96,0FFH,113,0

       DB 97,0FFH,9,0

       DB 98,'a'+80H
       DB 'statu','e'+80H
       DB C$OF,'a'+80H
       DB 'youn','g'+80H
       DB 'woman',0

       DB 99,'a'+80H
       DB 'sleepin','g'+80H
       DB 'ol','d'+80H
       DB 'man',0

       DB 100,'a'+80H
       DB 'secre','t'+80H
       DB 'passage',0

       DB 101
       DB 'pin','e'+80H
       DB 'trees',0

       DB 102,'a'+80H
       DB 'doorway',0

       DB 103,'a'+80H
       DB 'boarde','d'+80H,'u','p'+80H
       DB 'doorway',0

       DB 104,'a'+80H
       DB 'skeleton',0

       DB 105,'a'+80H
       DB 'bronz','e'+80H
       DB 'plaque',0

       DB 106
       DB 'bookcases',0

       DB 107,'a'+80H
       DB 'handcrafte','d'+80H
       DB 'altar',0

       DB 109,'a'+80H
       DB 'cabi','n'+80H
       DB C$IN,C$THE
       DB 'distance',0

       DB 110,'a'+80H
       DB 'cabin',0

       DB 111,C$AN
       DB 'ope','n'+80H
       DB 'coffin',0

       DB 112,'a'+80H
       DB 'coffin',0

       DB 113,C$LARG
       DB 'ston','e'+80H
       DB 'step','s'+80H
       DB 'leadin','g'+80H
       DB C$TO,'a'+80H
       DB 'doorway',0

       DB 114,C$AN
       DB 'ol','d'+80H
       DB 'vent',0

       DB 115,'a'+80H
       DB 'grump','y'+80H
       DB 'ol','d'+80H
       DB 'man',0

       DB 116,'a'+80H
       DB 'lectern',0

       DB 117,'a'+80H,C$LARG
       DB 'circl','e'+80H
       DB 'o','n'+80H,C$THE
       DB 'floor',0

       DB 118
       DB 'ston','e'+80H
       DB 'statues',0

       DB 119,0FFH,120,0

       DB 120,'a'+80H
       DB 'bi','g'+80H
       DB 'manua','l'+80H
       DB 'pip','e'+80H
       DB 'organ',0

       DB 121,'a'+80H
       DB 'ful','l'+80H
       DB 'lengt','h'+80H
       DB 'mirror',0

       DB 122,'a'+80H
       DB 'close','t'+80H
       DB 'doorway',0

       DB 123,'a'+80H
       DB 'bed',0

       DB 124,'a'+80H
       DB 'fligh','t'+80H,C$OF
       DB 'stairs',0

       DB 125,'a'+80H
       DB 'fireplace',0

       DB 126,'a'+80H,C$LARG
       DB 'woode','n'+80H
       DB 'door',0

       DB 127,0FFH,126,0

;******************************
;
; ROOM DESCRIPTIONS TABLE
;
;******************************

DESCTB EQU $
;ROOM 1
       DB C$IM,C$IN
       DB 'rugge','d'+80H
       DB 'mountai','n'+80H
       DB 'country','.'+80H
       DB 'Sno','w'+80H,C$IS
       DB 'falling.',0
;ROOM 2
       DB 0FFH,1,0
;ROOM 3
       DB 0FFH,1,0
;ROOM 4
       DB C$IM
       DB 'outsid','e'+80H,'a'+80H
       DB 'rustri','c'+80H
       DB 'mountai','n'+80H
       DB 'cabin','.'+80H
       DB 'Sno','w'+80H,C$IS
       DB 'falling.',0
;ROOM 5
       DB C$IM,C$IN,C$THE
       DB 'livin','g'+80H
       DB 'roo','m'+80H
       DB C$OF,'a'+80H
       DB 'mountai','n'+80H
       DB 'cabin.',0
;ROOM 6
       DB C$IM,C$INA
       DB 'diml','y'+80H,'li','t'+80H
       DB 'bedroom.',0
;ROOM 7
       DB C$IM,C$INA,C$LARG
       DB 'close','t'+80H
       DB 'use','d'+80H,'fo','r'+80H
       DB 'clothe','s'+80H
       DB 'storage.',0
;ROOM 8
       DB C$IM,C$INA
       DB 'lon','g'+80H
       DB 'narro','w'+80H
       DB 'corridor.',0
;ROOM 9
       DB 0FFH,8,0
;ROOM 10
       DB C$IM,C$IN,C$AN
       DB 'impressiv','e'+80H
       DB 'roo','m'+80H
       DB 'wit','h'+80H,'a'+80H
       DB 'cathedra','l'+80H
       DB 'ceiling.',0
;ROOM 11
       DB C$IM,C$INA
       DB 'ver','y'+80H
       DB 'strang','e'+80H
       DB 'room.',0
;ROOM 12
       DB C$IM,C$IN,C$AN
       DB 'arche','d'+80H
       DB 'passag','e'+80H
       DB 'unde','r'+80H,C$THE
       DB 'monastery.',0
;ROOM 13
       DB C$IM,C$IN,C$AN
       DB 'undergroun','d'+80H
       DB 'crypt.',0
;ROOM 14
       DB 0FFH,8,0
;ROOM 15
       DB C$IM,C$INA,C$SMAL
       DB 'room.',0
;ROOM 16
       DB 0FFH,8,0
;ROOM 17
       DB C$IM,C$AT,C$THE
       DB 'en','d'+80H
       DB C$OF,'a'+80H
       DB 'lon','g'+80H
       DB 'narro','w'+80H
       DB 'corridor.',0
;ROOM 18
       DB C$IM,C$INA
       DB 'lof','t'+80H,C$AT,C$THE
       DB 'to','p'+80H
       DB C$OF,C$THE
       DB 'stairs.',0
;ROOM 19
       DB 0FFH,8,0
;ROOM 20
       DB C$IM,C$IN,C$AN
       DB 'ol','d'+80H
       DB 'study.',0
;ROOM 21
       DB 0FFH,8,0
;ROOM 22
       DB 0FFH,17,0
;ROOM 23
       DB C$IM,C$INA,C$SMAL
       DB 'alcove.',0
;ROOM 24
       DB C$IM,C$INA
       DB 'strang','e'+80H
       DB 'place','.'+80H,'M','y'+80H
       DB 'bod','y'+80H
       DB 'feel','s'+80H
       DB 'paralyzed.',0

;******************************
;
; COMPRESSED PHRASE TABLE
;
;******************************

TXTTAB EQU $
       DB 'th','e'+80H,0
       DB 'smal','l'+80H,0
       DB 'ar','e'+80H,0
       DB 'se','e'+80H,0
       DB 'can',QUOTE,'t'+80H,0
       DB 'don',QUOTE,'t'+80H,0
       DB 'larg','e'+80H,0
       DB 'I',QUOTE,'m'+80H,0
       DB 'i','n'+80H,'a'+80H,0
       DB 'o','n'+80H,'a'+80H,0
       DB 'i','s'+80H,'a'+80H,0
       DB 'It',QUOTE,'s'+80H,0
       DB 'Th','e'+80H,0
       DB 'i','s'+80H,0
       DB 'an','d'+80H,0
       DB 'a','n'+80H,0
       DB 'a','t'+80H,0
       DB 'o','f'+80H,0
       DB 'I','t'+80H,'Says:',13,0
       DB 'FILL',0
       DB 't','o'+80H,0
       DB 'm','y'+80H,0
       DB 'i','n'+80H,0

;******************************
;
; VERB ROUTINE JUMP VECTORS
;
;******************************

RTNTAB EQU $
       DW VLOOK,VINVE,VGET,VPUT
       DW VNORTH,VSOUTH,VEAST,VWEST
       DW VUP,VDOWN,VGO,BADINP
       DW VSAVE,VLOAD,VHELP,VSCORE
       DW ENDGAM,BADINP,BADINP
       DW BADINP,VPLAY,BADINP
       DW VUNLOK,VBREAK,VBUILD
       DW VPULL,VHEAR,VCUT,VLIGHT
       DW VUNLIT,BADINP,BADINP
       DW BADINP,VTASTE,BADINP
       DW VDIG,VINVOK

;******************************
;
; ASSORTED TEXT MESSAGES
;
;******************************

MSG000 DB 13,13,'OK',','+80H,0

MSG001 DB 13,13
       DB 'Obviou','s'+80H
       DB 'directions',':'+80H
       DB 0

MSG002 DB 13,13
       DB 'I'+80H,C$SEE,8,':'+80H,0

MSG003 DB 13
       DB 'I'+80H
       DB C$SEE
       DB 'n','o'+80H
       DB 'wa','y'+80H
       DB C$TO,'g','o'+80H
       DB C$IN
       DB 'tha','t'+80H
       DB 'direction.'
       DB 0

MSG004 DB 13
       DB 'I'+80H,C$DONT
       DB 'understan','d'+80H,'"'
       DB 0

MSG005 DB 13,'I'+80H,'a','m'+80H
       DB 'carryin','g'+80H
       DB C$THE
       DB 'following:',13,0

MSG006 DB 13
       DB 'nothing.',0

MSG007 DB 13,'I'+80H,C$DONT
       DB C$SEE,0

MSG008 DB 13
       DB C$IM
       DB 'carryin','g'+80H,0

MSG009 DB 13,'I'+80H,C$CANT
       DB 'carr','y'+80H
       DB 'anymore.',0

MSG010 DB 13
       DB 'I'+80H,C$DONT
       DB 'hav','e'+80H,0

MSG011 DB 13
       DB 'Hey',','+80H,'I'+80H
       DB 'foun','d'+80H
       DB 'something!',0

MSG012 DB 13,'I'+80H,C$SEE
       DB 'nothin','g'+80H
       DB 'special.',0

MSG013 DB 13,C$IM,'o','n'+80H
       DB 'it!',0

MSG014 DB 13,C$IM,C$IN
       DB 'it!',0

MSG015 DB 13,C$IITS
       DB 'beyon','d'+80H,C$MY
       DB 'powe','r'+80H
       DB C$TO,'d','o'+80H
       DB 'that.',0

MSG016 DB 13,C$IITS
       DB 'closed.',0

MSG017 DB 13,C$IITS
       DB 'locked.',0

MSG018 DB 13,C$IITS
       DB 'open.',0

MSG019 DB 13,C$IITS
       DB 'unlocked.',0

MSG020 DB 13
       DB 'Won',QUOTE,'t'+80H
       DB 'budge.',0

MSG021 DB 13
       DB 'Doesn',QUOTE,'t'+80H
       DB 'work.',0

MSG022 DB 13,C$IITS
       DB 'empty.',0

MSG023 DB 13,'I'+80H,C$CANT
       DB 'd','o'+80H
       DB 'tha','t'+80H
       DB '..','.'+80H
       DB 'now!',0

MSG024 DB 13
       IF R$PNTS
MSG024B DB '00000 '
       DB C$OF,'1'+80H
       DB 'treasur','e'+80H
       DB 'scored',13
       ENDIF
MSG024A DB '00000'
       DB ' move','s'+80H
       DB 'used.',0

MSG025 DB 13,13
       DB 'Thi','s'+80H
       DB 'Adventur','e'+80H
       DB C$IS
       DB 'over.',13
       IF R$PNTS
MSG025B DB '00000'
       DB ' ',C$OF,'1'+80H
       DB 'treasur','e'+80H
       DB 'scored',13
       ENDIF
MSG025A DB '00000'
       DB ' move','s'+80H
       DB 'wer','e'+80H
       DB 'used.',13,13
       DB 'Pla','y'+80H
       DB 'agai','n'+80H
       DB '(Y/N)','?'+80H,0

MSG026 DB 13
       DB 'Don',QUOTE,'t'+80H,'b','e'+80H
       DB 'ridiculous.',0

MSG027 DB 13
       DB 'Congratulations',','+80H
       DB 'you',QUOTE,'v','e'+80H
       DB 'destroye','d'+80H
       DB 'them.',0

MSG028 DB 13
       DB 'Sorry',','+80H,'I'+80H
       DB C$CANT,'d','o'+80H
       DB 'tha','t'+80H,'-'+80H,0

MSG029 DB 13,'I','t'+80H
       DB 'look','s'+80H
       DB 'interestin','g'+80H
       DB 'alright!',0

MSG030 DB 13,'I'+80H
       DB 'hav','e'+80H,'n','o'+80H
       DB 'wa','y'+80H
       DB C$TO,'d','o'+80H
       DB 'that.',0

MSG031 DB 13,C$IITS
       DB 'lit.',0

MSG032 DB 13,C$IITS
       DB 'off.',0

MSG033 DB 13,13
       DB 'Ligh','t'+80H
       DB 'run','s'+80H
       DB 'ou','t'+80H,C$IN
MSG033A DB '00'
       DB ' move(s).',0

MSG034 DB 13,C$IITS
       DB 'dangerou','s'+80H
       DB C$TO
       DB 'mov','e'+80H
       DB 'aroun','d'+80H
       DB C$IN,C$THE
       DB 'dark!',0

MSG035 DB 13,'I'+80H
       DB 'fel','l'+80H
       DB 'dow','n'+80H,C$AND
       DB 'cracke','d'+80H,C$MY
       DB 'head','.'+80H,C$IM
       DB 'dead!',0

MSG036 DB 13
       DB 'Wheeeee...',0

MSG037 DB 13,C$IITS
       DB 'blockin','g'+80H,C$THE
       DB 'door.',0

MSG038 DB 13,'I','t'+80H
       DB 'look','s'+80H
       DB 'lik','e'+80H,C$AN
       DB 'antique.',0

MSG039 DB 13,C$IITS
       DB 'mad','e'+80H,C$OF
       DB C$LARG
       DB 'stone','s'+80H
       DB 'wit','h'+80H,'a'+80H
       DB 'woode','n'+80H
       DB 'mantle.',0

MSG040 DB 13,C$TTHE
       DB 'doo','r'+80H,C$IS
       DB 'naile','d'+80H
       DB 'shu','t'+80H
       DB 'fro','m'+80H,C$THE
       DB 'othe','r'+80H
       DB 'side.',0

MSG041 DB 13
       DB 'Ther','e'+80H,C$ARE
       DB 'woode','n'+80H
       DB 'board','s'+80H
       DB 'naile','d'+80H
       DB 'acros','s'+80H
       DB 'it.',0

MSG042 DB 13,C$IITS
       DB 'eerie..','.'+80H
       DB 'They',QUOTE,'r','e'+80H,'s','o'+80H
       DB 'lifelike.',0

MSG043 DB 13
       DB 'There',QUOTE,'s'+80H,C$AN
       DB 'inverte','d'+80H
       DB 'pentacl','e'+80H
       DB 'o','n'+80H,C$THE
       DB 'fron','t'+80H
       DB C$OF,'it','.'+80H
       DB 'Ther','e'+80H
       DB 'appear','s'+80H
       DB C$TO,'b','e'+80H,C$AN
       DB 'openin','g'+80H
       DB 'behin','d'+80H
       DB 'it.',0

MSG044 DB 13,'I','t'+80H
       DB 'look','s'+80H
       DB 'lik','e'+80H,'a'+80H
       DB C$LARG
       DB 'ai','r'+80H
       DB 'vent.',0

MSG045 DB 13,'A'+80H
       DB 'lo','t'+80H,C$OF
       DB C$THE
       DB 'writin','g'+80H
       DB 'ha','s'+80H
       DB 'faded','.'+80H
       DB 'Here',QUOTE,'s'+80H,C$AN
       DB 'interestin','g'+80H
       DB 'entry',':'+80H
       DB '"Jun','e'+80H,'8',','+80H
       DB '178','1'+80H,'-'+80H
       DB C$TTHE
       DB 'bisho','p'+80H
       DB 'ha','s'+80H
       DB 'succumbe','d'+80H
       DB C$TO,C$THE
       DB 'plague','.'+80H,'H','e'+80H
       DB 'ha','s'+80H
       DB 'bee','n'+80H
       DB 'lai','d'+80H,C$TO
       DB 'res','t'+80H
       DB C$IN,C$THE
       DB 'cryp','t'+80H,C$AND,C$THE
       DB 'brother','s'+80H
       DB 'hav','e'+80H
       DB 'electe','d'+80H,C$TO
       DB 'clos','e'+80H,C$THE
       DB 'monastery".',0

MSG046 DB 13
       DB 'There',QUOTE,'s'+80H,'a'+80H
       DB 'strang','e'+80H
       DB 'lookin','g'+80H
       DB 'emble','m'+80H
       DB 'o','n'+80H,C$THE
       DB 'sleeve.',0

MSG047 DB 13
       DB 'St','.'+80H
       DB 'Sebastia','n'+80H
       DB 'Monastery',','+80H
       DB '1739',0

MSG048 DB 13,C$IITS,C$AN
       DB 'inverte','d'+80H
       DB 'pentacle.',0

MSG049 DB 13
       DB 'She',QUOTE,'s'+80H
       DB 'quit','e'+80H
       DB 'prett','y'+80H
       DB 'wit','h'+80H
       DB 'lon','g'+80H
       DB 'dar','k'+80H
       DB 'hair','.'+80H
       DB 'Sh','e'+80H
       DB 'appear','s'+80H
       DB C$TO,'b','e'+80H,C$INA
       DB 'trance','.'+80H,0

MSG050 DB 'There',QUOTE,'s'+80H,'a'+80H
       DB 'not','e'+80H
       DB 'clutche','d'+80H,C$IN
       DB 'he','r'+80H
       DB 'hand.',0

MSG051 DB 13,C$IITS
       DB 'quee','n'+80H
       DB 'siz','e'+80H
       DB 'wit','h'+80H
       DB 'whit','e'+80H
       DB 'sheets.',0

MSG052 DB 13,'I','t'+80H
       DB 'says:',13
       DB 'They',QUOTE,'r','e'+80H
       DB 'afte','r'+80H
       DB 'me','.'+80H
       DB 'Remembe','r'+80H
       DB '"Invocar','e'+80H
       DB 'Episcopus".',0

MSG053 DB 13
       DB 'There',QUOTE,'s'+80H
       DB 're','d'+80H
       DB 'win','e'+80H
       DB C$IN
       DB 'it.',0

MSG054 DB 13
       DB 'There',QUOTE,'s'+80H
       DB 'sno','w'+80H
       DB C$IN
       DB 'it.',0

MSG055 DB 13
       DB 'There',QUOTE,'s'+80H
       DB 'wate','r'+80H,C$IN
       DB 'it.',0

MSG056 DB 13,13,C$TTHE
       DB 'sno','w'+80H
       DB 'melt','s'+80H,C$AND
       DB 'get','s'+80H,'m','e'+80H
       DB 'al','l'+80H
       DB 'wet','.'+80H,'I'+80H
       DB 'nee','d'+80H,'a'+80H
       DB 'container.',0

MSG057 DB 13,13,C$TTHE
       DB 'sno','w'+80H
       DB 'melt','s'+80H,C$AND
       DB 'fill','s'+80H,C$THE
       DB 'ju','g'+80H
       DB 'wit','h'+80H
       DB 'water.',0

MSG058 DB 13,13,C$IITS
       DB 'gettin','g'+80H
       DB 'col','d'+80H,C$IN
       DB 'here',','+80H
       DB 'mayb','e'+80H,'I'+80H
       DB 'shoul','d'+80H
       DB 'clos','e'+80H,C$THE
       DB 'door.',0

MSG059 DB 13,C$IITS,'a'+80H
       DB 'Bac','h'+80H
       DB 'fugue.',0

MSG060 DB 13
       DB 'Dee','p'+80H
       DB 'sno','w'+80H
       DB 'block','s'+80H,C$THE
       DB 'door.',0

MSG061 DB 13,C$TTHE
       DB 'rave','n'+80H
       DB 'squawk','s'+80H,C$AND
       DB 'flie','s'+80H
       DB 'away.',0

MSG062 DB 13,C$TTHE
       DB 'ol','d'+80H
       DB 'ma','n'+80H
       DB 'won',QUOTE,'t'+80H
       DB 'le','t'+80H,'me.',13
       DB 'H','e'+80H
       DB 'says',':'+80H
       DB '"',C$IM,C$THE
       DB 'caretaker',','+80H
       DB 'yo','u'+80H
       DB 'bette','r'+80H
       DB 'leave','.'+80H
       DB 'The','y'+80H
       DB 'won',QUOTE,'t'+80H
       DB 'lik','e'+80H
       DB 'strangers."',0

MSG063 DB 13,C$TTHE
       DB 'ol','d'+80H
       DB 'ma','n'+80H
       DB 'grab','s'+80H,C$THE
       DB 'win','e'+80H,C$AND
       DB 'shuffle','s'+80H
       DB 'dow','n'+80H,C$THE
       DB 'stairs.',0

MSG064 DB 13
       DB 'Wha','t'+80H
       DB 'shoul','d'+80H,'I'+80H
       DB 'play?',0

MSG065 DB 13,'I'+80H
       DB 'hav','e'+80H,'n','o'+80H
       DB 'keys!',0

MSG066 DB 13,'I'+80H
       DB 'hav','e'+80H,'n','o'+80H
       DB 'shee','t'+80H
       DB 'music.',0

MSG067 DB 13,'I','t'+80H
       DB 'make','s'+80H,'a'+80H
       DB 'magnifican','t'+80H
       DB 'sound','.'+80H
       DB 'Hey',','+80H,C$THE
       DB 'orga','n'+80H
       DB 'moved.',0

MSG068 DB 13,C$IITS
       DB 'he','r'+80H
       DB 'alright.',0

MSG069 DB 13,'I'+80H
       DB 'hav','e'+80H
       DB 'nothin','g'+80H,C$TO
       DB 'cu','t'+80H,'i','t'+80H
       DB 'with.',0

MSG070 DB 13,'I'+80H,C$DONT
       DB 'wan','t'+80H,C$TO
       DB 'rui','n'+80H
       DB 'he','r'+80H
       DB 'hair.',0

MSG071 DB 0CH,C$TTHE
       DB 'bisho','p'+80H
       DB 'appear','s'+80H,C$AND
       DB 'says',':'+80H
       DB '"Yo','u'+80H
       DB 'hav','e'+80H
       DB 'don','e'+80H
       DB 'well.','"'+80H
       DB 'H','e'+80H
       DB 'sprinkle','s'+80H
       DB 'wate','r'+80H
       DB 'o','n'+80H,C$THE
       DB 'altar',','+80H
       DB 'extend','s'+80H
       DB 'hi','s'+80H
       DB 'arm','s'+80H,C$AND,C$THE
       DB 'alta','r'+80H
       DB 'burn','s'+80H,C$AND
       DB 'turn','s'+80H,C$TO
       DB 'ash.',13
       DB '"Thro','w'+80H
       DB 'thi','s'+80H
       DB 'sanctifie','d'+80H
       DB 'as','h'+80H,C$IN
       DB 'thei','r'+80H
       DB 'evi','l'+80H
       DB 'circl','e'+80H,C$AND
       DB 'immediatel','y'+80H
       DB 'invok','e'+80H,C$MY
       DB 'presenc','e'+80H,C$TO
       DB 'protec','t'+80H
       DB 'yo','u'+80H
       DB 'fro','m'+80H,C$THE
       DB 'devil',QUOTE,'s'+80H
       DB 'wrath.','"'+80H,C$TTHE
       DB 'apparitio','n'+80H
       DB 'the','n'+80H
       DB 'disappears.',0

MSG072 DB 13,13,'A'+80H
       DB 'strang','e'+80H
       DB 'voic','e'+80H
       DB 'call','s'+80H,C$MY
       DB 'name.',0

MSG073 DB 0CH,C$TTHE
       DB 'imag','e'+80H
       DB C$OF,'a'+80H
       DB 'figur','e'+80H,C$IN
       DB 'whit','e'+80H
       DB 'vestment','s'+80H
       DB 'appear','s'+80H,C$AND
       DB 'says',':'+80H
       DB '"Yo','u'+80H
       DB 'mus','t'+80H
       DB 'exorcis','e'+80H,C$THE
       DB 'evi','l'+80H
       DB 'tha','t'+80H
       DB 'no','w'+80H
       DB 'lurk','s'+80H
       DB 'here','.'+80H,'I'+80H
       DB 'wil','l'+80H
       DB 'hel','p'+80H
       DB 'yo','u'+80H
       DB 'tur','n'+80H,C$THE
       DB 'devil',QUOTE,'s'+80H
       DB 'powe','r'+80H
       DB 'agains','t'+80H
       DB 'hi','s'+80H
       DB 'disciples','.'+80H
       DB 'Yo','u'+80H
       DB 'wil','l'+80H
       DB 'nee','d'+80H,C$AN
       DB 'alta','r'+80H
       DB 'crafte','d'+80H,'b','y'+80H
       DB 'you','r'+80H
       DB 'ow','n'+80H
       DB 'hand',','+80H,'a'+80H
       DB 'whit','e'+80H
       DB 'clot','h'+80H,C$TO
       DB 'cove','r'+80H,'it',','+80H
       DB 'pur','e'+80H
       DB 'wate','r'+80H,C$TO
       DB 'consecrat','e'+80H
       DB 'it',','+80H
       DB 'pin','e'+80H
       DB 'needles',','+80H,'a'+80H
       DB 'loc','k'+80H
       DB C$OF,'a'+80H
       DB 'maiden',QUOTE,'s'+80H
       DB 'hair',','+80H,'a'+80H
       DB 'blac','k'+80H
       DB 'feather',','+80H,C$AND
       DB 'salt','.'+80H
       DB 'Retur','n'+80H
       DB 'wit','h'+80H
       DB 'thes','e'+80H
       DB 'thing','s'+80H,C$AND,'I'+80H
       DB 'wil','l'+80H,'b','e'+80H
       DB 'here.','"'+80H,C$TTHE
       DB 'apparitio','n'+80H
       DB 'the','n'+80H
       DB 'disappears.',0

MSG074 DB 13,'I'+80H,C$DONT
       DB 'hea','r'+80H
       DB 'anythin','g'+80H
       DB 'now.',0

MSG075 DB 13,'I'+80H
       DB 'hav','e'+80H,'n','o'+80H
       DB 'matches.',0

MSG076 DB 13
       DB 'They',QUOTE,'r','e'+80H
       DB 'naile','d'+80H,C$IN
       DB 'place.',0

MSG077 DB 13,'I'+80H,C$CANT
       DB 'd','o'+80H
       DB 'tha','t'+80H
       DB 'here.',0

MSG078 DB 'Somethin','g'+80H
       DB C$IS
       DB 'missing.',0

MSG079 DB 13
       DB 'Everythin','g'+80H
       DB 'spin','s'+80H
       DB 'aroun','d'+80H,C$AND
       DB 'suddenl','y'+80H,C$IM
       DB 'elsewhere.',0

MSG080 DB 13
       DB 'Nothin','g'+80H
       DB 'happens.',0

MSG081 DB 13,'I'+80H
       DB 'thin','k'+80H
       DB 'it',QUOTE,'s'+80H,C$THE
       DB 'bishop.',0

MSG082 DB 13
       DB 'Gulp...','I'+80H
       DB 'foun','d'+80H,'a'+80H
       DB 'skeleto','n'+80H
       DB 'dresse','d'+80H,C$IN
       DB 'ministeria','l'+80H
       DB 'robes.',0

MSG083 DB 13
       DB 'Somethin','g'+80H
       DB 'won',QUOTE,'t'+80H
       DB 'fit.',0

MSG084 DB 13,C$IITS
       DB 'no','w'+80H
       DB 'pitc','h'+80H
       DB 'black','.'+80H
       DB 'I'+80H,C$CANT,C$SEE
       DB 'anything.',13,0

MSG085 DB 13,'N','o'+80H
       DB 'way','!'+80H,'I'+80H
       DB 'won',QUOTE,'t'+80H,'g','o'+80H
       DB 'nea','r'+80H
       DB 'it.',0

MSG086 DB 13,13,'A'+80H
       DB 'ra','t'+80H
       DB 'scurrie','s'+80H
       DB 'pas','t'+80H,C$MY
       DB 'feet.',0

MSG087 DB 13,13,'I'+80H
       DB 'hea','r'+80H
       DB 'chanting.',0

MSG088 DB 13,13,'A'+80H
       DB 'figur','e'+80H,C$INA
       DB 'blac','k'+80H
       DB 'rob','e'+80H,C$IS
       DB 'approaching','.'+80H
       DB 'H','e'+80H
       DB 'nod','s'+80H,C$AND
       DB 'continue','s'+80H,'o','n'+80H
       DB 'hi','s'+80H
       DB 'way.',0

MSG089 DB 13,'A'+80H
       DB 'figur','e'+80H,C$INA
       DB 'blac','k'+80H
       DB 'rob','e'+80H
       DB 'approaches','.'+80H
       DB 'H','e'+80H
       DB 'spot','s'+80H,'me',','+80H
       DB 'raise','s'+80H
       DB 'hi','s'+80H
       DB 'arm','s'+80H,C$AND
       DB 'begin','s'+80H,C$TO
       DB 'chant','.'+80H
       DB 'M','y'+80H
       DB 'bod','y'+80H
       DB 'feel','s'+80H
       DB 'paralyzed!',0

MSG090 DB 13,'I','t'+80H
       DB 'look','s'+80H
       DB 'like...I','t'+80H
       DB 'is','!'+80H,C$IITS
       DB 'mad','e'+80H,C$OF
       DB 'salt.',0

MSG091 DB 13,'I','t'+80H
       DB 'taste','s'+80H
       DB 'lik','e'+80H
       DB 'burgandy.',0

MSG092 DB 13,'I','t'+80H
       DB 'taste','s'+80H
       DB 'lik','e'+80H
       DB 'salt.',0

MSG093 DB 13
       DB 'The','y'+80H
       DB 'lea','d'+80H
       DB C$TO,'a'+80H
       DB 'doorway.',0

MSG094 DB 13,C$IITS,C$AN
       DB 'ol','d'+80H
       DB 'Praetoriu','s'+80H
       DB 'wit','h'+80H,'3','2'+80H
       DB 'stops.',0

MSG095 DB 13,'I'+80H
       DB 'hav','e'+80H,'n','o'+80H
       DB 'shovel.',0

MSG096 DB 13
       DB 'Boy',','+80H
       DB 'tha','t'+80H
       DB 'wa','s'+80H
       DB 'har','d'+80H
       DB 'work!',0

MSG097 DB 13
       DB 'Dee','p'+80H
       DB 'sno','w'+80H,C$IS
       DB 'blockin','g'+80H,C$THE
       DB 'door.',0

MSG098 DB 13,C$TTHE
       DB 'hoode','d'+80H
       DB 'figure','s'+80H
       DB 'glar','e'+80H
       DB C$AT,'me','.'+80H
       DB 'The','y'+80H
       DB 'pul','l'+80H
       DB 'm','e'+80H,C$TO
       DB 'thei','r'+80H
       DB 'circl','e'+80H,C$AND
       DB 'begi','n'+80H,C$TO
       DB 'chant','.'+80H
       DB 'I',QUOTE,'v','e'+80H
       DB 'bee','n'+80H
       DB 'turne','d'+80H,C$TO
       DB 'stone!',13,0

MSG099 DB 13,C$TTHE
       DB 'buildin','g'+80H
       DB 'tremble','s'+80H,C$AND
       DB 'unearthl','y'+80H
       DB 'shriek','s'+80H
       DB 'fil','l'+80H,C$THE
       DB 'room','.'+80H,'A'+80H
       DB 'hideou','s'+80H
       DB 'demo','n'+80H
       DB 'appear','s'+80H
       DB C$IN,C$THE
       DB 'circl','e'+80H
       DB 'a','s'+80H,'i','t'+80H
       DB 'burst','s'+80H
       DB 'in',C$TO
       DB 'flames.',0

;
;        END FILE: ADVDATA2.ASM
;
