
;        FILE: ADVCODE2.ASM         LAST MODIFIED: 10/19/84
;              BLACK SANCTUM

;        LOOK CABIN

LOOK01   PROC
         MOV   AL,ROOM
         CMP   AL,1
         JE    LOOK01_A
         CMP   AL,4
         JB    LOOK01_B
         CMP   AL,7
         JA    LOOK01_B
LOOK01_A:
         JMP   DMSG012
LOOK01_B:
         JMP   NOSEE
LOOK01   ENDP

;        LOOK SNOW

LOOK02   PROC
         CMP   ROOM,5
         LBLO  DMSG012
         JNE   LOOK02_A
         MOV   AL,127             ;OPEN DOOR
         CALL  CKOBJ
         JE    LOOK02_A
         TEST  SNOWSW,0FFH        ;SNOW BLOCKING DOOR?
         LBNE  DMSG037
LOOK02_A:
         JMP   NOSEE
LOOK02   ENDP

;        LOOK MANTLE

LOOK03   PROC
         MOV   AL,16+INV          ;MATCHES
         CALL  MAKVIS
         JNE   LOOK03_A
         MOV   AL,125             ;FIREPLACE
         CALL  CKOBJ
         LBNE  DMSG012
         JMP   NOSEE
LOOK03_A:
         CALL  CKDRAW
         JMP   DMSG011
LOOK03   ENDP

;        LOOK OPENING/VENT

LOOK04   PROC
         MOV   AL,ROOM
         CMP   AL,11
         JE    LOOK04_A
         CMP   AL,12
         LBNE  NOSEE
LOOK04_A:
         JMP   DMSG044
LOOK04   ENDP

;        LOOK BOOKCASES

LOOK05   PROC
         CMP   ROOM,20
         LBNE  NOSEE
         MOV   AL,19+INV          ;MANUSCRIPT
         CALL  MAKVIS
         JNE   LOOK05_A
         MOV   AL,20+INV          ;PARCHMENT
         CALL  MAKVIS
         LBEQ  DMSG012
LOOK05_A:
         CALL  CKDRAW
         JMP   DMSG011
LOOK05   ENDP

;        LOOK DOOR

LOOK06   PROC
         MOV   AL,103             ;BOARDED UP DOOR
         CALL  CKOBJ
         LBNE  DMSG041
         MOV   AL,ROOM
         CMP   AL,12
         JE    LOOK06_B
         CMP   AL,23
         JE    LOOK06_A
         CMP   AL,10
         JE    LOOK06_A
         CMP   AL,6
         JE    LOOK06_A
         MOV   AL,127             ;OPEN DOOR
         CALL  CKOBJ
         JNE   LOOK06_A
         MOV   AL,126             ;CLOSED DOOR
         CALL  CKOBJ
         LBNE  DMSG016
         JMP   NOSEE
LOOK06_A:
         JMP   DMSG018
LOOK06_B:
         MOV   ROOM,23
         MOV   AL,103             ;BOARDED UP DOOR
         CALL  CKOBJ
         MOV   ROOM,12
         JE    LOOK06_A
         JMP   DMSG040
LOOK06   ENDP

;        LOOK EMBLEM

LOOK07   PROC
         MOV   AL,18              ;ROBE
         CALL  LOCOBJ
         LBEQ  NOSEE
         JMP   DMSG048
LOOK07   ENDP

;        LOOK HAIR

LOOK08   PROC
         MOV   AL,NOUNNO
         CALL  LOCOBJ
         JNE   LOOK08_A
         MOV   AL,17              ;WOMAN
         CALL  LOCOBJ
         JNE   LOOK09
LOOK08_A:
         JMP   LOOKOB
LOOK08   ENDP

;        LOOK WOMAN

LOOK09   PROC
         MOV   AL,17              ;WOMAN
         CALL  LOCOBJ
         LBEQ  NOSEE
         MOV   BX,OFFSET MSG049
         CALL  DISPLY
         TEST  NOTESW,0FFH
         LBEQ  DMSG050
         JMP   REPLY
LOOK09   ENDP

;        LOOK NEEDLES

LOOK11   PROC
         CMP   ROOM,4
         LBLO  DMSG012
         JMP   LOOKOB
LOOK11   ENDP

;        LOOK NOTE

LOOK12   PROC
         MOV   AL,35              ;NOTE
         CALL  HAVOBJ
         LBEQ  NOHAVE
         JMP   LOOKOB
LOOK12   ENDP

;        LOOK SKELETON

LOOK13   PROC
         MOV   AL,111             ;OPEN COFFIN
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG081
LOOK13   ENDP

;        LOOK SALT

LOOK14   PROC
         CMP   ROOM,11
         LBNE  LOOKOB
         JMP   DMSG012
LOOK14   ENDP

;        LOOK BOARDS/NAILS

LOOK15   PROC
         MOV   AL,103             ;BOARDED DOORWAY
         CALL  CKOBJ
         LBEQ  LOOKOB
         JMP   DMSG012
LOOK15   ENDP

;        GET SALT

GET01    PROC
         CMP   ROOM,11
         JNE   GET01_A
         MOV   AL,32              ;SALT
         CALL  LOCOBJ
         JNE   GET01_A
         MOV   AL,32              ;SALT
         CALL  FNDOBJ
         LBNE  DMSG023
         MOV   AL,32              ;SALT
         CALL  PUTNRM
GET01_A:
         JMP   VGET
GET01    ENDP

;        GET NOTE

GET02    PROC
         MOV   AL,NOUNNO
         CALL  LOCOBJ
         JNE   GET02_A
         TEST  NOTESW,0FFH
         JNE   GET02_A
         MOV   AL,17              ;WOMAN
         CALL  LOCOBJ
         JE    GET02_A
         INC   NOTESW
         MOV   AL,35              ;NOTE
         CALL  PUTNRM
GET02_A:
         JMP   VGET
GET02    ENDP

;        GET SNOW

GET03    PROC
         CMP   ROOM,5
         JA    GET03_E
         JE    GET03_D
GET03_A:
         TEST  SNO2SW,0FFH
         LBNE  DMSG023
         MOV   AL,9               ;SNOW
         CALL  HAVOBJ
         JNE   GET03_B
         MOV   AL,12              ;EMPTY JUG
         CALL  HAVOBJ
         JNE   GET03_C
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         LBHS  DMSG009
         MOV   AL,9               ;SNOW
         CALL  GIVOBJ
GET03_B:
         JMP   REPLY
GET03_C:
         MOV   AH,13              ;JUG OF SNOW
         CALL  REPOBJ
         INC   SNO2SW
         MOV   AL,17              ;WOMAN
         SUB   AH,AH
         CALL  XCHGOB
         MOV   AH,ROOM
         DISABLE
         MOV   ROOM,11
         MOV   AL,98              ;STATUE OF WOMAN
         CALL  PUTNRM
         MOV   ROOM,AH
         ENABLE
         JMP   SHORT GET03_B
GET03_D:
         MOV   AL,127             ;OPEN DOOR
         CALL  CKOBJ
         JNE   GET03_A
GET03_E:
         JMP   NOSEE
GET03    ENDP

;        GET NEEDLES

GET04    PROC
         MOV   AL,10              ;PINE NEEDLES
         CALL  LOCOBJ
         JNE   GET04_A
         CMP   ROOM,3
         JA    GET04_A
         TEST  NEEDSW,0FFH
         LBNE  DMSG023
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         LBHS  DMSG009
         MOV   AL,10              ;PINE NEEDLES
         CALL  GIVOBJ
         INC   NEEDSW
         JMP   REPLY
GET04_A:
         JMP   VGET
GET04    ENDP

;        GET SAW/SHEARS/KEYS

GET05    PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    GET05_A
         MOV   AL,115             ;OLD MAN IN LOFT
         CALL  CKOBJ
         LBNE  DMSG062
GET05_A:
         JMP   VGET
GET05    ENDP

;        GET FEATHER

GET07    PROC
         MOV   AL,NOUNNO
         CALL  LOCOBJ
         JNE   GET07_A
         MOV   AL,26              ;RAVEN
         CALL  HAVOBJ
         JE    GET07_B
         TEST  FEATSW,0FFH
         JNE   GET07_B
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         LBHS  DMSG009
         MOV   AL,34              ;FEATHER
         CALL  GIVOBJ
         INC   FEATSW
         JMP   REPLY
GET07_A:
         JMP   VGET
GET07_B:
         JMP   DMSG023
GET07    ENDP

;        GET RAVEN

GET08    PROC
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JE    GET08_A
         MOV   AL,15              ;NET
         CALL  HAVOBJ
         LBEQ  DMSG061
GET08_A:
         JMP   VGET
GET08    ENDP

;        GET SKELETON

GET09    PROC
         MOV   AL,111             ;OPEN COFFIN
         CALL  CKOBJ
         LBEQ  NOSEE
         JMP   DMSG085
GET09    ENDP

;        GET SHEET

GET10    PROC
         MOV   AL,31              ;SHEET
         CALL  FNDOBJ
         JNE   GET10_A
         MOV   AL,123             ;BED
         CALL  CKOBJ
         JE    GET10_A
         MOV   AL,31              ;SHEET
         CALL  PUTNRM
GET10_A:
         JMP   VGET
GET10    ENDP

;        GET HAIR

GET11    PROC
         MOV   AL,NOUNNO
         CALL  LOCOBJ
         JNE   GET11_A
         MOV   AL,17              ;WOMAN
         CALL  LOCOBJ
         LBNE  DMSG026
GET11_A:
         JMP   VGET
GET11    ENDP

;        GET MANTLE

GET12    PROC
         MOV   NOUNNO,125         ;FIREPLACE
         JMP   VGET
GET12    ENDP

;        PUT SNOW

PUT01    PROC
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         LBEQ  NOHAVE
         SUB   AH,AH
         CALL  REPOBJ
         JMP   REPLY
PUT01    ENDP

;        PUT ASH

PUT02    PROC
         MOV   AL,NOUNNO
         CALL  HAVOBJ
         JE    PUT02_A
         CMP   ROOM,11
         JNE   PUT02_A
         INC   VOICSW
PUT02_A:
         JMP   VPUT
PUT02    ENDP

;        GO CABIN

GO01     PROC
         MOV   AL,ROOM
         CMP   AL,1
         JNE   GO01_A
         MOV   AL,4
         JMP   EXITRM
GO01_A:
         CMP   AL,4
         JE    GO02               ;GO DOOR
         CMP   AL,5
         JE    GO01_B
         CMP   AL,6
         JE    GO01_B
         JMP   NOSEE
GO01_B:
         JMP   DMSG014
GO01     ENDP

;        GO DOOR

GO02     PROC
         MOV   AL,ROOM
         CMP   AL,4
         JE    GO02_A
         CMP   AL,5
         JNE   GO02_C
GO02_A:
         MOV   AL,126             ;CLOSED DOOR
         CALL  CKOBJ
         LBNE  DMSG016
         MOV   AL,97              ;SNOW BLOCKING DOOR
         CALL  CKOBJ
         LBNE  DMSG097
         MOV   AL,ROOM
         INC   AL
         CMP   AL,5
         JE    GO02_B
         MOV   AL,4
GO02_B:
         JMP   EXITRM
GO02_C:
         CMP   AL,9
         JE    GO02_D
         CMP   AL,10
         JNE   GO02_E
GO02_D:
         MOV   AL,126             ;CLOSED DOOR
         CALL  CKOBJ
         LBNE  DMSG017
         MOV   AL,ROOM
         INC   AL
         CMP   AL,10
         JE    GO02_B
         MOV   AL,9
         JMP   SHORT GO02_B
GO02_E:
         CMP   AL,12
         JNE   GO02_F
         MOV   AL,113             ;BOARDED UP DOORWAY
         CALL  CKOBJ
         LBNE  DMSG040
         MOV   AL,23
         JMP   SHORT GO02_B
GO02_F:
         CMP   AL,23
         JNE   GO02_G
         MOV   AL,103
         CALL  CKOBJ
         LBNE  DMSG041
         MOV   AL,12
         JMP   SHORT GO02_B
GO02_G:
         CMP   AL,6
         JE    GO02_H
         CMP   AL,7
         LBNE  NOSEE
GO02_H:
         MOV   AL,ROOM
         XOR   AL,1
         JMP   SHORT GO02_B
GO02     ENDP

;        GO CLOSET

GO03     PROC
         MOV   AL,ROOM
         CMP   AL,7
         LBEQ  DMSG014
         CMP   AL,6
         LBNE  NOSEE
         INC   AL
         JMP   EXITRM
GO03     ENDP

;        GO MIRROR

GO04     PROC
         MOV   AL,121             ;MIRROR
         CALL  CKOBJ
         LBEQ  NOSEE
;
;        START OF PROTECTION CHECK
;
         MOV   AL,PROTSW
         CMP   AL,VALIDSW
         LBNE  DMSG026
;
;        END OF PROTECTION CHECK
;
         DISABLE
         MOV   SI,OFFSET SCRBLU
         CALL  SHOSCR
         MOV   DL,32              ;# OF WORDS ACROSS SCREEN
         MOV   DH,45              ;# OF SCAN LINES DOWN SCREEN / 2
         CALCX 1,1                ;UPPER LEFT CORNER OF SCREEN
         MOV   SI,BX
         MOV   AX,WHITE@W         ;WORD OF ALL WHITE PIXELS
GO04_A:
         MOV   BX,SI              ;CURRENT LINE OFFSET
         MOV   CL,DL              ;CURRENT LINE LEN (WORDS)
GO04_B:
         MOV   GSCRN1@W [BX],AX   ;WHITE OUT EVEN/ODD PAIR
         MOV   GSCRN2@W [BX],AX
         CALL  GO04_E             ;DELAY ROUTINE
         INC   BX
         INC   BX
         DEC   CL
         JNZ   GO04_B
         DEC   DL                 ;LOWER LINE LEN COUNT
         JE    GO04_D             ;IF ALL DONE
         DEC   BX                 ;BACK UP TO LAST WORD
         DEC   BX
         MOV   CH,DH              ;# OF EVEN SCAN LINES LEFT
GO04_C:
         MOV   GSCRN1@W [BX],AX   ;WHITE OUT DOWN THE SCREEN
         MOV   GSCRN2@W [BX],AX
         CALL  GO04_E             ;DELAY ROUTINE
         ADD   BX,80              ;BUMP TO NEXT EVEN SCANLINE
         DEC   CH
         JNZ   GO04_C
         ADD   SI,80              ;NEXT EVEN SCANLINE FOR ACROSS
         DEC   DH                 ;LOWER SCANLINES LEFT
         JNZ   GO04_A
GO04_D:
         ENABLE
         MOV   AL,ROOM
         XOR   AL,0FH
         JMP   EXITRM
GO04_E:
         PUSH  CX
         MOV   CX,200
GO04_F:
         LOOP  GO04_F
         POP   CX
         RET
GO04     ENDP

;        GO STAIRS

GO05     PROC
         CMP   ROOM,12
         LBEQ  GO02
         MOV   AL,124             ;STAIRS
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         XOR   AL,3
         JMP   EXITRM
GO05     ENDP

;        GO OPENING/VENT

GO06     PROC
         MOV   AL,ROOM
         CMP   AL,11
         JB    GO06_A
         CMP   AL,12
         JA    GO06_A
         XOR   AL,7
         JMP   EXITRM
GO06_A:
         JMP   NOSEE
GO06     ENDP

;        GO PASSAGE

GO07     PROC
         MOV   AL,100             ;SECRET PASSAGE
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AL,ROOM
         XOR   AL,1
         JMP   EXITRM
GO07     ENDP

;        OPEN DOOR

OPEN01   PROC
         MOV   AL,ROOM
         CMP   AL,5
         JE    OPEN01_A
         CMP   AL,4
         JNE   OPEN01_C
;
;        START OF PROTECTION CHECK
;
         MOV   AL,PROTSW
         CMP   AL,VALIDSW
         JE    OPEN01_A
         SUB   AH,AH
         MOV   AL,18              ;HOODED ROBE
         CALL  XCHGOB
         MOV   AL,23              ;KEYS
         CALL  XCHGOB
         JMP   DMSG017
;
;        END OF PROTECTION CHECK
;
OPEN01_A:
         MOV   AL,126             ;CLOSED DOOR
         CALL  CKOBJ
         JE    OPEN01_B
         MOV   AH,127             ;OPEN DOOR
         CALL  CHGOBJ
         MOV   AH,ROOM
         CMP   AH,5
         JNE   OPEN01_F
         TEST  SNOWSW,0FFH
         JE    OPEN01_F
         MOV   AL,97              ;SNOW BLOCKING DOOR
         CALL  PUTNRM
OPEN01_F:
         CALL  CKDRAW
OPEN01_B:
         JMP   DMSG018
OPEN01_C:
         CMP   AL,10
         JE    OPEN01_B
         CMP   AL,12
         JE    OPEN01_D
         CMP   AL,23
         JNE   OPEN01_E
OPEN01_D:
         JMP   DMSG021
OPEN01_E:
         CMP   AL,9
         LBNE  NOSEE
         MOV   AL,127             ;OPEN DOOR
         CALL  CKOBJ
         LBEQ  DMSG017
         JMP   SHORT OPEN01_B
OPEN01   ENDP

;        OPEN COFFIN

OPEN02   PROC
         CMP   ROOM,13
         LBNE  NOSEE
         MOV   AL,112             ;CLOSED COFFIN
         CALL  CKOBJ
         LBEQ  DMSG018
         MOV   AH,111             ;OPEN COFFIN
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG082
OPEN02   ENDP

;        CLOSE DOOR

CLOS01   PROC
         MOV   AL,126             ;CLOSED DOOR
         CALL  CKOBJ
         JE    CLOS01_B
CLOS01_A:
         JMP   DMSG016
CLOS01_B:
         MOV   AL,ROOM
         CMP   AL,12
         JE    CLOS01_C
         CMP   AL,23
         JNE   CLOS01_D
CLOS01_C:
         JMP   DMSG020
CLOS01_D:
         CMP   AL,9
         JE    CLOS01_E
         CMP   AL,10
         JNE   CLOS01_F
CLOS01_E:
         JMP   DMSG020
CLOS01_F:
         MOV   AL,127             ;OPEN DOOR
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   AH,126             ;CLOSED DOOR
         CALL  CHGOBJ
         CMP   ROOM,5
         JNE   CLOS01_G
         MOV   AL,97              ;SNOW BLOCKING DOOR
         SUB   AH,AH
         CALL  CHGOBJ
CLOS01_G:
         MOV   AL,127             ;OPEN DOOR
         CALL  CKDRAW
         JMP   SHORT CLOS01_A
CLOS01   ENDP

;        UNLOCK VERB PROCESSOR

VUNLOK   PROC
         CMP   NOUNNO,127         ;DOOR
         LBNE  BADINP
         CMP   ROOM,9
         JNE   VUNLOK_A
         MOV   AL,126             ;CLOSED DOOR
         CALL  CKOBJ
         JE    VUNLOK_A
         MOV   AL,23              ;KEYS
         CALL  HAVOBJ
         LBEQ  DMSG065
         MOV   AL,126             ;CLOSED DOOR
         MOV   AH,127             ;OPEN DOOR
         CALL  CHGOBJ
         CALL  CKDRAW
         JMP   DMSG018
VUNLOK_A:
         JMP   DMSG023
VUNLOK   ENDP

;        TASTE VERB PROCESSOR

VTASTE   PROC
         MOV   AL,NOUNNO
         CMP   AL,32              ;SALT
         JE    VTASTE_A
         CMP   AL,11              ;WINE
         LBNE  BADINP
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,11
         LBNE  LOOKOB
         CALL  HAVOBJ
         JE    VTASTE_B
         JMP   DMSG091
VTASTE_A:
         CALL  HAVOBJ
         JE    VTASTE_B
         JMP   DMSG092
VTASTE_B:
         JMP   NOHAVE
VTASTE   ENDP

;        PLAY VERB PROCESSOR

VPLAY    PROC
         CMP   NOUNNO,120         ;ORGAN
         LBNE  BADINP
         CMP   ROOM,10
         LBNE  NOSEE
         JMP   DMSG064
VPLAY    ENDP

;        PLAY BACH

PLAY01   PROC
         CMP   ROOM,10
         LBNE  DMSG023
         MOV   AL,20              ;MUSIC
         CALL  HAVOBJ
         LBEQ  DMSG066
         MOV   AL,120             ;ORGAN W/NO PASSAGE
         CALL  CKOBJ
         JE    PLAY01_A
         MOV   AH,119             ;ORGAN WITH PASSAGE
         CALL  CHGOBJ
         MOV   AL,100             ;SECRET PASSAGE
         CALL  PUTNRM
         JMP   SHORT PLAY01_B
PLAY01_A:
         MOV   AL,119             ;OPEN ORGAN
         MOV   AH,120             ;CLOSED ORGAN
         CALL  CHGOBJ
         MOV   AL,100             ;SECRET PASSAGE
         SUB   AH,AH
         CALL  CHGOBJ
PLAY01_B:
         MOV   AL,120             ;ORGAN
         CALL  CKDRAW
         JMP   DMSG067
PLAY01   ENDP

;        PLAY MUSIC

PLAY02   PROC
         CMP   ROOM,10
         LBNE  DMSG023
         MOV   AL,20              ;MUSIC
         CALL  HAVOBJ
         LBEQ  DMSG066
         JMP   DMSG064
PLAY02   ENDP

;        UNLIGHT VERB PROCESSOR

VUNLIT   PROC
         MOV   AL,NOUNNO
         CMP   AL,21              ;LANTERN
         LBNE  BADINP
         CALL  HAVOBJ
         JNE   VUNLIT_A
         MOV   AL,22              ;LIT LANTERN
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AH,21              ;UNLIT LANTERN
         CALL  REPOBJ
         MOV   LITESW,0
         CALL  INDARK
VUNLIT_A:
         JMP   DMSG032
VUNLIT   ENDP

;        LIGHT VERB PROCESSOR

VLIGHT   PROC
         CMP   NOUNNO,21          ;LANTERN
         LBNE  BADINP
         MOV   AL,22              ;LIT LANTERN
         CALL  HAVOBJ
         JNE   VLIGHT_A
         MOV   AL,21              ;UNLIT LANTERN
         CALL  HAVOBJ
         LBEQ  NOHAVE
         MOV   AL,16              ;MATCHES
         CALL  HAVOBJ
         LBEQ  DMSG075
         TEST  LITECT,0FFH        ;CHK IF OUT OF LIGHT
         LBEQ  DMSG021
         MOV   AL,21              ;UNLIT LANTERN
         MOV   AH,22              ;LIT LANTERN
         CALL  REPOBJ
         MOV   LITESW,1
         MOV   AL,ROOM
         CMP   AL,12
         JB    VLIGHT_A
         CMP   AL,13
         JA    VLIGHT_A
         CALL  DRAWSC
VLIGHT_A:
         JMP   DMSG031
VLIGHT   ENDP

;        CUT VERB PROCESSOR

VCUT     PROC
         CMP   NOUNNO,30          ;HAIR
         LBNE  BADINP
         MOV   AL,17              ;WOMAN
         CALL  LOCOBJ
         JE    VCUT_A
         MOV   AL,VERB
         CMP   AL,'S'             ;WAS VERB "SAW"?
         JE    VCUT_B
         MOV   AL,24              ;SHEARS
         CALL  HAVOBJ
         LBEQ  DMSG069
         TEST  HAIRSW,0FFH
         JNE   VCUT_A
         MOV   AL,30              ;LOCK OF HAIR
         CALL  PUTNRM
         INC   HAIRSW
         JMP   REPLY
VCUT_A:
         JMP   DMSG023
VCUT_B:
         MOV   AL,25              ;HAND SAW
         CALL  HAVOBJ
         JE    VCUT_A
         JMP   DMSG070
VCUT     ENDP

;        LISTEN/HEAR VERB PROCESSOR

VHEAR    PROC
         MOV   AL,111             ;OPEN COFFIN
         CALL  CKOBJ
         JE    VHEAR_A
         TEST  VOICSW,0FFH
         JNE   VHEAR_A
         INC   VOICSW
         INC   SNOWSW
         JMP   DMSG073
VHEAR_A:
         JMP   DMSG074
VHEAR    ENDP

;        DIG VERB PROCESSOR

VDIG     PROC
         CMP   NOUNNO,9           ;SNOW
         LBNE  BADINP
         MOV   AL,33              ;SHOVEL
         CALL  HAVOBJ
         LBEQ  DMSG095
         CMP   ROOM,5
         JB    VDIG_A
         JA    VDIG_B
         MOV   AL,97              ;SNOW BLOCKING DOOR
         CALL  CKOBJ
         JE    VDIG_B
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   SNOWSW,0
VDIG_A:
         JMP   DMSG096
VDIG_B:
         JMP   DMSG023
VDIG     ENDP

;        PULL VERB PROCESSOR

VPULL    PROC
         MOV   AL,NOUNNO
         CMP   AL,28              ;BOARDS
         JE    VPULL_B
         CMP   AL,29              ;NAILS
         LBNE  BADINP
         MOV   AL,103             ;BOARDED UP DOORWAY
         CALL  CKOBJ
         JE    VPULL_A
         MOV   AL,27              ;HAMMER
         CALL  HAVOBJ
         JE    VPULL_A
         MOV   AL,103             ;BOARDED DOORWAY
         MOV   AH,102             ;OPEN DOORWAY
         CALL  CHGOBJ
         DISABLE
         MOV   ROOM,12
         MOV   AL,113             ;CLOSED DOOR PASSAGE
         MOV   AH,96              ;OPEN DOOR PASSAGE
         CALL  CHGOBJ
         MOV   ROOM,23
         ENABLE
         MOV   AL,29              ;NAILS
         CALL  PUTNRM
         MOV   AL,28              ;BOARDS
         CALL  PUTNRM
         CALL  CKDRAW
         JMP   REPLY
VPULL_A:
         JMP   DMSG020
VPULL_B:
         MOV   AL,103             ;BOARDED UP DOORWAY
         CALL  CKOBJ
         JE    VPULL_A
         MOV   BX,OFFSET MSG076
         CALL  DISPLY
         JMP   DMSG026
VPULL    ENDP

;        INVOKE VERB PROCESSOR

VINVOK   PROC
         CMP   NOUNNO,39          ;EPISICOPUS
         LBNE  BADINP
         CMP   ROOM,24            ;IN TRAP ROOM?
         JNE   VINVOK_A           ;  NO
         MOV   ROOM,7
         CALL  DRAWSC
         CALL  CLSTXT
         JMP   DMSG079
VINVOK_A:
         CMP   VOICSW,3
         JAE   VINVOK_B
         JMP   DMSG080
VINVOK_B:
         MOV   AL,117             ;CIRCLE OF SALT
         MOV   AH,94              ;FLAMING CIRCLE
         CALL  CHGOBJ
         MOV   AL,95              ;HOODED FIGURE
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  DRAWSC
         CALL  CLSTXT
         MOV   BX,OFFSET MSG099
         CALL  DISPLY
         JMP   FINI
VINVOK   ENDP

;        BUILD VERB PROCESSOR

VBUILD   PROC
         CMP   NOUNNO,107         ;ALTAR
         LBNE  BADINP
         MOV   AL,28              ;BOARDS
         CALL  LOCOBJ
         JE    VBUILD_A
         MOV   AL,29              ;NAILS
         CALL  LOCOBJ
         JE    VBUILD_A
         MOV   AL,27              ;HAMMER
         CALL  LOCOBJ
         JE    VBUILD_A
         MOV   AL,25              ;HAND SAW
         CALL  LOCOBJ
         JE    VBUILD_A
         CMP   ROOM,13
         LBNE  DMSG077
         MOV   AL,28              ;BOARDS
         SUB   AH,AH
         CALL  REPOBJ
         CALL  CHGOBJ
         MOV   AL,29              ;NAILS
         CALL  REPOBJ
         CALL  CHGOBJ
         MOV   AL,107             ;ALTAR
         CALL  PUTNRM
         CALL  CKDRAW
         JMP   REPLY
VBUILD_A:
         MOV   BX,OFFSET MSG028
         CALL  DISPLY
         JMP   DMSG078
VBUILD   ENDP

;        BREAK VERB PROCESSOR

VBREAK   PROC
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CMP   AL,121             ;MIRROR
         LBNE  DMSG026
         CALL  CKOBJ
         LBEQ  NOSEE
         MOV   BX,OFFSET MSG079
         JMP   TOTRAP
VBREAK   ENDP

;        CHECK FOR IN DARK ROOM

INDARK   PROC
         PUSH  AX
         PUSH  BX
         PUSH  SI
         MOV   AL,ROOM
         CMP   AL,12
         JB    INDARK_A
         CMP   AL,13
         JA    INDARK_A
         MOV   AL,22              ;LIT LAMP
         CALL  LOCOBJ
         JNE   INDARK_A
         MOV   SI,OFFSET SCRBLK
         CALL  SHOSCR
         CALL  CLSTXT
         MOV   BX,OFFSET MSG084
         CALL  DISPLY
         SUB   AL,AL
INDARK_A:
         TEST  AL,0FFH
         POP   SI
         POP   BX
         POP   AX
         RET
INDARK   ENDP

;        CHECK EACH ITEM OF A "PUT ALL"

CHKPA    PROC
         TEST  AL,0FFH
         RET
CHKPA    ENDP

;        CHECK EACH ITEM OF A "GET ALL"

CHKGA    PROC
         PUSH  AX
         PUSH  BX
         MOV   AH,AL
         MOV   AL,115             ;OLD MAN IN LOFT
         CALL  CKOBJ
         JE    CHKGA_A
         CMP   AH,23              ;KEYS
         JB    CHKGA_A
         CMP   AH,25              ;HAND SAW
         JA    CHKGA_A
         SUB   AH,AH
CHKGA_A:
         CMP   AH,26              ;RAVEN
         JNE   CHKGA_B
         MOV   AL,15              ;NET
         CALL  HAVOBJ
         JNE   CHKGA_B
         MOV   BX,OFFSET MSG061
         CALL  DISPLY
         SUB   AH,AH
CHKGA_B:
         TEST  AH,0FFH
         POP   BX
         POP   AX
         RET
CHKGA    ENDP

;        ROUTINE PERFORMED FOR EACH MOVE

ECHMOV   PROC
         PUSH  AX
         PUSH  BX
         PUSH  CX
         PUSH  DX
         PUSH  SI
         CALL  CKASH              ;SEE IF ASH THROWN
         CALL  CKMONS             ;SEE IF IN MONASTERY
         CALL  CKLITE             ;SEE IF LANTERN RUNS OUT
         POP   SI
         POP   DX
         POP   CX
         POP   BX
         POP   AX
         RET
ECHMOV   ENDP

;        CHECK IF ASH THROWN

CKASH    PROC
         CMP   VOICSW,3
         JB    CKASH_B
         JE    CKASH_A
         DISABLE
         MOV   ROOM,11
         MOV   AL,118             ;STATUE OF ME
         CALL  PUTNRM
         MOV   BX,OFFSET MSG098
         JMP   DEAD2
CKASH_A:
         INC   VOICSW
CKASH_B:
         RET
CKASH    ENDP

;        CHECK LANTERN

CKLITE   PROC
         TEST  LITECT,0FFH
         JE    CKLITE_F
         TEST  LITESW,0FFH
         JE    CKLITE_F
         DEC   LITECT
         JE    CKLITE_G
         MOV   AL,LITECT
         CMP   AL,19
         JA    CKLITE_F
         SUB   AH,AH
         MOV   BX,AX
         MOV   SI,OFFSET MSG025A
         CALL  ASCLNO
         CALL  SUPRES
         MOV   AX,WORD PTR MSG025A+3
         MOV   WORD PTR MSG033A,AX
         MOV   BX,OFFSET MSG033
         CALL  DISPLY
CKLITE_F:
         RET
CKLITE_G:
         MOV   LITESW,0
         MOV   AL,22              ;LIT LANTERN
         MOV   AH,21              ;UNLIT LANTERN
         CALL  XCHGOB
         CALL  INDARK
         JMP   SHORT CKLITE_F
CKLITE   ENDP

;        CHECK IF IN MONASTERY

CKMONS   PROC
         MOV   AL,ROOM
         CMP   AL,8
         JB    CKMONS_D
         CMP   AL,11
         JE    CKMONS_D
         CMP   AL,18
         JE    CKMONS_D
         CMP   AL,24              ;IN TRAP
         JE    CKMONS_D
         CMP   AL,12
         JE    CKMONS_D
         CMP   AL,13
         JE    CKMONS_D
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,35
         JA    CKMONS_D
         CMP   AL,12
         JA    CKMONS_A
         MOV   BX,OFFSET MSG086
         JMP   SHORT CKMONS_C
CKMONS_D:
         RET
CKMONS_A:
         CMP   AL,22
         JA    CKMONS_B
         MOV   BX,OFFSET MSG087
         JMP   SHORT CKMONS_C
CKMONS_B:
         MOV   AL,18              ;ROBE
         CALL  HAVOBJ
         JE    CKMONS_E
         MOV   BX,OFFSET FIGRMS
CKMONS_J:
         MOV   AL,BYTE PTR [BX]
         INC   BX
         TEST  AL,0FFH
         JE    CKMONS_D
         CMP   AL,ROOM
         JNE   CKMONS_J
         MOV   MSGLNS,0
         MOV   BX,OFFSET MSG088
         CALL  DISPLY
         DISABLE
         MOV   AL,141             ;OVFIG1
         CALL  SHOOVL
         INC   AL                 ;OVFIG2
         CALL  SHOOVL
         ENABLE
         MOV   DL,15
         CALCX 34,37
CKMONS_Q:
         MOV   AX,GSCRN1@W [BX]
         XOR   AX,0101000001010000B
         MOV   GSCRN1@W [BX],AX
         MOV   CX,30000
CKMONS_U:
         LOOP  CKMONS_U
         DEC   DL
         JNZ   CKMONS_Q
         CALL  DRAWSC
         RET
CKMONS_C:
         CALL  DISPLY
         RET
CKMONS_E:
         MOV   BX,OFFSET MSG089
         JMP   SHORT TOTRAP
CKMONS   ENDP

;        GO TO TRAP ROOM

TOTRAP   PROC
         DISABLE
         MOV   AL,DEADRM1
         MOV   ROOM,AL
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,10
         JB    TOTRAP_A
         CALL  DRAWSC
         CALL  CLSTXT
         CALL  DISPLY
         JMP   REPLY
TOTRAP_A:
         JMP   DEAD1
TOTRAP   ENDP

;        IN ROOM ROUTINES

;        ROOM 5

INRM05   PROC
         PUSH  AX
         PUSH  BX
         MOV   AL,9               ;SNOW
         CALL  HAVOBJ
         JE    INRM05_A
         SUB   AH,AH
         CALL  REPOBJ
         MOV   BX,OFFSET MSG056
         CALL  DISPLY
         JMP   SHORT INRM05_B
INRM05_A:
         MOV   AL,13              ;JUG OF SNOW
         CALL  HAVOBJ
         JE    INRM05_B
         MOV   AH,14              ;JUG OF WATER
         CALL  REPOBJ
         MOV   BX,OFFSET MSG057
         CALL  DISPLY
INRM05_B:
         MOV   AL,127             ;OPEN DOOR
         CALL  CKOBJ
         JE    INRM05_C
         MOV   AL,RANDOM
         CMP   AL,75
         JA    INRM05_C
         MOV   BX,OFFSET MSG058
         CALL  DISPLY
INRM05_C:
         POP   BX
         POP   AX
         RET
INRM05   ENDP

;        ROOM 13

INRM13   PROC
         PUSH  AX
         PUSH  BX
         MOV   AL,22              ;LIT LANTERN
         CALL  LOCOBJ
         LBEQ  INRM13_C
         MOV   AL,VOICSW
         TEST  AL,0FFH
         LBEQ  INRM13_A
         CMP   AL,1
         LBHI  INRM13_C
         MOV   AL,107             ;ALTAR
         CALL  CKOBJ
         JE    INRM13_C
         MOV   AL,14              ;WATER
         CALL  LOCOBJ
         JE    INRM13_C
         MOV   AL,30              ;HAIR
         CALL  LOCOBJ
         JE    INRM13_C
         MOV   AL,31              ;SHEET
         CALL  LOCOBJ
         JE    INRM13_C
         MOV   AL,32              ;SALT
         CALL  LOCOBJ
         JE    INRM13_C
         MOV   AL,34              ;FEATHER
         CALL  LOCOBJ
         JE    INRM13_C
         MOV   AL,10              ;PINE NEEDLES
         CALL  LOCOBJ
         JE    INRM13_C
         SUB   AH,AH
         MOV   AL,14              ;WATER
         CALL  INRM13_Z
         MOV   AL,30              ;HAIR
         CALL  INRM13_Z
         MOV   AL,31              ;SHEET
         CALL  INRM13_Z
         MOV   AL,32              ;SALT
         CALL  INRM13_Z
         MOV   AL,34              ;FEATHER
         CALL  INRM13_Z
         MOV   AL,10              ;PINE NEEDLES
         CALL  INRM13_Z
         MOV   AL,107             ;ALTAR
         CALL  CHGOBJ
         CALL  CKDRAW
         MOV   AL,38              ;ASH
         CALL  PUTNRM
         INC   VOICSW
         DISABLE
         MOV   ROOM,11
         MOV   AL,95              ;HOODED FIGURE
         CALL  PUTNRM
         MOV   ROOM,13
         ENABLE
         MOV   BX,OFFSET MSG071
         JMP   SHORT INRM13_B
INRM13_C:
         POP   BX
         POP   AX
         RET
INRM13_A:
         MOV   AL,111             ;OPEN COFFIN
         CALL  CKOBJ
         JE    INRM13_C
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,80
         JA    INRM13_C
         MOV   BX,OFFSET MSG072
INRM13_B:
         CALL  DISPLY
         JMP   SHORT INRM13_C
INRM13_Z:
         CALL  REPOBJ
         CALL  CHGOBJ
         RET
INRM13   ENDP

;        ROOM 18

INRM18   PROC
         PUSH  AX
         PUSH  BX
         MOV   AL,11              ;JUG OF WINE
         CALL  CKOBJ
         JE    INRM18_A
         SUB   AH,AH
         CALL  CHGOBJ
         MOV   AL,115             ;OLD MAN IN LOFT
         CALL  CHGOBJ
         DISABLE
         MOV   ROOM,15
         MOV   AL,99              ;SLEEPING OLD MAN
         CALL  PUTNRM
         MOV   AL,12              ;EMPTY JUG
         CALL  PUTNRM
         MOV   ROOM,18
         ENABLE
         MOV   AL,115             ;OLD MAN
         CALL  CKDRAW
         MOV   BX,OFFSET MSG063
         CALL  DISPLY
INRM18_A:
         POP   BX
         POP   AX
         RET
INRM18   ENDP

;        ENTER ROOM ROUTINES

;        ROOM 5

ENTR05   PROC
         PUSH  AX
         TEST  SNOWSW,0FFH
         JE    ENTR05_A
         MOV   AL,127             ;OPEN DOOR
         CALL  CKOBJ
         JE    ENTR05_A
         MOV   AL,97              ;SNOW BLOCKING THE DOOR
         SUB   AH,AH
         CALL  CHGOBJ
         CALL  PUTNRM
         CALL  CKDRAW
ENTR05_A:
         POP   AX
         JMP   INRM05
ENTR05   ENDP

;        ROOMS 12 & 13

ENTR12   PROC
         PUSH  AX
         PUSH  BX
         MOV   AL,22              ;LIT LAMP
         CALL  LOCOBJ
         JNE   ENTR12_B
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,90
         JA    ENTR12_B
         MOV   BX,OFFSET MSG034
         CALL  DISPLY
ENTR12_B:
         POP   BX
         POP   AX
         RET
ENTR12   ENDP

;        EXIT ROOM ROUTINES

;        ROOM 11

EXIT11   PROC
         PUSH  AX
         CMP   AH,12              ;GOING TO ROOM 12?
         JNE   EXIT11_A           ;  NO
         MOV   AL,28              ;BOARDS
         CALL  HAVOBJ
         LBNE  DMSG083
EXIT11_A:
         POP   AX
         RET
EXIT11   ENDP

;        ROOMS 12 & 13

EXIT12   PROC
         PUSH  AX
         MOV   AL,22              ;LIT LAMP
         CALL  LOCOBJ
         JNE   EXIT12_A
         MOV   AL,RANDOM
         AND   AL,07FH
         CMP   AL,30
         JA    EXIT12_A
         MOV   BX,OFFSET MSG035
         JMP   DEAD1
EXIT12_A:
         POP   AX
         RET
EXIT12   ENDP

;        ANTIMATION ROUTINES

;        MOVE SMOKE IN ROOM 1

MOVSMO   PROC
         INC   FLP2CT
         MOV   AX,FLP2CT
         CMP   AX,8
         JB    MOVSMO_A
         MOV   FLP2CT,0
         CALCX 29,109
         CALCD 29,109,33,124
         CALL  SCRRIT
MOVSMO_A:
         JMP   SHORT MOVCLO
MOVSMO   ENDP

;        MOVE CLOUDS OUTSIDE

MOVCLO   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,6/3
         JE    MOVCLO_A
         CMP   AX,6/3*2
         JE    MOVCLO_A
         CMP   AX,6
         JB    MOVCLO_B
         MOV   FLIPCT,0
         CALCX 10,1
         CALCD 10,1,21,128
         CALL  SCRRIT
MOVCLO_A:
         CALCX 1,1
         CALCD 1,1,6,128
         CALL  SCRRIT
MOVCLO_B:
         RET
MOVCLO   ENDP

;        MOVE FIRE IN LIVING ROOM

MOVFIR   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,4
         JB    MOVFIR_C
         MOV   FLIPCT,0
         XOR   FLIPSW,1
         JE    MOVFIR_A
         MOV   AL,14              ;OVFIR3
         JMP   SHORT MOVFIR_B
MOVFIR_A:
         MOV   AL,15              ;OVFIR4
MOVFIR_B:
         CALL  SHOOVL
MOVFIR_C:
         RET
MOVFIR   ENDP

;        MOVE FRONT TORCHES

MOVTR2   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,2
         JB    MOVTR2_C
         MOV   FLIPCT,0
         XOR   FLIPSW,1
MOVTRX:
         JE    MOVTR2_A
         MOV   AL,143             ;OVTR11
         CALL  SHOOVL
         MOV   AL,144             ;OVTR41
         JMP   SHORT MOVTR2_B
MOVTR2_A:
         MOV   AL,8               ;OVTR12
         CALL  SHOOVL
         MOV   AL,11              ;OVTR42
MOVTR2_B:
         CALL  SHOOVL
MOVTR2_C:
         RET
MOVTR2   ENDP

;        MOVE ALL FOUR TORCHES

MOVTR4   PROC
         INC   FLIPCT
         MOV   AX,FLIPCT
         CMP   AX,2
         JB    MOVTR4_C
         MOV   FLIPCT,0
         XOR   FLIPSW,1
         JE    MOVTR4_A
         MOV   AL,145             ;OVTR21
         CALL  SHOOVL
         MOV   AL,146             ;OVTR31
         JMP   SHORT MOVTR4_B
MOVTR4_A:
         MOV   AL,9               ;OVTR22
         CALL  SHOOVL
         MOV   AL,10              ;OVTR32
MOVTR4_B:
         CALL  SHOOVL
         TEST  FLIPSW,0FFH
         JMP   SHORT MOVTRX
MOVTR4_C:
         RET
MOVTR4   ENDP

;        MOVE EYES ON HOODED FIGURE

MOVEYE   PROC
         MOV   AL,95              ;HOODED FIGURE
         CALL  CKOBJ
         JE    MOVEYE_A
         INC   FLIPSW
         CMP   FLIPSW,11
         JB    MOVEYE_A
         MOV   FLIPSW,0
         CALCX 28,45
         MOV   AX,GSCRN1@W [BX]
         XOR   AX,0000010100000101B
         MOV   GSCRN1@W [BX],AX
MOVEYE_A:
         RET
MOVEYE   ENDP


;        FILE: ADVCODE2.ASM
