
;        FILE: ADVCODE1.ASM         LAST MODIFIED: 10/19/84

;********************************************************************
;
;  VLOOK  - "LOOK" VERB HANDLER
;
;********************************************************************

VLOOK    PROC
         CALL  INDARK
         LBEQ  REPLY
         TEST  NOUNNO,0FFH
         LBNE  LOOKOB
         CALL  CLSTXT
VLOOK2:
         CALL  DRAWSC
         MOV   AH,ROOM
VLOOK_A:
         LEA   BX,DESCTB          ;FIND ROOM DESCRIPTION
VLOOK_B:
         DEC   AH
         JZ    VLOOK_D
VLOOK_C:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   VLOOK_C
         JMP   SHORT VLOOK_B
VLOOK_D:
         MOV   AL,[BX]
         CMP   AL,0FFH
         JNE   VLOOK_E
         MOV   AH,[BX+1]
         JMP   SHORT VLOOK_A
VLOOK_E:
         CALL  DISPLY
         MOV   AL,ROOM            ;DISPLAY ALL ROOM DIRECTIONS
         DEC   AL
         MOV   CL,RMSIZE
         MUL   CL
         LEA   CX,ROOMTB
         ADD   AX,CX
         MOV   DI,AX
         MOV   BX,AX              ;SEE IF ANY EXITS EXIST
         MOV   AH,RMSIZE
VLOOK_P:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   VLOOK_Q
         DEC   AH
         JNZ   VLOOK_P
         JMP   SHORT VLOOK_R
VLOOK_Q:
         LEA   BX,MSG001          ;DIRECTION MSG
         CALL  DISPLY
         LEA   BX,DIRECT
         MOV   AH,RMSIZE
VLOOK_F:
         INC   DI
         MOV   AL,[DI-1]
         CMP   AL,0
         JLE   VLOOK_G
         CALL  DISPLY
         CALL  PUTCMA
VLOOK_G:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   VLOOK_G
         DEC   AH
         JNZ   VLOOK_F
         CALL  PERIOD
VLOOK_R:
         CALL  PNTRM1
         MOV   DI,BX
         MOV   AL,[BX]
         CMP   AL,0
         JE    VLOOK_O
         LEA   BX,MSG002          ;OBJECTS SEEN MSG
         CALL  DISPLY
VLOOK_M:
         LEA   BX,OBJTAB          ;OBJECT DESC TABLE
         MOV   AL,[DI]
         INC   DI
         CMP   AL,0
         JE    VLOOK_N            ;END OF OBJECTS
         JL    VLOOK_M            ;UNSEEN OBJECT
VLOOK_J:
         INC   BX
         CMP   AL,[BX-1]
         JE    VLOOK_L
VLOOK_K:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   VLOOK_K
         JMP   SHORT VLOOK_J
VLOOK_L:
         MOV   AL,[BX]
         CMP   AL,0FFH
         JNE   VLOOK_T
         MOV   AL,[BX+1]
         LEA   BX,OBJTAB
         JMP   SHORT VLOOK_J
VLOOK_T:
         CALL  DISPLY
         CALL  PUTCMA
         JMP   SHORT VLOOK_M
VLOOK_N:
         CALL  PERIOD
VLOOK_O:
         JMP   REPLY
VLOOK    ENDP

;********************************************************************
;
;  LOOKOB - GENERAL LOOK AT OBJECT ROUTINE
;
;********************************************************************

LOOKOB   PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,6               ;IS IT A DIRECTION?
         JA    LOOKOB_A           ;  NO:CONTINUE ON
         JMP   DMSG012            ;  YES:DISPLAY "NUTHIN SPECIAL"
LOOKOB_A:
         MOV   AH,0
         CALL  HAVOBJ
         JNZ   LOOKOB_B
         MOV   AL,NOUNNO
         CALL  CKOBJ
         JZ    NOSEE
         INC   AH
LOOKOB_B:
         INC   AH
         LEA   BX,OBJMSG
LOOKOB_C:
         TEST  BYTE PTR [BX],0FFH
         LBEQ  DMSG012
         CMP   AL,[BX]
         JE    LOOKOB_D
         ADD   BX,3
         JMP   SHORT LOOKOB_C
LOOKOB_D:
         MOV   AL,AH
         MOV   AH,0
         ADD   BX,AX
         MOV   AL,[BX]
         CMP   AL,7
         JE    NOSEE
         CMP   AL,8
         JE    ALRHAV
         CMP   AL,10
         JE    NOHAVE
         JMP   DMSGXX
LOOKOB   ENDP

;********************************************************************
;
;  NOSEE  - DISPLAY OBJECT NOT SEEN MESSAGE
;
;********************************************************************

NOSEE    PROC
         LEA   BX,MSG007
NOSEE1:
         CALL  DISPLY
         MOV   AL,NOUNNO
         LEA   BX,THEMTB
         MOV   AH,0
NOSEE_A:
         TEST  BYTE PTR [BX],0FFH
         JZ    NOSEE_B
         ADD   BX,2
         CMP   AL,[BX-2]
         JNE   NOSEE_A
         MOV   AH,[BX-1]
NOSEE_B:
         LEA   BX,LITTAB
NOSEE_C:
         TEST  AH,0FFH
         JZ    NOSEE_E
NOSEE_D:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   NOSEE_D
         DEC   AH
         JMP   SHORT NOSEE_C
NOSEE_E:
         CALL DISPLY
         JMP  REPLY
NOSEE    ENDP

;********************************************************************
;
;  NOHAVE - DISPLAY DON'T HAVE OBJECT MESSAGE
;
;********************************************************************

NOHAVE   PROC
         LEA   BX,MSG010
         JMP   SHORT NOSEE1
NOHAVE   ENDP

;********************************************************************
;
;  ALRHAV - DISPLAY ALREADY HAVE OBJECT MESSAGE
;
;********************************************************************

ALRHAV   PROC
         LEA   BX,MSG008
         JMP   SHORT NOSEE1
ALRHAV   ENDP

;********************************************************************
;
;  VGO    - "GO" VERB HANDLER
;
;********************************************************************

VGO      PROC
         JMP   SHORT VGO2
VNORTH:
         MOV   AL,1
         JMP   SHORT VGO1
VSOUTH:
         MOV   AL,2
         JMP   SHORT VGO1
VEAST:
         MOV   AL,3
         JMP   SHORT VGO1
VWEST:
         MOV   AL,4
         JMP   SHORT VGO1
VUP:
         MOV   AL,5
         JMP   SHORT VGO1
VDOWN:
         MOV   AL,6
VGO1:
         MOV   NOUNNO,AL
VGO2:
         MOV   AL,NOUNNO
         CMP   AL,0
         JLE   VGO_C
VGO_D:
         CMP   AL,6
         JA    VGO_C
         MOV   AL,ROOM
         DEC   AL
         MOV   CL,RMSIZE
         MUL   CL
         LEA   BX,ROOMTB
         ADD   BX,AX
         MOV   AL,NOUNNO
         DEC   AL
         MOV   AH,0
         ADD   BX,AX
         MOV   AL,[BX]
         CMP   AL,0
         JLE   VGO_B
EXITRM:
         MOV   AH,AL
         LEA   BX,EXITTB          ;SPECIAL EXIT ROUTINES
VGO_E:
         INC   BX
         MOV   AL,[BX-1]
         CMP   AL,0
         JE    VGO_G
         CMP   AL,ROOM
         JE    VGO_F
         ADD   BX,2
         JMP   SHORT VGO_E
VGO_F:
         CALL  WORD PTR [BX]
VGO_G:
         INC   NEWRM
         DISABLE
         MOV   ROOM,AH
         MOV   NOUNNO,0
VGO_A:
         JMP   VLOOK
VGO_B:
         LEA   BX,MSG003          ;NO WAY TO GO MSG
         CALL  DISPLY
         JMP   REPLY
VGO_C:
         JMP   BADINP
VGO      ENDP

;********************************************************************
;
;  VINVE  - "INVENTORY" VERB HANDLER
;
;********************************************************************

VINVE    PROC
         LEA   BX,MSG005
         CALL  DISPLY
         LEA   BX,OBJECT
         MOV   AL,0
         MOV   AH,MAXOBJ1
VINVE_A:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JZ    VINVE_B
         INC   AL
VINVE_B:
         DEC   AH
         JNZ   VINVE_A
         TEST  AL,0FFH
         JZ    VINVE_I
         LEA   DI,OBJECT
         MOV   AH,MAXOBJ1
VINVE_C:
         INC   DI
         MOV   AL,[DI-1]
         CMP   AL,0
         JE    VINVE_G
         LEA   BX,OBJTAB
VINVE_D:
         INC   BX
         CMP   AL,[BX-1]
         JE    VINVE_F
VINVE_E:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   VINVE_E
         JMP   SHORT VINVE_D
VINVE_F:
         MOV   AL,[BX]
         CMP   AL,0FFH
         JNE   VINVE_J
         MOV   AL,[BX+1]
         LEA   BX,OBJTAB
         JMP   SHORT VINVE_D
VINVE_J:
         MOV   AL,13
         CALL  CHROUT
         CALL  DISPLY
         CALL  PUTCMA
VINVE_G:
         DEC   AH
         JNZ   VINVE_C
         CALL  PERIOD
VINVE_H:
         JMP   REPLY
VINVE_I:
         LEA   BX,MSG006
         CALL  DISPLY
         JMP   SHORT VINVE_H
VINVE    ENDP

;********************************************************************
;
;  VGET   - "GET" VERB HANDLER
;
;********************************************************************

VGET     PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CMP   AL,128             ;IS IT "GET ALL"?
         JE    VGET_I             ;  YES
         CALL  LOCOBJ
         JZ    VGET_M
         CMP   AL,64
         JLE   VGET_A
         JMP   DMSG015
VGET_A:
         CALL  HAVOBJ
         LBNE  ALRHAV
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         JAE   VGET_E
         MOV   AL,NOUNNO
         CALL  GETOBJ
         JNZ   VGET01
VGET_M:
         JMP   NOSEE
VGET_E:
         JMP   DMSG009
VGET01:
         CALL  GIVOBJ
         CALL  CKDRAW
VGET_H:
         JMP   REPLY
VGET_I:
         CALL  PNTRM1             ;PROCESS "GET ALL" COMMAND
VGET_J:
         INC   BX
         CMP   BYTE PTR [BX-1],0
         JL    VGET_J
         JE    VGET_H
         MOV   AL,OBJCNT
         CMP   AL,MAXOBJ1
         JAE   VGET_E
         MOV   AL,[BX-1]
         CMP   AL,64
         JA    VGET_J
         CALL  CHKGA
         JZ    VGET_J
         CALL  GETOBJ
         CALL  GIVOBJ
         CALL  CKDRAW
         JMP   SHORT VGET_I
VGET     ENDP

;********************************************************************
;
;  VPUT   - "PUT" VERB HANDLER
;
;********************************************************************

VPUT     PROC
         CALL  EQUOBJ
         MOV   AL,NOUNNO
         CMP   AL,0
         LBEQ  BADINP
         CMP   AL,128             ;IS IT "PUT ALL"?
         JE    VPUT_E             ;  YES
         CALL  HAVOBJ
         LBEQ  NOHAVE
         CALL  PUTOBJ
         CALL  CKDRAW
         MOV   AH,0
         CALL  REPOBJ
VPUT_D:
         JMP   REPLY
VPUT_E:
         LEA   BX,OBJECT          ;PROCESS "PUT ALL" COMMAND
         MOV   AH,MAXOBJ1
VPUT_F:
         INC   BX
         MOV   AL,[BX-1]
         CMP   AL,0
         JE    VPUT_G
         CALL  CHKPA
         JZ    VPUT_G
         MOV   BYTE PTR [BX-1],0
         DEC   OBJCNT
         CALL  PUTOBJ
         CALL  CKDRAW
VPUT_G:
         DEC   AH
         JNZ   VPUT_F
         JMP   SHORT VPUT_D
VPUT     ENDP

;********************************************************************
;
;  VSCORE - "SCORE" VERB HANDLER
;
;********************************************************************

VSCORE   PROC
         IF    R$PNTS
         MOV   BL,POINTS
         MOV   BH,0
         LEA   SI,MSG024B
         CALL  ASCLNO
         CALL  SUPRES
         ENDIF
         DEC   SCORE
         MOV   BX,SCORE
         LEA   SI,MSG024A
         CALL  ASCLNO
         CALL  SUPRES
         JMP   DMSG024
VSCORE   ENDP

;********************************************************************
;
;  BADINP - PROCESS UNKNOWN INPUT
;
;********************************************************************

BADINP   PROC
         DEC   SCORE
         LEA   BX,MSG004
         CALL  DISPLY
         LEA   BX,KEYBUF
         CALL  DISPLY
         MOV   AL,'"'
         CALL  CHROUT
         JMP   SHORT REPLY1
BADINP   ENDP

;********************************************************************
;
;  REPLY  - ADVENTURE MAINLINE PROCESSOR
;
;********************************************************************

REPLY    PROC
         MOV   AL,POINTS
         CMP   AL,MAXPNT1
         LBEQ  FINI
         TEST  NEWRM,0FFH
         JZ    REPLY_D
         MOV   FLIPSW,0
         MOV   FLIPCT,0
         MOV   FLP2SW,0
         MOV   FLP2CT,0
         MOV   RMMOVE,0
         LEA   BX,ENTRTB
         MOV   NEWRM,0
         JMP   SHORT REPLY_E
REPLY_D:
         LEA   BX,INRMTB
REPLY_E:
         MOV   AL,[BX]
         INC   BX
         CMP   AL,0
         JE    REPLY_G
         CMP   AL,ROOM
         JE    REPLY_F
         ADD   BX,2
         JMP   SHORT REPLY_E
REPLY_F:
         CALL  WORD PTR [BX]
REPLY_G:
         CALL  ECHMOV
REPLY1:
         MOV   AX,STKSEG          ;RESET THE STACK
         cli
         MOV   SS,AX
         MOV   SP,OFFSET STKTOP
         sti
         ENABLE
         LEA   BX,MSG000          ;OK PROMPT
         CALL  DISPLY
         CALL  GETLIN
         CALL  SCNKEY
         INC   RMMOVE
         INC   SCORE
         LEA   BX,SPCRTN
REPLY_A:
         MOV   AX,[BX]
         ADD   BX,2
         CMP   AX,0
         JE    REPLY_C
         CMP   AX,VERB_NOUN
         JNE   REPLY_B
         JMP   WORD PTR [BX]
REPLY_B:
         ADD   BX,2
         JMP   SHORT REPLY_A
REPLY_C:
         MOV   AL,VERBNO
         CMP   AL,0
         LBEQ  BADINP
         DEC   AL
         SHL   AL,1
         MOV   AH,0
         LEA   BX,RTNTAB
         ADD   BX,AX
         JMP   WORD PTR [BX]
REPLY    ENDP

;********************************************************************
;
;  VHELP  - GENERAL HELP VERB PROCESSOR
;
;********************************************************************

VHELP    PROC
         LEA   BX,GENHLP
         MOV   AL,RANDOM
         AND   AL,3
         JZ    VHELP_B
VHELP_A:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   VHELP_A
         DEC   AL
         JNZ   VHELP_A
VHELP_B:
         CALL  DISPLY
         JMP   REPLY
VHELP    ENDP

;********************************************************************
;
;  VSAVE  - SAVE GAME PROCESSOR
;
;********************************************************************

VSAVE    PROC
         DEC   SCORE
         CALL  SAVGAM
         JMP   REPLY
VSAVE    ENDP

;********************************************************************
;
;  VLOAD  - LOAD GAME PROCESSOR
;
;********************************************************************

VLOAD    PROC
         DEC   SCORE
         CALL  LODGAM
         MOV   NOUNNO,0
         JMP   VLOOK
VLOAD    ENDP

;********************************************************************
;
;  DEAD1  - END OF GAME ROUTINES
;
;********************************************************************

DEAD1    PROC
         MOV   AL,DEADRM1
         MOV   ROOM,AL
DEAD2:
         CALL  CLSTXT
         CALL  DRAWSC
         CALL  DISPLY
         JMP   SHORT ENDGAM
FINI:
         LEA   BX,MSG027
         CALL  DISPLY
ENDGAM:
         IF    R$PNTS
         MOV   BL,POINTS
         MOV   BH,0
         LEA   SI,MSG025B
         CALL  ASCLNO
         CALL  SUPRES
         ENDIF
         MOV   BX,SCORE
         LEA   SI,MSG025A
         CALL  ASCLNO
         CALL  SUPRES
         LEA   BX,MSG025
         CALL  DISPLY
         CALL  GETLIN
         MOV   AL,KEYBUF
         AND   AL,11011111B       ;CONVERT TO UPPER CASE
         CMP   AL,'Y'
         JNE   DEAD3
         DISABLE
         JMP   NEWGAM
DEAD3:
         MOV   BX,OFFSET ENDMSG
         CALL  DISPLY
DEAD4:
         JMP   SHORT DEAD4
DEAD1    ENDP

;********************************************************************
;
;  DSPMSG - DISPLAY MESSAGE ROUTINES
;
;********************************************************************

DSPMSG   PROC
DMSG007: MOV   AL,007
         DB    3DH
DMSG008: MOV   AL,008
         DB    3DH
DMSG009: MOV   AL,009
         DB    3DH
DMSG010: MOV   AL,010
         DB    3DH
DMSG011: MOV   AL,011
         DB    3DH
DMSG012: MOV   AL,012
         DB    3DH
DMSG013: MOV   AL,013
         DB    3DH
DMSG014: MOV   AL,014
         DB    3DH
DMSG015: MOV   AL,015
         DB    3DH
DMSG016: MOV   AL,016
         DB    3DH
DMSG017: MOV   AL,017
         DB    3DH
DMSG018: MOV   AL,018
         DB    3DH
DMSG019: MOV   AL,019
         DB    3DH
DMSG020: MOV   AL,020
         DB    3DH
DMSG021: MOV   AL,021
         DB    3DH
DMSG022: MOV   AL,022
         DB    3DH
DMSG023: MOV   AL,023
         DB    3DH
DMSG024: MOV   AL,024
         DB    3DH
DMSG026: MOV   AL,026
         DB    3DH
DMSG027: MOV   AL,027
         DB    3DH
DMSG028: MOV   AL,028
         DB    3DH
DMSG029: MOV   AL,029
         DB    3DH
DMSG030: MOV   AL,030
         DB    3DH
DMSG031: MOV   AL,031
         DB    3DH
DMSG032: MOV   AL,032
         DB    3DH
DMSG034: MOV   AL,034
         DB    3DH
DMSG035: MOV   AL,035
         DB    3DH
DMSG036: MOV   AL,036
         DB    3DH
DMSG037: MOV   AL,037
         DB    3DH
DMSG040: MOV   AL,040
         DB    3DH
DMSG041: MOV   AL,041
         DB    3DH
DMSG044: MOV   AL,044
         DB    3DH
DMSG048: MOV   AL,048
         DB    3DH
DMSG050: MOV   AL,050
         DB    3DH
DMSG061: MOV   AL,061
         DB    3DH
DMSG062: MOV   AL,062
         DB    3DH
DMSG064: MOV   AL,064
         DB    3DH
DMSG065: MOV   AL,065
         DB    3DH
DMSG066: MOV   AL,066
         DB    3DH
DMSG067: MOV   AL,067
         DB    3DH
DMSG069: MOV   AL,069
         DB    3DH
DMSG070: MOV   AL,070
         DB    3DH
DMSG073: MOV   AL,073
         DB    3DH
DMSG074: MOV   AL,074
         DB    3DH
DMSG075: MOV   AL,075
         DB    3DH
DMSG077: MOV   AL,077
         DB    3DH
DMSG078: MOV   AL,078
         DB    3DH
DMSG079: MOV   AL,079
         DB    3DH
DMSG080: MOV   AL,080
         DB    3DH
DMSG081: MOV   AL,081
         DB    3DH
DMSG082: MOV   AL,082
         DB    3DH
DMSG083: MOV   AL,083
         DB    3DH
DMSG085: MOV   AL,085
         DB    3DH
DMSG091: MOV   AL,091
         DB    3DH
DMSG092: MOV   AL,092
         DB    3DH
DMSG095: MOV   AL,095
         DB    3DH
DMSG096: MOV   AL,096
         DB    3DH
DMSG097: MOV   AL,097
DMSGXX:
         LEA   BX,MSG001
DMSGXX_A:
         DEC   AL
         JZ    DMSGXX_C
DMSGXX_B:
         INC   BX
         TEST  BYTE PTR [BX-1],0FFH
         JNZ   DMSGXX_B
         JMP   SHORT DMSGXX_A
DMSGXX_C:
         CALL  DISPLY
         JMP   REPLY
DSPMSG   ENDP

;        FILE: ADVCODE1.ASM
