'Saga-Games Kartenspiel-Sammlung

'** Hauptmen **

'(c) 2005 by Saga-Games; www.saga-games.de.ms


'$DYNAMIC
DEFINT A-Z

DECLARE SUB printf (Text$, X%, Y%, C%)
DECLARE SUB Credits ()
DECLARE SUB MouseCursor ()
DECLARE SUB Balken (Xpos%)
DECLARE SUB MousePut (X%, Y%)
DECLARE SUB MouseStatus (LB%, RB%, Xmouse%, Ymouse%)
DECLARE SUB Beenden ()
DECLARE SUB Button (Text$, Ypos%)
DECLARE SUB Center (Mes$, Zeile%)
DECLARE SUB MouseRange (X1%, Y1%, X2%, Y2%)
DECLARE SUB MouseDriver (AX%, BX%, CX%, DX%)
DECLARE FUNCTION MouseInit% ()
DECLARE SUB ZeichneKarte (X%, Y%, Nummer%)
DECLARE SUB Sparkle ()

COLOR 7, 0: CLS
COLOR 15, 1
PRINT SPACE$(25); "Saga-Games Kartenspiel-Sammlung"; SPACE$(24)
COLOR 7, 0
PRINT
PRINT "Laden..."
PRINT " Maus initialisieren"
TYPE kartenTyp
  Wert AS INTEGER
  Farbe AS INTEGER
  ImStapel AS INTEGER
  Abgelegt AS INTEGER
END TYPE
DIM SHARED Karte(1 TO 32) AS kartenTyp
 
Act = 0
FOR Symbol = 7 TO 14
  FOR Wert = 1 TO 4
    Act = Act + 1
    Karte(Act).Wert = Symbol
    Karte(Act).Farbe = Wert
    Karte(Act).ImStapel = 1
    Karte(Act).Abgelegt = 0
  NEXT Wert
NEXT Symbol

DIM SHARED MouseData$
RESTORE MouseDataHEX
MouseData$ = SPACE$(57)
FOR I% = 1 TO 57
  READ A$
  H$ = CHR$(VAL("&H" + A$))
  MID$(MouseData$, I%, 1) = H$
NEXT I%
MouseDataHEX:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

IF MouseInit% = 0 THEN
  PRINT
  PRINT " "; CHR$(26); " Es wurde keine Maus gefunden oder der Treiber ist nicht geladen;"
  PRINT "    Die Kartenspiel-Sammlung bentigt eine Maus mit Treiber."
  DO: LOOP UNTIL LEN(INKEY$)
  Beenden
END IF


WIDTH 80, 50
PALETTE 7, 63
PALETTE 5, 62
MouseRange 16, 216, 623, 383
MousePut 320, 240
COLOR 15, 2: CLS
ZeichneKarte 5, 10, 18
ZeichneKarte 25, 10, 23
ZeichneKarte 45, 10, 25
ZeichneKarte 65, 10, 32
FOR K = 1 TO 10
  ZeichneKarte 60 + INT(5 * RND) - 2, 30 + INT(5 * RND) - 2, 0
NEXT

COLOR 14, 4
Button "Saga-Games Kartenspiel-Sammlung", 4

Button "   Mau-Mau   ", 33
Button "    Poker    ", 38
Button "   Beenden   ", 43
     
K1Pos = 5
K2Pos = 25
K3Pos = 45
K4Pos = 65

DO

  DO

'Groovy music (sowas wie tek-pete.gdm)
'Wenn die karten den platz wechseln muss das "flutsch"-gerusch kommen (wie bei flintstones oder simpsons meledy)

    IK$ = INKEY$
    IF IK$ = CHR$(27) THEN Beenden
    Sparkle
    FOR Delay = 1 TO 3
      WAIT &H3DA, 8
      WAIT &H3DA, 8, 8
      MouseStatus L, R, X, Y
      MouseCursor
    NEXT
    IF TIMER > St! + 1 AND Active <> 2 THEN Active = 1
    IF Active = 1 THEN
      K1 = INT(3 * RND) + 2
      DO
        K2 = INT(3 * RND) + 2
      LOOP UNTIL K2 <> K1
      Active = 2
      K1Ziel = (K1 - 1) * 20 + 5
      IF K1 = 2 THEN K2Ziel = 5
      IF K1 = 3 THEN K3Ziel = 5
      IF K1 = 4 THEN K4Ziel = 5
     
      K2Ziel = (K2 - 1) * 20 + 5
      IF K2 = 1 THEN K1Ziel = 25
      IF K2 = 3 THEN K3Ziel = 25
      IF K2 = 4 THEN K4Ziel = 25

    END IF
    IF Active = 2 THEN
      IF K1Pos < K1Ziel THEN K1Pos = K1Pos + 2
      IF K1Pos > K1Ziel THEN K1Pos = K1Pos - 2
      IF K2Pos < K2Ziel THEN K2Pos = K2Pos + 2
      IF K2Pos > K2Ziel THEN K2Pos = K2Pos - 2
      IF K3Pos < K3Ziel THEN K3Pos = K3Pos + 2
      IF K3Pos > K3Ziel THEN K3Pos = K3Pos - 2
      IF K4Pos < K4Ziel THEN K4Pos = K4Pos + 2
      IF K4Pos > K4Ziel THEN K4Pos = K4Pos - 2
      ZeichneKarte K1Pos, 10, 18: Balken K1Pos - 2: Balken K1Pos + 11
      IF K2Pos <> K1Pos THEN ZeichneKarte K2Pos, 10, 23: Balken K2Pos - 2: Balken K2Pos + 11
      IF K3Pos <> K1Pos AND K3Pos <> K2Pos THEN ZeichneKarte K3Pos, 10, 25: Balken K3Pos - 2: Balken K3Pos + 11
      IF K4Pos <> K1Pos AND K4Pos <> K2Pos AND K4Pos <> K3Pos THEN ZeichneKarte K4Pos, 10, 32: Balken K4Pos - 2: Balken K4Pos + 11
      IF K1Pos = K1Ziel AND K2Pos = K2Ziel AND K3Pos = K3Ziel AND K4Pos = K4Ziel THEN Active = 0: St! = TIMER
    END IF
   
    LOCATE 3, 3
  LOOP UNTIL SCREEN(Y, X, 1) \ 16 <> 2 AND (L OR R OR IK$ = CHR$(13))

  SC = SCREEN(Y, X, 1) \ 16
  IF SC = 4 OR SC = 12 THEN
    Spiel = (Y - 28) \ 5
    IF Spiel = 1 THEN RUN "Maumau"
    IF Spiel = 2 THEN RUN "Poker"
    IF Spiel = 3 THEN Beenden
  ELSEIF SC = 7 OR SC = 15 THEN
    Credits
  END IF
LOOP

Texts:
DATA "Saga-Games Kartenspiel-Sammlung","(c) 2005 by Saga-Games"
DATA "Konzept / Quellcode","Johannes Schultz"
DATA "Grafik / Musik","Johannes Schultz
DATA "Sounds","Johannes Schultz"
DATA "Maus-Rountinen","Unbekannter Autor"
DATA "Homepage","www.saga-games.de.ms"
DATA "E-Mail:","saga-games@arcor.de"
DATA "ICQ Nr:","324-324-485"
DATA "!HAVE     ","      FUN!"
DATA "Gre gehen an:",">"
DATA "Die Programmierer:","Mecki, Stormy, Tomtitom, KB, ICC, EinNiemand"
DATA "Noch mehr Programmierer:","Devilkevin, Quark48, Marky, Dreael und all die andren"
DATA "Die Musiker:","Zatzen, Awesome, Genetic Gemini und viele mehr"
DATA "Die ICQ-Freunde:","Toa-Nuva, Druetze, Anni und alle anderen in meiner riesigen Liste :-)"
DATA "Die Schulfreunde:","Tobi, Simon, Christian, Daniel, Cedric, ..."
DATA "",""
DATA "","Worauf wartest du noch?!","",""
DATA "Achso, auf die Cheats :-)","","",""
DATA "Drcke in allen Spielen einfach","beide Maustasten gleichzeitig ;-)","",""
DATA "*","*"

REM $STATIC
SUB Balken (Xpos)
  COLOR 15, 2
  FOR Ypos = 10 TO 26
    LOCATE Ypos, Xpos
    PRINT "  ";
  NEXT
END SUB

SUB Beenden
  WIDTH 80, 25
  COLOR 7, 0: CLS
  PALETTE
  PRINT "  Have a nice day...";
  LOCATE CSRLIN + 1, POS(0)
  PRINT " ...and visit:"
  Center "           Ŀ Ĵ ÿ  ڴ  Ŀ     ", 3
  Center "                                 ٳ          .de.ms", 4
  Center "  Ŀ Ĵ      Ŀ          Ĵ     ", 5
  Center "www.                                                ", 6
  Center "       Ĵ                         ", 7
  PRINT
  PRINT "  Die Saga-Games Kartenspiel-Sammlung!"
  PRINT
  PRINT " Mehr Spiele, Tools, QB und VB-Programme, kostenlose Musik, ... gibt's auf der"
  PRINT " Saga-Games Webseite!"
  DO: MouseStatus L, R, X, Y: LOOP UNTIL INKEY$ = "" AND L = 0 AND R = 0
  DO: MouseStatus L, R, X, Y: LOOP UNTIL LEN(INKEY$) OR L OR R
  SYSTEM
END SUB

SUB Button (Text$, Ypos)
  Text$ = " " + Text$ + " "
  Center SPACE$(LEN(Text$)), Ypos
  Center Text$, Ypos + 1
  Center SPACE$(LEN(Text$)), Ypos + 2
END SUB

'Text zentriert ausgeben
SUB Center (Mes$, Zeile)
  LOCATE Zeile, 40 - LEN(Mes$) \ 2
  PRINT Mes$
END SUB

SUB Credits
  PCOPY 0, 3
  DO: MouseStatus ML, MR, MX, MY: LOOP UNTIL ML = 0 AND MR = 0 AND INKEY$ = ""
  COLOR 15, 2: CLS
  Center " C  R  E  D  I  T  S ", 3
  RESTORE Texts
  SX = 81
  PCOPY 0, 2
  DO
    IF SX > 80 THEN
      READ T1$, T2$
      IF T1$ = "*" THEN RESTORE Texts: READ T1$, T2$
      IF LEN(T1$) > LEN(T2$) THEN
        StopIt = 40 - LEN(T1$) \ 2
        Add1 = 0: Add2 = (LEN(T1$) - LEN(T2$)) \ 2
        SX = -LEN(T1$)
      ELSE
        StopIt = 40 - LEN(T2$) \ 2
        Add1 = (LEN(T2$) - LEN(T1$)) \ 2: Add2 = 0
        SX = -LEN(T2$)
      END IF
      Lever = 0
    END IF
    SX = SX + 2
    SY = SIN(SX * .09) * 10 + 20
    IF SX >= StopIt AND Lever = 0 THEN St! = TIMER: Lever = 1: First = 0: OX = SX
   
    IF Lever = 1 THEN SX = OX
    IF (TIMER < St! OR TIMER > St! + 2) AND Lever = 1 THEN Lever = 2
   
'    PCOPY 2, 0
    Sparkle
'    PCOPY 0, 2
    printf T1$, SX + Add1, SY, 15
    printf T2$, SX + Add2, SY + 2, 15
    FOR Wdh = 1 TO 3
      WAIT &H3DA, 8
      WAIT &H3DA, 8, 8
    NEXT
    IF Lever <> 1 THEN
      LOCATE SY, 2: PRINT SPACE$(78);
      LOCATE SY + 2, 2: PRINT SPACE$(78);
    END IF
    IF Lever = 1 AND First = 0 THEN First = 1: LOCATE SY, 2: PRINT SPACE$(78); : LOCATE SY + 2, 2: PRINT SPACE$(78);
    MouseStatus ML, MR, MX, MY
  LOOP UNTIL LEN(INKEY$) OR ML OR MR
  DO: MouseStatus ML, MR, MX, MY: LOOP UNTIL ML = 0 AND MR = 0 AND INKEY$ = ""
  PCOPY 3, 0
END SUB

SUB MouseCursor STATIC
  MouseStatus L, R, X, Y
  IF OldY > 0 AND (OldY <> Y OR OldX <> X) THEN
    COLOR OldCharF, OldCharB
    LOCATE OldY, OldX
    PRINT CHR$(OldChar)
  END IF
  IF OldY = Y AND OldX = X THEN EXIT SUB
  OldX = X: OldY = Y
  OldChar = SCREEN(Y, X)
  OldCharF = SCREEN(Y, X, 1) MOD 16
  OldCharB = SCREEN(Y, X, 1) \ 16
  LOCATE Y, X
  Temp = SCREEN(Y, X, 1)
  IF Temp \ 16 <> 2 AND Y > 10 THEN COLOR 16, Temp \ 16 ELSE COLOR 0, Temp \ 16
  PRINT CHR$(24);
END SUB

'Maus
SUB MouseDriver (AX%, BX%, CX%, DX%)
  DEF SEG = VARSEG(MouseData$)
  Mouse% = SADD(MouseData$)
  CALL ABSOLUTE(AX%, BX%, CX%, DX%, Mouse%)
  DEF SEG
END SUB

'Maus
FUNCTION MouseInit%
  AX% = 0
  MouseDriver AX%, 0, 0, 0
  MouseInit% = AX%
END FUNCTION

'Maus
SUB MousePut (X%, Y%)
  MouseDriver 4, 0, X%, Y%
END SUB

'Maus
SUB MouseRange (X1%, Y1%, X2%, Y2%)
  MouseDriver 7, 0, X1%, X2%
  MouseDriver 8, 0, Y1%, Y2%
END SUB

'Maus
SUB MouseStatus (LB%, RB%, Xmouse%, Ymouse%)
  MouseDriver 3, BX%, CX%, DX%
  LB% = ((BX% AND 1) <> 0)
  RB% = ((BX% AND 2) <> 0)
  Xmouse% = CX% \ 8 + 1
  Ymouse% = DX% \ 8 + 1
END SUB

'text
SUB printf (Text$, X, Y, C)
  COLOR C, 2
  IF Y < 1 OR Y > 50 THEN EXIT SUB
  IF X + LEN(Text$) < 81 AND X > 0 THEN LOCATE Y, X: PRINT Text$; : EXIT SUB
  FOR W = 1 TO LEN(Text$)
    IF W + X > 0 AND X + W < 81 THEN LOCATE Y, X + W: PRINT MID$(Text$, W, 1);
  NEXT
END SUB

'Aus Nibbles.bas; angepasst
SUB Sparkle
  STATIC A
  COLOR 14, 2
  A$ = "*    *    *    *    *    *    *    *    *    *    *    *    *    *    *    *    *    "
  A = A + 1: IF A = 6 THEN A = 1
    LOCATE 1, 1
    PRINT MID$(A$, A, 80);
    LOCATE 50, 1
    PRINT MID$(A$, 6 - A, 80);
    FOR B = 2 TO 49
      C = (A + B) MOD 5
      IF C = 1 THEN
        LOCATE B, 80
        PRINT "*";
        LOCATE 51 - B, 1
        PRINT "*";
      ELSE
        LOCATE B, 80
        PRINT " ";
        LOCATE 51 - B, 1
        PRINT " ";
      END IF
    NEXT B

END SUB

'Eine der 32 Karten zeichnen
SUB ZeichneKarte (X, Y, Nummer)
  COLOR 0, 7
  LOCATE Y, X
  PRINT ""; STRING$(9, 196); "";
  FOR Y1 = Y + 1 TO Y + 15
    LOCATE Y1, X
    PRINT ""; STRING$(9, 32); "";
  NEXT
  LOCATE Y + 16, X
  PRINT ""; STRING$(9, 196); "";
  IF Nummer = 0 THEN
    COLOR 0
    LOCATE Y + 6, X + 2: PRINT "S";
    LOCATE Y + 8, X + 3: PRINT "A";
    LOCATE Y + 10, X + 4: PRINT "G";
    LOCATE Y + 12, X + 5: PRINT "A";
    COLOR 4
    LOCATE Y + 3, X + 4: PRINT "G";
    LOCATE Y + 5, X + 5: PRINT "A";
    LOCATE Y + 7, X + 6: PRINT "M";
    LOCATE Y + 9, X + 7: PRINT "E";
    LOCATE Y + 11, X + 8: PRINT "S";
    LOCATE Y + 1, X + 1: PRINT CHR$(16); "Credits"; CHR$(17);
    LOCATE Y + 15, X + 1: PRINT CHR$(16); "Credits"; CHR$(17);
    EXIT SUB
  END IF
  Wert1 = Karte(Nummer).Wert
  Wert2 = Karte(Nummer).Farbe
  IF Wert2 < 3 THEN COLOR 4 ELSE COLOR 0
  IF Wert1 = 11 THEN Z$ = " B"
  IF Wert1 = 12 THEN Z$ = " D"
  IF Wert1 = 13 THEN Z$ = " K"
  IF Wert1 = 14 THEN Z$ = " A"
  LOCATE Y + 1, X + 1: PRINT LTRIM$(Z$);
  LOCATE Y + 1, X + 8: PRINT Z$;
  LOCATE Y + 15, X + 1: PRINT LTRIM$(Z$);
  LOCATE Y + 15, X + 8: PRINT Z$;


  'Farbwert
  IF Wert2 = 1 THEN Z$ = CHR$(3)
  IF Wert2 = 2 THEN Z$ = CHR$(4)
  IF Wert2 = 3 THEN Z$ = CHR$(5)
  IF Wert2 = 4 THEN Z$ = CHR$(6)

  LOCATE Y + 3, X + 1: PRINT Z$;
  LOCATE Y + 3, X + 9: PRINT Z$;
  LOCATE Y + 13, X + 1: PRINT Z$;
  LOCATE Y + 13, X + 9: PRINT Z$;
  SELECT CASE Wert1
    CASE 11
      LOCATE Y + 2, X + 3: PRINT Z$;
      LOCATE Y + 14, X + 7: PRINT Z$;
      LOCATE Y + 5, X + 3: PRINT " ";
      LOCATE Y + 6, X + 3: PRINT "  ";
      LOCATE Y + 7, X + 3: PRINT "  ";
      LOCATE Y + 8, X + 3: PRINT "";
      LOCATE Y + 9, X + 3: PRINT "   ";
      LOCATE Y + 10, X + 3: PRINT "   ";
      LOCATE Y + 11, X + 3: PRINT "";
    CASE 12
      LOCATE Y + 2, X + 3: PRINT Z$;
      LOCATE Y + 14, X + 7: PRINT Z$;
      LOCATE Y + 5, X + 3: PRINT " ";
      LOCATE Y + 6, X + 3: PRINT " ";
      LOCATE Y + 7, X + 3: PRINT "  ";
      LOCATE Y + 8, X + 3: PRINT "  ";
      LOCATE Y + 9, X + 3: PRINT "  ";
      LOCATE Y + 10, X + 3: PRINT "  ";
      LOCATE Y + 11, X + 3: PRINT "";
    CASE 13
      LOCATE Y + 2, X + 3: PRINT Z$;
      LOCATE Y + 14, X + 7: PRINT Z$;
      LOCATE Y + 5, X + 3: PRINT "  ";
      LOCATE Y + 6, X + 3: PRINT "  ";
      LOCATE Y + 7, X + 3: PRINT " ";
      LOCATE Y + 8, X + 3: PRINT "";
      LOCATE Y + 9, X + 3: PRINT " ";
      LOCATE Y + 10, X + 3: PRINT "  ";
      LOCATE Y + 11, X + 3: PRINT "  ";
    CASE 14
      LOCATE Y + 8, X + 5: PRINT Z$;
  END SELECT
END SUB

