	page	59,130
;SETPAL.ASM	JUL-12-95
;Loren Blaney

cseg	segment dword public 'code'
	assume cs:cseg

;----------------------------------------------------------------------
;SetPal(Array);
;Routine to set all 16 palette registers. "Array' is a byte array with
; values in the range 0..$3F. (This routine is similar to BIOS Int $10,
; Fun $10, Subfun $02, but it is much faster.)
;
	public	setpal
setpal:
	pop	bx		;save return address
	pop	bp
	pop	si		;get address of Array
	push	bp		;restore return address
	push	bx

;get address of input status registers
	push	es		;save es
	xor	ax,ax		;segment of BIOS variables
	mov	es,ax
	mov	dx,es:[463h]	;fetch port address of CRTC
	add	dx,6		;port address of input status register

;load palette registers
	in	al,dx		;reset data/address flip flop
	jmp	short $+2
	mov	dx,3c0h		;port address of Attribute controller

	xor	ax,ax		;first palette register = 0
	mov	cx,16		;number of palette registers to set
	cld
setp10:	out	dx,al		;select palette register
	jmp	short $+2
	xchg	ah,al		;save palette register index
	lodsb			;al <- ds:si++
	out	dx,al		;set palette register
	jmp	short $+2
	xchg	ah,al		;restore index
	inc	al
	loop	setp10

	mov	al,20h		;turn Attribute Controller on
	out	dx,al

	pop	es		;restore registers
	retf

cseg	ends
	end
