	page	59,136
;TREKSND.ASM	JUL-25-92
;XPL external routines and interrupt handler for playing sound samples.
;
;REVISIONS:
;JUN-08-92, Original
;JUL-25-92, Added second channel, removed repeating sounds, sound samples
; must be less than 64K long.
;
;These routines use pulse-width modulation to overcome the impossible
; sound circuitry of the PC. The system timer interrupt rate is sped up
; from 18.2 Hz to 20,000 Hz, and the interrupt handler is modified to send
; a pulse to the speaker with a duration proportional to the amplitude of
; the waveform.
;
;Each byte in the sound sample specifies an instantaneous waveform ampli-
; tude from 0 to 60, thus 30 represents the base line. If bit 7 is set the
; sound will terminate in one of two ways:
;	0ffh		stop sound
; (Beware of small negative amplitudes terminating play.)

	public	setstv, resstv, playsnd1, playsnd2

cseg	segment word public 'code'
	assume	cs:cseg

align	2
stvec	dw	0,0			;original vector for interrupt 8
intctr	dw	0			;counter used to run original handler

sndseg1	dw	0			;segment of sound sample
sndoff1	dw	0			;offset to current place in sample
volume1	dw	0			;play loudest sound
sndseg2	dw	0			;segment of sound sample
sndoff2	dw	0			;offset to current place in sample
volume2	dw	0			;play loudest sound
alldone	db	0ffh			;sound sample terminator for start up

;----------------------------------------------------------------------
;External routine to save the original system timer interrupt vector (08h).
;
setstv:	push	ax			;save registers
	push	bx
	push	dx
	push	ds
	push	es

	sub	ax,ax			;set volume to off
	mov	cs:volume1,ax
	mov	cs:volume2,ax

	mov	ax, offset alldone	;point to sound terminator
	mov	sndoff1,ax
	mov	sndoff2,ax
	mov	sndseg1,cs
	mov	sndseg2,cs

	mov	cs:intctr,1092		;=65536/60

	mov	ax,3508h		;get current vector
	int	21h
	mov	cs:stvec,bx		;save it
	mov	cs:stvec+2,es

	push	ds
	lea	dx,sthan		;point to our interrupt handler
	mov	ax,seg sthan
	mov	ds,ax
	mov	ax,2508h		;set new vector
	int	21h
	pop	ds

	cli
	mov	al,36h			;set up 8253/8254 counter 0 for mode 3
	out	43h,al
	mov	ax,60			;1.19318MHz *50us = 60 (838ns per count)
	jmp	short $+2		;delay
	out	40h,al			;(this value also gives low noise due
	mov	al,ah			; to beating with the DMA refresh, which
	jmp	short $+2		; has a count of 18)
	out	40h,al

	mov	al,90h			;set up 8253/8254 counter 2 for read
	jmp	short $+2		;delay
	out	43h,al			; least sig byte only, mode 0, binary

	in	al,61h			;disable speaker
	and	al,0fch
	jmp	short $+2		;delay
	out	61h,al
	sti

	pop	es			;restore registers
	pop	ds
	pop	dx
	pop	bx
	pop	ax
	retf

;----------------------------------------------------------------------
;External routine to restore the system timer.
; No registers are destroyed.
;
resstv:	push	ax			;save all registers
	push	dx
	push	ds

	pushf				;save current interrupt status
	cli
	in	al,61h			;disable speaker
	and	al,0fch
	jmp	short $+2		;delay
	out	61h,al

	mov	al,36h			;set up 8253/8254 counter 0 for mode 3
	out	43h,al
	mov	ax,0			;1.19318MHz /65536 = 18.20648
	jmp	short $+2		;delay
	out	40h,al
	mov	al,ah
	jmp	short $+2		;delay
	out	40h,al
	popf				;restore interrupt status

	mov	ax,2508h		;restore original vector
	mov	dx,cs:stvec
	mov	ds,cs:stvec+2
	int	21h

	pop	ds			;restore registers
	pop	dx
	pop	ax
	retf

;----------------------------------------------------------------------
;External routine to start playing a sound sample.
; PLAYSND1(VOLUME, ARRAY);
; VOLUME determines which sound is played when there is more than one
; sound per channel. Sounds of equal or greater volume replace the current
; sound. ARRAY is the address of the sound sample divided by 16 (the paragraph).
; Destroys registers ax, bx, cx, dx and bp.
;
playsnd1:				;channel 1
	pop	bx			;pop return address
	pop	cx

	pop	dx			;pop "address" of sound sample
	pop	ax			;pop volume

	cmp	cs:volume1,ax		;is the current sound louder?
	jg	ps90			;jump if so - exit
	cli
	mov	cs:volume1,ax		;set volume for this sound
	mov	cs:sndseg1,dx		;set pointer for this sound
	mov	cs:sndoff1,0
	sti
	jmp	ps20

playsnd2:				;channel 2
	pop	bx			;pop return address
	pop	cx

	pop	dx			;pop "address" of sound sample
	pop	ax			;pop volume

	cmp	cs:volume2,ax		;is the current sound louder?
	jg	ps90			;jump if so - exit
	cli
	mov	cs:volume2,ax		;set volume for this sound
	mov	cs:sndseg2,dx		;set pointer for this sound
	mov	cs:sndoff2,0
	sti
ps20:
	in	al,61h			;make sure speaker is enabled
	or	al,03h
	jmp	short $+2		;delay
	out	61h,al

ps90:	push	cx			;restore return address
	push	bx
	retf

;----------------------------------------------------------------------
;New system timer interrupt handler for playing two sound samples.
;
sthan:	push	ax			;save registers
	push	bx
	push	ds

	mov	al,90h			;set up 8253/8254 counter 2 for read
	out	43h,al			; least sig byte only, mode 0, binary
					; (noisy if this is not done each time)
	mov	ds,cs:sndseg1		;point data segment to sound sample
	mov	bx,cs:sndoff1		;get offset to sound sample
	shr	bx,1			;divide by 2 cuz record rate was 10,000
	mov	al,[bx]			;get sound sample (it's played twice)
	adc	bx,bx			;restore bx (rcl bx,1 is 9 cycles on 386)
	test	al,al			;end of sound sample?
	jns	st40			;jump if not
	mov	word ptr cs:volume1,0	;set volume to off when sound is done

	mov	ds,cs:sndseg2		;point data segment to sound sample
	mov	bx,cs:sndoff2		;get offset to sound sample
	shr	bx,1			;divide by 2 cuz record rate was 10,000
	mov	ah,[bx]			;get sound sample (it's played twice)
	adc	bx,bx			;restore bx (rcl bx,1 is 9 cycles on 386)
	test	ah,ah			;end of sound sample?
	jns	st20			;jump if not
	mov	word ptr cs:volume2,0	;set volume to off when sound is done

st03:	mov	al,20h			;send end-of-interrupt (EOI) to 8259A
	out	20h,al

	dec	cs:intctr		;periodically call the original system
	jle	st07			; timer routine

st05:	pop	ds			;restore registers
	pop	bx
	pop	ax
	iret

st07:	mov	cs:intctr,1092		;=65536/60
	pushf				;fake int
	call	dword ptr cs:stvec
	jmp	short st05
st20:
	inc	bx			;increment offset
	mov	cs:sndoff2,bx		;save pointer for next interrupt
	mov	al,ah
	out	42h,al			;set low byte of counter 2 with sample
	jmp	short st03
st40:
	inc	bx			;increment offset
	mov	cs:sndoff1,bx		;save pointer for next interrupt

	mov	ds,cs:sndseg2		;point data segment to sound sample
	mov	bx,cs:sndoff2		;get offset to sound sample
	shr	bx,1			;divide by 2 cuz record rate was 10,000
	mov	ah,[bx]			;get sound sample (it's played twice)
	adc	bx,bx			;restore bx (rcl bx,1 is 9 cycles on 386)
	test	ah,ah			;end of sound sample?
	jns	st60			;jump if not

	out	42h,al			;set low byte of counter 2 with sample
	jmp	short st03
st60:
	inc	bx			;increment offset
	mov	cs:sndoff2,bx		;save pointer for next interrupt

	add	al,ah			;play two sound samples
	sub	al,30			;subtract base line (don't average)
	cmp	al,1
	jge	st63			;make sure values are in range
	mov	al,1
	jmp	short st66
st63:	cmp	al,60
	jl	st66
	mov	al,60
st66:
	out	42h,al			;set low byte of counter 2 with sample
	jmp	short st03

;----------------------------------------------------------------------

cseg	ends
	end
