	page	59,136
;TREKKB.ASM	JUN-08-92
;Replacement interrupt handler for the keyboard. This simply reports whether
; certain keys are pressed or released. These routines are generalized to
; work for XT's, AT's and 386 clones. (This kind of hardware information is
; hard to come by.)

	public	setkbv, reskbv, getkeys

cseg	segment byte public 'code'
	assume	cs:cseg, ds:dseg

;----------------------------------------------------------------------
;External routine to set keyboard interrupt vector (09h) to point to our
; handler.
; Destroys registers ax, bx, and dx.
;
setkbv:	mov	keydown,0		;assume all keys are released
	mov	byte ptr relflag,0

	push	es			;save registers
	push	ds

	mov	ax,3509h		;get current vector
	int	21h
	mov	kbvec,bx		;save it
	mov	kbvec+2,es

	lea	dx,kbhan		;point to our handler
	mov	ax,seg kbhan
	mov	ds,ax
	mov	ax,2509h		;set new vector
	int	21h

	pop	ds			;restore registers
	pop	es
	retf

;----------------------------------------------------------------------
;External routine to restore original keyboard interrupt vector.
; Destroys registers ax and dx.
;
reskbv:	push	ds			;save segment register

	mov	ax,2509h		;set original vector
	mov	dx,kbvec
	mov	ds,kbvec+2
	int	21h

	pop	ds			;restore segment register
	retf

;----------------------------------------------------------------------
;This new keyboard interrupt handler simply reports whether certain keys
; are pressed or released.
;
kbhan:	push	ax			;save registers
	push	bx
	push	cx
	push	ds

	mov	ax,dseg			;point to our data
	mov	ds,ax

	in	al,060h			;read scan code from keyboard
	mov	ch,al			;save it

	in	al,061h			;send acknowledge signal to keyboard
	or	al,080h			; by strobing the high bit
	out	061h,al
	and	al,07fh
	out	061h,al

	mov	al,20h			;send end-of-interrupt (EOI) to 8259A
	out	20h,al
	sti

	lea	bx,kbtbl		;point to scan code table
	mov	cl,nkeys		;set up loop counter

	cmp	byte ptr relflag,0ffh	;is release flag set (for AT's only)?
	je	kb50			;jump if so

	cmp	ch,0f0h			;is AT keyboard sending release code?
	jne	kb05			;jump if not
	mov	byte ptr relflag,0ffh	;set release flag
	jmp	kb90			;exit
kb05:
	or	ch,ch			;set status
	js	kb50			;jump if release code

;here if key was pressed
	mov	ax,00001h		;set bit
kb10:	cmp	ch,[bx]			;test for scan code
	jne	kb20			;jump if not recognized
	or	keydown,ax		;set bit corresponding to key
kb20:	rol	ax,1			;next bit position
	inc	bx			;next scan code
	dec	cl
	jne	kb10			;loop until all codes tested
	jmp	kb90			;exit

;here if key was released
kb50:	and	ch,07fh			;clear MSB to form pressed scan code
	mov	ax,0fffeh		;set up bit mask
kb60:	cmp	ch,[bx]			;test for scan code
	jne	kb70			;jump if not recognized
	and	keydown,ax		;clear bit corresponding to key
kb70:	rol	ax,1			;next bit position
	inc	bx			;next scan code
	dec	cl
	jne	kb60			;loop until all codes tested

	mov	byte ptr relflag,0	;clear release flag

kb90:	pop	ds			;restore registers
	pop	cx
	pop	bx
	pop	ax
	iret

;----------------------------------------------------------------------
;External routine to return the state of the keys.
; Destroys registers ax, bx, and cx.
;
getkeys:pop	ax			;pop return address
	pop	bx

	mov	cx,keydown		;push the key states
	push	cx

	push	bx			;restore return address
	push	ax
	retf

;----------------------------------------------------------------------

dseg	segment byte public 'data'

kbvec	dw	0,0			;original keyboard interrupt vector

nkeys	equ	13			;number of keys in kbtbl

;table of scan codes			;BIT	KEY
kbtbl	db	72			;0	up arrow
	db	80			;1	down arrow
	db	75			;2	left arrow
	db	77			;3	right arrow

	db	1			;4	escape
	db	15			;5	tab
	db	57			;6	space
	db	71			;7	7 key (upper left)

	db	73			;8	9 key (upper right)
	db	76			;9	5 key (down)
	db	79			;10	1 key (lower left)
	db	81			;11	3 key (lower right)

	db	29			;12	ctrl

keydown	dw	0			;bit is set if key is down
relflag	db	0			;flag for AT keyboards: key is released
dseg	ends

cseg	ends
	end
