\Hi-Q.XPL	16-Jan-2007	Loren Blaney	loren_blaney@idcomm.com
\Simple Peg Solitaire Game

inc	c:\cxpl\codesi;		\include code definitions for intrinsic routines

def	X0 = (40-9*2)/2,	\to center board on screen
	Y0 = (25-9*2)/2;

int	Board(9, 9);		\surrounding border facilitates error checking

\	   0   1   2   3   4   5   6   7   8
\	 0 .   .   .   .   .   .   .   .   .
\
\	 1 .   .   .   o   o   o   .   .   .
\
\	 2 .   .   .   o   o   o   .   .   .
\
\	 3 .   o   o   o   o   o   o   o   .
\
\	 4 .   o   o   o   o   o   o   o   .
\
\	 5 .   o   o   o   o   o   o   o   .
\
\	 6 .   .   .   o   o   o   .   .   .
\
\	 7 .   .   .   o   o   o   .   .   .
\
\	 8 .   .   .   .   .   .   .   .   .

def	Peg=$01, PegHot=$02, Hole=^o, Blank=^ ;		\items on board

int	CpuReg;			\address of CPU register array (from GetReg)



func	CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call software interrupt
int	Int, AX, BX, CX, DX, BP, DS, ES; \(unused arguments need not be passed)
begin
CpuReg:= GetReg;
CpuReg(0):= AX;
CpuReg(1):= BX;
CpuReg(2):= CX;
CpuReg(3):= DX;
CpuReg(6):= BP;
CpuReg(9):= DS;
CpuReg(11):= ES;
SoftInt(Int);
return CpuReg(0) & $FFFF;	\return contents of AX register
end;	\CallInt



proc	Beep;			\A not-too-obnoxious beep
begin
Sound(false, 1, 1000);		\synchronize with system timer to make tone a
Sound(true, 1, 3000);		\ consistent duration and a consistent sound.
end;	\Beep

\------------------------------- MOUSE ROUTINES --------------------------------

func	OpenMouse;		\Initializes mouse; returns 'false' if it fails
int	HaveMouse;
begin				\Pointer is set to center of screen but hidden
CallInt($21, $3533);		\Make sure mouse vector $33 points to something
HaveMouse:= false;
if ((CpuReg(1) ! CpuReg(11)) & $FFFF) = 0 then return false;
HaveMouse:= CallInt($33, $0000); \reset mouse and get status
if HaveMouse then HaveMouse:= true; \(beware of 'not' operator in 32-bit XPL)
return HaveMouse;		\return 'false' if failure
end;	\OpenMouse



proc	ShowMouse(On);		\Turn mouse pointer on or off
\The video mode should be set before calling this routine.
\This counts the number of times the pointer is turned on or off. If the
\ pointer is turned on twice, it must be turned off twice before it
\ actually goes off. The pointer should be turned off before drawing over
\ it and before your program exits. Setting the video mode will also turn
\ off the pointer.
int	On;	\flag: true = pointer on; false = pointer off
CallInt($33, if On then $0001 else $0002);



func	GetMousePosition(N); \Return position of specified mouse coordinate
int	N;	\0 = X coordinate; 1 = Y coordinate
\For video modes $0-$E and $13 the maximum coordinates are 639x199, minus
\ the size of the pointer. For modes $F-$12 the coordinates are the same as
\ the pixels. For 80-column text modes divide the mouse coordinates by 8 to
\ get the character cursor position.
begin
CallInt($33, $0003);
return (if N then CpuReg(3) else CpuReg(2)) & $FFFF;
end;	\GetMousePosition



func	GetMouseButton(N);	\Return 'true' if specified mouse button is down
int	N;	\button number: 0 = left; 1 = right (or middle)
begin
CallInt($33, $0003);
return if N then (CpuReg(1)&2)=2 else (CpuReg(1)&1)=1;
end;	\GetMouseButton

\-------------------------------------------------------------------------------

proc	Exit;		\Exit program gracefully
begin
Attrib($025B);
Text(6, "

 No more moves. Hit any key to exit...");
if ChIn(1) then [];
ShowMouse(false);
SetVid(3);			\restore normal text mode (for DOS)
exit;
end;	\Exit



func	AllDone;	\Return 'true' if there are no more moves
int	X, Y;
begin
for Y:= 0, 8 do				\for all board locations...
    for X:= 0, 8 do
	if Board(X, Y)   = Peg  &	\and adjacent peg and beyond that a hole
	   ((Board(X+1, Y) = Peg & Board(X+2, Y) = Hole) !
	    (Board(X-1, Y) = Peg & Board(X-2, Y) = Hole) !
	    (Board(X, Y+1) = Peg & Board(X, Y+2) = Hole) !
	    (Board(X, Y-1) = Peg & Board(X, Y-2) = Hole)) then
		return false;
return true;
end;	\AllDone



proc	ShowBoard;	\Display the board
int	X, Y, C;
begin
ShowMouse(false);
for Y:= 0, 8 do
    for X:= 0, 8 do
	begin
	Cursor(2*X+X0, 2*Y+Y0);
	C:= Board(X, Y);		\get character
	if C # Blank then
		begin
		Attrib(if C = PegHot then $5B28 else $5B17);
		ChOut(6, C);
		end;
	end;
ShowMouse(true);
end;	\ShowBoard



proc	SelectHole;	\Select hole, make move, and show board
int	X, Y,
	Mx, My;
begin
loop	begin
	repeat if ChkKey then Exit	\wait for mouse button
	until GetMouseButton(0);
	Mx:= GetMousePosition(0)/16;
	My:= GetMousePosition(1)/8;

	X:= (Mx-X0)/2;
	Y:= (My-Y0)/2;

	while GetMouseButton(0) do [];	\wait for mouse button to be released

	\Make move if it is legal: if hole is 2 spaces away from PegHot and
	\ there is a peg in between
	if Board(X, Y) = Hole then
	    begin	
	    case of
	      Board(X+1, Y) = Peg & Board(X+2, Y) = PegHot:
	      	begin
	      	Board(X, Y):= Peg;
	      	Board(X+1, Y):= Hole;
	      	Board(X+2, Y):= Hole;
	      	quit;
	      	end;
	      Board(X-1, Y) = Peg & Board(X-2, Y) = PegHot:
		begin
		Board(X, Y):= Peg;
		Board(X-1, Y):= Hole;
		Board(X-2, Y):= Hole;
		quit;
		end;
	      Board(X, Y+1) = Peg & Board(X, Y+2) = PegHot:
		begin
		Board(X, Y):= Peg;
		Board(X, Y+1):= Hole;
		Board(X, Y+2):= Hole;
		quit;
		end;
	      Board(X, Y-1) = Peg & Board(X, Y-2) = PegHot:
		begin
		Board(X, Y):= Peg;
		Board(X, Y-1):= Hole;
		Board(X, Y-2):= Hole;
		quit;
		end
	    other Beep;
	    end
	else Beep
	end;	\loop
end;	\SelectHole



proc	SelectPeg;	\Select a legal peg to move and make it Hot
int	X, Y,		\board position of selected peg
	Mx, My;
begin
loop	begin
	repeat if ChkKey then Exit	\wait for mouse button
	until GetMouseButton(0);
	Mx:= GetMousePosition(0)/16;
	My:= GetMousePosition(1)/8;

	X:= (Mx-X0)/2;
	Y:= (My-Y0)/2;

	while GetMouseButton(0) do [];	\wait for mouse button to be released

	if Board(X, Y)   = Peg &	\and adjacent peg and beyond that a hole
	   ((Board(X+1, Y) = Peg & Board(X+2, Y) = Hole) !
	    (Board(X-1, Y) = Peg & Board(X-2, Y) = Hole) !
	    (Board(X, Y+1) = Peg & Board(X, Y+2) = Hole) !
	    (Board(X, Y-1) = Peg & Board(X, Y-2) = Hole)) then
		begin
		Board(X, Y):= PegHot;
		ShowBoard;		\show the hot peg
		quit;
		end
	else	Beep;
	end;
end;	\SelectPeg



proc	Init;		\Initialize
int	X, Y;
begin
\Set up mouse
if not OpenMouse then
	begin
	Text(0, "This program requires a mouse.");
	exit;
	end;

for Y:= 0, 8 do
    for X:= 0, 8 do
	Board(X, Y):= Blank;

for Y:= 3, 5 do
    for X:= 1, 7 do
	Board(X, Y):= Peg;

for Y:= 1, 7 do
    for X:= 3, 5 do
	Board(X, Y):= Peg;

Board(4, 4):= Hole;

SetVid($13);

\Initialize board and background colors

for Y:= 0, 200-1 do			\fill screen with green
    for X:= 0, 320-1 do
	Point(X, Y, $02);

Attrib($5B00);				\ivory background for board's color
for Y:= 1, 15 do
    for X:= 5, 11 do
	begin
	Cursor(X+X0, Y+Y0);
	ChOut(6, ^ );
	end;
for Y:= 5, 11 do
    for X:= 1, 15 do
	begin
	Cursor(X+X0, Y+Y0);
	ChOut(6, ^ );
	end;

ShowMouse(true);
end;	\Init

\-------------------------------------------------------------------------------

begin	\Main
Init;
repeat	ShowBoard;
	SelectPeg;
	SelectHole;
until	AllDone;
ShowBoard;
Exit;
end;	\Main
