{$M 1536,0,13824}
{$DEFINE debugText}

{
	1.5k stack + 13.5k heap = 15k
	Dos 2.0 on 64k system leaves 40k available
	so that's 25k free for code
}


program paku;

uses
	jfunc,
	keyboard,
	timer,
	sound,
	txtGraph;

type
	gameSprite=object
		tile:integer;
		cSprite:pSprite;
		constructor init(sx,sy,sTile:integer);
	end;
	tPlayer=object(gameSprite)
		direction,inputDirection,waka,wakaDir:integer;
		lastInputDirX:boolean;
		constructor init;
		procedure reset;
		procedure update;
	end;
	pGhost=^tGhost;
	tGhost=object(gameSprite)
		direction,inputDirection,
		tileOffset,activeTileOffset,
		logic,
		mode,
		frame,
		fleeCounter,
		exitCounter,
		homeX,homeY:integer;
		inJail:boolean;
		constructor init(sLogic:integer);
		procedure reset;
		procedure update;
	end;
	tGhostData=record
		cx,cy,d,hx,hy:integer;
	end;
	tLevelData=record
		symbol,points,rate,frightTime,flashes:integer;
	end;
	tBehavior=record
		behavior,time:word;
	end;
	tBehaviorList=array[0..7] of tBehavior;

const
	dir_up    = 0;
	dir_right = 1;
	dir_down  = 2;
	dir_left  = 3;

	mode_scatter = 0;
	mode_chase   = 1;
	mode_flee    = 2;
	mode_eaten    = 3;

	jail_left   = 33;
	jail_right  = 52;
	jail_top    = 38;
	jail_bottom = 44;

	fieldOffsetX=1;
	fieldWidth=28;
	fieldEndX=fieldWidth*3+fieldOffsetX;
	textCenter=fieldEndX+(160-fieldEndX) div 2;

	sirenLookup:array[0..23] of word=(
		440,466,494,523,554,587,622,659,698,740,784,831,
		880,831,784,740,698,659,622,587,554,523,494,466
	);

	ghostData:array[0..3] of tGhostData=(
		(cx:40;	cy:32; d:dir_left; hX:fieldWidth*3; hY:5),
		(cX:41; cY:41; d:dir_up;   hX:fieldWidth*3; hY:85),
		(cX:33; cY:39; d:dir_down; hX:1; hY:5),
		(cX:48; cY:43; d:dir_down; hX:1; hY:85)
	);

	levelData:array[1..21] of tLevelData=(
		(symbol:$38; points:100;  rate:6; frightTime:1320; flashes:600),
		(symbol:$39; points:300;  rate:5; frightTime:1200; flashes:600),
		(symbol:$3A; points:500;  rate:5; frightTime:1080; flashes:600),
		(symbol:$3A; points:500;  rate:5; frightTime:960;  flashes:600),

		(symbol:$3B; points:700;  rate:4; frightTime:840;  flashes:600),
		(symbol:$3B; points:700;  rate:4; frightTime:1320; flashes:600),
		(symbol:$3C; points:1000; rate:4; frightTime:840;  flashes:600),
		(symbol:$3C; points:1000; rate:4; frightTime:840;  flashes:600),

		(symbol:$3D; points:2000; rate:4; frightTime:480;  flashes:360),
		(symbol:$3D; points:2000; rate:4; frightTime:1200; flashes:600),
		(symbol:$3E; points:3000; rate:4; frightTime:840;  flashes:600),
		(symbol:$3E; points:3000; rate:4; frightTime:480;  flashes:360),

		(symbol:$3F; points:5000; rate:4; frightTime:480; flashes:360),
		(symbol:$3F; points:5000; rate:4; frightTime:960; flashes:600),
		(symbol:$3F; points:5000; rate:4; frightTime:480; flashes:360),
		(symbol:$3F; points:5000; rate:4; frightTime:480; flashes:360),

		(symbol:$3F; points:5000; rate:4; frightTime:0;   flashes:0),
		(symbol:$3F; points:5000; rate:4; frightTime:480; flashes:360),
		(symbol:$3F; points:5000; rate:4; frightTime:0;   flashes:0),
		(symbol:$3F; points:5000; rate:4; frightTime:0;   flashes:0),

		(symbol:$3F; points:5000; rate:5; frightTime:0;   flashes:0)
	);

	behaviorLevel1:tBehaviorList=(
		(behavior:mode_scatter; time:420),
		(behavior:mode_chase; time:1200),
		(behavior:mode_scatter; time:420),
		(behavior:mode_chase; time:1200),
		(behavior:mode_scatter; time:300),
		(behavior:mode_chase; time:1200),
		(behavior:mode_scatter; time:300),
		(behavior:mode_chase; time:0)
	);
	behaviorLevel2_4:tBehaviorList=(
		(behavior:mode_scatter; time:420),
		(behavior:mode_chase; time:1200),
		(behavior:mode_scatter; time:420),
		(behavior:mode_chase; time:1200),
		(behavior:mode_scatter; time:300),
		(behavior:mode_chase; time:65535),
		(behavior:mode_scatter; time:1),
		(behavior:mode_chase; time:0)
	);
	behaviorLevel5Plus:tBehaviorList=(
		(behavior:mode_scatter; time:300),
		(behavior:mode_chase; time:1200),
		(behavior:mode_scatter; time:300),
		(behavior:mode_chase; time:1200),
		(behavior:mode_scatter; time:300),
		(behavior:mode_chase; time:65535),
		(behavior:mode_scatter; time:1),
		(behavior:mode_chase; time:0)
	);

var
	score,
	highScore:longint;

	lives,level,truncLevel,
	dots,
	ghostMode,
	nextGhost,
	behaviorStep,
	behaviorCounter,
	globalDotCounter,
	globalJailCounter,
	globalFleeCounter,
	siren,pakuSound,
	frameSpeed,
	timerInterval:word;

	globalJailCounterEnable:boolean;

	map,
	mapTiles,
	spriteTiles:tileset;

	fonts:fontSet;
	numbers:numberSet;

	tileMap:array[0..30,0..fieldWidth-1] of byte;

	player:tPlayer;
	ghost:array[0..3] of tGhost;
	ghostScoreBg:array[0..3] of pointer;

procedure scorePoints(points:longint);
begin
	score:=score+points;
	numbers.outDecimal(textCenter-16,23,score,1);
	if (score>highScore) then begin
		highScore:=score;
		numbers.outDecimal(textCenter-16,9,highScore,1);
	end;
end;

constructor gameSprite.init(sx,sy,sTile:integer);
begin
	tile:=sTile;
	cSprite:=tg_addSprite(sx,sy,tile,5,@spriteTiles);
end;

constructor tPlayer.init;
begin
	gameSprite.init(40,68,$42);
	reset;
end;

procedure tPlayer.reset;
begin
	with cSprite^ do begin
		currentX:=40;
		currentY:=68;
		currentTile:=$4C;
	end;
	direction:=3;
	inputdirection:=3;
	waka:=0;
end;

procedure tPlayer.update;
var
	mx,my,
	tx,ty,
	dCount,oldDirection:integer;
	t:word;

	procedure eatDot;
	begin
		tileMap[ty,tx]:=$28;
		pakuSound:=6;
		scorePoints(10);
		tg_eraseUnderSprite(tx*3+1,ty*3,tx*3+3,ty*3+2);
		dec(dots);
		globalDotCounter:=0;
		if globalJailCounterEnable then begin
			inc(globalJailCounter);
			if globalJailCounter>7 then begin
				ghost[2].exitCounter:=0;
				if globalJailCounter>14 then begin
					ghost[3].exitCounter:=0;
				end;
			end;
		end else begin
			t:=0;
			repeat
				with ghost[t] do begin
					if inJail and (exitCounter>0) then begin
						dec(exitCounter);
						t:=4;
					end else inc(t);
				end;
			until t>=4;
		end;
	end;

begin
	with (cSprite^) do begin

		dCount:=1;
		oldDirection:=direction;

		mx:=currentX mod 3;
		my:=(currentY+1) mod 3;

		tx:=(currentX+1) div 3;
		ty:=(currentY+1) div 3;

		case tileMap[ty,tx] of
			$20:eatDot;
			$21:begin
				eatDot;
				globalFleeCounter:=levelData[truncLevel].frightTime;
				for t:=0 to 3 do with ghost[t] do begin
					if (
						not(inJail) and
						not(mode=mode_eaten)
					) then begin
						mode:=mode_flee;
						direction:=(direction+2) mod 4;
						fleeCounter:=globalFleeCounter;
					end;
				end;
			end;
		end;

		case direction of
			dir_up,dir_down:begin
				case inputDirection of
					dir_up,dir_down:direction:=inputDirection;
					else if (my=0) then begin
						case inputDirection of
							dir_right:if tileMap[ty,tx+1]>0 then direction:=1;
							dir_left:if tileMap[ty,tx-1]>0 then direction:=3;
						end;
					end;
				end;
			end;
			dir_left,dir_right:begin
				case inputDirection of
					dir_left,dir_right:direction:=inputDirection;
					else if (mx=0) then begin
						case inputDirection of
							dir_up:if tileMap[ty-1,tx]>0 then direction:=0;
							dir_down:if tileMap[ty+1,tx]>0 then direction:=2;
						end;
					end;
				end;
			end;
		end;

		if not(direction=oldDirection) then inc(dCount);
		case direction of
			dir_up:if my=0 then begin
				if tileMap[ty-1,tx]>0 then dec(currentY,dCount) else waka:=4;
			end else dec(currentY);
			dir_right:if mx=0 then begin
				if tileMap[ty,tx+1]>0 then inc(currentX,dCount) else waka:=4;
			end else inc(currentX);
			dir_down:if my=0 then begin
				if tileMap[ty+1,tx]>0 then inc(currentY,dCount) else waka:=4;
			end else inc(currentY);
			dir_left:if mx=0 then begin
				if tileMap[ty,tx-1]>0 then dec(currentX,dCount) else waka:=4;
			end else dec(currentX);
		end;

		currentTile:=$40+direction*4+waka div 2;
	end;

	waka:=(waka+1) mod 8;

end;

constructor tGhost.init(sLogic:integer);
begin
	logic:=sLogic;
	cSprite:=tg_addSprite(0,0,0,5,@spriteTiles);
	reset;
end;

procedure tGhost.reset;
begin
	tileOffset:=logic*8;
	activeTileOffset:=tileOffset;
	frame:=0;
	with cSprite^ do with ghostData[logic] do begin
		direction:=d;
		homeX:=hx;
		homeY:=hy;
		currentX:=cx;
		currentY:=cy;
		mode:=mode_scatter;
		currentTile:=activeTileOffset+(frame div 4)+direction*2;
		exitCounter:=0;
		case logic of
			2:if level=1 then inc(exitCounter,30);
			3:if level=1 then inc(exitCounter,60) else inc(exitCounter,50);
		end;
	end;
	inputDirection:=direction;
end;

procedure tGhost.update;
var
	dx,dy,
	adx,ady,
	sdx,sdy,
	mx,my,
	tx,ty,
	howFar:integer;
	jailSkip:boolean;
begin
	with (cSprite^) do begin
		mx:=currentX mod 3;
		my:=(currentY+1) mod 3;

		tx:=(currentX+1) div 3;
		ty:=(currentY+1) div 3;

		inJail:=(
			(currentX>=jail_left) and
			(currentX<=jail_right) and
			(currentY>=jail_top) and
			(currentY<=jail_bottom)
		);

		if (inJail) then begin

			if (mode=mode_eaten) and (currentY<jail_bottom) then begin
				inc(currentY);
				if (currentY=jail_bottom) then begin
					mode:=mode_scatter;
				end;
			end else begin

				if exitCounter>0 then case currentY of
					jail_top:begin
						direction:=dir_down;
						inc(currentX);
					end;
					jail_bottom:begin
						direction:=dir_up;
						dec(currentX);
					end;
				end else begin
					case currentX of
						jail_left..39:direction:=dir_right;
						41..jail_right:direction:=dir_left;
						40:direction:=dir_up;
					end;
				end;

				case direction of
					dir_up:dec(currentY);
					dir_right:inc(currentX);
					dir_down:inc(currentY);
					dir_left:dec(currentX);
				end;
			end;

		end else begin

			howFar:=1;
			jailSkip:=false;

			case mode of
				mode_scatter:begin
					dx:=homeX-currentX;
					dy:=homeY-currentY;
				end;
				mode_chase:begin
					dx:=player.cSprite^.currentX-currentX;
					dy:=player.cSprite^.currentY-currentY;
				end;
				mode_flee:begin
					dx:=currentX-player.cSprite^.currentX;
					dy:=currentY-player.cSprite^.currentY;
					dec(fleeCounter,frameSpeed);
					if (fleeCounter<=0) then mode:=ghostMode;
				end;
				mode_eaten:begin
					if (
						((currentX=40) or (currentX=41)) and
						(currentY>=31) and
						(currentY<jail_bottom)
					) then begin
						direction:=dir_down;
						jailSkip:=true;
					end else begin
						dx:=40-currentX;
						dy:=32-currentY;
						inc(howFar);
					end;
				end;
			end;

			if not(jailSkip) then begin

				adx:=abs(dx);
				ady:=abs(dy);

				case direction of
					dir_up:if (my=0) then begin
						if (adx>ady) or (tileMap[ty-1,tx]=0) or (dy>0) then begin
							if dx>0 then begin
								if tileMap[ty,tx+1]>0 then begin
									direction:=dir_right;
								end else if (tileMap[ty,tx-1]>0) and (tileMap[ty-1,tx]=0) then begin
									direction:=dir_left;
								end;
							end else begin
								if tileMap[ty,tx-1]>0 then begin
									direction:=dir_left;
								end else if (tileMap[ty,tx+1]>0) and (tileMap[ty-1,tx]=0) then begin
									direction:=dir_right;
								end;
							end;
						end;
					end;
					dir_down:if (my=0) then begin
						if (adx>ady) or (tileMap[ty+1,tx]=0) or (dy<0) then begin
							if dx>0 then begin
								if tileMap[ty,tx+1]>0 then begin
									direction:=dir_right;
								end else if (tileMap[ty,tx-1]>0) and (tileMap[ty+1,tx]=0) then begin
									direction:=dir_left;
								end;
							end else begin
								if tileMap[ty,tx-1]>0 then begin
									direction:=dir_left;
								end else if (tileMap[ty,tx+1]>0) and (tileMap[ty+1,tx]=0) then begin
									direction:=dir_right;
								end;
							end;
						end;
					end;
					dir_left:if (mx=0) then begin
						if (ady>adx) or (tileMap[ty,tx-1]=0) or (dx>0) then begin
							if dy>0 then begin
								if tileMap[ty+1,tx]>0 then begin
									direction:=dir_down;
								end else if (tileMap[ty-1,tx]>0) and (tileMap[ty,tx-1]=0) then begin
									direction:=dir_up;
								end;
							end else begin
								if tileMap[ty-1,tx]>0 then begin
									direction:=dir_up;
								end else if (tileMap[ty+1,tx]>0) and (tileMap[ty,tx-1]=0) then begin
									direction:=dir_down;
								end;
							end;
						end;
					end;
					dir_right:if (mx=0) then begin
						if (ady>adx) or (tileMap[ty,tx+1]=0) or (dx<0) then begin
							if dy>0 then begin
								if tileMap[ty+1,tx]>0 then begin
									direction:=dir_down;
								end else if (tileMap[ty-1,tx]>0) and (tileMap[ty,tx+1]=0) then begin
									direction:=dir_up;
								end;
							end else begin
								if tileMap[ty-1,tx]>0 then begin
									direction:=dir_up;
								end else if (tileMap[ty+1,tx]>0) and (tileMap[ty,tx+1]=0) then begin
									direction:=dir_down;
								end;
							end;
						end;
					end;
				end;
			end;

			case direction of
				dir_up:if my=0 then begin
					if tileMap[ty-1,tx]>0 then dec(currentY,howfar);
				end else dec(currentY);
				dir_right:if mx=0 then begin
					if tileMap[ty,tx+1]>0 then inc(currentX,howfar);
				end else inc(currentX);
				dir_down:if my=0 then begin
					if (tileMap[ty+1,tx]>0) or jailSkip then inc(currentY,howfar);
				end else inc(currentY);
				dir_left:if mx=0 then begin
					if tileMap[ty,tx-1]>0 then dec(currentX,howfar);
				end else dec(currentX);
			end;

		end;
		case mode of
			mode_eaten:currentTile:=$30+(frame div 4)+direction*2;
			mode_flee:if (
				(fleeCounter<levelData[truncLevel].flashes) and
				((fleeCounter mod 120) div 60=0)
			) then begin
				currentTile:=$28+(frame div 4)+direction*2;
			end else currentTile:=$20+(frame div 4)+direction*2;
			else currentTile:=activeTileOffset+(frame div 4)+direction*2;
		end;
	end;
	frame:=(frame+1) mod 8;
end;

procedure setupTileMap;
var
	px,py,t:word;
	mapOffset,storeOffset:pTileData;
	c:byte;
begin
	mapOffset:=map.dataStart;
	storeOffset:=pTileData(@tileMap);
	while not(mapOffset=map.dataEnd) do begin
		if (mapOffset^ and $80)=$80 then begin
			{
				bit 7 set, bottom bits holds how many times
				to repeat next byte. Store the repeat and move
				the pointer ahead one.
			}
			c:=mapOffset^ and $7F;
			inc(mapOffset);
		end else c:=1; { otherwise it's just 1 raw data byte }
		while c>0 do begin
			case mapOffset^ of
				$20,$21,$28:storeOffset^:=mapOffset^;
				else storeOffset^:=0;
			end;
			inc(storeOffset);
			dec(c);
		end;
		inc(mapOffset);
	end;
end;

procedure loadData;
var
	t:word;
begin
	writeln('Loading Data');
	map.init('MAP');
	mapTiles.init('MAPTILES');
	spriteTiles.init('SPRITES');
	fonts.init('FONTS');
	numbers.init('HEXNUM');
	setupTileMap;
	writeln('Initializing Sprites System');
	for t:=0 to 3 do begin
		ghost[t].init(t);
		getmem(ghostScoreBg[t],30);
	end;
	player.init;
	writeln;
	write('Starting Timer');
	startTimer;
	writeln(' - Complete');
	write('Starting Sound');
	startSound;
	writeln(' - Complete');
	writeln('Loading complete!');
	highScore:=0;
	timerInterval:=getUserClockInterval(120);
	{$IFDEF debugText}
	writeln;
	writeln('Largest Dos Block Free: ',largestDosMemBlock);
	writeln('Heap Free: ',memavail);
	writeln('Stack Free:',freeStack);
	{$ENDIF}
	writeln('Press any key to continue');
	waitkey;
end;

procedure cleanup;
var
	t:word;
begin
	writeln('graphics shutdown - Complete');
	write('Halting Sound');
	killSound;
	writeln(' - Complete');
	write('Halting Timer');
	killTimer;
	writeln(' - Complete');
	write('Releasing Memory');
	for t:=0 to 3 do begin
		freemem(ghostScoreBg[t],30);
	end;
	numbers.term;
	fonts.term;
	spriteTiles.term;
	mapTiles.term;
	map.term;
	writeln(' - Complete');
end;

procedure showLives;
var
	t,x:word;
begin
	t:=1;
	x:=4;
	while (t<lives) do begin
		tg_tile5(x,94,spriteTiles.dataStart,$4C);
		inc(x,6);
		inc(t);
	end;
	tg_bar(x,94,23,99,0);
end;

{ map is stored RLE, so we need to decode that }
procedure drawPlayfield;
var
	px,py:word;
	mapOffset:pTileData;
	c:byte;

begin
	px:=fieldOffsetX;
	py:=0;
	mapOffset:=map.dataStart;
	while not(mapOffset=map.dataEnd) do begin
		if (mapOffset^ and $80)=$80 then begin
			{
				bit 7 set, bottom bits holds how many times
				to repeat next byte. Store the repeat and move
				the pointer ahead one.
			}
			c:=mapOffset^ and $7F;
			inc(mapOffset);
		end else c:=1; { otherwise it's just 1 raw data byte }
		while (c>0) do begin
			tg_tile3(px,py,mapTiles.dataStart,mapOffset^);
			inc(px,3);
			if (px>=fieldEndX) then begin
				px:=fieldOffsetX;
				inc(py,3);
				if (py>93) then py:=0;
			end;
			dec(c);
		end;
		inc(mapOffset);
	end;
end;

procedure redrawPlayfield;
var
	px,py:word;
	mapOffset:pTileData;
	c:byte;

begin
	px:=fieldOffsetX;
	py:=0;
	mapOffset:=map.dataStart;
	while not(mapOffset=map.dataEnd) do begin
		if (mapOffset^ and $80)=$80 then begin
			{
				bit 7 set, bottom bits holds how many times
				to repeat next byte. Store the repeat and move
				the pointer ahead one.
			}
			c:=mapOffset^ and $7F;
			inc(mapOffset);
		end else c:=1; { otherwise it's just 1 raw data byte }
		while (c>0) do begin
			if not(mapOffset^=$20) and not(mapOffset^=$21) then begin
				tg_tile3(px,py,mapTiles.dataStart,mapOffset^);
			end;
			inc(px,3);
			if (px>=fieldEndX) then begin
				px:=fieldOffsetX;
				inc(py,3);
				if (py>93) then py:=0;
			end;
			dec(c);
		end;
		inc(mapOffset);
	end;
end;


{ requires playfield to be drawn }
procedure whitePlayField; assembler;
asm
	mov  cx,$3AC0
	mov  ax,$B800
	mov  es,ax
	mov  di,1
	mov  dx,$0301
	mov  bx,$3010
@loop:
	mov  al,es:[di]
	mov  ah,al
	and  ah,dh
	cmp  ah,dl
	jne  @compare2
	or   al,$07
@compare2:
  mov  ah,al
	and  ah,bh
	cmp  ah,bl
	jne  @writeIt
	or   al,$70
@writeIt:
  stosb
  inc  di
  loop @loop
end;

procedure resetSprites;
var
	t:word;
begin
	for t:=0 to 3 do ghost[t].reset;
	player.reset;
end;

procedure setupPlayfield;
var
	t,n,x:word;
	b:byte;
begin
	resetSprites;
	setupTileMap;
	tg_clear(0);
	drawPlayField;
	fonts.outtextCentered(textCenter,3,'High Score');
	fonts.outtextCentered(textCenter,17,'Your Score');
	x:=76;
	t:=level;
	if (t>9) then begin
		n:=9;
	end else n:=t;
	while (n>0) do begin
		if (t>21) then begin
			b:=levelData[21].symbol;
		end else b:=levelData[t].symbol;
		tg_tile5(x,94,spriteTiles.dataStart,b);
		x:=x-6;
		dec(n);
		dec(t);
	end;
	scorePoints(0);
	showLives;
	tg_showSprites;
end;

procedure waitNoReset(ticks:word);
begin
	repeat
		if userClockCounter>timerInterval then begin
			userClockCounter:=userClockCounter-timerInterval;
			dec(ticks);
		end;
	until ticks<=0;
end;

procedure wait(ticks:word);
begin
	userClockCounter:=0;
	waitNoReset(ticks);
end;

procedure behaviorUpdate;
var
	t:word;
begin
	case level of
		1:begin
			behaviorCounter:=behaviorLevel1[behaviorStep].time;
			ghostMode:=behaviorLevel1[behaviorStep].behavior;
		end;
		2..4:begin
			behaviorCounter:=behaviorLevel2_4[behaviorStep].time;
			ghostMode:=behaviorLevel2_4[behaviorStep].behavior;
		end;
		else begin
			behaviorCounter:=behaviorLevel5Plus[behaviorStep].time;
			ghostMode:=behaviorLevel5Plus[behaviorStep].behavior;
		end;
	end;
	for t:=0 to 3 do with ghost[t] do begin
		if (
			not(inJail) and
			not(mode=mode_flee) and
			not(mode=mode_eaten)
		) then mode:=ghostMode;
	end;
	if (behaviorStep<7) then inc(behaviorStep);
end;

procedure message(txt:st40; time:integer);
begin
	fonts.outtextCentered(44,50,txt);
	wait(time);
	tg_bar(32,50,56,54,0);
end;

procedure testCollisions;
var
	dx,dy,xx,tx:integer;
	t,n:word;
begin
	for t:=0 to 3 do with ghost[t] do begin
		dx:=abs(cSprite^.currentX-player.cSprite^.currentX);
		if (dx<2) then begin
			dy:=abs(cSprite^.currentY-player.cSprite^.currentY);
			if (dy<2) then begin
				case mode of
					mode_flee:begin
						scorePoints(nextGhost);
						tx:=cSprite^.currentX-2;
						if (nextGhost>999) then dec(tx,2);
						xx:=tx;
						for n:=0 to 2 do begin
							tg_getBackground5(xx,cSprite^.currentY,ghostScoreBg[n]);
							xx:=xx+6;
						end;
						numbers.outDecNonPadded(tx,cSprite^.currentY,nextGhost,1);
						waitNoReset(120);
						for n:=0 to 2 do begin
							tg_restoreBackground5(tx,cSprite^.currentY,ghostScoreBg[n]);
							tx:=tx+6;
						end;
						nextGhost:=nextGhost*2;
						mode:=mode_eaten;
					end;
					mode_chase,mode_scatter:begin
						setVoice(0,0,0,0);
						setVoice(1,0,0,0);
						player.cSprite^.hide;
						for n:=0 to 3 do ghost[n].cSprite^.hide;
						with player.cSprite^ do begin
							tg_getBackground5(currentX,currentY,ghostScoreBg[0]);
						end;
						n:=0;
						repeat
							if userClockCounter>timerInterval then begin
								case n of
									0..80:setVoice(0,880-n*5+trunc(220*sin(n/1.5)),32,0);
									85,100:setVoice(0,0,0,0);
									90,110:setVoice(0,55,48,0);
								end;
								with player.cSprite^ do begin
									tg_waitRetrace;
									tg_restoreBackground5(currentX,currentY,ghostScoreBg[0]);
									tg_tile5(
										currentX,currentY,
										spriteTiles.dataStart,
										$50+n div 15
									);
								end;
								userClockCounter:=userClockCounter-timerInterval;
								inc(n);
							end;
						until n>=120;
						setVoice(0,0,0,0);
						wait(45);
						with player.cSprite^ do begin
							tg_restoreBackground5(currentX,currentY,ghostScoreBg[0]);
						end;
						wait(60);
						dec(lives);
						showLives;
						if (lives>0) then begin
							resetSprites;
							tg_showSprites;
							message('READY!',120);
						end else begin
							message('GAME OVER',240);
						end;
					end;
				end;
			end;
		end;
	end
end;

procedure gameLoop;
var
	ch:char;
	t,frameThrottle,altThrottle:word;
begin

	pakuSound:=0;
	siren:=0;
	score:=0;
	level:=0;
	lives:=3;
	ch:=' ';

	repeat

		dots:=244;

		inc(level);

		if (level>21) then truncLevel:=21 else truncLevel:=level;

		setupPlayfield;

		message('READY!',120);

		frameSpeed:=levelData[truncLevel].rate;
		frameThrottle:=frameSpeed-1;

		userClockCounter:=0;

		globalJailCounterEnable:=false;
		globalJailCounter:=0;
		globalDotCounter:=0;

		behaviorStep:=0;
		behaviorUpdate;
		altThrottle:=0;

		nextGhost:=200;

		repeat

			if userClockCounter>timerInterval then begin

				userClockCounter:=userClockCounter-timerInterval;

				frameThrottle:=(frameThrottle+1) mod frameSpeed;

				if frameThrottle=0 then begin
					tg_waitRetrace;
					tg_updateSprites;
					player.update;
					for t:=0 to 3 do ghost[t].update;
					testCollisions;
				end;

				if (globalDotCounter<120) then begin
					inc(globalDotCounter);
				end else begin
					globalDotCounter:=0;
					if ghost[2].exitCounter>0 then dec(ghost[2].exitCounter);
					if ghost[3].exitCounter>0 then dec(ghost[3].exitCounter);
				end;

				if (globalFleeCounter>0) then begin
					dec(globalFleeCounter);
					if globalFleeCounter=0 then nextGhost:=200;
				end;

				inc(altThrottle);
				if (altThrottle and $01)=0 then begin
					dec(behaviorCounter);
					if (behaviorCounter=0) then behaviorUpdate;
				end;
				{sound handler }

				if (frameThrottle and $01)=0 then begin
					siren:=(siren+1) mod 24;
					setVoice(0,sirenLookup[siren],32,0);
				end;
				if (pakuSound>0) then begin
					dec(pakuSound);
					case pakuSound of
						1..6:setVoice(1,340+pakusound*$20,40,1);
						0:setVoice(1,0,0,0);
					end;
				end;

			end;
			if keypressed then begin
				ch:=readkey;
				case ch of
					'w','W':player.inputDirection:=0;
					'd','D':player.inputDirection:=1;
					's','S':player.inputDirection:=2;
					'a','A':player.inputDirection:=3;
					#0:begin
						ch:=readkey;
						case ch of
							#$48:player.inputDirection:=0;
							#$4D:player.inputDirection:=1;
							#$50:player.inputDirection:=2;
							#$4B:player.inputDirection:=3;
						end;
					end;
					#27:lives:=0;
					#32:begin
						for t:=0 to 3 do ghost[t].mode:=mode_eaten;
					end;
				end;
			end;
		until (lives=0) or (dots=0);

		setVoice(0,0,0,0);
		setVoice(1,0,0,0);

		if (dots=0) then begin
			frameThrottle:=0;
			repeat
				wait(30);
				case frameThrottle of
					3:begin
						for t:=0 to 3 do ghost[t].cSprite^.hide;
						tg_bar(jail_left,jail_top,jail_right,jail_bottom+5,0);
					end;
					4,6,8:whitePlayField;
					5,7,9:redrawPlayField;
				end;
				inc(frameThrottle);
			until frameThrottle>11;
		end;

		player.cSprite^.hide;

	until (level=0) or (lives=0);
end;

begin
	loadData;
	tg_init;
	gameloop;
	tg_term;
	cleanup;
end.