unit jfunc;

interface

type
	dosExt=string[3];
	dosName=string[8];
	hexWordString=string[4];
	hexLongString=string[8];
	st10=string[10];
	st40=string[40];
	st80=string[80];
	st255=string[255];

function freeStack:word;
function strint(n:longint; digits:byte):st10;
function largestDosMemBlock:longint;
function word2Hex(v:word):hexWordString;
function long2Hex(v:longint):hexLongString;
function strLead(n:longint; digits:byte):st10;

implementation

const
  hexChar:array[0..15] of char=(
  	'0','1','2','3','4','5','6','7',
  	'8','9','A','B','C','D','E','F'
  );

function freeStack:word; assembler;
asm
	mov  ax,sp
end;

function largestDosMemBlock:longint; assembler;
asm
	mov  ax,$4800
	mov  bx,$FFFF { 1 meg, impossible }
	int  $21
	xor  dx,dx
	mov  ax,bx
	mov  bx,16
	mul  bx
end;

function strint(n:longint; digits:byte):st10;
var
  st:st10;
begin
  str(n:digits,st);
  strint:=st;
end;

function strLead(n:longint; digits:byte):st10;
var
	st:st10;
	ln:longint;
	decdig:byte;
begin
	st:='';
	decDig:=digits;
	ln:=n;
	while (decDig>0) do begin
		st:=chr((n mod 10)+48)+st;
		n:=n div 10;
		dec(decDig);
	end;
	strLead:=st;
end;

function word2Hex(v:word):hexWordString;
var
	t,n:word;
  s:string;
begin
	t:=0;
	s:='';
	n:=v;
	for t:=0 to 3 do begin
		s:=hexChar[n and $0F]+s;
		n:=n shr 4;
	end;
  word2hex:=s;
end;

function long2Hex(v:longint):hexLongString;
var
	t:word;
	n:longint;
  s:string;
begin
	t:=0;
	s:='';
	n:=v;
	for t:=0 to 7 do begin
		s:=hexChar[n and $0F]+s;
		n:=n shr 4;
	end;
  long2Hex:=s;
end;


end.