\TTT.XPL	22-Apr-2004	Loren Blaney		loren_blaney@idcomm.com
\Program to play Tic-Tac-Toe
\
\The computer marks its moves with an "O" and the player uses an "X". The
\ numeric keypad is used to make the player's move.
\
\                         7  8  9
\                        
\                         4  5  6
\                        
\                         1  2  3
\
\The player always goes first, but the 0 key is used to skip a move. Thus
\ it can be used to let the computer play first.


inc	\cxpl\codesi;	\Intrinsic routine definitions

def	X0=16, Y0=10;	\Coordinates of character in upper-left square

int	I0,
	PMove,		\Player's move (^0..^9)
	Key;		\Keystroke
int	X, O;		\Bit arrays for player and computer
			\ bit 0 corresponds to playing square 1, etc.


func	CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call software interrupt
int	Int, AX, BX, CX, DX, BP, DS, ES; \(Unused arguments need not be passed)
int	CpuReg;
begin
CpuReg:= Getreg;
CpuReg(0):= AX;
CpuReg(1):= BX;
CpuReg(2):= CX;
CpuReg(3):= DX;
CpuReg(6):= BP;
CpuReg(9):= DS;
CpuReg(11):= ES;
Softint(Int);
return CpuReg(0);		\return AX register
end;	\CallInt



proc	HLine(X, Y);	\Draw a horizontal line
int	X, Y;
int	I;
begin
Cursor(X, Y);
for I:= 0, 10 do Chout(0, ^);
end;	\HLine



proc	VLine(X, Y);	\Draw a vertical line over the horizontal line
int	X, Y;
int	I;
begin
for I:= 0, 4 do
	begin
	Cursor(X, Y+I);
	Chout(0, if I&1 then ^ else ^);
	end;
end;	\VLine



func	Won(p);		\Return 'true' if player P has won
int	P;
int	T, I;
begin
T:= [$007, $038, $1C0, $049, $092, $124, $111, $054];
for I:= 0, 7 do
    if (P & T(I)) = T(I) then return true;
return false;
end;	\Won



func	Cats;		\Returns 'true' if no more moves available (Cat's game)
begin
if (X ! O) = $1FF then
	begin
	Cursor(17, 20);
	Text(0, "A draw!");
	return true;
	end;
return false;
end;	\Cats



proc	DoMove(P, M, Ch);	\Make move in player's bit array and display it
int	P,		\Address of player's bit array
	M,		\Index 0..8 where bit is placed
	Ch;
int	I, X, Y;
begin
P(0):= P(0) ! 1<<M;	\make move

I:= M / 3;		\display move
X:= Rem(0) * 4;
Y:= (2-I) * 2;
Cursor(X+X0, Y+Y0);
Chout(0, Ch);
end;	\DoMove



func	Try(P);
\Returns the value of the best node for player P
int	P;		\Address of player's bit array
int	P1, I, I0, V, V0;
begin
P1:= if P = addr X then addr O else addr X;

if Won(P1(0)) then return -1;
if (X ! O) = $1FF then return 0;

V0:= -1;				\assume the worst
for I:= 0, 8 do				\for all of the squares
    if ((O!X) & 1<<I) = 0 then		\if square is unused
	begin
	P(0):= P(0) ! 1<<I;		\make tenative move
	V:= -(extend(Try(P1)));		\get value
	if V > V0 then			\save best value
		[V0:= V; I0:= I];
	P(0):= P(0) & ~(1<<I);		\undo tenative move
	end;
return V0 & $FF ! I0<<8;
end;	\Try



proc	PlayGame;	\Play one game
int	I, V, V0;
begin
Chout(0, $0C);		\Clear screen
HLine(X0-1, Y0+1);	\Draw grid
HLine(X0-1, Y0+3);
VLine(X0+2, Y0);
VLine(X0+6, Y0);

X:= 0;   O:= 0;				\initialize player's arrays to empty

loop	begin
	\#################### GET PLAYER'S MOVE (X) ####################
	loop	begin
		PMove:= Chin(1);
		if PMove = $1B\Esc\ then
			[SetVid(3); exit];    \clear screen and restore cursor
		if PMove = ^0 then quit;

		\Check for legal move (optional)
		if PMove>=^1 & PMove<=^9 & 
		   ((X!O) & 1<<(PMove-^1)) = 0 then quit;
		end;

	if PMove # ^0 then
		begin
		DoMove(addr X, PMove-^1, ^X);
		if Won(X) then
			begin
			Cursor(17, 20);
			Text(0, "X wins!");
			quit;
			end;
		end;

	if Cats then quit;

	\#################### GET COMPUTER'S MOVE (O) ####################

	I0:= Try(addr O) >>8;

	DoMove(addr O, I0, ^O);		\do best move

	if Won(O) then
		begin
		Cursor(17, 20);
		Text(0, "O wins!");
		quit;
		end;

	if Cats then quit;
	end;
end;	\PlayGame



begin	\Main
SetVid(1);
CallInt($10, $0100, 0, $2000);		\turn off flashing cursor
loop	begin
	PlayGame;

	Key:= Chin(1);
	if Key = $1B\Esc\ then
		[SetVid(3); exit];    \clear screen and restore cursor
	end;
end;	\Main
