#################################################
#Patchfile for Commander Keen 9			#
#################################################


#################################################################################################
#GENERAL GAME PATCHES										#
#################################################################################################
#NOTES:						#
#Patches have overwritten F10 + D and F10 + S	#
#cheats, possibly more.				#
#################################################

#################################################
#FILES						#
#################################################

%ext ck5
%egahead EGAHEAD.CK5		#New graphics
%maphead maphead.ck5		#New levels
%gamemaps editmaps.ck5		#Change level names to 'editmaps'
%patchfile $25B22 keen9.tli	#New tile properties
%patchfile $20cd7 ck5load.bin 	#New DOS screen
%patchfile $21C80 AUDIOHED.CK5	#Audio header
%patchfile $35EC4 AUDIODCT.CK5	#Audio dictionary
%patchfile $1FDE0 "STORY.CK5"	#'star wars text' story



#################################################
#LEVEL NAMES					#
#################################################

#World Map
%patch $20040 "The Universe" $00
%patch $201F0 "Keen determinedly" $0A " searches the Universe!" $00
%patch $30605 "Exit to the Universe" $00

#Level 1
%patch $20050 "HUB Command Center" $00
%patch $20220 "Keen lands in the " $0A "HUB Command Center" $00

#Level 2
%patch $20070 "Shivonia City" $00
%patch $20250 "Keen charges into" $0A "Shivonia City" $00

#Level 3
%patch $20080 "VitaCorp" $00
%patch $20280 "Keen investigates" $0A "VitaCorp" $00

#Level 4
%patch $200A0 "Defense Tower Surth" $00
%patch $202B0 "Keen invades" $0A "Defense Tower Surth" $00

#Level 5
%patch $200C0 "Fort Yetisburg" $00
%patch $202E0 "Keen addresses" $0A "Fort Yetisburg" $00

#Level 6
%patch $200E0 "Jotundra Mountains" $00
%patch $20310 "Keen storms up the" $0A "Jotundra Mountains" $00

#Level 7
%patch $20100 "Frosthool Station" $00
%patch $20340 "Keen chills out in" $0A "Frosthool Station" $00

#Level 8
%patch $20120 "The Depleted Tunnels" $00
%patch $20370 "Keen combs the" $0A "Depleted Tunnels" $00

#Level 9
%patch $20140 "The Crater" $00
%patch $203A0 "Keen falls into" $0A "The Crater" $00

#Level 10
%patch $20160 "Altaire Station" $00
%patch $203D0 "Keen barges into" $0A "Altaire Station" $00

#Level 11
%patch $20180 "Elevator Access Station" $00
%patch $20400 "Keen captures the" $0A "Elevator Access Station" $00

#Level 12
%patch $201A0 "The Krodacian Overlabs" $00
%patch $20440 "Keen raids" $0A "The Krodacian Overlabs" $00

#Level 13
%patch $201C0 "Mort's Workshop"
%patch $20470 "Keen snoops around" $0A "Mortimer's Workshop" $00

#Level 14
%patch $201D0 "Defense Hall M"
%patch $204A0 "Keen races down" $0A "Defense Hall M" $00

#Level 15
%patch $201E0 "The Warpcore"
%patch $204D0 "Keen battles" $0A "Mortimer McMire" $0A "in the Warpcore" $00

# Used when Keen enters Korath
%patch $30563 "Keen steps into" $0A
              "Mortimer's backyard" $00



#################################################
#MISC						#
#################################################

#Fix highscore level 'bug'
%patch $5B8A $10

#Secret level:
#Change secret level to level 12 and make it so just exiting the level in any way
#will trigger alt. e.
%patch $EC31 $36	#Level 12 (28 + 24 = 54)
%patch $EC33 $01 $72	#Just win level to get secret ending

#Change the location of elevator doors so they don't cause trouble
%patch $F451 $0002W 	#First elevator start h loc
%patch $F455 $0000W	#First elevator start v loc
%patch $F460 $0002W 	#First elevator destination h loc
%patch $F464 $0000W	#First elevator destination v loc
%patch $F497 $0002W	#Main elevator start h loc
%patch $F49B $0000W	#Main elevator start v loc
%patch $F4B2 $0002W	#Main elevator destination h loc
%patch $F4B6 $0000W	#Main elevator destination v loc

# Stop mapkeen from walking down on exiting teleporter
%patch $D669 $90 $90 $90 # stop y motion
%patch $7A79  $EB
#no walking animation
%patch $D66E $90 $90 $90 $90 $90 $90 $90 $90 
$90 $90 $90 $90 $90 $90 $90 $90 
$90 $90 $90 $90 $90 $90 $90 $90 
$90 $90

#stop extra hop at end
#%patch $D5AD $00

#################################################
#MUSIC						#
#################################################

#Change number of songs:
%patch $8C61 $00BBW
%patch $8BF1 $BF3BW
%patch $8BFF $BF3BW
%patch $8CF5 $BF3BW

#This is the music played in each level:
#             VALUE   LEVEL                      MUSIC PLAYED            LEVEL No
%patch $3067A $03 $00 #Map                       (World map)               0
              $04 $00 #Ion Ventilation System    ()                        1
              $05 $00 #Security Center           ()                        2
              $06 $00 #Defense Tunnel Vlook      ()                        3
              $07 $00 #Energy Flow Systems       ()                        4
              $08 $00 #Defense Tunnel Burrh      ()                        5
              $09 $00 #Regulation Control Center ()                        6
              $0A $00 #Defense Tunnel Sorra      ()                        7
              $0B $00 #Neutrino Burst Injector   ()                        8
              $0C $00 #Defense Tunnel Teln       ()                        9
              $0D $00 #Brownian Motion Inducer   ()                        10
              $0E $00 #Gravitational Damping Hub ()                        11
              $0F $00 #Quantum Explosion Dynamo  ()                        12
              $00 $00 #Korath III Base           ()                        13
              $10 $00 #Defense hall
              $11 $00 #BWBMegarocket             (?)                       14
              $01 $00 #Ending                    (Fanfare)
              $01 $00 #High Scores               (High Scores)             15
%patch $3069C $02 $00 #Scrolling Story           (Armageddon Machine)
              $01 $00 #Game Over                 (Came In)
              $02 $00 #Help                      (Help)

# Xky3 "Airline: Backwater"
# Genius314 botb4
# genius314 Jazz1
# kosmyn alien dance
# thc Level 315
# xky squeel

# 00 - Secret
# 01 - Mischief
# 02 - short requiem
# 03 - tuit
# 04 - shikadi rock pt 2
# 05 - shikadiville
# 06 - Jazz
# 07 - Alien Dance
# 08 - reflections
# 09 - quantum racing
# 0A - backwater
# 0B - xky2
# 0C - spaced out
# 0D - level 315
# 0E - Into the Void
# 0F - Alien Abduction
# 10 - Into the Reactor
# 11 - Leaky Gremlin
# 12 - Forever Keen
# 13


#################################################
#SOUNDS						#
#################################################

#Use Keen land sound for something else
%patch $C87D  $01			#Keen land (Use map walk, free up sound)
%patch $CB4F  $01			#Keen land (Use map walk, free up sound)
%patch $10F93 $25			#Pink shot shot uses different sound from Cybloog
%patch $129FC $1C			#Spindred slam into ground from roof
%patch $12A0A $1C			#Spindred small ceiling bounce
%patch $12A49 $1C			#Spindred slam into ceiling from floor
%patch $12A57 $1C			#Spindred small floor bounce
%patch $13784 $3B			#Sphereful uses just one sound
%patch $135E0 $19			#Shocksund shot hit stuff (Change to $19)
%patch $12E20 $90 $90 $90 $90 $90	#Remove yeti shot hit ground
%patch $13035 $90 $90 $90 $90 $90	#Disable yeti shot sound



#################################################
#TEXT PATCHES					#
#################################################

#---HIGH SCORES---
%patch $33D56 "Ceilick          "
%patch $33D96 "Lemm             "
%patch $33DD6 "Levellass        "
%patch $33E16 "Mink             "
%patch $33E56 "Mobiethian       "
%patch $33E96 "Mr. M            "
%patch $33ED6 "Tulip            "
%patch $33F16 "XkyRauh          "

#Status bar
%patch $30907 "KEYS" $00 
              "AMMO" $00 
              "KEENS" $00 
              "ORBS   " $00 



#################################################################################################
#SPRITE PATCHES											#
#################################################################################################
#NOTES:						#
#Fuses need Spindreds in their levels for proper#
#sprite caching. Red, Master, Shik and Ampton	#
#code are highly mixed and can affect each other#
#We have a new enemy, the 'Korathoid' which	#
#replaces still sitting goplats.		#
#################################################


#################################################
#AMPTON (YETI)					#
#################################################

#Ampton walks about like a Shikadi, throwing the Master's shot when in
#front of a special tile. This affects the Master and Shikadi code

#Ampton Walks like a Shikadi (See: Shikadi)
%patch $330D8 $110202ABRL	#First frame
%patch $330F6 $110202ABRL	#Second frame
%patch $33114 $110202ABRL	#Third frame
%patch $33132 $110202ABRL	#Fourth frame
%patch $8260  $EB
#Patch Shikadi code so Ampton doesn't become a Shikadi: (See: Shikadi)
%patch $12FC3 $21DCW		#Ampton walk (Randomly when Ampt is walking)
%patch $13029 $2B6CW		#Shikadi master shoot (When passing pole)
%patch $32EE6 $21DCW		#Ampton walk (After master shooting)

#Patch Master code so Ampton doesn't become a Master after shooting:
%patch $32EC0 $11020615RL	#Shooting when shot
%patch $32EDE $11020615RL	#Shooting when seeing Keen

#Patch Shikadi code so Ampton doesn't look for and follow Keen (At all)
%patch $12F6B $EB $1B

#Change Master's shot anim so it fits with the Ampton
%patch $32F60 $01A2W $01A1W	#Frame 1
%patch $32F7E $01A1W $01A2W	#Frame 2
%patch $32F9A $2C20W		#Use only 2 frames

#Change Shooting Master anim so it fits with the Ampton
%patch $32EAC $019AW $019AW	#Frame 1
%patch $32ECA $019BW $019BW	#Frame 2

#Change Ampton turning frame to fit Ampton walk
%patch $32594 $019AW $019AW #308

#Master's shot (Yeti's snowball) changes Keen's actions instead of killing him
%patch $12DC3 $C7 $44 $1C $31EEW

#Ampton throws snowballs when in front of this tile (Changes pole sliding code)
%patch $1301D $2A

#Change how fast Ampton shoots
%patch $32EB6 $0008W        #Pause before shooting
%patch $32ED4 $001EW        #Shoot time

#Ampton shoots only when Keen is level with him
%patch $12F57 $0000W
%patch $12FA6 $75

#Ampton takes 3 hits to kill (By Lemm)
%patch $11635 $55 $8B $EC $56 $57 $8B $76 $06 $8B $7E $08 $83 $3D $02 $75 $09
              $9A $0AAF1517RL     $5F $5E $5D $CB
                                                  $83 $3D $03 $75 $F7 $FF $4C #New Stuff STarts here
              $40 $83 $7C $40 $FD $7F $1B $B8 $16 $00 $50 $9A $196E09EFRL     #Hits = 3 ($FD)
              $44 $44 $B8 $9E $23 $50 $57 $56 $9A $090B16CDRL     $83 $C4 $06 #Change sound to 16
              $EB $D3 $C7 $44 $42 $01 $00 $57 $9A $0CCB10B3RL     $44 $44 $EB
              $EF
%patch $1170D $EA $11C415CDRL  

#Ampton shoooting bug fix:
#Create special walk frames from extra Master's shot actions:
%patch $32F9C $019CW $0195W $00000000L  $0001W $0008W $0080W $0000W
              $00000000L    $11C41403RL $11020679RL   $2C7AW
%patch $32FBA $019DW $0196W $00000000L  $0001W $0008W $0080W $0000W
              $00000000L    $11C41403RL $11020679RL   $21DCW
%patch $32EE6 $2C5CW #Ampton walk special (After master shooting)



#################################################
#FUSE\Q.E.D (KEEN'S FRIENDS AND WARPCORE)	#
#################################################

#The fuse is also the Q.E.D. The Q.E.D level is level 15.
#Fuses can be broken by Shocksund shots or Keen running into them
#Fuses are invisible. Fuses will display 1 of 4 messages depending on
#what level Keen is in. Fuses need Spindred in-level to cache their
#sprites or an error will occur.
#
#The messages are Spot in level 2, Lindsey in level 5, Barker in level 11
#and Janitor in any other level (Here level 8)
#SIDE EFFECT: Keen can destroy the Warpcore by touching it


#Time after fuse\Q.E.D broken before windows appear or game ends:
%patch $31E8A $0001W
%patch $8260  $EB
#Fuse action, uses frame 321 (Appears invisible, but things can touch it)
%patch $334C6 $01A7W $01A7W $0001W $00000000L $0008W $0000W $0000W
              $00000000L    $00000000L        $11C418CBRL   $3186W

#Change Spindred cache to hold fuse animation
%patch $31A46 $01A7W		#Spindred cache start (1 earlier)
%patch $31A9A $01ABW		#Cache end

#Always make fuse\Q.E.D visible
%patch $F10C $90 $90
%patch $7A79  $EB

#Replace fuse counter check with new Fuse window code
%patch $CAA7 $55 $8B $EC $83 $3E $55 $9E $0F $75 $08 $C7 $06 $70 $6F $0F $00
             $5D $CB $B8 $03 $00 $50 $9A $EF $09 $196ERW $83 $C4 $02 $9A $018BW
                 $06B9RW $9A $56 $0D $174ERW $5D $CB

#Sprite uses new behavior (Due to space limitations)
%patch $31E90 $B7 $1F $0AAFRW

#Fuse only does Q.E.D tile replacement in level 15 ($0F) ------V
%patch $120AE $83 $3C $19 $74 $03 $E9 $88 $00 $83 $3E $68 $6F $0F $75 $71 $FF $74
              $2E $FF $74 $2C $9A $28
              $06 $0F92RW $83 $C4 $04 $FF $74 $2E $FF $74 $30 $9A $28 $06 $0F92RW
                  $83 $C4 $04 $FF $74 $32 $FF $74 $2C $9A $28 $06 $0F92RW $83
              $C4 $04 $FF $74 $32 $FF $74 $30 $9A $28 $06 $0F92RW $83 $C4 $04
              $B8 $02 $00 $50 $B8 $04 $00 $50 $B8 $0B $00 $50 $B8 $10 $00 $50
              $33 $C0 $50 $50 $9A $75 $0D $174ERW $83 $C4 $0C $B8 $02 $00 $50
              $B8 $04 $00 $50 $B8 $0D $00 $50 $B8 $10 $00 $50 $33 $C0 $50 $B8
              $04 $00 $50 $9A $75 $0D $174ERW $83 $C4 $0C $9A $77 $06 $0F92RW
              $56 $9A $47 $1E $06B9RW $83 $C4 $02 $5E $5D $CB

#Fuse window, 4 messages, cache 5 bitmaps
%patch $6D1B  $55 $8B $EC $9A $FB $0A $196ERW $B8 $2B7BRW $8A $16 $EC $6F $8E
              $C0 $26 $08 $16 $2C $00 $8E $C0 $26 $08 $16 $2D $00 $8E $C0 $26
              $08 $16 $2E $00 $8E $C0 $26 $08 $16 $2F $00 $8E $C0 $26 $08 $16
              $5B $00 $33 $C0 $50 $9A $48 $18 $13A0RW $83 $C4 $02 $9A $95 $09
              $1E00RW $B8 $08 $00 $50 $B8 $1A $00 $50 $9A $6E $10 $1A2BRW $83
              $C4 $04 $83 $3E $68 $6F $05 $75 $1C $83 $2E $99 $9B $30 $B8 $2E
              $00 $50 $FF $36 $46 $9E $A1 $9B $9B $03 $06 $99 $9B $50 $9A $75
              $0C $1E00RW $EB $60 $83 $3E $68 $6F $0B $75 $1C $83 $2E $99 $9B
              $30 $B8 $2C $00 $50 $FF $36 $46 $9E $A1 $9B $9B $03 $06 $99 $9B
              $50 $9A $75 $0C $1E00RW $EB $3D $83 $3E $68 $6F $02 $75 $1C $83
              $2E $99 $9B $30 $B8 $2F $00 $50 $FF $36 $46 $9E $A1 $9B $9B $03
              $06 $99 $9B $50 $9A $75 $0C $1E00RW $EB $1A $83 $2E $99 $9B $30
              $B8 $2D $00 $50 $FF $36 $46 $9E $A1 $9B $9B $03 $06 $99 $9B $50
              $9A $75 $0C $1E00RW

#Level-text pointers and rest of window code (To $6E93)
%patch $6DF0                      $83 $C4 $06 $83 $06 $9D $9B $0C $83 $3E $68
              $6F $05 $75 $0E $B8 $3766W  $50 $9A $BB $0E $1A2BRW $83 $C4 $02
              $EB $36 $83 $3E $68 $6F $0B $75 $0E $B8 $37C1W  $50 $9A $BB $0E
              $1A2BRW $83 $C4 $02 $EB $21 $83 $3E $68 $6F $02 $75 $0E $B8 $37F8W
                  $50 $9A $BB $0E $1A2BRW $83 $C4 $02 $EB $0C

              $B8 $18BBW  $50 $9A $BB $0E $1A2BRW $83 $C4 $02 $9A $97 $0A $1E00RW
                  $B8 $1E $00 $50 $9A $DF $0A $1F03RW $83 $C4 $02 $9A $A5 $08 $155ARW
                  $9A $DC $0E $155ARW $B8 $5B $00 $50 $FF $36 $46 $9E $A1 $9B $9B
              $03 $06 $99 $9B $50 $9A $75 $0C $1E00RW $83 $C4 $06 $9A $97 $0A $1E00RW
                  $B8 $1E $00 $50 $9A $DF $0A $1F03RW $83 $C4 $02 $9A $A5 $08 $155ARW
              $9A $DC $0E $155ARW $5D $CB


#Level 5
%patch $33AA6 "Princess Lindsey says:" $0A $0A
              "You won't be able to " $0A
              "defeat Mortimer with" $0A
              "your stunner alone!" $00

#Level 11
%patch $33B01 "Lt. Barker says:" $0A $0A
              "Beware of the" $0A
              "Krodacian Overlords!" $00

#Level 2
%patch $33B38 "Spot says:" $0A $0A
              "The Shikadi are" $0A
              "invincible while" $0A
              "climbing poles!" $00

#Any other level (Level 8)
%patch $31BFB "Oracle Janitor says:" $0A $0A
              "There's something" $0A
              "mysterious beneath the" $0A
              "giant crater." $00

#------------------------------ MULTIPLE QEDs WITH HEALTH --------------
#Patch Updated QED Action in place of original
%patch $334C6 -1W -1W 0W 0W 1W 8W $80W 0W
0L $090B0DD8RL 0L
#QED Spawn includes health
%patch $139B4 $C7 $47 $40 $0002W

#New QED Sprite Collision 
%patch $9E88
$55 #push bp
$8B $EC #mov bp, sp
$56 #push si 

#checkspr:
$8B $76 $08 #mov si, [bp+8]
$83 $3C $04 #cmp [si+0], TYPE_MORTSHOT
$74 $03 #je dechealth
$5E $5D $CB #pop bp; ret;


#dechealth:
$B8 $E0 $2F #mov ax, A_BARKSHOTDIE0
$50 #push ax 
$56 #push si
$9A $090B1242RL #call checkground2
$83 $C4 $04 #add sp, 4
$C7 $44 $00 $0000W #mov spritetype, 0
#$56 #push si 
#$9A $0CCB10B3RL #call stunnerhits
#$44 $44
$8B $76 $06 #mov si, [bp+6]
$FF $4C $40 #dec [si+objtype.time]
$74 $03 #jz asplode
$5E $5D $CB #pop bp; ret;

#asplode:
#spawn QED explosions
$FF $74 $2E
$FF $74 $2C
$9A $0F920628RL
$83 $C4 $04

$FF $74 $2E
$FF $74 $30
$9A $0F920628RL
$83 $C4 $04

$FF $74 $32
$FF $74 $2C
$9A $0F920628RL
$83 $C4 $04

$FF $74 $32
$FF $74 $30
$9A $0F920628RL
$83 $C4 $04



#replacetileblock
$68 $0003W #push 3 ; h
$68 $0003W #push 2 ; w
$FF $74 $2E #push [si+boxTY1] ; ydest
$FF $74 $2C #push [si+boxTX0] ; xdest
$68 $0001W #push 1 ; fgplane
$FF $36 $9E51W #push [mapsegs+2] : src seg
$68 $20W #push $20 ; src offs !ASSUME tile 20 is clear!
$9A $174E0F25RL #call ReplaceTiles
$83 $C4 $0E #add sp, 0Eh

#Remove Object
$56 #push si
$9A $06B91E47RL #call RemoveObj
$44 $44 #inc sp inc sp

$FF $0E $5E $6F #dec [Fuse1]
$74 $03 #jz endgame
$5E $5D $CB #pop bp; ret;

#endgame:
$9A $0F920677RL #call LevelEndSpawn
$5E $5D $CB #pop bp; ret;

#destruction of Qeds not to win game
%patch $F112 $05

#################################################
#GOPLAT (KORATHOID				#
#################################################

#This replaces the still red goplats that appear ONLY on E, M or H
#The new code overwritesthe demo cheat

#Alter properties of platform spawn to spawn new enemy
%patch $10620 $17 $00		#Sprite type
%patch $1064D $0E $FF $FF	#Initial direction, left (NOT RANDOM!)
%patch $1063B $05 $80 $FF	#Spawn height (Half a tile up)
%patch $10651 $359DW		#Platforms now spawn new enemy

#Korathoid has EMH, Hplat always appear, Mplat on m,h and Eplat on h
%patch $F0BE $02 $7F
%patch $F0A1 $01 $7F
%patch $7A79  $EB

#Replace F10-D cheat code with Korath code (Now with Keen seeking)
%patch $645B $CB $55 $8B $EC $56 $8B $76 $06 $9A $1DFB0036RL     $3D $10 $00
             $7D $28 $C7 $06 $85 $BF $00 $00 $9A $1DFB0036RL     $8B $44 $0A
             $8B $1E $3E $9E $3B $47 $0A $76 $07 $C7 $44 $0E $FF $FF $EB $05
             $C7 $44 $0E $01 $00 $C7 $44 $1C $3694W  $5E $5D $CB $55 $8B $EC
             $56 $57 $8B $7E $06 $8B $76 $08 $83 $3C $02 $75 $19 $8B $5C $1C
             $8B $47 $14 $0B $47 $16 $74 $0E $57 $56 $9A $0AAF1517RL     $83
             $C4 $04 $5F $5E $5D $CB $83 $3C $03 $75 $0E $B8 $36D0W  $50 $56
             $57 $9A $090B16CDRL     $83 $C4 $06 $5F $5E $5D $CB

#Write new actions, 4 walk, 2 stand, 1 dead (Fix to avoid teleporter and Blooguard)
%patch $338DD $0117W $011AW $0000W $0000W $0001W $0008W $0078W $0000W
              $05C1084CRL   $05C10888RL   $090B17DCRL   $36EEW
%patch $33A2E $0118W $0119W $0000W $0000W $0001W $0008W $0078W $0000W
              $05C1084CRL   $05C10888RL   $090B17DCRL   $32E0W
%patch $33620 $0119W $0118W $0000W $0000W $0001W $0008W $0078W $0000W
              $05C1084CRL   $05C10888RL   $090B17DCRL   $3676W
%patch $339B6 $011AW $0117W $0000W $0000W $0001W $0008W $0078W $0000W
              $05C1084CRL   $05C10888RL   $090B17DCRL   $359DW

%patch $339D4 $0114W $0114W $0000W $0000W $0001W $000FW $0000W $0000W
              $00000000L    $05C10888RL   $090B17DCRL   $36B2W
%patch $339F2 $0115W $0115W $0000W $0000W $0001W $000FW $0080W $0000W
              $00000000L    $05C10888RL   $090B17DCRL   $359DW

%patch $33A10 $0116W $0116W $0002W $0000W $0000W $0000W $0000W $0000W
              $090B1710RL   $00000000L    $090B195ARL   $0000W


#################################################
#KEEN						#
#################################################

#New stunned action for Keen (Uses frame 142 = $8E)
#Stun time here is $013CW in first line
#Keen goes to 'stop reading book 3' when unstunning
#%patch $3352E $008EW $008EW $0000W $0000W $0001W $003CW $0000W $0000W
#              $00000000L    $0AAF1597RL   $0AAF1AC6RL   $0AA4W


#Keen Collision with MasterShot calls stunkeen instead of KillKeen
%patch $12DC3 $9A $174E1134RL

#StunKeen:
%patch $18614 

$55 #push bp
$8B $EC #mov bp, sp

$8B $1E $3E $9E #mov bx, player ; OBJECT *
$81 $7F $1C $BB2W 
$74 71 #jz short locret

$8B $1E $3E $9E #mov bx, player ; OBJECT *
$81 $7F $1C $BD0W 
$74 60 #jz short locret

$83 $3E $91 $BC $00 #cmp GodMode, 0
$75 39 #jnz short locret
$8B $1E $3E $9E #mov bx, player ; OBJECT *
$81 $7F $1C $31EEW #cmp [bx+OBJECT.action], offset ACTION_KEENSTUN.left_chunk
$74 42 #jz short locret

$B8 $31EEW #mov ax, offset ACTION_KEENSTUN
$50 #push ax
$FF $36 $9E3EW #push player ; OBJECT *
$9A $090B1242RL #call CheckGround2
$83 $C4 $04 #add sp, 4

$B8 00W #mov ax, 23
$50 #push ax
$9A $196E09EFRL #call SD_PlaySound
$83 $C4 $02 #add sp, 2

$8B $1E $3E $9E #mov bx, player ; OBJECT *
$C7 $47 $18 $0001W #mov [bx+OBJECT.ymove], -40
$C7 $47 $16 $0W #mov [bx+OBJECT.xmove], 16

#locret:
$5D #pop bp
$CB #retf

#New stunned action for Keen (Uses frame 142 = $8E)
#Stun time here is $003CW in first line
#Goes to last stop reading action ($0AA4W) 
#Patched at DS:31EE
%patch $8260  $EB
%patch $3352E $008EW $008EW $0004W $0001W $0000W $006CW $0000W $0000W
$090B1710RL $0AAF1597RL $090B17B5RL $0AA4W


#Walking Keen will destroy fuse (and Q.E.D!)
%patch $312C6 $11C40456RL	#Alter 1st walking frame only



#################################################
#KORATH (KORDACIAN)				#
#################################################

#Korath only uses three walking frames
%patch $3346A $30D2W

#Korath death uses the Ampton sound; write new death code at $6E93-6EDE
%patch $6E93 $55 $8B $EC $56 $57 $8B $7E $06 $8B $76 $08 $83 $3C $02 $75 $19
             $8B $5C $1C $8B $47 $14 $0B $47 $16 $74 $0E $57 $56 $9A $090B0CD2RL
                     $83 $C4 $04 $5F $5E $5D $CB $83 $3C $03 $75 $1A $B8 $21
             $00 $50 $9A $EF $09 $196ERW $83 $C4 $02 $B8 $3168W  $50 $56 $57
             $9A $090B16CDRL     $83 $C4 $06 $5F $5E $5D $CB

#Korath uses new death code:
%patch $33426 $06B90303RL #Walk 1
%patch $33444 $06B90303RL #Walk 2
%patch $33462 $06B90303RL #Walk 3
%patch $3349E $06B90303RL #Sit


#################################################
#ROBO RED (CYBLOOG)				#
#################################################

#Red shoots a heavily modified Shikadi polezap instead of
#his normal shot. This affects the Shikadi code

#Red has four walking animations instead of one
%patch $32A74 $015EW $0162W $00000000L  $0001W      $0008W $0040W $0000W #Original
              $11C409BCRL   $11C40A0DRL $090B17DCRL $35E0W
%patch $33920 $015FW $0163W $00000000L  $0001W      $0008W $0040W $0000W #Frame 2
              $11C409BCRL   $11C40A0DRL $090B17DCRL $35FEW
%patch $3393E $0160W $0164W $00000000L  $0001W      $0008W $0040W $0000W #Frame 3
              $11C409BCRL   $11C40A0DRL $090B17DCRL $361CW
%patch $3395C $0161W $0165W $00000000L  $0001W      $0008W $0040W $0000W #Frame 4
              $11C409BCRL   $11C40A0DRL $090B17DCRL $2734W

#Red spawns lower down since he's smaller now
%patch $125C7 $FD00W		#3 tiles up

#Red doesn't jiggle back and forth when shooting:
%patch $32ABC $0000W		#Remove pushback in shooting anim, compensate by also removing
%patch $12718 $00 $00		#Right movement when facing right
%patch $1271D $00 $00		#Left movement when facing left

#Change the chance Red will shoot when Keen is near him
%patch $12624 $20 $00

#Patch Shikadi polezapping anims to go with Red
%patch $33140 $0167W $0166W	#Frame 1
%patch $3315E $0167W $0166W	#Frame 2

#Patch Shikadi code so Red doesn't become a Shikadi
%patch $12648 $2E00W		#Shikadi polezaps (Keen lands near Red)
%patch $12683 $2E00W		#Shikadi polezaps (Shot by Keen while moving)
%patch $3317A $2734W		#Robo Red move (After Shik shoots)

#Shooting red is immortal (Not a stunnable Shikadi)
%patch $33154 $11C40D61RL	#Kill and block shots
%patch $33172 $11C40D61RL	#Kill and block shots


#Polezaps move horizontally. They also animate and (mostly) move toward Keen
#SIDE EFFECT: Polezaps don't always go in Keen's direction
%patch $130F5 $0A		#Zap 1 checks horizontally for Keen, not vertically
%patch $130FC $0A		#Zap 2 checks horizontally for Keen, not vertically

%patch $13105 $0E		#Zap 1 (mostly) heads horizontally for Keen, not vertically
%patch $13110 $0E		#Zap 2 (mostly) heads horizontally for Keen, not vertically

%patch $331A4 $0003W		#Zap frame 1 animates
%patch $331C2 $0003W		#Zap frame 2 animates

%patch $331AA $00000000L	#Zap frame 1 ignores vertical speed stuff
%patch $331C8 $00000000L	#Zap frame 2 ignores vertical speed stuff

%patch $331A6 $0040W		#Zap frame 1 speed
%patch $331C4 $0040W		#Zap frame 2 speed

%patch $3319A $0168W $016AW	#Zap Frame 1 anim
%patch $331B8 $0169W $016BW	#Zap Frame 2 anim

%patch $130DE $20 $03		#Polezaps always appear in front of tiles



#################################################
#SHELLEY (PROSPECTOR)				#
#################################################

#Shelley jump height (Default $E8 $FF )
%patch $11A08 $B2 $FF #left
%patch $119DF $B2 $FF #right

#Shelley jump widths
%patch $11A03 $F0 $FF #left
%patch $119DA $10 $00 #right

#After exploding Shelley leaves something behind
%patch $328F8 $7E $25

#Shelley will jump at Keen if he is above her and we can also ajust her 'attack range'
#Make Shelley check for Keen when walking, not just at the edge of platforms.
%patch $32766 $11020986RL
%patch $32784 $11020986RL
%patch $327A2 $11020986RL
%patch $327C0 $11020986RL
%patch $119B7 $77	#Jump at Keen if he is above Shelley

#Change Shelley attack range:
#Right
%patch $119CD $0100W #1 tile right of it to...
%patch $119D3 $0300W #3 tiles right of it

#Left:
%patch $119F6 $FF00W #1 tile left of it to...
%patch $119FC $FD00W #3 tiles left of it

#Shelly doesn't wait at platform edges
%patch $327D8 $0004W

#Shelley deadly, not pushy when jumping:
%patch $32800 $090B1799RL
%patch $3281E $090B1799RL
%patch $3283C $090B1799RL



#################################################
#SHIKADI (SHIKADI)				#
#################################################

#Shikadi will flip switches and slide on poles. They cannot shoot.
#This affects the Ampton code

#Shikadi Walks like Ampton (See: Ampton)
%patch $3252C $11C412ECRL	#First frame
%patch $3254A $11C412ECRL	#Second frame
%patch $32568 $11C412ECRL	#Third frame
%patch $32586 $11C412ECRL	#Fourth frame
%patch $7A79  $EB

#Patch Ampton code so Shikadi stays a Shikadi (See: Ampton)
%patch $112D9 $2D10W		#Shikadi stand (Unknown)
%patch $326DC $2D10W		#Shikadi stand (After flicking switches)
%patch $32646 $2D10W		#Shikadi stand (After pole sliding)

#Make the polesliding Shikadi immportal (Collision: Deadly, destroy shots)
%patch $325C6 $11C40D61RL	#Start slide
%patch $325E4 $11C40D61RL	#Sliding
%patch $32620 $11C40D61RL	#Sliding
%patch $3263E $11C40D61RL	#Stop slide

#Shikadi has an extra poleslide animation
%patch $325EE $013CW $013CW $0004W $00000000L $0006W $0000W $0020W #Old action (Frame 1)
              $11020405RL   $11C40D61RL       $090B17B5RL   $3658W
%patch $33998 $013DW $013DW $0004W $00000000L $0006W $0000W $0020W #New action (Frame 2)
              $11020405RL   $11C40D61RL       $090B17B5RL   $22AEW



#################################################
#SHIKADI MASTER (KOARTHOID MASTER)		#
#################################################

#Master will use the Robo Red shot when Keen is near or shoots him
#This affects the Robo Red code

#Patch Red's code so Master doesn't turn into Red
%patch $12B13 $2752W		#Shooting Robo Red (Random)
%patch $12BA8 $2752W		#Shooting Robo Red (When Master shot by Keen)
%patch $126B1 $2BC6W		#Shikadi master teleport (When done shooting)

#Patch Red's shot so it spawns closer to the (smaller) Master:
%patch $126CE $80 $00		#Vert (0.5 tiles down from head)
%patch $126BD $80 $00		#Horz (0.5 tiles right [When shooting left only!])

#Patch the number of shots Master shoots:
%patch $12AF6 $0A $00		#When shooting randomly, 10 shots
%patch $12BA5 $0F $00		#When Keen shot him first, 15 shots

#Change Master's shooting frames
%patch $32ECA $0199W $019BW	#307/309

#Remove Shikadi Master's sparks by making them a 'delete' action
%patch $32FD8 $FFFFW $FFFFW $0000W      $00000000L  $0001W $00000000L #This action deletes a sprite
              $00000000L    $00000000L  $00000000L  $0000W



#################################################
#SHIKADI MINE (SHIKADI PROBE COLLECTIVE)	#
#################################################

#Mine explodes when shot
%patch $1257A $FFFFW #Remove eye animation to avoid bug

#Disable sprite test cheat and create new collision for Mine
%patch $6CEE $CB $55 $8B $EC $56 $8B $76 $08 $83 $3C $02 $75 $08 $9A $0AAF1517RL
                     $5E $5D $CB $83 $3C $03 $75 $10 $B8 $2662W  $50 $56 $FF
             $76 $06 $9A $090B16CDRL $83 $C4 $06 $5E $5D $CB

#Mine uses new collision
%patch $3295C $06B9015FRL #Sit
%patch $3297A $06B9015FRL #Turn
%patch $32998 $06B9015FRL #Move

#Shikadi Mine spawns 3 spherefuls when it explodes 
%patch $1244F $303AW #Spawn 1
%patch $12509 $303AW #Spawn 2
%patch $1253F $303AW #Spawn 3
%patch $8260  $EB

#Mine appears in front of fore tiles:
%patch $11C92 $C7 $47 $20 $03 $00

%patch $11D28 4
%patch $11D2E 4

#should make the explosion detection bounds a tile bigger
%patch $11FCE $0300W 
%patch $11FD5 $FA00W

#eliminate pause during search 
%patch $1205B $2608W

#################################################
#SHOCKSUND (MORT)				#
#################################################

#Mort takes hits, then stuns. Then stuns every time he's shot
%patch $1328A $001EW		#Shockshund strength
%patch $133AA $7F		#Mort stuns every time once his health runs out.

#Shocksund stuns, doesn't die
%patch $3335C $0157W $0157W $0001W $00000000L $0070W $0000W $0000W
              $11C41664RL   $11C4174DRL       $11C418CBRL   $2F2CW

#Shocksund has an extra jump animation (Anim sp --V)
%patch $332C6 $0151W $0152W $0003W $00000000L $0010W $0008W $0000W #Begin jump
              $090B1710RL   $11C4174DRL       $11C418CBRL   $3748W
%patch $33A88 $015CW $015DW $0002W $00000000L $0008W $0080W $0000W #Jump/fall
              $090B1710RL   $11C4174DRL       $11C418CBRL   $2F2CW

#Shocksund jump speeds: 
%patch $132FA $28 $00		#Right speed (On flat ground) 
%patch $13301 $D8 $FF		#Left speed (On flat ground) 
%patch $13306 $D8 $FF		#Upwards speed (On flat ground) 
%patch $13489 $28 $00		#Right speed (At platform's edges) 
%patch $13490 $D8 $FF		#Left speed (At platform's edges) 
%patch $13495 $D8 $FF		#Upwards speed (At platform's edges)

#Shock shots bust Q.E.D AND Keen
%patch $332F8 $11C40456RL	#Change first anim frame only

#Shocksund doesn't sit
%patch $132CB $EB

#Bark frequency (Bigger = more often, default= $80)
%patch $1330E $90

#Shocksund doesn't hurt Keen:
%patch $1339B $EB

#Shocksund's shot doesn't bust on Keen's shot
%patch $135B4 $90 $90 $90 $90 $90

#Socksund walking speeds: (First h, second v)
%patch $3325A $0090W $0000W
%patch $33278 $0090W $0000W
%patch $33296 $0090W $0000W
%patch $332B4 $0090W $0000W

#Shooting Shocksund is deadly (SIDE EFFECT: Harder to shoot!)
%patch $33226 $11C40D61RL
%patch $33244 $11C40D61RL

#Change shot animation speed
%patch $332EE $0004W        #Animation speed
%patch $3330C $0004W        #Animation speed

#shockshund shot delay
%patch  $3323A 15W


#################################################
#SLICESTAR (ASTEROID)				#
#################################################

#Slicestar has four frames of animation:
#Bouncy Slicestar
%patch $3271A $0113W $0113W $0001W $00000000L $0010W $0018W $0018W
              $00000000L    $1102085ARL       $11020897RL   $31B2W
%patch $334F2 $0112W $0112W $0001W $00000000L $0010W $0018W $0018W
              $00000000L    $1102085ARL       $11020897RL   $31D0W
%patch $33510 $0111W $0111W $0001W $00000000L $0010W $0018W $0018W
              $00000000L    $1102085ARL       $11020897RL   $363AW
%patch $3397A $0110W $0110W $0001W $00000000L $0010W $0018W $0018W
              $00000000L    $1102085ARL       $11020897RL   $23DAW

#H/V Slicestar
%patch $326FC $0113W $0113W $0003W $00000000L $0018W $0000W $0000W
              $0F920776RL   $1102085ARL       $090B17B5RL   $2CB6W
%patch $32FF6 $0112W $0112W $0003W $00000000L $0018W $0000W $0000W
              $0F920776RL   $1102085ARL       $090B17B5RL   $2CD4W
%patch $33014 $0111W $0111W $0003W $00000000L $0018W $0000W $0000W
              $0F920776RL   $1102085ARL       $090B17B5RL   $2CF2W
%patch $33032 $0110W $0110W $0003W $00000000L $0018W $0000W $0000W
              $0F920776RL   $1102085ARL       $090B17B5RL   $23BCW

#Invincible nonbouncing slicestars 
%patch $1175F $90 $90 $90 $90 $90 

#Invincible bouncing slicestars 
%patch $11803 $90 $90 $90 $90 $90



#################################################
#SPARKY	(BIO-GARG)				#
#################################################

#Make Sparky Stunnable (Stun time is $012C)
#Sparky searches after stunning
%patch $324FE $0179W $0179W $00000000L $0001W  $012CW $00000000L
       $00000000L    $00000000L        $090B17B5RL    $1FFCW

#Change Sparky's look behavior so it chases sooner after unstunning
%patch $3232E $00000000L  #Nothing
%patch $3236A $110200A2RL #Sparky look
%patch $32388 $110200EFRL #Sparky look 2
%patch $32388 $110200A2RL #Sparky look
%patch $323A6 $110200EFRL #Sparky look 2

#Change Sparky's animation speed (and thus speed too):
#Sparky Walk
%patch $32256 $000CW #Animation speed
%patch $32274 $000CW #Animation speed
%patch $32292 $000CW #Animation speed
%patch $322B0 $000CW #Animation speed

#Sparky look
%patch $322CE $000CW #Animation speed
%patch $322EC $000CW #Animation speed
%patch $3230A $000CW #Animation speed
%patch $32328 $000CW #Animation speed
%patch $32346 $000CW #Animation speed
%patch $32364 $000CW #Animation speed
%patch $32382 $000CW #Animation speed
%patch $323A0 $000CW #Animation speed

#Sparky turn
%patch $324AE $000CW #Animation speed
%patch $324CC $000CW #Animation speed
%patch $324EA $000CW #Animation speed

#Sparky charge
%patch $32436 $0006W #Animation speed
%patch $32454 $0006W #Animation speed
%patch $32472 $0006W #Animation speed
%patch $32490 $0006W #Animation speed

#Sparky prepare to charge (Looking and sees Keen)
%patch $323D0 $20ECW #Sparky charge
%patch $323EE $20ECW #Sparky charge
%patch $3240C $20ECW #Sparky charge
%patch $3242A $20ECW #Sparky charge 

#Sparky charge speeds
%patch $32438 $00C0W
%patch $32456 $00C0W
%patch $32474 $00C0W
%patch $32492 $00C0W

#Increase charging vertical range from 1 to 5 tiles vertically:
#Look for Keen on left if Keen is...
%patch $110D4 $0400W #More than 0 tile but...
%patch $110DF $0800W #Less than 4 tiles

#Look for Keen on right if Keen is...
%patch $11121 $0400W #More than 0 tile but...
%patch $1112C $0800W #Less than 4 tiles



#################################################
#SPHEREFUL (SHIKADI PROBE)			#
#################################################

#Sphereful animation speeds
%patch $33384 $000CW #Animation speed
%patch $333A2 $000CW #Animation speed
%patch $333C0 $000CW #Animation speed
%patch $333DE $000CW #Animation speed

#sphereful speeds
%patch $13774 $EE $FF #Hit floor, ceiling
%patch $13781 $EE $FF #Floating randomly u/d

#increase sphereful top speed
# max speed down
%patch $136A5 10
#max speed right
%patch $136BA 10
# max x speed left
%patch $136CF $F2
%patch $7A79  $EB
# sphereful responsiveness
%patch $1369B 15

#################################################
#SPINDRED (DRILLBOT)				#
#################################################

#Spindred jump height
%patch $12A65 $C8 $FF

#Spindred bounces on the floor exclusively
%patch $12A32 $FF $FF #Bounce 65'535 times on the floor before...
%patch $129E5 $03 $00 #Bouncing 3 times on the ceiling



#################################################
#SPIROGRIP (BEDHED)				#
#################################################

#Spirogrip spawned searching
%patch $127DC $2914W 
%patch $8260  $EB
#Spinning spirogrip animation speeds
%patch $32C5E $0C
%patch $32C7C $0C
%patch $32C9A $0C
%patch $32CB8 $0C
%patch $32CD6 $0C
%patch $32CF4 $0C
%patch $32D12 $0C
%patch $32D30 $0C

#spinning animation frames
%patch $32C54 $90 $01 #Spirogrip spin 1 (Left animation: 298)
%patch $32C56 $90 $01 #Spirogrip spin 1 (Right animation:298)
%patch $32C72 $91 $01 #Spirogrip spin 2 (Left animation: 299)
%patch $32C74 $91 $01 #Spirogrip spin 2 (Right animation: 299)
%patch $32C90 $8F $01 #Spirogrip spin 3 (Left animation: 297)
%patch $32C92 $8F $01 #Spirogrip spin 3 (Right animation: 297)
%patch $32CAE $94 $01 #Spirogrip spin 4 (Left animation: 302)
%patch $32CB0 $94 $01 #Spirogrip spin 4 (Right animation: 302)
%patch $32CCC $8F $01 #Spirogrip spin 5 (Left animation: 297)
%patch $32CCE $8F $01 #Spirogrip spin 5 (Right animation: 297)
%patch $32CEA $91 $01 #Spirogrip spin 6 (Left animation: 299)
%patch $32CEC $91 $01 #Spirogrip spin 6 (Right animation: 299)
%patch $32D08 $90 $01 #Spirogrip spin 7 (Left animation: 298)
%patch $32D0A $90 $01 #Spirogrip spin 7 (Right animation: 298)
%patch $32D26 $92 $01 #Spirogrip spin 8 (Left animation: 300)
%patch $32D28 $92 $01 #Spirogrip spin 8 (Right animation: 300)

#Spirogrip slam down/right - originally right
%patch $32DAA $50 $00 #Left\right speed
%patch $32DAC $27 $00 #Up\down speed

#Spirogrip slam down/left - originally left
%patch $32D6E $A0 $FF #Left\right speed
%patch $32D70 $27 $00 #Up\down speed

#Spirogrip slam down - originally down
%patch $32D50 $00 $00 #Left\right speed
%patch $32D52 $50 $00 #Up\down speed

#Spriogrip has extra animations:
#Step 1: New actions:
%patch $335A8 $018DW $018DW $0001W $00000000L $0030W $0020W $FFE4W #back up down/left - frame 295
              $00000000L    $11C40D61RL       $11C40C03RL   $2932W
%patch $335C6 $018EW $018EW $0001W $00000000L $0040W $0000W $FFF0W #back up down - frame 296
              $00000000L    $11C40D61RL       $11C40C03RL   $2932W
%patch $33602 $0193W $0193W $0001W $00000000L $0030W $FFF0W $FFE4W #back up down/right - frame 301
              $00000000L    $11C40D61RL       $11C40C03RL   $2932W

#Step 2: patch an existing action or reference to use these new actions,
#This adds a new frame to our Spirogrip.
%patch $32B80 $3286W #back up down
%patch $32BBC $3268W #back up left/down
%patch $32BF8 $3286W #back up down - originally up
%patch $32C34 $32C2W #back up right/down

#Only slams down, left/down, right/down
%patch $1282F $2A04W #Move down (Stop spinning)
%patch $1283E $2A22W #Move left/down (Stop spinning)
%patch $12820 $2A04W #Move down (Stop spinning) - originally up
%patch $12811 $2A5EW #Move right/down (Stop spinning)

#Spirogrip apears in front of fore tiles:
%patch $127B7 $C7 $47 $20 $03 $00



#################################################
#VOLTE FACE					#
#################################################

#Volte Face speed
%patch $32016 $000FW #Animation speed
%patch $32034 $000FW #Animation speed
%patch $32052 $000FW #Animation speed
%patch $32070 $000FW #Animation speed

#Moving Volte-Face behavior
%patch $3201C $0F921005RL #Infgoplat
%patch $3203A $0F921005RL #Infgoplat
%patch $32058 $0F921005RL #Infgoplat
%patch $32076 $0F921005RL #Infgoplat



#################################################################################################
#ANIMATION AND CACHE PATCHES									#
#################################################################################################
#NOTES:						#
#This rearranges all the animations and caches	#
#of all the sprites except Keen. This is to	#
#avoid sprites needing other sprites in-level	#
#to cache things for them, to save on memory and#
#to free up animation space.			#
#################################################

#Move K sign $113->$10C
%patch $317CA $010CW $010CW #Keen K flag waving
%patch $317E8 $010DW $010DW #Keen K flag waving
%patch $31806 $010EW $010EW #Keen K flag waving
%patch $31824 $010FW $010FW #Keen K flag waving
#Result, shrink Map Keen cache by 6 frames
%patch $31A2C $00F2W #Map Keen cache start
%patch $31A80 $010FW #Cache end

#Consolidate slicestar frames $110-$113
#MOVED TO SLICESTAR AREA
#Move slicestar cache (Size 12K)
%patch $31A3A $0110W #Slicestar cache start
%patch $31A8E $0113W #Cache end

#Consolidate Korathoid frames $114-$120
#MOVED TO KORATHOID AREA
#Fuse\Q.E.D Cache, caches Korathoid, fuse and Q.E.D (Size 15K)
%patch $31A52 $0114W #Q.E.D cache start
%patch $31AA6 $0121W #Cache end

#Consolidate lightbulb guy frames (Korath)
%patch $33412 $0122W $0125W #Korath walking
%patch $33430 $0123W $0126W #Korath walking
%patch $3344E $0124W $0127W #Korath walking
%patch $3348A $0128W $0128W #Korath sit
%patch $334A8 $0129W $0129W #Korath stunned
#Consolidate korath cache (Size 9K)
%patch $31A50 $0122W #Korath cache start
%patch $31AA4 $0129W #Cache end

#Consolidate Master frames $12A-$135
%patch $32E34 $012AW $012AW #Shikadi master stand
%patch $32E52 $012BW $012BW #Shikadi master stand
%patch $32E70 $012CW $012CW #Shikadi master stand
%patch $32E8E $012DW $012DW #Shikadi master stand
%patch $32EE8 $012EW $012EW #Shikadi master teleport
%patch $32F06 $012FW $012FW #Shikadi master teleport
%patch $32F24 $012FW $012FW #Shikadi master teleport
%patch $32F42 $012FW $012FW #Shikadi master teleport
#Master shoot (RR shooting behavior)
%patch $32A92 $0131W $0130W #Robo Red
%patch $32AB0 $0131W $0130W #Robo Red
%patch $32ACE $0131W $0130W #Robo Red
#Master's shot (RR shot behavior)
%patch $32AEC $0132W $0133W #Robo Red shot
%patch $32B0A $0133W $0132W #Robo Red shot
%patch $32B28 $0134W $0134W #Robo Red shot smash
%patch $32B46 $0135W $0135W #Robo Red shot smash
#Consolidate Master cache (Size 12K)
%patch $31A2E $012AW #Master cache start
%patch $31A82 $0135W #Cache end

#Move Shikadi frames $136-$146
#Shikadi flip switch (Ampton flip behavior, shikadi stand anims)
%patch $32648 $0136W $0136W #Shikadi stand
%patch $32666 $0137W $0137W #Shikadi stand
%patch $32684 $0138W $0138W #Shikadi stand
%patch $326A2 $0139W $0139W #Shikadi stand
%patch $326C0 $0136W $0136W #Shikadi stand
#Shikadi polegrab (Ampton slide behavior Shik polezaping anim)
%patch $325B2 $013BW $013AW #Ampton start pole slide
%patch $325D0 $013BW $013AW #Ampton start pole slide
%patch $3260C $013BW $013AW #Ampton stop pole slide
%patch $3262A $013BW $013AW #Ampton stop pole slide
#Shikadi zapping up pole frames in SHIKADI section
%patch $330C8 $0142W $013EW #Shikadi walk
%patch $330E6 $0143W $013FW #Shikadi walk
%patch $33104 $0144W $0140W #Shikadi walk
%patch $33122 $0145W $0141W #Shikadi walk
%patch $33050 $0136W $0136W #Shikadi stand
%patch $3306E $0137W $0137W #Shikadi stand
%patch $3308C $0138W $0138W #Shikadi stand
%patch $330AA $0139W $0139W #Shikadi stand
%patch $3317C $0146W $0146W #Shikadi stunned
#Consolidate Shikadi cache (Size 11K)
%patch $31A30 $0136W #Shikadi cache start
%patch $31A84 $0146W #Cache end

#Consolidate Shocksund frames $147-$15D (Add two frames deleted earlier)
%patch $331D6 $0147W $0147W #Shocksund sit
%patch $331F4 $0148W $0148W #Shocksund sit
%patch $33212 $0155W $0153W #Shocksund bark
%patch $33230 $0156W $0154W #Shocksund bark
%patch $3324E $014DW $0149W #Shocksund walk
%patch $3326C $014EW $014AW #Shocksund walk
%patch $3328A $014FW $014BW #Shocksund walk
%patch $332A8 $0150W $014CW #Shocksund walk
%patch $332E4 $0158W $0158W #Shocksund shot
%patch $33302 $0159W $0159W #Shocksund shot
%patch $33320 $015AW $015AW #Shocksund shot smash
%patch $3333E $015BW $015BW #Shocksund shot smash
#Expand Shocksund cache to $147-$15D (Size 21K)
%patch $31A32 $0147W #Shocksund cache start
%patch $31A86 $015DW #Cache end
%patch $7A79  $EB

#Consolidate Blooguard (RoboRed) frames to $15E-$16B
#ALL IN OTHER SECTIONS
#Consolidate RR cache (Size 64K!)
%patch $31A3C $015EW #Robo Red cache start
%patch $31A90 $016BW #Cache end

#Shift Sparky frames t0 $16C-$177 (Cheat by shifting only 2 frames!)
%patch $322A6 $0171W $016DW #Sparky walk
%patch $3240E $0171W $016DW #Sparky prepare to charge
%patch $32486 $0171W $016DW #Sparky charge
%patch $324FE $016CW $016CW #Stunned Sparky
#Move Sparky cache (Size 10K)
%patch $31A36 $016CW #Sparky cache start
%patch $31A8A $0177W #Cache end

#Shift and shrink Shikadi mine frames to $78-$17D
%patch $32948 $0178W $0178W #Shikadi mine
%patch $32966 $0178W $0178W #Shikadi mine
%patch $32984 $0178W $0178W #Shikadi mine
%patch $329A2 $0179W $0179W #Shikadi mine detonate
%patch $329C0 $017AW $017AW #Shikadi mine detonate
%patch $329DE $0179W $0179W #Shikadi mine detonate
%patch $329FC $017AW $017AW #Shikadi mine detonate
%patch $32A1A $017BW $017BW #Shikadi mine detonate
%patch $32A38 $017CW $017CW #Shikadi mine detonate
%patch $32A56 $017DW $017DW #Mine fragments
#Shift and shrink Mine cache (Size 22K)
%patch $31A38 $0178W #Mine cache start
%patch $31A8C $0181W #cache end

#Move Sphereful frames $166->$17E
%patch $3337A $017EW $017EW #Sphereful
%patch $33398 $017FW $017FW #Sphereful
%patch $333B6 $0180W $0180W #Sphereful
%patch $333D4 $0181W $0181W #Sphereful
#Move and shrink Sphereful cache (Size 9K)
%patch $31A34 $017EW #Sphereful cache start
%patch $31A88 $0181W #Cache end

#Move Volteface frames to $182-$186
%patch $3200C $0182W $0182W #Volte face
%patch $3202A $0183W $0183W #Volte face
%patch $32048 $0184W $0184W #Volte face
%patch $32066 $0185W $0185W #Volte face
%patch $32084 $0186W $0186W #Volte face stunned
#Move Volte cache (Size 7K)
%patch $31A42 $0182W #Volte cache start
%patch $31A96 $0186W #Cache end

#Move blue platform frames to $187-$188
%patch $31EBC $0187W $0187W #Purple Plat
%patch $31EDA $0188W $0188W #Purple Plat
%patch $31F8E $0187W $0187W #Purple plat
%patch $31FAC $0188W $0188W #Purple plat
#Move platform cache from $1A6->$187 (Size 2K)
%patch $31A44 $0187W #Purple plat cache start
%patch $31A98 $0188W #Cache end

#Expand ampton cache 2 to $195-$1A2 (Size 13K)
%patch $31A94 $01A2W #Cache end

#Change teleporter anis to spare frames
%patch $31DAE $01A3W $01A3W #Teleporter bolt
%patch $31DCC $01A4W $01A4W #Teleporter bolt
%patch $31DEA $01A5W $01A5W #Teleporter bolt
%patch $31E08 $01A6W $01A6W #Teleporter bolt
#Set teleporter cache to use 'spare' frames (Size 0.4K)
%patch $31A56 $01A3W #Teleport cache start
%patch $31AAA $01A8W #Cache end



#Presplosion:

#Starting palette
#%patch $31BE2  $00 $01 $02 $03 $04 $05 $06 $07  $18 $19 $1A $1B $1C $1D $1E $1F  $03

#First palette index to cycle (default = 08)
#%patch $F6FB $18AAW

#first index color cycle
#%patch $31B9A $08W $08W $07W $0FW $07W $08W 
#              $00W $08W $07W $0FW $07W $08W
#              $00W $00W $00W $00W $00W $00W

#Second palette index to cycle (default = 07)
#%patch $F706 $18A9W

#second index color cycle
#%patch $31BBE $07w $07w $07w $07w $07w $0Fw
#              $07w $08w $00w $07w $0Fw $07w
#              $08w $00w $00w $00w $00w $00w


#Starburst:

#starburst length (frames/2 ), max = $7F
#%patch $F7D7 $1E 

#star color
#%patch $F626 $0F

#color planes to enable for starburst segment
#%patch $F73F $0F

#Bonus patches, might not be of great use, but here they are anyways...

#Use write mode 0 instead of 2; gives nifty shimmer effect, but star color patch is ignored
#%patch $F736 $00

#Fade from Death to Presplosion stage
#fade to white
#%patch $F660 $211W 

#fade from white
#%patch $F6D9 $265W
%patch $8260  $EB
#disable fade in
#%patch $F6D8 $90 $90 $90 $90 $90


###########
#TEST ZONE#
###########

#palette
%patch $31BE2  $00 $00 $02 $03 $04 $1C $06 $07  $18 $19 $1A $1B $1C $1D $1E $1F  $03


#First palette index to cycle (yellow)
%patch $F6FB $18B0W

#first index color cycle
%patch $31B9A $1EW $1EW $1EW $1CW $04W $1EW 
              $00W $1EW $04W $1CW $04W $1EW
              $00W $00W $00W $00W $00W $00W 

#Second palette index to cycle (Dark Red)
%patch $F706 $18A6W

#second index color cycle
%patch $31BBE $04w $04w $04w $04w $04w $1Cw
              $04w $1Ew $00w $04w $1Cw $1Ew
              $1Ew $00w $00w $00w $00w $04W #end on 4 because we need to see the dots!

#starburst length (frames/2 ), max = $7F
%patch $F7D7 $40 

#star color
%patch $F626 $04

#color planes to enable for starburst segment
%patch $F73F $0E

###########

###########
#End Game##
###########
#Call new exiting function
%patch $8642 $9A $174E11A9RL $90
%patch $7A79  $EB
#New exiting function (RF_14)
%patch $18689
$83 $3E $6F68W 15 #cmp current_level, 15
$74 $07           #je wingame
$C7 $06 $6F70W $0002W #mov level_state, 2 (win level)
$CB               #retf
$C7 $06 $6F70W $000FW #mov level_state, 15 (win game)
$CB


####
# Make sphereful killable
# takes one shot; stunned with stunners stars at 5SPR0317.bmp
####
# Consequence: must place sphereful 1 tile higher during level design
#don't draw sphereful diamonds 
%patch $137AC $5F $5E $8B $E5 $5D $CB
#create new sphereful sprite collision
%patch $137B2
$55 $8B $EC
$56 $57 $8B $76 $06 $8B $7E $08  $83 $3D $02 $75 $05 $9A $0AAF1517RL
$83 $3D $03 $75 29  $C7  $44 $16 $00 $00 $C7 $44 $18 $00
$00 $C7 $44 $06 $00 $01 
$B8 $399FW  $50 $57 $56 $9A  $090B16CDRL     $83 $C4 $06 $5F
$5E $5D $CB
# normal sphereful action now has shocksund sprite collision
%patch $3338E $11C41B72RL
%patch $333AC $11C41B72RL
%patch $333CA $11C41B72RL
%patch $333E8 $11C41B72RL
# dead action for sphereful
# NOTE: this overwrites the "Bad Instrument" and "Uncached sounds" errors
# If you need these, just remove the entire sphereful patch
%patch $33CDF
419W 419W 2W 0W 0W 0W 0W 0W $090B1710RL 0L $090B195ARL 0W


#point sprite animation speeds
%patch $31C90 $001EW        #Animation speed
%patch $31CAE $001EW        #Animation speed

%end
