/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 804)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
(local
ready2
clicked
)
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture 804
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())

		(super:init())
		(self:setScript(RoomScript))

		(send gEgo:
			init()
			hide()
         )




        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
     = gTimeSeconds 9

 )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)

    (method (changeState newState)

  = state newState
  (switch (state)
    (case 0
(send gGame:setSpeed(5))
    (aShip: init() setMotion(MoveTo 155 110 RoomScript))
    (aShip2: init() setMotion(MoveTo 0 44 RoomScript))
     (aShip3: init() setMotion(MoveTo 320 10 RoomScript))
    )
    (case 1
     (aShip: init() setMotion(MoveTo 155 155 RoomScript))
       )
       (case 2
      (aLand: init() setCycle(End))
        )
        (case 3
        Wait(20)
        (send gRoom:newRoom(405))
        )
    )
    )

	(method (handleEvent pEvent)
      (var button2)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD))
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())

                // End the title screen, start the game

        = button2 Print(
  "Are you sure you want to cancel the intro. It includes some useful clues."
  #title "Make your selection:"
  #font 999
  #button " No " 1
  #button " Yes " 0
)
(if(== button2 0)
 (send gRoom:newRoom(INITROOMS_SCRIPT))
 return
)(else
return

))))
(method(doit)
(if(== gTimeSeconds 7)
= clicked 0
)
))

(instance aShip of Act
(properties
view 333
x 1
y 40

))
(instance aLand of Act
(properties
view 403
x 160
y 109
cycleSpeed 3
))
(instance aShip2 of Act
(properties
view 111
x 301
y 44

))
(instance aShip3 of Act
(properties
view 111
x 0
y 10

))
