/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 170)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "menubar")
(local
parachuteTaken
jammed = 0
)
/******************************************************************************/
(instance public rm170 of Rm
	(properties
		picture 170
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))
          (send gTheMusic:
			prevSignal(0)
			stop()
			number(5)
			loop(-1)
			play()
		)

		(switch(gPreviousRoomNumber)
			(case 158
				(send gEgo:
					posn(210 110)
					loop(1)
				)
			)
		)
        (aSmoke: init() cycleSpeed(1) setCycle(Fwd))
		SetUpEgo()
        (aWindow: init() setCycle(Fwd) cycleSpeed(0))
		(send gEgo:init())
  (aParachute: init())
  RestoreSpeed()
  Print("You're going down fast, so don't waste any time. You have got to get out of here." #at 80 140)
  = gTimeSeconds2 0
		(TheMenuBar:draw())
		(SL:enable())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
 (method(doit)
  (super: doit())
(if(== savedGame2 77)
(if(carpetMoved)
= savedGame2 76
DrawPic(171)
)
)
  (if(== gTimeSeconds2 40)
 Print("You're getting dangerously close to the ground. Better think something out quickly.")
 += gTimeSeconds2 1
 )
 (if(== gTimeSeconds2 56)
 Print("You're now too close to the ground. There's no way to escape anymore.")
  (send gRoom:newRoom(172))
 )
 )
 (method (handleEvent pEvent)
(super:handleEvent(pEvent))

  (if(Said('look>'))
            (if(Said('/bench,stool,chair,seat'))
            Print("This seat must be for the passangers.")
            )
            (if(Said('/parachute'))
              (if(not(parachuteTaken))
            Print("This must be the emergency parachute.")
            return
            )
            Print("You are wearing it. It's brownish and ready for action.")
            )
            (if(Said('/floor'))
            (if(carpetMoved)
            Print("There's a carpet on the floor. Under the carpet you see a small hatch.")
            return
            )
            Print("There's a carpet on the floor. Why does a ship like this need a carpet. Is it covering something?")
            )
            (if(Said('/wall'))
            (if(not(parachuteTaken))
            Print("There's a keypad and a window on the wall next to the door. In the back of the ship, there's something hanging on the wall. Looks like a parachute.")
            return
            )
            Print("There's a keypad and a window on the wall next to the door.")
            )
            (if(Said('/button,keypad'))
            Print("This keypad on the wall is for opening the door. But it doesn't seem to work at the moment.")
            )
            (if(Said('/door'))
            (if(== jammed 1)
            Print("The door is jammed because of the explosion.")
            return
            )
            Print("This door is the way out of the vessel. Try opening it")
            )
            (if(Said('/ceiling'))
            Print("Nothing special up there.")
            )
            (if(Said('/window'))
            Print("Judging from what you see from the window, you're going down fast.")
            )
            (if(Said('/cockpit'))
            Print("There's nothing to see there. Most of the equipment doesn't work anyway because of the explosion.")
            )
            (if(Said('/'))
            Print("You're in a space-vessel that's going down, FAST! You better get out of here.")
            Print("In the upper wall of the vessel, there is a door with a keypad next to it. A small window is next to the door too. A red carpet is covering the floor.")
              (if(not(parachuteTaken))
              Print("There's something hanging on the wall in the back of the ship.")
              )
        ))

     (if(Said('open/hatch,lid'))
(if(carpetMoved)
    (if(parachuteTaken)
       (if(==(send gEgo: onControl()) ctlNAVY)
 Print("You open up the hatch, and jump out.")
   (send gRoom: newRoom(161))
   return
   )
   Print("Move closer the hatch.")
   return
   )
  Print("You'd get killed if you just jump out.")
   return
   )
   Print("What hatch? I don't see any here.")
     )
     (if(Said('pull,take,move/carpet'))
     (if(carpetMoved)
    Print("You already pulled up the carpet.")
     return
     )
      (if(==(send gEgo: onControl()) ctlNAVY)
     Print("You pull up the carpet, revealing a hatch.")
     = carpetMoved TRUE
     DrawPic(171)
     += gScore 1
     return
     )
     Print("Get closer to the carpet.")
     )
     (if(Said('take/parachute'))
       (if(parachuteTaken)
       Print("You already have the parachute. And you are even wearing it.")
       return
       )
       (if(==(send gEgo: onControl()) ctlYELLOW)
      Print("You pick up the parachute and put it on.")
     += gScore 2
     (aParachute: dispose())
      = parachuteTaken TRUE
      (send gEgo: view(371))
      return
       )
       Print("You can't reach the parachute from here.")
     )
     (if(Said('open/door'))
     (if(==(send gEgo: onControl()) ctlRED)
 Print("The door is not opening. The explosion must have jammed it.")
 = jammed 1
 return
 )
 Print("You have to be closer to the door.")
    )
      (if(Said('press,use/button,keypad'))
 Print("Can't you see that the keypad is emitting smoke. That means it's not working.")
    )
 )
)

(instance aSmoke of Act
(properties
view 366
x 119
y 59
))
(instance aWindow of Act
(properties
view 368
x 163
y 55
))
(instance aParachute of Prop
(properties
view 370
x 71
y 66
))
/******************************************************************************/
