/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 81)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
red
)
/******************************************************************************/
(instance public rm081 of Rm
	(properties
		picture scriptNumber
		north 0
		east 83
		south 0
		west 82
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 83
				(send gEgo:
					posn(300 109)
					loop(1)
				)
			)
   (case 82
				(send gEgo:
					posn(20 109)
					loop(0)
				)
			)
      (case 127
				(send gEgo:
					posn(35 102)
					loop(2)
				)
			)
		)

		SetUpEgo()

		(send gEgo:init())
  (if(killed and (if(not(send gEgo: has(INV_LADDER)) and (if(not(> ladderPlaced 0))))))
   (aLadder: init())
  )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
 (method(doit)
  (if(==(send gEgo: onControl()) ctlBLACK)
   = red FALSE
  )
 (if(==(send gEgo: onControl()) ctlCYAN)
 (if(not(red))
 = red TRUE
 (if(killed)
 Print("The rebels told you, not to use the main entrance. So don't use it!")
 (send gEgo: setMotion(MoveTo 290 116))
 )
 )
 )
 
 
 )
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        
        (if(Said('look>'))
            (if(Said('/ladder'))
  (if(killed and (if(not(send gEgo: has(INV_LADDER)) and (if(not(> ladderPlaced 0))))))
 Print("How on earth did a ladder get here?")
 return
  )
  Print("Where? Me? Ladder?")
                )
        (if(Said('/wall'))
 (if(killed and (if(not(send gEgo: has(INV_LADDER)) and (if(not(> ladderPlaced 0))))))
 Print("The wall isn't very interesting. A ladder is placed against the wall. A sign above directs to the pool area.")
 return
 )
 Print("The wall isn't very interesting. A sign above directs to the pool area.")
 )
 (if(Said('/lock'))
 Print("As much as you wish, you need a key to open these locks.")
)
(if(Said('/door'))
 Print("These are the doors for room 6, 5 and 4.")
)
(if(Said('/'))
Print("You're in the hotel hallway. There are 3 doors here.")
)
)
         (if(Said('take/ladder'))
         (if(killed)
         (if(< (send gEgo:distanceTo(aLadder)) 15)
         (if(not(send gEgo: has(INV_LADDER)))
         (if(> ladderPlaced 0)
        Print("You already took it.")
         return
         )
         += gScore 2
         (send gEgo: get(INV_LADDER))
         (aLadder: hide())
         return
         )
         Print("You already took it.")
         return
         )
         Print("You can't reach the ladder.")
         return
         )
         Print("Ladder? Where?")
         )
         (if(Said('open/door'))
         (if(==(send gEgo: onControl()) ctlRED)
         (if(send gEgo: has(INV_HOTELKEY))
         Print("Ok")
         (send gRoom: newRoom(127))
         return
         )
         Print("You just can't open a hotel room door. You need a key.")
         return
         )
         Print("You're too far away from the door.")
         )
        )
)
(instance aLadder of Prop
(properties
view 159
x 83
y 101
))
/******************************************************************************/
