/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 58)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "rev")
(local
silver
navy
red
blue
dyingScript
)
/******************************************************************************/
(instance public rm058 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 54
				(send gEgo:
					posn(30 139)
					loop(0)
				)
			)
   	(case 976
				(send gEgo:
					posn(23 139)
					loop(0)
				)
			)
		)
		SetUpEgo()
		(send gEgo:init())
  (aDoor: init())

  (send gEgo: ignoreControl(ctlYELLOW))
  (aDoor: ignoreControl(ctlWHITE))

	)
)
/******************************************************************************/
(instance RoomScript6 of Script
	(properties)
  (method(changeState newState)
 = state newState
 (switch(state)
 (case 0

 
      = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("The guard shot you and you died. Pity, it was a very nice quest so far.")
  )
  (send gGame:setScript(dyingScript))
 )

 )
 )
 )

(instance RoomScript3 of Script
	(properties)
  (method(changeState newState)
 = state newState
 (switch(state)
 (case 0
 (aGuard: loop(1))

 Print("Where did ze go?!" #title "Prof. Grankenztein:" #icon 778 0 0)
 Print("I don't know sir!" #title "Guard:" #icon 778 0 3)
 Print("Let'z go!" #title "Prof. Grankenztein:" #icon 778 0 0)
  (aGuard: setCycle(Walk) setMotion(MoveTo 322 109 RoomScript3))
  (doctor: setMotion(MoveTo 312 133 RoomScript3))
  )
    (case 1
  (aGuard: hide())
)
  (case 2
    (aDoor: dispose())
  (doctor: hide())
  (send gEgo: hide())
  PlayerControl()
  DrawPic(8)
  = corridorDoor TRUE
  Print("Few moments later, you step out.")
(send gRoom: newRoom(59))
 )
 )
 )
 )
(instance RoomScript4 of Script
	(properties)
  (method(changeState newState)
 = state newState
 (switch(state)
 (case 0
 (doctor: loop(0))
 Print("Kill him!" #title "Prof. Grankenztein:" #icon 778 0 0)
 (aGuard: init() setCycle(Walk) setMotion(MoveTo 280 109 RoomScript4))
 )
 (case 1
 (if(not(shoot))
 = shoot TRUE
  ProgramControl()
 (send gEgo: view(83) setCycle(End))
 (aGuard: loop(6) setCycle(End RoomScript4))
 )
 )
 (case 2
      = dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("The guard shot you and you died in horrible pain.")
  )
  (send gGame:setScript(dyingScript))
 )

 )
 )
 )

(instance RoomScript2 of Script
	(properties)
 (method(changeState newState)
 = state newState
 (switch(state)
 (case 0

 )

 )
 )
 )
(instance RoomScript of Script
	(properties)
 
    (method (handleEvent pEvent)
(super:handleEvent(pEvent))
         (if(Said('look>'))
(if(Said('/pipe'))
Print("It doesn't look interesting. So you look at it.")
)
(if(Said('/floor'))
Print("The cleaner around here has done a nice job.")
)
(if(Said('/door'))
Print("The closet door looks like an automatic one. The big door is opened.")
)
(if(Said('/broom'))
(if(==(send gEgo: onControl()) ctlBLUE or ctlRED)
Print("BroomMaster 4000 GX Mark 3. Now THAT's what I call a good broom.")
return
)
Print("There isn't any here. Try looking elsewhere.")
)
(if(Said('/mop,cloth,underwear'))
(if(==(send gEgo: onControl()) ctlBLUE or ctlRED)
Print("Looks like some old underwear or something.")
return
)
Print("No mop here.")
)
(if(Said('/button,keypad'))
Print("Pressing it, you close the big door.")
)
(if(Said('/'))
(if(==(send gEgo: onControl()) ctlBLUE)
(if(==(send gEgo: onControl()) ctlRED)
)
Print("You are inside the closet. Looks like it's the cleaners \"cabinet\". Some brooms and mops are lying on the floor.")
return
)
Print("You're in a hallway. There's a button to close the door on the wall.")
        )
        )
  (if(Said('press,close,operate/button,door,keypad'))
  (if(==(send gEgo: onControl()) ctlCYAN)
 Print("This door only activates on Prof. Grankenztein's command.")
return
  )
  Print("You're not close enough.")
  )
  )
  
 (method(changeState newState)
 = newState 1
 = state newState
 (switch(state)
 (case 1
 (aDoor: hide())
 (send gEgo: ignoreControl(ctlYELLOW))
 )

 )
 )
 (method(doit)
 (if(==(send gEgo: onControl()) ctlGREEN)
 ProgramControl()
  (doctor: init() setCycle(Walk) setMotion(MoveTo 73 133 RoomScript4))
 )
 (if(== gTimeSeconds2 12)
 = gTimeSeconds2 13
 ProgramControl()
 (aGuard: init())
 (doctor: init())
 (if(==(send gEgo: onControl()) ctlBLUE)
 (doctor: setCycle(Walk) setMotion(MoveTo 73 133 RoomScript3))
 return
 )
  (if(==(send gEgo: onControl()) ctlRED)
  (doctor: setCycle(Walk) setMotion(MoveTo 73 133 RoomScript3))
 return
  )
    (if(==(send gEgo: onControl()) ctlYELLOW)
  (doctor: setCycle(Walk) setMotion(MoveTo 73 133 RoomScript3))
 return
  )
 (doctor: setCycle(Walk) setMotion(MoveTo 73 133 RoomScript4))
  return
 )


   (if(==(send gEgo: onControl()) ctlBLUE)
   = blue TRUE
   )
  (if(==(send gEgo: onControl()) ctlRED)
  (if(blue)
  = blue FALSE
   (aDoor: loop(0) setCycle(End RoomScript))

  )
  (if(not(red))
  = red TRUE
   (aDoor: show())
 (aDoor: loop(1) setCycle(End RoomScript2))
    )
  )
 (if(==(send gEgo: onControl()) ctlNAVY)
 = red FALSE
 = blue FALSE
 (if(not(navy))
 = navy TRUE
 (aDoor: loop(0) setCycle(End RoomScript))
 )
 )
  (if(==(aGuard: onControl()) ctlNAVY)
 = red FALSE
 = blue FALSE
 (if(not(navy))
 = navy TRUE
 (aDoor: loop(0) setCycle(End RoomScript))
 )
 )
 (if(==(send gEgo: onControl()) ctlBLACK)
 = silver FALSE
 (if(navy)
 = navy FALSE
  (send gEgo: observeControl(ctlYELLOW))
 (aDoor: show())
 (aDoor: loop(1) setCycle(End RoomScript2))

 )
 )
 (if(==(send gEgo: onControl()) ctlSILVER)
 (if(not(silver))
 = silver TRUE
 Print("You don't have to go back to the lab.")
 )
 )
 )
)
(instance aDoor of Act
(properties
view 82
x 181
y 97
)
)
(instance doctor of Act
(properties
view 80
x 13
y 133
)
)
(instance aGuard of Act
(properties
view 128
x 322
y 109
loop 1
))
/******************************************************************************/
