/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 56)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm056 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(265 65)
					loop(2)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
 (if(not(haveCard))
 (card: init())
  )
  )

)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
(method (handleEvent pEvent)
(super:handleEvent(pEvent))
(if(Said('talk/man,guard'))
Print("Guard? Where?")
)
(if(Said('open/door'))
Print("You can't. It's tightly locked.")
)
(if(Said('look>'))
(if(Said('/door'))
Print("It looks like a guard-room door.")
)
(if(Said('/guard'))
Print("Huh? Where?")
)
(if(Said('/keycard,card'))
(if(haveCard)
Print("It's in your inventory. Press TAB to see it.")
return
)
Print("Looks like the guard left a keycard here. It's shiny!")
)
(if(Said('/floor,ceiling'))
Print("I don't see anything special about it.")
)
(if(Said('/wall'))
Print("There's a button in the wall and also a small shelf.")
)
(if(Said('/dust'))
Print("Woo! Look at that. Isn't is cool!?")
)
(if(Said('/shelf'))
(if(haveCard)
Print("The shelf is empty. Just dust.")
return
)
Print("There's a keycard on the shelf. And some dust.")
)
(if(Said('/buttons'))
Print("You can open and close the big door in the hallway with this button.")
)
(if(Said('/table'))
Print("It's just an ordinary empty table.")
)
(if(Said('/vent,hole,lid,hatch,grate'))
Print("This is where you came in.")
)
(if(Said('/'))
Print("You're in the guard's room. There is a shelf and a button in the wall. Also, there is a table here, an empty one.")
)
)

(if(Said('take/card,keycard'))
(if(==(send gEgo: onControl()) ctlCYAN)
(if(not(haveCard))
Print("Ok")
Wait(20)
Print("You pick up an electronic card.")
+= gScore 2
= haveCard TRUE
(send gEgo: get(INV_CARD))
(card: hide())
return
)
Print("You already have it.")
return
)
Print("You're not close enough to the shelf.")
)
(if(Said('press,use/button,keypad'))
(if(==(send gEgo: onControl()) ctlCYAN)
(if(bigDoorOpen)
Print("Ok")
-= gScore 3
= bigDoorOpen FALSE
Print("... clang ... clang ... clang ... POF!")
Print("Looks like the big door is now closed.")
return
)
Print("Ok")
+= gScore 3
= bigDoorOpen TRUE
Print("... clang ... clang ... clang ...")
Print("Looks like the big door is now opened.")
return
)
Print("You're not close enough to the button.")
)
(if(Said('(get<in,back),enter,(climb<in,back),climb,(crawl<in,back),crawl/vent,hole,lid,hatch,back,shaft')or(if(Said('crouch,(get<in,back),(climb<back),(crawl<in,back)'))))
(if(==(send gEgo: onControl()) ctlCYAN)
Print("Ok")
Print("You decide to crawl back...")
Wait(30)
(send gRoom: newRoom(57))
return
 )
 Print("You're not close enough to the air-ventilation tunnel.")
 )
 )
)
(instance card of Prop
(properties
view 22
x 292
y 42
))
/******************************************************************************/
