/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 43)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
one
part1
part2
)
/******************************************************************************/
(instance public rm043 of Rm
	(properties
		picture 44
		north 0
		east 57
		south 42
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
   
				(send gEgo:
					posn(120 180)
					loop(3)
				)

     (if(bayDoor)
    (aDoor: posn(123 80))
    )
    )
      (case 52
               (send gTheMusic:
			prevSignal(0)
			stop()
			number(11)
			loop(-1)
			play()
		)
				(send gEgo:
					posn(122 144)
					loop(2)
				)
     (if(bayDoor)
    (aDoor: posn(123 80))
    )
			)
       (case 57

				(send gEgo:
					posn(315 180)
					loop(1)
				)
     (if(bayDoor)
    (aDoor: posn(123 80))
    )
			)
     		)

		SetUpEgo()
		(send gEgo:init())
  (aDoor: init())
  (Camera: init())
  = info TRUE
(if(not(camWarn))
 = camWarn TRUE
   Print("See this camera? It's watching you. Don't make any suspicious moves. There has to be a way to get pass this camera.")
  )
 )
)
/******************************************************************************/
(instance RoomScript2 of Script
	(properties)

 )
(instance RoomScript of Script
	(properties)
  (method (handleEvent pEvent)
(super:handleEvent(pEvent))
(if(Said('close/door'))
(if(not(bayDoor))
Print("The door is already closed. You have to OPEN it.")
return
)
Print("Then what was the point of opening it in the first place?")
)
(if(Said('open/door'))
Print("For that, there's a keypad next to the door.")
)
(if(Said('look>'))
(if(Said('/button,keypad'))
Print("It looks like you have to enter two three-digit codes to open the door.")
= needCode TRUE
)
(if(Said('/building'))
Print("It's the cargo space port.")
)
(if(Said('/ground'))
Print("You don't see anything special about it.")
)
(if(Said('/wall'))
Print("There's a camera high on the wall. You can also see a keypad near the door.")
)
(if(Said('/camera,(security<camera)'))
(if(send gEgo:has(INV_SIGNAL_DEVICE))
Print("It's filming everything that's going on at the door area.")
return
)
Print("It's filming everything what's going on at the door area. Don't get very close.")
)
(if(Said('/door'))
Print("It's a heavy-metal-explosion-proof door.")
)
(if(Said('/spaceport,(space,cargo<port),(cargo<(space<port))'))
Print("That's the building. You better try to get inside.")
)
(if(Said('/'))
(if(tManClub)
Print("You're outside the cargo spaceport. There's a camera on the wall and a keypad next to the door.")
return
)
Print("You're outside some unknown building. There's a camera on the wall and a keypad next to the door.")
)


 )
(if(Said('press/keypad,button') or (if(Said('enter/code') or (if(Said('use/button,keypad'))))))
(if(==(send gEgo: onControl())ctlRED)
(if(bayDoor)
Print("The door is already opened.")
return
)
Print("You need to enter two three-digit codes here.")
(if(send gEgo: has(INV_PAPER))
= part1 GetNumber("The first part of the activation code:\n")
(if(== part1 427)
= part2 GetNumber("The second part of the activation code:\n")
(if(== part2 519)
Wait(30)
Print("The code was correct and the door opens.")
= bayDoor TRUE
+= gScore 2
(aDoor: setMotion(MoveTo 123 80 RoomScript2))
return
)
)
Print("Access denied!")
return
)
Print("You try a lot of number codes but none of them work.")
= needCode TRUE
return
)
Print("You're not close enough to the keypad.")
)

)
 
 
 (method(doit)
    (var dyingScript)
    (if(==(send gEgo: onControl())ctlSILVER)
    (if(not(enterBase))
    Print("After some walking you reach the stairs...")
    = enterBase TRUE
    (send gRoom: newRoom(52))
    return
    )
    (send gRoom: newRoom(52))
    )
(if(==(send gEgo: onControl())ctlYELLOW)
 (if(not(send gEgo: has(INV_SIGNAL_DEVICE)))
 (if(not(one))
 ProgramControl()
  = one TRUE
 -= Xposn 18
 Wait(60)
 (Guard: init() setCycle(Walk) setMotion(MoveTo Xposn 150 RoomScript))
 )
 )
 )
 )
  (method (changeState newState)  (var dyingScript)
    = state newState
    (switch (state)
    (case 0
    = cycles 1
    )
    (case 1
    (Guard: init() setCycle(Walk) setMotion(MoveTo Xposn 159 RoomScript))
     )
     (case 2
   (Guard: init() setCycle(Walk) setMotion(MoveTo Xposn 160 RoomScript))
    )
     (case 3
= dyingScript ScriptID(DYING_SCRIPT)
  (send dyingScript:
    caller(3)
    register("The camera saw you and alerted the guard. Try again!")
  )
  (send gGame:setScript(dyingScript))
 )
    )
    )
    )

 
 
(instance aDoor of Act
(properties
view 350
x 123
y 140
moveSpeed 2
cycleSpeed 2
))
(instance Camera of Prop
(properties
view 352
x 41
y 18
))

(instance Guard of Act
(properties
view 127
x 0
y 150
moveSpeed 1
cycleSpeed 1
)
)
/******************************************************************************/
