/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 15)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(use "rev")
(local
navy
)
/******************************************************************************/
(instance public rm015 of Rm
	(properties
		picture scriptNumber
		north 0
		east 53
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 53
				(send gEgo:
					posn(315 153)
					loop(3)
				)
			)

			(case 16

      (send gTheMusic:
			prevSignal(0)
			stop()
			number(17)
			loop(-1)
			play()
		)
				(send gEgo:
					posn(262 125)
					loop(2)
				)
			)
   (case 976
				(send gEgo:
					posn(315 153)
					loop(3)
				)
			)
		)
        (liftDoor: init())
		SetUpEgo()
		(send gEgo:init())
	)
)
/******************************************************************************/

(instance RoomScript of Script
	(properties)
     (method (changeState newState)
  = state newState
  (switch (state)
    (case 0
= cycles 1


    )
    (case 1
    (liftDoor: hide())
    )
    )
    )
        (method (handleEvent pEvent)
   (super:handleEvent(pEvent))
  (if(Said('open/door'))
Print("For that, there's a button on the wall next to the door.")
)
  (if(Said('use/elevator'))
Print("You have to press the button next to the elevator doors to call up the lift, and then you can use it.")
)
   (if(Said('press,call,use/(call<button),elevator,button'))
   (if(==(send gEgo: onControl()) ctlRED)
   Wait(120)
   Print("Man, this elevator is coming up slowly...")
   Wait(90)
   Print("Finally!")
   Wait(5)
   (liftDoor: setCycle(End RoomScript))
   return
   )
   Print("You can't reach the button from here.")
   )

   (if(Said('look>'))
            (if(Said('/lift,elevator'))
            Print("This is the main elevator. It goes way down.")
            )
            (if(Said('/door'))
            Print("These are the elevator doors. Very strong and all.")

            )
            (if(Said('/button,(call<button)'))
            Print("This is the elevator call-button.")

            )
            (if(Said('/wall'))
            Print("Plain stone walls. There's a button on the wall.")
            )
            (if(Said('/floor'))
            Print("Regular rocket base floor. Hard concrete.")
            )
            (if(Said('/light'))
            Print("It gives a certain atmosphere to this hall.")
            )
            (if(Said('/'))
            Print("You're in some hall. There seems to be an elevator and a button next to it.")

        )
        )
        )

 (method(doit)
  (if(==(send gEgo: onControl()) ctlBLACK)
 = navy FALSE
 )
 (if(==(send gEgo: onControl()) ctlNAVY)
 (if(not(navy))
 = navy TRUE
 (liftDoor: show())
 (liftDoor: loop(1) setCycle(End))

 (send gRoom: newRoom(16))
 )
 )
 (if(==(send gEgo: onControl()) ctlYELLOW)
 (send gRoom: newRoom(53))
 )
 )
)
(instance liftDoor of Prop
(properties
view 214
x 261
y 122
))
/******************************************************************************/
