/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game. 
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
(local
testVar = 0
gSmashedwindow
gThrowgravel
)
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture 1
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))
  		
  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)

            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
  			(case 976

              = objective 6
                 (send gTheMusic:fade(5))
                 = gTimeSeconds2 0
  				(send gEgo:
  					posn(150 130)
  					loop(1)
  				)

  			)

     (case 2
  				(send gEgo:
  					posn(28 87)
  					loop(2)
  				)
  			)
  		)
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:init())


   
        /****************************************
         * Set up the room's music to play here *
         ****************************************/
         (if(not(power))
          (aScreen: init())
         )
        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
         (if(== gPreviousRoomNumber 976)
         = gPreviousRoomNumber 0
Print("Here you are in your lab, trying to get the Timegate to work. But there's a part missing. You need it to get the gate fully operational. Last you heard, it was on its way to the post-office." #at 60 130)

         )

      (if(trans)
         (aTransmitter: init())
  )
    = gTimeSeconds2 1

  //FormatPrint("Free Heap: %u Bytes" MemoryInfo(miFREEHEAP))


  )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
 
 (method(doit)
 (if(activated)
  (send gRoom:newRoom(7))
 )
 (if(>= gTimeSeconds2 1)
 (if(== objective 6)
 = objective 89
              (send gTheMusic:
			prevSignal(0)
			stop()
			number(2) //1
			loop(-1)
			play()
		) )
 )
 )
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
(if((<> (send pEvent:type) evSAID) or (send pEvent:claimed))
		    return(TRUE)
     )
    (if(Said('take,pull/wire'))
(if(== (send gEgo:onControl()) ctlBLUE)
(if(send gEgo:has(INV_WIRES))
Print("You have already taken those wires.")
return
)
    Print("Ok")
    += gScore 2
    (send gEgo:get(INV_WIRES))
    return
)
Print("You can't reach them from here. Move closer to the wires between the Timegate and the computer.")

         )
         
         
 (if(Said('climb'))
    (if(< (send gEgo:distanceTo(aTransmitter)) 40)
    
    (if(not(gSmashedwindow))
    (if(gThrowgravel)
      	Print("The hole is to small make it bigger.")
      return
      )
      (else	
    	Print("How can you do that? You can't climb through a solid object.")
      return
	  )
    )
    (if(gSmashedwindow)
      Print("You climb though the broken window.")     
      return
    )
    )
    (else
      Print("You are too far away.")
    )
)
       
         
     (if(Said('set,connect,put,use/transmitter') or(if(Said('connect,use/transmitter/computer'))))
               (if(trans)
         Print("You already used it.")
         return
         )
           (if(== (send gEgo:onControl()) ctlSILVER)
         (if(send gEgo:has(INV_TRANSMITTER))

         Print("You connect the transmitter to the Timegate.")
           += gScore 2
         = trans TRUE
         (aTransmitter: init())
         (send gEgo:put(INV_TRANSMITTER))
         return
         )
         Print("You don't have the transmitter.")
         return
         )
         Print("You need to connect the tranmitter with the Timegate so move closer to it.")
         )
          (if(Said('(turn<on),start,activate,use/timegate'))
          Print("You need to use the computer for that.")
          )
           (if(Said('(turn<on),start,activate,use/computer')or(if(Said('(turn<on),start,activate,use/timegate/computer'))))
           (if(== (send gEgo:onControl()) ctlRED)
           (if(power)
           (if(activated)
         Print("You already activated the Timegate.")
        return
           )
           (if(trans)
           Print("Ok")
         (aScreen: hide())

          ShakeScreen(4 ssFULL_SHAKE)
            ShakeScreen(4 ssLEFTRIGHT)
              ShakeScreen(4 ssFULL_SHAKE)
            ShakeScreen(4 ssLEFTRIGHT)
            ShakeScreen(4 ssLEFTRIGHT)
              ShakeScreen(4 ssFULL_SHAKE)
            ShakeScreen(4 ssLEFTRIGHT)
             = activated TRUE
           (send gRoom:newRoom(7))
           return
           )
           Print("You could do that but it wouldn't work. First you need the transmitter to be connected with the Timegate and then you can try again.")
           return
           )
           Print("First you have to turn the power on.")
           return
           )
           Print("You're too far away from the computer.")
          )
          (if(Said('use/machine,generator'))
          Print("You have to press the generator start button to turn it on.")
          )
          (if(Said('(turn<on),press,start,activate/machine,button,(start<button),generator'))
            (if(== (send gEgo:onControl()) ctlYELLOW)
            (if(power)
            Print("You already activated the generator.")
            return
            )
            (if(button)
            Print("Ok")
            ShakeScreen(5)
            += gScore 3
            = power TRUE

            Print("Turning on the generator shaked the whole thing...")
            return
            )
            Print("The power in the lab isn't turned on.")
            return
            )
            Print("You're too far away from the generator start button.")
          )

         (if(Said('open/door'))
         (if(== (send gEgo:onControl()) ctlNAVY)
         Print("Ok")
         (send gRoom:newRoom(2))
         return
         )
         Print("You're not close enough to the door.")
         

        )
        (if(Said('look>'))
                (if(Said('/transmitter'))
             (if(trans)
            Print("This little thingy controls the time and space continuance, preventing mismatches. At least it should do all that.")
            return
            )
            Print("It's in your inventory. Press TAB to see it.")
            )
            (if(Said('/button,(start<button)'))
            (if(>= (send gEgo: y) 140)
            Print("This is the generator start button.")
            return
            )
            Print("You can't see the button from this position.")
            )
            (if(Said('/generator,machine'))
            Print("This is one big and powerful generator. This is going to start the Timegate, hopefully. There's a button on the lower side.")
            Print("This generator amplifies the power up to 10 times. And it's one of your inventions.")
            )
            (if(Said('/door'))
            Print("The door is so strong that it can even stand a nuclear explosion...")
            Print("...when it's 300 miles away.")
            )
            (if(Said('/computer,console'))
            Print("This is your mainframe. It controls all the operations, calculations and stuff you need to travel in time. It uses Windows 98(c)")
            )
            (if(Said('/timegate,gate,invention'))
            Print("This is what you've been working on for a year. Now it's time to test it out.")
            )
            (if(Said('/wall'))
            Print("The walls are green and they have been build higher recently.")
            )
            (if(Said('/knob'))
            Print("Like there's anything to see. A door knob ... useless.")
            )
            (if(Said('/ceiling'))
            Print("An old lamp is hanging from the ceiling. But not for long.")
            )
            (if(Said('/lamp,(old<lamp)'))
            Print("It's about to fall down.")
            )
            (if(Said('/stair,walkway'))
            Print("It's nothing special you know. Makes it easier to get near the Timegate.")
            )
              (if(Said('/card,id'))
            (if(postman)
             Print("New Yerk Post Office: \n\n Name: Mike Haley \n\n ID: 4587B2D" #icon 778 0 5)
            return
            )Print("You're losing it man. :P"))
            (if(Said('/screen,monitor,(computer<screen,monitor)'))
            (if(power)
            (if(connected)
            Print("\nTransmitter: ON\nGenerator: ON")
            return
            )
            Print("\nTransmitter: OFF\nGenerator: ON")
            return
            )
            Print("\nTransmitter: OFF\nGenerator: OFF")
            return
            )
            (if(Said('/floor'))
            Print("The floor is untidy and there are different parts laying all over the floor including some wires.")
            )
            (if(Said('/wires'))
            (if(send gEgo: has(INV_WIRES))
            Print("It's in your inventory. Press TAB to see it.")
            return
            )
            Print("There are lots of wires on the floor. Some of them are useless.")
            )
            (if(Said('/'))
            Print("This is your lab. There's a big generator, computer and the Timegate. This lab has changed a lot during this year. Some wires are laying on the floor.")
            
        )
        )
  )
)

(instance aScreen of Prop
(properties
view 107
x 228
y 65
))
(instance aTransmitter of Prop
(properties
view 359
x 136
y 58
))
/******************************************************************************/
