/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 100)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm100 of Rm
	(properties
		picture 10
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:posn(240 135)loop(1))
			)(case 9
                (send gEgo:posn(240 135)loop(1))
            )
		)

		SetUpEgo()
		(send gEgo:init())
        (fire:init()setCycle(Fwd)cycleSpeed(1))
        (pianoChair:init()setPri(1)ignoreActors())
        (pianoTop:init())

        (if(not(gameComplete))
            (pops:init()loop(2))
            (doctor:init()loop(3))
            (gwen:init()loop(1)cel(3))
            (jennifer:init()loop(2))
            (butler:init()loop(3))
            (deadGuy:init()loop(3))
        )(else
            (copA:init()loop(0))
            (copB:init()loop(0))
            (butler:init()view(132)posn(119 117))
        )
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState intro)
        = state intro
        (switch(state)
            (case 0 = cycles 1
            )(case 1 = cycles 9
            )(case 2 = cycles 15
                (if(gameComplete)
                    (ProgramControl)
                    Print("How can it be?")
                    Print("I saw you die!"#title"You say")
                    (send gGame:changeScore(5))
                )(else
                    Print("Oh my God! Jeff!"#title"Jennifer says")
                    (jennifer:setCycle(Walk)setMotion(MoveTo 150 130))
                )
            )(case 3 = cycles 17
                (if(gameComplete)
                    Print("Remember who proclaimed me dead?"#title"Butler says")
                )(else
                    Print("Who would've done such a thing?"#title"You ask")
                    (send gEgo:setMotion(MoveTo 160 130))
                )
            )(case 4 = cycles 12
                (if(gameComplete)
                    (send gRoom:newRoom(2))
                )(else
                    Print("Who had the opportunity?"#title"Mr Vince asks")
                    (pops:setCycle(Walk)setMotion(MoveTo 142 120))
                )
            )(case 5 = cycles 12
                Print("I was in the kitchen."#title"Gwen says")
                (gwen:setCycle(Walk)setMotion(MoveTo 200 110))
            )(case 6 = cycles 12
                Print("I was smoking a cigar outside."#title "Doc says")
                (doctor:setCycle(Walk)setMotion(MoveTo 155 160))
            )(case 7 = cycles 12
                Print("Jennifer was upstairs and I was in the study."#title "Mr Vince says")
            )(case 8 = cycles 15
                Print("I was in the bathroom getting a bandage for Gwen." #title "You say")
            )(case 9 = cycles 12
                Print("What about the butler?"#title "Jennifer asks")
                (jennifer:loop(2))
            )(case 10 = cycles 10
                Print("Who? Me? N...no, I was getting firewood outside."#title "Butler says")
                Print("I didn't come in until after the doctor."#title "Butler says")
            )(case 11 = cycles 12
                Print("It could be anyone!")
            )(case 12 = cycles 70
                Print("I'm feeling ill."#title "Butler says")
                (butler:setCycle(Walk)setMotion(MoveTo 360 130))
            )(case 13 = cycles 40
                Print("What if there is someone else in the house?"#title "You say")
                Print("Shouldn't someone make sure the butler is alright?"#title "You say")
                (send gEgo:loop(2))
                (gwen:loop(2))
                (doctor:setCycle(Walk)setMotion(MoveTo 360 130))
            )(case 14 = cycles 20
                (send gEgo:loop(0))
                (gwen:loop(0))
                (jennifer:loop(0))
                (pops:loop(0))
                (send gGame:changeScore(2))
            )(case 15
                (send gRoom:newRoom(90))
            )

        )
    )
 
 
)
//characters

(instance copA of Act
    (properties
    y 117
    x 105
    view 310
    )
)(instance copB of Act
    (properties
    y 127
    x 188
    view 311
    )
)
(instance jennifer of Act
    (properties
    y 105
    x 217
    view 309
    )
)
(instance butler of Act
    (properties
    y 145
    x 120
    view 303
    )
)
(instance gwen of Act
    (properties
    y 125
    x 250
    view 302
    )
)
(instance pops of Act
    (properties
    y 110
    x 139
    view 301
    )
)
(instance doctor of Act
    (properties
    y 170
    x 153
    view 306
    )
)
//Props
(instance fire of Prop
    (properties
    y 126
    x 31
    view 10
    )
)
(instance deadGuy of Prop
    (properties
    y 130
    x 147
    view 151
    )
)
(instance pianoTop of Prop
    (properties
    y 70
    x 71
    view 1
    )
)
(instance pianoChair of Prop
    (properties
    y 94
    x 92
    view 9
    )
)
/******************************************************************************/
