\ConGame.xpl	20-Mar-2006	Loren Blaney	loren_blaney@idcomm.com
\Concentration Card Game
\(Can be compiled with any version of XPL0 for the PC, especially xjsb.bat)

inc	C:\CXPL\CODESI;	\include code definitions for intrinsic routines

int	CpuReg,		\address of CPU register array (from GetReg)
	Cards;		\number of cards remaining to be matched
int	Deck(52);	\deck of cards, contains values 0..51

def	Black, Blue, Green, Cyan, Red, Magenta, Brown, White,  \attribute colors
	Gray, LBlue, LGreen, LCyan, LRed, LMagenta, Yellow, BWhite;



func	CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call software interrupt
int	Int, AX, BX, CX, DX, BP, DS, ES; \(unused arguments need not be passed)
begin
CpuReg(0):= AX;
CpuReg(1):= BX;
CpuReg(2):= CX;
CpuReg(3):= DX;
CpuReg(6):= BP;
CpuReg(9):= DS;
CpuReg(11):= ES;
SoftInt(Int);
return CpuReg(0);		\return AX register
end;	\CallInt



proc	Blink(On);		\Turn video blinking off and on
\When blink is off, hi-intensity background colors are available
int	On;	\flag: true = blink on; false = blink off
begin
CallInt($10, $1003, if On then 1 else 0);
end;	\Blink

\------------------------------- MOUSE ROUTINES --------------------------------

func	OpenMouse;		\Initializes mouse; returns 'false' if it fails
begin				\Pointer is set to center of screen but is hidden
CallInt($21, $3533);		\Make sure mouse vector ($33) points to something
if CpuReg(1)=0 & CpuReg(11)=0 then return false;
return Extend(CallInt($33, $0000));	\reset mouse and return its status
end;	\OpenMouse			 (Extend is necessary for 32-bit XPL)



proc	ShowMouse(On);		\Turn mouse pointer on or off
int	On;			\flag: true = pointer on; false = pointer off
CallInt($33, if On then $0001 else $0002);



func	GetMousePosition(N);	\Return position of specified mouse coordinate
int	N;			\0 = X coordinate; 1 = Y coordinate
\For 80-column text modes divide the mouse coordinates by 8 to get the character
\ cursor position.
begin
CallInt($33, $0003);
return if N then CpuReg(3) else CpuReg(2);
end;	\GetMousePosition



func	GetMouseButton(N);	\Return 'true' if specified mouse button is down
int	N;			\button number: 0 = left; 1 = right (or middle)
begin
CallInt($33, $0003);
return if N then (CpuReg(1)&2)=2 else (CpuReg(1)&1)=1;
end;	\GetMouseButton

\===============================================================================

proc	Exit;			\Make a clean exit
begin
ShowMouse(false);		\make sure mouse pointer is off
Blink(true);			\(bright = false)
Cursor(79, 23);			\so DOS prompt ends up at the bottom
exit;
end;	\Exit



proc	ShowCard(X, Y, Card);	\Show card C at coordinates X,Y
int	X, Y, Card;
int	N, Suit;
char	Str;

	proc	CardStock(Ch);	\Draw the basic card stock
	int	Ch;		\pattern for front or back side
	int	I, J;
	begin
	for J:= 0, 2 do
		begin
		Cursor(X, Y+J);
		for I:= 0, 4 do ChOut(6, Ch);
		end;
	end;	\CardStock

begin
if Card < 0 then		\display the back of the card
	begin
	Attrib(BWhite<<4 + Blue);
	CardStock($B1);
	return;
	end;

Str:= "234567891JQKA ";
N:= Card/4;
Suit:= Rem(0);

Attrib(BWhite<<4 + (if Suit<2 then LRed else Black));
CardStock(^ );

Cursor(X+2, Y+1);		\show suit symbol in center of card
ChOut(6, Suit+3);

Cursor(X, Y);			\show face value (number)
ChOut(6, Str(N));
if N = 10-2 then
	begin
	ChOut(6, ^0);
	Cursor(X+3, Y+2);
	Text(6, "10");
	end
else	begin
	Cursor(X+4, Y+2);
	ChOut(6, Str(N));
	end;
end;	\ShowCard



proc	Play;			\Play the game
int	MX, MY,			\mouse coordinates (char cells)
	N, X, Y,		\card number and coordinates
	C1, C1X, C1Y,		\first selected card
	C2, C2X, C2Y;		\second selected card


func	GetCard;
\Given mouse coordinates MX,MY, return card N at position X,Y
begin
N:= 0;
for Y:= 0, 5 do
    for X:= 0, 9 do
	begin
	if Y#2 & Y#3 ! (X<3!X>6) then
		begin
		if MX<5+X*7+6 & MY<1+Y*4+4 then return;
		N:= N+1;
		end;
	end;
N:= 52-1;			\don't go beyond the last card
X:= 9;  Y:= 5;
end;	\GetCard



proc	PickCard;		\Click on a card and turn it over
begin
ShowMouse(true);
while GetMouseButton(0) do [];	\wait for button release
repeat if ChkKey then Exit;	\any keystroke terminates program
until GetMouseButton(0);

MX:= GetMousePosition(0) / 8;	\convert mouse coordinates to character cells
MY:= GetMousePosition(1) / 8;
GetCard;
ShowMouse(false);
if Deck(N) >= 0 then ShowCard(5+X*7, 1+Y*4, Deck(N));	\turn the card face up
end;	\PickCard



begin	\Play
PickCard;
C1:= N;
C1X:= X;
C1Y:= Y;

PickCard;
C2:= N;
C2X:= X;
C2Y:= Y;

if Deck(C1)/4 = Deck(C2)/4  &  C1 # C2  &  Deck(C1) >= 0  &  Deck(C2) >= 0 then
	begin			\face values match and they aren't the same card
	Cards:= Cards-2;	\ and they have not already been taken
	Deck(C1):= -1;		\mark cards as taken
	Deck(C2):= -1;
	end
else	begin			\cards don't match (or illegal move)
	Sound(0, 22, 1);	\delay then turn cards face down
	if Deck(C1) >= 0 then ShowCard(5+C1X*7, 1+C1Y*4, -1);
	if Deck(C2) >= 0 then ShowCard(5+C2X*7, 1+C2Y*4, -1);
	end;
end;	\Play



proc	Deal;			\Display all the cards facing down
int	X, Y;
begin
for Y:= 0, 5 do
    for X:= 0, 9 do
	if Y#2 & Y#3 ! (X<3!X>6) then
		ShowCard(5+X*7, 1+Y*4, -1);
end;	\Deal



proc	Shuffle;		\Shuffle the card deck
int	I, J, K, T;
begin
for J:= 0, 10-1 do
    for I:= 0, 52-1 do
	begin
	K:= Ran(52);		\randomly pick a card
	T:= Deck(I);		\swap cards in the deck at locations I and K
	Deck(I):= Deck(K);
	Deck(K):= T;
	end;
end;	\Shuffle



proc	Init;			\Initialize
int	I, J;
begin
for I:= 0, 52-1 do Deck(I):= I;	\set up the deck
Shuffle;

Cards:= 52;

Attrib(Green<<4 + White);	\paint the background green
for J:= 0, 25-1 do
	begin
	Cursor(0, J);
	for I:= 0, 80-2 do Chout(6, ^ );
	end;
end;	\Init

\===============================================================================

begin	\Main
CpuReg:= GetReg;

if not OpenMouse then
	begin
	Text(0, "This program requires a mouse.");
	CrLf(0);
	exit;
	end;

Blink(false);
Init;
Deal;

repeat Play until Cards <= 0;
Exit;
end;	\Main
