.\"
.\" aguide.mm
.\"
.\" Advanced Rogue
.\" Copyright (C) 1984, 1985, 1986 Michael Morgan, Ken Dalka and AT&T
.\" All rights reserved.
.\"
.\" Based on "Rogue: Exploring the Dungeons of Doom"
.\" Copyright (C) 1980, 1981 Michael Toy, Ken Arnold and Glenn Wichman
.\" All rights reserved.
.\"
.\" See the file LICENSE.TXT for full copyright and licensing information.
.\"
.tr ~
.nr Pt 1
.ds HF 3 2 2 2 2 2 2
.TL
The Dungeons of Doom
.AF Toolchest
.AU " "
.AS 1
.P
Rogue was introduced at the University of California at Berkeley as a
screen-oriented fantasy game.
The game had 26 types of monsters that the player could meet while
exploring a dungeon generated by the computer.
Scrolls, potions, rings, wands, staves, armor, and weapons helped the
player to battle these monsters and to gain gold, the basis for scoring.
.P
The version of Rogue described in this guide has been expanded to include
over 110 monsters with many new capabilities.
Many of the monsters are intelligent, and they, like the player, must avoid
traps and decide when it is better to fight or to run.
The player chooses a character class at the beginning of the game which
defines the player's abilities.
Experience, rather than gold, decides the player's score.
.AE
.MT 4
.H 1 INTRODUCTION
Rogue is a screen-oriented fantasy game set in the ever-changing
\fIDungeons of Doom\fR.
The game comes complete with monsters, spells, weapons, armor, potions,
and other magical items.
The dungeon's geography changes with every game, and although many magical
items have certain identifiable properties, such as turning the player
invisible, the physical manifestation of the magic changes each game.
A red potion, for example, will cause the same reaction throughout
a given game, but it may be a completely different potion in a new game.
.P
Entering the dungeon with only a little food, armor, and a weapon, the player
must develop a good strategy of when
to fight, when to run, and how to best use any magical items found
in the dungeon.
To make things interesting, the player has a quest to return one of
several unique artifacts, rumored to lie deep in the dungeon's bowels.
Returning with this artifact brings great glory and the title of
\fIComplete Winner\fR.
But even after finding the artifact, the player may wish to continue
further to match wits with an \fIarch-devil\fR, \fIdemon prince\fR, or even a 
\fIdeity\fR found far down in the dungeon.
Defeating such a creature will gain the player many experience points,
the basis for scoring in Rogue.
.P
It is very difficult to return from the \fIDungeons of Doom\fR.
Few people ever make it out alive.
Should this unlikely event occur, the player would be proclaimed a
complete winner and handsomely rewarded for any booty removed from the
dungeon.
.H 1 "CHARACTER CLASSES"
Before placing the player in the dungeon, the game requests the player
to select what type of character they would like to be:~ a fighter, a magic user, a cleric, 
a druid, a thief, a paladin, a ranger, a monk, or an assassin.
.H 2 "The Fighter"
A fighter is very strong and will have a high strength rating.
This great strength gives a fighter the best odds of
winning a battle with a monster.
At high experience levels the \fIfighter\fR also gets to attack
multiple times in a single turn.
This obviously further increases his chances at winning battles.
Intrinsic to the fighter class is a robustness which results in
1 to 12 extra hit points for every new experience
level.
.H 2 "The Magician"
A Magician is able to "cast" spells.
The number and variety of spells increases as
the magician gains experience and intelligence.
Magic users are not as hearty as fighters;
they receive 1 to 6 extra hit
points for every new experience level.
.H 2 "The Cleric"
A cleric is able to "pray" to his god for help.
The number and variety of prayers which the gods are willing to grant to
a cleric increase as the cleric gains experience and wisdom.
.P
Because of their religious nature, clerics can also affect the "undead"
beings, like \fIzombies\fR and \fIghouls\fR, which became monsters after they
died.
If an "undead" creature is next to a cleric, the cleric may try
to turn it and cause it to flee.
If the cleric is sufficiently powerful relative to the monster,
the cleric will destroy it.
This ability increases as the character gains experience levels.
.P
Clerics can gain from 1 to 8 extra hit points on
reaching a new experience level.
.H 2 "The Druid"
The druid is a cleric of sorts but worships nature rather than a god.
The druid is able to "chant" and thereby recieve certain types
of spells. Most of the chants are targeted more towards the
elements and nature.
.P
Druids gain from 1 to 8 hit points when they gain an experience level.
.H 2 "The Thief"
A thief is exceptionally dextrous and has a good chance to
set a trap or rob a monster.
.P
By their nature, thieves can automatically detect all the gold on the
current level of the dungeon.
They are also good at detecting hidden traps.
Because thieves slink along, they are not as likely as other characters
to wake sleeping monsters.
If a \fIthief\fR manages to sneak up on a creature without waking it, he
will get a chance to \fIbackstab\fR the monster. When this is done,
the damage done by the \fIthief\fR greatly increases based on his experience
level.
.P
Thieves gain from 1 to 6 extra hit points from a new experience level.
.H 2 "The Paladin"
The paladin is a type of holy warrior. Somewhat of a cross between a 
fighter and a cleric. He is able to pray and turn undead as a cleric,
(but to a lesser degree) but fights as a fighter. He is on the side of
all that is good and righteous. Therefore he would never attack a 
creature that would not attack him first. If he does kill a non-violent
creature inadvertantly he will feel "uneasy" and his god may retaliate
by making him a mere fighter.
.P
Paladins gain 1 to 10 hit points per experience level.
.H 2 "The Ranger"
The ranger is somewhat of a cross between a druid and a fighter. He
too is on the side of righteousness and good. Therefore, the same
same restrictions apply to his as they do to a paladin. The ranger
can "chant" and "cast" but to a lesser degree than the druid and
magician.
.P
Rangers gain 1 to 8 hit points per experience level.
.H 2 "The Monk"
The Monk is a martial arts expert. He wears no armor but has
an effective armor class based on his ability to dodge attacks.
He does not need a weapon in combat for his hands and feet are
a formidable weapon. His ability to dodge and use his hands
as weapons increases as he gains in level. 
.P
Monks gain 1 to 6 hit points per experience level.
.H 2 "The Assassin"
The assassin is a person trained in the art of killing people
by surprise. He has most of the abilities of the thief except
the "backstab". Instead, the assassin has the chance to kill
an opponent outright with one strike. He is also a ruthless
character and trained in the use of poison. He can recognize
poison on sight and can coat his weapon with it thereby making
his next attack an exceptionally lethal one.
.P
Assassins gain 1 to 6 hit points per experience level.
.H 1 "ATTRIBUTES"
.H 2 "Intelligence"
Intelligence is the primary attribute associated with casting
spells. With higher intelligence comes the knowledge of more
spells, the ability to cast more spells, and faster recovery
of spells that have been cast.
.H 2 "Strength"
This is, of course, the measure of a character's physical strength.
With higher strength a character can carry more, cause more damage
when striking, have a better chance to strike an opponent, and
move about more quickly when carrying a load.
.H 2 "Wisdom"
Wisdom is the primary attribute associated with Praying
to a god. With higher wisdom comes the knowledge of more
prayers, the ability to pray more often, and faster recovery
of prayer ability.
.H 2 "Dexterity"
Dexterity is a measure of a character's agility. With higher dexterity
a character is harder to hit, can hit a opponent more easily, and
can move about more quickly when carrying a load.
.H 2 Constitution
Every character has a constitution rating.
A character with an exceptionally good constitution will gain more than
the normal amount of hit points associated with the character's class
when the character reaches a new experience level. Exceptional constitution
also provides better protection versus poison-based attacks and diseases.
.H 2 "Charisma"
Charisma is a measure of a characters looks and general likeableness.
It effects transactions when trying to purchase things.
.H 2 "Experience Levels"
Characters gain experience for killing monsters, stealing from monsters,
and turning monsters.
Each character class has a set of thresholds associated with it.
When a character reaches a threshold, the character attains the next
experience level.
This new level brings extra hit points and a greater chance of success
in performing the abilities associated with the character's class.
For example, magicians receive new spells, and clerics receive new prayers.
.P
.H 2 "Allocating Attributes"
The player starts with 72 "attribute points" to create a character and
can distribute them in any manner among the six attributes described
above.
When prompting the player for each attribute, the game displays the
minimum and maximum allowable values for that attribute.
The player can type a backspace (control-H) to go back and change
a value; typing an escape (ESC) sets the remaining attributes to
the maximum value possible given the remaining attribute points.
.H 1 "THE SCREEN"
During the normal course of play, the screen consists of three separate
sections:~ the top line of the terminal, the bottom two lines of the
terminal, and the remaining middle lines.
The top line reports actions which occur during the game, the middle
section depicts the dungeon, and the bottom lines describe the player's
current condition.
.H 2 "The Top Line"
Whenever anything happens to the player, such as finding a scroll or
hitting or being hit by a monster, a short report of the occurrence
appears on the top line of the screen.
When such reports occur quickly, one right after another,
the game displays the notice followed by the prompt '\(emMore\(em.'~
After reading this notice, the player can press a space to display
the next message.
At such a point, the game ignores all commands until the player presses
a space.
.H 2 "The Dungeon Section"
The large middle section of the screen displays the player's surroundings using
the following symbols:
.tr ~~
.VL 10
.LI |
A wall of a room.
.LI -
A wall of a room.
.LI *
A pile of gold.
.LI %
A way to the next level.
.LI +
A doorway.
.LI .
The floor in a room.
.LI @
The player.
.LI _
The player, when invisible.
.LI #
The floor in a passageway.
.LI !
A flask containing a potion.
.LI ?
A sealed scroll.
.LI :
Some food.
.LI )
A weapon.
.LI \ 
Solid rock (denoted by a space).
.LI ]
Some armor.
.LI ;
A miscellaneous magic item
.LI ,
An artifact
.LI =
A ring.
.LI /
A wand or a staff.
.LI ^
The entrance to a trading post
.LI >
A trapdoor leading to the next level
.LI {
An arrow trap
.LI $
A sleeping gas trap
.LI }
A beartrap
.LI ~
A trap that teleports you somewhere else
.LI \`
A poison dart trap
.LI \fR"\fR
A shimmering magic pool
.LI \'
An entrance to a maze
.LI $
Any magical item. (During magic detection)
.LI >
A blessed magical item. (During magic detection)
.LI <
A cursed magical item. (During magic detection)
.LI A\ letter
A monster.
Note that a given letter may signify multiple monsters,
depending on the level of the dungeon.
The player can always identify a current monster by using
the identify command ('\fB/\fR').
.LE
.tr ~
.H 2 "The Status Section"
The bottom two lines of the screen describe the player's current status.
The first line gives the player's characteristics:
.BL
.LI
Intelligence (\fBInt\fR)
.LI
Strength (\fBStr\fR)
.LI
Wisdom (\fBWis\fR)
.LI
Dexterity (\fBDxt\fR)
.LI
Constitution (\fBConst\fR)
.LI
Charisma (\fBChar\fR)
.LI
Encumberance (\fBCarry\fR)
.LE
.P
Intelligence, strength, wisdom, dexterity, charisma, and constitution have a 
normal maximum of 25, but can be higher when augmented by a ring.
Encumberance is a measurement of how much the player can carry versus
how much he is currently carrying. The more you carry relative to your
maximum causes you to use more food.
.P
The second status line provides the following information:
.BL
.LI
The current level (\fBLvl\fR) in the dungeon.  This number increases as the
player goes further down.
.LI
The player's current number of hit points (\fBHp\fR), followed in parentheses
by the player's current maximum number of hit points.
Hit points express the player's health.
As a player heals by resting, the player's current hit points gradually
increase until reaching the current maximum.
This maximum increases each time a player attains a new experience level.
If the player's current hit points reach 0, the player dies.
.LI
The player's armor class (\fBAc\fR).
This number describes the amount of protection provided by the armor, cloaks, 
and/or rings currently worn by the player. 
It is also affected by high or low dexterity.
Wearing no armor is equivalent to an armor class of 10.
The protection level increases as the armor class decreases.
.LI
The player's current experience level (\fBExp\fR) followed by the player's
experience points.
The player can gain experience points by killing monsters, successfully
stealing from monsters, and turning monsters.
When a player gains enough experience points to surpass a threshold that
depends on the player's character type, the player reaches a new
experience level.
A new experience level brings extra hit points and possibly added
abilities, such as a new spell for a magician or a new prayer for
a cleric.
.LI
A description of the player's character.
This description depends on the player's character type and experience
level.
.LE
.H 1 COMMANDS
A player can invoke most Rogue commands by typing a single character.
Some commands, however, require a direction, in which case the player
types the command character followed by a directional command.
Many commands can be prefaced by a number, indicating how many times
the command should be executed.
.P
When the player invokes a command referring to an item in the player's
pack (such as reading a scroll), the game prompts for the item.
The player should then type the letter associated with the item, as
displayed by the \fBinventory\fR command.
Typing a '*' at this point produces a list of the eligible items.
.P
Rogue understands the following commands:~
.VL 4
.LI ?
Preceding a command by a '\fB?\fR' produces a brief explanation of the command.
The command '\fB?*\fR' gives an explanation of all the commands.
.LI /
Preceding a symbol by a '\fB/\fR' identifies the symbol.
.LI =
Clarify.
After typing an '\fB=\fR' sign, the player can use the movement keys to
position the cursor anywhere on the current level.
As long as the player can normally see the selected position, Rogue will
identify whatever is at that space.
Examples include a \fIsleeping giant rat\fR, a \fIblue potion\fR, and a \fIfood
ration\fR.
.LI h
Move one position to the left.
.LI j
Move one position down.
.LI k
Move one position up.
.LI l
Move one position to the right.
.LI y
Move one position to the top left.
.LI u
Move one position to the top right.
.LI b
Move one position to the bottom left.
.LI n
Move one position to the bottom right.
.LI H
Run to the left until reaching something interesting.
.LI J
Run down until reaching something interesting.
.LI K
Run up until reaching something interesting.
.LI L
Run to the right until reaching something interesting.
.LI Y
Run to the top left until reaching something interesting.
.LI U
Run to the top right until reaching something interesting.
.LI B
Run to the bottom left until reaching something interesting.
.LI N
Run to the bottom right until reaching something interesting.
.LI t
This command prompts for an object from the players pack.
The player then \fBt\fRhrows the object in the specified direction.
.LI f
When this command precedes a directional command, the player moves
in the specified direction until passing something interesting.
.LI z
This command prompts for a wand or staff from the player's pack and
\fBz\fRaps it in the specified direction.
.LI >
Go down to the next level.
.LI <
Go up to the next level.
.LI s
\fBS\fRearch for a secret door or a trap in the circle surrounding the player.
.LI .
This command (a dot) causes the player to rest a turn.
.LI i
Display an \fBi\fRnventory of the player's pack.
.LI I
This command prompts for an item from the player's pack and displays
the \fBi\fRnventory information for that item.
.LI q
\fBQ\fRuaff a potion from the player's pack.
.LI r
\fBR\fRead a scroll from the player's pack.
.LI e
\fBE\fRat some food from the player's pack.
.LI w
\fBW\fRield a weapon from the player's pack.
.LI W
\fBW\fRear some armor, ring, or miscellaneous magic item from the player's pack.
The player can wear a maximum of eight rings.
.LI T
\fBT\fRake off whatever the player is wearing.
.LI ^U
\fBU\fRse a magic item in the player's pack.
.LI d
\fBD\fRrop an item from the player's pack.
.LI P
\fBP\fRick up the items currently under the player.
.LI ^N
When the player types this command, Rogue prompts for a monster or an item
from the player's pack and a one-line \fBn\fRame.
For monsters, the player can use the movement keys to position the cursor
over the desired monster, and Rogue will use the given \fBn\fRame to refer
to that monster.
For items, Rogue gives all similar items (such as all the blue potions)
the specified \fBn\fRame.
.LI m
When the player types this command, Rogue prompts for an item from the
player's pack and a one-line name.
Rogue then \fBm\fRarks the specified item with the given name.
.LI o
Typing this command causes Rogue to display all the settable \fBo\fRptions.
The player can then merely examine the options or change any or all of them.
.LI C
This command, restricted to magicians and rangers
produces a listing of the current supply of spells.
The player can select one of the displayed spells and, if the player's
energy level is sufficiently high, \fBC\fRast it.
The more complicated the spell, the more energy it takes.
.LI c
This command, restricted to druids and rangers
produces a listing of the current supply of chants.
The player can select one of the displayed chants and, if the player's
energy level is sufficiently high, \fBc\fRhant it.
The more complicated the spell, the more energy it takes.
.LI p
This command, restricted to clerics and paladins,
produces a listing of the character's known \fBp\fRrayers.
The player can then offer one of these prayers to the character's deity.
Deities are not known for favoring characters which continually pray
to them, and they are most likely to answer the least "ambitious" prayers.
.LI a
This command is restricted to clerics and paladins
must be followed by a directional command.
If there is an "undead" monster standing next to the player in the
specified direction, there is a chance the player will \fBa\fRffect the
monster by causing it to flee or possibly even destroying it.
.LI *
Count the gold in the player's pack.
.LI ^
This command sets a trap and is limited to thieves and assassins.
If the character is successful, Rogue prompts the player for a type of trap
and sets it where the player is standing.
.LI G
This command is restricted to thieves and assassins.
It causes Rogue to display all the gold on the current level.
.LI D
\fBD\fRip something into a magic pool.
.LI ^T
This command is restricted to thieves and assassins.
It must be followed by a directional command.
If there is a monster standing next to the player in the specified direction,
the player tries to \fBs\fRteal an item from the monster's pack.
If the player is successful, the monster does not notice anything, but if
the player is unsuccessful, there is a chance the monster will wake up.
.LI ^L
Redraw the screen.
.LI ^R
\fBR\fRepeat the last message that was displayed on the top line of the screen.
.LI ^[
Typing an escape will usually cause Rogue to cancel the current command.
.LI v
Print the current Rogue \fBv\fRersion number.
.LI !
Escape to the shell.
.LI S
Quit and \fBs\fRave the game for resumption at a later time.
.LI Q
\fBQ\fRuit without saving the game.
.LE
.H 1 "IMPLICIT COMMANDS"
There is no "attack" command.
If a player wishes to attack a monster, the player simply tries to
move onto the spot where the monster is standing.
The game then assumes that the player wishes to attack the monster
with whatever weapon the player is wielding.
.P
When the player moves onto an item, the game automatically places the
object into the player's pack.
If there is no room left in the pack, the game announces that fact and
leaves the item on the floor.
.H 1 TIME
All actions except for purely bookkeeping commands, such as taking an
inventory, take time.
The amount of time varies with the command.
Swinging a weapon, for example, takes more time than simply moving;
so a monster could move several spaces in the time it takes the player
to make one attack.
The time it takes to swing a weapon also varies based on the bulk of the
weapon, and the time it takes to simply move a space varies with the type
of armor worn.
Movement is always faster when flying.
.P
Since actions take time, some of them can be disrupted.
If the player is casting a spell, for example, and gets hit before finishing
it, the spell is lost.
Similarly, the player might choke if hit while trying to eat.
Of course, the same rule applies when the player hits a monster.
.P
Magical hasting (or slowing) will decrease (or increase) the time it takes
to perform an action.
.H 1 LIGHT
Some rooms in the dungeon possess a natural light source.
In other rooms and in corridors the player can see only those things
within a one space radius from the player.
These dark rooms can be lit with magical light or by a \fIfire beetle\fR.
.H 1 "WEAPONS AND ARMOR"
The player can wield exactly one weapon at a time.
When the player attacks a monster, the amount of damage depends on the
particular weapon the player is wielding.
To fire a projectile weapon, such as a crossbow or a short bow, the player
should wield the bow and "throw" the bolt or arrow at the monster.
.P
A weapon may be cursed or blessed, affecting the likelihood of hitting a
monster with the weapon and the damage the weapon will inflict on the monster.
If the player has identified a weapon, the "to hit" and "to damage" bonuses
appear in that order before the weapon's name in an inventory listing.
A positive bonus indicates a blessed weapon, and a negative bonus usually
indicates a cursed weapon.
The player cannot release a cursed weapon.
.P
Without any armor the player has an armor class of 10.
The lower the player's armor class, the harder it is for a monster to hit
the player, so
wearing armor can improve the player's armor class.
A cursed suit of armor, however, offers poor protection and may sometimes be
worse than no armor at all.
.P
After the player has identified a suit of armor, the protection bonus appears
before the armor's name in an inventory listing.
If the bonus is positive the armor is blessed, and if it is negative, the
armor is usually cursed.
The player cannot remove a cursed suit of armor.
.P
Some monsters can corrode armor when they hit it.
If such a monster hits the player when the player is wearing metal armor,
the armor loses some of its protection value, but the corrosion does not
curse the armor.
This corrosive property can also apply to weapons when the player hits
such a monster.
.H 1 "POTIONS AND SCROLLS"
The player can frequently find potions and scrolls in the dungeon.
In any given dungeon, the player can distinguish among the different types
of potions by a potion's color and among the different types of scrolls
by a scroll's name.
Quaffing a potion or reading a scroll usually causes some magical occurrence.
Most potions and scrolls may be cursed or blessed.
.H 1 RINGS
The player can wear a maximum of eight rings, and
they have a magical effect on the player as long as they are worn.
Some rings also speed up the player's metabolism, making the player require
food more often.
Many rings can be cursed or blessed, and the player cannot remove a
cursed ring.
The player can distinguish among different types of rings by a ring's jewel.
.H 1 "WANDS AND STAVES"
Wands and staves affect the player's environment.
The player can zap a wand or staff at something and perhaps shoot a bolt
of lightning at it or teleport it away.
All wands or staves of the same type are constructed with the same type of wood.
Some wands and staves may be cursed or blessed.
.H 1 FOOD
The player must be careful not to run out of food since moving through the
dungeon fighting monsters consumes a lot of energy.
Starving results in the player's fainting for increasingly longer periods
of time, during which any nearby monster can attack the player freely.
.P
Food comes in the form of standard rations and as a variety of berries.
Some berries have side effects in addition to satisfying one's hunger.
.H 1 GOLD
Gold has one use in a dungeon:~ buying things.
One can buy things in two ways, either in a \fItrading post\fR or from a
\fIquartermaster\fR.
A trading post is a place that sometimes occurs "between levels" of the
dungeon and can be entered by stepping on the entrance.
A quartermaster is a person who will sometimes appear and 
will try to sell the player some of his wares.
These wares are never cursed and frequently blessed, though blessed goods
cost more than normal goods.
If the player chooses to buy one of the quartermaster's items, the
quartermaster trades the item for the specified amount of gold and
disappears.
Attacking a quartermaster causes him to vanish without offering
a trade.
.P
The player starts the game in a trading post with a class-dependent allotment
of gold.
Although there are restrictions on the use of some items (eg. only fighters,
paladins, and rangers can wield two-handed swords), the market will happily
sell the player anything that he can afford.

.H 1 "MISCELLANEOUS MAGIC ITEMS"
Miscellaneous items such as a pair of boots or a book may be found within the 
dungeon.
These items can usually be used to the player's advantage (assuming they are
not cursed).
Some of these items can be worn, such as a cloak, while others are to be used,
such as a book.
.H 1 "ARTIFACTS"
Some monsters down in the depths of the dungeon carry unique artifacts.
The game begins as a quest to retrieve one of these items.
Each artifact appears only on its owner's person.
These items also can usually be used to the player's advantage. However,
care must be taken when handling them for they are intelligent and will
reject mishandling or abuse. These items consume food and merely carrying 
them will result in increased food use.
.H 1 TRAPS
A variety of traps, including trap doors, bear traps, and sleeping traps, are
hidden in the dungeon.
They remain hidden until sprung by a monster or the player.
A sprung trap continues to function, but since it is visible, an intelligent
monster is not likely to tread on it.
.H 1 "THE MONSTERS"
Each monster except for the merchant \fIquartermaster\fR appears in
a limited range of dungeon levels.
All monsters of the same type share the same abilities;
all \fIgiant rats\fR, for example, can give the player a disease, and
all \fIjackalweres\fR can put the player to sleep.
Monsters of the same type can vary, however, such that one \fIkobold\fR
may be much more difficult to kill than another one.
In general, the more difficult it is to kill a monster, the more
experience points the monster is worth.
.P
Most monsters attack by biting and clawing, but some monsters carry
weapons, including such projectile weapons as short bows and crossbows,
and some monsters have breath weapons.
Some monsters even use magical items, such as wands.
Monsters with distance weapons or magic can attack the player from across a room
or down a corridor.
.P
Some monsters are more intelligent than others, and the more intelligent
a monster, the more likely that the monster will run away if it is about
to die.
A fleeing monster will not attack the player unless cornered.
.P
It is sometimes possible to enlist a monster's aid.
Reading a \fIcharm monster\fR scroll, for example, or singing a \fIcharm
monster\fR chant can make a monster believe the player is its friend.
A charmed monster will fight hostile monsters for the player as long as they are
not of its race.
.P
As the player moves down in the dungeon, the monsters get more powerful.
Deep down in the dungeon there exist some one-of-a-kind monsters.
These monsters are greatly feared.
However, once a "unique monster" is killed, the player will not find 
another in the current dungeon.
.H 1 OPTIONS
Rogue has several options which may be set by the player:~
.VL 7
.LI \fBterse\fR
Setting this Boolean option results in shorter messages appearing on
the top line of the screen.
.LI \fBjump\fR
Setting this Boolean option results in waiting until the player has
finished running to draw the player's path.
Otherwise the game always displays the path one step at a time.
.LI \fBstep\fR
Setting this Boolean option results in most listings, such as an inventory,
appearing one item at a time on the top line of the screen.
When this option is not set, the game clears the screen, displays the
list, and then redraws the dungeon.
.LI \fBflush\fR
Setting this Boolean option results in flushing all typeahead (pending) commands
when the player encounters a monster.
.LI \fBaskme\fR
Setting this Boolean option results in the game prompting the player for a
name upon encountering a new type of scroll, potion, ring, staff, or wand.
.LI \fBpickup\fR
This option specifys whether items should be picked up automatically as the
rogue steps over them.
In the non-automatic mode, the player may still pick up items via the
pickup (P) command.
The option defaults to true.
.LI \fBname\fR
This string is the player's name and defaults to the player's account name.
.LI \fBfile\fR
This string, which defaults to rogue.save, specifies the file to use for
saving the game.
.LI \fBscore\fR
This string identifies the top-twenty score file to use for the game.
.LI \fBclass\fR
This option specifies the character class of the rogue.
It can be set only in the ROGUEOPTS environment variable.
.LI \fBquested~item\fR
.br
This option is set by the game at the start and cannot be reset by the player.
It is merely listed to remind the player of his quest.
.LE
.P
The player can set options at the beginning of a game via the ROGUEOPTS
environment variable.
Naming a Boolean option sets it, and preceding the Boolean option name by
"no" clears it.
The syntax "stringoption=name" sets a string option to "name."~
So setting ROGUEOPTS to
"terse, jump, nostep, flush, askme, name=Ivan~the~Terrible"
would set the \fIterse, jump, flush\fR, and \fIaskme\fR Boolean options,
clear the \fIstep\fR Boolean option, set the player's
\fIname\fR to "Ivan the Terrible," and use the defaults for
the \fIsave file\fR and the \fIscore file\fR.
.P
The player may change an option at any time during the game
via the \fBoption\fR command, which results in a listing of
the current options.
Typing a new value changes the option, a RETURN moves to the
next option, a '-' moves to the previous option, and an ESCAPE
returns the player to the dungeon.
.H 1 SCORING
The player receives experience points for stealing items from
monsters, turning monsters (a clerical ability), and killing
monsters.
When the player gets killed, the player's score equals the player's
experience points.
A player who quits gets a score equal to the player's experience
points and gold.
If the player makes it back up out of the dungeon, the player's
score equals the player's experience points plus the gold the
player carried and the gold received from selling the player's
possessions.
.P
Rogue maintains a list of the top twenty scores to date, together
with the name of the player obtaining the score, the level where
the player finished, and the manner in which the player ended the
game.
As an installation option, the game may record only one entry per
character type and login;
this restriction encourages a greater number of different players
in the scorechart.
.H 1 ACKNOWLEDGEMENTS
This version of Rogue is based on a version developed at the
University of California.
