#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <iostream.h>
#include <time.h>      //used by randomize()
#include <dos.h>
#include <graphics.h>
#include <string.h>
#include <math.h>      //for sinus sound

const left = 109;
const top  =  59;
const emptyColor  = BLUE;
const usedColor   = LIGHTBLUE;
const wallColor   = DARKGRAY;
const targetColor = GREEN;
const playerColor = LIGHTGREEN;
const mineColor   = LIGHTRED;

const infocolor   = LIGHTGRAY;

const withoutMines = 0;
const withMines    = 1;

const number_of_walls = 50;  //min. 9 walls !!!


enum FieldValues {empty, used, wall, player, target, mine};


struct gamer
{
 char name[10];
 long score;
 int mines;
 unsigned long pltime;
};


void paintBoard(FieldValues field[20][20], int paintMines);
void paintField(int x, int y, FieldValues field);
void paintMineNumber(int x, int y, FieldValues field[20][20]);
void Intro(void);
void initBoard(FieldValues field[20][20], int numMines);
void clearGFXboard();
int getMines(int x, int y, FieldValues field[20][20]);
int y2i(int y);
int x2i(int x);
void looseGame(void);
void winGame(unsigned long ptime, int movs, int mines, FieldValues field[20][20]);
void information(void);
void showNumber(int N, int x, int y);
void highscore(long score, int M, int ptime);


// M A I N
void main(void)
 {
 // *****
 FieldValues board[20][20];       //chessboard
 int px=0, py=0;                  //coordinates of player in board array
 int opx=0, opy=0;                //last coordinates of player in board array
 int moves;			  //number of player moves
 int mines;			  //number of mines in game
 unsigned long start_time;
 unsigned long play_time;

 int gdriver = VGA, gmode = VGAHI, errorcode;   //used for graphic mode

 char msg[80];                                  //string for various messages
 int i;
 int x, y;
 int mnx;
 int mny;
 char key; //userinput via getch()
 // *****

 clrscr();
 mines = 30;  //start value for mines. can be changed with keys '-' and '+'
 randomize();

 initgraph(&gdriver, &gmode, "..\\bgi");  //init graph
 errorcode = graphresult();
 if (errorcode != grOk)  /* an error occurred */
 {
   printf("Graphics error: %s\n", grapherrormsg(errorcode));
   printf("Please make sure you have a VGA compatible video card installed.\n");
   printf("Press any key to exit:");
   getch();
   exit(1); /* terminate with an error code */
 }

 Intro();  //build GUI
 key='w';  //int key to prevent random value

 do {
  moves=0;    //reset No. of moves
  showNumber(moves,3,6);  //show No. of moves

  gotoxy(9,13);
  printf("%d ",mines);  //show No. of mines

  //set player position and prev. player position
  px=0;
  py=0;
  opx=0;
  opy=0;

  start_time=time(NULL);  //set new start time
  play_time=0;            //reset playtime

  initBoard(board, mines);            //place walls and mines
  paintBoard(board, withoutMines);

  do
   {

   if (moves!=0) play_time=difftime(time(NULL),start_time);  //calculate play_time when key is pressed
   showNumber(play_time,3,10);   //refresh playtime display

   if (play_time > 7200) key='n';  //when play_time exeeds 2 hours game will be resetet

   if (kbhit())
    {
    key = getch();   //get key
    if (moves==0) start_time=time(NULL);  //set start_time when key is pressed

    if (key=='-')
     {
     mines--;
     if (mines < 10) mines =10;
     key='n';
     }

    else if (key=='+')
     {
     mines++;
     if (mines > 90) mines =90;
     key='n';
     }

    else if (key=='i')
     {
     information();
     paintBoard(board, withoutMines);
     for (mny=0;mny<20;mny++)
      {
      for (mnx=0;mnx<20;mnx++)
       {
       if ((board[mnx][mny]==player)||(board[mnx][mny]==used)) paintMineNumber(mnx, mny, board);
       }
      }
     key=' ';
     }

    if (key==NULL)   //special key was pressed (cursors, F1..F12, ...)
     {
     key=getch();   //get 2nd key char

     switch (key)   //was cursor?
      {
      case 'K':   //left
	      if (px>0 && board[px-1][py]!=wall)
	       {
	       opx=px;
	       opy=py;
	       px--;
	       moves++;
	       }
	      break;
      case 'M':   //right
	      if (px<19 && board[px+1][py]!=wall)
	       {
	       opx=px;
	       opy=py;
	       px++;
	       moves++;
	       }
	      break;
      case 'H':   //up
	      if (py>0 && board[px][py-1]!=wall)
	       {
	       opy=py;
	       opx=px;
	       py--;
	       moves++;
	       }
	      break;
      case 'P':   //down
	      if (py<19 && board[px][py+1]!=wall)
	       {
	       opy=py;
	       opx=px;
	       py++;
	       moves++;
	       }
	      break;
      }//switch key

      if (board[px][py]==mine)  //player hit a minefiled
       {
       looseGame();
       key='n';    //while-loop will be exitet and board will be painted with mines
       }
      else if (board[px][py]==target)  //player reaches target
       {
       winGame(play_time,moves,mines,board);
       key='n';    //while-loop will be exitet and board will be painted with mines
       }
      else   //nothing hit - just moved player
       {
       board[opx][opy]=used;
       paintField(left+opx*20,top+opy*20,used);
       paintMineNumber(opx,opy,board);
       board[px][py]=player;
       paintField(left+px*20,top+py*20,player);
       paintMineNumber(px,py,board);
       showNumber(moves,3,6);
       }

     } //key was NULL (special key)

   } //if kbhit

   } while(key!='e' && key!='n' && key!=27);   //game end or new game

  if (key=='n')     //new game?
   {
   if (moves>0)
    {
    paintBoard(board, withMines);
    while(getch()==NULL) getch();
    }
   key=' ';        //Doesn't matter what key is - but it must be != 'n' (and != 'e' or ESC)
   }

  if (moves>0) clearGFXboard();

 } while (key!='e' && key!=27);  //game end with keys 'e' or ESCAPE


 closegraph();    //leave graphic mod

 gotoxy(1,1);
 printf("See ya later!\n\n");

 } // E N D   O F   M A I N


void paintField(int x, int y, FieldValues field)
 {
 setcolor(LIGHTGRAY);
 rectangle(x,y,x+20,y+20);
 switch (field)
     {
     case empty:
	    setfillstyle(SOLID_FILL, emptyColor);
	    floodfill(x+10, y+10, LIGHTGRAY);
	    break;
     case used:
	    setfillstyle(SOLID_FILL, usedColor);
	    floodfill(x+10, y+10, LIGHTGRAY);
	    break;
     case wall:
	    setfillstyle(SOLID_FILL, wallColor);
	    floodfill(x+10, y+10, LIGHTGRAY);
	    break;
     case player:
	    setfillstyle(SOLID_FILL, playerColor);
	    floodfill(x+10, y+10, LIGHTGRAY);
	    break;
     case target:
	    setfillstyle(SOLID_FILL, targetColor);
	    floodfill(x+10, y+10, LIGHTGRAY);
	    break;
     case mine:
	    setfillstyle(SOLID_FILL, mineColor);
	    floodfill(x+10, y+10, LIGHTGRAY);
	    setcolor(BLACK);
	    circle(x+10,y+10,5);
	    setfillstyle(SOLID_FILL, BLACK);
	    floodfill(x+10, y+10, BLACK);
	    line(x+10,y+2,x+10,y+18);
	    line(x+2,y+10,x+18,y+10);
	    break;
     } //switch

 }


int getMines(int x, int y, FieldValues field[20][20])
 {
 int a, b;
 int M;   //number of mines

 M=0;

 for(b=y-1;b<=y+1;b++)
  for(a=x-1;a<=x+1;a++)
   if ((a>=0)&&(a<20)&&(b>=0)&&(b<20))
    if (field[a][b]==mine) M++;
 return M;
 }


void paintMineNumber(int x, int y, FieldValues field[20][20])
 {
 char nMines[5];  //string for number of mines

 if ((field[x][y]==player)||(field[x][y]==used))
  {
  settextjustify(CENTER_TEXT, CENTER_TEXT);
  setcolor(0);
  itoa(getMines(x,y,field),nMines,10);        //get number of mines near xy
  outtextxy(left+x*20+10,top+y*20+10,nMines); //print nMines in field
  }
 }


void paintBoard(FieldValues field[20][20], int paintMines)
 {
  int i;
  int z;

  setcolor(LIGHTGRAY);
  for (z=0;z<20;z++)
   for (i=0;i<20;i++)
    {
    if (field[i][z]==mine && paintMines==withoutMines) paintField(left+i*20,top+z*20,empty);
    else paintField(left+i*20,top+z*20,field[i][z]);
    if (field[i][z]==player || field[i][z]==used) paintMineNumber(i,z,field);
    }

  setcolor(WHITE);
  rectangle(left-1,top-1,left+401,top+401);

 }


void Intro(void)
{
 const c = 14;
 int i, x, y;

 for (i=0;i<300;i++)
  {
   putpixel(320-i,24,c);
   putpixel(320+i,24,c);
   putpixel(320-i,23,c);
   putpixel(320+i,23,c);
   sound(i+100);
   putpixel(320-i,470,c);
   putpixel(320+i,470,c);
   putpixel(320-i,471,c);
   putpixel(320+i,471,c);
   if (!kbhit()) delay(10);
  }
 nosound();

 setcolor(LIGHTGREEN);
 settextjustify(CENTER_TEXT, CENTER_TEXT);
 x = getmaxx() / 2;
 y = 17;
 outtextxy(x, y, "SUPER MINESWEEPER");

 setcolor(LIGHTGRAY);
 settextjustify(RIGHT_TEXT, CENTER_TEXT);
 x = getmaxx();
 y = 36;
 outtextxy(x, y, "by Philipp Bank, 2005  ");

 settextjustify(CENTER_TEXT, CENTER_TEXT);

 for(i=100;i<400;i++)
  {
  sound(i*2+sin(i/100)*500);
  delay((410-i)%2);
  }
 nosound();


 //text on right side

 settextjustify(LEFT_TEXT, CENTER_TEXT);
 setcolor(WHITE);
 outtextxy(531, 80, "Legend:");

 paintField(530,100,player);
 setcolor(LIGHTGRAY);
 outtextxy(530, 130, "player");

 paintField(530,145,target);
 setcolor(LIGHTGRAY);
 outtextxy(530, 175, "target");

 paintField(530,190,empty);
 setcolor(LIGHTGRAY);
 outtextxy(530, 220, "unknown field");

 paintField(530,235,used);
 setcolor(LIGHTGRAY);
 outtextxy(530, 265, "known field");

 paintField(530,280,wall);
 setcolor(LIGHTGRAY);
 outtextxy(530, 310, "unpassable");

 setcolor(WHITE);
 outtextxy(517, 350, "Numbers in");
 outtextxy(517, 362, "fields indicate");
 outtextxy(517, 374, "the number of");
 outtextxy(517, 386, "surrounding");
 outtextxy(517, 398, "mine fields!");


 //text on left side

 outtextxy(5, 240, "Press '+' or");
 outtextxy(5, 252, "'-' key to");
 outtextxy(5, 264, "change number");
 outtextxy(5, 276, "of mines.");

 outtextxy(5, 302, "Press 'n'");
 outtextxy(5, 314, "to restart");
 outtextxy(5, 326, "game or");
 outtextxy(5, 338, "ESC or 'e'");
 outtextxy(5, 350, "to exit.");

 outtextxy(5, 374, "Use cursor");
 outtextxy(5, 386, "keys to");
 outtextxy(5, 398, "navigate.");

 outtextxy(5, 422, "Press 'i'");
 outtextxy(5, 434, "for more");
 outtextxy(5, 446, "information.");

 outtextxy(10, 72, "Moves:");

 outtextxy(10, 136, "Time (Sec):");

 outtextxy(10, 200, "Mines:");

 settextjustify(CENTER_TEXT, CENTER_TEXT);
}


void initBoard(FieldValues field[20][20], int numMines)
{
 const px=0;
 const py=0;
 const tx=19;
 const ty=19;
 int i, x, y;


 for (y=0;y<20;y++)
  for (x=0;x<20;x++)
   field[x][y]=empty;

 field[px][py]=player;    //place player
 field[tx][ty]=target;    //place target

 //place walls near target
 field[17][19]=wall;
 field[19][17]=wall;
 field[16][16]=wall;
 field[16][15]=wall;
 field[16][14]=wall;
 field[16][13]=wall;
 field[15][16]=wall;
 field[14][16]=wall;
 field[13][16]=wall;
 //place some random walls
 i = 0;
 do
  {
  x=random(20);
  y=random(20);
  if ((field[x][y]==empty) && ((x>2)||(y>2)) && ((x<17)||(y<17)))
   {
   field[x][y]=wall;
   i++;
   }
  } while (i<(number_of_walls-9));

 //place Mines
 i = 0;
 do
  {
  x=random(20);
  y=random(20);
  if ((field[x][y]==empty) && ((x>2)||(y>2)) && ((x<17)||(y<17)))
   {
   field[x][y]=mine;
   i++;
   }
  } while (i<numMines);

}

int x2i(int x)
 {
 return((x-left)/20);
 }

int y2i(int y)
 {
 return((y-top)/20);
 }

void clearGFXboard()
 {
  setfillstyle(SOLID_FILL, BLACK);
  floodfill(left+10, top+10, WHITE);
 }

void looseGame(void)
 {
 clearGFXboard();
 setcolor(LIGHTRED);
 outtextxy(getmaxx() / 2, getmaxy() / 2, "YOU ARE SUCH A LOOSER!!!");
 setcolor(LIGHTGREEN);
 outtextxy(getmaxx() / 2, getmaxy() / 2+90, "Press any key!");
 if (getch()==NULL) getch();
 }


void winGame(unsigned long ptime, int movs, int mines, FieldValues field[20][20])
 {
 char s1[10];
 char s2[10];
 char s3[10];
 char s[100];
 int i, x, y;
 int used_fields;
 int empty_fields;
 unsigned long score;


 //calculate number of used fields
 used_fields=0;
 for (y=0;y<20;y++)
  for (x=0;x<20;x++)
   if (field[x][y]==used) used_fields++;

 //calculate number of emtpy fields at game start
 empty_fields=(398-mines)-number_of_walls;

 clearGFXboard();

 itoa(ptime,s1,10);          //play_time
 itoa(used_fields,s2,10);    //used fields
 itoa(mines,s3,10);          //number of mines


 setcolor(YELLOW);
 outtextxy(getmaxx() / 2, getmaxy() / 2-30, "CONGRATULATIONS!!!");

 setcolor(LIGHTCYAN);

 strcpy(s,"You needed ");
 strcat(s,s1);
 strcat(s," seconds and you uncovered");
 outtextxy(getmaxx() / 2, getmaxy() / 2+20, s);

 strcpy(s,s2);
 strcat(s," of ");
 itoa(empty_fields,s2,10);    //empty fields
 strcat(s,s2);
 strcat(s," free fields to reach target");
 outtextxy(getmaxx() / 2, getmaxy() / 2+30, s);

 strcpy(s,"in a game with ");
 strcat(s,s3);
 strcat(s," mines!");
 outtextxy(getmaxx() / 2, getmaxy() / 2+40, s);

 score=(long) ( ((double)mines*(double)mines*(double)mines*(double)mines) / (double)(ptime) );
 score = score - (movs*10);
 if (score<0) score=0;

 setcolor(YELLOW);
 ltoa(score,s2,10);           //score
 strcpy(s,"YOU RECIEVED A SCORE OF ");
 strcat(s,s2);
 strcat(s," POINTS!");
 outtextxy(getmaxx() / 2, getmaxy() / 2+60, s);

 setcolor(LIGHTGREEN);
 outtextxy(getmaxx() / 2, getmaxy() / 2+90, "Press any key!");

 if (getch()==NULL) getch();

 highscore(score, mines, ptime);  //show highscores

 }

void showNumber(int N, int x, int y)
 {
  setcolor(LIGHTGRAY);
  gotoxy(x,y);
  printf("%05d ",N);
 }

void highscore(long score, int M, int ptime)
 {
 const hy=180;
 const hx=145;

 FILE* pfile;        //file pointer to highscore file
 gamer gamers[11];   //array of gamers
 int   i;
 int x,y;
 int is_highscore;
 char outxystr[20];
 char bufferstr[20];

 char player_name[10]; //name of player
 char c;
 int charcounter;
 int hsplace;           //place in highscorelist

 char gname[10];
 long gscore;
 int  gmines;
 unsigned long gptime;
 char strend;



 if ((pfile=fopen("mines.hsc","r")) == NULL)  //open file failed
  {
  fclose(pfile);
  pfile=fopen("mines.hsc","w");             //create file
  for (i=0;i<10;i++)
   {
   fprintf(pfile,"%d,%d,%d,Player%d\n",1100-(i*100),20-i,60+i,i+1);  //generate highscore file
   }
  fclose(pfile);
  }


 pfile=fopen("mines.hsc","r+");  //open file for read & write

 //read highscores and store in array
 for (i=0;i<10;i++)
  {
  fscanf(pfile,"%ld,%d,%lu,%s\n",&gamers[i].score,&gamers[i].mines,&gamers[i].pltime,gamers[i].name);
  }
 fclose(pfile);


 if (score>gamers[9].score) //new highscore?
  {
  is_highscore=1;
  clearGFXboard();
  setcolor(LIGHTBLUE);
  settextjustify(CENTER_TEXT, CENTER_TEXT);
  x = getmaxx() / 2;
  y = 180;
  outtextxy(x, y, "YOU RECIEVED A NEW HIGHSCORE!!!");

  setcolor(LIGHTBLUE);
  settextjustify(CENTER_TEXT, CENTER_TEXT);
  x = getmaxx() / 2;
  y = 210;
  outtextxy(x, y, "Please enter your name:");

  strcpy(player_name,"");

  charcounter=0;
  c=' ';

  gotoxy(35,15);
  printf(">");
  gotoxy(36,16);
  printf("");
  do
   {
   c=getch();
   if ((charcounter<9) && ((c >='a' && c<='z') || (c >='A' && c<='Z') || (c >='0' && c<='9')))  //valid character?
    {
    player_name[charcounter]=c;
    gotoxy(36+charcounter,15);
    printf("%c",c);
    charcounter++;
    }
   else if (c=='\b' && charcounter>0)
    {
    charcounter--;
    gotoxy(36+charcounter,15);
    printf(" ");
    gotoxy(36+charcounter,15);
    }

   } while (c != 13);

  if(charcounter==0) player_name[0]='?';

  //append ' ' to player_name if lenght of player_name is <9
  for (i=charcounter;i<9;i++)
   player_name[i]=' ';

  //remove user name from display
  gotoxy(35,15);
  printf("          ");
  gotoxy(36,15);
  printf("          ");


  //calc ranking in highscore (0 means 1st place - 9 means last place)
  hsplace=9;
  while (score > gamers[hsplace-1].score && hsplace > 0)
   {
   hsplace--;
   }


  //insert player in gamers array
  for(i=9;i >= hsplace;i--)
   {
   strcpy(gamers[i+1].name,gamers[i].name);
   gamers[i+1].score=gamers[i].score;
   gamers[i+1].mines=gamers[i].mines;
   gamers[i+1].pltime=gamers[i].pltime;
   }
  strcpy(gamers[hsplace].name,player_name);
  gamers[hsplace].score = score;
  gamers[hsplace].mines = M;
  gamers[hsplace].pltime = ptime;


  //save highscore list back to file
  pfile=fopen("mines.hsc","w");  //open file for write
  //read highscores from gamers-array and save to highscore file
  for (i=0;i<10;i++)
   {
   fprintf(pfile,"%ld,%d,%lu,%s\n",gamers[i].score,gamers[i].mines,gamers[i].pltime,gamers[i].name);
   }
  fclose(pfile);


  } //is highscore true?
  else is_highscore=0;

  //show highscores

  clearGFXboard();
  setcolor(LIGHTBLUE);
  settextjustify(CENTER_TEXT, CENTER_TEXT);
  x = getmaxx() / 2;
  y = 120;
  outtextxy(x, y, "HIGHSCORE LIST");

  setcolor(WHITE);
  line(x-80,127,x+80,127);

  settextjustify(LEFT_TEXT, CENTER_TEXT);
  x=hx;

  setcolor(LIGHTBLUE);
  outtextxy(hx, hy-18,"No.  Name           Score   Mines     Time");

  for(i=0;i<10;i++)
   {
   y = hy+i*17;

   setcolor(YELLOW);
   itoa(i+1,outxystr,10);
   outtextxy(x, y, outxystr);

   setcolor(WHITE);
   outtextxy(x+40, y, gamers[i].name);

   settextjustify(RIGHT_TEXT, CENTER_TEXT);
   setcolor(YELLOW);
   ltoa(gamers[i].score,outxystr,10);
   outtextxy(x+200, y, outxystr);
   settextjustify(LEFT_TEXT, CENTER_TEXT);

   setcolor(WHITE);
   itoa(gamers[i].mines,outxystr,10);
   outtextxy(x+245, y, outxystr);

   settextjustify(RIGHT_TEXT, CENTER_TEXT);
   setcolor(WHITE);
   ultoa(gamers[i].pltime,outxystr,10);
   strcat(outxystr," s");
   outtextxy(x+337, y, outxystr);
   settextjustify(LEFT_TEXT, CENTER_TEXT);

   } //for i
 if (is_highscore==0)
  {
  setcolor(WHITE);
  outtextxy(hx,y+26, "Your score:");
  ltoa(score,outxystr,10);
  setcolor(YELLOW);
  outtextxy(hx+90, y+26, outxystr);
  }
 else
  {
  setcolor(LIGHTRED);
  outtextxy(hx-12,hy+hsplace*17, ">");
  }


 settextjustify(CENTER_TEXT, CENTER_TEXT);
 setcolor(LIGHTBLUE);
 outtextxy(getmaxx() / 2, 400, "Press any key!");

 getch();
 }

void information(void)
 {


 clearGFXboard();
 settextjustify(CENTER_TEXT, CENTER_TEXT);
 setcolor(LIGHTBLUE);
 outtextxy(getmaxx() / 2, 100, "Information 1 of 2");

 settextjustify(LEFT_TEXT, CENTER_TEXT);
 setcolor(infocolor);


 outtextxy(left+20, 120, "To win this nice little game you need to move");
 outtextxy(left+20, 132, "the player from the upper left corner through");
 outtextxy(left+20, 144, "a mined area to the target field.");

 outtextxy(left+20, 160, "To move the player use the ");
 setcolor(LIGHTRED);
 outtextxy(left+20+textwidth("To move the player use the "), 160, "cusor keys");
 setcolor(infocolor);
 outtextxy(left+20+textwidth("To move the player use the cursor key"), 160, ".");

 outtextxy(left+20, 176, "The area divided by 20x20 fields.");
 outtextxy(left+20, 188, "50 fields are blockated by unpassable walls.");
 outtextxy(left+20, 200, "And some fields contain unvisibile mines.");
 outtextxy(left+20, 212, "If the player enters a mined field, the game");
 outtextxy(left+20, 224, "is lost and the area will be uncovered.");
 outtextxy(left+20, 236, "The ");
 setcolor(LIGHTRED);
 outtextxy(left+20+textwidth("The "), 236, "number of mines");
 setcolor(infocolor);
 outtextxy(left+20+textwidth("The number of mines"), 236, " in the area is displayed");
 setcolor(infocolor);
 outtextxy(left+20, 248, "at the left screen side.");
 outtextxy(left+20, 260, "This number can be changed at any time by");
 outtextxy(left+20, 272, "pressing ");
 setcolor(LIGHTRED);
 outtextxy(left+20+textwidth("pressing "), 272, "+    -");
 setcolor(infocolor);
 outtextxy(left+20+textwidth("pressing + "), 272, "or   key.");
 outtextxy(left+20, 284, "If you change the number of mines, the game");
 outtextxy(left+20, 296, "will be restartet with a new area.");

 outtextxy(left+20, 312, "You can also start a");
 setcolor(LIGHTRED);
 outtextxy(left+20, 312, "                     new game");
 setcolor(infocolor);
 outtextxy(left+20, 312, "                              by pressing ");
 setcolor(LIGHTRED);
 outtextxy(left+20, 312, "                                          n");
 setcolor(infocolor);
 outtextxy(left+20, 312, "                                           .");

 outtextxy(left+20, 328, "If the player enters a unmined field, the");
 outtextxy(left+20, 340, "previous position will be marked as a 'known'");
 outtextxy(left+20, 352, "field.");
 outtextxy(left+20, 364, "Known fields and the player field show a");
 outtextxy(left+20, 376, "number. This number is corresponding to the");
 outtextxy(left+20, 388, "number of surrounding minefields.");
 outtextxy(left+20, 400, "So you can find a way to the target field by");
 outtextxy(left+20, 412, "combine these numbers (and with some luck).");

 settextjustify(CENTER_TEXT, CENTER_TEXT);
 setcolor(LIGHTGREEN);
 outtextxy(getmaxx() / 2, 435, "Press any key to continue...");
 getch();




 clearGFXboard();
 settextjustify(CENTER_TEXT, CENTER_TEXT);
 setcolor(LIGHTBLUE);
 outtextxy(getmaxx() / 2, 100, "Information 2 of 2");

 settextjustify(LEFT_TEXT, CENTER_TEXT);
 setcolor(infocolor);


 outtextxy(left+20, 120, "If the target field is reached, your ");
 setcolor(LIGHTRED);
 outtextxy(left+20, 120, "                                     score");
 setcolor(infocolor);
 outtextxy(left+20, 132, "is given by this formula:");

 settextjustify(CENTER_TEXT, CENTER_TEXT);

 outtextxy(getmaxx() / 2, 155, "[mines] * [mines]                ");
 outtextxy(getmaxx() / 2, 157, "___________________  - [10 * moves]");
 outtextxy(getmaxx() / 2, 167, "      [time]                       ");
 setcolor(infocolor);

 setcolor(LIGHTRED);
 outtextxy(getmaxx() / 2, 200, "Maybe you reach a new HIGHSCORE!?");

 setcolor(LIGHTBLUE);
 outtextxy(getmaxx() / 2, 220, "TRY NOW!");

 settextjustify(CENTER_TEXT, CENTER_TEXT);
 setcolor(LIGHTGREEN);
 outtextxy(getmaxx() / 2, 435, "Press any key!");
 getch();





 clearGFXboard();
 }
