/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 600)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
    password = 0
)
/******************************************************************************/
(instance public rm600 of Rm
	(properties
		picture 1
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(150 130)
					loop(1)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (send gTheMusic:
			prevSignal(0)
			stop()
			number(799)
			loop(-1)
			play()
		)
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState opening)
        (var dyingScript, button)
        =state opening
             (switch(state)
                (case 0= cycles 1
                )(case 1= cycles 10
                )(case 2= cycles 10
                    (exit:init()setCycle(End)cycleSpeed(2)setPri(1))
                    (extras:init()setCycle(End)cycleSpeed(2)setPri(1))
                    (gameroom:init()setCycle(End)cycleSpeed(2)setPri(1))
                    //DrawPic(1 dpOPEN_INSTANTLY 1 1)
                )(case 10
                    = RM1_OPENING 1
                    (send gGame:changeScore(1))
                )(case 11=cycles 15
                    (gate:init()setCycle(End)cycleSpeed(3)setPri(7))
                    (send gEgo:observeControl(ctlRED))
                )
            )
    )
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if(Said('open/door,gate'))
            Print("You have to know the password to enter. To learn the password, you simply have to beat the game.")
        )
        (if(Said('kill/cheat'))
            Print("OH YEAH!")
            (send gEgo:ignoreControl(ctlRED))
            (gate:hide())
            = password 1
        )
        (if(Said('look'))
            Print("You are in an empty room")
        )
 	)
    (method (doit)
        (var button)
        (super:doit)
        (if(== (send gEgo:onControl())ctlMAROON)
            (send gRoom:newRoom(2))
        )
        (if(== (send gEgo:onControl())ctlSILVER)
            (if(not(password))
                Print("What's the password?"#title"Did you beat the game?")
                (send gEgo:posn(140 140))
                (RoomScript:changeState(11))
            )(else
                (send gRoom:newRoom(400))
            )
        )
        (if(== (send gEgo:onControl())ctlGREY)
            = button Print("Do you want to quit?"
                #title "Getting the crap out huh?"
                #button "Quit" 0
                #button "Play" 1
            )
            (if(== button 0)
                = gQuitGame 1
            )(else
                (send gEgo:posn(140 140))
            )

        )

    )
)
(instance beast of Act
    (properties
        x 10
        y 40
        view 2
    )
)
(instance exit of Prop
    (properties
        x 18
        y 65
        view 100
    )
)
(instance extras of Prop
    (properties
        x 301
        y 65
        view 100
        loop 1
    )
)(instance gameroom of Prop
    (properties
        x 160
        y 48
        view 100
        loop 2
    )
)
(instance gate of Prop
    (properties
        x 282
        y 160
        view 200
    )
)

/******************************************************************************/
