/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
(use "wander")
(use "follow")
(local
    password = 0
)
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))

  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
            (case 2 (send gEgo: posn(160 135)loop(2)))
            (default
  				(send gEgo:posn(150 145)loop(1))
  			)
  		)

		// Set up the ego
		SetUpEgo()
        (if (INCOSTUME)
            (send gEgo:view(11))
        )(if(RM2_GOTWATCH)
            (send gEgo:put(1))
        )(else
            (send gEgo:get(1))//INV_MONEY
        )
        /****************************************
         * Set up the room's music to play here *
         ****************************************/


        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState opening)
        (var dyingScript, button)
        =state opening
             (switch(state)
                (case 0= cycles 1
                    (if (not(RM1_OPENING))
                        DrawPic(999 dpOPEN_INSTANTLY 1 0)
                        (-- gSpeed)(-- gSpeed)(-- gSpeed)
                        Print("This is a fan-made game. All characters are borrowed from Homestarrunner.com which is owned by the Brothers Chaps."#title"Disclaimer:"#font LARGE_FONT)
                    )(else
                        (send gEgo:init())
                        DrawPic(1 dpOPEN_INSTANTLY 1 0)
                    )
                )(case 1= cycles 10
                )(case 2= cycles 10
                    (if (not(RM1_OPENING))
                    (ProgramControl())
                    Print("Dear Strong Bad,                    "+
                    "                I want to play an old style computer game."+
                    "                                           Crapfully yours,                          "+
                    "        the Player                                ")
                    Print("Well 'the player', let's get ourselves a character.")
                    Print("Whad'ya say?")
                    Print("Yeah I think Strong Bad would be a great main character too! Here you go.")
                    )(else
                        (RoomScript:changeState(9))
                    )
                )(case 3= cycles 20
                    (send gEgo:init()loop(2))
                )(case 4= cycles 10
                    Print("Yeah that looks about right. All tall and muscular-like.")
                    (send gEgo:posn(150 145)loop(2))
                )(case 5= cycles 10
                    Print("Now about the scenery...")
                    Print("How about a super cool-cutting art-state of the edge computer world?")
                    (send gTheMusic:prevSignal(0)stop()number(799)loop(0)play())
                    (send gEgo:posn(150 145)loop(2))
                )(case 6= cycles 10
                    DrawPic(1 dpOPEN_INSTANTLY 1 0)
                )(case 7= cycles 10
                    Print("Yeah, now that's pretty nice.")
                    Print("What now?")
                )(case 8= cycles 10
                    Print("Follow the signs stupid!")
                    (PlayerControl())
                )(case 9= cycles 10
                    (exit:init()setCycle(End)cycleSpeed(2)setPri(1))
                    (extras:init()setCycle(End)cycleSpeed(2)setPri(1))
                    (gameroom:init()setCycle(End)cycleSpeed(2)setPri(1))
                    //DrawPic(1 dpOPEN_INSTANTLY 1 1)
                )(case 10
                    = RM1_OPENING 1
                    (send gGame:changeScore(1))
                )(case 11=cycles 15
                    (gate:init()setCycle(End)cycleSpeed(3)setPri(7))
                    (send gEgo:observeControl(ctlRED))
                )
            )
    )
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if(Said('open/door,gate'))
            Print("You have to know the password to enter. To learn the password, you simply have to beat the game.")
        )
        (if(Said('kill/cheat'))
            Print("Password correct")
            (send gEgo:ignoreControl(ctlRED))
            (gate:hide())
            = password 1
        )
        (if(Said('look'))
            Print("You are in a room with 3 doors. Go to the one you want.")
        )
 	)
    (method (doit)
        (var button)
        (super:doit)
        (if(== (send gEgo:onControl())ctlMAROON)
            (send gRoom:newRoom(2))
        )
        (if(== (send gEgo:onControl())ctlSILVER)
            (if(not(password))
                Print("What's the password?"#title"Did you beat the game?")
                (send gEgo:posn(140 140))
                (RoomScript:changeState(11))
            )(else
                (send gRoom:newRoom(400))
            )
        )
        (if(== (send gEgo:onControl())ctlGREY)
            = button Print("Do you want to quit?"
                #title "Getting the crap out huh?"
                #button "Quit" 0
                #button "Play" 1
            )
            (if(== button 0)
                = gQuitGame 1
            )(else
                (send gEgo:posn(140 140))
            )

        )

    )
)
(instance beast of Act
    (properties
        x 10
        y 40
        view 2
    )
)
(instance exit of Prop
    (properties
        x 18
        y 65
        view 100
    )
)
(instance extras of Prop
    (properties
        x 301
        y 65
        view 100
        loop 1
    )
)(instance gameroom of Prop
    (properties
        x 160
        y 48
        view 100
        loop 2
    )
)
(instance gate of Prop
    (properties
        x 282
        y 160
        view 200
    )
)
/******************************************************************************/
