/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 titlescreen.sc
 Contains the title screen room.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script TITLESCREEN_SCRIPT)
/******************************************************************************/
(use "main")
(use "game")
(use "menubar")
(use "obj")
(use "cycle")
(use "user")
(use "controls")
(use "feature")
(local
Ldown = 0
Lpress = 0
)
/******************************************************************************/
(instance public TitleScreen of Rm
	(properties
		picture scriptNumber
	)
	(method (init)
        // Set up the title screen
		ProgramControl()
		= gProgramControl FALSE
		(send gGame:setSpeed(1))
		(SL:disable())
		(TheMenuBar:hide())

		(super:init())
		(self:setScript(RoomScript))

		(send gEgo:
			init()
			hide()
		)

        (logo:init())


        /****************************************
         * Set up the room's music to play here *
         ****************************************/
        (send gTheMusic:
			prevSignal(0)
			stop()
			number(800)
			loop(0)
			play()
		)
        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
		Display(
			"Profile Games"
			dsCOORD 10 40
			dsCOLOUR clBLACK
			dsBACKGROUND clTRANSPARENT
		)
        Display(
			"presents:"
			dsCOORD 50 62
			dsCOLOUR clWHITE
			dsBACKGROUND clTRANSPARENT
		)
        Display(
			"Quest for the Cheat"
			dsCOORD 10 100
			dsCOLOUR clRED
			dsBACKGROUND clTRANSPARENT
		)
        Display(
			"Version 1.0"
			dsCOORD 10 140
			dsCOLOUR clRED
			dsBACKGROUND clTRANSPARENT
		)
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)     /*
    (method (changeState newState)
        = state newState
        /************************************
         * Add the state related stuff here *
         ************************************/
    //)
    (method (changeState opening)
        (var dyingScript, button)
        =state opening
         (switch(state)
            (case 0= cycles 100
            )(case 1= cycles 50
                (thing2:init() setCycle(Fwd) cycleSpeed(4)setPri(1))
            )(case 2= cycles 150
                (thing1:init() show() setCycle(End) cycleSpeed(4)setPri(1))
            )(case 3= cycles 10
                (thing1:hide())
            )(case 4= cycles 50
                (if(not (Ldown))
                    (paper:init() setCycle(End) cycleSpeed(4)setPri(2))
                    = Ldown 1
                )
            )(case 5= cycles 50
                    (if(not(Lpress))
                    (press:init()setPri(3)setCycle(End)cycleSpeed(4))
                    = Lpress 1
                )
                (RoomScript:changeState(0))
            )
        )
    )
	(method (handleEvent pEvent)
        (super:handleEvent(pEvent))
        (if( not (send pEvent:claimed) )
			(if( (== (send pEvent:type) evKEYBOARD) and (== (send pEvent:message) $3C00) )
				ToggleSound()
			)(else
                /******************************************
                 * If the title screen has music, fade it *
                 ******************************************/
				//(send gTheMusic:fade())

                // End the title screen, start the game
				(send gRoom:newRoom(INITROOMS_SCRIPT))
		    )
		)
	)
)
(instance thing1 of Prop
    (properties
        x 241
        y 148
        view 700
    )
)
(instance thing2 of Prop
    (properties
        x 241
        y 148
        view 701
    )
)(instance thing3 of Prop
    (properties
        x 164
        y 100
        view 700
    )
)(instance thing4 of Prop
    (properties
        x 100
        y 132
        view 700
    )
)
(instance paper of Prop
    (properties
        x 160
        y 23
        view 703
    )
)
(instance press of Prop
    (properties
        x 230
        y 22
        view 703
        loop 1
    )
)
(instance logo of Prop
    (properties
        x 27
        y 80
        view 999
    )
)
/******************************************************************************/
