.model medium, basic
.stack 20h
.386

EXTRN gsclipx1:WORD
EXTRN gsclipx2:WORD
EXTRN gsclipy1:WORD
EXTRN gsclipy2:WORD

.CODE
;sub gsputt2(x,y,varseg(screen),varptr(screen),varseg(Array),varptr(array))
;stack layout:
;bp+16  x
;bp+14  y
;bp+12  screenseg
;bp+10  screenofs
;bp+8   aryseg
;bp+6   aryofs
;bp+4   returnseg
;bp+2   returnofs
;bp+0   bp         (after pushing it on the first line)
;bp-2   toadd      (this is pushed several lines after the 'mov bp,sp')
;bp-4   x1
;bp-6   y1
;bp-8   x2
;bp-10  y2
;bp-12  ds
;bp-14  es
;bp-16  special thingy
; es:di = screen
; ds:si = array

public gsputt2
gsputt2 proc 

;intro stuff, (memory management, getting variables set up, etc)

push bp
xor bx,bx         ;heh.... I could have done this a few lines up, but    

mov cx, gsclipx1
mov dx, gsclipy1

mov bp,sp
push bx           ;I had already written the stack layout before that... 

push cx
push dx

mov cx, gsclipx2
mov dx, gsclipy2

push cx
push dx

push es
push ds

mov ds, [bp+8]    ;
mov si, [bp+6]    ;es:di = array

mov di, [bp+10]   ;ds:si = screen
mov es, [bp+12]   ;

mov dx, [si]   ;dx = width*8
add si, 2         ;move di to the location of the height

shr dx, 3
mov bx, [si]   ;bx = height

add si, 2         ;di is now at the starting location of the image...
;;;;;;;;;         ;important stuff :)
mov cx, [bp+14]   ;cx = Y     

cmp cx, [bp-10]   ;if it is waaay too low, then exit
jg endofspr

cmp cx, [bp-6]
jl toohigh        ;if it is above the screen, then goto Toohigh

aftertoohigh:
mov ax, cx        ;\

shl ax, 2         ; \

add ax, cx        ; /ax = cx *320

shl ax, 6         ;/

add di, ax        ;offset the screen to the correct row
;;;;;;; at this point: bx=height, dx = width, cx = Y location
;now check to see if it is partially off of the bottom of the screen
mov ax, cx        ;ax = Y

add ax, bx        ;ax = Y + height (the bottom pixel)

cmp ax, [bp-10]
jg toolow         ;if it is too low, then goto toolow to be 'cropped'

aftertoolow:
;;;;;;;; atp: bx = fully corrected height, dx=uncorrected width, cx=Y, ax=:oP
mov ax, [bp+16]   ;ax = X location

cmp ax, [bp-8]         ;waaay too far to the right? then exit
jg endofspr

cmp ax, [bp-4]
jl tooleft        ;partially off of the screen to the left?

Aftertooleft:
add di, ax        ;if it is fully on the screen, adjust the screen's offset   
;;;;;;;;atp: ax = X,bx=height,cx=Y,dx=width
;now, check to see if it is partally off of the right side of the screen
add dx, ax        ;running out of registers now :oP

cmp dx, [bp-8]         ;dx = width + X
jg tooright       ;greater than 319? goto tooright to be cropped

sub dx, ax        ;dx = width + X - X = width
aftertooright:
mov cx, dx        ;cx = width

jmp sprloop

toohigh:
neg cx            ;cx = -Y

add cx, [bp-6]

sub bx, cx
jle endofspr    ;if it is waaay too high, end

toohighloop:
add si,dx         ;dx = width

loop toohighloop  ;basically the same as a mul, but I don't like mul :)

mov cx, [bp-6]
jmp aftertoohigh  ;now cx = 0, 

toolow:
sub ax, [bp-10]  ;ax = Y

dec ax

sub bx, ax        ;bx = height... this "crops" the height...
jmp aftertoolow 

tooleft:
neg ax            ;ax = abs(X)

add ax, [bp-4]

sub dx, ax        ;if ax (=X) is too far to the left, end...
jle endofspr      ;width = width + X (crops the width)

add si, ax        ;ax(=-X) is < 0, di = the array's offset...
mov [bp-2], ax    ;[bp-2] is a weird little error-corrector that is used in 
                  ;the main loop to skip over the unneeded pixels
mov ax, [bp-4]  
jmp aftertooleft

tooright:
sub dx, [bp-8]         ;now dx = X + width - 319

dec dx

add [bp-2],dx     ;add dx to the mysterious error-corrector :)
mov dx, [bp-8] 

inc dx            ;\

sub dx, ax        ;/now the sprite's width is just from X to 319...
jmp aftertooright

;;;;;;
;atp, ax is for pixels, bx = height, cx = width counter, dx = real width
;es:di = screen
;ds:si = array

sprloop:
mov ah, [si]      ;ah = current byte from the array
inc si                     ;move to the next pixel in the array

cmp ah, 0                  ;if it is 0, then move to the next byte...
je endofsprloop
mov al, es:[di]
and ax, 0000111111110000b
xor ah, al
mov es:[di], ah            ;puts the result into the screen

endofsprloop:
inc di   

dec cx
jnz sprloop

add di, 320                ;if at the end of row, move down a row on the scrn
mov cx, dx                 ;cx = real width again...

mov ax, [bp-2]
sub di, cx                 ;move the screen offset to the starting X coord

add si, ax             ;move aryoffset up (in case it is off the edge of
dec bx                        ;the screen

jnz sprloop
           
endofspr:    ;either the thing is really far off the edge of the screen
pop ds       ;or it is finished... either way, restore ds&bp, & end
pop es

pop eax
pop edx

pop bx
pop bp 

ret 12         ;restore the stack & end
gsputt2 endp     ;the end :o)



end
