COLOR 7, 0: CLS
PRINT "Cribbage Solitaire - A solitaire/patience game"
PRINT "Copyright (C) 2004  Justin Somerton (j_somerton@roadrunner.nf.net)"
PRINT ""
PRINT "Justin Somerton"
PRINT "539 Old Broad Cove Road"
PRINT "Portugal Cove - St. Philip's, NL"
PRINT "Canada  A1M 1Z1"
PRINT ""
PRINT "This program is free software; you can redistribute it and/or modify"
PRINT "it under the terms of the GNU General Public License as published by"
PRINT "the Free Software Foundation; either version 2 of the License, or"
PRINT "(at your option) any later version."
PRINT ""
PRINT "This program is distributed in the hope that it will be useful,"
PRINT "but WITHOUT ANY WARRANTY; without even the implied warranty of"
PRINT "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
PRINT "GNU General Public License for more details."
PRINT ""
PRINT "You should have received a copy of the GNU General Public License"
PRINT "along with this program; if not, write to the Free Software"
PRINT "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA"
PRINT ""
LOCATE 23, 1: PRINT "Press any key to continue . . ."
DO: LOOP WHILE INKEY$ = ""
3 COLOR 13, 1: CLS
LOCATE 2, 1
PRINT "                "
PRINT "                                                "
PRINT "                       "
PRINT "                                              "
PRINT "                        "
PRINT ""
PRINT "                   "
PRINT "                                                 "
PRINT "                             "
PRINT "                                                 "
PRINT "                           "
COLOR 7, 1
LOCATE 23, 4: PRINT "Version 2.02"
LOCATE 23, 54: PRINT "(C) 2004 Justin Somerton"
LOCATE 17, 14: PRINT "Instructions, Play, Reset High Scores, Quit (I/P/R/Q)"
IPQ$ = UCASE$(INPUT$(1))
IF IPQ$ = "" THEN GOTO 3
IF IPQ$ = "I" THEN GOSUB INST
IF IPQ$ = "P" THEN GOTO 5
IF IPQ$ = "Q" THEN COLOR 7, 0: CLS
IF IPQ$ = "Q" THEN END
IF IPQ$ = "R" THEN GOSUB RESETSCORES
IF IPQ$ = CHR$(27) THEN COLOR 7, 0: CLS
IF IPQ$ = CHR$(27) THEN END

GOTO 3

5 CLEAR
COLOR 7, 1: CLS

LOCATE 2, 48: PRINT "ͻ"
LOCATE 3, 48: PRINT "                         "
LOCATE 4, 48: PRINT "  A    B    C    D    E  "
LOCATE 5, 48: PRINT "                         "
LOCATE 6, 48: PRINT "͹"
LOCATE 7, 48: PRINT "                         "
LOCATE 8, 48: PRINT "  F    G    H    I    J  "
LOCATE 9, 48: PRINT "                         "
LOCATE 10, 48: PRINT "͹"
LOCATE 11, 48: PRINT "                         "
LOCATE 12, 48: PRINT "  K    L    M    N    O  "
LOCATE 13, 48: PRINT "                         "
LOCATE 14, 48: PRINT "͹"
LOCATE 15, 48: PRINT "                         "
LOCATE 16, 48: PRINT "  P    Q    R    S    T  "
LOCATE 17, 48: PRINT "                         "
LOCATE 18, 48: PRINT "͹"
LOCATE 19, 48: PRINT "                         "
LOCATE 20, 48: PRINT "  U    V    W    X    Y  "
LOCATE 21, 48: PRINT "                         "
LOCATE 22, 48: PRINT "ͼ"
COLOR 13, 5
LOCATE 2, 3: PRINT ""
LOCATE 3, 3: PRINT ""
LOCATE 4, 3: PRINT ""
COLOR 7, 1
8 IF GOTAG% = 1 THEN GOSUB GOODBYE
TGT$ = "Z"
GOSUB TGT
IF GP90% = 0 THEN GOSUB PICKACARD
IF GP90% = 0 THEN GOSUB CARDREC
IF GP90% = 0 THEN GOTO 8
PIST% = 0
TGT$ = ""
COLOR 7, 1
TGT$ = UCASE$(INPUT$(1))
IF TGT$ = CHR$(27) THEN COLOR 7, 0
IF TGT$ = CHR$(27) THEN CLS
IF TGT$ = CHR$(27) THEN END
LOCATE 7, 30: PRINT "      "
LOCATE 8, 1: PRINT "                                  "
LOCATE 9, 1: PRINT "                                  "
LOCATE 10, 1: PRINT "                                  "
LOCATE 11, 1: PRINT "                                  "
LOCATE 12, 1: PRINT "                                  "
LOCATE 13, 1: PRINT "                                  "
LOCATE 14, 1: PRINT "                                  "

IF TGT$ = "" THEN GOTO 8
IF ASC(TGT$) < 65 THEN GOTO 8
IF ASC(TGT$) > 89 THEN GOTO 8
GOSUB POSTAKEN
IF PIST% = 0 THEN GOSUB POSRECORD
IF PIST% = 0 THEN GOSUB TGT
IF PIST% = 0 THEN C% = GP90%
IF PIST% = 0 THEN GOSUB CARDX
IF PIST% = 0 THEN GOSUB CARDREC
IF PIST% = 1 THEN SOUND 75, 5
IF PIST% = 1 THEN FOR VVV = 1 TO 8000: NEXT VVV

GOTO 8
COLOR 7, 0: CLS
END

INST:
COLOR 7, 1: CLS
LOCATE 2, 3: PRINT "The object of this game is to arrange 25 cards to form the 10 best cribbage"
LOCATE 3, 3: PRINT "hands. The 25 cards will be laid out on a 5x5 grid, each row and column"
LOCATE 4, 3: PRINT "representing one cribbage hand."
LOCATE 6, 3: PRINT "For those familiar with Cribbage, each hand consists of the player's regular"
LOCATE 7, 3: PRINT "cards plus the starter card, totaling 5 cards. Unlike regular Cribbage,"
LOCATE 8, 3: PRINT "however, all 5 cards of the hand are chosen by the player."
LOCATE 10, 3: PRINT "To place cards, each place is represented by a letter. Press the letter"
LOCATE 11, 3: PRINT "of the grid where you want to place your next card. The next card is close"
LOCATE 12, 3: PRINT "to the top left corner."
LOCATE 14, 3: PRINT "Once all 25 cards are placed, the Cribbage scoring system (with a few"
LOCATE 15, 3: PRINT "modifications) is used to count the score of each hand."
LOCATE 22, 3: PRINT "Press any key to continue . . ."
DO: LOOP WHILE INKEY$ = ""
RETURN

TGT:

IF TGT$ = "A" THEN TGTA% = 3
IF TGT$ = "A" THEN TGTB% = 49
IF TGT$ = "A" THEN TGTC% = 4
IF TGT$ = "A" THEN TGTE% = 5

IF TGT$ = "B" THEN TGTA% = 3
IF TGT$ = "B" THEN TGTB% = 55
IF TGT$ = "B" THEN TGTC% = 4
IF TGT$ = "B" THEN TGTE% = 5

IF TGT$ = "C" THEN TGTA% = 3
IF TGT$ = "C" THEN TGTB% = 61
IF TGT$ = "C" THEN TGTC% = 4
IF TGT$ = "C" THEN TGTE% = 5

IF TGT$ = "D" THEN TGTA% = 3
IF TGT$ = "D" THEN TGTB% = 67
IF TGT$ = "D" THEN TGTC% = 4
IF TGT$ = "D" THEN TGTE% = 5

IF TGT$ = "E" THEN TGTA% = 3
IF TGT$ = "E" THEN TGTB% = 73
IF TGT$ = "E" THEN TGTC% = 4
IF TGT$ = "E" THEN TGTE% = 5

IF TGT$ = "F" THEN TGTA% = 7
IF TGT$ = "F" THEN TGTB% = 49
IF TGT$ = "F" THEN TGTC% = 8
IF TGT$ = "F" THEN TGTE% = 9

IF TGT$ = "G" THEN TGTA% = 7
IF TGT$ = "G" THEN TGTB% = 55
IF TGT$ = "G" THEN TGTC% = 8
IF TGT$ = "G" THEN TGTE% = 9

IF TGT$ = "H" THEN TGTA% = 7
IF TGT$ = "H" THEN TGTB% = 61
IF TGT$ = "H" THEN TGTC% = 8
IF TGT$ = "H" THEN TGTE% = 9

IF TGT$ = "I" THEN TGTA% = 7
IF TGT$ = "I" THEN TGTB% = 67
IF TGT$ = "I" THEN TGTC% = 8
IF TGT$ = "I" THEN TGTE% = 9

IF TGT$ = "J" THEN TGTA% = 7
IF TGT$ = "J" THEN TGTB% = 73
IF TGT$ = "J" THEN TGTC% = 8
IF TGT$ = "J" THEN TGTE% = 9

IF TGT$ = "K" THEN TGTA% = 11
IF TGT$ = "K" THEN TGTB% = 49
IF TGT$ = "K" THEN TGTC% = 12
IF TGT$ = "K" THEN TGTE% = 13

IF TGT$ = "L" THEN TGTA% = 11
IF TGT$ = "L" THEN TGTB% = 55
IF TGT$ = "L" THEN TGTC% = 12
IF TGT$ = "L" THEN TGTE% = 13

IF TGT$ = "M" THEN TGTA% = 11
IF TGT$ = "M" THEN TGTB% = 61
IF TGT$ = "M" THEN TGTC% = 12
IF TGT$ = "M" THEN TGTE% = 13

IF TGT$ = "N" THEN TGTA% = 11
IF TGT$ = "N" THEN TGTB% = 67
IF TGT$ = "N" THEN TGTC% = 12
IF TGT$ = "N" THEN TGTE% = 13

IF TGT$ = "O" THEN TGTA% = 11
IF TGT$ = "O" THEN TGTB% = 73
IF TGT$ = "O" THEN TGTC% = 12
IF TGT$ = "O" THEN TGTE% = 13

IF TGT$ = "P" THEN TGTA% = 15
IF TGT$ = "P" THEN TGTB% = 49
IF TGT$ = "P" THEN TGTC% = 16
IF TGT$ = "P" THEN TGTE% = 17

IF TGT$ = "Q" THEN TGTA% = 15
IF TGT$ = "Q" THEN TGTB% = 55
IF TGT$ = "Q" THEN TGTC% = 16
IF TGT$ = "Q" THEN TGTE% = 17

IF TGT$ = "R" THEN TGTA% = 15
IF TGT$ = "R" THEN TGTB% = 61
IF TGT$ = "R" THEN TGTC% = 16
IF TGT$ = "R" THEN TGTE% = 17

IF TGT$ = "S" THEN TGTA% = 15
IF TGT$ = "S" THEN TGTB% = 67
IF TGT$ = "S" THEN TGTC% = 16
IF TGT$ = "S" THEN TGTE% = 17

IF TGT$ = "T" THEN TGTA% = 15
IF TGT$ = "T" THEN TGTB% = 73
IF TGT$ = "T" THEN TGTC% = 16
IF TGT$ = "T" THEN TGTE% = 17

IF TGT$ = "U" THEN TGTA% = 19
IF TGT$ = "U" THEN TGTB% = 49
IF TGT$ = "U" THEN TGTC% = 20
IF TGT$ = "U" THEN TGTE% = 21

IF TGT$ = "V" THEN TGTA% = 19
IF TGT$ = "V" THEN TGTB% = 55
IF TGT$ = "V" THEN TGTC% = 20
IF TGT$ = "V" THEN TGTE% = 21

IF TGT$ = "W" THEN TGTA% = 19
IF TGT$ = "W" THEN TGTB% = 61
IF TGT$ = "W" THEN TGTC% = 20
IF TGT$ = "W" THEN TGTE% = 21

IF TGT$ = "X" THEN TGTA% = 19
IF TGT$ = "X" THEN TGTB% = 67
IF TGT$ = "X" THEN TGTC% = 20
IF TGT$ = "X" THEN TGTE% = 21

IF TGT$ = "Y" THEN TGTA% = 19
IF TGT$ = "Y" THEN TGTB% = 73
IF TGT$ = "Y" THEN TGTC% = 20
IF TGT$ = "Y" THEN TGTE% = 21

IF TGT$ = "Z" THEN TGTA% = 2
IF TGT$ = "Z" THEN TGTB% = 10
IF TGT$ = "Z" THEN TGTC% = 3
IF TGT$ = "Z" THEN TGTE% = 4

RETURN

PICKACARD:

6019 TC% = 0
6022 RANDOMIZE COS(TIMER)
C% = INT(RND * 52) + 1
IF C% = 0 THEN GOTO 6022
IF C% > 52 THEN GOTO 6022
GOSUB CARDX

RETURN

CARDX:
IF C% = 1 THEN GOSUB ACEH
IF C% = 2 THEN GOSUB ACED
IF C% = 3 THEN GOSUB ACEC
IF C% = 4 THEN GOSUB ACES

IF C% = 5 THEN GOSUB TWOH
IF C% = 6 THEN GOSUB TWOD
IF C% = 7 THEN GOSUB TWOC
IF C% = 8 THEN GOSUB TWOS

IF C% = 9 THEN GOSUB THREEH
IF C% = 10 THEN GOSUB THREED
IF C% = 11 THEN GOSUB THREEC
IF C% = 12 THEN GOSUB THREES

IF C% = 13 THEN GOSUB FOURH
IF C% = 14 THEN GOSUB FOURD
IF C% = 15 THEN GOSUB FOURC
IF C% = 16 THEN GOSUB FOURS

IF C% = 17 THEN GOSUB FIVEH
IF C% = 18 THEN GOSUB FIVED
IF C% = 19 THEN GOSUB FIVEC
IF C% = 20 THEN GOSUB FIVES

IF C% = 21 THEN GOSUB SIXH
IF C% = 22 THEN GOSUB SIXD
IF C% = 23 THEN GOSUB SIXC
IF C% = 24 THEN GOSUB SIXS

IF C% = 25 THEN GOSUB SEVENH
IF C% = 26 THEN GOSUB SEVEND
IF C% = 27 THEN GOSUB SEVENC
IF C% = 28 THEN GOSUB SEVENS

IF C% = 29 THEN GOSUB EIGHTH
IF C% = 30 THEN GOSUB EIGHTD
IF C% = 31 THEN GOSUB EIGHTC
IF C% = 32 THEN GOSUB EIGHTS

IF C% = 33 THEN GOSUB NINEH
IF C% = 34 THEN GOSUB NINED
IF C% = 35 THEN GOSUB NINEC
IF C% = 36 THEN GOSUB NINES

IF C% = 37 THEN GOSUB TENH
IF C% = 38 THEN GOSUB TEND
IF C% = 39 THEN GOSUB TENC
IF C% = 40 THEN GOSUB TENS

IF C% = 41 THEN GOSUB JACKH
IF C% = 42 THEN GOSUB JACKD
IF C% = 43 THEN GOSUB JACKC
IF C% = 44 THEN GOSUB JACKS

IF C% = 45 THEN GOSUB QUEENH
IF C% = 46 THEN GOSUB QUEEND
IF C% = 47 THEN GOSUB QUEENC
IF C% = 48 THEN GOSUB QUEENS

IF C% = 49 THEN GOSUB KINGH
IF C% = 50 THEN GOSUB KINGD
IF C% = 51 THEN GOSUB KINGC
IF C% = 52 THEN GOSUB KINGS

IF TC% = 1 THEN GOTO 6019

IF C% = 1 THEN HACE% = 1
IF C% = 2 THEN DACE% = 1
IF C% = 3 THEN CACE% = 1
IF C% = 4 THEN SACE% = 1

IF C% = 5 THEN HTWO% = 1
IF C% = 6 THEN DTWO% = 1
IF C% = 7 THEN CTWO% = 1
IF C% = 8 THEN STWO% = 1

IF C% = 9 THEN HTHREE% = 1
IF C% = 10 THEN DTHREE% = 1
IF C% = 11 THEN CTHREE% = 1
IF C% = 12 THEN STHREE% = 1

IF C% = 13 THEN HFOUR% = 1
IF C% = 14 THEN DFOUR% = 1
IF C% = 15 THEN CFOUR% = 1
IF C% = 16 THEN SFOUR% = 1

IF C% = 17 THEN HFIVE% = 1
IF C% = 18 THEN DFIVE% = 1
IF C% = 19 THEN CFIVE% = 1
IF C% = 20 THEN SFIVE% = 1

IF C% = 21 THEN HSIX% = 1
IF C% = 22 THEN DSIX% = 1
IF C% = 23 THEN CSIX% = 1
IF C% = 24 THEN SSIX% = 1

IF C% = 25 THEN HSEVEN% = 1
IF C% = 26 THEN DSEVEN% = 1
IF C% = 27 THEN CSEVEN% = 1
IF C% = 28 THEN SSEVEN% = 1

IF C% = 29 THEN HEIGHT% = 1
IF C% = 30 THEN DEIGHT% = 1
IF C% = 31 THEN CEIGHT% = 1
IF C% = 32 THEN SEIGHT% = 1

IF C% = 33 THEN HNINE% = 1
IF C% = 34 THEN DNINE% = 1
IF C% = 35 THEN CNINE% = 1
IF C% = 36 THEN SNINE% = 1

IF C% = 37 THEN HTEN% = 1
IF C% = 38 THEN DTEN% = 1
IF C% = 39 THEN CTEN% = 1
IF C% = 40 THEN STEN% = 1

IF C% = 41 THEN HJACK% = 1
IF C% = 42 THEN DJACK% = 1
IF C% = 43 THEN CJACK% = 1
IF C% = 44 THEN SJACK% = 1

IF C% = 45 THEN HQUEEN% = 1
IF C% = 46 THEN DQUEEN% = 1
IF C% = 47 THEN CQUEEN% = 1
IF C% = 48 THEN SQUEEN% = 1

IF C% = 49 THEN HKING% = 1
IF C% = 50 THEN DKING% = 1
IF C% = 51 THEN CKING% = 1
IF C% = 52 THEN SKING% = 1

COLOR 7, 1


RETURN

ACEH:
IF GP90% = 1 THEN GOTO 801
IF HACE% = 1 THEN TC% = 1
IF HACE% = 1 THEN RETURN

801 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "A    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    A"


RETURN

ACED:
IF GP90% = 2 THEN GOTO 802
IF DACE% = 1 THEN TC% = 1
IF DACE% = 1 THEN RETURN

802 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "A    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    A"


RETURN

ACEC:
IF GP90% = 3 THEN GOTO 803
IF CACE% = 1 THEN TC% = 1
IF CACE% = 1 THEN RETURN

803 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "A    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    A"


RETURN

ACES:
IF GP90% = 4 THEN GOTO 804
IF SACE% = 1 THEN TC% = 1
IF SACE% = 1 THEN RETURN

804 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "A    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    A"


RETURN

TWOH:
IF GP90% = 5 THEN GOTO 805
IF HTWO% = 1 THEN TC% = 1
IF HTWO% = 1 THEN RETURN

805 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "2    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    2"

RETURN

TWOD:
IF GP90% = 6 THEN GOTO 806
IF DTWO% = 1 THEN TC% = 1
IF DTWO% = 1 THEN RETURN

806 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "2    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    2"


RETURN

TWOC:
IF GP90% = 7 THEN GOTO 807
IF CTWO% = 1 THEN TC% = 1
IF CTWO% = 1 THEN RETURN

807 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "2    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    2"


RETURN

TWOS:
IF GP90% = 8 THEN GOTO 808
IF STWO% = 1 THEN TC% = 1
IF STWO% = 1 THEN RETURN

808 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "2    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    2"

RETURN


THREEH:
IF GP90% = 9 THEN GOTO 809
IF HTHREE% = 1 THEN TC% = 1
IF HTHREE% = 1 THEN RETURN

809 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "3    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    3"


RETURN

THREED:
IF GP90% = 10 THEN GOTO 810
IF DTHREE% = 1 THEN TC% = 1
IF DTHREE% = 1 THEN RETURN

810 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "3    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    3"


RETURN

THREEC:
IF GP90% = 11 THEN GOTO 811
IF CTHREE% = 1 THEN TC% = 1
IF CTHREE% = 1 THEN RETURN

811 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "3    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    3"


RETURN

THREES:
IF GP90% = 12 THEN GOTO 812
IF STHREE% = 1 THEN TC% = 1
IF STHREE% = 1 THEN RETURN

812 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "3    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    3"

RETURN

FOURH:
IF GP90% = 13 THEN GOTO 813
IF HFOUR% = 1 THEN TC% = 1
IF HFOUR% = 1 THEN RETURN

813 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "4    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    4"


RETURN

FOURD:
IF GP90% = 14 THEN GOTO 814
IF DFOUR% = 1 THEN TC% = 1
IF DFOUR% = 1 THEN RETURN

814 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "4    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    4"


RETURN

FOURC:
IF GP90% = 15 THEN GOTO 815
IF CFOUR% = 1 THEN TC% = 1
IF CFOUR% = 1 THEN RETURN

815 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "4    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    4"


RETURN

FOURS:
IF GP90% = 16 THEN GOTO 816
IF SFOUR% = 1 THEN TC% = 1
IF SFOUR% = 1 THEN RETURN

816 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "4    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    4"

RETURN

FIVEH:
IF GP90% = 17 THEN GOTO 817
IF HFIVE% = 1 THEN TC% = 1
IF HFIVE% = 1 THEN RETURN

817 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "5    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    5"


RETURN

FIVED:
IF GP90% = 18 THEN GOTO 818
IF DFIVE% = 1 THEN TC% = 1
IF DFIVE% = 1 THEN RETURN

818 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "5    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    5"


RETURN

FIVEC:
IF GP90% = 19 THEN GOTO 819
IF CFIVE% = 1 THEN TC% = 1
IF CFIVE% = 1 THEN RETURN

819 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "5    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    5"


RETURN

FIVES:
IF GP90% = 20 THEN GOTO 820
IF SFIVE% = 1 THEN TC% = 1
IF SFIVE% = 1 THEN RETURN

820 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "5    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    5"

RETURN

SIXH:
IF GP90% = 21 THEN GOTO 821
IF HSIX% = 1 THEN TC% = 1
IF HSIX% = 1 THEN RETURN

821 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "6    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    6"


RETURN

SIXD:
IF GP90% = 22 THEN GOTO 822
IF DSIX% = 1 THEN TC% = 1
IF DSIX% = 1 THEN RETURN

822 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "6    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    6"


RETURN

SIXC:
IF GP90% = 23 THEN GOTO 823
IF CSIX% = 1 THEN TC% = 1
IF CSIX% = 1 THEN RETURN

823 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "6    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    6"


RETURN

SIXS:
IF GP90% = 24 THEN GOTO 824
IF SSIX% = 1 THEN TC% = 1
IF SSIX% = 1 THEN RETURN

824 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "6    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    6"

RETURN

SEVENH:
IF GP90% = 25 THEN GOTO 825
IF HSEVEN% = 1 THEN TC% = 1
IF HSEVEN% = 1 THEN RETURN

825 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "7    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    7"


RETURN

SEVEND:
IF GP90% = 26 THEN GOTO 826
IF DSEVEN% = 1 THEN TC% = 1
IF DSEVEN% = 1 THEN RETURN

826 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "7    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    7"


RETURN

SEVENC:
IF GP90% = 27 THEN GOTO 827
IF CSEVEN% = 1 THEN TC% = 1
IF CSEVEN% = 1 THEN RETURN

827 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "7    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    7"


RETURN

SEVENS:
IF GP90% = 28 THEN GOTO 828
IF SSEVEN% = 1 THEN TC% = 1
IF SSEVEN% = 1 THEN RETURN

828 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "7    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    7"

RETURN

EIGHTH:
IF GP90% = 29 THEN GOTO 829
IF HEIGHT% = 1 THEN TC% = 1
IF HEIGHT% = 1 THEN RETURN

829 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "8    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    8"


RETURN

EIGHTD:
IF GP90% = 30 THEN GOTO 830
IF DEIGHT% = 1 THEN TC% = 1
IF DEIGHT% = 1 THEN RETURN

830 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "8    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    8"


RETURN

EIGHTC:
IF GP90% = 31 THEN GOTO 831
IF CEIGHT% = 1 THEN TC% = 1
IF CEIGHT% = 1 THEN RETURN

831 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "8    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    8"


RETURN

EIGHTS:
IF GP90% = 32 THEN GOTO 832
IF SEIGHT% = 1 THEN TC% = 1
IF SEIGHT% = 1 THEN RETURN

832 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "8    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    8"

RETURN

NINEH:
IF GP90% = 33 THEN GOTO 833
IF HNINE% = 1 THEN TC% = 1
IF HNINE% = 1 THEN RETURN

833 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "9    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    9"


RETURN

NINED:
IF GP90% = 34 THEN GOTO 834
IF DNINE% = 1 THEN TC% = 1
IF DNINE% = 1 THEN RETURN

834 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "9    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    9"


RETURN

NINEC:
IF GP90% = 35 THEN GOTO 835
IF CNINE% = 1 THEN TC% = 1
IF CNINE% = 1 THEN RETURN

835 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "9    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    9"


RETURN

NINES:
IF GP90% = 36 THEN GOTO 836
IF SNINE% = 1 THEN TC% = 1
IF SNINE% = 1 THEN RETURN

836 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "9    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    9"

RETURN

TENH:
IF GP90% = 37 THEN GOTO 837
IF HTEN% = 1 THEN TC% = 1
IF HTEN% = 1 THEN RETURN

837 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "10   "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "   10"


RETURN

TEND:
IF GP90% = 38 THEN GOTO 838
IF DTEN% = 1 THEN TC% = 1
IF DTEN% = 1 THEN RETURN

838 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "10   "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "   10"


RETURN

TENC:
IF GP90% = 39 THEN GOTO 839
IF CTEN% = 1 THEN TC% = 1
IF CTEN% = 1 THEN RETURN

839 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "10   "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "   10"


RETURN

TENS:
IF GP90% = 40 THEN GOTO 840
IF STEN% = 1 THEN TC% = 1
IF STEN% = 1 THEN RETURN

840 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "10   "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "   10"

RETURN

JACKH:
IF GP90% = 41 THEN GOTO 841
IF HJACK% = 1 THEN TC% = 1
IF HJACK% = 1 THEN RETURN

841 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "J    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    J"


RETURN

JACKD:
IF GP90% = 42 THEN GOTO 842
IF DJACK% = 1 THEN TC% = 1
IF DJACK% = 1 THEN RETURN

842 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "J    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    J"


RETURN

JACKC:
IF GP90% = 43 THEN GOTO 843
IF CJACK% = 1 THEN TC% = 1
IF CJACK% = 1 THEN RETURN

843 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "J    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    J"


RETURN

JACKS:
IF GP90% = 44 THEN GOTO 844
IF SJACK% = 1 THEN TC% = 1
IF SJACK% = 1 THEN RETURN

844 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "J    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    J"

RETURN

QUEENH:
IF GP90% = 45 THEN GOTO 845
IF HQUEEN% = 1 THEN TC% = 1
IF HQUEEN% = 1 THEN RETURN

845 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "Q    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    Q"


RETURN

QUEEND:
IF GP90% = 46 THEN GOTO 846
IF DQUEEN% = 1 THEN TC% = 1
IF DQUEEN% = 1 THEN RETURN

846 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "Q    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    Q"


RETURN

QUEENC:
IF GP90% = 47 THEN GOTO 847
IF CQUEEN% = 1 THEN TC% = 1
IF CQUEEN% = 1 THEN RETURN

847 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "Q    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    Q"


RETURN

QUEENS:
IF GP90% = 48 THEN GOTO 848
IF SQUEEN% = 1 THEN TC% = 1
IF SQUEEN% = 1 THEN RETURN

848 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "Q    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    Q"

RETURN

KINGH:
IF GP90% = 49 THEN GOTO 849
IF HKING% = 1 THEN TC% = 1
IF HKING% = 1 THEN RETURN

849 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "K    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(3); "  "
LOCATE TGTE%, TGTB%: PRINT "    K"


RETURN

KINGD:
IF GP90% = 50 THEN GOTO 850
IF DKING% = 1 THEN TC% = 1
IF DKING% = 1 THEN RETURN

850 COLOR 4, 7
LOCATE TGTA%, TGTB%: PRINT "K    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(4); "  "
LOCATE TGTE%, TGTB%: PRINT "    K"


RETURN

KINGC:
IF GP90% = 51 THEN GOTO 851
IF CKING% = 1 THEN TC% = 1
IF CKING% = 1 THEN RETURN

851 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "K    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(5); "  "
LOCATE TGTE%, TGTB%: PRINT "    K"

RETURN

KINGS:
IF GP90% = 52 THEN GOTO 852
IF SKING% = 1 THEN TC% = 1
IF SKING% = 1 THEN RETURN

852 COLOR 0, 7
LOCATE TGTA%, TGTB%: PRINT "K    "
LOCATE TGTC%, TGTB%: PRINT "  "; CHR$(6); "  "
LOCATE TGTE%, TGTB%: PRINT "    K"

RETURN

CARDBACK:

LOCATE TGTA%, TGTB%: PRINT "     "
LOCATE TGTC%, TGTB%: PRINT "     "
LOCATE TGTE%, TGTB%: PRINT "     "

RETURN

POSRECORD:

9001 IF PR1$ > "" THEN GOTO 9002
IF PR1$ = "" THEN PR1$ = TGT$
RETURN
9002 IF PR2$ > "" THEN GOTO 9003
IF PR2$ = "" THEN PR2$ = TGT$
RETURN
9003 IF PR3$ > "" THEN GOTO 9004
IF PR3$ = "" THEN PR3$ = TGT$
RETURN
9004 IF PR4$ > "" THEN GOTO 9005
IF PR4$ = "" THEN PR4$ = TGT$
RETURN
9005 IF PR5$ > "" THEN GOTO 9006
IF PR5$ = "" THEN PR5$ = TGT$
RETURN
9006 IF PR6$ > "" THEN GOTO 9007
IF PR6$ = "" THEN PR6$ = TGT$
RETURN
9007 IF PR7$ > "" THEN GOTO 9008
IF PR7$ = "" THEN PR7$ = TGT$
RETURN
9008 IF PR8$ > "" THEN GOTO 9009
IF PR8$ = "" THEN PR8$ = TGT$
RETURN
9009 IF PR9$ > "" THEN GOTO 9010
IF PR9$ = "" THEN PR9$ = TGT$
RETURN
9010 IF PR10$ > "" THEN GOTO 9011
IF PR10$ = "" THEN PR10$ = TGT$
RETURN
9011 IF PR11$ > "" THEN GOTO 9012
IF PR11$ = "" THEN PR11$ = TGT$
RETURN
9012 IF PR12$ > "" THEN GOTO 9013
IF PR12$ = "" THEN PR12$ = TGT$
RETURN
9013 IF PR13$ > "" THEN GOTO 9014
IF PR13$ = "" THEN PR13$ = TGT$
RETURN
9014 IF PR14$ > "" THEN GOTO 9015
IF PR14$ = "" THEN PR14$ = TGT$
RETURN
9015 IF PR15$ > "" THEN GOTO 9016
IF PR15$ = "" THEN PR15$ = TGT$
RETURN
9016 IF PR16$ > "" THEN GOTO 9017
IF PR16$ = "" THEN PR16$ = TGT$
RETURN
9017 IF PR17$ > "" THEN GOTO 9018
IF PR17$ = "" THEN PR17$ = TGT$
RETURN
9018 IF PR18$ > "" THEN GOTO 9019
IF PR18$ = "" THEN PR18$ = TGT$
RETURN
9019 IF PR19$ > "" THEN GOTO 9020
IF PR19$ = "" THEN PR19$ = TGT$
RETURN
9020 IF PR20$ > "" THEN GOTO 9021
IF PR20$ = "" THEN PR20$ = TGT$
RETURN
9021 IF PR21$ > "" THEN GOTO 9022
IF PR21$ = "" THEN PR21$ = TGT$
RETURN
9022 IF PR22$ > "" THEN GOTO 9023
IF PR22$ = "" THEN PR22$ = TGT$
RETURN
9023 IF PR23$ > "" THEN GOTO 9024
IF PR23$ = "" THEN PR23$ = TGT$
RETURN
9024 IF PR24$ > "" THEN GOTO 9025
IF PR24$ = "" THEN PR24$ = TGT$
RETURN
9025 IF PR25$ > "" THEN GOTO 9026
IF PR25$ = "" THEN PR25$ = TGT$
IF PR25$ > "" THEN GOTO 9026
RETURN
9026 GOSUB GAMEOVER
GOTAG% = 1
RETURN

POSTAKEN:
PIST% = 0
IF TGT$ = PR1$ THEN PIST% = 1
IF TGT$ = PR2$ THEN PIST% = 1
IF TGT$ = PR3$ THEN PIST% = 1
IF TGT$ = PR4$ THEN PIST% = 1
IF TGT$ = PR5$ THEN PIST% = 1
IF TGT$ = PR6$ THEN PIST% = 1
IF TGT$ = PR7$ THEN PIST% = 1
IF TGT$ = PR8$ THEN PIST% = 1
IF TGT$ = PR9$ THEN PIST% = 1
IF TGT$ = PR10$ THEN PIST% = 1
IF TGT$ = PR11$ THEN PIST% = 1
IF TGT$ = PR12$ THEN PIST% = 1
IF TGT$ = PR13$ THEN PIST% = 1
IF TGT$ = PR14$ THEN PIST% = 1
IF TGT$ = PR15$ THEN PIST% = 1
IF TGT$ = PR16$ THEN PIST% = 1
IF TGT$ = PR17$ THEN PIST% = 1
IF TGT$ = PR18$ THEN PIST% = 1
IF TGT$ = PR19$ THEN PIST% = 1
IF TGT$ = PR20$ THEN PIST% = 1
IF TGT$ = PR21$ THEN PIST% = 1
IF TGT$ = PR22$ THEN PIST% = 1
IF TGT$ = PR23$ THEN PIST% = 1
IF TGT$ = PR24$ THEN PIST% = 1
IF TGT$ = PR25$ THEN PIST% = 1

RETURN

CARDREC:

IF TGT$ = "A" THEN GP1% = C%
IF TGT$ = "B" THEN GP2% = C%
IF TGT$ = "C" THEN GP3% = C%
IF TGT$ = "D" THEN GP4% = C%
IF TGT$ = "E" THEN GP5% = C%
IF TGT$ = "F" THEN GP6% = C%
IF TGT$ = "G" THEN GP7% = C%
IF TGT$ = "H" THEN GP8% = C%
IF TGT$ = "I" THEN GP9% = C%
IF TGT$ = "J" THEN GP10% = C%
IF TGT$ = "K" THEN GP11% = C%
IF TGT$ = "L" THEN GP12% = C%
IF TGT$ = "M" THEN GP13% = C%
IF TGT$ = "N" THEN GP14% = C%
IF TGT$ = "O" THEN GP15% = C%
IF TGT$ = "P" THEN GP16% = C%
IF TGT$ = "Q" THEN GP17% = C%
IF TGT$ = "R" THEN GP18% = C%
IF TGT$ = "S" THEN GP19% = C%
IF TGT$ = "T" THEN GP20% = C%
IF TGT$ = "U" THEN GP21% = C%
IF TGT$ = "V" THEN GP22% = C%
IF TGT$ = "W" THEN GP23% = C%
IF TGT$ = "X" THEN GP24% = C%
IF TGT$ = "Y" THEN GP25% = C%
9880 IF TGT$ = "Z" THEN GP90% = C%
IF GP90% = GP1% THEN GP90% = 0
IF GP90% = GP2% THEN GP90% = 0
IF GP90% = GP3% THEN GP90% = 0
IF GP90% = GP4% THEN GP90% = 0
IF GP90% = GP5% THEN GP90% = 0
IF GP90% = GP6% THEN GP90% = 0
IF GP90% = GP7% THEN GP90% = 0
IF GP90% = GP8% THEN GP90% = 0
IF GP90% = GP9% THEN GP90% = 0
IF GP90% = GP10% THEN GP90% = 0
IF GP90% = GP11% THEN GP90% = 0
IF GP90% = GP12% THEN GP90% = 0
IF GP90% = GP13% THEN GP90% = 0
IF GP90% = GP14% THEN GP90% = 0
IF GP90% = GP15% THEN GP90% = 0
IF GP90% = GP16% THEN GP90% = 0
IF GP90% = GP17% THEN GP90% = 0
IF GP90% = GP18% THEN GP90% = 0
IF GP90% = GP19% THEN GP90% = 0
IF GP90% = GP20% THEN GP90% = 0
IF GP90% = GP21% THEN GP90% = 0
IF GP90% = GP22% THEN GP90% = 0
IF GP90% = GP23% THEN GP90% = 0
IF GP90% = GP24% THEN GP90% = 0
IF GP90% = GP25% THEN GP90% = 0
RETURN

GAMEOVER:
GOSUB CLEANCN
GOSUB CNW1
GOSUB CNW2
GOSUB CNW3
GOSUB CNW4
GOSUB CNW5
GOSUB CNCOL1
GOSUB CNCOL2
GOSUB CNCOL3
GOSUB CNCOL4
GOSUB CNCOL5
TOTALW% = SCR% + SCORER2% + SCORER3% + SCORER4% + SCORER5%
TOTALCOL% = SCOREC1% + SCOREC2% + SCOREC3% + SCOREC4% + SCOREC5%
TOTAL% = TOTALW% + TOTALCOL%
COLOR 7, 1
LOCATE 2, 1: PRINT "                       "
LOCATE 3, 1: PRINT "                       "
LOCATE 4, 1: PRINT "                       "
LOCATE 5, 3: PRINT "Game Over"
LOCATE 7, 3: PRINT "Row 1:                       "
LOCATE 7, 15: PRINT SCORER1%
LOCATE 8, 3: PRINT "Row 2:"
LOCATE 8, 15: PRINT SCORER2%
LOCATE 9, 3: PRINT "Row 3:"
LOCATE 9, 15: PRINT SCORER3%
LOCATE 10, 3: PRINT "Row 4:"
LOCATE 10, 15: PRINT SCORER4%
LOCATE 11, 3: PRINT "Row 5:"
LOCATE 11, 15: PRINT SCORER5%
LOCATE 13, 3: PRINT "Col 1:"
LOCATE 13, 15: PRINT SCOREC1%
LOCATE 14, 3: PRINT "Col 2:"
LOCATE 14, 15: PRINT SCOREC2%
LOCATE 15, 3: PRINT "Col 3:"
LOCATE 15, 15: PRINT SCOREC3%
LOCATE 16, 3: PRINT "Col 4:"
LOCATE 16, 15: PRINT SCOREC4%
LOCATE 17, 3: PRINT "Col 5:"
LOCATE 17, 15: PRINT SCOREC5%
LOCATE 19, 3: PRINT "TOTAL:"
LOCATE 19, 15: PRINT TOTAL%



RETURN

CNW1:

CRDT% = GP1%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP2%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP3%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP4%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP5%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCORER1% = SCR%
GOSUB CLEANCN
RETURN

CNW2:

CRDT% = GP6%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP7%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP8%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP9%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP10%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%
GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCORER2% = SCR%
GOSUB CLEANCN
RETURN

CNW3:
CRDT% = GP11%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP12%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP13%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP14%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP15%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCORER3% = SCR%
GOSUB CLEANCN
RETURN

CNW4:
CRDT% = GP16%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP17%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP18%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP19%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP20%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCORER4% = SCR%
GOSUB CLEANCN
RETURN

CNW5:
CRDT% = GP21%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP22%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP23%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP24%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP25%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCORER5% = SCR%
GOSUB CLEANCN
RETURN

CNCOL1:

CRDT% = GP1%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP6%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP11%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP16%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP21%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCOREC1% = SCR%
GOSUB CLEANCN
RETURN

CNCOL2:

CRDT% = GP2%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP7%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP12%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP17%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP22%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCOREC2% = SCR%
GOSUB CLEANCN

RETURN

CNCOL3:
CRDT% = GP3%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP8%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP13%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP18%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP23%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCOREC3% = SCR%
GOSUB CLEANCN
RETURN

CNCOL4:
CRDT% = GP4%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP9%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP14%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP19%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP24%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCOREC4% = SCR%
GOSUB CLEANCN
RETURN

CNCOL5:
CRDT% = GP5%
GOSUB CVLTEST
R1% = RANK%
V1% = VLF%
S1% = SUIT%

CRDT% = GP10%
GOSUB CVLTEST
R2% = RANK%
V2% = VLF%
S2% = SUIT%

CRDT% = GP15%
GOSUB CVLTEST
R3% = RANK%
V3% = VLF%
S3% = SUIT%

CRDT% = GP20%
GOSUB CVLTEST
R4% = RANK%
V4% = VLF%
S4% = SUIT%

CRDT% = GP25%
GOSUB CVLTEST
R5% = RANK%
V5% = VLF%
S5% = SUIT%

GOSUB CN5RUNS
GOSUB CN4RUNS
GOSUB CN3RUNS
GOSUB CNPAIRS
GOSUB CNFIFTEENS
GOSUB CNFLUSHES
GOSUB TALLY
SCOREC5% = SCR%
GOSUB CLEANCN
RETURN

CVLTEST:

IF CRDT% = 1 THEN RANK% = 1
IF CRDT% = 2 THEN RANK% = 1
IF CRDT% = 3 THEN RANK% = 1
IF CRDT% = 4 THEN RANK% = 1
IF CRDT% = 5 THEN RANK% = 2
IF CRDT% = 6 THEN RANK% = 2
IF CRDT% = 7 THEN RANK% = 2
IF CRDT% = 8 THEN RANK% = 2
IF CRDT% = 9 THEN RANK% = 3
IF CRDT% = 10 THEN RANK% = 3
IF CRDT% = 11 THEN RANK% = 3
IF CRDT% = 12 THEN RANK% = 3
IF CRDT% = 13 THEN RANK% = 4
IF CRDT% = 14 THEN RANK% = 4
IF CRDT% = 15 THEN RANK% = 4
IF CRDT% = 16 THEN RANK% = 4
IF CRDT% = 17 THEN RANK% = 5
IF CRDT% = 18 THEN RANK% = 5
IF CRDT% = 19 THEN RANK% = 5
IF CRDT% = 20 THEN RANK% = 5
IF CRDT% = 21 THEN RANK% = 6
IF CRDT% = 22 THEN RANK% = 6
IF CRDT% = 23 THEN RANK% = 6
IF CRDT% = 24 THEN RANK% = 6
IF CRDT% = 25 THEN RANK% = 7
IF CRDT% = 26 THEN RANK% = 7
IF CRDT% = 27 THEN RANK% = 7
IF CRDT% = 28 THEN RANK% = 7
IF CRDT% = 29 THEN RANK% = 8
IF CRDT% = 30 THEN RANK% = 8
IF CRDT% = 31 THEN RANK% = 8
IF CRDT% = 32 THEN RANK% = 8
IF CRDT% = 33 THEN RANK% = 9
IF CRDT% = 34 THEN RANK% = 9
IF CRDT% = 35 THEN RANK% = 9
IF CRDT% = 36 THEN RANK% = 9
IF CRDT% = 37 THEN RANK% = 10
IF CRDT% = 38 THEN RANK% = 10
IF CRDT% = 39 THEN RANK% = 10
IF CRDT% = 40 THEN RANK% = 10
IF CRDT% = 41 THEN RANK% = 11
IF CRDT% = 42 THEN RANK% = 11
IF CRDT% = 43 THEN RANK% = 11
IF CRDT% = 44 THEN RANK% = 11
IF CRDT% = 45 THEN RANK% = 12
IF CRDT% = 46 THEN RANK% = 12
IF CRDT% = 47 THEN RANK% = 12
IF CRDT% = 48 THEN RANK% = 12
IF CRDT% = 49 THEN RANK% = 13
IF CRDT% = 50 THEN RANK% = 13
IF CRDT% = 51 THEN RANK% = 13
IF CRDT% = 52 THEN RANK% = 13

IF CRDT% = 1 THEN VLF% = 1
IF CRDT% = 2 THEN VLF% = 1
IF CRDT% = 3 THEN VLF% = 1
IF CRDT% = 4 THEN VLF% = 1
IF CRDT% = 5 THEN VLF% = 2
IF CRDT% = 6 THEN VLF% = 2
IF CRDT% = 7 THEN VLF% = 2
IF CRDT% = 8 THEN VLF% = 2
IF CRDT% = 9 THEN VLF% = 3
IF CRDT% = 10 THEN VLF% = 3
IF CRDT% = 11 THEN VLF% = 3
IF CRDT% = 12 THEN VLF% = 3
IF CRDT% = 13 THEN VLF% = 4
IF CRDT% = 14 THEN VLF% = 4
IF CRDT% = 15 THEN VLF% = 4
IF CRDT% = 16 THEN VLF% = 4
IF CRDT% = 17 THEN VLF% = 5
IF CRDT% = 18 THEN VLF% = 5
IF CRDT% = 19 THEN VLF% = 5
IF CRDT% = 20 THEN VLF% = 5
IF CRDT% = 21 THEN VLF% = 6
IF CRDT% = 22 THEN VLF% = 6
IF CRDT% = 23 THEN VLF% = 6
IF CRDT% = 24 THEN VLF% = 6
IF CRDT% = 25 THEN VLF% = 7
IF CRDT% = 26 THEN VLF% = 7
IF CRDT% = 27 THEN VLF% = 7
IF CRDT% = 28 THEN VLF% = 7
IF CRDT% = 29 THEN VLF% = 8
IF CRDT% = 30 THEN VLF% = 8
IF CRDT% = 31 THEN VLF% = 8
IF CRDT% = 32 THEN VLF% = 8
IF CRDT% = 33 THEN VLF% = 9
IF CRDT% = 34 THEN VLF% = 9
IF CRDT% = 35 THEN VLF% = 9
IF CRDT% = 36 THEN VLF% = 9
IF CRDT% = 37 THEN VLF% = 10
IF CRDT% = 38 THEN VLF% = 10
IF CRDT% = 39 THEN VLF% = 10
IF CRDT% = 40 THEN VLF% = 10
IF CRDT% = 41 THEN VLF% = 10
IF CRDT% = 42 THEN VLF% = 10
IF CRDT% = 43 THEN VLF% = 10
IF CRDT% = 44 THEN VLF% = 10
IF CRDT% = 45 THEN VLF% = 10
IF CRDT% = 46 THEN VLF% = 10
IF CRDT% = 47 THEN VLF% = 10
IF CRDT% = 48 THEN VLF% = 10
IF CRDT% = 49 THEN VLF% = 10
IF CRDT% = 50 THEN VLF% = 10
IF CRDT% = 51 THEN VLF% = 10
IF CRDT% = 52 THEN VLF% = 10
                     
IF CRDT% = 1 THEN SUIT% = 1
IF CRDT% = 2 THEN SUIT% = 2
IF CRDT% = 3 THEN SUIT% = 3
IF CRDT% = 4 THEN SUIT% = 4
IF CRDT% = 5 THEN SUIT% = 1
IF CRDT% = 6 THEN SUIT% = 2
IF CRDT% = 7 THEN SUIT% = 3
IF CRDT% = 8 THEN SUIT% = 4
IF CRDT% = 9 THEN SUIT% = 1
IF CRDT% = 10 THEN SUIT% = 2
IF CRDT% = 11 THEN SUIT% = 3
IF CRDT% = 12 THEN SUIT% = 4
IF CRDT% = 13 THEN SUIT% = 1
IF CRDT% = 14 THEN SUIT% = 2
IF CRDT% = 15 THEN SUIT% = 3
IF CRDT% = 16 THEN SUIT% = 4
IF CRDT% = 17 THEN SUIT% = 1
IF CRDT% = 18 THEN SUIT% = 2
IF CRDT% = 19 THEN SUIT% = 3
IF CRDT% = 20 THEN SUIT% = 4
IF CRDT% = 21 THEN SUIT% = 1
IF CRDT% = 22 THEN SUIT% = 2
IF CRDT% = 23 THEN SUIT% = 3
IF CRDT% = 24 THEN SUIT% = 4
IF CRDT% = 25 THEN SUIT% = 1
IF CRDT% = 26 THEN SUIT% = 2
IF CRDT% = 27 THEN SUIT% = 3
IF CRDT% = 28 THEN SUIT% = 4
IF CRDT% = 29 THEN SUIT% = 1
IF CRDT% = 30 THEN SUIT% = 2
IF CRDT% = 31 THEN SUIT% = 3
IF CRDT% = 32 THEN SUIT% = 4
IF CRDT% = 33 THEN SUIT% = 1
IF CRDT% = 34 THEN SUIT% = 2
IF CRDT% = 35 THEN SUIT% = 3
IF CRDT% = 36 THEN SUIT% = 4
IF CRDT% = 37 THEN SUIT% = 1
IF CRDT% = 38 THEN SUIT% = 2
IF CRDT% = 39 THEN SUIT% = 3
IF CRDT% = 40 THEN SUIT% = 4
IF CRDT% = 41 THEN SUIT% = 1
IF CRDT% = 42 THEN SUIT% = 2
IF CRDT% = 43 THEN SUIT% = 3
IF CRDT% = 44 THEN SUIT% = 4
IF CRDT% = 45 THEN SUIT% = 1
IF CRDT% = 46 THEN SUIT% = 2
IF CRDT% = 47 THEN SUIT% = 3
IF CRDT% = 48 THEN SUIT% = 4
IF CRDT% = 49 THEN SUIT% = 1
IF CRDT% = 50 THEN SUIT% = 2
IF CRDT% = 51 THEN SUIT% = 3
IF CRDT% = 52 THEN SUIT% = 4

RETURN

GOODBYE:
COLOR 7, 1
LOCATE 21, 3: PRINT "Press any key to continue . . ."
DO: LOOP WHILE INKEY$ = ""
GOSUB HIGHSCORE
GOTO 3
RETURN

CNPAIRS:

IF R1% = R2% THEN WP1% = 1
IF R1% = R3% THEN WP2% = 1
IF R1% = R4% THEN WP3% = 1
IF R1% = R5% THEN WP4% = 1
IF R2% = R3% THEN WP5% = 1
IF R2% = R4% THEN WP6% = 1
IF R2% = R5% THEN WP7% = 1
IF R3% = R4% THEN WP8% = 1
IF R3% = R5% THEN WP9% = 1
IF R4% = R5% THEN WP10% = 1

RETURN

CNFLUSHES:

IF S1% = S2% AND S1% = S3% AND S1% = S4% AND S1% = S5% THEN WF% = 1

RETURN

CNFIFTEENS:

IF V1% + V2% + V3% + V4% + V5% = 15 THEN W515% = 1

IF V1% + V2% + V3% + V4% = 15 THEN W4151% = 1
IF V1% + V3% + V4% + V5% = 15 THEN W4152% = 1
IF V1% + V2% + V4% + V5% = 15 THEN W4153% = 1
IF V1% + V2% + V3% + V5% = 15 THEN W4154% = 1
IF V2% + V3% + V4% + V5% = 15 THEN W4155% = 1

IF V1% + V2% + V3% = 15 THEN W3151% = 1
IF V1% + V2% + V4% = 15 THEN W3152% = 1
IF V1% + V2% + V5% = 15 THEN W3153% = 1
IF V2% + V3% + V4% = 15 THEN W3154% = 1
IF V2% + V3% + V5% = 15 THEN W3155% = 1
IF V3% + V4% + V5% = 15 THEN W3156% = 1
IF V1% + V3% + V5% = 15 THEN W3157% = 1
IF V1% + V4% + V5% = 15 THEN W3158% = 1
IF V2% + V4% + V5% = 15 THEN W3159% = 1
IF V1% + V3% + V4% = 15 THEN W31510% = 1

IF V1% + V2% = 15 THEN W2151% = 1
IF V1% + V3% = 15 THEN W2152% = 1
IF V1% + V4% = 15 THEN W2153% = 1
IF V1% + V5% = 15 THEN W2154% = 1
IF V2% + V3% = 15 THEN W2155% = 1
IF V2% + V4% = 15 THEN W2156% = 1
IF V2% + V5% = 15 THEN W2157% = 1
IF V3% + V4% = 15 THEN W2158% = 1
IF V3% + V5% = 15 THEN W2159% = 1
IF V4% + V5% = 15 THEN W21510% = 1

RETURN

CN3RUNS:
IF W5R% = 1 THEN RETURN
IF W4R1% = 1 THEN RETURN
IF W4R2% = 1 THEN RETURN
IF W4R3% = 1 THEN RETURN
IF W4R4% = 1 THEN RETURN
IF W4R5% = 1 THEN RETURN
IF R1% - R2% = 1 AND R2% - R3% = 1 THEN W3R1% = 1
IF R1% - R3% = 1 AND R3% - R2% = 1 THEN W3R1% = 1
IF R3% - R1% = 1 AND R1% - R2% = 1 THEN W3R1% = 1
IF R3% - R2% = 1 AND R2% - R1% = 1 THEN W3R1% = 1
IF R2% - R1% = 1 AND R1% - R3% = 1 THEN W3R1% = 1
IF R2% - R3% = 1 AND R3% - R1% = 1 THEN W3R1% = 1

IF R1% - R2% = 1 AND R2% - R4% = 1 THEN W3R2% = 1
IF R1% - R4% = 1 AND R4% - R2% = 1 THEN W3R2% = 1
IF R2% - R1% = 1 AND R1% - R4% = 1 THEN W3R2% = 1
IF R2% - R4% = 1 AND R4% - R1% = 1 THEN W3R2% = 1
IF R4% - R2% = 1 AND R2% - R1% = 1 THEN W3R2% = 1
IF R4% - R1% = 1 AND R1% - R2% = 1 THEN W3R2% = 1

IF R1% - R2% = 1 AND R2% - R5% = 1 THEN W3R3% = 1
IF R1% - R5% = 1 AND R5% - R2% = 1 THEN W3R3% = 1
IF R2% - R5% = 1 AND R5% - R1% = 1 THEN W3R3% = 1
IF R2% - R1% = 1 AND R1% - R5% = 1 THEN W3R3% = 1
IF R5% - R1% = 1 AND R1% - R2% = 1 THEN W3R3% = 1
IF R5% - R2% = 1 AND R2% - R1% = 1 THEN W3R3% = 1

IF R2% - R3% = 1 AND R3% - R4% = 1 THEN W3R4% = 1
IF R2% - R4% = 1 AND R4% - R3% = 1 THEN W3R4% = 1
IF R4% - R2% = 1 AND R2% - R3% = 1 THEN W3R4% = 1
IF R4% - R3% = 1 AND R3% - R2% = 1 THEN W3R4% = 1
IF R3% - R2% = 1 AND R2% - R4% = 1 THEN W3R4% = 1
IF R3% - R4% = 1 AND R4% - R2% = 1 THEN W3R4% = 1

IF R2% - R3% = 1 AND R3% - R5% = 1 THEN W3R5% = 1
IF R2% - R5% = 1 AND R5% - R3% = 1 THEN W3R5% = 1
IF R3% - R2% = 1 AND R2% - R5% = 1 THEN W3R5% = 1
IF R3% - R5% = 1 AND R5% - R2% = 1 THEN W3R5% = 1
IF R5% - R3% = 1 AND R3% - R2% = 1 THEN W3R5% = 1
IF R5% - R2% = 1 AND R2% - R3% = 1 THEN W3R5% = 1

IF R3% - R4% = 1 AND R4% - R5% = 1 THEN W3R6% = 1
IF R3% - R5% = 1 AND R5% - R4% = 1 THEN W3R6% = 1
IF R4% - R3% = 1 AND R3% - R5% = 1 THEN W3R6% = 1
IF R4% - R5% = 1 AND R5% - R3% = 1 THEN W3R6% = 1
IF R5% - R4% = 1 AND R4% - R3% = 1 THEN W3R6% = 1
IF R5% - R3% = 1 AND R3% - R4% = 1 THEN W3R6% = 1

IF R1% - R3% = 1 AND R3% - R5% = 1 THEN W3R7% = 1
IF R1% - R5% = 1 AND R5% - R3% = 1 THEN W3R7% = 1
IF R3% - R1% = 1 AND R1% - R5% = 1 THEN W3R7% = 1
IF R3% - R5% = 1 AND R5% - R1% = 1 THEN W3R7% = 1
IF R5% - R3% = 1 AND R3% - R1% = 1 THEN W3R7% = 1
IF R5% - R1% = 1 AND R1% - R3% = 1 THEN W3R7% = 1

IF R1% - R4% = 1 AND R4% - R5% = 1 THEN W3R8% = 1
IF R1% - R5% = 1 AND R5% - R4% = 1 THEN W3R8% = 1
IF R4% - R5% = 1 AND R5% - R1% = 1 THEN W3R8% = 1
IF R4% - R1% = 1 AND R1% - R5% = 1 THEN W3R8% = 1
IF R5% - R4% = 1 AND R4% - R1% = 1 THEN W3R8% = 1
IF R5% - R1% = 1 AND R1% - R4% = 1 THEN W3R8% = 1

IF R2% - R4% = 1 AND R4% - R5% = 1 THEN W3R9% = 1
IF R2% - R5% = 1 AND R5% - R4% = 1 THEN W3R9% = 1
IF R4% - R5% = 1 AND R5% - R2% = 1 THEN W3R9% = 1
IF R4% - R2% = 1 AND R2% - R5% = 1 THEN W3R9% = 1
IF R5% - R2% = 1 AND R2% - R4% = 1 THEN W3R9% = 1
IF R5% - R4% = 1 AND R4% - R2% = 1 THEN W3R9% = 1

IF R1% - R3% = 1 AND R3% - R4% = 1 THEN W3R10% = 1
IF R1% - R4% = 1 AND R4% - R3% = 1 THEN W3R10% = 1
IF R3% - R4% = 1 AND R4% - R1% = 1 THEN W3R10% = 1
IF R3% - R1% = 1 AND R1% - R4% = 1 THEN W3R10% = 1
IF R4% - R1% = 1 AND R1% - R3% = 1 THEN W3R10% = 1
IF R4% - R3% = 1 AND R3% - R1% = 1 THEN W3R10% = 1

RETURN

CN4RUNS:
IF W5R% = 1 THEN RETURN

IF R1% - R2% = 1 AND R2% - R3% = 1 AND R3% - R4% = 1 THEN W4R1% = 1
IF R1% - R2% = 1 AND R2% - R4% = 1 AND R4% - R3% = 1 THEN W4R1% = 1
IF R1% - R3% = 1 AND R3% - R2% = 1 AND R2% - R4% = 1 THEN W4R1% = 1
IF R1% - R3% = 1 AND R3% - R4% = 1 AND R4% - R2% = 1 THEN W4R1% = 1
IF R1% - R4% = 1 AND R4% - R2% = 1 AND R2% - R3% = 1 THEN W4R1% = 1
IF R1% - R4% = 1 AND R4% - R3% = 1 AND R3% - R2% = 1 THEN W4R1% = 1

IF R2% - R1% = 1 AND R1% - R3% = 1 AND R3% - R4% = 1 THEN W4R1% = 1
IF R2% - R1% = 1 AND R1% - R4% = 1 AND R4% - R3% = 1 THEN W4R1% = 1
IF R2% - R3% = 1 AND R3% - R1% = 1 AND R1% - R4% = 1 THEN W4R1% = 1
IF R2% - R3% = 1 AND R3% - R4% = 1 AND R4% - R1% = 1 THEN W4R1% = 1
IF R2% - R4% = 1 AND R4% - R1% = 1 AND R1% - R3% = 1 THEN W4R1% = 1
IF R2% - R4% = 1 AND R4% - R3% = 1 AND R3% - R1% = 1 THEN W4R1% = 1

IF R3% - R1% = 1 AND R1% - R2% = 1 AND R2% - R4% = 1 THEN W4R1% = 1
IF R3% - R1% = 1 AND R1% - R4% = 1 AND R4% - R2% = 1 THEN W4R1% = 1
IF R3% - R2% = 1 AND R2% - R1% = 1 AND R1% - R4% = 1 THEN W4R1% = 1
IF R3% - R2% = 1 AND R2% - R4% = 1 AND R4% - R1% = 1 THEN W4R1% = 1
IF R3% - R4% = 1 AND R4% - R2% = 1 AND R2% - R1% = 1 THEN W4R1% = 1
IF R3% - R4% = 1 AND R4% - R1% = 1 AND R1% - R2% = 1 THEN W4R1% = 1

IF R4% - R1% = 1 AND R1% - R2% = 1 AND R2% - R3% = 1 THEN W4R1% = 1
IF R4% - R1% = 1 AND R1% - R3% = 1 AND R3% - R2% = 1 THEN W4R1% = 1
IF R4% - R2% = 1 AND R2% - R1% = 1 AND R1% - R3% = 1 THEN W4R1% = 1
IF R4% - R2% = 1 AND R2% - R3% = 1 AND R3% - R1% = 1 THEN W4R1% = 1
IF R4% - R3% = 1 AND R3% - R2% = 1 AND R2% - R1% = 1 THEN W4R1% = 1
IF R4% - R3% = 1 AND R3% - R1% = 1 AND R1% - R2% = 1 THEN W4R1% = 1

IF R1% - R2% = 1 AND R2% - R3% = 1 AND R3% - R5% = 1 THEN W4R2% = 1
IF R1% - R2% = 1 AND R2% - R5% = 1 AND R5% - R3% = 1 THEN W4R2% = 1
IF R1% - R3% = 1 AND R3% - R2% = 1 AND R2% - R5% = 1 THEN W4R2% = 1
IF R1% - R3% = 1 AND R3% - R5% = 1 AND R5% - R2% = 1 THEN W4R2% = 1
IF R1% - R5% = 1 AND R5% - R2% = 1 AND R2% - R3% = 1 THEN W4R2% = 1
IF R1% - R5% = 1 AND R5% - R3% = 1 AND R3% - R2% = 1 THEN W4R2% = 1

IF R2% - R1% = 1 AND R1% - R3% = 1 AND R3% - R5% = 1 THEN W4R2% = 1
IF R2% - R1% = 1 AND R1% - R5% = 1 AND R5% - R3% = 1 THEN W4R2% = 1
IF R2% - R3% = 1 AND R3% - R1% = 1 AND R1% - R5% = 1 THEN W4R2% = 1
IF R2% - R3% = 1 AND R3% - R5% = 1 AND R5% - R1% = 1 THEN W4R2% = 1
IF R2% - R5% = 1 AND R5% - R1% = 1 AND R1% - R3% = 1 THEN W4R2% = 1
IF R2% - R5% = 1 AND R5% - R3% = 1 AND R3% - R1% = 1 THEN W4R2% = 1

IF R3% - R1% = 1 AND R1% - R2% = 1 AND R2% - R5% = 1 THEN W4R2% = 1
IF R3% - R1% = 1 AND R1% - R5% = 1 AND R5% - R2% = 1 THEN W4R2% = 1
IF R3% - R2% = 1 AND R2% - R1% = 1 AND R1% - R5% = 1 THEN W4R2% = 1
IF R3% - R2% = 1 AND R2% - R5% = 1 AND R5% - R1% = 1 THEN W4R2% = 1
IF R3% - R5% = 1 AND R5% - R1% = 1 AND R1% - R2% = 1 THEN W4R2% = 1
IF R3% - R5% = 1 AND R5% - R2% = 1 AND R2% - R1% = 1 THEN W4R2% = 1

IF R5% - R1% = 1 AND R1% - R2% = 1 AND R2% - R3% = 1 THEN W4R2% = 1
IF R5% - R1% = 1 AND R1% - R3% = 1 AND R3% - R2% = 1 THEN W4R2% = 1
IF R5% - R2% = 1 AND R2% - R1% = 1 AND R1% - R3% = 1 THEN W4R2% = 1
IF R5% - R2% = 1 AND R2% - R3% = 1 AND R3% - R1% = 1 THEN W4R2% = 1
IF R5% - R3% = 1 AND R3% - R1% = 1 AND R1% - R2% = 1 THEN W4R2% = 1
IF R5% - R3% = 1 AND R3% - R2% = 1 AND R2% - R1% = 1 THEN W4R2% = 1

IF R2% - R3% = 1 AND R3% - R4% = 1 AND R4% - R5% = 1 THEN W4R3% = 1
IF R2% - R3% = 1 AND R3% - R5% = 1 AND R5% - R4% = 1 THEN W4R3% = 1
IF R2% - R4% = 1 AND R4% - R3% = 1 AND R3% - R5% = 1 THEN W4R3% = 1
IF R2% - R4% = 1 AND R4% - R5% = 1 AND R5% - R3% = 1 THEN W4R3% = 1
IF R2% - R5% = 1 AND R5% - R3% = 1 AND R3% - R4% = 1 THEN W4R3% = 1
IF R2% - R5% = 1 AND R5% - R4% = 1 AND R4% - R3% = 1 THEN W4R3% = 1

IF R3% - R2% = 1 AND R2% - R4% = 1 AND R4% - R5% = 1 THEN W4R3% = 1
IF R3% - R2% = 1 AND R2% - R5% = 1 AND R5% - R4% = 1 THEN W4R3% = 1
IF R3% - R4% = 1 AND R4% - R2% = 1 AND R2% - R5% = 1 THEN W4R3% = 1
IF R3% - R4% = 1 AND R4% - R5% = 1 AND R5% - R2% = 1 THEN W4R3% = 1
IF R3% - R5% = 1 AND R5% - R2% = 1 AND R2% - R4% = 1 THEN W4R3% = 1
IF R3% - R5% = 1 AND R5% - R4% = 1 AND R4% - R2% = 1 THEN W4R3% = 1

IF R4% - R2% = 1 AND R2% - R3% = 1 AND R3% - R5% = 1 THEN W4R3% = 1
IF R4% - R2% = 1 AND R2% - R5% = 1 AND R5% - R3% = 1 THEN W4R3% = 1
IF R4% - R3% = 1 AND R3% - R5% = 1 AND R5% - R2% = 1 THEN W4R3% = 1
IF R4% - R3% = 1 AND R3% - R2% = 1 AND R2% - R5% = 1 THEN W4R3% = 1
IF R4% - R5% = 1 AND R5% - R2% = 1 AND R2% - R3% = 1 THEN W4R3% = 1
IF R4% - R5% = 1 AND R5% - R3% = 1 AND R3% - R2% = 1 THEN W4R3% = 1
                                                                        
IF R5% - R2% = 1 AND R2% - R3% = 1 AND R3% - R4% = 1 THEN W4R3% = 1
IF R5% - R2% = 1 AND R2% - R4% = 1 AND R4% - R3% = 1 THEN W4R3% = 1
IF R5% - R3% = 1 AND R3% - R2% = 1 AND R2% - R4% = 1 THEN W4R3% = 1
IF R5% - R3% = 1 AND R3% - R4% = 1 AND R4% - R2% = 1 THEN W4R3% = 1
IF R5% - R4% = 1 AND R4% - R3% = 1 AND R3% - R2% = 1 THEN W4R3% = 1
IF R5% - R4% = 1 AND R4% - R2% = 1 AND R2% - R3% = 1 THEN W4R3% = 1

IF R1% - R2% = 1 AND R2% - R4% = 1 AND R4% - R5% = 1 THEN W4R4% = 1
IF R1% - R2% = 1 AND R2% - R5% = 1 AND R5% - R4% = 1 THEN W4R4% = 1
IF R1% - R4% = 1 AND R4% - R2% = 1 AND R2% - R5% = 1 THEN W4R4% = 1
IF R1% - R4% = 1 AND R4% - R5% = 1 AND R5% - R2% = 1 THEN W4R4% = 1
IF R1% - R5% = 1 AND R5% - R4% = 1 AND R4% - R2% = 1 THEN W4R4% = 1
IF R1% - R5% = 1 AND R5% - R2% = 1 AND R2% - R4% = 1 THEN W4R4% = 1

IF R2% - R1% = 1 AND R1% - R4% = 1 AND R4% - R5% = 1 THEN W4R4% = 1
IF R2% - R1% = 1 AND R1% - R5% = 1 AND R5% - R4% = 1 THEN W4R4% = 1
IF R2% - R4% = 1 AND R4% - R5% = 1 AND R5% - R1% = 1 THEN W4R4% = 1
IF R2% - R4% = 1 AND R4% - R1% = 1 AND R1% - R5% = 1 THEN W4R4% = 1
IF R2% - R5% = 1 AND R5% - R4% = 1 AND R4% - R1% = 1 THEN W4R4% = 1
IF R2% - R5% = 1 AND R5% - R1% = 1 AND R1% - R4% = 1 THEN W4R4% = 1

IF R4% - R1% = 1 AND R1% - R2% = 1 AND R2% - R5% = 1 THEN W4R4% = 1
IF R4% - R1% = 1 AND R1% - R5% = 1 AND R5% - R2% = 1 THEN W4R4% = 1
IF R4% - R2% = 1 AND R2% - R1% = 1 AND R1% - R5% = 1 THEN W4R4% = 1
IF R4% - R2% = 1 AND R2% - R5% = 1 AND R5% - R1% = 1 THEN W4R4% = 1
IF R4% - R5% = 1 AND R5% - R2% = 1 AND R2% - R1% = 1 THEN W4R4% = 1
IF R4% - R5% = 1 AND R5% - R1% = 1 AND R1% - R2% = 1 THEN W4R4% = 1
                                                                       
IF R5% - R1% = 1 AND R1% - R2% = 1 AND R2% - R4% = 1 THEN W4R4% = 1
IF R5% - R1% = 1 AND R1% - R4% = 1 AND R4% - R2% = 1 THEN W4R4% = 1
IF R5% - R2% = 1 AND R2% - R4% = 1 AND R4% - R1% = 1 THEN W4R4% = 1
IF R5% - R2% = 1 AND R2% - R1% = 1 AND R1% - R4% = 1 THEN W4R4% = 1
IF R5% - R4% = 1 AND R4% - R2% = 1 AND R2% - R1% = 1 THEN W4R4% = 1
IF R5% - R4% = 1 AND R4% - R1% = 1 AND R1% - R2% = 1 THEN W4R4% = 1

IF R1% - R2% = 1 AND R2% - R3% = 1 AND R3% - R5% = 1 THEN W4R5% = 1
IF R1% - R2% = 1 AND R2% - R5% = 1 AND R5% - R3% = 1 THEN W4R5% = 1
IF R1% - R3% = 1 AND R3% - R2% = 1 AND R2% - R5% = 1 THEN W4R5% = 1
IF R1% - R3% = 1 AND R3% - R5% = 1 AND R5% - R2% = 1 THEN W4R5% = 1
IF R1% - R5% = 1 AND R5% - R2% = 1 AND R2% - R3% = 1 THEN W4R5% = 1
IF R1% - R5% = 1 AND R5% - R3% = 1 AND R3% - R2% = 1 THEN W4R5% = 1

IF R2% - R1% = 1 AND R1% - R3% = 1 AND R3% - R5% = 1 THEN W4R5% = 1
IF R2% - R1% = 1 AND R1% - R5% = 1 AND R5% - R3% = 1 THEN W4R5% = 1
IF R2% - R3% = 1 AND R3% - R1% = 1 AND R1% - R5% = 1 THEN W4R5% = 1
IF R2% - R3% = 1 AND R3% - R5% = 1 AND R5% - R1% = 1 THEN W4R5% = 1
IF R2% - R5% = 1 AND R5% - R3% = 1 AND R3% - R1% = 1 THEN W4R5% = 1
IF R2% - R5% = 1 AND R5% - R1% = 1 AND R1% - R3% = 1 THEN W4R5% = 1

IF R3% - R1% = 1 AND R1% - R2% = 1 AND R2% - R5% = 1 THEN W4R5% = 1
IF R3% - R1% = 1 AND R1% - R5% = 1 AND R5% - R2% = 1 THEN W4R5% = 1
IF R3% - R2% = 1 AND R2% - R1% = 1 AND R1% - R5% = 1 THEN W4R5% = 1
IF R3% - R2% = 1 AND R2% - R5% = 1 AND R5% - R1% = 1 THEN W4R5% = 1
IF R3% - R5% = 1 AND R5% - R1% = 1 AND R1% - R2% = 1 THEN W4R5% = 1
IF R3% - R5% = 1 AND R5% - R2% = 1 AND R2% - R1% = 1 THEN W4R5% = 1
                                                                      
IF R5% - R1% = 1 AND R1% - R2% = 1 AND R2% - R3% = 1 THEN W4R5% = 1
IF R5% - R1% = 1 AND R1% - R3% = 1 AND R3% - R2% = 1 THEN W4R5% = 1
IF R5% - R2% = 1 AND R2% - R3% = 1 AND R3% - R1% = 1 THEN W4R5% = 1
IF R5% - R2% = 1 AND R2% - R1% = 1 AND R1% - R3% = 1 THEN W4R5% = 1
IF R5% - R3% = 1 AND R3% - R1% = 1 AND R1% - R2% = 1 THEN W4R5% = 1
IF R5% - R3% = 1 AND R3% - R2% = 1 AND R2% - R1% = 1 THEN W4R5% = 1

RETURN

CN5RUNS:

IF R1% - R2% = 1 AND R2% - R3% = 1 AND R3% - R4% = 1 AND R4% - R5% = 1 THEN W5R% = 1
IF R1% - R2% = 1 AND R2% - R3% = 1 AND R3% - R5% = 1 AND R5% - R4% = 1 THEN W5R% = 1
IF R1% - R2% = 1 AND R2% - R4% = 1 AND R4% - R3% = 1 AND R3% - R5% = 1 THEN W5R% = 1
IF R1% - R2% = 1 AND R2% - R4% = 1 AND R4% - R5% = 1 AND R5% - R3% = 1 THEN W5R% = 1
IF R1% - R2% = 1 AND R2% - R5% = 1 AND R5% - R3% = 1 AND R3% - R4% = 1 THEN W5R% = 1
IF R1% - R2% = 1 AND R2% - R5% = 1 AND R5% - R4% = 1 AND R4% - R3% = 1 THEN W5R% = 1

IF R1% - R3% = 1 AND R3% - R2% = 1 AND R2% - R4% = 1 AND R4% - R5% = 1 THEN W5R% = 1
IF R1% - R3% = 1 AND R3% - R2% = 1 AND R2% - R5% = 1 AND R5% - R4% = 1 THEN W5R% = 1
IF R1% - R3% = 1 AND R3% - R4% = 1 AND R4% - R2% = 1 AND R2% - R5% = 1 THEN W5R% = 1
IF R1% - R3% = 1 AND R3% - R4% = 1 AND R4% - R5% = 1 AND R5% - R2% = 1 THEN W5R% = 1
IF R1% - R3% = 1 AND R3% - R5% = 1 AND R5% - R2% = 1 AND R2% - R4% = 1 THEN W5R% = 1
IF R1% - R3% = 1 AND R3% - R5% = 1 AND R5% - R4% = 1 AND R4% - R2% = 1 THEN W5R% = 1

IF R1% - R4% = 1 AND R4% - R2% = 1 AND R2% - R3% = 1 AND R3% - R5% = 1 THEN W5R% = 1
IF R1% - R4% = 1 AND R4% - R2% = 1 AND R2% - R5% = 1 AND R5% - R3% = 1 THEN W5R% = 1
IF R1% - R4% = 1 AND R4% - R3% = 1 AND R3% - R2% = 1 AND R2% - R5% = 1 THEN W5R% = 1
IF R1% - R4% = 1 AND R4% - R3% = 1 AND R3% - R5% = 1 AND R5% - R2% = 1 THEN W5R% = 1
IF R1% - R4% = 1 AND R4% - R5% = 1 AND R5% - R2% = 1 AND R2% - R3% = 1 THEN W5R% = 1
IF R1% - R4% = 1 AND R4% - R5% = 1 AND R5% - R3% = 1 AND R3% - R2% = 1 THEN W5R% = 1

IF R1% - R5% = 1 AND R5% - R2% = 1 AND R2% - R3% = 1 AND R3% - R4% = 1 THEN W5R% = 1
IF R1% - R5% = 1 AND R5% - R2% = 1 AND R2% - R4% = 1 AND R4% - R3% = 1 THEN W5R% = 1
IF R1% - R5% = 1 AND R5% - R3% = 1 AND R3% - R2% = 1 AND R2% - R4% = 1 THEN W5R% = 1
IF R1% - R5% = 1 AND R5% - R3% = 1 AND R3% - R4% = 1 AND R4% - R2% = 1 THEN W5R% = 1
IF R1% - R5% = 1 AND R5% - R4% = 1 AND R4% - R2% = 1 AND R2% - R3% = 1 THEN W5R% = 1
IF R1% - R5% = 1 AND R5% - R4% = 1 AND R4% - R3% = 1 AND R3% - R2% = 1 THEN W5R% = 1

IF R2% - R1% = 1 AND R1% - R3% = 1 AND R3% - R4% = 1 AND R4% - R5% = 1 THEN W5R% = 1
IF R2% - R1% = 1 AND R1% - R3% = 1 AND R3% - R5% = 1 AND R5% - R4% = 1 THEN W5R% = 1
IF R2% - R1% = 1 AND R1% - R4% = 1 AND R4% - R3% = 1 AND R3% - R5% = 1 THEN W5R% = 1
IF R2% - R1% = 1 AND R1% - R4% = 1 AND R4% - R5% = 1 AND R5% - R3% = 1 THEN W5R% = 1
IF R2% - R1% = 1 AND R1% - R5% = 1 AND R5% - R3% = 1 AND R3% - R4% = 1 THEN W5R% = 1
IF R2% - R1% = 1 AND R1% - R5% = 1 AND R5% - R4% = 1 AND R4% - R3% = 1 THEN W5R% = 1

IF R2% - R3% = 1 AND R3% - R1% = 1 AND R1% - R4% = 1 AND R4% - R5% = 1 THEN W5R% = 1
IF R2% - R3% = 1 AND R3% - R1% = 1 AND R1% - R5% = 1 AND R5% - R4% = 1 THEN W5R% = 1
IF R2% - R3% = 1 AND R3% - R4% = 1 AND R4% - R5% = 1 AND R5% - R1% = 1 THEN W5R% = 1
IF R2% - R3% = 1 AND R3% - R4% = 1 AND R4% - R1% = 1 AND R1% - R5% = 1 THEN W5R% = 1
IF R2% - R3% = 1 AND R3% - R5% = 1 AND R5% - R4% = 1 AND R4% - R1% = 1 THEN W5R% = 1
IF R2% - R3% = 1 AND R3% - R5% = 1 AND R5% - R1% = 1 AND R1% - R4% = 1 THEN W5R% = 1

IF R2% - R4% = 1 AND R4% - R1% = 1 AND R1% - R3% = 1 AND R3% - R5% = 1 THEN W5R% = 1
IF R2% - R4% = 1 AND R4% - R1% = 1 AND R1% - R5% = 1 AND R5% - R3% = 1 THEN W5R% = 1
IF R2% - R4% = 1 AND R4% - R3% = 1 AND R3% - R1% = 1 AND R1% - R5% = 1 THEN W5R% = 1
IF R2% - R4% = 1 AND R4% - R3% = 1 AND R3% - R5% = 1 AND R5% - R1% = 1 THEN W5R% = 1
IF R2% - R4% = 1 AND R4% - R5% = 1 AND R5% - R3% = 1 AND R3% - R1% = 1 THEN W5R% = 1
IF R2% - R4% = 1 AND R4% - R5% = 1 AND R5% - R1% = 1 AND R1% - R3% = 1 THEN W5R% = 1

IF R2% - R5% = 1 AND R5% - R1% = 1 AND R1% - R3% = 1 AND R3% - R4% = 1 THEN W5R% = 1
IF R2% - R5% = 1 AND R5% - R1% = 1 AND R1% - R4% = 1 AND R4% - R3% = 1 THEN W5R% = 1
IF R2% - R5% = 1 AND R5% - R3% = 1 AND R3% - R1% = 1 AND R1% - R4% = 1 THEN W5R% = 1
IF R2% - R5% = 1 AND R5% - R3% = 1 AND R3% - R4% = 1 AND R4% - R1% = 1 THEN W5R% = 1
IF R2% - R5% = 1 AND R5% - R4% = 1 AND R4% - R1% = 1 AND R1% - R3% = 1 THEN W5R% = 1
IF R2% - R5% = 1 AND R5% - R4% = 1 AND R4% - R3% = 1 AND R3% - R1% = 1 THEN W5R% = 1

IF R3% - R1% = 1 AND R1% - R2% = 1 AND R2% - R4% = 1 AND R4% - R5% = 1 THEN W5R% = 1
IF R3% - R1% = 1 AND R1% - R2% = 1 AND R2% - R5% = 1 AND R5% - R4% = 1 THEN W5R% = 1
IF R3% - R1% = 1 AND R1% - R4% = 1 AND R4% - R2% = 1 AND R2% - R5% = 1 THEN W5R% = 1
IF R3% - R1% = 1 AND R1% - R4% = 1 AND R4% - R5% = 1 AND R5% - R2% = 1 THEN W5R% = 1
IF R3% - R1% = 1 AND R1% - R5% = 1 AND R5% - R4% = 1 AND R4% - R2% = 1 THEN W5R% = 1
IF R3% - R1% = 1 AND R1% - R5% = 1 AND R5% - R2% = 1 AND R2% - R4% = 1 THEN W5R% = 1

IF R3% - R2% = 1 AND R2% - R1% = 1 AND R1% - R4% = 1 AND R4% - R5% = 1 THEN W5R% = 1
IF R3% - R2% = 1 AND R2% - R1% = 1 AND R1% - R5% = 1 AND R5% - R4% = 1 THEN W5R% = 1
IF R3% - R2% = 1 AND R2% - R4% = 1 AND R4% - R5% = 1 AND R5% - R1% = 1 THEN W5R% = 1
IF R3% - R2% = 1 AND R2% - R4% = 1 AND R4% - R1% = 1 AND R1% - R5% = 1 THEN W5R% = 1
IF R3% - R2% = 1 AND R2% - R5% = 1 AND R5% - R4% = 1 AND R4% - R1% = 1 THEN W5R% = 1
IF R3% - R2% = 1 AND R2% - R5% = 1 AND R5% - R1% = 1 AND R1% - R4% = 1 THEN W5R% = 1

IF R3% - R4% = 1 AND R4% - R1% = 1 AND R1% - R2% = 1 AND R2% - R5% = 1 THEN W5R% = 1
IF R3% - R4% = 1 AND R4% - R1% = 1 AND R1% - R5% = 1 AND R5% - R2% = 1 THEN W5R% = 1
IF R3% - R4% = 1 AND R4% - R2% = 1 AND R2% - R1% = 1 AND R1% - R5% = 1 THEN W5R% = 1
IF R3% - R4% = 1 AND R4% - R2% = 1 AND R2% - R5% = 1 AND R5% - R1% = 1 THEN W5R% = 1
IF R3% - R4% = 1 AND R4% - R5% = 1 AND R5% - R1% = 1 AND R1% - R2% = 1 THEN W5R% = 1
IF R3% - R4% = 1 AND R4% - R5% = 1 AND R5% - R2% = 1 AND R2% - R1% = 1 THEN W5R% = 1
                                                                                              
IF R3% - R5% = 1 AND R5% - R1% = 1 AND R1% - R2% = 1 AND R2% - R4% = 1 THEN W5R% = 1
IF R3% - R5% = 1 AND R5% - R1% = 1 AND R1% - R4% = 1 AND R4% - R2% = 1 THEN W5R% = 1
IF R3% - R5% = 1 AND R5% - R4% = 1 AND R4% - R2% = 1 AND R2% - R1% = 1 THEN W5R% = 1
IF R3% - R5% = 1 AND R5% - R4% = 1 AND R4% - R1% = 1 AND R1% - R2% = 1 THEN W5R% = 1
IF R3% - R5% = 1 AND R5% - R2% = 1 AND R2% - R1% = 1 AND R1% - R4% = 1 THEN W5R% = 1
IF R3% - R5% = 1 AND R5% - R2% = 1 AND R2% - R4% = 1 AND R4% - R1% = 1 THEN W5R% = 1

IF R4% - R1% = 1 AND R1% - R2% = 1 AND R2% - R3% = 1 AND R3% - R5% = 1 THEN W5R% = 1
IF R4% - R1% = 1 AND R1% - R2% = 1 AND R2% - R5% = 1 AND R5% - R3% = 1 THEN W5R% = 1
IF R4% - R1% = 1 AND R1% - R3% = 1 AND R3% - R5% = 1 AND R5% - R2% = 1 THEN W5R% = 1
IF R4% - R1% = 1 AND R1% - R3% = 1 AND R3% - R2% = 1 AND R2% - R5% = 1 THEN W5R% = 1
IF R4% - R1% = 1 AND R1% - R5% = 1 AND R5% - R2% = 1 AND R2% - R3% = 1 THEN W5R% = 1
IF R4% - R1% = 1 AND R1% - R5% = 1 AND R5% - R3% = 1 AND R3% - R2% = 1 THEN W5R% = 1

IF R4% - R2% = 1 AND R2% - R1% = 1 AND R1% - R3% = 1 AND R3% - R5% = 1 THEN W5R% = 1
IF R4% - R2% = 1 AND R2% - R1% = 1 AND R1% - R5% = 1 AND R5% - R3% = 1 THEN W5R% = 1
IF R4% - R2% = 1 AND R2% - R3% = 1 AND R3% - R5% = 1 AND R5% - R1% = 1 THEN W5R% = 1
IF R4% - R2% = 1 AND R2% - R3% = 1 AND R3% - R1% = 1 AND R1% - R5% = 1 THEN W5R% = 1
IF R4% - R2% = 1 AND R2% - R5% = 1 AND R5% - R1% = 1 AND R1% - R3% = 1 THEN W5R% = 1
IF R4% - R2% = 1 AND R2% - R5% = 1 AND R5% - R3% = 1 AND R3% - R1% = 1 THEN W5R% = 1

IF R4% - R3% = 1 AND R3% - R5% = 1 AND R5% - R1% = 1 AND R1% - R2% = 1 THEN W5R% = 1
IF R4% - R3% = 1 AND R3% - R5% = 1 AND R5% - R2% = 1 AND R2% - R1% = 1 THEN W5R% = 1
IF R4% - R3% = 1 AND R3% - R1% = 1 AND R1% - R2% = 1 AND R2% - R5% = 1 THEN W5R% = 1
IF R4% - R3% = 1 AND R3% - R1% = 1 AND R1% - R5% = 1 AND R5% - R2% = 1 THEN W5R% = 1
IF R4% - R3% = 1 AND R3% - R2% = 1 AND R2% - R1% = 1 AND R1% - R5% = 1 THEN W5R% = 1
IF R4% - R3% = 1 AND R3% - R2% = 1 AND R2% - R5% = 1 AND R5% - R1% = 1 THEN W5R% = 1

IF R4% - R5% = 1 AND R5% - R3% = 1 AND R3% - R1% = 1 AND R1% - R2% = 1 THEN W5R% = 1
IF R4% - R5% = 1 AND R5% - R3% = 1 AND R3% - R2% = 1 AND R2% - R1% = 1 THEN W5R% = 1
IF R4% - R5% = 1 AND R5% - R1% = 1 AND R1% - R2% = 1 AND R2% - R3% = 1 THEN W5R% = 1
IF R4% - R5% = 1 AND R5% - R1% = 1 AND R1% - R3% = 1 AND R3% - R2% = 1 THEN W5R% = 1
IF R4% - R5% = 1 AND R5% - R2% = 1 AND R2% - R3% = 1 AND R3% - R1% = 1 THEN W5R% = 1
IF R4% - R5% = 1 AND R5% - R2% = 1 AND R2% - R1% = 1 AND R1% - R3% = 1 THEN W5R% = 1

IF R5% - R1% = 1 AND R1% - R2% = 1 AND R2% - R3% = 1 AND R3% - R4% = 1 THEN W5R% = 1
IF R5% - R1% = 1 AND R1% - R2% = 1 AND R2% - R4% = 1 AND R4% - R3% = 1 THEN W5R% = 1
IF R5% - R1% = 1 AND R1% - R3% = 1 AND R3% - R2% = 1 AND R2% - R4% = 1 THEN W5R% = 1
IF R5% - R1% = 1 AND R1% - R3% = 1 AND R3% - R4% = 1 AND R4% - R2% = 1 THEN W5R% = 1
IF R5% - R1% = 1 AND R1% - R4% = 1 AND R4% - R2% = 1 AND R2% - R3% = 1 THEN W5R% = 1
IF R5% - R1% = 1 AND R1% - R4% = 1 AND R4% - R3% = 1 AND R3% - R2% = 1 THEN W5R% = 1

IF R5% - R2% = 1 AND R2% - R1% = 1 AND R1% - R4% = 1 AND R4% - R3% = 1 THEN W5R% = 1
IF R5% - R2% = 1 AND R2% - R1% = 1 AND R1% - R3% = 1 AND R3% - R4% = 1 THEN W5R% = 1
IF R5% - R2% = 1 AND R2% - R4% = 1 AND R4% - R3% = 1 AND R3% - R1% = 1 THEN W5R% = 1
IF R5% - R2% = 1 AND R2% - R4% = 1 AND R4% - R1% = 1 AND R1% - R3% = 1 THEN W5R% = 1
IF R5% - R2% = 1 AND R2% - R3% = 1 AND R3% - R4% = 1 AND R4% - R1% = 1 THEN W5R% = 1
IF R5% - R2% = 1 AND R2% - R3% = 1 AND R3% - R1% = 1 AND R1% - R4% = 1 THEN W5R% = 1

IF R5% - R3% = 1 AND R3% - R1% = 1 AND R1% - R2% = 1 AND R2% - R4% = 1 THEN W5R% = 1
IF R5% - R3% = 1 AND R3% - R1% = 1 AND R1% - R4% = 1 AND R4% - R2% = 1 THEN W5R% = 1
IF R5% - R3% = 1 AND R3% - R2% = 1 AND R2% - R1% = 1 AND R1% - R4% = 1 THEN W5R% = 1
IF R5% - R3% = 1 AND R3% - R2% = 1 AND R2% - R4% = 1 AND R4% - R1% = 1 THEN W5R% = 1
IF R5% - R3% = 1 AND R3% - R4% = 1 AND R4% - R2% = 1 AND R2% - R1% = 1 THEN W5R% = 1
IF R5% - R3% = 1 AND R3% - R4% = 1 AND R4% - R1% = 1 AND R1% - R2% = 1 THEN W5R% = 1

IF R5% - R4% = 1 AND R4% - R1% = 1 AND R1% - R2% = 1 AND R2% - R3% = 1 THEN W5R% = 1
IF R5% - R4% = 1 AND R4% - R1% = 1 AND R1% - R3% = 1 AND R3% - R2% = 1 THEN W5R% = 1
IF R5% - R4% = 1 AND R4% - R2% = 1 AND R2% - R1% = 1 AND R1% - R3% = 1 THEN W5R% = 1
IF R5% - R4% = 1 AND R4% - R2% = 1 AND R2% - R3% = 1 AND R3% - R1% = 1 THEN W5R% = 1
IF R5% - R4% = 1 AND R4% - R3% = 1 AND R3% - R2% = 1 AND R2% - R1% = 1 THEN W5R% = 1
IF R5% - R4% = 1 AND R4% - R3% = 1 AND R3% - R1% = 1 AND R1% - R2% = 1 THEN W5R% = 1

RETURN

CLEANCN:

WP1% = 0
WP2% = 0
WP3% = 0
WP4% = 0
WP5% = 0
WP6% = 0
WP7% = 0
WP8% = 0
WP9% = 0
WP10% = 0
WF% = 0
W515% = 0
W4151% = 0
W4152% = 0
W4153% = 0
W4154% = 0
W4155% = 0
W3151% = 0
W3152% = 0
W3153% = 0
W3154% = 0
W3155% = 0
W3156% = 0
W3157% = 0
W3158% = 0
W3159% = 0
W31510% = 0
W2151% = 0
W2152% = 0
W2153% = 0
W2154% = 0
W2155% = 0
W2156% = 0
W2157% = 0
W2158% = 0
W2159% = 0
W21510% = 0
W3R1% = 0
W3R2% = 0
W3R3% = 0
W3R4% = 0
W3R5% = 0
W3R6% = 0
W3R7% = 0
W3R8% = 0
W3R9% = 0
W3R10% = 0
W4R1% = 0
W4R2% = 0
W4R3% = 0
W4R4% = 0
W4R5% = 0
W5R% = 0
SCR% = 0
RETURN

TALLY:
IF WP1% = 1 THEN SCR% = SCR% + 2
IF WP2% = 1 THEN SCR% = SCR% + 2
IF WP3% = 1 THEN SCR% = SCR% + 2
IF WP4% = 1 THEN SCR% = SCR% + 2
IF WP5% = 1 THEN SCR% = SCR% + 2
IF WP6% = 1 THEN SCR% = SCR% + 2
IF WP7% = 1 THEN SCR% = SCR% + 2
IF WP8% = 1 THEN SCR% = SCR% + 2
IF WP9% = 1 THEN SCR% = SCR% + 2
IF WP10% = 1 THEN SCR% = SCR% + 2
IF WF% = 1 THEN SCR% = SCR% + 5
IF W515% = 1 THEN SCR% = SCR% + 2
IF W4151% = 1 THEN SCR% = SCR% + 2
IF W4152% = 1 THEN SCR% = SCR% + 2
IF W4153% = 1 THEN SCR% = SCR% + 2
IF W4154% = 1 THEN SCR% = SCR% + 2
IF W4155% = 1 THEN SCR% = SCR% + 2
IF W3151% = 1 THEN SCR% = SCR% + 2
IF W3152% = 1 THEN SCR% = SCR% + 2
IF W3153% = 1 THEN SCR% = SCR% + 2
IF W3154% = 1 THEN SCR% = SCR% + 2
IF W3155% = 1 THEN SCR% = SCR% + 2
IF W3156% = 1 THEN SCR% = SCR% + 2
IF W3157% = 1 THEN SCR% = SCR% + 2
IF W3158% = 1 THEN SCR% = SCR% + 2
IF W3159% = 1 THEN SCR% = SCR% + 2
IF W31510% = 1 THEN SCR% = SCR% + 2
IF W2151% = 1 THEN SCR% = SCR% + 2
IF W2152% = 1 THEN SCR% = SCR% + 2
IF W2153% = 1 THEN SCR% = SCR% + 2
IF W2154% = 1 THEN SCR% = SCR% + 2
IF W2155% = 1 THEN SCR% = SCR% + 2
IF W2156% = 1 THEN SCR% = SCR% + 2
IF W2157% = 1 THEN SCR% = SCR% + 2
IF W2158% = 1 THEN SCR% = SCR% + 2
IF W2159% = 1 THEN SCR% = SCR% + 2
IF W21510% = 1 THEN SCR% = SCR% + 2
IF W3R1% = 1 THEN SCR% = SCR% + 3
IF W3R2% = 1 THEN SCR% = SCR% + 3
IF W3R3% = 1 THEN SCR% = SCR% + 3
IF W3R4% = 1 THEN SCR% = SCR% + 3
IF W3R5% = 1 THEN SCR% = SCR% + 3
IF W3R6% = 1 THEN SCR% = SCR% + 3
IF W3R7% = 1 THEN SCR% = SCR% + 3
IF W3R8% = 1 THEN SCR% = SCR% + 3
IF W3R9% = 1 THEN SCR% = SCR% + 3
IF W3R10% = 1 THEN SCR% = SCR% + 3
IF W4R1% = 1 THEN SCR% = SCR% + 4
IF W4R2% = 1 THEN SCR% = SCR% + 4
IF W4R3% = 1 THEN SCR% = SCR% + 4
IF W4R4% = 1 THEN SCR% = SCR% + 4
IF W4R5% = 1 THEN SCR% = SCR% + 4
IF W5R% = 1 THEN SCR% = SCR% + 5

RETURN

HIGHSCORE:
CLS
OPEN "CS.SCO" FOR BINARY ACCESS READ WRITE AS #1
N1$ = STRING$(3, " ")
S1$ = STRING$(3, " ")
GET #1, 1, N1$
GET #1, 4, S1$
N2$ = STRING$(3, " ")
S2$ = STRING$(3, " ")
GET #1, 7, N2$
GET #1, 10, S2$
N3$ = STRING$(3, " ")
S3$ = STRING$(3, " ")
GET #1, 13, N3$
GET #1, 16, S3$
N4$ = STRING$(3, " ")
S4$ = STRING$(3, " ")
GET #1, 19, N4$
GET #1, 22, S4$
N5$ = STRING$(3, " ")
S5$ = STRING$(3, " ")
GET #1, 25, N5$
GET #1, 28, S5$
N6$ = STRING$(3, " ")
S6$ = STRING$(3, " ")
GET #1, 31, N6$
GET #1, 34, S6$
N7$ = STRING$(3, " ")
S7$ = STRING$(3, " ")
GET #1, 37, N7$
GET #1, 40, S7$
N8$ = STRING$(3, " ")
S8$ = STRING$(3, " ")
GET #1, 43, N8$
GET #1, 46, S8$
N9$ = STRING$(3, " ")
S9$ = STRING$(3, " ")
GET #1, 49, N9$
GET #1, 52, S9$
N10$ = STRING$(3, " ")
S10$ = STRING$(3, " ")
GET #1, 55, N10$
GET #1, 58, S10$
CLOSE #1

IF TOTAL% > VAL(S10$) THEN HSPOS% = 10
IF TOTAL% > VAL(S9$) THEN HSPOS% = 9
IF TOTAL% > VAL(S8$) THEN HSPOS% = 8
IF TOTAL% > VAL(S7$) THEN HSPOS% = 7
IF TOTAL% > VAL(S6$) THEN HSPOS% = 6
IF TOTAL% > VAL(S5$) THEN HSPOS% = 5
IF TOTAL% > VAL(S4$) THEN HSPOS% = 4
IF TOTAL% > VAL(S3$) THEN HSPOS% = 3
IF TOTAL% > VAL(S2$) THEN HSPOS% = 2
IF TOTAL% > VAL(S1$) THEN HSPOS% = 1
IF TOTAL% = VAL(S10$) THEN GOSUB VIEWHS
IF TOTAL% < VAL(S10$) THEN GOSUB VIEWHS
IF TOTAL% = VAL(S10$) THEN RETURN
IF TOTAL% < VAL(S10$) THEN RETURN

LOCATE 12, 17: PRINT "Congratulations! You got the #"; HSPOS%; "high score!"
LOCATE 14, 25: PRINT "Enter your initials:"
9394 LOCATE 14, 47: PRINT "   "
NN1$ = UCASE$(INPUT$(1))
IF NN1$ = CHR$(8) THEN GOTO 9394
LOCATE 14, 47: PRINT NN1$
9396 LOCATE 14, 48: PRINT "   "
NN2$ = UCASE$(INPUT$(1))
IF NN2$ = CHR$(8) THEN GOTO 9394
LOCATE 14, 48: PRINT NN2$
9398 LOCATE 14, 49: PRINT "   "
NN3$ = UCASE$(INPUT$(1))
IF NN3$ = CHR$(8) THEN GOTO 9396
LOCATE 14, 49: PRINT NN3$
NEWNAME$ = LTRIM$(NN1$) + LTRIM$(NN2$) + LTRIM$(NN3$)
CLS
IF TOTAL% < 10 THEN GOSUB ONEDIGIT
IF TOTAL% > 9 THEN GOSUB TWODIGIT
IF TOTAL% > 99 THEN GOSUB THREEDIGIT

IF HSPOS% = 1 THEN GOSUB PLACE1
IF HSPOS% = 2 THEN GOSUB PLACE2
IF HSPOS% = 3 THEN GOSUB PLACE3
IF HSPOS% = 4 THEN GOSUB PLACE4
IF HSPOS% = 5 THEN GOSUB PLACE5
IF HSPOS% = 6 THEN GOSUB PLACE6
IF HSPOS% = 7 THEN GOSUB PLACE7
IF HSPOS% = 8 THEN GOSUB PLACE8
IF HSPOS% = 9 THEN GOSUB PLACE9
IF HSPOS% = 10 THEN GOSUB PLACE10


OPEN "CS.SCO" FOR BINARY ACCESS READ WRITE AS #1
PUT #1, 1, N1$
PUT #1, 4, S1$
PUT #1, 7, N2$
PUT #1, 10, S2$
PUT #1, 13, N3$
PUT #1, 16, S3$
PUT #1, 19, N4$
PUT #1, 22, S4$
PUT #1, 25, N5$
PUT #1, 28, S5$
PUT #1, 31, N6$
PUT #1, 34, S6$
PUT #1, 37, N7$
PUT #1, 40, S7$
PUT #1, 43, N8$
PUT #1, 46, S8$
PUT #1, 49, N9$
PUT #1, 52, S9$
PUT #1, 55, N10$
PUT #1, 58, S10$
CLOSE #1
GOSUB VIEWHS

RETURN

ONEDIGIT:
NEWSCORE$ = "  " + LTRIM$(STR$(TOTAL%))
RETURN

TWODIGIT:
NEWSCORE$ = " " + LTRIM$(STR$(TOTAL%))
RETURN

THREEDIGIT:
NEWSCORE$ = LTRIM$(STR$(TOTAL%))
RETURN

PLACE1:
N10$ = N9$
N9$ = N8$
N8$ = N7$
N7$ = N6$
N6$ = N5$
N5$ = N4$
N4$ = N3$
N3$ = N2$
N2$ = N1$
N1$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = S7$
S7$ = S6$
S6$ = S5$
S5$ = S4$
S4$ = S3$
S3$ = S2$
S2$ = S1$
S1$ = NEWSCORE$
RETURN

PLACE2:
N10$ = N9$
N9$ = N8$
N8$ = N7$
N7$ = N6$
N6$ = N5$
N5$ = N4$
N4$ = N3$
N3$ = N2$
N2$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = S7$
S7$ = S6$
S6$ = S5$
S5$ = S4$
S4$ = S3$
S3$ = S2$
S2$ = NEWSCORE$
RETURN

PLACE3:
N10$ = N9$
N9$ = N8$
N8$ = N7$
N7$ = N6$
N6$ = N5$
N5$ = N4$
N4$ = N3$
N3$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = S7$
S7$ = S6$
S6$ = S5$
S5$ = S4$
S4$ = S3$
S3$ = NEWSCORE$
RETURN

PLACE4:
N10$ = N9$
N9$ = N8$
N8$ = N7$
N7$ = N6$
N6$ = N5$
N5$ = N4$
N4$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = S7$
S7$ = S6$
S6$ = S5$
S5$ = S4$
S4$ = NEWSCORE$
RETURN

PLACE5:
N10$ = N9$
N9$ = N8$
N8$ = N7$
N7$ = N6$
N6$ = N5$
N5$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = S7$
S7$ = S6$
S6$ = S5$
S5$ = NEWSCORE$
RETURN

PLACE6:
N10$ = N9$
N9$ = N8$
N8$ = N7$
N7$ = N6$
N6$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = S7$
S7$ = S6$
S6$ = NEWSCORE$
RETURN

PLACE7:
N10$ = N9$
N9$ = N8$
N8$ = N7$
N7$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = S7$
S7$ = NEWSCORE$
RETURN

PLACE8:
N10$ = N9$
N9$ = N8$
N8$ = NEWNAME$
S10$ = S9$
S9$ = S8$
S8$ = NEWSCORE$
RETURN

PLACE9:
N10$ = N9$
N9$ = NEWNAME$
S10$ = S9$
S9$ = NEWSCORE$
RETURN

PLACE10:
N10$ = NEWNAME$
S10$ = NEWSCORE$
RETURN

VIEWHS:
LOCATE 5, 25: PRINT "Cribbage Solitaire High Scores"
LOCATE 7, 22: PRINT N1$
LOCATE 7, 54: PRINT S1$
LOCATE 8, 22: PRINT N2$
LOCATE 8, 54: PRINT S2$
LOCATE 9, 22: PRINT N3$
LOCATE 9, 54: PRINT S3$
LOCATE 10, 22: PRINT N4$
LOCATE 10, 54: PRINT S4$
LOCATE 11, 22: PRINT N5$
LOCATE 11, 54: PRINT S5$
LOCATE 12, 22: PRINT N6$
LOCATE 12, 54: PRINT S6$
LOCATE 13, 22: PRINT N7$
LOCATE 13, 54: PRINT S7$
LOCATE 14, 22: PRINT N8$
LOCATE 14, 54: PRINT S8$
LOCATE 15, 22: PRINT N9$
LOCATE 15, 54: PRINT S9$
LOCATE 16, 22: PRINT N10$
LOCATE 16, 54: PRINT S10$
LOCATE 18, 25: PRINT "Press any key to continue . . ."
DO: LOOP WHILE INKEY$ = ""
RETURN

RESETSCORES:
CLS
LOCATE 12, 14: PRINT "Are you sure you want to reset the high scores (Y/N)?"
RESETX$ = UCASE$(INPUT$(1))
9981 IF RESETX$ = "Y" THEN GOTO 9983
IF RESETX$ = "N" THEN RETURN
GOTO 9981
9983 OPEN "CS.SCO" FOR BINARY ACCESS READ WRITE AS #1
N1$ = "***"
S1$ = "  0"
N2$ = "***"
S2$ = "  0"
N3$ = "***"
S3$ = "  0"
N4$ = "***"
S4$ = "  0"
N5$ = "***"
S5$ = "  0"
N6$ = "***"
S6$ = "  0"
N7$ = "***"
S7$ = "  0"
N8$ = "***"
S8$ = "  0"
N9$ = "***"
S9$ = "  0"
N10$ = "***"
S10$ = "  0"
PUT #1, 1, N1$
PUT #1, 4, S1$
PUT #1, 7, N2$
PUT #1, 10, S2$
PUT #1, 13, N3$
PUT #1, 16, S3$
PUT #1, 19, N4$
PUT #1, 22, S4$
PUT #1, 25, N5$
PUT #1, 28, S5$
PUT #1, 31, N6$
PUT #1, 34, S6$
PUT #1, 37, N7$
PUT #1, 40, S7$
PUT #1, 43, N8$
PUT #1, 46, S8$
PUT #1, 49, N9$
PUT #1, 52, S9$
PUT #1, 55, N10$
PUT #1, 58, S10$
CLOSE #1
RETURN





