/* graphics.h -- Header for graphics.c */

#ifndef GRAPHICS_H
#define GRAPHICS_H

#include "defs.h"

#include <curses.h>

/* Structure for drawings to be made */
struct drawing
{
  char *stages[LIVES_AVAIL];	/* incremental figure to draw */
  int start_line[LIVES_AVAIL];	/* for each stage, row to start */
  char *desc;			/* description of drawing */
  char *hanged_msg;		/* what to display when hanged */
  char *saved_msg;		/* what to show when saved */
};

/* Different drawings available */
extern struct drawing *draw_cur;	/* current drawing */
extern struct drawing *draw_man;	/* man */
extern struct drawing *draw_tux;	/* tux the penguin */
extern struct drawing *draw_bill;	/* bill gate$ */
extern struct drawing *draw_sco;
/*   sco guy, going the way of the dinosaur */

#ifdef __LINUX__
void global_resize_screen (void);
#endif /* linux */

void init_curses (void);
void init_drawings (void);
void print_art (WINDOW * win, int number);
void print_gameover (WINDOW * win);
void print_welldone (WINDOW * win);
void print_bill (WINDOW * win, int number);
void print_letter_list (char *letter_list);
void print_underscores (char *guessed_word);
void print_score (void);
void restore_terminal (void);

#endif /* GRAPHICS_H */
