DECLARE SUB WinImage ()
DECLARE SUB GWipeScreen ()
DECLARE SUB GGameOver ()
DECLARE SUB MShiftPal (ColorToShift AS INTEGER)
DECLARE SUB Menu ()
DECLARE SUB MLoadAll ()
DECLARE SUB WaitVr (TimeToKill%)
DECLARE FUNCTION GCenterText% (NumChars%)
DECLARE SUB GClearVScreen ()
DECLARE SUB BonusMessage (MsgNo%)
DECLARE SUB GDisplayMenu ()
DECLARE SUB GLoadPalette (FileName$)
DECLARE SUB GLoadSprite (FileName$, GraphicArray() AS INTEGER)
DECLARE SUB GStoreSprite (GraphicArray() AS INTEGER, NumSprites%)
DECLARE SUB GNullPalette ()
DECLARE SUB GLoadAll ()
DECLARE SUB PPlayerInput ()
DECLARE SUB PPlayerMove ()
DECLARE SUB GPlayerPut ()
DECLARE SUB Main ()
DECLARE SUB GDisplayMap ()
DECLARE SUB PCheckEgg ()
DECLARE SUB PInitVariables ()
DECLARE SUB GLoadMap (MapFileName$)
DECLARE SUB GStoreFont (FontArray() AS INTEGER, CharAmount%)
DECLARE SUB GTextPut (FontX%, FontY%, Text$)
DECLARE SUB GLevelCheck ()

'$INCLUDE: 'mylib.bi'
DEFINT A-Z
SCREEN 13

'$DYNAMIC

TYPE tObject
    XPos AS INTEGER
    YPos AS INTEGER
    XFin AS INTEGER
    YFin AS INTEGER
    XDir AS INTEGER
    YDir AS INTEGER
    Time AS SINGLE
    Frame AS INTEGER
    Moving AS INTEGER
END TYPE

' Graphic arrays
DIM SHARED VScreen(32001)
DIM SHARED TileSet(1560) AS INTEGER
DIM SHARED FontSet(1665) AS INTEGER
DIM SHARED PlayerSprite(1040) AS INTEGER
DIM SHARED ClearVar(201) AS INTEGER

' Attribute variables
DIM SHARED Player AS tObject
DIM SHARED TimeLeft AS INTEGER
DIM SHARED TimeDelay AS SINGLE
DIM SHARED TotalEggs AS INTEGER
DIM SHARED EggsFound AS INTEGER

DIM SHARED Map(0 TO 19, 0 TO 11) AS INTEGER

'Flag variables
DIM SHARED TRUE AS INTEGER
DIM SHARED FALSE AS INTEGER
DIM SHARED Level AS INTEGER
DIM SHARED LoadNextLevel AS INTEGER

' Init flags
TRUE = 1
FALSE = 0

'Menu variables
DIM SHARED MenuKey AS SINGLE
DIM SHARED ShiftDir AS INTEGER

Main
END

REM $STATIC
SUB BonusMessage (MsgNo)
    
    GClearVScreen
   
    IF MsgNo = 1 THEN GTextPut GCenterText%(19), 80, "Final Fantasy Rocks"
    IF MsgNo = 2 THEN GTextPut GCenterText%(15), 80, "Happy New Year"
    IF MsgNo = 3 THEN GTextPut GCenterText%(19), 80, "DarkDread Rocks"
    IF MsgNo = 4 THEN GTextPut GCenterText%(31), 80, "Chobos are better then Chocobos"
    IF MsgNo = 5 THEN GTextPut GCenterText%(24), 80, "Look out for the Wizards"
    IF MsgNo = 6 THEN GTextPut GCenterText%(16), 80, "There magical"
    IF MsgNo = 7 THEN GTextPut GCenterText%(18), 80, "And full of mayhem"
    IF MsgNo = 8 THEN GTextPut GCenterText%(16), 80, "Sometime in the future"
   
    MMBcopy VARSEG(VScreen(0)), &HA000

END SUB

FUNCTION GCenterText% (NumChars)

HalfChars = INT(NumChars / 2)
GCenterText% = 160 - (HalfChars * 8)

END FUNCTION

SUB GClearVScreen

FOR y = 0 TO 9
    FOR x = 0 TO 15
        mmputs 1, x * 20, y * 20, VARSEG(ClearVar(0)), VARSEG(VScreen(0))
    NEXT
NEXT

END SUB

SUB GDisplayMap

FOR y = 0 TO 11
    FOR x = 0 TO 19
        mmputs VARPTR(TileSet(Map(x, y) * 130 + 2)), x * 16, y * 16, VARSEG(TileSet(Map(x, y) * 130)), VARSEG(VScreen(0))
    NEXT
NEXT

WaitVr 0
END SUB

SUB GDisplayMenu

' This controls the timer and how fast it ticks down
IF TIMER - TimeDelay > 1 THEN
    TimeLeft = TimeLeft - 1
    TimeDelay = TIMER

    ' If the time has reached 0 go back to the menu
    ' we will make a game over sign also
    IF TimeLeft = 0 THEN
        GWipeScreen
        GGameOver
        Menu
        PInitVariables
    END IF
END IF

' Convert the timer integer variable to a string so our
' text put routine can output it to the screen
szTimeLeft$ = LTRIM$(STR$(TimeLeft))
GTextPut 3, 3, "Time"
GTextPut 45, 3, szTimeLeft$

szEggsFound$ = LTRIM$(STR$(EggsFound))
szTotalEggs$ = LTRIM$(STR$(TotalEggs))
GTextPut 90, 3, "Eggs"
GTextPut 138, 3, szEggsFound$
GTextPut 171, 3, "Of"
GTextPut 195, 3, szTotalEggs$

END SUB

SUB GGameOver

GLoadSprite "GameOver.mmg", VScreen()
GLoadPalette "GmPal.mmp"
KeyBoardOff


PUT (0, 0), VScreen, PSET
DO: LOOP UNTIL INKEY$ <> ""

KeyBoardOn
GClearVScreen

Level = 0

END SUB

SUB GLevelCheck

' If this is TRUE then you are going to have to
' Re-init the variables no matter what the level is
IF LoadNextLevel = TRUE THEN
 
    BonusMessage (Level)
    DO: LOOP UNTIL GetKey%(28)

    PInitVariables
    LoadNextLevel = FALSE
    TotalEggs = 0

    IF Level = 2 THEN GLoadMap ("Level2")
    IF Level = 3 THEN GLoadMap ("level3")
    IF Level = 4 THEN GLoadMap ("Level4")
    IF Level = 5 THEN GLoadMap ("Level5")
    IF Level = 6 THEN GLoadMap ("Level6")
    IF Level = 7 THEN GLoadMap ("Level7")
    IF Level = 8 THEN GLoadMap ("Level8")
    IF Level = 9 THEN
        GWipeScreen
        WinImage
        Menu
        PInitVariables
    END IF
    
END IF

END SUB

SUB GLoadAll

GNullPalette

GLoadSprite "FontSet.mmg", FontSet()
GStoreFont FontSet(), 35

GLoadSprite "CharSet.mmg", PlayerSprite()
GStoreSprite PlayerSprite(), 7

GLoadSprite "TileSet.mmg", TileSet()
GStoreSprite TileSet(), 11

GLoadPalette "SetPal.mmp"

END SUB

SUB GLoadMap (MapFileName$)

OPEN MapFileName$ + ".MmL" FOR INPUT AS #1
INPUT #1, TimeLeft   ' How much time you get for this level
FOR y = 0 TO 11
    FOR x = 0 TO 19
        INPUT #1, Map(x, y)
        IF Map(x, y) = 2 THEN TotalEggs = TotalEggs + 1
    NEXT x
NEXT y
CLOSE #1

END SUB

SUB GLoadPalette (FileName$)

' Palette loading routine
OPEN FileName$ FOR BINARY AS #1
FOR I = 0 TO 255
    R$ = " "        ' Initialize RGB variables
    G$ = " "
    B$ = " "
   
    GET #1, , R$    ' Get the RGB values from the file
    GET #1, , G$
    GET #1, , B$

    R = ASC(R$)     ' Convert the RGB values from strings to integers
    G = ASC(G$)
    B = ASC(B$)

    OUT &H3C8, I    ' Set the palette to the new RGB values
    OUT &H3C9, R
    OUT &H3C9, G
    OUT &H3C9, B
NEXT
CLOSE #1

END SUB

SUB GLoadSprite (FileName$, GraphicArray() AS INTEGER)

' Graphic loading routine
DEF SEG = VARSEG(GraphicArray(0))
BLOAD FileName$, VARPTR(GraphicArray(0))
DEF SEG

END SUB

SUB GNullPalette

FOR I = 0 TO 255
    OUT &H3C8, I
    OUT &H3C9, 0
    OUT &H3C9, 0
    OUT &H3C9, 0
NEXT

END SUB

SUB GPlayerPut

' Sub routine to draw the player
IF Player.Moving THEN
    ' Every .02 seconds switch frames
    IF TIMER - Player.Time > .02 THEN
        Player.Frame = NOT Player.Frame  ' Frame will equal either -1 or 0
        Player.Time = TIMER              ' Reset the time counter
    END IF

    ' Draw the player moving
    IF Player.YDir = -1 THEN
        IF Player.Frame = 0 THEN mmput VARPTR(PlayerSprite(6 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
        IF Player.Frame = -1 THEN mmput VARPTR(PlayerSprite(7 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    ELSEIF Player.YDir = 1 THEN
        IF Player.Frame = 0 THEN mmput VARPTR(PlayerSprite(4 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
        IF Player.Frame = -1 THEN mmput VARPTR(PlayerSprite(5 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    ELSEIF Player.XDir = -1 THEN
        IF Player.Frame = 0 THEN mmput VARPTR(PlayerSprite(0 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
        IF Player.Frame = -1 THEN mmput VARPTR(PlayerSprite(1 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    ELSEIF Player.XDir = 1 THEN
        IF Player.Frame = 0 THEN mmput VARPTR(PlayerSprite(2 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
        IF Player.Frame = -1 THEN mmput VARPTR(PlayerSprite(3 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    END IF
ELSE
    ' Draw the player still
    IF Player.Frame = -1 THEN
        mmput VARPTR(PlayerSprite(6 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    ELSEIF Player.Frame = 3 THEN
        mmput VARPTR(PlayerSprite(4 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    ELSEIF Player.Frame = -2 THEN
        mmput VARPTR(PlayerSprite(0 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    ELSEIF Player.Frame = 2 THEN
        mmput VARPTR(PlayerSprite(2 * 130 + 2)), Player.XFin, Player.YFin, VARSEG(PlayerSprite(0)), VARSEG(VScreen(0))
    END IF
END IF

END SUB

SUB GStoreFont (FontArray() AS INTEGER, CharAmount)

FontX = 0
FontY = 0

PUT (0, 0), FontArray, PSET                           ' Put down font
FOR I = 0 TO CharAmount
    ' Every 26 character move down one row
    IF FontX = 26 THEN
        FontX = 0
        FontY = FontY + 1
    END IF
   
    ' Get font and store it properly
    GET (FontX * 8, FontY * 8)-(FontX * 8 + 7, FontY * 8 + 7), FontArray(I * 34)
    LINE (FontX * 8, FontY * 8)-(FontX * 8 + 7, FontY * 8 + 7), 0, BF
   
    ' Move forward 1 character
    FontX = FontX + 1
NEXT
 
END SUB

SUB GStoreSprite (GraphicArray() AS INTEGER, NumSprites)

' We can't just BLOAD the graphics, we have to store them
' so that the graphic array is devided into 16 by 16 sprites
' When we first BLOAD the graphics it stores them as one big
' sprite
PUT (0, 0), GraphicArray, PSET
FOR I = 0 TO NumSprites
    GET (I * 16, 0)-(I * 16 + 15, 15), GraphicArray(I * 130)
    LINE (I * 16, 0)-(I * 16 + 15, 15), 0, BF
NEXT

END SUB

SUB GTextPut (FontX, FontY, Text$)

' Font put routine to output letters to the screen
FOR I = 1 TO LEN(Text$)
    Text$ = UCASE$(Text$)         ' Always make text upper-case
    Letter$ = MID$(Text$, I, 1)   ' Get a letter
    LetterVal = ASC(Letter$)      ' Convert letter to value
   
    IF LetterVal > 47 AND LetterVal < 58 THEN
        LetterVal = LetterVal - 22
    ELSE
        LetterVal = LetterVal - 65    ' The upper-case "A" starts at 65 in the ASC values
    END IF

    IF Letter$ <> " " THEN mmput VARPTR(FontSet(LetterVal * 34 + 2)), FontX, FontY, VARSEG(FontSet(0)), VARSEG(VScreen(0))
    FontX = FontX + 9             ' Move to the next letters position

NEXT

END SUB

SUB GWipeScreen

gWidth = 0
gHeight = 0
gWidthMax = 319
gHeightMax = 199

DO
    LINE (gWidth, gHeight)-(gWidthMax, gHeightMax), 0, B

    gWidth = gWidth + 1
    gHeight = gHeight + 1
    gWidthMax = gWidthMax - 1
    gHeightMax = gHeightMax - 1

    WaitVr 1
LOOP UNTIL gHeight = 99

END SUB

SUB Main

KeyBoardOn
Menu

PInitVariables

DO
    PPlayerInput
    PPlayerMove
    GDisplayMap
    GPlayerPut
    PCheckEgg
    GDisplayMenu
    GLevelCheck
   
    MMBcopy VARSEG(VScreen(0)), &HA000
    

LOOP UNTIL GetKey%(1)
KeyBoardOff

END SUB

SUB Menu

MLoadAll

Selection = 0
Choice = 0

DO
    ' Check for key presses
    IF TIMER - MenuKey! > .01 THEN
        IF GetKey%(72) THEN Selection = 0
        IF GetKey%(80) THEN Selection = -1
        IF GetKey%(28) THEN
            IF Selection = 0 THEN Choice = 1
            IF Selection = -1 THEN Choice = 2
        END IF
        MenuKey! = TIMER
    END IF
   
    ' Shift the palette
    MShiftPal Selection
    WaitVr 0

LOOP UNTIL Choice

' Exit if user chooses too
IF Choice = 2 THEN
    KeyBoardOff
    END
END IF

' Erase the back buffer
GClearVScreen

END SUB

SUB MLoadAll

LINE (0, 0)-(19, 19), 0, BF
GET (0, 0)-(19, 19), ClearVar
GLoadSprite "MenuBG.mmg", VScreen()
GLoadPalette "MnuPal.mmp"

' First menu selection color
OUT &H3C8, 135
OUT &H3C9, 63
OUT &H3C9, 63
OUT &H3C9, 63

' Second menu selection color
OUT &H3C8, 183
OUT &H3C9, 63
OUT &H3C9, 63
OUT &H3C9, 63

PUT (0, 0), VScreen, PSET

END SUB

SUB MShiftPal (ColorToShift AS INTEGER)

' Select Color to shift
IF ColorToShift = 0 THEN
    OUT &H3C7, 135
ELSE
    OUT &H3C7, 183
END IF

' Get the RBG values of the color
R = INP(&H3C9)
G = INP(&H3C9)
B = INP(&H3C9)

' Shift the green value
IF ShiftDir = 0 THEN
    IF G > 0 THEN G = G - 1
ELSEIF ShiftDir = -1 THEN
    IF G < 63 THEN G = G + 1
END IF

' If either of the values have bin reached then make
' the shift go back the other way
IF G = 0 OR G = 63 THEN ShiftDir = NOT ShiftDir
      
' Select color to shift and make the other option white
IF ColorToShift = 0 THEN
    OUT &H3C8, 183
    OUT &H3C9, 63
    OUT &H3C9, 63
    OUT &H3C9, 63
   
    OUT &H3C8, 135
ELSE
    OUT &H3C8, 135
    OUT &H3C9, 63
    OUT &H3C9, 63
    OUT &H3C9, 63
   
    OUT &H3C8, 183
END IF
 
' Shift the color
OUT &H3C9, R
OUT &H3C9, G
OUT &H3C9, B

END SUB

SUB PCheckEgg

IF Map(Player.XPos, Player.YPos) = 2 THEN
    EggsFound = EggsFound + 1
    Map(Player.XPos, Player.YPos) = 0
END IF

IF TotalEggs = EggsFound THEN LoadNextLevel = TRUE

END SUB

SUB PInitVariables

GLoadAll

Player.XFin = 1 * 16
Player.YFin = 2 * 16
Player.XPos = 1
Player.YPos = 2
Player.XDir = 0
Player.YDir = 0
Player.Moving = FALSE
Player.Frame = 3

EggsFound = 0
Level = Level + 1
TotalEggs = 0

GLoadMap ("level1")

END SUB

SUB PPlayerInput


IF GetKey(72) AND Player.Moving = FALSE THEN       ' Check if key was pressed and you are not moving already
    IF Map(Player.XPos, Player.YPos - 1) < 3 THEN  ' Check if its ok to move there
        Player.YPos = Player.YPos - 1              ' Direction you are about to move to
        Player.YDir = -1                           ' Direction you are moving
        Player.Moving = TRUE                       ' Set flag to TRUE
        Player.Frame = 0                           ' Frame to put is 0
    END IF
END IF

IF GetKey(80) AND Player.Moving = FALSE THEN
    IF Map(Player.XPos, Player.YPos + 1) < 3 THEN
        Player.YPos = Player.YPos + 1
        Player.YDir = 1
        Player.Moving = TRUE
        Player.Frame = 0
    END IF
END IF

IF GetKey(75) AND Player.Moving = FALSE THEN
    IF Map(Player.XPos - 1, Player.YPos) < 3 THEN
        Player.XPos = Player.XPos - 1
        Player.XDir = -1
        Player.Moving = TRUE
        Player.Frame = 0
    END IF
END IF

IF GetKey(77) AND Player.Moving = FALSE THEN
    IF Map(Player.XPos + 1, Player.YPos) < 3 THEN
        Player.XPos = Player.XPos + 1
        Player.XDir = 1
        Player.Moving = TRUE
        Player.Frame = 0
    END IF
END IF

END SUB

SUB PPlayerMove

                                                          
IF Player.Moving THEN
    Player.XFin = Player.XFin + Player.XDir               ' Move the player in the X and Y direction
    Player.YFin = Player.YFin + Player.YDir

    IF Player.XDir THEN
        IF Player.XFin MOD 16 = 0 THEN
            Player.Frame = Player.XDir + Player.XDir      ' Save the direction you are going, it ill be either -2 or 2
            Player.XDir = 0                               ' If you are in the X or Y
            Player.Moving = FALSE                         ' direction then check to
        END IF                                            ' see if you have reached
    ELSEIF Player.YDir THEN                               ' your destination
        IF Player.YFin MOD 16 = 0 THEN
            Player.Frame = Player.YDir + Player.YDir + 1  ' Save direction, it will be either -1 or 3
            Player.YDir = 0
            Player.Moving = FALSE
        END IF
    END IF
END IF

END SUB

SUB WaitVr (TimeToKill%)

FOR I = 0 TO TimeToKill%
    WAIT &H3DA, 8
    WAIT &H3DA, 8, 8
NEXT I

END SUB

SUB WinImage

GLoadSprite "winbit.mmg", VScreen()
GLoadPalette "winPal.mmp"
KeyBoardOff


PUT (0, 0), VScreen, PSET
DO: LOOP UNTIL INKEY$ <> ""

KeyBoardOn
GClearVScreen

Level = 0

END SUB

