'- Unofficial Tornament Engine v1.1
'- March 2001 - Created by Joe King

                  '- declare subs
                    DECLARE FUNCTION Keyboard% (t%)
                    DECLARE SUB GetData ()
                    DECLARE SUB SendData ()
                    DECLARE SUB CheckKills ()
                    DECLARE SUB MovePlayer (i AS INTEGER)
                    DECLARE SUB PutUpExplode ()
                    DECLARE SUB MakeExplosion (x AS INTEGER, y AS INTEGER, radius AS INTEGER, p AS INTEGER, position AS INTEGER, explodepasswalls AS INTEGER)
                    DECLARE SUB MoveBullets ()
                    DECLARE SUB FireBullet (i AS INTEGER)
                    DECLARE SUB PageCopy (s1 AS INTEGER, s2 AS INTEGER)
                    DECLARE SUB GetAsm ()
                    DECLARE SUB CheckAnimations ()
                    DECLARE SUB Delay (n AS SINGLE)
                    DECLARE SUB battle ()
                    DECLARE SUB RandomPut ()
                    DECLARE SUB CompileDeltaData ()
                    DECLARE SUB LoadDeltaData ()
                    DECLARE SUB PutUpMap ()
                    DECLARE SUB LoadMap (FileName AS STRING)
                    DECLARE SUB LoadSprite (FileName AS STRING, sp AS INTEGER)
                    DECLARE SUB LoadPalette ()
                               
                                      '$DYNAMIC
                                      '- declare data types
                                        TYPE ExplodeType
                                          x AS INTEGER
                                          y AS INTEGER
                                          t AS INTEGER
                                          p AS INTEGER
                                        END TYPE
                                        TYPE BulletType
                                          x AS INTEGER
                                          y AS INTEGER
                                          position AS INTEGER
                                          spread AS INTEGER
                                        END TYPE
                                        TYPE WeaponType
                                          Power AS INTEGER
                                          Delay AS INTEGER
                                          explode AS INTEGER
                                          radius AS INTEGER
                                          pass AS INTEGER
                                          freeze AS INTEGER
                                          rotate AS INTEGER
                                          drunk AS INTEGER
                                          spread AS INTEGER
                                        END TYPE
                                        TYPE person
                                          FName AS STRING * 20
                                          WeaponName AS STRING * 40
                                          life AS INTEGER
                                          x AS INTEGER
                                          y AS INTEGER
                                          ox AS INTEGER
                                          oy AS INTEGER
                                          d AS INTEGER
                                          od AS INTEGER
                                          t AS INTEGER
                                          speed AS INTEGER
                                          position AS INTEGER
                                          animation AS INTEGER
                                          weapon AS WeaponType
                                          ammo AS INTEGER
                                          Kills AS INTEGER
                                          almostkills AS INTEGER
                                          frozentime AS INTEGER
                                        END TYPE

                                      '- declare constants
                                        CONST TILE = 0
                                        CONST EPS = 52
                                        CONST RIGHT = 0
                                        CONST LEFT = 7
                                        CONST DOWN = 14
                                        CONST UP = 19
                                        CONST DEAD = 23
                                        CONST FROZEN = 35

                                      '- declare variables
                                        DIM SHARED MaxPlayers AS INTEGER
                                        DIM SHARED TileSetFile AS STRING
                                        DIM SHARED DataString AS STRING
                                        DIM SHARED FileLength AS INTEGER
                                        DIM SHARED PlayerOne AS INTEGER
                                        DIM SHARED PlayerTwo AS INTEGER
                                        DIM SHARED ExplodeTile1 AS INTEGER
                                        DIM SHARED ExplodeTile2 AS INTEGER
                                        DIM SHARED ExplodeNumber AS INTEGER
                                        DIM SHARED MapFile AS STRING
                                        DIM SHARED Flicker AS INTEGER
                                        DIM SHARED Flicker2 AS INTEGER
                                        DIM SHARED MultiPlayer AS INTEGER
                                        DIM SHARED Master AS INTEGER
                                        DIM SHARED ComPort AS INTEGER
                                        DIM i AS INTEGER
                                        DIM SHARED DeadPlay AS INTEGER
                                        DIM SHARED fullcopy$
                                        DIM SHARED putt$
                                        DIM SHARED WaterNumber
                                        DIM SHARED BloodGore AS INTEGER
                                        DIM SHARED Difficulty AS INTEGER
                                        DIM SHARED TimeLimit AS INTEGER
                                        DIM SHARED TookGame AS INTEGER
                                        DIM SHARED FireAllFour AS INTEGER
                                        DIM SHARED UnFairFire AS INTEGER
                                        DIM SHARED CoOp AS INTEGER
                                        DIM SHARED GrassDirt AS INTEGER
                                        DIM SHARED PopUps AS INTEGER
                                        DIM SHARED BonusX AS INTEGER, BonusY AS INTEGER
                                        DIM SHARED BonusI AS INTEGER, BonusT AS INTEGER
                                        DIM SHARED GameSpeed AS INTEGER

                                      '- declare array variables
                                        DIM SHARED Map(33, 21) AS INTEGER
                                        DIM SHARED WaterX(640) AS INTEGER
                                        DIM SHARED WaterY(640) AS INTEGER
                                        DIM SHARED Page1(32000) AS INTEGER
                                        DIM SHARED Page2(32000) AS INTEGER
                                        DIM SHARED Explosion(2000) AS ExplodeType
                                       
  '- startup
    '- clear num lock, caps lock,  etc.
      DEF SEG = 0
        POKE (&H417), 0
      DEF SEG
    RANDOMIZE TIMER
    Flicker = 50
    LoadDeltaData

                                      '- declare more variables
                                        DIM SHARED Sprite(2080, MaxPlayers) AS INTEGER
                                        DIM SHARED Player(MaxPlayers) AS person
                                        DIM SHARED SpriteFile(MaxPlayers) AS STRING
                                        DIM SHARED NumBullets(MaxPlayers) AS INTEGER
                                        DIM SHARED BulletSpeed(MaxPlayers) AS INTEGER
                                        DIM SHARED Bullet(640, MaxPlayers) AS BulletType
                                        DIM SHARED BulletDelay(MaxPlayers) AS INTEGER
                                        DIM SHARED add(MaxPlayers) AS INTEGER
                                        DIM SHARED Kills(MaxPlayers, MaxPlayers) AS INTEGER
                                        DIM SHARED pd(MaxPlayers) AS INTEGER
                                        DIM SHARED tp(MaxPlayers) AS INTEGER
                                        DIM SHARED FB(MaxPlayers) AS INTEGER
                                        DIM SHARED DeadPlay(MaxPlayers) AS INTEGER
                             
    CompileDeltaData

  
  '- load the sprites
    LoadSprite TileSetFile, TILE
    FOR i = 1 TO MaxPlayers
      LoadSprite SpriteFile(i), i
      Player(i).ammo = 1
      add(i) = 1
    NEXT i
    'DeadPlay = 1
    GetAsm

    SCREEN 13
   
  '- load the palette
    LoadPalette
  
  '- load the map
   
    LoadMap MapFile
    PutUpMap

  '- randomly put up players
    RandomPut
   
  '- battle
    IF MultiPlayer = 1 THEN
      IF ComPort = 1 THEN OPEN "COM1: 9600,,,,CD6000" FOR RANDOM AS #2
      IF ComPort = 2 THEN OPEN "COM2: 9600,,,,CD6000" FOR RANDOM AS #2
      IF ComPort = 3 THEN OPEN "COM3: 9600,,,,CD6000" FOR RANDOM AS #2
      IF ComPort = 4 THEN OPEN "COM4: 9600,,,,CD6000" FOR RANDOM AS #2
      Flicker2 = 50
    END IF
    IF TookGame = 1 THEN Flicker2 = 50
    TIMER ON
    battle

EndGame:
CLOSE #2
Nil% = Keyboard(-2)
OPEN "UT2.DAT" FOR OUTPUT AS #1
  FOR i = 1 TO MaxPlayers
    WRITE #1, Player(i).Kills
  NEXT i
CLOSE #1
END

REM $STATIC
SUB battle

                                        '- declare variables
                                          DIM ky AS INTEGER
                                          DIM ox AS INTEGER
                                          DIM oy AS INTEGER
                                          DIM i AS INTEGER
                                          DIM n AS INTEGER
                                          DIM t AS INTEGER
                                          DIM e AS INTEGER
                                          DIM x AS INTEGER
                                          DIM y AS INTEGER
                                          DIM inv AS INTEGER
                                          DIM op AS INTEGER
                                          DIM pa AS INTEGER
                                          DIM StopAnimation AS INTEGER
                                          STATIC WaterTimer AS INTEGER
                                          STATIC WaterT AS INTEGER
                                         
  '- battle
    Nil% = Keyboard(-1)
    ON TIMER(TimeLimit) GOSUB EndGame

    DO
      WaterT = WaterT + 1
      IF WaterT > 2 THEN WaterT = 0: WaterTimer = WaterTimer + 1
      IF WaterTimer > 2 THEN WaterTimer = 0
      FOR i = 1 TO WaterNumber
        offset% = SADD(putt$)
        DEF SEG = VARSEG(putt$)
          CALL ABSOLUTE(WaterX(i) + 1, WaterY(i) + 1, VARSEG(Sprite(EPS * (24 + WaterTimer), TILE)), VARPTR(Sprite(EPS * (24 + WaterTimer), TILE)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
        DEF SEG
      NEXT i
      PageCopy 2, 1
      IF BonusI > 0 AND BonusT > 0 THEN
        offset% = SADD(putt$)
        DEF SEG = VARSEG(putt$)
          CALL ABSOLUTE(BonusX, BonusY, VARSEG(Sprite(EPS * BonusI, TILE)), VARPTR(Sprite(EPS * BonusI, TILE)), VARSEG(Page1(0)), VARPTR(Page1(0)), offset%)
        DEF SEG
        BonusT = BonusT - 1
      END IF
      PutUpExplode
      StopAnimation = 1
      FOR i = 1 TO MaxPlayers
        Player(i).ox = Player(i).x
        Player(i).oy = Player(i).y
        IF DeadPlay(i) = 0 THEN
          IF Flicker <> 0 AND i = PlayerOne THEN
            inv = i
          ELSEIF Flicker2 > 0 AND i = PlayerTwo AND TookGame = 1 THEN
            inv = i
          ELSE
            inv = 0
          END IF
          IF Player(i).ammo = 0 THEN BulletDelay(i) = BulletDelay(i) + 1
          IF BulletDelay(i) > Player(i).weapon.Delay THEN
            IF Player(i).ammo <> -1 THEN Player(i).ammo = 1
            BulletDelay(i) = 0
          END IF
          '- put the player on the screen
            'PUT (Player(i).x, Player(i).y), Sprite(EPS * (Player(i).position + Player(i).animation), i), PSET
            offset% = SADD(putt$)
            DEF SEG = VARSEG(putt$)
              CALL ABSOLUTE(Player(i).x, Player(i).y, VARSEG(Sprite(EPS * (Player(i).position + Player(i).animation), i)), VARPTR(Sprite(EPS * (Player(i).position + Player(i).animation), i)), VARSEG(Page1(0)), VARPTR(Page1(0)), offset%)
            DEF SEG
            ox = Player(i).x: oy = Player(i).y
          '- if player one is that player check if a key is pressed
            IF PlayerOne = i AND Player(i).position <> DEAD AND Player(i).position < FROZEN THEN
              IF Keyboard(77) THEN
                Player(i).x = Player(i).x + Player(i).speed
                Player(i).position = RIGHT
                Player(i).animation = Player(i).animation + 1
                StopAnimation = 0
              END IF
              IF Keyboard(75) THEN
                Player(i).x = Player(i).x - Player(i).speed
                Player(i).position = LEFT
                Player(i).animation = Player(i).animation + 1
                StopAnimation = 0
              END IF
            '- check if a player hit a wall
              FOR y = 10 TO 19 STEP 9
                FOR x = 10 TO 19 STEP 9
                  IF Map((Player(i).x + x) \ 10, (Player(i).y + y) \ 10) THEN
                    Player(i).x = ox
                    Player(i).y = oy
                    Player(i).t = 0
                  END IF
                NEXT x
              NEXT y
              ox = Player(i).x
              oy = Player(i).y
              IF Keyboard(80) THEN
                Player(i).y = Player(i).y + Player(i).speed
                Player(i).position = DOWN
                IF StopAnimation = 1 THEN Player(i).animation = Player(i).animation + 1
                StopAnimation = 0
              END IF
              IF Keyboard(72) THEN
                Player(i).y = Player(i).y - Player(i).speed
                Player(i).position = UP
                IF StopAnimation = 1 THEN Player(i).animation = Player(i).animation + 1
                StopAnimation = 0
              END IF
              IF Keyboard(&H39) THEN
                IF FireAllFour = 0 THEN FireBullet (i)
                IF FireAllFour = 1 AND Player(i).ammo <> 0 THEN
                  op = Player(i).position
                  IF Player(i).ammo = 1 THEN pa = 1
                  Player(i).position = RIGHT
                  FireBullet i
                  Player(i).ammo = 1
                  Player(i).position = LEFT
                  FireBullet i
                  Player(i).ammo = 1
                  Player(i).position = DOWN
                  FireBullet i
                  Player(i).ammo = 1
                  Player(i).position = UP
                  FireBullet i
                  Player(i).position = op
                  IF pa = 1 THEN pa = 0: Player(i).ammo = -1
                END IF
              END IF
              IF Keyboard(&H1D) THEN
                IF FireAllFour = 0 THEN FireBullet (i)
                IF FireAllFour = 1 AND Player(i).ammo <> 0 THEN
                  op = Player(i).position
                  IF Player(i).ammo = -1 THEN pa = 1
                  Player(i).position = RIGHT
                  FireBullet i
                  Player(i).ammo = 1
                  Player(i).position = LEFT
                  FireBullet i
                  Player(i).ammo = 1
                  Player(i).position = DOWN
                  FireBullet i
                  Player(i).ammo = 1
                  Player(i).position = UP
                  FireBullet i
                  Player(i).position = op
                  IF pa = 1 THEN pa = 1: Player(i).ammo = -1
                END IF
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H17) THEN
                Flicker = -1
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H21) THEN
                Player(i).ammo = -1
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H1E) THEN
                FireAllFour = 1
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) THEN
                IF MaxPlayers > 0 AND Keyboard(&H2) THEN Player(1).position = DEAD: Kills(1, i) = 1
                IF MaxPlayers > 1 AND Keyboard(&H3) THEN Player(2).position = DEAD: Kills(2, i) = 1
                IF MaxPlayers > 2 AND Keyboard(&H4) THEN Player(3).position = DEAD: Kills(3, i) = 1
                IF MaxPlayers > 3 AND Keyboard(&H5) THEN Player(4).position = DEAD: Kills(4, i) = 1
                IF MaxPlayers > 4 AND Keyboard(&H6) THEN Player(5).position = DEAD: Kills(5, i) = 1
                IF MaxPlayers > 5 AND Keyboard(&H7) THEN Player(6).position = DEAD: Kills(6, i) = 1
                IF MaxPlayers > 6 AND Keyboard(&H8) THEN Player(7).position = DEAD: Kills(7, i) = 1
                IF MaxPlayers > 7 AND Keyboard(&H9) THEN Player(8).position = DEAD: Kills(8, i) = 1
                IF MaxPlayers > 8 AND Keyboard(&HA) THEN Player(9).position = DEAD: Kills(9, i) = 1
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H12) THEN
                Player(i).weapon.explode = Player(i).weapon.explode + 1
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H1F) THEN
                IF Player(i).speed = 5 THEN Player(i).speed = 10
                IF Player(i).speed = 2 THEN Player(i).speed = 5
                IF Player(i).speed = 1 THEN Player(i).speed = 2
                Player(i).x = (Player(i).x \ 10) * 10
                Player(i).y = (Player(i).y \ 10) * 10
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H30) THEN
                IF BulletSpeed(i) = 5 THEN BulletSpeed(i) = 10
                IF BulletSpeed(i) = 2 THEN BulletSpeed(i) = 5
                IF BulletSpeed(i) = 1 THEN BulletSpeed(i) = 2
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H2D) THEN
                Player(i).weapon.pass = 1
              END IF
              IF MultiPlayer = 0 AND TookGame = 0 AND Keyboard(&H16) AND Keyboard(&H14) AND Keyboard(&H32) THEN
                FOR op = 1 TO MaxPlayers
                  IF op <> i THEN Player(op).position = DEAD
                  IF op <> i THEN Kills(1, op) = 1
                NEXT op
              END IF
              DO
              LOOP UNTIL INKEY$ = ""
            END IF
            IF PlayerTwo = i AND TookGame = 1 AND Player(i).position <> DEAD AND Player(i).position < FROZEN THEN
              IF Keyboard(&H20) THEN
                Player(i).x = Player(i).x + Player(i).speed
                Player(i).position = RIGHT
                Player(i).animation = Player(i).animation + 1
              END IF
              IF Keyboard(&H1E) THEN
                Player(i).x = Player(i).x - Player(i).speed
                Player(i).position = LEFT
                Player(i).animation = Player(i).animation + 1
              END IF
            '- check if a player hit a wall
              FOR y = 10 TO 19 STEP 9
                FOR x = 10 TO 19 STEP 9
                  IF Map((Player(i).x + x) \ 10, (Player(i).y + y) \ 10) THEN
                    Player(i).x = ox
                    Player(i).y = oy
                    Player(i).t = 0
                  END IF
                NEXT x
              NEXT y
              ox = Player(i).x
              oy = Player(i).y
              IF Keyboard(&H1F) THEN
                Player(i).y = Player(i).y + Player(i).speed
                Player(i).position = DOWN
                Player(i).animation = Player(i).animation + 1
              END IF
              IF Keyboard(&H11) THEN
                Player(i).y = Player(i).y - Player(i).speed
                Player(i).position = UP
                Player(i).animation = Player(i).animation + 1
              END IF
              IF Keyboard(&HF) THEN FireBullet (i)
              IF Keyboard(&H21) THEN FireBullet (i)
              DO
              LOOP UNTIL INKEY$ = ""
            END IF
          IF StopAnimation = 2 THEN StopAnimation = 0
          IF Keyboard(1) THEN Nil% = Keyboard(-2): EXIT SUB
          IF Keyboard(&H19) THEN
            Delay .01
            LOCATE 10, 18: COLOR 136
            PRINT "P"; : COLOR 137: PRINT "A"; : COLOR 138: PRINT "U"; : COLOR 139: PRINT "S";
            COLOR 140: PRINT "E"; : COLOR 141: PRINT "D"
            DO
              IF Keyboard(&H19) THEN EXIT DO
            LOOP
            Delay .01
          END IF
          IF StopAnimation = 1 AND Player(i).position <> DEAD THEN
            StopAnimation = 0
            Player(i).animation = 0
          END IF
          IF PlayerOne <> i THEN MovePlayer (i)
          IF PlayerOne = i AND Player(i).position = DEAD THEN Player(i).animation = Player(i).animation + add(i)
          IF PlayerTwo = i AND TookGame = 1 AND Player(i).position = DEAD THEN Player(i).animation = Player(i).animation + add(i)
          '- check if a player hit a wall
            FOR y = 10 TO 19 STEP 9
              FOR x = 10 TO 19 STEP 9
                IF Map((Player(i).x + x) \ 10, (Player(i).y + y) \ 10) THEN
                  Player(i).x = ox
                  Player(i).y = oy
                  Player(i).t = 0
                END IF
              NEXT x
            NEXT y
            FOR y = 1 TO 10 STEP 5
              FOR x = 1 TO 10 STEP 5
                IF POINT(Player(i).x + x, Player(i).y + y) = 90 OR POINT(Player(i).x + x, Player(i).y + y) = 92 THEN
                  IF inv <> i THEN
                    IF Player(i).position <> DEAD THEN Player(i).animation = 1
                    Player(i).position = DEAD
                    FOR t = 1 TO ExplodeNumber
                      IF (Player(i).x + x) \ 10 = Explosion(t).x \ 10 AND (Player(i).y + y) \ 10 = Explosion(t).y \ 10 THEN
                        e = Explosion(t).p
                        Kills(i, e) = 1
                      END IF
                    NEXT t
                  END IF
                END IF
                IF BonusI > 0 AND BonusT > 0 AND i = PlayerOne THEN
                  IF (Player(i).x + x) \ 10 = BonusX \ 10 AND (Player(i).y + y) \ 10 = BonusY \ 10 THEN
                    IF BonusI = 32 THEN Player(i).ammo = -1
                    IF BonusI = 33 THEN Flicker = 200
                    IF BonusI = 34 THEN FireAllFour = 1
                    IF BonusI = 35 THEN
                      FOR op = 1 TO MaxPlayers
                        IF op <> i THEN Player(op).position = DEAD
                        IF op <> i THEN Kills(1, op) = 1
                      NEXT op
                    END IF
                    BonusT = 0
                  END IF
                END IF
              NEXT x
            NEXT y
        END IF
      NEXT i
      '- check if to reset animations
        CheckAnimations
      CheckKills
      MoveBullets
      PageCopy 1, 0
      IF Flicker <> 0 THEN
        LINE (Player(PlayerOne).ox + (Flicker MOD 5), Player(PlayerOne).oy + (Flicker MOD 5))-(Player(PlayerOne).ox + 9 - (Flicker MOD 5), Player(PlayerOne).oy + 9 - (Flicker MOD 5)), 140, B
        LINE (Player(PlayerOne).ox + (Flicker MOD 5) - 2, Player(PlayerOne).oy + (Flicker MOD 5) - 2)-(Player(PlayerOne).ox + 9 - (Flicker MOD 5) + 2, Player(PlayerOne).oy + 9 - (Flicker MOD 5) + 2), 138, B
        LINE (Player(PlayerOne).ox + (Flicker MOD 5) - 4, Player(PlayerOne).oy + (Flicker MOD 5) - 4)-(Player(PlayerOne).ox + 9 - (Flicker MOD 5) + 4, Player(PlayerOne).oy + 9 - (Flicker MOD 5) + 4), 136, B
        IF Flicker > 0 THEN Flicker = Flicker - 1
      END IF
      IF Flicker2 > 0 THEN
        LINE (Player(PlayerTwo).ox + (Flicker2 MOD 5), Player(PlayerTwo).oy + (Flicker2 MOD 5))-(Player(PlayerTwo).ox + 9 - (Flicker2 MOD 5), Player(PlayerTwo).oy + 9 - (Flicker2 MOD 5)), 58, B
        LINE (Player(PlayerTwo).ox + (Flicker2 MOD 5) - 2, Player(PlayerTwo).oy + (Flicker2 MOD 5) - 2)-(Player(PlayerTwo).ox + 9 - (Flicker2 MOD 5) + 2, Player(PlayerTwo).oy + 9 - (Flicker2 MOD 5) + 2), 56, B
        LINE (Player(PlayerTwo).ox + (Flicker2 MOD 5) - 4, Player(PlayerTwo).oy + (Flicker2 MOD 5) - 4)-(Player(PlayerTwo).ox + 9 - (Flicker2 MOD 5) + 4, Player(PlayerTwo).oy + 9 - (Flicker2 MOD 5) + 4), 54, B
        Flicker2 = Flicker2 - 1
      END IF
      IF MultiPlayer = 0 OR TookGame = 1 THEN Delay .01
      IF MultiPlayer = 1 AND TookGame = 0 THEN
        IF Master THEN SendData ELSE GetData
      END IF
    LOOP

END SUB

SUB CheckAnimations

                                        '- declare variables
                                          DIM i AS INTEGER
                                          DIM x AS INTEGER
                                          DIM y AS INTEGER

  '- check animations to see if they need to be reset
    FOR i = 1 TO MaxPlayers
      IF DeadPlay(i) = 0 THEN
        IF Player(i).position = LEFT OR Player(i).position = RIGHT THEN
          IF Player(i).animation > 6 THEN Player(i).animation = 1
        ELSEIF Player(i).position = UP OR Player(i).position = DOWN THEN
          IF Player(i).animation > 4 THEN Player(i).animation = 1
        ELSEIF Player(i).position > FROZEN THEN
          Player(i).animation = 0
          Player(i).frozentime = Player(i).frozentime - 1
          IF Player(i).frozentime <= 0 THEN
            Player(i).position = DEAD
            Player(i).frozentime = -50
          END IF
        ELSEIF Player(i).position = DEAD THEN
          IF add(i) = 1 THEN
            IF Player(i).animation = 1 THEN
              IF i = PlayerOne THEN
                FireAllFour = 0
                Player(i).ammo = 0
              END IF
              IF BloodGore > 0 THEN
                offset% = SADD(putt$)
                DEF SEG = VARSEG(putt$)
                  CALL ABSOLUTE(Player(i).x, Player(i).y, VARSEG(Sprite(EPS * 27, TILE)), VARPTR(Sprite(EPS * 27, TILE)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
                DEF SEG
              END IF
              IF BloodGore > 2 THEN
                FOR j% = 1 TO 10
                  guts% = INT(4 * RND(1)) + 1
                  x = INT(20 * RND(1)) - 10
                  y = INT(20 * RND(1)) - 10
                  offset% = SADD(putt$)
                  DEF SEG = VARSEG(putt$)
                    CALL ABSOLUTE(Player(i).x + x, Player(i).y + y, VARSEG(Sprite(EPS * (27 + guts%), TILE)), VARPTR(Sprite(EPS * (27 + guts%), TILE)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
                  DEF SEG
                NEXT j%
              END IF
              IF BloodGore > 1 THEN
                FOR j% = 1 TO 3
                  guts% = INT(4 * RND(1)) + 1
                  x = INT(10 * RND(1)) - 5
                  y = INT(10 * RND(1)) - 5
                  offset% = SADD(putt$)
                  DEF SEG = VARSEG(putt$)
                    CALL ABSOLUTE(Player(i).x + x, Player(i).y + y, VARSEG(Sprite(EPS * (27 + guts%), TILE)), VARPTR(Sprite(EPS * (27 + guts%), TILE)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
                  DEF SEG
                NEXT j%
              END IF
              IF BloodGore > 3 THEN
                FOR j% = 1 TO 8
                  guts% = INT(4 * RND(1)) + 1
                  x = INT(20 * RND(1)) - 10
                  y = INT(20 * RND(1)) - 10
                  offset% = SADD(putt$)
                  DEF SEG = VARSEG(putt$)
                    CALL ABSOLUTE(Player(i).x + x, Player(i).y + y, VARSEG(Sprite(EPS * (27 + guts%), TILE)), VARPTR(Sprite(EPS * (27 + guts%), TILE)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
                  DEF SEG
                NEXT j%
              END IF
              IF BloodGore > 2 THEN
                guts% = INT(2 * RND(1)) + 1
                offset% = SADD(putt$)
                DEF SEG = VARSEG(putt$)
                  CALL ABSOLUTE(Player(i).x, Player(i).y, VARSEG(Sprite(EPS * (24 + guts%), i)), VARPTR(Sprite(EPS * (24 + guts%), i)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
                DEF SEG
              END IF
            END IF
          END IF
          IF Player(i).animation > 7 THEN
            IF DeadPlay = 1 THEN
              DeadPlay(i) = 1
              Player(i).x = 0
              Player(i).y = 0
            END IF
            add(i) = -1
            DO
              Player(i).x = INT(32 * RND(1)) + 1
              Player(i).y = INT(20 * RND(1)) + 1
            LOOP WHILE Map(Player(i).x, Player(i).y)
            Player(i).x = Player(i).x * 10 - 10
            Player(i).y = Player(i).y * 10 - 10
            IF CoOp = 1 AND i = PlayerOne THEN
              Player(i).x = (Player(PlayerTwo).x \ 10) * 10
              Player(i).y = (Player(PlayerTwo).y \ 10) * 10
            END IF
            IF CoOp = 1 AND i = PlayerTwo THEN
              Player(i).x = (Player(PlayerOne).x \ 10) * 10
              Player(i).y = (Player(PlayerOne).y \ 10) * 10
            END IF
          END IF
          IF Player(i).animation < 1 THEN
            add(i) = 1
            Player(i).animation = 0
            Player(i).position = DOWN
            IF PlayerOne = i THEN Player(i).ammo = 1: Flicker = 50
            IF PlayerTwo = i AND TookGame = 1 THEN Player(i).ammo = 1: Flicker2 = 50
            Player(i).frozentime = 0
            pd(i) = 0
            FOR y = 1 TO MaxPlayers
              FOR x = 1 TO MaxPlayers
                IF Kills(x, y) THEN
                  IF x = y THEN Player(y).Kills = Player(y).Kills - 1 ELSE Player(y).Kills = Player(y).Kills + 1
                  Kills(x, y) = 0
                END IF
              NEXT x
            NEXT y
          END IF
        END IF
      END IF
    NEXT i
    IF PopUps THEN
      i = INT(800 * RND(1)) + 1
      IF i = 1 AND BonusT = 0 THEN
        DO
          x = INT(32 * RND(1)) + 1
          y = INT(20 * RND(1)) + 1
          IF Map(x, y) = 0 THEN
            i = INT(4 * RND(1)) + 1
            BonusX = x * 10 - 10: BonusY = y * 10 - 10
            BonusI = 31 + i
            BonusT = 200
            EXIT DO
          END IF
        LOOP
      END IF
    END IF

END SUB

SUB CheckKills

                                        '- declare variables
                                          DIM i AS INTEGER

  '- check for kills
'    FOR i = 1 TO MaxPlayers
'      IF Player(i).kills >= 20 THEN
'        CLS
'        PRINT Player(i).FName + " WINS!!!"
'        PRINT Player(i).kills; " KILLS"
'        DO
'        LOOP UNTIL INKEY$ = CHR$(27)
'        END
'      END IF
'    NEXT i
END SUB

SUB CompileDeltaData

                                        '- declare variables
                                          DIM CheckString AS STRING
                                          DIM TempPlayerFName AS STRING
                                          DIM i AS INTEGER
                                          DIM n AS INTEGER
                                          DIM x AS INTEGER

  '- compile the rest of the UT.DAT file for player info
    FOR i = 1 TO FileLength

      '- check for []
        IF MID$(DataString, i, 1) = "[" THEN
          i = i + 1
          x = INSTR(i, DataString, ".")
          CheckString = MID$(DataString, i, x - i)

          FOR x = 1 TO MaxPlayers
            IF UCASE$(CheckString) + STRING$(20 - (INSTR(1, Player(x).FName, " ") - 1), " ") = Player(x).FName THEN
              i = i + LEN(LEFT$(Player(x).FName, INSTR(1, Player(x).FName, " ")))
              n = INSTR(i, DataString, "=")
              CheckString = MID$(DataString, i, n - i)

              '- check if it's a sprite file
                IF UCASE$(CheckString) = "SPRITEFILE" THEN
                  i = i + LEN(CheckString) + 1
                  n = INSTR(i, DataString, "]")
                  CheckString = MID$(DataString, i, n - i)
                  SpriteFile(x) = CheckString
                END IF
              
              '- check if it's speed
                IF UCASE$(CheckString) = "SPEED" THEN
                  i = i + LEN(CheckString) + 1
                  n = INSTR(i, DataString, "]")
                  CheckString = MID$(DataString, i, n - i)
                  Player(x).speed = VAL(CheckString)
                END IF

              '- check if it's life
                IF UCASE$(CheckString) = "LIFE" THEN
                  i = i + LEN(CheckString) + 1
                  n = INSTR(i, DataString, "]")
                  CheckString = MID$(DataString, i, n - i)
                  Player(x).life = VAL(CheckString)
                END IF

              '- check if it's weapon FName
                IF UCASE$(CheckString) = "WEAPONNAME" THEN
                  i = i + LEN(CheckString) + 1
                  n = INSTR(i, DataString, "]")
                  CheckString = MID$(DataString, i, n - i)
                  Player(x).WeaponName = CheckString
                END IF
            
              '- check if it's weapon data
                IF UCASE$(CheckString) = "WEAPONDATA" THEN
                  i = i + LEN(CheckString) + 1
                  n = INSTR(i, DataString, ":")
                  CheckString = MID$(DataString, i, n - i)
                  
                  '- check what weapon data it is
                    IF UCASE$(CheckString) = "POWER" THEN
                      i = i + 6
                      n = INSTR(i, DataString, "]")
                      CheckString = MID$(DataString, i, n - i)
                      Player(x).weapon.Power = VAL(CheckString)
                    END IF

                    IF UCASE$(CheckString) = "DELAY" THEN
                      i = i + 6
                      n = INSTR(i, DataString, "]")
                      CheckString = MID$(DataString, i, n - i)
                      Player(x).weapon.Delay = VAL(CheckString)
                    END IF

                    IF UCASE$(CheckString) = "EXPLODE" THEN
                      i = i + 8
                      n = INSTR(i, DataString, "]")
                      CheckString = MID$(DataString, i, n - i)
                      Player(x).weapon.explode = VAL(CheckString)
                    END IF
                   
                    IF UCASE$(CheckString) = "EXPLODEPASSWALLS" THEN
                      Player(x).weapon.pass = 1
                    END IF

                    IF UCASE$(CheckString) = "FREEZE" THEN
                      Player(x).weapon.freeze = 1
                    END IF

                    IF UCASE$(CheckString) = "SPEED" THEN
                      i = i + 6
                      n = INSTR(i, DataString, "]")
                      CheckString = MID$(DataString, i, n - i)
                      BulletSpeed(x) = VAL(CheckString)
                    END IF

                    IF UCASE$(CheckString) = "DRUNK" THEN
                      i = i + 6
                      n = INSTR(i, DataString, "]")
                      CheckString = MID$(DataString, i, n - i)
                      Player(x).weapon.drunk = VAL(CheckString)
                    END IF

                    IF UCASE$(CheckString) = "SPREAD" THEN
                      i = i + 7
                      n = INSTR(i, DataString, "]")
                      CheckString = MID$(DataString, i, n - i)
                      Player(x).weapon.spread = VAL(CheckString)
                    END IF

                    IF UCASE$(CheckString) = "ROTATE" THEN
                      Player(x).weapon.rotate = 1
                    END IF
               
                END IF

            END IF
          NEXT x

          IF UCASE$(CheckString) = "PLAYER" THEN
            i = i + 7
            x = INSTR(i, DataString, "=")
            TempPlayerFName = MID$(DataString, i, x - i)
            i = i + LEN(TempPlayerFName) + 1
            x = INSTR(i, DataString, "]")
            x = VAL(MID$(DataString, i, x - i))
            Player(x).FName = UCASE$(TempPlayerFName)
          END IF
        
        END IF

    NEXT i

END SUB

SUB Delay (n AS SINGLE)

                                        '- declare variables
                                          DIM t AS SINGLE

  '- delay
    SELECT CASE GameSpeed
      CASE 0
        t = TIMER
        DO
        LOOP UNTIL TIMER > t + n
      CASE 1
        WAIT &H3DA, 8: WAIT &H3DA, 8, 8
        WAIT &H3DA, 8: WAIT &H3DA, 8, 8
      CASE 2
        WAIT &H3DA, 8: WAIT &H3DA, 8, 8
    END SELECT

END SUB

SUB FireBullet (i AS INTEGER)

                                        '- declare variables
                                          DIM x AS INTEGER, y AS INTEGER
                                          DIM n AS INTEGER, t AS INTEGER

  '- fire a bullet
  '- NOTE: bullet can be anything: missile, water, etc.
    '- put a bullet into the array
      IF Player(i).weapon.drunk THEN t = Player(i).weapon.drunk
      IF Player(i).weapon.spread THEN t = Player(i).weapon.spread
      IF TookGame = 0 THEN
        IF Player(i).ammo <> 0 OR i = PlayerTwo THEN
          DO
            NumBullets(i) = NumBullets(i) + 1
            IF NumBullets(i) > 498 THEN EXIT SUB
            Bullet(NumBullets(i), i).position = Player(i).position
            Bullet(NumBullets(i), i).x = Player(i).x
            Bullet(NumBullets(i), i).y = Player(i).y
            Bullet(NumBullets(i), i).spread = 0
            BulletDelay(i) = 0
            FB(i) = 1
            IF Player(i).weapon.spread > 0 AND n = 0 THEN Bullet(NumBullets(i), i).spread = -1
            IF Player(i).weapon.spread > 0 AND n = 1 THEN Bullet(NumBullets(i), i).spread = 1
            n = n + 1
          LOOP WHILE n < t
          Player(i).ammo = Player(i).ammo - 1
        END IF
      ELSEIF TookGame = 1 THEN
        IF Player(i).ammo <> 0 THEN
          DO
            NumBullets(i) = NumBullets(i) + 1
            IF NumBullets(i) > 498 THEN EXIT SUB
            Bullet(NumBullets(i), i).position = Player(i).position
            Bullet(NumBullets(i), i).x = Player(i).x
            Bullet(NumBullets(i), i).y = Player(i).y
            Bullet(NumBullets(i), i).spread = 0
            BulletDelay(i) = 0
            FB(i) = 1
            IF Player(i).weapon.spread > 0 AND n = 0 THEN Bullet(NumBullets(i), i).spread = -1
            IF Player(i).weapon.spread > 0 AND n = 1 THEN Bullet(NumBullets(i), i).spread = 1
            n = n + 1
          LOOP WHILE n < t
          Player(i).ammo = Player(i).ammo - 1
        END IF
      END IF
END SUB

SUB GetAsm

' ------ Created with Absolute Assembly 2.1 by Petter Holmberg, -97. ------- '

fullcopy$ = ""
fullcopy$ = fullcopy$ + CHR$(&H55)                          ' PUSH BP
fullcopy$ = fullcopy$ + CHR$(&H89) + CHR$(&HE5)             ' MOV BP,SP
fullcopy$ = fullcopy$ + CHR$(&H1E)                          ' PUSH DS
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) ' MOV BX,[BP+06]
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H1F)             ' MOV BX,[BX]
fullcopy$ = fullcopy$ + CHR$(&H89) + CHR$(&HDF)             ' MOV DI,BX
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) ' MOV BX,[BP+08]
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H1F)             ' MOV BX,[BX]
fullcopy$ = fullcopy$ + CHR$(&H8E) + CHR$(&HC3)             ' MOV ES,BX
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) ' MOV BX,[BP+0A]
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H1F)             ' MOV BX,[BX]
fullcopy$ = fullcopy$ + CHR$(&H89) + CHR$(&HDE)             ' MOV SI,BX
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC) ' MOV BX,[BP+0C]
fullcopy$ = fullcopy$ + CHR$(&H8B) + CHR$(&H1F)             ' MOV BX,[BX]
fullcopy$ = fullcopy$ + CHR$(&H8E) + CHR$(&HDB)             ' MOV DS,BX
fullcopy$ = fullcopy$ + CHR$(&HB9) + CHR$(&H0) + CHR$(&H7D) ' MOV CX,7D00
fullcopy$ = fullcopy$ + CHR$(&HF3)                          ' REPZ
fullcopy$ = fullcopy$ + CHR$(&HA5)                          ' MOVSW
fullcopy$ = fullcopy$ + CHR$(&H1F)                          ' POP DS
fullcopy$ = fullcopy$ + CHR$(&H5D)                          ' POP BP
fullcopy$ = fullcopy$ + CHR$(&HCA) + CHR$(&H8) + CHR$(&H0)  ' RETF 0008

'offset% = SADD(fullcopy$)
'DEF SEG = VARSEG(fullcopy$)
'CALL ABSOLUTE(offset%)
'DEF SEG

' ------ Created with Absolute Assembly 2.1 by Petter Holmberg, -97. ------- '

' ------ Created with Absolute Assembly 2.1 by Petter Holmberg, -97. ------- '

putt$ = ""
putt$ = putt$ + CHR$(&H55)                                       ' PUSH BP
putt$ = putt$ + CHR$(&H89) + CHR$(&HE5)                          ' MOV BP,SP
putt$ = putt$ + CHR$(&H1E)                                       ' PUSH DS
putt$ = putt$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)              ' MOV BX,[BP+06]
putt$ = putt$ + CHR$(&H8B) + CHR$(&H1F)                          ' MOV BX,[BX]
putt$ = putt$ + CHR$(&H89) + CHR$(&HDF)                          ' MOV DI,BX
putt$ = putt$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)              ' MOV BX,[BP+08]
putt$ = putt$ + CHR$(&H8B) + CHR$(&H1F)                          ' MOV BX,[BX]
putt$ = putt$ + CHR$(&H8E) + CHR$(&HC3)                          ' MOV ES,BX
putt$ = putt$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)              ' MOV BX,[BP+0E]
putt$ = putt$ + CHR$(&H8B) + CHR$(&HF)                           ' MOV CX,[BX]
putt$ = putt$ + CHR$(&H81) + CHR$(&HC7) + CHR$(&H40) + CHR$(&H1) ' Y: ADD DI,0140
putt$ = putt$ + CHR$(&HE2) + CHR$(&HFA)                          ' LOOP Y
putt$ = putt$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)             ' MOV BX,[BP+10]
putt$ = putt$ + CHR$(&H8B) + CHR$(&HF)                           ' MOV CX,[BX]
putt$ = putt$ + CHR$(&H1) + CHR$(&HCF)                           ' ADD DI,CX
putt$ = putt$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)              ' MOV BX,[BP+0A]
putt$ = putt$ + CHR$(&H8B) + CHR$(&H1F)                          ' MOV BX,[BX]
putt$ = putt$ + CHR$(&H89) + CHR$(&HDE)                          ' MOV SI,BX
putt$ = putt$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)              ' MOV BX,[BP+0C]
putt$ = putt$ + CHR$(&H8B) + CHR$(&H1F)                          ' MOV BX,[BX]
putt$ = putt$ + CHR$(&H8E) + CHR$(&HDB)                          ' MOV DS,BX
putt$ = putt$ + CHR$(&HAD)                                       ' LODSW
putt$ = putt$ + CHR$(&HB1) + CHR$(&H8)                           ' MOV CL,08
putt$ = putt$ + CHR$(&HF6) + CHR$(&HF1)                          ' DIV CL
putt$ = putt$ + CHR$(&H31) + CHR$(&HD2)                          ' XOR DX,DX
putt$ = putt$ + CHR$(&H88) + CHR$(&HC2)                          ' MOV DL,AL
putt$ = putt$ + CHR$(&HAD)                                       ' LODSW
putt$ = putt$ + CHR$(&H88) + CHR$(&HC6)                          ' MOV DH,AL
putt$ = putt$ + CHR$(&H31) + CHR$(&HC9)                          ' XOR CX,CX
putt$ = putt$ + CHR$(&H31) + CHR$(&HDB)                          ' XOR BX,BX
putt$ = putt$ + CHR$(&HAC)                                       ' Start: LODSB
putt$ = putt$ + CHR$(&H3C) + CHR$(&H0)                           ' CMP AL,00
putt$ = putt$ + CHR$(&H74) + CHR$(&H9)                           ' JZ Skippixel
putt$ = putt$ + CHR$(&HAA)                                       ' STOSB
putt$ = putt$ + CHR$(&HFE) + CHR$(&HC1)                          ' INC CL
putt$ = putt$ + CHR$(&H38) + CHR$(&HD1)                          ' Back1: CMP CL,DL
putt$ = putt$ + CHR$(&H74) + CHR$(&H7)                           ' JZ Downrow
putt$ = putt$ + CHR$(&HEB) + CHR$(&HF2)                          ' Back2: JMP 0142
putt$ = putt$ + CHR$(&H47)                                       ' Skippixel: INC DI
putt$ = putt$ + CHR$(&HFE) + CHR$(&HC1)                          ' INC CL
putt$ = putt$ + CHR$(&HEB) + CHR$(&HF5)                          ' JMP Back1
putt$ = putt$ + CHR$(&H31) + CHR$(&HC9)                          ' Downrow: XOR CX,CX
putt$ = putt$ + CHR$(&H88) + CHR$(&HD1)                          ' MOV CL,DL
putt$ = putt$ + CHR$(&H81) + CHR$(&HC7) + CHR$(&H40) + CHR$(&H1) ' ADD DI,0140
putt$ = putt$ + CHR$(&H29) + CHR$(&HCF)                          ' SUB DI,CX
putt$ = putt$ + CHR$(&HFE) + CHR$(&HC7)                          ' INC BH
putt$ = putt$ + CHR$(&H38) + CHR$(&HF7)                          ' CMP BH,DH
putt$ = putt$ + CHR$(&H74) + CHR$(&H4)                           ' JZ Done
putt$ = putt$ + CHR$(&H31) + CHR$(&HC9)                          ' XOR CX,CX
putt$ = putt$ + CHR$(&HEB) + CHR$(&HE5)                          ' JMP Back2
putt$ = putt$ + CHR$(&H1F)                                       ' Done: POP DS
putt$ = putt$ + CHR$(&H5D)                                       ' POP BP
putt$ = putt$ + CHR$(&HCA) + CHR$(&HC) + CHR$(&H0)               ' RETF 000C

'offset% = SADD(putt$)
'DEF SEG = VARSEG(putt$)
'CALL ABSOLUTE(offset%)
'DEF SEG

' ------ Created with Absolute Assembly 2.1 by Petter Holmberg, -97. ------- '

END SUB

SUB GetData

                                        '- declare variables
                                          DIM i AS INTEGER

  '- get and send data

  INPUT #2, Player(PlayerTwo).x, Player(PlayerTwo).y, Player(PlayerTwo).position, Player(PlayerTwo).animation, FB(PlayerTwo), Flicker2

  WRITE #2, Player(PlayerOne).x, Player(PlayerOne).y, Player(PlayerOne).position, Player(PlayerOne).animation, FB(PlayerOne), Flicker

  IF MaxPlayers > 2 THEN
    FOR i = 1 TO MaxPlayers
      IF i <> PlayerOne AND i <> PlayerTwo THEN INPUT #2, Player(i).x, Player(i).y, Player(i).position, Player(i).animation, FB(i)
    NEXT i
  END IF

  FOR i = 1 TO MaxPlayers
    IF FB(i) THEN FireBullet i
    FB(i) = 0
  NEXT i

END SUB

DEFINT A-Z
FUNCTION Keyboard (t%)
STATIC kbcontrol%(), kbmatrix%(), Firsttime, StatusFlag
IF Firsttime = 0 THEN
 DIM kbcontrol%(128)
 DIM kbmatrix%(128)
 code$ = ""
 code$ = code$ + "E91D00E93C00000000000000000000000000000000000000000000000000"
 code$ = code$ + "00001E31C08ED8BE24000E07BF1400FCA5A58CC38EC0BF2400B85600FAAB"
 code$ = code$ + "89D8ABFB1FCB1E31C08EC0BF2400BE14000E1FFCFAA5A5FB1FCBFB9C5053"
 code$ = code$ + "51521E560657E460B401A8807404B400247FD0E088C3B700B0002E031E12"
 code$ = code$ + "002E8E1E100086E08907E4610C82E661247FE661B020E6205F075E1F5A59"
 code$ = code$ + "5B589DCF"
 DEF SEG = VARSEG(kbcontrol%(0))
 FOR i% = 0 TO 155
 d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
 POKE VARPTR(kbcontrol%(0)) + i%, d%
 NEXT i%
 i& = 16
 n& = VARSEG(kbmatrix%(0)): l& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
 n& = VARPTR(kbmatrix%(0)): l& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
 DEF SEG
 Firsttime = 1
END IF
SELECT CASE t
 CASE 1 TO 128
 Keyboard = kbmatrix%(t)
 CASE -1
 IF StatusFlag = 0 THEN
 DEF SEG = VARSEG(kbcontrol%(0))
 CALL ABSOLUTE(0)
 DEF SEG
 StatusFlag = 1
 END IF
 CASE -2
 IF StatusFlag = 1 THEN
 DEF SEG = VARSEG(kbcontrol%(0))
 CALL ABSOLUTE(3)
 DEF SEG
 StatusFlag = 0
 END IF
 CASE ELSE
 Keyboard = 0
END SELECT
END FUNCTION

DEFSNG A-Z
SUB LoadDeltaData

                                          '- dimension variables
                                            DIM CheckString AS STRING
                                            DIM i AS INTEGER
                                            DIM x AS INTEGER

                                          '- dimension array variables
                                            

  '- loads the UT.DAT file
    OPEN "UT.DAT" FOR INPUT AS #1
      FileLength = LOF(1)
      DataString = INPUT$(FileLength, 1)
    CLOSE #1

  '- compile some the data
    FOR i = 1 TO FileLength

      '- check for {}
        IF MID$(DataString, i, 1) = "{" THEN
          i = i + 1
          x = INSTR(i, DataString, "=")
          CheckString = MID$(DataString, i, x - i)

          IF UCASE$(CheckString) = "MAXPLAYERS" THEN
            i = i + 11
            MaxPlayers = VAL(MID$(DataString, i, 2))
          END IF

          IF UCASE$(CheckString) = "BLOODGORE" THEN
            i = i + 10
            BloodGore = VAL(MID$(DataString, i, 2))
          END IF
         
          IF UCASE$(CheckString) = "DIFFICULTY" THEN
            i = i + 11
            Difficulty = VAL(MID$(DataString, i, 2))
          END IF

          IF UCASE$(CheckString) = "GAMESPEED" THEN
            i = i + 10
            GameSpeed = VAL(MID$(DataString, i, 2))
          END IF

          IF UCASE$(CheckString) = "EXPLODETILE" THEN
            i = i + 12
            ExplodeTile1 = VAL(MID$(DataString, i, 2)) - 1
            i = i + 3
            ExplodeTile2 = VAL(MID$(DataString, i, 2)) - 1
          END IF

          IF UCASE$(CheckString) = "TILESET" THEN
            i = i + 8
            x = INSTR(i, DataString, "}")
            TileSetFile = MID$(DataString, i, x - i)
          END IF

          IF UCASE$(CheckString) = "MAP" THEN
            i = i + 4
            x = INSTR(i, DataString, "}")
            MapFile = MID$(DataString, i, x - i)
          END IF

          IF UCASE$(CheckString) = "TIME" THEN
            i = i + 5
            x = INSTR(i, DataString, "}")
            TimeLimit = VAL(MID$(DataString, i, x - i))
          END IF

          IF UCASE$(CheckString) = "PLAYERONE" THEN
            i = i + 10
            x = INSTR(i, DataString, "}")
            PlayerOne = VAL(MID$(DataString, i, x - i))
          END IF

          IF UCASE$(CheckString) = "PLAYERTWO" THEN
            i = i + 10
            x = INSTR(i, DataString, "}")
            PlayerTwo = VAL(MID$(DataString, i, x - i))
            IF TookGame = 0 THEN MultiPlayer = 1
          END IF

          IF UCASE$(CheckString) = "COMPORT" THEN
            i = i + 8
            x = INSTR(i, DataString, "}")
            ComPort = VAL(MID$(DataString, i, x - i))
            MultiPlayer = 1
          END IF

          IF UCASE$(CheckString) = "MASTER" THEN
            MultiPlayer = 1
            Master = 1
          END IF
         
          IF UCASE$(CheckString) = "SLAVE" THEN
            MultiPlayer = 1
            Master = 0
          END IF

          IF UCASE$(CheckString) = "TOOKGAME" THEN
            TookGame = 1
          END IF

          IF UCASE$(CheckString) = "UNFAIRFIRE" THEN
            UnFairFire = 1
          END IF
         
          IF UCASE$(CheckString) = "COOP" THEN
            CoOp = 1
          END IF

          IF UCASE$(CheckString) = "GRASSDIRT" THEN
            GrassDirt = 1
          END IF
         
          IF UCASE$(CheckString) = "POPUPS" THEN
            PopUps = 1
          END IF

        END IF

      
    NEXT i
    IF TookGame = 1 OR MultiPlayer = 1 THEN PopUps = 0


END SUB

SUB LoadMap (FileName AS STRING)

                                        '- declare variables
                                          DIM x AS INTEGER
                                          DIM y AS INTEGER
                                          DIM i AS INTEGER
 
  '- load the map
    OPEN FileName FOR INPUT AS #1
      FOR y = 1 TO 20
        FOR x = 1 TO 32
          INPUT #1, Map(x, y)
          IF Map(x, y) = 24 THEN
            i = i + 1
            WaterX(i) = x * 10 - 10
            WaterY(i) = y * 10 - 10
            WaterNumber = i
          END IF
        NEXT x
      NEXT y
    CLOSE #1

END SUB

SUB LoadPalette

  '- load the palette
    DEFINT A-Z
    REDIM PaletteArray&(0 TO 255)
    FileNo = FREEFILE
    OPEN "GRADIENT.PAL" FOR BINARY AS #FileNo
    FOR n = 0 TO 255
    GET #FileNo, , colour&
    PaletteArray&(n) = colour&
    NEXT n
    CLOSE #FileNo
    DIM RGBval(0 TO 255, 0 TO 2)
    FOR n = 0 TO 255
    c& = PaletteArray&(n)
    B = c& \ 65536: c& = c& - B * 65536
    g = c& \ 256: c& = c& - g * 256
    r = c&
    RGBval(n, 0) = r
    RGBval(n, 1) = g
    RGBval(n, 2) = B
    NEXT n
    WAIT &H3DA, &H8, &H8: WAIT &H3DA, &H8
    FOR n = 0 TO 255
    OUT &H3C8, n
    OUT &H3C9, RGBval(n, 0)
    OUT &H3C9, RGBval(n, 1)
    OUT &H3C9, RGBval(n, 2)
    NEXT n

END SUB

DEFSNG A-Z
SUB LoadSprite (FileName AS STRING, sp AS INTEGER)

  '- load sprite set
    DEF SEG = VARSEG(Sprite(0, sp))
      BLOAD FileName, VARPTR(Sprite(0, sp))
    DEF SEG

END SUB

SUB MakeExplosion (x AS INTEGER, y AS INTEGER, radius AS INTEGER, p AS INTEGER, position AS INTEGER, explodepasswalls AS INTEGER)

                                        '- declare variables
                                          DIM xx AS INTEGER, yy AS INTEGER
                                          DIM dx AS INTEGER, dy AS INTEGER
                                          DIM RadiusLeft AS INTEGER
                                          DIM RadiusRight AS INTEGER
                                          DIM RadiusUp AS INTEGER
                                          DIM RadiusDown AS INTEGER
                                          DIM LR AS INTEGER
                                          DIM DontRight AS INTEGER
                                          DIM DontDown AS INTEGER

    IF radius = 0 THEN EXIT SUB
  '- create an explosion
    IF explodepasswalls THEN
      FOR yy = y - radius TO y + radius
        FOR xx = x - radius TO x + radius
          IF xx * 10 - 10 > 0 AND xx * 10 - 10 < 310 AND yy * 10 - 10 > 0 AND yy * 10 - 10 < 190 THEN
            IF ExplodeNumber < 1998 THEN
              ExplodeNumber = ExplodeNumber + 1
              Explosion(ExplodeNumber).x = xx * 10 - 10
              Explosion(ExplodeNumber).y = yy * 10 - 10
              Explosion(ExplodeNumber).t = 0
              Explosion(ExplodeNumber).p = p
            END IF
          END IF
        NEXT xx
      NEXT yy
    ELSE
      RadiusUp = radius
      RadiusDown = radius
      RadiusLeft = radius
      RadiusRight = radius
      xx = x
      yy = y
      dx = -1
      dy = -1
      IF position = LEFT OR position = RIGHT THEN LR = 1
      IF position = UP OR position = DOWN THEN UD = 1
      IF Map(xx, yy) = 0 THEN LR = 1: UD = 1
      IF Map(xx, yy) AND position = LEFT THEN dx = 1: RadiusRight = (RadiusRight * 2) - 1
      IF Map(xx, yy) AND position = RIGHT THEN dx = -1: RadiusLeft = (RadiusLeft * 2) - 1: DontRight = 1
      IF Map(xx, yy) AND position = UP THEN dy = 1: RadiusDown = (RadiusDown * 2) - 1
      IF Map(xx, yy) AND position = DOWN THEN dy = -1: RadiusUp = (RadiusUp * 2) - 1: DontDown = 1
      IF LR = 1 THEN
        DO
          xx = xx + dx
          IF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dx = -1 THEN
            IF DontRight = 0 THEN dx = 1: RadiusUp = radius
            xx = x
            IF DontRight THEN EXIT DO
          ELSEIF xx < x - RadiusLeft THEN
            IF DontRight = 0 THEN dx = 1: RadiusUp = radius
            xx = x
            IF DontRight THEN EXIT DO
          ELSEIF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dx = 1 THEN
            xx = x: EXIT DO
          ELSEIF xx > x + RadiusRight THEN
            xx = x: EXIT DO
          END IF
          DO
            yy = yy + dy
            IF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dy = -1 THEN
              RadiusUp = (y - yy) - 1
              dy = 1: yy = y
            ELSEIF yy < y - RadiusUp THEN
              dy = 1: yy = y
            ELSEIF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dy = 1 THEN
              RadiusDown = (yy - y) - 1
              yy = y: dy = -1: EXIT DO
            ELSEIF yy > y + RadiusDown THEN
              yy = y: dy = -1: EXIT DO
            END IF
            ExplodeNumber = ExplodeNumber + 1
            Explosion(ExplodeNumber).x = xx * 10 - 10
            Explosion(ExplodeNumber).y = yy * 10 - 10
            Explosion(ExplodeNumber).t = 0
            Explosion(ExplodeNumber).p = p
          LOOP
        LOOP
      END IF
      IF UD = 1 THEN
        DO
          yy = yy + dy
          IF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dy = -1 THEN
            IF DontDown = 0 THEN dy = 1
            yy = y
            IF DontDown THEN EXIT DO
          ELSEIF yy < y - RadiusUp THEN
            IF DontRight = 0 THEN dy = 1
            yy = y
            IF DontDown THEN EXIT DO
          ELSEIF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dy = 1 THEN
            yy = y: EXIT DO
          ELSEIF yy > y + RadiusDown THEN
            yy = y: EXIT DO
          END IF
          DO
            xx = xx + dx
            IF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dx = -1 THEN
              RadiusLeft = (x - xx) - 1
              dx = 1: xx = x
            ELSEIF xx < x - RadiusLeft THEN
              dx = 1: xx = x
            ELSEIF Map(xx, yy) > 0 AND Map(xx, yy) < 24 AND dx = 1 THEN
              RadiusRight = (xx - x) - 1
              xx = x: dx = -1: EXIT DO
            ELSEIF xx > x + RadiusRight THEN
              xx = x: dx = -1: EXIT DO
            END IF
            ExplodeNumber = ExplodeNumber + 1
            Explosion(ExplodeNumber).x = xx * 10 - 10
            Explosion(ExplodeNumber).y = yy * 10 - 10
            Explosion(ExplodeNumber).t = 0
            Explosion(ExplodeNumber).p = p
          LOOP
        LOOP
      END IF
    END IF

END SUB

SUB MoveBullets

                                        '- declare variables
                                          DIM i AS INTEGER
                                          DIM n AS INTEGER
                                          DIM t AS INTEGER
                                          DIM e AS INTEGER
                                          DIM g AS INTEGER
                                          DIM r AS INTEGER
                                          DIM ri AS INTEGER
                                          DIM x AS INTEGER
                                          DIM y AS INTEGER
                                          DIM ox AS INTEGER
                                          DIM oy AS INTEGER
                                          DIM BHit AS INTEGER
                                          DIM DontExplode AS INTEGER
                                          DIM GetRidOf AS INTEGER
                 
  '- move anu bullets if there are any
  '- NOTE: bullets can be anything: missiles, water, etc.
    FOR i = 1 TO MaxPlayers
      FOR n = 1 TO NumBullets(i)
        IF Player(i).weapon.drunk THEN
          r = INT(2 * RND(1)) + 1
          IF Bullet(n, i).position = UP OR Bullet(n, i).position = DOWN THEN
            IF r = 1 THEN Bullet(n, i).x = Bullet(n, i).x + 2
            IF r = 2 THEN Bullet(n, i).x = Bullet(n, i).x - 2
            FOR y = 10 TO 19 STEP 9
              FOR x = 10 TO 19 STEP 9
                IF Map((Bullet(n, i).x + x) \ 10, (Bullet(n, i).y + y) \ 10) > 0 AND Map((Bullet(n, i).x + x) \ 10, (Bullet(n, i).y + y) \ 10) < 24 THEN
                  IF r = 1 THEN Bullet(n, i).x = Bullet(n, i).x - 2
                  IF r = 2 THEN Bullet(n, i).x = Bullet(n, i).x + 2
                END IF
              NEXT x
            NEXT y
          END IF
          IF Bullet(n, i).position = LEFT OR Bullet(n, i).position = RIGHT THEN
            IF r = 1 THEN Bullet(n, i).y = Bullet(n, i).y + 2
            IF r = 2 THEN Bullet(n, i).y = Bullet(n, i).y - 2
            FOR y = 10 TO 19 STEP 9
              FOR x = 10 TO 19 STEP 9
                IF Map((Bullet(n, i).x + x) \ 10, (Bullet(n, i).y + y) \ 10) > 0 AND Map((Bullet(n, i).x + x) \ 10, (Bullet(n, i).y + y) \ 10) < 24 THEN
                  IF r = 1 THEN Bullet(n, i).y = Bullet(n, i).y - 2
                  IF r = 2 THEN Bullet(n, i).y = Bullet(n, i).y + 2
                END IF
              NEXT x
            NEXT y
          END IF
          r = 0
        END IF
        '- move the bullet
          IF i = PlayerOne THEN
            IF Bullet(n, i).position = RIGHT THEN Bullet(n, i).x = Bullet(n, i).x + BulletSpeed(i)
            IF Bullet(n, i).position = LEFT THEN Bullet(n, i).x = Bullet(n, i).x - BulletSpeed(i)
            IF Bullet(n, i).position = DOWN THEN Bullet(n, i).y = Bullet(n, i).y + BulletSpeed(i)
            IF Bullet(n, i).position = UP THEN Bullet(n, i).y = Bullet(n, i).y - BulletSpeed(i)
          ELSEIF i = PlayerTwo AND TookGame = 1 THEN
            IF Bullet(n, i).position = RIGHT THEN Bullet(n, i).x = Bullet(n, i).x + BulletSpeed(i)
            IF Bullet(n, i).position = LEFT THEN Bullet(n, i).x = Bullet(n, i).x - BulletSpeed(i)
            IF Bullet(n, i).position = DOWN THEN Bullet(n, i).y = Bullet(n, i).y + BulletSpeed(i)
            IF Bullet(n, i).position = UP THEN Bullet(n, i).y = Bullet(n, i).y - BulletSpeed(i)
          ELSE
            IF Bullet(n, i).position = RIGHT THEN Bullet(n, i).x = Bullet(n, i).x + (BulletSpeed(i) * (Difficulty / 2))
            IF Bullet(n, i).position = LEFT THEN Bullet(n, i).x = Bullet(n, i).x - (BulletSpeed(i) * (Difficulty / 2))
            IF Bullet(n, i).position = DOWN THEN Bullet(n, i).y = Bullet(n, i).y + (BulletSpeed(i) * (Difficulty / 2))
            IF Bullet(n, i).position = UP THEN Bullet(n, i).y = Bullet(n, i).y - (BulletSpeed(i) * (Difficulty / 2))
          END IF
        IF Bullet(n, i).spread <> 0 THEN
          IF Bullet(n, i).position = UP OR Bullet(n, i).position = DOWN THEN Bullet(n, i).x = Bullet(n, i).x + Bullet(n, i).spread
          IF Bullet(n, i).position = LEFT OR Bullet(n, i).position = RIGHT THEN Bullet(n, i).y = Bullet(n, i).y + Bullet(n, i).spread
        END IF
        IF Player(i).weapon.rotate THEN
          SELECT CASE Bullet(n, i).position
            CASE IS = RIGHT
              Bullet(n, i).position = DOWN
            CASE IS = DOWN
              Bullet(n, i).position = LEFT
            CASE IS = LEFT
              Bullet(n, i).position = UP
            CASE IS = UP
              Bullet(n, i).position = RIGHT
          END SELECT
        END IF
        '- draw the bullet
          IF Bullet(n, i).position = RIGHT THEN e = 1
          IF Bullet(n, i).position = LEFT THEN e = 2
          IF Bullet(n, i).position = DOWN THEN e = 3
          IF Bullet(n, i).position = UP THEN e = 4
          r = Bullet(n, i).position
          offset% = SADD(putt$)
          DEF SEG = VARSEG(putt$)
            CALL ABSOLUTE(Bullet(n, i).x, Bullet(n, i).y, VARSEG(Sprite(EPS * (31 + e), i)), VARPTR(Sprite(EPS * (31 + e), i)), VARSEG(Page1(0)), VARPTR(Page1(0)), offset%)
          DEF SEG
        '- check if bullet hit something
          FOR y = 10 TO 19 STEP 9
            FOR x = 10 TO 19 STEP 9
              IF Map((Bullet(n, i).x + x) \ 10, (Bullet(n, i).y + y) \ 10) > 0 AND Map((Bullet(n, i).x + x) \ 10, (Bullet(n, i).y + y) \ 10) < 24 THEN
                GetRidOf = 1
                ox = (Bullet(n, i).x + x) \ 10
                oy = (Bullet(n, i).y + y) \ 10
              END IF
              FOR g = 1 TO MaxPlayers
                IF g <> i AND (Bullet(n, i).x + x) \ 10 = (Player(g).x + x) \ 10 AND (Bullet(n, i).y + y) \ 10 = (Player(g).y + y) \ 10 THEN
                    IF g = PlayerOne AND i = PlayerTwo AND CoOp = 1 THEN
                    ELSEIF g = PlayerTwo AND i = PlayerOne AND CoOp = 1 THEN
                    ELSEIF g = PlayerOne AND Flicker <> 0 THEN
                    ELSEIF g = PlayerTwo AND Flicker2 <> 0 THEN
                    ELSE
                      IF Player(i).weapon.freeze THEN
                        IF Player(g).position <> DEAD AND Player(g).position <> FROZEN THEN
                          Player(g).animation = 0
                          Kills(g, i) = 1
                          IF Player(g).position = RIGHT THEN Player(g).position = FROZEN + 1
                          IF Player(g).position = LEFT THEN Player(g).position = FROZEN + 2
                          IF Player(g).position = DOWN THEN Player(g).position = FROZEN + 3
                          IF Player(g).position = UP THEN Player(g).position = FROZEN + 4
                          IF Player(g).frozentime = 0 THEN Player(g).frozentime = 200
                        END IF
                        GetRidOf = 1
                        ox = (Bullet(n, i).x + x) \ 10
                        oy = (Bullet(n, i).y + y) \ 10
                      ELSE
                        IF Player(g).position <> DEAD THEN Player(g).animation = 0
                        Player(g).position = DEAD
                        GetRidOf = 1
                        ox = (Bullet(n, i).x + x) \ 10
                        oy = (Bullet(n, i).y + y) \ 10
                        Kills(g, i) = 1
                      END IF
                    END IF
                END IF
              NEXT g
            NEXT x
          NEXT y
          '- if unfair fire is on, check if bullets hit each other
          IF UnFairFire THEN
            FOR t = 1 TO MaxPlayers
              FOR e = 1 TO NumBullets(t)
                IF t <> i THEN
                  IF (Bullet(n, i).x + x) \ 10 = (Bullet(e, t).x + x) \ 10 AND (Bullet(n, i).y + y) \ 10 = (Bullet(e, t).y + y) \ 10 THEN
                    ox = (Bullet(n, i).x + x) \ 10
                    oy = (Bullet(n, i).y + y) \ 10
                    FOR g = n TO NumBullets(i) - 1
                      Bullet(g, i).x = Bullet(g + 1, i).x
                      Bullet(g, i).y = Bullet(g + 1, i).y
                      Bullet(g, i).position = Bullet(g + 1, i).position
                      Bullet(g, i).spread = Bullet(g + 1, i).spread
                    NEXT g
                    MakeExplosion ox, oy, Player(i).weapon.explode, i, r, Player(i).weapon.pass
                    NumBullets(i) = NumBullets(i) - 1
                    ox = (Bullet(e, t).x + x) \ 10
                    oy = (Bullet(e, t).y + y) \ 10
                    FOR g = e TO NumBullets(t) - 1
                      ri = Bullet(n, i).position
                      Bullet(g, t).x = Bullet(g + 1, t).x
                      Bullet(g, t).y = Bullet(g + 1, t).y
                      Bullet(g, t).position = Bullet(g + 1, t).position
                      Bullet(g, t).spread = Bullet(g + 1, t).spread
                    NEXT g
                    MakeExplosion ox, oy, Player(t).weapon.explode, t, ri, Player(t).weapon.pass
                    NumBullets(t) = NumBullets(t) - 1
                    IF NumBullets(i) < 0 THEN NumBullets(i) = 0
                    IF NumBullets(t) < 0 THEN NumBullets(t) = 0
                    GetRidOf = 0
                    BHit = 1
                    IF NumBullets(t) < 0 THEN NumBullets(t) = 0
                  END IF
                END IF
              NEXT e
            NEXT t
            IF BHit = 0 THEN
              FOR y = 1 TO 10 STEP 5
                FOR x = 1 TO 10 STEP 5
                  IF POINT(Bullet(n, i).x + x, Bullet(n, i).y + y) = 90 OR POINT(Bullet(n, i).x + x, Bullet(n, i).y + y) = 92 AND GetRidOf = 0 THEN
                    ox = (Bullet(n, i).x + x) \ 10
                    oy = (Bullet(n, i).y + y) \ 10
                    FOR g = n TO NumBullets(i) - 1
                      Bullet(g, i).x = Bullet(g + 1, i).x
                      Bullet(g, i).y = Bullet(g + 1, i).y
                      Bullet(g, i).position = Bullet(g + 1, i).position
                      Bullet(g, i).spread = Bullet(g + 1, i).spread
                    NEXT g
                    MakeExplosion ox, oy, Player(i).weapon.explode, i, r, Player(i).weapon.pass
                    NumBullets(i) = NumBullets(i) - 1
                    GetRidOf = 0
                  END IF
                NEXT x
              NEXT y
            END IF
          END IF
          IF GetRidOf = 0 THEN IF Bullet(n, i).x < 10 OR Bullet(n, i).x > 300 OR Bullet(n, i).y < 10 OR Bullet(n, i).y > 180 THEN GetRidOf = 1: DontExplode = 1
          IF GetRidOf THEN
            '- get rid of bullet
              FOR t = n TO NumBullets(i) - 1
                Bullet(t, i).x = Bullet(t + 1, i).x
                Bullet(t, i).y = Bullet(t + 1, i).y
                Bullet(t, i).position = Bullet(t + 1, i).position
                Bullet(t, i).spread = Bullet(t + 1, i).spread
              NEXT t
              IF DontExplode = 0 THEN MakeExplosion ox, oy, Player(i).weapon.explode, i, r, Player(i).weapon.pass
              GetRidOf = 0
              NumBullets(i) = NumBullets(i) - 1
          END IF
          IF NumBullets(i) < 0 THEN NumBullets(i) = 0
      NEXT n
    NEXT i
   
END SUB

SUB MovePlayer (i AS INTEGER)

                                        '- delcare variables
                                          DIM r AS INTEGER
                                          DIM n AS INTEGER
                                          DIM DontShootRight AS INTEGER
                                          DIM DontShootLeft AS INTEGER
                                          DIM DontShootDown AS INTEGER
                                          DIM DontShootUp AS INTEGER
                                          DIM Move AS INTEGER
                                          DIM x AS INTEGER, y AS INTEGER
                                          DIM px AS INTEGER, py AS INTEGER
                                          DIM ps AS INTEGER
                                          DIM rd AS INTEGER
                                          DIM StopAnimation AS INTEGER

  IF i = PlayerTwo THEN EXIT SUB
  IF Player(i).position > FROZEN THEN EXIT SUB
  StopAnimation = 1
  IF MultiPlayer = 1 AND Master = 0 THEN EXIT SUB
  '- move a player
  IF Player(i).position <> DEAD THEN
    IF pd(i) = 0 THEN
      r = INT((100 \ Player(i).speed) * RND(1)) + 1
      IF Player(i).t = 0 THEN
        DO
          Player(i).d = INT(4 * RND(1)) + 1
        LOOP UNTIL Player(i).d <> Player(i).od
        IF Player(i).od = 0 THEN Player(i).od = Player(i).d: tp(i) = 20
        IF Player(i).od > 0 THEN tp(i) = tp(i) - 1
        IF tp(i) < 1 THEN Player(i).od = 0
      END IF
    ELSE
      r = INT(2 * RND(1)) + 1
      IF r = 1 THEN r = INT(5 * RND(1)) + 1 ELSE r = INT(5 * RND(1)) + 5
      IF Player(i).t = 0 THEN
        Player(i).d = 5
      END IF
    END IF
      IF Player(i).d = 1 THEN
        Player(i).x = Player(i).x + (Player(i).speed * (Difficulty / 2))
        Player(i).position = RIGHT
        StopAnimation = 0
      ELSEIF Player(i).d = 2 THEN
        Player(i).x = Player(i).x - (Player(i).speed * (Difficulty / 2))
        Player(i).position = LEFT
        StopAnimation = 0
      ELSEIF Player(i).d = 3 THEN
        Player(i).y = Player(i).y + (Player(i).speed * (Difficulty / 2))
        Player(i).position = DOWN
        StopAnimation = 0
      ELSEIF Player(i).d = 4 THEN
        Player(i).y = Player(i).y - (Player(i).speed * (Difficulty / 2))
        Player(i).position = UP
        StopAnimation = 0
      END IF
        FOR ps = 1 TO 4
          px = Player(i).x: py = Player(i).y
          rd = 0
          DO
            IF ps = 1 THEN px = px + 10
            IF ps = 2 THEN px = px - 10
            IF ps = 3 THEN py = py + 10
            IF ps = 4 THEN py = py - 10
            rd = rd + 1
            IF rd > Player(i).weapon.explode THEN EXIT DO
            FOR y = 10 TO 19 STEP 9
              FOR x = 10 TO 19 STEP 9
                IF Map((px + x) \ 10, (py + y) \ 10) > 0 AND Map((px + x) \ 10, (py + y) \ 10) < 24 THEN
                  IF ps = 1 THEN DontShootRight = 1: EXIT DO
                  IF ps = 2 THEN DontShootLeft = 1: EXIT DO
                  IF ps = 3 THEN DontShootDown = 1: EXIT DO
                  IF ps = 4 THEN DontShootUp = 1: EXIT DO
                END IF
              NEXT x
            NEXT y
          LOOP
        NEXT ps
      FOR n = 1 TO MaxPlayers
        IF i <> n THEN
          IF Player(i).y = Player(n).y AND Player(n).x < Player(i).x AND DontShootLeft = 0 THEN
            Player(i).position = LEFT
            FireBullet (i)
            pd(n) = 0
            r = 1
            Move = 1
          END IF
          IF Player(i).y = Player(n).y AND Player(n).x > Player(i).x AND DontShootRight = 0 THEN
            Player(i).position = RIGHT
            FireBullet (i)
            pd(n) = 0
            r = 1
            Move = 1
          END IF
          IF Player(i).x = Player(n).x AND Player(n).y > Player(i).y AND DontShootDown = 0 THEN
            Player(i).position = DOWN
            FireBullet (i)
            pd(n) = 0
            r = 1
            Move = 1
          END IF
          IF Player(i).x = Player(n).x AND Player(n).y < Player(i).y AND DontShootUp = 0 THEN
            Player(i).position = UP
            FireBullet (i)
            pd(n) = 0
            r = 1
            Move = 1
          END IF
        END IF
      NEXT n
    Player(i).t = 1
    IF r = 1 THEN
      Player(i).t = 0
      IF pd(i) = 0 THEN pd(i) = 1 ELSE pd(i) = 0
      IF Move THEN pd(i) = 0: Move = 0
    END IF
  END IF
    IF StopAnimation AND Player(i).position <> DEAD AND Player(i).position <> FROZEN THEN
      StopAnimation = 0
      Player(i).animation = 0
    END IF
    Player(i).animation = Player(i).animation + add(i)
    IF Player(i).position <> DEAD AND Player(i).position <> FROZEN AND Player(i).d = 5 THEN Player(i).animation = Player(i).animation - add(i)
    

END SUB

SUB PageCopy (s1 AS INTEGER, s2 AS INTEGER)


  '- copy from one page to another
    offset% = SADD(fullcopy$)
    DEF SEG = VARSEG(fullcopy$)
    IF s1 = 2 AND s2 = 1 THEN
      CALL ABSOLUTE(VARSEG(Page2(0)), VARPTR(Page2(0)), VARSEG(Page1(0)), VARPTR(Page1(0)), offset%)
    ELSEIF s1 = 1 AND s2 = 2 THEN
      CALL ABSOLUTE(VARSEG(Page1(0)), VARPTR(Page1(0)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
    ELSEIF s1 = 2 AND s2 = 0 THEN
      CALL ABSOLUTE(VARSEG(Page2(0)), VARPTR(Page2(0)), &HA000, 0, offset%)
    ELSEIF s1 = 1 AND s2 = 0 THEN
      CALL ABSOLUTE(VARSEG(Page1(0)), VARPTR(Page1(0)), &HA000, 0, offset%)
    ELSEIF s1 = 0 AND s2 = 1 THEN
      CALL ABSOLUTE(&HA000, 0, VARSEG(Page1(0)), VARPTR(Page1(0)), offset%)
    ELSEIF s1 = 0 AND s2 = 2 THEN
        CALL ABSOLUTE(&HA000, 0, VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
    END IF
    DEF SEG

END SUB

SUB PutSprite (x AS INTEGER, y AS INTEGER, pg AS INTEGER)

  '- put a sprite on a page

    offset% = SADD(putt$)
    DEF SEG = VARSEG(putt$)
    CALL ABSOLUTE(x, y, offset%)
    DEF SEG


END SUB

SUB PutUpExplode

                                        '- declare variables
                                          DIM i AS INTEGER
                                          DIM n AS INTEGER
                                          DIM t AS INTEGER
                                         
  '- draws the explosions on the screen
    FOR i = 1 TO ExplodeNumber
      IF Explosion(i).x > 0 THEN
        offset% = SADD(putt$)
        DEF SEG = VARSEG(putt$)
          CALL ABSOLUTE(Explosion(i).x, Explosion(i).y, VARSEG(Sprite(EPS * (ExplodeTile1 + Explosion(i).t), TILE)), VARPTR(Sprite(EPS * (ExplodeTile1 + Explosion(i).t), TILE)), VARSEG(Page1(0)), VARPTR(Page1(0)), offset%)
        DEF SEG
        Explosion(i).t = Explosion(i).t + 1
        IF ExplodeTile1 + Explosion(i).t > ExplodeTile2 THEN Explosion(i).x = 0
      END IF
    NEXT i
    FOR i = 1 TO ExplodeNumber
      IF Explosion(i).x = 0 THEN
        FOR n = i TO ExplodeNumber - (t + 1)
          Explosion(n).x = Explosion(n + 1).x
          Explosion(n).y = Explosion(n + 1).y
          Explosion(n).t = Explosion(n + 1).t
          Explosion(n).p = Explosion(n + 1).p
        NEXT n
        t = t + 1
      END IF
    NEXT i
    ExplodeNumber = ExplodeNumber - t

END SUB

SUB PutUpMap

                                        '- declare variables
                                          DIM x AS INTEGER
                                          DIM y AS INTEGER
                                          DIM i AS INTEGER
                                          DIM n AS INTEGER
                                          DIM c AS INTEGER

  IF GrassDirt THEN
    PAINT (0, 0), 128
    n = INT(2 * RND(1)) + 1
    FOR i = 1 TO 32000
      x = INT(320 * RND(1)) + 1
      y = INT(320 * RND(1)) + 1
      c = INT(5 * RND(1)) + 1
      IF n = 1 THEN c = c + 127
      IF n = 2 THEN c = c + 47
      PSET (x, y), c
    NEXT i
    PageCopy 0, 2
  END IF
  '- put the map on the screen
    FOR y = 1 TO 20
      FOR x = 1 TO 32
        'PUT (x * 10 - 10, y * 10 - 10), Sprite(EPS * Map(x, y), TILE), PSET
        offset% = SADD(putt$)
        DEF SEG = VARSEG(putt$)
          CALL ABSOLUTE(x * 10 - 10, y * 10 - 10, VARSEG(Sprite(EPS * Map(x, y), TILE)), VARPTR(Sprite(EPS * Map(x, y), TILE)), VARSEG(Page2(0)), VARPTR(Page2(0)), offset%)
        DEF SEG
      NEXT x
    NEXT y

END SUB

SUB RandomPut

  '- put the players on a random spot on the map
    FOR i = 1 TO MaxPlayers
      DO
        x = INT(32 * RND) + 1
        y = INT(20 * RND) + 1
        IF Map(x, y) = 0 THEN
          Player(i).x = x * 10 - 10
          Player(i).y = y * 10 - 10
          EXIT DO
        END IF
      LOOP
        Player(i).position = DOWN
    NEXT i
    IF CoOp = 1 THEN
      Player(PlayerTwo).x = Player(PlayerOne).x
      Player(PlayerTwo).y = Player(PlayerOne).y
    END IF

END SUB

SUB SendData

                                        '- declare variables
                                          DIM i AS INTEGER

  '- send and get data

  WRITE #2, Player(PlayerOne).x, Player(PlayerOne).y, Player(PlayerOne).position, Player(PlayerOne).animation, FB(PlayerOne), Flicker
 
  INPUT #2, Player(PlayerTwo).x, Player(PlayerTwo).y, Player(PlayerTwo).position, Player(PlayerTwo).animation, FB(PlayerTwo), Flicker2
 
  IF MaxPlayers > 2 THEN
    FOR i = 3 TO MaxPlayers
      WRITE #2, Player(i).x, Player(i).y, Player(i).position, Player(i).animation, FB(i)
    NEXT i
  END IF
 
  FOR i = 1 TO MaxPlayers
    IF FB(i) THEN FireBullet i
    FB(i) = 0
  NEXT i

END SUB

