;*_LIB.ASM ******************************************************************
;* Main assembly module for quickbasic ver 7.1
;* Version 0.12
;* Coded by Ben Bosco
;* Last updated 8th April 2002
;****************************************************************************

.model  medium, basic
.386
.stack  200h

;* structure used by the xms function 
struct_xms_move         struc
        d_len           dd      ?
        w_src_hdl       dw      ?
        d_src_off       dd      ?
        w_dst_hdl       dw      ?
        d_dst_off       dd      ?
struct_xms_move         ends
                                                   
.data

;* memory handling variables (xms/ems) **************************************
b_mflag         db      0
b_emm_id        db      'EMMXXXX0'
w_ems_hdl       dw      ?
w_ems_seg       dw      ?

d_xms_ctrl      dd      ?
w_xms_hdl       dw      ?
s_xms_move      struct_xms_move <>

;* mouse and keyboard variables *********************************************
b_flag          db      0
w_mouse_x       dw      ?
w_mouse_y       dw      ?
b_mouse_b       db      ?

d_old_kbisr     dd      ?
b_old_kflag     db      ?
b_key_state     db      128 dup(0)
b_keys          db      0

.code

;* functions externed to qb *************************************************
public  lhzinit, lhzshutdown
public  lhzmousex, lhzmousey, lhzmouseb, lhzsetmouse
public  lhzkeycount, lhzkeystate
public  lhzmemcopy, lhzemsseg, lhzemsmap, lhzxmspaste, lhzxmscopy

;****************************************************************************
;* function lhzinit(nscr%, nxmskb%, nflag%)
;* Initializes the library by setting up ems, xms, mouse and kb.
;****************************************************************************
lhzinit         proc    uses ds es, n_scr:word, n_xmskb:word, n_flag:word
        mov     al, byte ptr n_flag
        mov     b_flag, al

;* is xms required
        cmp     n_xmskb, 0
        je      _ems_setup

;* check for presence of xms driver
        mov     ax, 4300h
        int     2Fh
        cmp     al, 80h
        jne     _err1_no_emm

;* extract the xms function address
        mov     ax, 4310h
        int     2Fh
        mov     word ptr [d_xms_ctrl], bx
        mov     word ptr [d_xms_ctrl+2], es

;* is there enough xms memory
        mov     ah, 08h
        call    [d_xms_ctrl]
        cmp     ax, n_xmskb
        jl      _err1_no_emm

;* allocate the amount of xms specified and store the handle
        mov     ah, 09h
        mov     dx, n_xmskb
        call    [d_xms_ctrl]
        cmp     ax, 0
        je      _err1_no_emm
        mov     w_xms_hdl, dx
        or      b_mflag, 00000010b

_ems_setup:
;* do we require ems
        cmp     n_scr, 0
        je      _no_ems_req
;* extract the address of the emm
        mov     ax, 3567h
        int     21h
;* point es:di to where emm id should be and check it
        mov     di, 0Ah
        lea     si, b_emm_id
        mov     cx, 8
        cld
        repe    cmpsb
        jne     _err1_no_emm

;* is there enough ems (pages is stored in bx)
        mov     ah, 42h
        int     67h
        mov     ax, bx          
        mov     bx, n_scr
;* multipy pages required by 4, as high end qb module works in 64k segs
        shl     bx, 02
        cmp     ax, bx
        jl      _err2_not_enough

;* allocate ems and extract ems segment
        mov     ax, 4300h
        int     67h
        mov     w_ems_hdl, dx
        mov     ah, 41h
        int     67h                     
        mov     w_ems_seg, bx

        or      b_mflag, 00000001b

_no_ems_req:
;* is a mouse required
        test    n_flag, 1
        jz      _no_mouse_req
;* initialize the mouse
        xor     ax, ax
        int     33h
        cmp     ax, 0
        je      _err3_no_mouse
    
;* install the mouse handler (cl holds conditions of handler)
        xor     ch, ch
        mov     cl, 01111111b
        mov     dx, seg _mouse_handler
        mov     es, dx
        mov     dx, offset _mouse_handler
        mov     ax, 0Ch
        int     33h

_no_mouse_req:
;* is the keyboard handler required
        test    n_flag, 4
        jz      _no_keyboard_req

;* 40:17 points to kb flag 1
        mov     ax, 040h
        mov     es, ax
        mov     si, 017h
        mov     al, es:[si]
;* make sure shift in not de-pressed and store old key flags
        and     al, 11111100b
        mov     b_old_kflag, al
;* save the old kb handler address
        mov     ax, 3509h
        int     21h
        mov     word ptr [d_old_kbisr], bx
        mov     word ptr [d_old_kbisr+2], es

        mov     ax, seg _kb_handler
        mov     dx, offset _kb_handler

;* point interrupt 9h to _kb_handler
        push    ds
        mov     ds, ax
        mov     ax, 2509h
        int     21h
        pop     ds

_no_keyboard_req:
;* clear ax to signify no errors
        xor     ax, ax
        jmp     _exit_asminit

;* return error value in ax
_err1_no_emm:
        mov     ax, 1
        jmp     _exit_asminit
_err2_not_enough:
        mov     ax, 2
        jmp     _exit_asminit
_err3_no_mouse:
        mov     ax, 3
        jmp     _exit_asminit

_kb_handler:
;* store all used registers (bl stores key state 1:down 0:up)
        push    ax
        push    bx
        push    ds

        mov     ax, @data
        mov     ds, ax

;* get the key that was pressed/released
        in      al, 60h
        movzx   bx, al

;* bit 7 holds key action (0:pressed)
        test    bl, 10000000b
        jz      _key_press

_key_up:
;* disregard bit 7
        and     bl, 01111111b
        cmp     b_key_state[bx], 0
        je      _kb_cleanup

        mov     b_key_state[bx],  0
        dec     b_keys

        jmp     _kb_cleanup

_key_press:
        cmp     b_key_state[bx], 1
        je      _kb_cleanup

        mov     b_key_state[bx], 1
        inc     b_keys

_kb_cleanup:
;* re-enable interrups
        mov     al, 20h
        out     20h, al                     

        pop     ds
        pop     bx                          
        pop     ax                          
        iret                                

_exit_asminit:
        ret
lhzInit    endp

_mouse_handler  proc    far
        push    ds
        push    ax
        mov     ax, @data
        mov     ds,ax
        mov     w_mouse_x, cx
        mov     w_mouse_y, dx
        mov     b_mouse_b, bl
        pop     ax
        pop     ds
        ret
_mouse_handler  endp

;****************************************************************************
;* sub lhzshutdown()
;* Returns all memory allocated and removes mouse and kb handlers if
;* necessary.
;****************************************************************************
lhzshutdown     proc    uses ds
;* do we need to deallocate ems
        test    b_mflag, 00000001b
        jz      _no_uninst_ems
        mov     dx, w_ems_hdl
        mov     ax, 4500h
        int     67h

_no_uninst_ems:
;* do we need to deallocate xms
        test    b_mflag, 00000010b
        jz      _no_uninst_xms
        mov     ah, 0Ah
        mov     dx, w_xms_hdl
        call    [d_xms_ctrl]

_no_uninst_xms:
;* do we need to remove kb handler
        test    b_flag, 00000100b
        jz      _no_uninst_kb
        push    ds                          
        mov     dx, word ptr [d_old_kbisr]
        mov     ax, word ptr [d_old_kbisr+02]
        mov     ds, ax
        mov     ax, 2509h
        int     21h
        pop     ds
        mov     ax, 040h
        mov     es, ax
        mov     si, 017h
        mov     al, b_old_kflag
        mov     es:[si], al

_no_uninst_kb:
        ret
lhzshutdown   endp

;****************************************************************************
;* function lhzmousex()
;* function lhzmousey()
;* function lhzmouseb()
;* Returns the mouse's current x and y coordinates and its button status
;****************************************************************************
lhzmousex       proc    uses ds
        mov     ax, w_mouse_x
        shr     ax, 1
        ret
lhzmousex       endp

lhzmousey       proc    uses ds
        mov     ax, w_mouse_y
        ret
lhzmousey       endp

lhzmouseb       proc    uses ds
        movzx   ax, b_mouse_b
        ret
lhzmouseb  endp

;****************************************************************************
;* sub lhzsetmouse(nhorz%, nvert%)
;* Alters the physical position of mouse on screen
;****************************************************************************
lhzsetmouse	proc	uses ds, n_horz:word, n_vert:word
        mov     cx, n_horz
	mov	dx, n_vert
        shl     cx, 01

        mov     w_mouse_x, cx
        mov     w_mouse_y, dx

	mov	ax, 04h
        int     33h
	ret
lhzsetmouse	endp

;****************************************************************************
;* function lhzkeystate(nkey%)
;* Returns the state of the specified key (1:depressed)
;****************************************************************************
lhzkeystate     proc   uses ds, n_key:word
        mov     bx, n_key
        movzx   ax, b_key_state[bx]
        ret
lhzkeystate     endp

;****************************************************************************
;* function lhzkeystate(nkey%)
;* Returns the number of de-pressed keys.
;****************************************************************************
lhzkeycount     proc uses ds
        movzx   ax, b_keys
        ret
lhzkeycount     endp

;****************************************************************************
;* sub lhzmemcopy(nsrcseg%, nsrcoff%, ndstseg%, ndstoff%, lbytes&)
;* Copies memory between ems and conventional memory.
;* lbytes& must be divisible by 4 for it to work reliably.
;****************************************************************************
lhzmemcopy      proc    uses ds es, n_sseg:word, n_soff:word, n_dseg:word, n_doff:word, l_bytes:dword
        mov     ds, n_sseg
        mov     es, n_dseg
        mov     si, n_soff
        mov     di, n_doff
        mov     ecx, l_bytes
        shr     cx, 2
        rep     movsd
        ret
lhzmemcopy      endp

;****************************************************************************
;* function lhzemsseg()
;* Returns the ems segment
;****************************************************************************
lhzemsseg       proc    uses ds
        mov     ax, w_ems_seg
        ret
lhzemsseg       endp

;****************************************************************************
;* sub lhzemsmap(npage%)
;* Maps the specified ems page ready for use
;****************************************************************************
lhzemsmap       proc    uses ds, n_page:word
        mov     bx, n_page
        mov     dx, w_ems_hdl
        xor     ax, ax

_map_page:
        mov     ah, 44h
        int     67h
        inc     bx
        inc     al
        cmp     al, 4
        jne     _map_page
        ret
lhzemsmap       endp

;****************************************************************************
;* sub lhzxmspaste(nsseg&, nsoff&, loffset&, lbytes&)
;* Copyies up to 64K from conv/ems to xms.
;****************************************************************************
lhzxmspaste     proc    uses ds, n_sseg:word, n_soff:word, l_offset:dword, l_bytes:dword
        mov     eax, l_bytes
        mov     s_xms_move.d_len, eax
        mov     s_xms_move.w_src_hdl, 0
        mov     ax, n_sseg
        shl     eax, 16
        mov     ax, n_soff
        mov     s_xms_move.d_src_off, eax
        mov     ax, w_xms_hdl
        mov     s_xms_move.w_dst_hdl, ax
        mov     eax, l_offset
        mov     s_xms_move.d_dst_off, eax

        mov     ax, 0B00h
        mov     si, offset s_xms_move
        call    [d_xms_ctrl]
        ret
lhzxmspaste     endp

;****************************************************************************
;* sub lhzxmscopy(loffset&, ndseg&, ndoff&, lbytes&)
;* Copyies up to 64K from xms to conv/ems
;****************************************************************************
lhzxmscopy      proc    uses ds, l_offset:dword, n_dseg:word, n_doff:word, l_bytes:dword
        mov     eax, l_bytes
        mov     s_xms_move.d_len, eax
        mov     s_xms_move.w_dst_hdl, 0
        mov     ax, n_dseg
        shl     eax, 16
        mov     ax, n_doff
        mov     s_xms_move.d_dst_off, eax
        mov     ax, w_xms_hdl
        mov     s_xms_move.w_src_hdl, ax
        mov     eax, l_offset
        mov     s_xms_move.d_src_off, eax

        mov     ax, 0B00h
        mov     si, offset s_xms_move
        call    [d_xms_ctrl]
        ret

lhzXMSCopy endp

end

