'****************************************************************************
'* TRPRS.BI - QB include file for CANNON.BAS
'* Coded by Ben Bosco
'****************************************************************************
'$DYNAMIC
DEFINT A-Z

'* CANNON.BAS function declarations *****************************************
DECLARE SUB s.bob.add (x, y, spr, sprindex, flipflag, putfirst)
DECLARE SUB s.bob.draw (destBuffer, destOff)
DECLARE SUB s.bob.put (destBuffer, destOff, x, y, spr, sprnum, PUTTYPE, flip, scale)
DECLARE SUB s.bres.set (bres AS ANY, maxCount)
DECLARE SUB s.bres.update (bres AS ANY, incx, incy, loops)
DECLARE SUB s.bullets.add (spos AS ANY, dx, dy, rndDisp, ForEn, range)
DECLARE SUB s.bullets.update (destBuffer, destOff)
DECLARE SUB s.doodads.update ()
DECLARE SUB s.enemy.update ()
DECLARE SUB s.font.put (destBuffer, destOff, BYVAL x, BYVAL y, str AS STRING, col, shadow, bTeleType)
DECLARE SUB s.graph.fadetocol (pal AS STRING, ir, ig, ib, fade, iStart, iEnd)
DECLARE SUB s.graph.fadetopal (pal AS STRING, newpal AS STRING, fade, iStart, iEnd)
DECLARE SUB s.graph.setpal (pal AS STRING)
DECLARE SUB s.main.gameloop (destBuffer, destOff, sideBufferSeg, sideBufferOff)
DECLARE SUB s.main.getmask (spr, x, y)
DECLARE SUB s.main.intermediate (destBuffer, destOff)
DECLARE SUB s.main.intro (destBuffer, destOff)
DECLARE SUB s.main.menu (destBuffer, destOff)
DECLARE SUB s.main.minimap (destBuffer, destOff, sideBufferSeg, sideBufferOff)
DECLARE SUB s.main.newgame ()
DECLARE SUB s.main.scrollhandler (destBuffer, destOff, player AS ANY)
DECLARE SUB s.main.shutdown (errmsg AS STRING)
DECLARE SUB s.main.updatesidebar (destBuffer, destOff)
DECLARE SUB s.sound.loadsong (fileName AS STRING)
DECLARE SUB s.sound.playsample (iSample, freq&, iVol, iPan)
DECLARE SUB s.troopers.update ()
DECLARE SUB s.troopers.updateleader (group, curTrpr)

DECLARE FUNCTION f.font.findwidth (str AS STRING)
DECLARE FUNCTION f.main.finddir (dx, dy)
DECLARE FUNCTION f.font.load (fileName AS STRING)
DECLARE FUNCTION f.main.init ()
DECLARE FUNCTION f.main.loadmap (strFileName AS STRING)
DECLARE FUNCTION f.main.loadmission (strFileName AS STRING)
DECLARE FUNCTION f.main.loadspritebank (fileName AS STRING, spr() AS ANY, si)
DECLARE FUNCTION f.main.manhattan (pos1 AS ANY, pos2 AS ANY)
DECLARE FUNCTION f.pcx.getpal (fileName AS STRING, pal AS STRING)
DECLARE FUNCTION f.pcx.load (fileName AS STRING, segBuffer)

'* Constants (Most are self explanatory) ************************************
CONST FALSE = 0, TRUE = NOT FALSE

CONST NUMFONTS = 6 * 16, FONTWID = 7, FONTHITE = 8

CONST MAXGROUPS = 3, MAXTROOPERS = 15, MAXMEN = 100, MAXENEMIES = 64
CONST TURNRATE = 600, NUMRANKS = 18
CONST MAXBULLETS = 256, BULLETRANGE = 100, ENEMYBULLETRANGE = 65
CONST BFRIEND = &H8000, BENEMY = 0, HITRANGE = 12
CONST MAXMAPS = 16

CONST MAXSPRITES = 256, MAXBOBS = 128
CONST SCRX = 16, SCRY = 13, TILESIZE = 16
CONST CLIPSCRX1 = 64, XCENTRE = 128, YCENTRE = 100
CONST MAXVIEW = 140, MAXVIEWSQ = 19600, EMINVIEW = 50

CONST ALPHAG = 0, BETAG = 1, GAMMAG = 2
CONST TSELECTED = 19, TNOTSELECTED = 21

CONST ONGAME = 1, ONMINIMAP = 2

CONST BPASTE = 1, BPUT = 2
CONST SPRPOINT = 0, SPRSHOOT = 1, SPRBULLET = 3, SPRGROUP = 4, SPRLOGO = 5
CONST SPRTROOPER = 2, SPRTILES = 8, SPRMASK = 9, SPRDOODAD = 10
CONST SPRENEMY = 6, SPRRANK = 7

CONST SALIVE = 2, SDYING = 1, SDEAD = 0
CONST TWALK = 1, TSWIM = 2

CONST MAXDOODADS = 64, MAPBORDER = 50

CONST MAXCHANNELS = 16

'* Shared type definitions **************************************************
TYPE PCXHeaderType
   manufacturer      AS STRING * 1
   version           AS STRING * 1
   encoding          AS STRING * 1
   bitsPerPixel      AS STRING * 1
   x                 AS INTEGER
   y                 AS INTEGER
   width             AS INTEGER
   height            AS INTEGER
   horzRes           AS INTEGER
   vertRes           AS INTEGER
   egaPalette        AS STRING * 48
   reserved          AS STRING * 1
   numColorPlanes    AS STRING * 1
   bytesPerLine      AS INTEGER
   paletteType       AS INTEGER
   padding           AS STRING * 58
END TYPE

'* Coordinate type - Makes passing/copying coordinates simpler and makes QB a bit more OOP =)
TYPE pointType
   x                 AS INTEGER
   y                 AS INTEGER
END TYPE

'* Don't think I ever use this type...
TYPE RectType
   ul                AS pointType
   lr                AS pointType
END TYPE

'* Bresenham's algorithm type - Used for finding a straight line between any two points (eg in walking/scrolling/bullets etc)
'* Also used as a better way of drawing lines on the screen than LINE(), because it uses integers (not applied in this program)
TYPE bresType
   dx                AS INTEGER
   dy                AS INTEGER
   incx              AS INTEGER
   incy              AS INTEGER
   erro              AS INTEGER
   count             AS INTEGER
END TYPE

'* Sprites are the actual images you see on the screen. They are stored in XMS
TYPE spriteType
   xmsOffset         AS LONG
   hotspot           AS pointType         '* Handle of sprite (QB's default is (0,0))
   width             AS INTEGER
   hite              AS INTEGER
END TYPE

'* Basic game info - Put together for ease and efficiency
TYPE gameInfoType
   mapSize           AS pointType
   pixMapSize        AS pointType
   
   origTroopers      AS INTEGER        '* Number of men we start out with at start of mission
   origEnemies       AS INTEGER

   numEnemies        AS INTEGER
   numTroopers       AS INTEGER
   numDoodads        AS INTEGER

   name              AS STRING * 32    '* Name of current stage
   difficulty        AS INTEGER
   missionFlags      AS INTEGER        '* bit 0:kill all enemy 1:save civilians 2:destory all buildings

   curMan            AS INTEGER        '* Current bloke we start with
   curMission        AS INTEGER
   curStage          AS INTEGER
   numStages         AS INTEGER
   
   gameLoop          AS INTEGER

   missname          AS STRING * 32

   ebrate            AS INTEGER       '* Enemy difficulty
   ebaccuracy        AS INTEGER
   ebrange           AS INTEGER
   eview             AS INTEGER

   savedpos          AS INTEGER        '* current mission in saved game

   bInvincible        AS INTEGER
END TYPE

TYPE scrType
   pos               AS pointType      '* Offset into map
   cur               AS pointType      '* Current grid offset
   add               AS pointType      '* Offset into current tile
   vadd              AS pointType      '* Current view offset
   bres              AS bresType       '* Scrolling bres type
   accel             AS INTEGER
   fr                AS INTEGER
END TYPE

'* Every bullet on the screen (enemy/friend) is held in one of these, in a queue
TYPE bulletType
   player            AS INTEGER           '* Bit 16:1=friendly bullet 0=enemy
                                          '* Bits 0-15:index of player/enemy this bullet belongs to (used for stMen().kills)
   pos               AS pointType
   bres              AS bresType

   origtile          AS pointType         '* Tile bullet started in
   status            AS INTEGER           '* 0 is dead, 1 is alive, 2 is dying
   dieframe          AS INTEGER
END TYPE

'* Holds info for recruits
TYPE manType
   name              AS STRING * 12
   rank              AS INTEGER
   kills             AS INTEGER
   status            AS INTEGER           '* dead or alive
   missioncount      AS INTEGER           '* How many missions have they survived
END TYPE

'* Used when placing sprites on screen - Only visible bobs are placed down
TYPE bobType
   pos               AS pointType         '* pos on SCREEN!
   flip              AS INTEGER
   spr               AS INTEGER           '* Pointer to the sprite this bob uses
   sprindex          AS INTEGER
   putfirst          AS INTEGER
   scale             AS INTEGER
END TYPE

TYPE enemyType
   pos                  AS pointType
   bres                 AS bresType
   status               AS INTEGER
   fr                   AS INTEGER
   d                    AS INTEGER
   deathfr              AS INTEGER
   dir                  AS INTEGER
   flip                 AS INTEGER
   bdelay               AS INTEGER
   turndelay            AS INTEGER
   walkdelay            AS INTEGER
   inwater              AS INTEGER
END TYPE

'* Determines where players/bullets/enemies can/how they walk on map
TYPE terrainPixelType
   walktype             AS INTEGER        '* 0:nowalk 1:walk 2:swim
   bullet               AS INTEGER        '* Can bullets travel over this
   height               AS INTEGER        '* Adjusts mens y hotspot
END TYPE

'* The men on the current mission (different to manType)
TYPE trooperType
   pos                  AS pointType
   bres(2)              AS bresType
                                          
   group                AS INTEGER        '* Group this trooper belongs to
   dest                 AS pointType
   destnum              AS INTEGER

   index                AS INTEGER        '* Points to mantype
   status               AS INTEGER        '* Alive, dead, dying
   shootwalk            AS INTEGER
   walkdelay            AS INTEGER
   inwater              AS INTEGER

   fr                   AS INTEGER        '* Animation
   d                    AS INTEGER
   deathfr              AS INTEGER
   dir                  AS INTEGER        '* Direction player is facing
   flip                 AS INTEGER        '* Do we need to flip player

   bdelay               AS INTEGER        '* Bullet info
   brate                AS INTEGER
   baccuracy            AS INTEGER
   brange               AS INTEGER
   autofire             AS INTEGER
   autodest             AS pointType

   selected             AS INTEGER        '* used when transferring groups
END TYPE

TYPE doodadType
   pos                  AS pointType
   frame                AS INTEGER
END TYPE

'* BWSB Objects declerations
TYPE MSEConfigFile
  SoundCard     AS INTEGER
  BaseIO        AS INTEGER
  IRQ           AS INTEGER
  DMA           AS INTEGER
  SoundQuality  AS INTEGER
END TYPE

COMMON SHARED curXMS AS LONG
COMMON SHARED stSprite() AS spriteType
COMMON SHARED stBob()  AS bobType, iBobNum
COMMON SHARED stScr AS scrType
COMMON SHARED iSprBuffer()
COMMON SHARED strFont AS STRING * 5376
COMMON SHARED iFontWidth()

COMMON SHARED pWork AS pointType, ax, bx, ecx AS LONG    '* Working variables, used when a descriptive variable is not necessary, or for temporary value holders

