'****************************************************************************
'* TROOPERS.BAS
'* A Cannon Fodder style game in QB
'* Version 0.5
'****************************************************************************
'* Coded by Ben Bosco of Aspect Productions
'****************************************************************************
'* See TRPRS.BI for more detailed descriptions of user defined types
'****************************************************************************

'$INCLUDE: 'SOURCE\_LIB.BI'
'$INCLUDE: 'SOURCE\TRPRS.BI'

'* BWSB Include files (not included with source)
'$INCLUDE: 'SOURCE\BWSB.BI'
'$INCLUDE: 'SOURCE\GDMTYPE.BI'


'* Global Variables
DIM SHARED stSprite(MAXSPRITES) AS spriteType   '* The image data of sprites
DIM SHARED stBob(MAXBOBS) AS bobType            '* Bobs: See programming info
DIM SHARED iSprBuffer(2048)                     '* Global buffer to store sprites

'* Variables local to main module
DIM SHARED strPal AS STRING * 768
DIM SHARED stDoodad(MAXDOODADS) AS doodadType
DIM SHARED strMask AS STRING * 256              '* Used to store current map tile mask
DIM SHARED stTerrainPix(2) AS terrainPixelType  '* Info about pixels on map
DIM SHARED stMen(MAXMEN) AS manType             '* All the men in game (not the men on the current mission tho)
DIM SHARED strRank(NUMRANKS) AS STRING
DIM SHARED iLeader(MAXGROUPS)                   '* Leader of each group
DIM SHARED iCurGroup                            '* Current group player has control of
DIM SHARED iGroupSize(MAXGROUPS)                '* Size of each group
DIM SHARED stTrooper(MAXTROOPERS) AS trooperType'* Used to control men in current mission
DIM SHARED stEnemy(MAXENEMIES) AS enemyType     '* Enemies on the level
DIM SHARED stBullet(MAXBULLETS) AS bulletType   '* All bullets on level (friendly/enemy)
DIM SHARED iBulHead, iBulTail                   '* Keeps track of bullet queue

DIM SHARED MONSCREEN, SCROVERRIDE               '* Scrolling booleans
DIM SHARED bInvalidateSideBar                   '* updateSideBar() is called if this is TRUE
DIM SHARED pMS AS pointType, iMSB               '* Global mouse info
DIM SHARED iPointer, LMDOWN, LMFLAG
DIM SHARED iFontWidth(NUMFONTS)                 '* Width of each font
DIM SHARED strKeyShift AS STRING * 128
DIM SHARED strKeyNoShift AS STRING * 128

DIM SHARED bVictoryStatus                       '* 0=playing 1=won 2=lost
DIM SHARED iEndDelay

DIM SHARED stGameInfo AS gameInfoType           '* Stores basic game info
DIM SHARED iMap(1, 1)                           '* Dynamically redimensioned to suit map size

DIM SHARED curMsg$, iCurMsgDelay                '* Current on screen message
DIM SHARED lmaindataXMS AS LONG
DIM SHARED lOffset&(MAXMAPS), curMission$, bEnterMenu

DIM iBuffer(32000)                              '* The double buffer of the screen. Note: VARPTR(Buffer(0)) is always 0.
DIM iSideBar(CLIPSCRX1 * 200 \ 2)               '* The sidebar graphic
DIM i, f$                                       '* Oh...you know...things
DIM bFadeGameIn

'* BWSB Variables
DIM SHARED ModHead         AS GDMHeader         '* Module Header
DIM SHARED MSEConfig       AS MSEConfigFile     '* Structure of MSE configuration file
DIM SHARED curChannel, bBWSBInstalled

'ON ERROR GOTO ErrorHandler
RESTORE errData
READ ax: DIM SHARED strError(ax) AS STRING: DIM SHARED strErrorAdd AS STRING
FOR i = 0 TO ax - 1: READ strError(i): NEXT i

FreeMem& = FRE(-1) - 80000                      '* Basic Heap - EXE Memory (80000)
BWSBMem& = SETMEM(-FreeMem&)                    '* This is the memory freed for module
                                                '* and MSE usage.

ax = f.main.init
lmaindataXMS = curXMS
IF ax THEN s.main.shutdown strError(ax - 1) + strErrorAdd

s.main.intro VARSEG(iBuffer(0)), VARPTR(iBuffer(0))
s.main.newgame

'* Put the mouse in viewport centre
lhz.setmouse CLIPSCRX1 + XCENTRE, YCENTRE
bEnterMenu = TRUE

DO
   IF bEnterMenu THEN s.main.menu VARSEG(iBuffer(0)), VARPTR(iBuffer(0))

   IF NOT f.main.loadmap(curMission$) THEN s.main.shutdown strError(0) + curMission$
   s.main.intermediate VARSEG(iBuffer(0)), VARPTR(iBuffer(0))

   '* Only jungle tileset is available, otherwise different tilesets would be
   '* checked for
   RESTORE jungleFileData
   READ f$
   curXMS = lmaindataXMS
   IF NOT f.pcx.getpal(f$, strPal) THEN s.main.shutdown strError(0) + f$
   FOR i = 0 TO 2
      READ f$, ax
      IF NOT f.main.loadspritebank(f$, stSprite(), ax) THEN s.main.shutdown strError(0) + f$
   NEXT i

   '* Info set when a new stage is started *************************************
   s.sound.loadsong "SOUND\SOUNDS.GDM"

   iPointer = SPRPOINT
   iBulHead = 0: iBulTail = 0

   lhz.setBufferWidth 320
   bInvalidateSideBar = TRUE
   stScr.pos.x = stTrooper(iLeader(iCurGroup)).pos.x - XCENTRE
   stScr.pos.y = stTrooper(iLeader(iCurGroup)).pos.y - 100
   stGameInfo.gameLoop = ONGAME

   stGameInfo.bInvincible = FALSE
   LMFLAG = FALSE
   bFadeGameIn = TRUE: bVictoryStatus = 0
   iEndDelay = 400
   DO
      pMS.x = lhz.mousex: pMS.y = lhz.mousey
      iMSB = lhz.mouseb

      IF iMSB = 1 THEN
         IF LMDOWN THEN LMFLAG = FALSE:  ELSE LMFLAG = TRUE
         LMDOWN = TRUE
      ELSE
          LMDOWN = FALSE
      END IF

      SELECT CASE stGameInfo.gameLoop
         CASE ONGAME
            s.main.gameloop VARSEG(iBuffer(0)), VARPTR(iBuffer(0)), VARSEG(iSideBar(0)), VARPTR(iSideBar(0))
         CASE ONMINIMAP
            s.main.minimap VARSEG(iBuffer(0)), VARPTR(iBuffer(0)), VARSEG(iSideBar(0)), VARPTR(iSideBar(0))
      END SELECT

      '* Then the mouse pointer
      s.bob.put VARSEG(iBuffer(0)), 0, pMS.x, pMS.y, iPointer, 0, BPUT, FALSE, 100

      '* Wait until screen is in refresh state
      lhz.waitvbl

      '* Copy Buffer to screen (for flicker free graphics)
      lhz.memcopy VARSEG(iBuffer(0)), 0, &HA000, 0, 64000

      IF bFadeGameIn THEN
         s.graph.fadetopal STRING$(768, 0), strPal, 0, 0, 255
         bFadeGameIn = FALSE
      END IF
   LOOP UNTIL iEndDelay <= 0
   s.graph.fadetocol strPal, 0, 0, 0, 0, 0, 255
   
   IF bVictoryStatus = 1 THEN
      stGameInfo.curStage = stGameInfo.curStage + 1
      IF stGameInfo.curStage = stGameInfo.numStages THEN
         bEnterMenu = TRUE
         stGameInfo.curMission = stGameInfo.curMission + 1
         stGameInfo.curStage = 0
      END IF
      FOR i = 0 TO stGameInfo.origTroopers - 1
         IF stTrooper(i).status = SALIVE THEN
            stMen(stTrooper(i).index).rank = stMen(stTrooper(i).index).rank + 1
            IF stMen(stTrooper(i).index).rank > 17 THEN stMen(stTrooper(i).index).rank = 17
         END IF
      NEXT i
   END IF
LOOP

'* Shutdown the program *****************************************************
s.main.shutdown ""

errData:
DATA 1
DATA "Cannot find File - "

fileData:
DATA "gfx\pointer.spr", 0
DATA "gfx\shoot.spr", 1
DATA "gfx\trooper.spr", 2
DATA "gfx\shot.spr", 3
DATA "gfx\group.spr", 4
DATA "gfx\logo.spr", 5
DATA "gfx\enemy.spr", 6
DATA "gfx\rank.spr", 7

jungleFileData:
DATA "gfx\junpal.pcx"
DATA "gfx\jungle.trn", 8
DATA "gfx\jungle.msk", 9
DATA "gfx\jungle.dod", 10

names:
DATA 56
DATA "Alfred", "Rutger", "Louis", "Barbara", "George", "Flo", "Bosco", "BB"
DATA "Steve", "Max", "Parker", "Lentle", "Dixie", "Sonny", "Jim", "Grendon"
DATA "Bob", "Disco", "Mary", "Little Joe", "Horace", "Brooder", "Hector", "Nit"
DATA "Wasp", "Benny", "Zeppa", "Leroy","Amos", "Olmos", "Harris", "Wolfgang"
DATA "Jimmy", "Robby", "Silky", "Flaky", "Browno", "Fonzo", "Mavis", "Jus"
DATA "Lemer", "Skinner", "Kay", "Russ", "Geoff", "Fred", "Gunner", "Clark"
DATA "Toni", "Marshall", "Private", "Duncan", "Mellow Boy", "Blade", "Denzil", "Opa"

rankData:
DATA "Private", "Lance Corporal", "Corporal", "Sergeant", "Staff Sergeant"
DATA "Warrant Officer II", "Warrant Officer I", "2nd Lieutenant"
DATA "Lieutenant", "Captain", "Major", "Lieutenant Colonel", "Colonel"
DATA "Brigadier", "Major General", "Lieutenant General", "General"
DATA "Field Marshall"

terrainData:
'* walktype, bullet, height
DATA 0, 0, 0
DATA 1, 1, 0
DATA 2, 1, 0

BWSBCardData:
DATA "GUS", "SB1X", "SB2X", "SBPRO", "SB16", "PAS"

scanCodeData:
DATA " 1234567890-=  qwertyuiop[]  asdfghjkl;'` \zxcvbnm,./ *                                                                         "
DATA " !@#$%^&*()_+  QWERTYUIOP{}  ASDFGHJKL:c~ |ZXCVBNM<>?                                                                           "


ErrorHandler:
CLOSE
strErrorAdd = STR$(ERR)
SELECT CASE ERR
   CASE 76
      strErrorAdd = "Path not found."
   CASE ELSE
      strErrorAdd = LTRIM$(STR$(ERR))
END SELECT
s.main.shutdown "ERROR: " + strErrorAdd

REM $DYNAMIC
'****************************************************************************
'* Uses rough trigonomety to determine direction number for men
'****************************************************************************
FUNCTION f.main.finddir (iDx, iDy)
   DIM sWork AS SINGLE, iDir

   SELECT CASE iDy
      CASE 0
         IF iDx > 0 THEN iDir = 2 ELSE iDir = 6
      CASE IS < 0
         sWork = ABS(iDx / iDy)
         SELECT CASE sWork
            CASE IS <= .41
               iDir = 0
            CASE IS <= 2.41
               IF iDx > 0 THEN iDir = 1 ELSE iDir = 5
            CASE ELSE
               IF iDx > 0 THEN iDir = 2 ELSE iDir = 6
         END SELECT
      CASE IS > 0
         sWork = ABS(iDx / iDy)
         SELECT CASE sWork
            CASE IS <= .41
               iDir = 4
            CASE IS <= 2.41
               IF iDx > 0 THEN iDir = 3 ELSE iDir = 7
            CASE ELSE
               IF iDx > 0 THEN iDir = 2 ELSE iDir = 6
         END SELECT

   END SELECT

   f.main.finddir = iDir
END FUNCTION

'****************************************************************************
'* Initializes all hardware stuff and basic game info
'****************************************************************************
FUNCTION f.main.init
   DIM i
   DIM SndDevMSE(6)    AS STRING                '* Array of MSE file names

   f.main.init = 0      '* Assume success

   '* Initialize the lhz _LIB library ******************************************
   ax = lhz.init(0, 400, MOUSE OR KEYBOARD)   '* No EMS, 60kb XMS and mouse routine
   IF ax THEN s.main.shutdown "Initialization error code" + STR$(ax) + "!"
   
   ff = FREEFILE
   OPEN "SOUND\MSE.CFG" FOR BINARY AS ff
      GET ff, , MSEConfig
   CLOSE ff
   bBWSBInstalled = FALSE
   IF MSEConfig.SoundCard = 0 THEN s.main.shutdown "No Sound Selected in setup. Please run SETUP.BAT."
   bBWSBInstalled = TRUE

   RESTORE BWSBCardData
   FOR i = 1 TO 6
      READ SndDevMSE(i)
   NEXT i

   MSE$ = "SOUND\" + SndDevMSE(MSEConfig.SoundCard) + ".MSE"

   SELECT CASE MSEConfig.SoundQuality
   CASE 0: ov = 16
   CASE 1: ov = 22
   CASE 2: ov = 45
   CASE 3: ov = 8
   END SELECT

   'Set up our sound system:
   ErrorFlag = LoadMSE(MSE$, 0, ov, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)

   strErrorAdd = ""
   SELECT CASE ErrorFlag
   CASE 0
   CASE 1: strErrorAdd = "Base I/O address autodetection failure"
   CASE 2: strErrorAdd = "IRQ level autodetection failure"
   CASE 3: strErrorAdd = "DMA channel autodetection failure"
   CASE 4: strErrorAdd = "DMA channel not supported"
   CASE 6: strErrorAdd = "Sound device does not respond"
   CASE 7: strErrorAdd = "Memory control blocks destroyed"
   CASE 8: strErrorAdd = "Insufficient memory for mixing buffers"
   CASE 9: strErrorAdd = "Insufficient memory for MSE file"
   CASE 10: strErrorAdd = "MSE has invalid identification string (corrupt/non-existant)"
   CASE 11: strErrorAdd = "MSE disk read failure"
   CASE 12: strErrorAdd = "MVSOUND.SYS not loaded (required for PAS use)"
   CASE ELSE: strErrorAdd = "Unknown error on MSE startup" + STR$(ErrorFlag)
   END SELECT
   IF LEN(strErrorAdd) THEN s.main.shutdown strErrorAdd

   RANDOMIZE TIMER

   '* Read names of all of the men
   RESTORE names
   READ ax
   FOR i = 0 TO ax - 1
      READ stMen(i).name
   NEXT i

   RESTORE rankData
   FOR i = 0 TO NUMRANKS - 1: READ strRank(i): NEXT

   RESTORE terrainData
   FOR i = 0 TO 2
      READ stTerrainPix(i).walktype
      READ stTerrainPix(i).bullet
      READ stTerrainPix(i).height
   NEXT i

   strErrorAdd = "gfx\wire.fnt"
   IF NOT f.font.load(strErrorAdd) THEN
      f.main.init = 1: EXIT FUNCTION
   END IF

   RESTORE fileData
   FOR i = 0 TO 7
      READ strErrorAdd, ax    '* Read name of file, and which sprite index it has
      IF NOT f.main.loadspritebank(strErrorAdd, stSprite(), ax) THEN
         f.main.init = 1: EXIT FUNCTION
      END IF
   NEXT i

   RESTORE scanCodeData
   READ strKeyShift
   READ strKeyNoShift

   '* Default game info

   lhz.scr &H13
END FUNCTION

'****************************************************************************
'* Loads a map, and sets up all default game info
'****************************************************************************
FUNCTION f.main.loadmap (strFileName AS STRING)
   DIM strF AS STRING * 5, i

   ff = FREEFILE
   f.main.loadmap = TRUE

   OPEN strFileName FOR BINARY AS ff
      GET ff, lOffset&(stGameInfo.curStage), stGameInfo.name
      GET ff, , stGameInfo.missionFlags   '* gameflags (ie. destroy enemy/enemy building
      GET ff, , stGameInfo.difficulty
      IF stGameInfo.difficulty > 18 THEN stGameInfo.difficulty = 18

      GET ff, , stGameInfo.mapSize

      's.main.shutdown stGameInfo.name + STR$(stGameInfo.mapSize.x) + STR$(stGameInfo.mapSize.y)
      REDIM iMap(stGameInfo.mapSize.x, stGameInfo.mapSize.y)
      
      GET ff, , i                      '* tileset
      GET ff, , stGameInfo.origTroopers
      GET ff, , stGameInfo.origEnemies
      GET ff, , stGameInfo.numDoodads  '* doodads

      IF stGameInfo.origTroopers > 0 THEN
         FOR i = 0 TO stGameInfo.origTroopers - 1
            GET ff, , stTrooper(i).pos
            stTrooper(i).status = SALIVE
         NEXT i
      END IF
      IF stGameInfo.origEnemies > 0 THEN
         FOR i = 0 TO stGameInfo.origEnemies - 1
            GET ff, , stEnemy(i).pos
            stEnemy(i).status = SALIVE
            stEnemy(i).dir = INT(RND * 8)
         NEXT i
      END IF
      IF stGameInfo.numDoodads > 0 THEN
         FOR i = 0 TO stGameInfo.numDoodads - 1
            GET ff, , stDoodad(i).pos
            GET ff, , stDoodad(i).frame
         NEXT i
      END IF
      
      FOR y = 0 TO stGameInfo.mapSize.y - 1
         FOR x = 0 TO stGameInfo.mapSize.x - 1
            GET ff, , iMap(x, y)
         NEXT x
      NEXT y
   CLOSE ff

   stGameInfo.pixMapSize.x = stGameInfo.mapSize.x * TILESIZE: stGameInfo.pixMapSize.y = stGameInfo.mapSize.y * TILESIZE
   stGameInfo.numTroopers = stGameInfo.origTroopers
   stGameInfo.numEnemies = stGameInfo.origEnemies

   iCurGroup = 0
   iLeader(0) = 0: iLeader(1) = 0: iLeader(2) = 0
   iGroupSize(0) = stGameInfo.origTroopers
   iGroupSize(1) = 0: iGroupSize(2) = 0

   oldcx = 0
   FOR i = 0 TO stGameInfo.origTroopers - 1
      stTrooper(i).group = 0: stTrooper(i).selected = TNOTSELECTED
      stTrooper(i).destnum = 0: stTrooper(i).shootwalk = FALSE
      stTrooper(i).bres(0).count = 0
      stTrooper(i).inwater = FALSE: stTrooper(i).deathfr = 0
      stTrooper(i).d = 0
      
      FOR cx = oldcx TO MAXMEN - 1
         IF stMen(cx).status = SALIVE THEN
            stTrooper(i).index = cx
            oldcx = cx + 1
            EXIT FOR
         END IF
      NEXT cx
      stTrooper(i).brate = 16 - stMen(stTrooper(i).index).rank / 1.8
      stTrooper(i).bdelay = INT(RND * stTrooper(i).brate)
      stTrooper(i).baccuracy = 10 - (stMen(stTrooper(i).index).rank \ 2)
      stTrooper(i).brange = BULLETRANGE + stMen(stTrooper(i).index).rank * 3
   NEXT i

   FOR i = 0 TO stGameInfo.origEnemies
      stEnemy(i).d = 0: stEnemy(i).inwater = FALSE
      stEnemy(i).deathfr = 0: stEnemy(i).bres.count = 0
      stEnemy(i).bdelay = 0
      stEnemy(i).turndelay = INT(RND * TURNRATE)
   NEXT i
   
   stGameInfo.difficulty = 5
   stGameInfo.ebrate = 20 - stGameInfo.difficulty / 1.8
   stGameInfo.eview = (ENEMYBULLETRANGE * 1.5) + stGameInfo.difficulty * 3.5
   stGameInfo.ebrange = ENEMYBULLETRANGE + stGameInfo.difficulty * 3
   stGameInfo.ebaccuracy = 20 - stGameInfo.difficulty

   FOR i = 0 TO MAXBULLETS - 1
      stBullet(i).status = 0
   NEXT i
END FUNCTION

REM $STATIC
'****************************************************************************
' * Sets up everything for a new mission (each mission has several stages,
' * see f.main.loadmap())
'****************************************************************************
FUNCTION f.main.loadmission (strFileName AS STRING)
   DIM w$, ff, l&

   ff = FREEFILE
   f.main.loadmission = TRUE
   OPEN strFileName FOR BINARY AS ff: l& = LOF(ff): CLOSE ff
   IF l& = 0 THEN
      KILL strFileName
      f.main.loadmission = FALSE
      EXIT FUNCTION
   END IF

   OPEN strFileName FOR BINARY AS ff
      w$ = SPACE$(9)
      GET ff, , w$
      IF w$ <> "TRPRMISS" THEN
         f.main.loadmission = FALSE
         EXIT FUNCTION
      END IF
      
      GET ff, , stGameInfo.missName
      GET ff, , stGameInfo.numStages
      FOR i = 0 TO stGameInfo.numStages - 1
         GET ff, , lOffset&(i)
      NEXT i
   CLOSE ff

END FUNCTION

REM $DYNAMIC
'****************************************************************************
'* A faster way of finding a distance between two points without using the
'* SQR() function which is slow. This function is about 15% accurate, and
'* uses Taylor's series for the sqrt function.
'****************************************************************************
FUNCTION f.main.manhattan (pos1 AS pointType, pos2 AS pointType)
   DIM iDx, iDy
   iDx = ABS(pos1.x - pos2.x)
   iDy = ABS(pos1.y - pos2.y)
   IF iDx < iDy THEN
      f.main.manhattan = iDx \ 2 + iDy
   ELSE
      f.main.manhattan = iDx + iDy \ 2
   END IF
END FUNCTION

'****************************************************************************
'* Bresenham's algorithm is an integer based line drawing algorithm, but it
'* is used in this game for such things as walking/scrolling between two
'* points in a straight line.
'****************************************************************************
SUB s.bres.set (bres AS bresType, maxCount)
   DIM t AS LONG, scrDist AS DOUBLE

   IF maxCount <> -1 THEN
      t = 1& * bres.dx * bres.dx + 1& * bres.dy * bres.dy + 1
      scrDist = maxCount / SQR(t)
      bres.dx = bres.dx * scrDist
      bres.dy = bres.dy * scrDist
   END IF

   IF bres.dx >= 0 THEN
      bres.incx = 1
   ELSE
      bres.incx = -1
      bres.dx = -bres.dx
   END IF
   IF bres.dy >= 0 THEN
      bres.incy = 1
   ELSE
      bres.incy = -1
      bres.dy = -bres.dy
   END IF

   IF bres.dx > bres.dy THEN
      bres.count = bres.dx + 1
   ELSE
      bres.count = bres.dy + 1
   END IF
END SUB

'****************************************************************************
'* Uses bresenham's algorithm to update info in brestype
'****************************************************************************
SUB s.bres.update (bres AS bresType, incx, incy, loops)
   DIM i

   incx = 0: incy = 0
   FOR i = 0 TO loops
      IF bres.dx > bres.dy THEN
         bres.erro = bres.erro + bres.dy
         IF bres.erro > bres.dx THEN
            bres.erro = bres.erro - bres.dx
            incy = incy + bres.incy
         END IF
         incx = incx + bres.incx
      ELSE
         bres.erro = bres.erro + bres.dx
         IF bres.erro > 0 THEN
            bres.erro = bres.erro - bres.dy
            incx = incx + bres.incx
         END IF
         incy = incy + bres.incy
      END IF
      bres.count = bres.count - 1
      IF bres.count < 0 THEN
         bres.count = 0
         EXIT FOR
      END IF
   NEXT i
END SUB

'****************************************************************************
'* Adds a bullet to the bullet queue
'****************************************************************************
SUB s.bullets.add (spos AS pointType, dx, dy, rndDisp, ForEn, range)
   stBullet(iBulTail).status = 1
   stBullet(iBulTail).dieframe = 0
   stBullet(iBulTail).pos.x = spos.x
   stBullet(iBulTail).pos.y = spos.y - 7
   stBullet(iBulTail).origtile.x = spos.x \ TILESIZE
   stBullet(iBulTail).origtile.y = (spos.y - 7) \ TILESIZE
   IF RND < .5 THEN t = -1 ELSE t = 1
   stBullet(iBulTail).bres.dx = dx + INT(RND * rndDisp) * t
   IF RND < .5 THEN t = -1 ELSE t = 1
   stBullet(iBulTail).bres.dy = dy + INT(RND * rndDisp) * t
   
   stBullet(iBulTail).player = ForEn
   s.bres.set stBullet(iBulTail).bres, range
   
   IF iBulTail + 1 = iBulHead THEN
      '* Oops! Ran out of bullets!
   ELSE
      iBulTail = iBulTail + 1
   END IF
   
   IF iBulTail = MAXBULLETS THEN iBulTail = 0
END SUB

'****************************************************************************
'* Handles the queue of bullets in the game
'****************************************************************************
SUB s.bullets.update (destBuffer, destOff)
   DIM i, ii

   i = iBulHead
   DO
      SELECT CASE stBullet(i).status
      CASE 1   '* bullet is moving ******************************************
         s.bres.update stBullet(i).bres, incx, incy, 2
         IF stBullet(i).pos.x + incx < 0 THEN stBullet(i).bres.count = 0: stBullet(i).status = 0
         IF stBullet(i).pos.y + incy < 0 THEN stBullet(i).bres.count = 0: stBullet(i).status = 0
         IF stBullet(i).pos.x + incx > stGameInfo.pixMapSize.x - 1 THEN stBullet(i).bres.count = 0: stBullet(i).status = 0
         IF stBullet(i).pos.y + incy > stGameInfo.pixMapSize.y - 1 THEN stBullet(i).bres.count = 0: stBullet(i).status = 0

         IF stBullet(i).bres.count > 0 THEN
            s.main.getmask SPRMASK, (stBullet(i).pos.x + incx) \ TILESIZE, (stBullet(i).pos.y + incy) \ TILESIZE

            curpix = ASC(MID$(strMask, ((stBullet(i).pos.y + incy) MOD TILESIZE) * TILESIZE + ((stBullet(i).pos.x + incx) MOD TILESIZE) + 1, 1))
            IF stTerrainPix(curpix).bullet OR (stBullet(i).pos.x \ TILESIZE = stBullet(i).origtile.x AND stBullet(i).pos.y \ TILESIZE = stBullet(i).origtile.y) THEN
               stBullet(i).pos.x = stBullet(i).pos.x + incx
               stBullet(i).pos.y = stBullet(i).pos.y + incy
            ELSE
               stBullet(i).status = 2
            END IF

            lhz.plot destBuffer, destOff, stBullet(i).pos.x - stScr.pos.x + CLIPSCRX1, stBullet(i).pos.y - stScr.pos.y, 31
            lhz.plot destBuffer, destOff, stBullet(i).pos.x - stScr.pos.x + CLIPSCRX1 + 2, stBullet(i).pos.y - stScr.pos.y + 5, 0

            FOR ii = 0 TO stGameInfo.origEnemies - 1
               IF stEnemy(ii).status = SALIVE AND (stBullet(i).player AND BFRIEND) THEN
                  pWork = stEnemy(ii).pos
                  pWork.y = pWork.y - 8
                  buldis = f.main.manhattan(stBullet(i).pos, pWork)
                  IF buldis <= HITRANGE THEN
                     stBullet(i).status = 2
                     stEnemy(ii).status = SDYING
                     stGameInfo.numEnemies = stGameInfo.numEnemies - 1
                     s.sound.playsample 1, 8000, -1, -1
                     ax = stTrooper(stBullet(i).player XOR &H8000).index
                     stMen(ax).kills = stMen(ax).kills + 1
                     IF stMen(ax).kills > 32000 THEN stMen(ax).kills = 32000 '* Well...it could happen =)
                     EXIT FOR
                  END IF
               END IF
            NEXT ii
            
            '* Player can only get hit if this bullet hits them 'on target'
            IF stBullet(i).bres.count < 5 THEN
            FOR ii = 0 TO stGameInfo.origTroopers - 1
               IF stTrooper(ii).status = SALIVE AND NOT (stBullet(i).player AND BFRIEND) AND NOT stGameInfo.bInvincible THEN
                  pWork = stTrooper(ii).pos
                  pWork.y = pWork.y - 8
                  buldis = f.main.manhattan(stBullet(i).pos, pWork)
                  IF buldis <= HITRANGE THEN
                     stBullet(i).status = 2
                     stTrooper(ii).status = SDYING
                     stTrooper(ii).selected = TNOTSELECTED
                     curTrpr = iLeader(iCurGroup)
                     stGameInfo.numTroopers = stGameInfo.numTroopers - 1
                     iGroupSize(stTrooper(ii).group) = iGroupSize(stTrooper(ii).group) - 1
                     IF iGroupSize(stTrooper(ii).group) = 0 THEN
                        FOR g = 0 TO MAXGROUPS - 1
                           IF iGroupSize(g) > 0 THEN
                              iCurGroup = g
                              EXIT FOR
                           END IF
                        NEXT g
                     END IF
                     s.troopers.updateleader iCurGroup, curTrpr

                     bInvalidateSideBar = TRUE
                     s.sound.playsample 1, 7000, -1, -1
                     EXIT FOR
                  END IF
               END IF
            NEXT ii
            END IF
         ELSE
            IF stBullet(i).status = 1 THEN stBullet(i).status = 2
         END IF
      CASE 2   '* bullet is dying *******************************************
         s.bob.put destBuffer, destOff, stBullet(i).pos.x - stScr.pos.x + CLIPSCRX1, stBullet(i).pos.y - stScr.pos.y, SPRBULLET, stBullet(i).dieframe, BPUT, FALSE, 100
         stBullet(i).dieframe = stBullet(i).dieframe + 1
         IF stBullet(i).dieframe > 2 THEN
            stBullet(i).status = 0
         END IF
      CASE 0   '* bullet is dead ********************************************
         IF i = iBulHead THEN
            iBulHead = iBulHead + 1
            IF iBulHead = MAXBULLETS THEN iBulHead = 0
         END IF
      END SELECT
      i = i + 1
      IF i = MAXBULLETS THEN i = 0
   LOOP UNTIL i = iBulTail

END SUB

'****************************************************************************
'* Updates doodads (trees, bushes, bobs that aren't part of background
'****************************************************************************
SUB s.doodads.update
   DIM i

   FOR i = 0 TO stGameInfo.numDoodads - 1
      s.bob.add stDoodad(i).pos.x, stDoodad(i).pos.y, SPRDOODAD, stDoodad(i).frame, FALSE, FALSE
   NEXT i
END SUB

'****************************************************************************
' Handles all enemies in the game.
'****************************************************************************
SUB s.enemy.update
   DIM en AS enemyType, curscan
   DIM curdist, curpix, i

   FOR i = 0 TO stGameInfo.origEnemies - 1
   en = stEnemy(i)         '* This makes things easier...
   SELECT CASE en.status
   CASE SALIVE
      curscan = -1
      '* Scan for any player using manhatten distance
      FOR ii = 0 TO stGameInfo.origTroopers - 1
         IF stTrooper(ii).status = SALIVE THEN
            curdist = f.main.manhattan(en.pos, stTrooper(ii).pos)
            IF curdist <= stGameInfo.eview THEN
               '* Set uncontrolled units to fire at this enemy
               IF stTrooper(ii).group <> iCurGroup THEN
                  stTrooper(ii).autofire = TRUE
                  stTrooper(ii).autodest = en.pos
               END IF
               '* can enemy SEE the player?
               en.bres.dx = stTrooper(ii).pos.x - en.pos.x
               en.bres.dy = stTrooper(ii).pos.y - en.pos.y
               s.bres.set en.bres, -1
               pWork = en.pos: canseeplayer = TRUE
               DO
                  s.bres.update en.bres, incx, incy, 4

                  s.main.getmask SPRMASK, pWork.x \ TILESIZE, pWork.y \ TILESIZE
                  ax = (pWork.y MOD TILESIZE) * TILESIZE + (pWork.x MOD TILESIZE) + 1
                  curpix = ASC(MID$(strMask, ax, 1))
                  IF stTerrainPix(curpix).walktype <> 0 THEN
                     pWork.x = pWork.x + incx
                     pWork.y = pWork.y + incy
                     IF pWork.x < 0 THEN pWork.x = 0
                     IF pWork.y < 0 THEN pWork.y = 0
                     IF pWork.x > stGameInfo.pixMapSize.x - 1 THEN pWork.x = stGameInfo.pixMapSize.x - 1
                     IF pWork.y > stGameInfo.pixMapSize.y - 1 THEN pWork.y = stGameInfo.pixMapSize.y - 1
                  ELSE
                     canseeplayer = FALSE
                     EXIT DO
                  END IF
               LOOP UNTIL en.bres.count <= 0
               IF canseeplayer THEN
                  curscan = ii
                  IF en.bdelay = stGameInfo.ebrate THEN en.bdelay = 0
               END IF
            END IF
         END IF
      NEXT ii

      '* Enemy Shooting ***********************************************************
      en.bdelay = en.bdelay + 1
      IF en.bdelay > stGameInfo.ebrate THEN en.bdelay = stGameInfo.ebrate
         ' first enemy detected is target
         IF curscan <> -1 THEN
            IF en.bdelay = stGameInfo.ebrate AND NOT en.inwater THEN
               '* Add a bullet to the queue
               s.bullets.add en.pos, stTrooper(curscan).pos.x - en.pos.x, 7 + stTrooper(curscan).pos.y - en.pos.y, stGameInfo.ebaccuracy, BENEMY OR i, -1
               s.sound.playsample 0, -1, -1, -1
               en.bdelay = 0
            END IF
         END IF

      '* Start walking towards player if visible and within range
      IF curscan <> -1 AND curdist >= EMINVIEW THEN
         en.bres.dx = stTrooper(curscan).pos.x - en.pos.x
         en.bres.dy = stTrooper(curscan).pos.y - en.pos.y
         s.bres.set en.bres, curdist - EMINVIEW
      END IF
   

      '* Trooper Walking **********************************************************
         incx = 0: incy = 0
         en.walkdelay = en.walkdelay + 1
         IF en.walkdelay > 6 OR (NOT en.inwater AND en.walkdelay > 1) THEN
            en.walkdelay = 0
            s.bres.update en.bres, incx, incy, 0
         END IF
         IF en.bres.count > 0 THEN
            s.main.getmask SPRMASK, (en.pos.x + incx) \ TILESIZE, (en.pos.y + incy) \ TILESIZE
            curpix = ASC(MID$(strMask, ((en.pos.y + incy) MOD TILESIZE) * TILESIZE + ((en.pos.x + incx) MOD TILESIZE) + 1, 1))
            IF stTerrainPix(curpix).walktype <> 0 THEN
               en.pos.x = en.pos.x + incx
               en.pos.y = en.pos.y + incy
               IF en.pos.x > stGameInfo.pixMapSize.x - 1 THEN en.pos.x = stGameInfo.pixMapSize.x - 1
               IF en.pos.y > stGameInfo.pixMapSize.y - 1 THEN en.pos.y = stGameInfo.pixMapSize.y - 1
               IF en.pos.x < 0 THEN en.pos.x = 0
               IF en.pos.y < 0 THEN en.pos.y = 0
            ELSE
               en.bres.count = 0
            END IF
            IF stTerrainPix(curpix).walktype = TSWIM THEN
               IF en.inwater = FALSE THEN
                  en.fr = 0: en.walkdelay = 0
               END IF
               en.inwater = TRUE
            ELSE
               en.inwater = FALSE
            END IF
         END IF

         '* Animation
         en.d = en.d + 1
         IF en.inwater THEN
            IF en.d > 8 THEN
               en.d = 0
               en.fr = en.fr + 1
               IF en.fr > 1 THEN
                  en.fr = 0
               END IF
            END IF
         ELSE
            IF en.d > 4 THEN
               en.d = 0
               en.fr = en.fr + 1
               IF en.fr > 7 THEN
                  en.fr = 0
               END IF
            END IF
            IF en.bres.count <= 0 THEN en.fr = 0
         END IF
         
         '* Direction is either random TURNING or that of scanned player->this
         IF curscan <> -1 THEN
            en.dir = f.main.finddir(stTrooper(curscan).pos.x - en.pos.x, stTrooper(curscan).pos.y - en.pos.y)
         ELSE
            en.turndelay = en.turndelay + 1
            IF en.turndelay > TURNRATE THEN
               en.turndelay = 0
               IF RND < .5 THEN
                  en.dir = en.dir - 1
               ELSE
                  en.dir = en.dir + 1
               END IF
               IF en.dir < 0 THEN en.dir = 7
               IF en.dir > 7 THEN en.dir = 0
            END IF
         END IF

         '* Flip man sprite if necessary
         en.flip = FALSE
         tdir = en.dir
         IF tdir > 4 THEN
            tdir = tdir - 4
            en.flip = TRUE
         END IF
         IF en.inwater THEN
            s.bob.add en.pos.x, en.pos.y, SPRENEMY, en.fr + tdir * 2 + 48, en.flip, FALSE
         ELSE
            s.bob.add en.pos.x, en.pos.y, SPRENEMY, en.fr + tdir * 8, en.flip, FALSE
         END IF
   CASE SDYING
      en.d = en.d + 1
      IF en.d > 4 THEN
         en.d = 0
         en.deathfr = en.deathfr + 1
         IF en.deathfr > 2 THEN
            en.status = SDEAD
            IF stGameInfo.numEnemies = 0 THEN bVictoryStatus = 1
            IF en.inwater THEN en.deathfr = 0
         END IF
      END IF
      s.bob.add en.pos.x, en.pos.y, SPRENEMY, en.deathfr + 40, FALSE, TRUE
   CASE SDEAD
      en.d = en.d + 1
      IF NOT en.inwater THEN
         IF en.d > 1200 THEN
            en.d = 0
            en.deathfr = en.deathfr + 1
            IF en.deathfr > 8 THEN en.deathfr = 8
         END IF
         IF en.deathfr < 8 THEN s.bob.add en.pos.x, en.pos.y, SPRENEMY, en.deathfr + 40, FALSE, TRUE
      ELSE
         IF en.d > 30 THEN
            en.d = 0
            en.deathfr = en.deathfr + 1
            IF en.deathfr > 1 THEN en.deathfr = 0
         END IF
         s.bob.add en.pos.x, en.pos.y, SPRENEMY, en.deathfr + 58, FALSE, TRUE
      END IF
   END SELECT
   stEnemy(i) = en
   NEXT i
END SUB

REM $STATIC
'****************************************************************************
' Handles the game when in the main game phase
'****************************************************************************
SUB s.main.gameloop (destBuffer, destOff, sideBufferSeg, sideBufferOff)
   IF pMS.x >= CLIPSCRX1 THEN
      MONSCREEN = TRUE
   ELSE
      MONSCREEN = FALSE
      iPointer = SPRPOINT
   END IF

   IF lhz.keystate(1) THEN bVictoryStatus = 2
   
   '* Sets destination for current trooper group

   IF LMFLAG THEN
      IF bVictoryStatus THEN iEndDelay = 1
      IF MONSCREEN THEN
         pWork = pMS
         IF pWork.x < CLIPSCRX1 THEN pWork.x = CLIPSCRX1

         stTrooper(iLeader(iCurGroup)).dest.x = pWork.x - CLIPSCRX1 + stScr.pos.x
         stTrooper(iLeader(iCurGroup)).dest.y = pWork.y + stScr.pos.y
         stTrooper(iLeader(curGruop)).destnum = 0
         stTrooper(iLeader(iCurGroup)).bres(0).dx = stTrooper(iLeader(iCurGroup)).dest.x - stTrooper(iLeader(iCurGroup)).pos.x
         stTrooper(iLeader(iCurGroup)).bres(0).dy = stTrooper(iLeader(iCurGroup)).dest.y - stTrooper(iLeader(iCurGroup)).pos.y

         '* ax is distance from leader of current group to destination point
         ax = SQR(stTrooper(iLeader(iCurGroup)).bres(0).dx ^ 2 + stTrooper(iLeader(iCurGroup)).bres(0).dy ^ 2)
         FOR i = 0 TO stGameInfo.origTroopers - 1
            IF stTrooper(i).status = SALIVE AND stTrooper(i).group = iCurGroup AND i <> iLeader(iCurGroup) THEN
               ax = ax - 10
               IF ax < 0 THEN ax = 0
               stTrooper(i).destnum = 1
               stTrooper(i).bres(1).dx = stTrooper(iLeader(iCurGroup)).pos.x - stTrooper(i).pos.x
               stTrooper(i).bres(1).dy = stTrooper(iLeader(iCurGroup)).pos.y - stTrooper(i).pos.y
               s.bres.set stTrooper(i).bres(1), -1

               stTrooper(i).bres(0) = stTrooper(iLeader(iCurGroup)).bres(0)
               s.bres.set stTrooper(i).bres(0), (ax)
            END IF
         NEXT i
         s.bres.set stTrooper(iLeader(iCurGroup)).bres(0), -1

         iPointer = SPRPOINT
      ELSE
         bInvalidateSideBar = TRUE
      END IF
   END IF

   s.main.scrollhandler destBuffer, destOff, stTrooper(iLeader(iCurGroup)).pos

   s.troopers.update
   s.enemy.update
   s.doodads.update
   s.bob.draw destBuffer, destOff
   s.bullets.update destBuffer, destOff

   IF bInvalidateSideBar THEN s.main.updatesidebar sideBufferSeg, sideBufferOff

   '* Copy the side bar to the main screen...
   lhz.paste destBuffer, destOff, 0, 0, CLIPSCRX1, 200, sideBufferSeg, sideBufferOff

   IF iCurMsgDelay > 0 THEN
      iCurMsgDelay = iCurMsgDelay - 1
      s.font.put destBuffer, destOff, 317 - f.font.findwidth(curMsg$), 189, curMsg$, 19, TRUE, FALSE
   END IF
   IF bVictoryStatus THEN
      stGameInfo.bInvincible = TRUE
      iEndDelay = iEndDelay - 1
      IF bVictoryStatus = 1 THEN
         f$ = "Stage Complete"
         IF stGameInfo.curStage + 1 = stGameInfo.numStages THEN
            f$ = "Mission Complete"
         END IF
      ELSE
         f$ = "You Failed...Darn"
      END IF
      s.font.put destBuffer, destOff, XCENTRE + CLIPSCRX1 - f.font.findwidth(f$) / 2, 95, f$, 19, TRUE, FALSE
   END IF
END SUB

REM $DYNAMIC
'****************************************************************************'
'* Extracts the tile mask from XMS. The mask tells us what area of a tile
'* a player can walk on. Also hold other info such as whether it is water etc
'****************************************************************************
SUB s.main.getmask (spr, x, y)
   DIM sproffset AS LONG, newMask
   STATIC curMask

   newMask = iMap(x, y)
   IF curMask <> newMask THEN
      sproffset = newMask * stSprite(spr).width * stSprite(spr).hite
      lhz.xmscopy stSprite(spr).xmsOffset + sproffset, VARSEG(strMask), VARPTR(strMask), stSprite(spr).width * stSprite(spr).hite
      curMask = newMask
   END IF
END SUB

REM $STATIC
SUB s.main.intermediate (destBuffer, destOff)

startInter:
   
   lhz.fill &HA000, 0, 64000, 0

   OUT &H3C8, 15
   OUT &H3C9, 57
   OUT &H3C9, 57
   OUT &H3C9, 57

   DO: LOOP UNTIL lhz.mouseb = 0
   s.font.put &HA000, 0, 10, 10, "MISSION BRIEFING:", 15, FALSE, TRUE
   s.font.put &HA000, 0, 20, 20, stGameInfo.missName, 15, FALSE, TRUE
   s.font.put &HA000, 0, 20, 30, RTRIM$(stGameInfo.name) + " - Stage" + STR$(stGameInfo.curStage + 1) + " of" + STR$(stGameInfo.numStages), 15, FALSE, TRUE

   FOR i = 0 TO stGameInfo.numTroopers - 1
      s.font.put &HA000, 0, 20, 50 + i * 10, strRank(stMen(stTrooper(i).index).rank) + " " + RTRIM$(stMen(stTrooper(i).index).name), 15, FALSE, TRUE
   NEXT i

   DO: LOOP UNTIL lhz.mouseb = 0
   DO
      IF lhz.keystate(1) THEN
         bEnterMenu = TRUE
         EXIT DO
      END IF
   LOOP UNTIL lhz.mouseb

   DO: LOOP UNTIL lhz.mouseb = 0

   FOR i = 56 TO 0 STEP 1
      OUT &H3C8, 15
      OUT &H3C9, i
      OUT &H3C9, i
      OUT &H3C9, i
   NEXT i

   IF bEnterMenu THEN
      s.main.menu destBuffer, destOffset
      IF NOT f.main.loadmap(curMission$) THEN s.main.shutdown strError(0) + curMission$
      GOTO startInter
   END IF
END SUB

SUB s.main.intro (destBuffer, destOff)
   DIM t&

   s.graph.setpal STRING$(768, 0)
   f$ = "gfx\logo.pcx"
   IF NOT f.pcx.getpal(f$, strPal) THEN s.main.shutdown strError(0) + f$
   ax = f.pcx.load(f$, destBuffer)
   lhz.memcopy destBuffer, destOff, &HA000, 0, 64000

   s.graph.fadetopal STRING$(768, 0), strPal, 2, 0, 255
   t& = TIMER
   DO
   LOOP UNTIL lhz.mouseb OR TIMER - t& >= 5
   s.graph.fadetocol strPal, 63, 63, 63, 1, 0, 255
   s.graph.fadetocol strPal, 0, 0, 0, 0, 0, 255
   lhz.fill &HA000, 0, 64000, 0
END SUB

REM $DYNAMIC
'****************************************************************************
'* Handles the menu...not the best of functions, but putting time into
'* optimising menus is time unwisely spent.
'****************************************************************************
SUB s.main.menu (destBuffer, destOff)
   DIM strMain$(6), curSel, bAreYouSure

   bEnterMenu = FALSE

   GOSUB setScreen1

   bAreYouSure = FALSE
   DO
      lhz.xmscopy curXMS, destBuffer, destOff, 64000

      pMS.x = lhz.mousex: pMS.y = lhz.mousey
      curSel = (pMS.y - 80) \ 10

      IF NOT bAreYouSure THEN
         IF pMS.x > 100 AND pMS.x < 220 THEN
            IF pMS.y >= 80 AND pMS.y <= 140 THEN
               s.font.put destBuffer, destOff, 160 - f.font.findwidth(strMain$(curSel)) \ 2, 80 + curSel * 10, strMain$(curSel), 17, TRUE, FALSE
            END IF

            IF lhz.mouseb THEN
            SELECT CASE curSel
               CASE 0      '* new game
                  IF stGameInfo.savedpos <> stGameInfo.curMission THEN
                     bAreYouSure = TRUE
                     bSureWant = 1
                     GOSUB setScreen2
                  ELSE
                     s.main.newgame
                     EXIT DO
                  END IF
               CASE 1      '* back to missions
                  EXIT DO
               CASE 2      '* save game
                  '* dont forget savedpos
               CASE 3      '* load game
                  '* dont forget savedpos
               CASE 4      '* credits
               CASE 5      '* quit
                  IF stGameInfo.savedpos <> stGameInfo.curMission THEN
                     bAreYouSure = TRUE
                     bSureWant = 0
                     GOSUB setScreen2
                  ELSE
                     s.graph.fadetocol strPal, 0, 0, 0, 0, 0, 255
                     s.main.shutdown ""
                  END IF
               END SELECT
            END IF
         END IF
      ELSE
         IF lhz.keystate(21) THEN
            IF bSureWant = 0 THEN
               s.graph.fadetocol strPal, 0, 0, 0, 0, 0, 255
               s.main.shutdown ""
            ELSE
               s.main.newgame
               EXIT DO
            END IF
         END IF
         IF lhz.keystate(49) THEN
            bAreYouSure = FALSE
            GOSUB setScreen1
         END IF
      END IF

      '* Then the mouse pointer
      s.bob.put destBuffer, destOff, pMS.x, pMS.y, SPRPOINT, 0, BPUT, FALSE, 100

      '* Wait until screen is in refresh state
      lhz.waitvbl

      '* Copy Buffer to screen (for flicker free graphics)
      lhz.memcopy destBuffer, destOff, &HA000, 0, 64000
   LOOP
   s.graph.fadetocol strPal, 0, 0, 0, 0, 0, 255
   lhz.fill &HA000, 0, 64000, 0

   '* load next mission
   
   ff = FREEFILE
   OPEN "maps\misspak.txt" FOR INPUT AS ff
      FOR i = 0 TO stGameInfo.curMission
         LINE INPUT #ff, f$
      NEXT i
   CLOSE ff
   IF f$ = "" THEN s.main.shutdown "Game Complete! Thanks for playing!"
   curMission$ = "maps\" + f$
   IF NOT f.main.loadmission(curMission$) THEN s.main.shutdown strError(0) + curMission$
   
   EXIT SUB
   
setScreen1:
   s.graph.setpal STRING$(768, 0)
   f$ = "gfx\title.pcx"
   IF NOT f.pcx.getpal(f$, strPal) THEN s.main.shutdown strError(0) + f$
   ax = f.pcx.load(f$, destBuffer)

   strMain$(0) = "New Game": s.font.put destBuffer, destOff, 160 - f.font.findwidth(strMain$(0)) \ 2, 80, strMain$(0), 19, TRUE, FALSE
   strMain$(1) = "Continue Missions": s.font.put destBuffer, destOff, 160 - f.font.findwidth(strMain$(1)) \ 2, 90, strMain$(1), 19, TRUE, FALSE
   strMain$(2) = "Save Game": s.font.put destBuffer, destOff, 160 - f.font.findwidth(strMain$(2)) \ 2, 100, strMain$(2), 19, TRUE, FALSE
   strMain$(3) = "Load Game": s.font.put destBuffer, destOff, 160 - f.font.findwidth(strMain$(3)) \ 2, 110, strMain$(3), 19, TRUE, FALSE
   strMain$(4) = "Credits": s.font.put destBuffer, destOff, 160 - f.font.findwidth(strMain$(4)) \ 2, 120, strMain$(4), 19, TRUE, FALSE
   strMain$(5) = "Quit": s.font.put destBuffer, destOff, 160 - f.font.findwidth(strMain$(5)) \ 2, 130, strMain$(5), 19, TRUE, FALSE
   '* A second buffer

   lhz.xmspaste destBuffer, destOff, curXMS, 64000

   s.bob.put destBuffer, destOff, lhz.mousex, lhz.mousey, SPRPOINT, 0, BPUT, FALSE, 100
   lhz.memcopy destBuffer, destOff, &HA000, 0, 64000

   s.graph.fadetopal STRING$(768, 0), strPal, 0, 0, 255
RETURN

setScreen2:
   s.graph.fadetocol strPal, 0, 0, 0, 0, 0, 255
   f$ = "gfx\title.pcx"
   IF NOT f.pcx.getpal(f$, strPal) THEN s.main.shutdown strError(0) + f$
   ax = f.pcx.load(f$, destBuffer)
   f$ = "Current game not saved. Are you sure? (Y/N)"
   s.font.put destBuffer, destOff, 160 - f.font.findwidth(f$) / 2, 90, f$, 19, TRUE, FALSE
   lhz.xmspaste destBuffer, destOff, curXMS, 64000

   s.bob.put destBuffer, destOff, lhz.mousex, lhz.mousey, SPRPOINT, 0, BPUT, FALSE, 100
   lhz.memcopy destBuffer, destOff, &HA000, 0, 64000

   s.graph.fadetopal STRING$(768, 0), strPal, 0, 0, 255
RETURN
END SUB

REM $STATIC
'****************************************************************************
'* Handles game when on the mini map screen
'****************************************************************************
SUB s.main.minimap (destBuffer, destOff, sideBufferSeg, sideBufferOff)
   DIM sMapScale AS SINGLE, sYStart AS SINGLE, sXStart AS SINGLE
   DIM sy AS SINGLE, sx AS SINGLE, sScale AS SINGLE
   DIM i AS INTEGER, ibx, iby

   lhz.fill destBuffer, destOff, 64000, 0

   '* Draw the minimap
   IF stGameInfo.mapSize.x > stGameInfo.mapSize.y THEN
      sMapScale = (320 - CLIPSCRX1 - MAPBORDER) / (stGameInfo.mapSize.x)
      sYStart = YCENTRE - (stGameInfo.mapSize.y / 2) * sMapScale
      sXStart = CLIPSCRX1 + MAPBORDER / 2
   ELSE
      sMapScale = (200 - MAPBORDER) / stGameInfo.mapSize.y
      sXStart = 160 + CLIPSCRX1 / 2 - (stGameInfo.mapSize.x / 2) * sMapScale
      sYStart = MAPBORDER / 2
   END IF
   IF sXStart < CLIPSCRX1 + MAPBORDER / 2 THEN sXStart = CLIPSCRX1 + MAPBORDER / 2
   IF sYStart < MAPBORDER / 2 THEN sYStart = MAPBORDER / 2

   sScale = (sMapScale / TILESIZE) * 100
   FOR sy = 0 TO stGameInfo.mapSize.y - 1
      FOR sx = 0 TO stGameInfo.mapSize.x - 1
         s.bob.put destBuffer, destOff, sXStart + sx * sMapScale, sYStart + sy * sMapScale, SPRTILES, iMap(sx, sy), BPASTE, FALSE, CINT(sScale) + 7
      NEXT sx
   NEXT sy

   '* This is a replacement for s.bob.add (due to very specific nature of the
   '* map drawing function.
   iBobNum = 0
   FOR i = 0 TO stGameInfo.numDoodads - 1
      stBob(iBobNum).pos.x = sXStart + (stDoodad(i).pos.x - stSprite(SPRDOODAD).hotspot.x) * (sMapScale / TILESIZE)
      stBob(iBobNum).pos.y = sYStart + (stDoodad(i).pos.y - stSprite(SPRDOODAD).hotspot.y) * (sMapScale / TILESIZE)
      stBob(iBobNum).flip = FALSE
      stBob(iBobNum).spr = SPRDOODAD
      stBob(iBobNum).sprindex = stDoodad(i).frame
      stBob(iBobNum).putfirst = FALSE
      stBob(iBobNum).scale = sScale + 7
      iBobNum = iBobNum + 1
   NEXT i

   s.bob.draw destBuffer, destOff


   ibx = sXStart + stScr.pos.x * (sMapScale / TILESIZE)
   iby = sYStart + stScr.pos.y * (sMapScale / TILESIZE)
   ibx2 = ibx + (SCRX * sMapScale)
   iby2 = iby + (SCRY * sMapScale)
   IF ibx2 > 319 THEN ibx2 = 319
   IF iby2 > 199 THEN iby2 = 199
   lhz.vline destBuffer, destOff, ibx, iby, iby + 5, 19
   lhz.vline destBuffer, destOff, ibx, iby2 - 5, iby2, 19
   lhz.vline destBuffer, destOff, ibx2, iby, iby + 5, 19
   lhz.vline destBuffer, destOff, ibx2, iby2 - 5, iby2, 19
   lhz.hline destBuffer, destOff, ibx, ibx + 5, iby, 19
   lhz.hline destBuffer, destOff, ibx2 - 5, ibx2, iby, 19
   lhz.hline destBuffer, destOff, ibx, ibx + 5, iby2, 19
   lhz.hline destBuffer, destOff, ibx2 - 5, ibx2, iby2, 19
   


   lhz.paste destBuffer, destOff, 0, 0, CLIPSCRX1, 200, sideBufferSeg, sideBufferOff
   IF LMFLAG THEN
      stGameInfo.gameLoop = ONGAME
      bInvalidateSideBar = TRUE
   END IF
END SUB

'****************************************************************************
'* Sets up default info for a new game
'****************************************************************************
SUB s.main.newgame
   DIM i
   stGameInfo.curMission = 0
   stGameInfo.curStage = 0

   FOR i = 0 TO MAXMEN - 1
      stMen(i).rank = 0
      stMen(i).status = SALIVE
      stMen(i).kills = 0
   NEXT i
   stMen(0).rank = 1

   'stGameInfo.curMan = 0
END SUB

SUB s.main.savegame (strFileName AS STRING)
   ff = FREEFILE
   OPEN strFileName FOR BINARY AS ff: CLOSE ff
   KILL strFileName

   OPEN strFileName FOR BINARY AS ff
      f$ = "TRPRSAVE"
      PUT ff, , f$
      PUT ff, , stGameInfo.curMission
      'PUT ff, , stGameInfo.curMan
      FOR i = 0 TO MAXMEN - 1
         PUT ff, , stMen(i).rank
         PUT ff, , stMen(i).kills
         PUT ff, , stMen(i).status
         PUT ff, , stMen(i).missioncount
      NEXT i
   CLOSE ff
END SUB

REM $DYNAMIC
'****************************************************************************
'* Handles all scrolling in game. Basically the screens position is always
'* moving towards the point half way between the mousepointer and the current
'* leader of the current group. A restriction is present to give a circular
'* field of view.
'****************************************************************************
SUB s.main.scrollhandler (destBuffer, destOff, player AS pointType)
   DIM sprOn, incx, incy, i

   DIM v AS pointType
   DIM ov AS pointType, c AS pointType

   ' Compute distance from player to mouse
   v.x = pMS.x + stScr.pos.x - player.x - CLIPSCRX1
   v.y = pMS.y + stScr.pos.y - player.y
   ov = v
   ov.x = ov.x + CLIPSCRX1
   
   t& = 1& * v.x * v.x + 1& * v.y * v.y
   IF t& > MAXVIEWSQ THEN
      scrDist! = MAXVIEW / SQR(t&)
      v.x = v.x * scrDist!
      v.y = v.y * scrDist!
   END IF
   
   ' Compute scroll destination from player to centre of screen
   c.x = v.x \ 2
   c.y = v.y \ 2

   ' Scroll towards new centre
   stScr.bres.dx = (player.x + c.x - XCENTRE) - stScr.pos.x
   stScr.bres.dy = (player.y + c.y - YCENTRE) - stScr.pos.y
   s.bres.set stScr.bres, -1

   stScr.fr = stScr.fr + 1
   IF stScr.fr > 15 THEN
      stScr.fr = 0
      stScr.accel = stScr.accel + 1
      IF stScr.accel > 2 THEN stScr.accel = 2
   END IF

   FOR i = 0 TO stScr.accel
      s.bres.update stScr.bres, incx, incy, 0 'stScr.accel
      IF stScr.bres.count > 0 THEN
         
         IF MONSCREEN OR SCROVERRIDE THEN
            stScr.vadd.x = stScr.vadd.x + incx
            stScr.vadd.y = stScr.vadd.y + incy
         END IF
         
         IF stScr.pos.x + stScr.vadd.x < 0 AND incx = -1 THEN stScr.vadd.x = stScr.vadd.x - incx
         IF player.x < XCENTRE AND stScr.vadd.x < (XCENTRE - player.x) THEN stScr.vadd.x = (XCENTRE - player.x)
         IF stScr.pos.y + stScr.vadd.y < 0 AND incy = -1 THEN stScr.vadd.y = stScr.vadd.y - incy
         IF player.y < YCENTRE AND stScr.vadd.y < (YCENTRE - player.y) THEN stScr.vadd.y = (YCENTRE - player.y)

         IF stScr.pos.x + stScr.vadd.x > stGameInfo.pixMapSize.x - (320 - CLIPSCRX1) AND incx = 1 THEN stScr.vadd.x = stScr.vadd.x - incx
         IF player.x > stGameInfo.pixMapSize.x - (XCENTRE) AND stScr.vadd.x > (stGameInfo.pixMapSize.x - (XCENTRE) - player.x) THEN stScr.vadd.x = (stGameInfo.pixMapSize.x - (XCENTRE) - player.x)
         IF stScr.pos.y + stScr.vadd.y > stGameInfo.pixMapSize.y - 200 AND incy = 1 THEN stScr.vadd.y = stScr.vadd.y - incy
         IF player.y > stGameInfo.pixMapSize.y - YCENTRE AND stScr.vadd.y > (stGameInfo.pixMapSize.y - YCENTRE - player.y) THEN stScr.vadd.y = (stGameInfo.pixMapSize.y - YCENTRE - player.y)

         stScr.pos.x = player.x - XCENTRE + stScr.vadd.x
         stScr.pos.y = player.y - YCENTRE + stScr.vadd.y

      ELSE
         stScr.accel = 0
         SCROVERRIDE = FALSE
      END IF
      
   NEXT i

   IF stScr.pos.x < 0 THEN stScr.pos.x = 0
   IF stScr.pos.x > stGameInfo.pixMapSize.x - (320 - CLIPSCRX1) THEN stScr.pos.x = stGameInfo.pixMapSize.x - (320 - CLIPSCRX1)
   IF stScr.pos.y < 0 THEN stScr.pos.y = 0
   IF stScr.pos.y > stGameInfo.pixMapSize.y - (200) THEN stScr.pos.y = stGameInfo.pixMapSize.y - 200

   IF MONSCREEN THEN
      pMS.x = player.x - stScr.pos.x + ov.x
      pMS.y = player.y - stScr.pos.y + ov.y

      IF pMS.x < 0 THEN pMS.x = 0
      IF pMS.y < 0 THEN pMS.y = 0
      IF pMS.x > 319 THEN pMS.x = 319
      IF pMS.y > 199 THEN pMS.y = 199

      lhz.setmouse pMS.x, pMS.y
   END IF

   stScr.cur.x = stScr.pos.x \ TILESIZE
   stScr.cur.y = stScr.pos.y \ TILESIZE
   stScr.add.x = stScr.pos.x MOD TILESIZE
   stScr.add.y = stScr.pos.y MOD TILESIZE

   FOR y = 0 TO SCRY
      FOR x = 0 TO SCRX
         s.bob.put destBuffer, destOff, CLIPSCRX1 + x * TILESIZE - stScr.add.x, y * TILESIZE - stScr.add.y, SPRTILES, iMap(x + stScr.cur.x, y + stScr.cur.y), TPASTE, FALSE, 100
      NEXT x
   NEXT y
END SUB

'****************************************************************************
'* Safely closes the program
'* If no error message is specified, the thank you message is shown
'****************************************************************************
SUB s.main.shutdown (errmsg AS STRING)
   CLOSE

   lhz.shutdown

   IF bBWSBInstalled THEN
      StopMusic
      StopOutput
      UnloadModule
      FreeMSE                   'Free MSE from system and memory
   END IF

   SCREEN 1: SCREEN 0: WIDTH 80, 25
   COLOR 15, 1
   f$ = "Troopers V1.0 (C) 2002 Aspect Productions"
   LOCATE 1, 1: PRINT SPACE$(80)
   LOCATE 1, 40 - LEN(f$) / 2
   PRINT f$: PRINT
   COLOR 7, 0
   IF LEN(errmsg) THEN
      PRINT errmsg
   ELSE
      PRINT "Thanks for playing Troopers!"
      PRINT "Contact us at benbosco@hotmail.com"
   END IF

   END
END SUB

SUB s.main.updatesidebar (destBuffer, destOff)
   DIM i, iMSB2

   lhz.setBufferWidth CLIPSCRX1
   lhz.fill destBuffer, destOff, 200 * 64, 0

   iMSB2 = iMSB

   '* If user clicks on group header, transfer selected units to group
   IF LMFLAG THEN 'iMSB2 THEN
      oldleader = iLeader(iCurGroup)
      aadd = 23
      FOR sq = 0 TO MAXGROUPS - 1
         IF pMS.x >= 1 AND pMS.x <= 59 THEN
            IF pMS.y >= aadd AND pMS.y <= aadd + 12 THEN
               FOR i = 0 TO stGameInfo.origTroopers - 1
                  IF stTrooper(i).selected = TSELECTED THEN
                     iGroupSize(stTrooper(i).group) = iGroupSize(stTrooper(i).group) - 1
                     stTrooper(i).group = sq: stTrooper(i).selected = TNOTSELECTED
                     iGroupSize(stTrooper(i).group) = iGroupSize(stTrooper(i).group) + 1
                  END IF
               NEXT i
               IF iGroupSize(sq) > 0 THEN
                  iCurGroup = sq
                  SCROVERRIDE = TRUE
               END IF
               LMFLAG = FALSE 'iMSB2 = 0
            END IF
         END IF
         aadd = aadd + 15 + iGroupSize(sq) * 9
      NEXT sq
      FOR sq = 0 TO MAXGROUPS - 1
         s.troopers.updateleader sq, oldleader
      NEXT sq
      IF pMS.x >= 35 AND pMS.x < 63 AND pMS.y > 185 AND pMS.y < 198 THEN
         stGameInfo.gameLoop = ONMINIMAP
      END IF
   END IF

   aadd = 23
   s.bob.put destBuffer, destOff, 3, 0, SPRLOGO, 0, BPASTE, FALSE, 100

   FOR sq = 0 TO MAXGROUPS - 1
      darkened = 4: darkcol = 16
      IF iCurGroup = sq THEN darkened = 0: darkcol = 19
      s.bob.put destBuffer, destOff, 0, aadd, SPRGROUP, sq + darkened, BPASTE, FALSE, 100
      IF iGroupSize(sq) THEN
         s.bob.put destBuffer, destOff, 0, 13 + aadd, SPRGROUP, 3 + darkened, BPASTE, FALSE, 100
         lhz.vline destBuffer, destOff, 1, 20 + aadd, 14 + aadd + iGroupSize(sq) * 9, darkcol
         lhz.vline destBuffer, destOff, 59, 20 + aadd, 14 + aadd + iGroupSize(sq) * 9, darkcol
         lhz.hline destBuffer, destOff, 1, 59, 15 + aadd + iGroupSize(sq) * 9, darkcol
         aadd = aadd + 2

         iadd = 0
         FOR i = 0 TO stGameInfo.origTroopers - 1
            IF stTrooper(i).group = sq AND stTrooper(i).status = SALIVE THEN
               IF LMFLAG THEN
                  IF pMS.y >= 12 + aadd + iadd AND pMS.y < 12 + aadd + iadd + FONTHITE THEN
                     IF pMS.x >= 13 AND pMS.x <= 59 THEN
                        IF stTrooper(i).selected = TSELECTED THEN
                           stTrooper(i).selected = TNOTSELECTED
                        ELSE
                           stTrooper(i).selected = TSELECTED
                        END IF
                     END IF
                     IF pMS.x >= 1 AND pMS.x < 13 THEN
                        curMsg$ = ""
                        IF i = iLeader(0) OR i = iLeader(1) OR i = iLeader(2) THEN curMsg$ = "[L] "
                        curMsg$ = curMsg$ + strRank(stMen(stTrooper(i).index).rank) + " " + RTRIM$(stMen(stTrooper(i).index).name) + " - Kills:" + STR$(stMen(stTrooper(i).index).kills)
                        iCurMsgDelay = 70 * 5
                     END IF
                  END IF
               END IF
               s.font.put destBuffer, destOff, 58 - f.font.findwidth(stMen(stTrooper(i).index).name), 12 + aadd + iadd, stMen(stTrooper(i).index).name, stTrooper(i).selected, FALSE, FALSE
               s.bob.put destBuffer, destOff, 2, 11 + aadd + iadd, SPRRANK, stMen(stTrooper(i).index).rank, TPASTE, FALSE, 100
               iadd = iadd + 9
            END IF
         NEXT i
      END IF
      aadd = aadd + 15 + iGroupSize(sq) * 9
   NEXT sq

   IF stGameInfo.gameLoop = ONMINIMAP THEN
      s.bob.put destBuffer, destOff, 35, 185, SPRGROUP, 9, BPASTE, FALSE, 100
   ELSE
      s.bob.put destBuffer, destOff, 35, 185, SPRGROUP, 8, BPASTE, FALSE, 100
   END IF

   lhz.setBufferWidth 320

   bInvalidateSideBar = FALSE
END SUB

REM $STATIC
SUB s.sound.loadsong (FileName AS STRING)

   IF EmsExist THEN ErrorFlag = 1 ELSE ErrorFlag = 0   'Setup EMS use flag
   File = FREEFILE
   OPEN FileName FOR BINARY AS File
   'Load our module
   LoadGDM FILEATTR(File, 2), 0, ErrorFlag, VARSEG(ModHead), VARPTR(ModHead)

   strErrorAdd = ""
   SELECT CASE ErrorFlag
   CASE 0
   CASE 1: strErrorAdd = "Module is corrupt"
   CASE 2: strErrorAdd = "Could not autodetect module type"
   CASE 3: strErrorAdd = "Bad format ID"
   CASE 4: strErrorAdd = "Out of memory"
   CASE 5: strErrorAdd = "Cannot unpack samples"
   CASE 6: strErrorAdd = "AdLib samples not supported"
   CASE ELSE: strErrorAdd = "Unknown Load Error:" + STR$(ErrorFlag)
   END SELECT
   IF LEN(strErrorAdd) THEN s.main.shutdown strErrorAdd

   MusicChannels = 0                      'Start out at zero..
   FOR i = 1 TO 32                        'Scan for used music channels
     IF ASC(MID$(ModHead.PanMap, i, 1)) <> &HFF THEN
       MusicChannels = MusicChannels + 1
     END IF
   NEXT i
   MusicChannels = MAXCHANNELS

   OverRate& = StartOutput(MusicChannels, 0) 'Start your (sound) engines
'   StartMusic                                'Revv up the music playing

END SUB

SUB s.sound.playsample (iSample, freq&, iVol, iPan)
   STATIC curChannel

   IF freq& = -1 THEN freq& = 22000
   IF iVol = -1 THEN iVol = 64
   IF iPan = -1 THEN iPan = 8

   curChannel = curChannel + 1
   IF curChannel > MAXCHANNELS THEN curChannel = 1
   IF bBWSBInstalled THEN PlaySample curChannel, iSample, freq&, iVol, iPan
END SUB

REM $DYNAMIC
'****************************************************************************
'* Handles all the players, taking into account group/controlled units
'****************************************************************************
SUB s.troopers.update
   DIM trpr AS trooperType, curpix, i

   FOR i = 0 TO stGameInfo.origTroopers - 1
   trpr = stTrooper(i)

   SELECT CASE trpr.status
   CASE SALIVE
      '* Trooper Walking **********************************************************
         incx = 0: incy = 0
         trpr.walkdelay = trpr.walkdelay + 1
         IF trpr.walkdelay > 4 OR NOT trpr.inwater THEN
            trpr.walkdelay = 0
            s.bres.update trpr.bres(trpr.destnum), incx, incy, 0
         END IF

         IF trpr.bres(trpr.destnum).count > 0 THEN
            IF trpr.pos.x + incx > stGameInfo.pixMapSize.x - 1 THEN incx = 0
            IF trpr.pos.y + incy > stGameInfo.pixMapSize.y - 1 THEN incy = 0
            IF trpr.pos.x + incx < 0 THEN incx = 0
            IF trpr.pos.y + incy < 0 THEN incy = 0

            s.main.getmask SPRMASK, (trpr.pos.x + incx) \ TILESIZE, (trpr.pos.y + incy) \ TILESIZE
            ax = ((trpr.pos.y + incy) MOD TILESIZE) * TILESIZE + ((trpr.pos.x + incx) MOD TILESIZE) + 1
            curpix = ASC(MID$(strMask, ax, 1))
            
            IF stTerrainPix(curpix).walktype <> 0 THEN
               trpr.pos.x = trpr.pos.x + incx
               trpr.pos.y = trpr.pos.y + incy
               IF i = iLeader(iCurGroup) THEN
                  stScr.vadd.x = stScr.vadd.x - incx
                  stScr.vadd.y = stScr.vadd.y - incy
               END IF
            END IF
            IF stTerrainPix(curpix).walktype = TSWIM THEN
               IF trpr.inwater = FALSE THEN
                  trpr.fr = 0: trpr.walkdelay = 0
               END IF
               trpr.inwater = TRUE
            ELSE
               trpr.inwater = FALSE
            END IF
         ELSE
            IF trpr.destnum = 1 THEN
               trpr.destnum = 0
            END IF
         END IF


      IF trpr.group = iCurGroup THEN
      '* Trooper Shooting *********************************************************
         trpr.bdelay = trpr.bdelay + 1

         IF i = iLeader(iCurGroup) THEN
            IF trpr.bdelay > trpr.brate THEN trpr.bdelay = trpr.brate
         ELSE
            IF trpr.bdelay > trpr.brate THEN trpr.bdelay = 0'trpr.brate
         END IF
         IF iMSB = 2 AND MONSCREEN THEN
            IF trpr.bdelay = trpr.brate AND NOT trpr.inwater THEN
               '* Add a bullet to the queue
               s.bullets.add trpr.pos, pMS.x - CLIPSCRX1 + stScr.pos.x - trpr.pos.x, 7 + pMS.y + stScr.pos.y - trpr.pos.y, trpr.baccuracy, BFRIEND OR i, trpr.brange
               IF i = iLeader(iCurGroup) THEN s.sound.playsample 0, -1, -1, -1
               trpr.bdelay = 0
            END IF
            iPointer = SPRSHOOT
         END IF

         '* Animation
         trpr.d = trpr.d + 1
         IF trpr.inwater THEN
            IF trpr.d > 8 THEN
               trpr.d = 0
               trpr.fr = trpr.fr + 1
               IF trpr.fr > 1 THEN
                  trpr.fr = 0
               END IF
            END IF
         ELSE
            IF trpr.d > 4 THEN
               trpr.d = 0
               trpr.fr = trpr.fr + 1
               IF trpr.fr > 7 THEN
                  trpr.fr = 0
               END IF
            END IF
            IF trpr.bres(trpr.destnum).count <= 0 THEN trpr.fr = 0
         END IF
         
         '* Men always look towards mouse pointer
         trpr.dir = f.main.finddir(pMS.x - CLIPSCRX1 + stScr.pos.x - trpr.pos.x, pMS.y + stScr.pos.y - trpr.pos.y)
      ELSE
         '* Handle uncontrolled units (fire automatically if fire at, but twice as slow)
         trpr.bdelay = trpr.bdelay + 1
         IF trpr.bdelay > trpr.brate * 2 THEN trpr.bdelay = trpr.brate * 2
         IF trpr.autofire AND NOT trpr.inwater THEN
            trpr.autofire = FALSE
            IF trpr.bdelay = trpr.brate * 2 THEN
               '* Add a bullet to the queue
               s.bullets.add trpr.pos, trpr.autodest.x - trpr.pos.x, 7 + trpr.autodest.y - trpr.pos.y, trpr.baccuracy, BFRIEND OR i, BULLETRANGE
               trpr.bdelay = 0
            END IF
            trpr.dir = f.main.finddir(trpr.autodest.x - trpr.pos.x, trpr.autodest.y - trpr.pos.y)
         ELSE
            trpr.dir = f.main.finddir(pMS.x - CLIPSCRX1 + stScr.pos.x - trpr.pos.x, pMS.y + stScr.pos.y - trpr.pos.y)
         END IF
         
      END IF


      '* Flip man sprite if necessary
      trpr.flip = FALSE
      IF trpr.dir > 4 THEN
         trpr.dir = trpr.dir - 4
         trpr.flip = TRUE
      END IF

      IF trpr.inwater THEN
         s.bob.add trpr.pos.x, trpr.pos.y, SPRTROOPER, trpr.fr + trpr.dir * 2 + 48, trpr.flip, FALSE
      ELSE
         s.bob.add trpr.pos.x, trpr.pos.y, SPRTROOPER, trpr.fr + trpr.dir * 8, trpr.flip, FALSE
      END IF
   CASE SDYING
      '* Handle dying animation
      trpr.d = trpr.d + 1
      IF trpr.d > 4 THEN
         trpr.d = 0
         trpr.deathfr = trpr.deathfr + 1
         IF trpr.deathfr > 2 THEN
            trpr.status = SDEAD
            stMen(trpr.index).status = SDEAD
            IF stGameInfo.numTroopers = 0 THEN bVictoryStatus = 2
            IF trpr.inwater THEN trpr.deathfr = 0
         END IF
      END IF
      s.bob.add trpr.pos.x, trpr.pos.y, SPRTROOPER, trpr.deathfr + 40, FALSE, TRUE
   CASE SDEAD
      trpr.d = trpr.d + 1
      IF NOT trpr.inwater THEN
         IF trpr.d > 1200 THEN
            trpr.d = 0
            trpr.deathfr = trpr.deathfr + 1
            IF trpr.deathfr > 7 THEN trpr.deathfr = 7
         END IF
         s.bob.add trpr.pos.x, trpr.pos.y, SPRTROOPER, trpr.deathfr + 40, FALSE, TRUE
      ELSE
         IF trpr.d > 30 THEN
            trpr.d = 0
            trpr.deathfr = trpr.deathfr + 1
            IF trpr.deathfr > 1 THEN trpr.deathfr = 0
         END IF
         s.bob.add trpr.pos.x, trpr.pos.y, SPRTROOPER, trpr.deathfr + 58, FALSE, TRUE
      END IF
   END SELECT

   stTrooper(i) = trpr
   NEXT i
END SUB

SUB s.troopers.updateleader (group, curTrpr)
'* find a new leader for group (according to rank)
'* temp
   DIM i, iHighest

   iHighest = -1
   FOR i = 0 TO stGameInfo.origTroopers - 1
      IF stTrooper(i).group = group AND stTrooper(i).status = SALIVE THEN
         IF iHighest <> -1 THEN
            IF stMen(stTrooper(i).index).rank > stMen(stTrooper(iHighest).index).rank THEN
                  iHighest = i
            END IF
         ELSE
            iHighest = i
         END IF
      END IF
   NEXT i

   IF iHighest = -1 THEN iHighest = curTrpr

   iLeader(group) = iHighest
   IF group = iCurGroup AND iHighest <> curTrpr THEN
      stScr.vadd.x = stScr.vadd.x - (stTrooper(iHighest).pos.x - stTrooper(curTrpr).pos.x)
      stScr.vadd.y = stScr.vadd.y - (stTrooper(iHighest).pos.y - stTrooper(curTrpr).pos.y)
      SCROVERRIDE = TRUE
   END IF
END SUB

