'$DYNAMIC
DECLARE SUB advance.time ()
DECLARE SUB ini.clouds ()
DECLARE SUB save.keysettings ()
DECLARE SUB load.keysettings ()
DECLARE SUB ini.keysettings ()
DECLARE SUB ini.speedsettings ()
DECLARE SUB ini.keyname ()
DECLARE SUB ini.gamesettings ()
DECLARE SUB print2 (string1$)
DECLARE SUB menu.quit ()
DECLARE SUB ini.snow ()
DECLARE SUB menu.playgame ()
DECLARE SUB menu.main ()
DECLARE SUB menu.gameinfo ()
DECLARE SUB menu.settings ()
DECLARE SUB game.menu ()
DECLARE SUB ini.grass ()
DECLARE SUB bikester.move ()
DECLARE SUB ini.mountains ()
DECLARE SUB draw.grass ()
DECLARE SUB pause.game ()
DECLARE SUB sleep2 ()
DECLARE SUB game.ending (n%)
DECLARE SUB kill.check (n%)
DECLARE SUB badguy.collision (n%)
DECLARE SUB fire.badguy.alive (n2%, n%)
DECLARE SUB draw.badguy.alive (n%)
DECLARE SUB ini.badguys ()
DECLARE SUB speed.adjust ()
DECLARE SUB put.bikester ()
DECLARE SUB day.night.cycle ()
DECLARE SUB draw.clouds ()
DECLARE SUB draw.sun ()
DECLARE SUB draw.snow ()
DECLARE SUB draw.mountains ()
DECLARE SUB draw.life.bar ()
DECLARE SUB game.win ()
DECLARE SUB draw.bikester ()
DECLARE SUB play.sound (n%)
CLEAR
'DIM SHARED bikester(50 * 27)

'variables for picture stuff
DIM SHARED screen1.max.x%, screen1.max.y%
DIM SHARED miles.elapsed%, level% 'unused / unactivated
DIM SHARED life.bar%
DIM SHARED bikester.x%, bikester.y%, missile.x%, missile.y%
DIM SHARED uguy.amount%: uguy.amount% = 5
DIM SHARED uammo.amount%: uammo.amount% = 2
DIM SHARED obj.x%(uguy.amount%), obj.y%(uguy.amount%), adj.x%, adj.y%
DIM SHARED scoreon.pass(1 TO uguy.amount%) AS INTEGER
DIM SHARED enemy.start.x%(uguy.amount%), enemy.start.y%(uguy.amount%)
DIM SHARED wt%, wt2%
DIM SHARED game.setting%(9)
DIM SHARED guy.name$(uguy.amount%)
DIM SHARED lim1(uguy.amount%) AS INTEGER, lim2(uguy.amount%) AS INTEGER 'collide "booleans"
DIM SHARED score AS INTEGER, shoot AS INTEGER
DIM SHARED d.result%(uguy.amount%)
DIM SHARED guy.index AS INTEGER, guy.alive AS INTEGER
DIM SHARED ammo.type%(uguy.amount%), guy.ammo%(uguy.amount%), guy.ammo.max%(uguy.amount%)
DIM SHARED ammo.ap%(uammo.amount%), ammo.pos%(uammo.amount%)
DIM SHARED p1%(33), ini1%, prevpk%, pk%, cl%, prevr%
DIM SHARED mmp AS INTEGER, mmp2 AS INTEGER
DIM SHARED fall%, jump%, bike.speed%
DIM SHARED sentence.max%, sentence.min%
DIM SHARED speed.str$(6), sound.str$(2)
DIM SHARED settings%(10), settings.keyname$(134 + 128), settings.desc$(10), settings.max%(9), prevsettings%(9)
DIM SHARED accel1#, accel2#
'ini grass
DIM SHARED r%(320)

'ini clouds
DIM SHARED cloud.max%, cloud.amount%, prev.cloud%: cloud.max% = 12
DIM SHARED cloudy%(cloud.max%), cloudx%(cloud.max%), cloud.rad%(cloud.max%)

DIM SHARED x AS INTEGER
DIM SHARED Y AS INTEGER
DIM SHARED col AS INTEGER
DIM SHARED size AS INTEGER

'ini sun
DIM SHARED sun.wait%, sun.height%, sun.dir%

'ini moon
DIM SHARED moon.dir%, moon.height%, moon.wait%

'ini snow
DIM SHARED snow.active%, snow.severity%, snow.interval%

RANDOMIZE TIMER

'--"the Incredible Bikester is a robotic stunt bike"
'The Incredible Bikester by TJ Edmister (TEEJ213360@AOL.COM)  (1997)
'Version Omega 2 by Agamemnus (warlordagamemnus@aol.com)

'Um, thanks to Alias (NapalmLady) for:
'helping with the flicker problem I didn't know I had. :)
'and speed adjustment issues

'Game Last Updated: February 18th, 2002
'ALIAS sayz:
'Gradients for colors
'movement up/down: gravity

'CHDIR "C:\qbasic\myprogs\bike"

ini.gamesettings

menu.main

REM $STATIC
SUB advance.time
'sun
IF sun.height% = 40 THEN
sun.dir% = 2
sun.height% = sun.height% - 1
ELSEIF sun.height% = 200 THEN
sun.dir% = 0
sun.height% = sun.height% + 1
END IF

IF sun.dir% = 1 THEN
sun.height% = sun.height% + 1
ELSEIF sun.dir% = -1 THEN
sun.height% = sun.height% - 1
ELSEIF sun.dir% = 0 THEN
sun.wait% = sun.wait% + 1
ELSEIF sun.dir% = 2 THEN
sun.wait% = sun.wait% - 1
END IF

IF sun.wait% > 30 THEN
sun.dir% = -1: sun.wait% = 0
sun.height% = sun.height% - 2
ELSEIF sun.wait% < -100 THEN
sun.dir% = 1: sun.wait% = 0
sun.height% = sun.height% + 2
END IF

'moon
IF moon.height% = 40 THEN
moon.dir% = 2
moon.height% = moon.height% - 1
ELSEIF moon.height% = 200 THEN
moon.dir% = 0
moon.height% = moon.height% + 1
END IF

IF moon.dir% = 1 THEN
moon.height% = moon.height% + 1
ELSEIF moon.dir% = -1 THEN
moon.height% = moon.height% - 1
ELSEIF moon.dir% = 0 THEN
moon.wait% = moon.wait% + 1
ELSEIF moon.dir% = 2 THEN
moon.wait% = moon.wait% - 1
END IF

IF moon.wait% > 25 THEN
moon.dir% = -1: moon.wait% = 0
moon.height% = moon.height% - 2
ELSEIF moon.wait% < -80 THEN
moon.dir% = 1: moon.wait% = 0
moon.height% = moon.height% + 2
END IF

'advance clouds
FOR I% = 1 TO cloud.amount%

x = cloudx%(I%): Y = cloudy%(I%): col = 15: size = cloud.rad%(I%) * 5: Y = Y - size / 2

cloudx%(I%) = cloudx%(I%) + 1
IF cloudx%(I%) > 330 THEN GOSUB remove.cloud
NEXT I%

IF prev.cloud% > 0 THEN
add.cloud% = INT(RND * 30 / (prev.cloud% * 4))
IF INT(RND * 6) = 0 OR prev.cloud% = 5 THEN prev.cloud% = 0
ELSE
add.cloud% = INT(RND * 30)
END IF

IF add.cloud% = 0 AND cloud.amount% < cloud.max% THEN GOSUB add.cloud

EXIT SUB
remove.cloud:
FOR j% = I% TO cloud.amount% - 1
cloudx%(j%) = cloudx%(j% + 1)
cloudy%(j%) = cloudy%(j% + 1)
cloud.rad%(j%) = cloud.rad%(j% + 1)
NEXT j%
cloud.amount% = cloud.amount% - 1
RETURN

add.cloud:
prev.cloud% = prev.cloud% + 1
cloud.amount% = cloud.amount% + 1
cloud.rad%(cloud.amount%) = INT(RND * 30) + 5

IF prev.cloud% > 1 THEN
cloudy%(cloud.amount%) = (INT(RND * 80) + cloudy%(cloud.amount% - 1)) / 2
ELSE
cloudy%(cloud.amount%) = INT(RND * 80)
END IF
RETURN

END SUB

SUB badguy.collision (n%)
IF lim1(n%) = 0 THEN
d2% = ABS((adj.x% - obj.x%(n%)) - (bikester.x% + 36))
IF d2% <= wt% THEN 'X proximity
IF bikester.y% >= adj.y% THEN                   'Y min
IF bikester.y% <= adj.y% + obj.y%(n%) THEN      'Y max
life.bar% = life.bar% - 1: guy.alive = 0
play.sound (3)
END IF
ELSE
n2% = ammo.type%(n%)
IF ammo.ap%(n2%) <> 0 AND ABS(d2% - ammo.pos%(n2%)) <= 40 THEN
fire.badguy.alive n2%, n%
IF guy.ammo%(n%) > 0 THEN life.bar% = life.bar% - ammo.ap%(n2%): guy.ammo%(n%) = 0
play.sound (4)
END IF
END IF
END IF
END IF
END SUB

SUB bikester.move
'IF jump% = 1 THEN
'FOR j% = 1 TO bike.speed%
'bikester.y% = bikester.y% + 1
'IF bikester.y% = 50 THEN fall% = 1: jump% = 0
'NEXT j%
'ELSEIF fall% = 1 THEN
'FOR j% = 1 TO bike.speed%
'bikester.y% = bikester.y% - 1'accel1#
'IF bikester.y% <= 0 THEN fall% = 0: bikester.y% = 0
'NEXT j%
'END IF

jump% = jump% - 98
bikester.y% = bikester.y% + jump% / 100
IF bikester.y% <= 0 THEN
  bikester.y% = 0
  jump% = 0
END IF

END SUB

SUB day.night.cycle
IF sun.dir% = 2 THEN COLOR , 1: LINE (0, 0)-(320, 200), 1, BF:  ELSE COLOR , 9: LINE (0, 0)-(320, 200), 9, BF
END SUB

SUB draw.badguy.alive (n%)
temp2% = adj.y%
adj.y% = 195 - adj.y%

SELECT CASE n%
CASE 1
CIRCLE (adj.x% + 8, adj.y% - 7), 7, 7
PAINT (adj.x% + 8, adj.y% - 7), 8, 7
CIRCLE (adj.x% + 8, adj.y% - 7), 2, 7
PAINT (adj.x% + 8, adj.y% - 7), 8, 7
CASE 2
LINE (adj.x% + 1, adj.y% - 1)-(adj.x% + 13, adj.y% - 1), 8
LINE (adj.x% + 2, adj.y% - 2)-(adj.x% + 12, adj.y% - 2), 8
LINE (adj.x% + 3, adj.y% - 3)-(adj.x% + 11, adj.y% - 3), 8

CASE 3
LINE (adj.x% - 26 - 30, adj.y% + 1 - 2)-(adj.x% + 10 - 30, adj.y% + 1 - 2), 8
LINE (adj.x% - 25 - 30, adj.y% - 2)-(adj.x% + 10 - 30, adj.y% - 2), 8
LINE (adj.x% - 24 - 30, adj.y% - 1 - 2)-(adj.x% + 10 - 30, adj.y% - 1 - 2), 8
LINE (adj.x% - 23 - 30, adj.y% - 2 - 2)-(adj.x% + 10 - 30, adj.y% - 2 - 2), 8
LINE (adj.x% - 22 - 30, adj.y% - 3 - 2)-(adj.x% + 10 - 30, adj.y% - 3 - 2), 8
LINE (adj.x% - 21 - 30, adj.y% - 4 - 2)-(adj.x% + 10 - 30, adj.y% - 4 - 2), 8
LINE (adj.x% - 20 - 30, adj.y% - 5 - 2)-(adj.x% + 10 - 30, adj.y% - 5 - 2), 8
LINE (adj.x% - 22 - 30, adj.y% - 3 - 2)-(adj.x% - 15 - 30, adj.y% - 3 - 2), 1
LINE (adj.x% - 21 - 30, adj.y% - 4 - 2)-(adj.x% - 15 - 30, adj.y% - 4 - 2), 1
LINE (adj.x% - 20 - 30, adj.y% - 5 - 2)-(adj.x% - 15 - 30, adj.y% - 5 - 2), 1
LINE (adj.x% - 30, adj.y% - 6 - 2)-(adj.x% + 10 - 30, adj.y% - 6 - 2), 8
LINE (adj.x% + 1 - 30, adj.y% - 7 - 2)-(adj.x% + 10 - 30, adj.y% - 7 - 2), 8
LINE (adj.x% + 2 - 30, adj.y% - 8 - 2)-(adj.x% + 10 - 30, adj.y% - 8 - 2), 8
LINE (adj.x% + 3 - 30, adj.y% - 9 - 2)-(adj.x% + 10 - 30, adj.y% - 9 - 2), 8

CASE 4
LINE (adj.x% + 30 - 10, adj.y% + 25 - 37)-(adj.x% + 20 - 10, adj.y% + 21 - 37), 4
LINE (adj.x% + 10 - 10, adj.y% + 25 - 37)-(adj.x% + 20 - 10, adj.y% + 21 - 37), 4
LINE (adj.x% + 10 - 10, adj.y% + 25 - 37)-(adj.x% + 20 - 10, adj.y% + 15 - 37), 4
PSET (adj.x% + 13 - 10, adj.y% + 23 - 37), 4
LINE (adj.x% + 20 - 10, adj.y% + 15 - 37)-(adj.x% + 30 - 10, adj.y% + 15 - 37), 4
LINE (adj.x% + 30 - 10, adj.y% + 15 - 37)-(adj.x% + 32 - 10, adj.y% + 7 - 37), 4
LINE (adj.x% + 32 - 10, adj.y% + 7 - 37)-(adj.x% + 40 - 10, adj.y% + 7 - 37), 4
LINE (adj.x% + 40 - 10, adj.y% + 7 - 37)-(adj.x% + 42 - 10, adj.y% + 15 - 37), 4
LINE (adj.x% + 42 - 10, adj.y% + 15 - 37)-(adj.x% + 50 - 10, adj.y% + 15 - 37), 4
LINE (adj.x% + 50 - 10, adj.y% + 15 - 37)-(adj.x% + 60 - 10, adj.y% + 25 - 37), 4
LINE (adj.x% + 60 - 10, adj.y% + 25 - 37)-(adj.x% + 50 - 10, adj.y% + 21 - 37), 4
LINE (adj.x% + 50 - 10, adj.y% + 21 - 37)-(adj.x% + 40 - 10, adj.y% + 25 - 37), 4
LINE (adj.x% + 40 - 10, adj.y% + 25 - 37)-(adj.x% + 40 - 10, adj.y% + 30 - 37), 4
LINE (adj.x% + 40 - 10, adj.y% + 30 - 37)-(adj.x% + 30 - 10, adj.y% + 30 - 37), 4
LINE (adj.x% + 30 - 10, adj.y% + 30 - 37)-(adj.x% + 30 - 10, adj.y% + 25 - 37), 4
PAINT (adj.x% + 35 - 10, adj.y% + 25 - 37), 4, 4
CIRCLE (adj.x% + 20 - 10, adj.y% + 30 - 37), 7, 7
PAINT (adj.x% + 20 - 10, adj.y% + 30 - 37), 8, 7
CIRCLE (adj.x% + 20 - 10, adj.y% + 30 - 37), 2, 7
PAINT (adj.x% + 20 - 10, adj.y% + 30 - 37), 8, 7
CIRCLE (adj.x% + 50 - 10, adj.y% + 30 - 37), 7, 7
PAINT (adj.x% + 50 - 10, adj.y% + 30 - 37), 8, 7
CIRCLE (adj.x% + 50 - 10, adj.y% + 30 - 37), 2, 7
PAINT (adj.x% + 50 - 10, adj.y% + 30 - 37), 8, 7
PSET (adj.x% + 36 - 10, adj.y% + 10 - 37), 8
PSET (adj.x% + 33 - 10, adj.y% + 10 - 37), 8
CASE 5
LINE (adj.x% + 30 - 10, adj.y% + 25 - 37)-(adj.x% + 20 - 10, adj.y% + 21 - 37), 3
LINE (adj.x% + 10 - 10, adj.y% + 25 - 37)-(adj.x% + 20 - 10, adj.y% + 21 - 37), 3
LINE (adj.x% + 10 - 10, adj.y% + 25 - 37)-(adj.x% + 20 - 10, adj.y% + 15 - 37), 3
PSET (adj.x% + 13 - 10, adj.y% + 23 - 37), 3
LINE (adj.x% + 20 - 10, adj.y% + 15 - 37)-(adj.x% + 30 - 10, adj.y% + 15 - 37), 3
LINE (adj.x% + 30 - 10, adj.y% + 15 - 37)-(adj.x% + 32 - 10, adj.y% + 7 - 37), 3
LINE (adj.x% + 32 - 10, adj.y% + 7 - 37)-(adj.x% + 40 - 10, adj.y% + 7 - 37), 3
LINE (adj.x% + 40 - 10, adj.y% + 7 - 37)-(adj.x% + 42 - 10, adj.y% + 15 - 37), 3
LINE (adj.x% + 42 - 10, adj.y% + 15 - 37)-(adj.x% + 50 - 10, adj.y% + 15 - 37), 3
LINE (adj.x% + 50 - 10, adj.y% + 15 - 37)-(adj.x% + 60 - 10, adj.y% + 25 - 37), 3
LINE (adj.x% + 60 - 10, adj.y% + 25 - 37)-(adj.x% + 50 - 10, adj.y% + 21 - 37), 3
LINE (adj.x% + 50 - 10, adj.y% + 21 - 37)-(adj.x% + 40 - 10, adj.y% + 25 - 37), 3
LINE (adj.x% + 40 - 10, adj.y% + 25 - 37)-(adj.x% + 40 - 10, adj.y% + 30 - 37), 3
LINE (adj.x% + 40 - 10, adj.y% + 30 - 37)-(adj.x% + 30 - 10, adj.y% + 30 - 37), 3
LINE (adj.x% + 30 - 10, adj.y% + 30 - 37)-(adj.x% + 30 - 10, adj.y% + 25 - 37), 3
PAINT (adj.x% + 35 - 10, adj.y% + 25 - 37), 9, 3
CIRCLE (adj.x% + 20 - 10, adj.y% + 30 - 37), 7, 7
PAINT (adj.x% + 20 - 10, adj.y% + 30 - 37), 8, 7
CIRCLE (adj.x% + 20 - 10, adj.y% + 30 - 37), 2, 7
PAINT (adj.x% + 20 - 10, adj.y% + 30 - 37), 8, 7
CIRCLE (adj.x% + 50 - 10, adj.y% + 30 - 37), 7, 7
PAINT (adj.x% + 50 - 10, adj.y% + 30 - 37), 8, 7
CIRCLE (adj.x% + 50 - 10, adj.y% + 30 - 37), 2, 7
PAINT (adj.x% + 50 - 10, adj.y% + 30 - 37), 8, 7
PSET (adj.x% + 36 - 10, adj.y% + 10 - 37), 8
PSET (adj.x% + 33 - 10, adj.y% + 10 - 37), 8
END SELECT

adj.y% = temp2%
END SUB

SUB draw.bikester
CLS
LINE (30, 25)-(20, 21), 4
LINE (10, 25)-(20, 21), 4
LINE (10, 25)-(20, 15), 4
PSET (13, 23), 4
LINE (20, 15)-(30, 15), 4
LINE (30, 15)-(32, 7), 4
LINE (32, 7)-(40, 7), 4
LINE (40, 7)-(42, 15), 4
LINE (42, 15)-(50, 15), 4
LINE (50, 15)-(60, 25), 4
LINE (60, 25)-(50, 21), 4
LINE (50, 21)-(40, 25), 4
LINE (40, 25)-(40, 30), 4
LINE (40, 30)-(30, 30), 4
LINE (30, 30)-(30, 25), 4
PAINT (35, 25), 4, 4
CIRCLE (20, 30), 7, 7
PAINT (20, 30), 8, 7
CIRCLE (20, 30), 2, 7
PAINT (20, 30), 8, 7
CIRCLE (50, 30), 7, 7
PAINT (50, 30), 8, 7
CIRCLE (50, 30), 2, 7
PAINT (50, 30), 8, 7
PSET (36, 10), 1
PSET (39, 10), 1
'GET (10, 7)-(60, 36), bikester
END SUB

SUB draw.clouds
FOR I% = 1 TO cloud.amount%

x = cloudx%(I%): Y = cloudy%(I%): col = 15: size = cloud.rad%(I%) * 5: Y = Y - size / 2
FOR k% = 13 * size / 32 TO 19 * size / 32
j% = -size * COS(2 * 3.141528 * k% / size) / 1.2
LINE (x - j% + size * 1.25 / 2, Y + k%)-(x + j% - size * 1.25 / 2, Y + k%), col
NEXT k%

cloudx%(I%) = cloudx%(I%) + 1
NEXT I%
END SUB

SUB draw.grass
LINE (0, screen1.max.y%)-(screen1.max.x%, screen1.max.y% - 5), 2, BF
PAINT (0, screen1.max.y% - 1), 2, 2
EXIT SUB

j% = 32
FOR I% = 0 TO 320 / j%
LINE ((I% - 1) * j%, screen1.max.y% - prevr%)-(I% * j%, screen1.max.y% - r%(I%)), 2
prevr% = r%(I%)
NEXT I%

mmp2 = mmp2 - 1
IF mmp2 = -j% + 1 THEN
mmp2 = 0
FOR I% = 0 TO 320 / j% - 1
r%(I%) = r%(I% + 1)
NEXT I%
r%(I%) = INT(RND * 10) + prevr% / 2 + 2
END IF
LINE (0, screen1.max.y%)-(screen1.max.x%, screen1.max.y%), 2
PAINT (0, screen1.max.y% - 1), 2, 2

END SUB

SUB draw.life.bar
FOR I% = 1 TO life.bar%
j% = (I% - 1) * 6 + 160
LINE (j%, 12)-(j% + 3, 20), 15, BF
LINE (j% - 1, 11)-(j% + 4, 21), 2, B
NEXT I%
END SUB

SUB draw.mountains
j% = 10
FOR I% = 0 TO (320 - j%) / j% + 1
LINE (I% * j% + mmp, p1%(I%))-((I% + 1) * j% + mmp, p1%(I% + 1)), 6
prevpk% = pk%
cl% = cl% + 1: IF INT(RND * 15) = 1 OR cl% = 15 THEN cl% = 0
NEXT I%

mmp = mmp - 1
IF mmp = -j% + 1 THEN
mmp = 0
FOR I% = 0 TO (320 - j%) / j% + 1
p1%(I%) = p1%(I% + 1)
NEXT I%

IF cl% = 0 THEN
pk% = INT(RND * 40)
ELSE
pk% = (INT(RND * 40) * (15 - cl%) / 20 + prevpk% * cl% / 15) / 1.5
END IF
p1%(I%) = 125 + prevpk% * 4
IF p1%(I%) > 190 THEN p1%(I%) = 190
prevpk% = pk%
cl% = cl% + 1: IF INT(RND * 15) = 1 OR cl% = 15 THEN cl% = 0
END IF

LINE (0, screen1.max.y% - 6)-(screen1.max.x%, screen1.max.y% - 6), 6
PAINT (0, screen1.max.y% - 7), 6, 6
END SUB

SUB draw.snow
IF snow.active% = 1 THEN
FOR x = 1 TO snow.severity%
'IF cl% = 0 THEN
snow.x% = 320 - INT(RND * 310)
snow.y% = 200 - (INT(RND * 190) + 5)
'ELSE
'snow.x% = (320 - (INT(RND * 310) + prev.x%) / 2)
'snow.y% = (195 - (INT(RND * 190) + prev.y%) / 2)
'END IF
prev.x% = snow.x%
prev.y% = snow.y%
PSET (snow.x%, snow.y%), 15
cl% = cl% + 1: IF INT(RND * 10) = 1 OR cl% = 10 THEN cl% = 0
NEXT x
END IF
snow.interval% = snow.interval% - 1

IF snow.interval% = 0 THEN
snow.interval% = INT(RND * 250) + 100
snow.severity% = INT(RND * 30) + 10
snow.active% = 1 - snow.active%
END IF
END SUB

SUB draw.sun
IF sun.height% > 40 THEN
CIRCLE (160, 300 - sun.height%), 20, 14
PAINT (160, 300 - sun.height%), 14, 14
END IF

IF moon.height% > 40 THEN
CIRCLE (160, 300 - moon.height%), 15, 7
PAINT (160, 300 - moon.height%), 7, 7
END IF
END SUB

SUB fire.badguy.alive (n2%, n%)
SELECT CASE n2%
CASE 1:
LINE (adj.x% + 5 - 50, 195 - adj.y%)-(adj.x% + 11 - 50, 165 - bikester.y%), 3, BF
LINE (adj.x% + 6 - 50, 195 - adj.y%)-(adj.x% + 10 - 50, 165 - bikester.y%), 1, BF
CASE 2:
LINE (adj.x% + 5 - 50, 195 - adj.y%)-(adj.x% + 11 - 50, 165 - bikester.y%), 2, BF
LINE (adj.x% + 6 - 50, 195 - adj.y%)-(adj.x% + 10 - 50, 165 - bikester.y%), 4, BF
END SELECT
END SUB

SUB game.ending (n%)
SCREEN , , 0, 0
CLS
SELECT CASE n%
CASE 1
PRINT "The Incredible Bikester destroyed"
PRINT "the aliens and saved earth once"
PRINT "again."
CASE 2
PRINT "You lost. Ha ha ha. (lame)"
END SELECT
END SUB

SUB ini.badguys
guy.name$(1) = "tire"
guy.name$(2) = "rock"
guy.name$(3) = "hawk"
guy.name$(4) = "cycle"
guy.name$(5) = "cycle shooter"

enemy.start.x%(1) = 320: enemy.start.y%(1) = 0
enemy.start.x%(2) = 320: enemy.start.y%(2) = 0
enemy.start.x%(3) = 400: enemy.start.y%(3) = 50
enemy.start.x%(4) = 320: enemy.start.y%(4) = 0
enemy.start.x%(5) = 320: enemy.start.y%(5) = 0

scoreon.pass(1) = 1
scoreon.pass(2) = 1
scoreon.pass(3) = 0
scoreon.pass(4) = 1
scoreon.pass(5) = 1

guy.ammo.max%(3) = 1
ammo.type%(3) = 1

guy.ammo.max%(5) = 1
ammo.type%(5) = 2

ammo.pos%(1) = 10
ammo.ap%(1) = 1

ammo.pos%(2) = 15
ammo.ap%(2) = 1

'collision with missile player...ignore?
lim1(1) = 0
lim1(2) = 0
lim1(3) = 0
lim1(4) = 0
lim1(5) = 0

lim2(1) = 0
lim2(2) = 1
lim2(3) = 0
lim2(4) = 0
lim2(5) = 0

'object.sizeY
obj.y%(1) = 8
obj.y%(2) = 3
obj.y%(3) = 25
obj.y%(4) = 20
obj.y%(5) = 20

'object.sizeX
obj.x%(1) = 7
obj.x%(2) = 7
obj.x%(3) = 40
obj.x%(4) = 50
obj.x%(4) = 50

d.result%(1) = 0
d.result%(2) = 0
d.result%(3) = 0
d.result%(4) = 1
d.result%(5) = 4
END SUB

SUB ini.clouds
FOR I% = 1 TO cloud.max%
cloudy%(I%) = 0: cloudx%(I%) = 0: cloud.rad%(I%) = 0
NEXT I%
cloud.amount% = 0
END SUB

SUB ini.gamesettings
ini.badguys
ini.keyname
speed.str$(0) = "Speed Demon"
speed.str$(1) = "Cheetah"
speed.str$(2) = "Legal Limit"
speed.str$(3) = "Normal"
speed.str$(4) = "Sleepy"
speed.str$(5) = "Turtle"
sound.str$(0) = "Yes"
sound.str$(1) = "No"
settings.desc$(1) = " to shoot"
settings.desc$(2) = " to jump"
settings.desc$(3) = " to accelerate"
settings.desc$(4) = " to decelerate"
settings.desc$(5) = " for >> speed burst"
settings.desc$(6) = " for << speed burst"
settings.desc$(7) = " to pause"
settings.desc$(8) = "Speed: "
settings.desc$(9) = "Sound: "
settings.desc$(10) = "Reset Keys to Default: "
FOR I% = 1 TO 7
settings.max%(I%) = 128 + 134
NEXT I%
settings.max%(8) = 5
settings.max%(9) = 1
load.keysettings

ini.speedsettings 'must come after gamesettings
END SUB

SUB ini.grass
EXIT SUB
prevr% = 0
j% = 32
FOR I% = 0 TO 320 / j%
r%(I%) = INT(RND * 10) + prevr% / 2 + 2
LINE ((I% - 1) * j%, screen1.max.y% - prevr%)-(I% * j%, screen1.max.y% - r%(I%)), 2
prevr% = r%(I%)
NEXT I%
END SUB

SUB ini.keyname
FOR I% = 33 TO 96
settings.keyname$(I%) = CHR$(I%)
NEXT I%
FOR I% = 123 TO 126
settings.keyname$(I%) = CHR$(I%)
NEXT I%

settings.keyname$(128 + 72) = ""
settings.keyname$(128 + 80) = ""
settings.keyname$(128 + 75) = ""
settings.keyname$(128 + 77) = ""
settings.keyname$(8) = "<backspace>"
settings.keyname$(13) = "<enter>"
settings.keyname$(27) = "<escape>"
settings.keyname$(32) = "<space>"
settings.keyname$(9) = "<tab>"

settings.keyname$(73 + 128) = "<page up>"
settings.keyname$(81 + 128) = "<page down>"
settings.keyname$(71 + 128) = "<home>"
settings.keyname$(79 + 128) = "<end>"
settings.keyname$(82 + 128) = "<insert>"
settings.keyname$(83 + 128) = "<delete>"

settings.keyname$(59 + 128) = "<F1>"
settings.keyname$(60 + 128) = "<F2>"
settings.keyname$(61 + 128) = "<F3>"
settings.keyname$(62 + 128) = "<F4>"
settings.keyname$(63 + 128) = "<F5>"
settings.keyname$(64 + 128) = "<F6>"
settings.keyname$(65 + 128) = "<F7>"
settings.keyname$(66 + 128) = "<F8>"
settings.keyname$(67 + 128) = "<F9>"
settings.keyname$(68 + 128) = "<F10>"
settings.keyname$(133 + 128) = "<F11>"
settings.keyname$(134 + 128) = "<F11>"
END SUB

SUB ini.keysettings
settings%(1) = 32
settings%(2) = 72 + 128
settings%(3) = 43
settings%(4) = 45
settings%(5) = 77 + 128
settings%(6) = 75 + 128
settings%(7) = 80
settings%(8) = 3
settings%(9) = 1
END SUB

SUB ini.mountains
mmp = 0
j% = 10

FOR I% = 0 TO (320 - j%) / j% + 2
p1%(I%) = 0
NEXT I%

FOR I% = 0 TO (320 - j%) / j% + 2
IF cl% = 0 THEN
pk% = INT(RND * 40)
ELSE
pk% = (INT(RND * 40) * (15 - cl%) / 20 + prevpk% * cl% / 15) / 1.5
END IF
temp1% = 125 + prevpk% * 4
temp2% = 125 + pk% * 4
IF temp1% > 190 THEN temp1% = 190
IF temp2% > 190 THEN temp2% = 190
p1%(I%) = temp1%
LINE (I% * j%, temp1%)-((I% + 1) * j%, temp2%), 6
prevpk% = pk%
cl% = cl% + 1: IF INT(RND * 15) = 1 OR cl% = 15 THEN cl% = 0
NEXT I%

END SUB

SUB ini.snow
snow.interval% = INT(RND * 250) + 100
snow.severity% = INT(RND * 30) + 10
snow.active% = INT(RND * 2)
END SUB

SUB ini.speedsettings
'set the speed settings..
SELECT CASE settings%(8)
CASE 0: wt% = 22
CASE 1: wt% = 16
CASE 2: wt% = 12
CASE 3: wt% = 9
CASE 4: wt% = 6: wt2% = 2
CASE 5: wt% = 3: wt2% = 4
END SELECT
END SUB

SUB kill.check (n%)
'COLOR 15: LOCATE 1, 1: PRINT missile.y%; obj.y%(n%); missile.x% + 36; adj.x%
'further the missile
missile.x% = missile.x% + 25
CIRCLE (missile.x%, 185 - missile.y%), 5, 14
PAINT (missile.x% - 3, 185 - missile.y%), 14, 14
IF missile.x% > 320 THEN shoot = 0

IF guy.alive < 1 THEN EXIT SUB

IF adj.x% - (missile.x% + 36) <= 10 AND lim2(n%) = 0 THEN
IF ABS(missile.y% - adj.y%) <= 10 THEN
IF missile.y% <= adj.y% + obj.y%(n%) THEN

shoot = 0
score = score + 1

IF d.result%(n%) <> 0 THEN
guy.index = d.result%(n%)
play.sound (2)
ELSE
guy.alive = 0
END IF

END IF
END IF
END IF
END SUB

SUB load.keysettings
OPEN "bike.ini" FOR INPUT AS #1
DO
LINE INPUT #1, A$
I% = I% + 1
settings%(I%) = VAL(A$)
LOOP UNTIL EOF(1)
CLOSE
END SUB

SUB menu.gameinfo
COLOR 15, 1
sentence.max% = 39
sentence.min% = 2
PRINT
PRINT
print2 "   The Incredible Bikester Omega 2"
COLOR 3
print2 "           by Agamemnus"
PRINT
PRINT
COLOR 7
print2 "   Human spies have found out that the aliens have rebuilt their forces and are planning to attack again. The Incredible Bikester must go to the alien world and stop them."
PRINT
print2 "   The object of the game is to jump over rocks and tires and to destroy enemy bikes and remote jets. When your score reaches 50 you win. Watch out for remote jets because they shoot lasers at you!"
LINE (5, 5)-(315, 195), 15, B
PCOPY 0, 1
sleep2
END SUB

SUB menu.main
DO
n% = 5
x1% = 14
y1% = 9
SCREEN 7, , 0, 1
COLOR , 0
n% = 1
adj.x% = x1% * 6
GOSUB showmenu
PCOPY 0, 1
CLS
DO
I$ = UCASE$(INKEY$): I% = 0
IF I$ <> "" THEN
IF LEN(I$) = 2 THEN I% = 128 + ASC(RIGHT$(I$, 1)) ELSE I% = ASC(I$)
IF I% = 27 THEN n% = 4: EXIT DO
IF I% = 13 THEN EXIT DO
IF I% = 72 + 128 THEN n% = n% - 1: IF n% < 1 THEN n% = 4
IF I% = 80 + 128 THEN n% = n% + 1: IF n% > 4 THEN n% = 1
GOSUB showmenu
PCOPY 0, 1
CLS
END IF
LOOP

SELECT CASE n%
CASE 1: menu.gameinfo
CASE 2: menu.settings
CASE 3: menu.playgame
CASE 4: EXIT DO
END SELECT
CLS
LOOP
menu.quit
EXIT SUB

showmenu:
COLOR 1
LOCATE 7, x1%: PRINT "Bikester Omega II"
adj.y% = (y1% + n%) * 8 + 2
COLOR 15
LOCATE y1% + 1, x1%: PRINT "How to Play / Info"
LOCATE y1% + 2, x1%: PRINT "Game Settings"
LOCATE y1% + 3, x1%: PRINT "Play the Game"
LOCATE y1% + 4, x1%: PRINT "Quit"
CIRCLE (adj.x% + 8, adj.y% - 7), 7, 7
PAINT (adj.x% + 8, adj.y% - 7), 8, 7
CIRCLE (adj.x% + 8, adj.y% - 7), 2, 7
PAINT (adj.x% + 8, adj.y% - 7), 8, 7
RETURN
END SUB

SUB menu.playgame
prev.cloud% = 0
sun.wait% = 0: sun.height% = 100: sun.dir% = 1
moon.wait% = -10: moon.height% = 39: moon.dir% = 2

'initial settings..
jump% = 0
level = 1
score = 0
bikester.x% = 0: bikester.y% = 0
missile.x% = 0: missile.y% = 0
adj.x% = 0: adj.y% = 0
screen1.max.x% = 320: screen1.max.y% = 200
miles.elapsed% = 0
life.bar% = 15
bike.speed% = 5
guy.alive = 0
CLS

ini.snow
ini.mountains
ini.grass
ini.clouds
DO
time.elapsed2% = time.elapsed2% + 1
IF time.elapsed2% = 5 THEN time.elapsed2% = 0: time.elapsed% = time.elapsed% + 1

speed.adjust

miles.elapsed% = miles.elapsed% + 1

day.night.cycle


IF game.setting%(9) = 1 THEN play.sound (1)'play music/sound effects
I2% = I2% + 1
IF I2% = 4 THEN
advance.time
I2% = 0
END IF
draw.sun
draw.clouds
draw.mountains
draw.grass
draw.snow

put.bikester
draw.life.bar
LOCATE 1, 21, 1: PRINT "Score  "; score

I$ = UCASE$(INKEY$): I% = 0
IF I$ <> "" THEN
I2$ = INKEY$
IF LEN(I$) = 2 THEN I% = 128 + ASC(RIGHT$(I$, 1)) ELSE I% = ASC(I$)
SELECT CASE I%
CASE 27:  game.status% = 2
CASE settings%(1): IF shoot = 0 THEN shoot = 1: missile.y% = bikester.y%: missile.x% = bikester.x% + 60
CASE settings%(2): IF jump% = 0 THEN jump% = 1200
CASE settings%(3): bike.speed% = bike.speed% + 1: IF bike.speed% > 10 THEN bike.speed% = 10
CASE settings%(4): bike.speed% = bike.speed% - 1: IF bike.speed% < 1 THEN bike.speed% = 1
CASE settings%(5): bikester.x% = bikester.x% + bike.speed%: IF bikester.x% > 260 THEN bikester.x% = 260
CASE settings%(6): bikester.x% = bikester.x% - bike.speed%: IF bikester.x% < 10 THEN bikester.x% = 10
CASE settings%(7): pause.game
END SELECT
END IF

IF game.status% <> 0 THEN EXIT DO

IF guy.alive = 0 THEN
IF time.elapsed% > 20 THEN
tp = INT(RND * uguy.amount%) + 1
guy.name$ = guy.name$(tp)
adj.x% = enemy.start.x%(tp)
adj.y% = enemy.start.y%(tp)
guy.alive = 1
guy.index = tp
guy.ammo%(guy.index) = guy.ammo.max%(guy.index)
END IF
END IF

bikester.move

IF guy.alive THEN
adj.x% = adj.x% - wt%
draw.badguy.alive (guy.index)
badguy.collision (guy.index)

'test for win/lose condition
IF score = 50 THEN game.status% = 1
IF life.bar% = -1 THEN game.status% = 2

IF adj.x% < 0 THEN
IF scoreon.pass%(guy.index) THEN score = score + 1
guy.alive = 0
END IF

END IF

IF shoot = 1 THEN kill.check (guy.index)
PCOPY 0, 1
LOOP

game.ending (game.status%)
END SUB

SUB menu.quit
PRINT
PRINT "Thanks for playing!"
PRINT
PRINT "Press any key to quit."
PCOPY 0, 1
DO: LOOP UNTIL INKEY$ <> ""
END SUB

SUB menu.settings
FOR I% = 1 TO 9
prevsettings%(I%) = settings%(I%)
NEXT I%
CLS
COLOR 2, 1: n% = 3: j% = 1: GOSUB dispsetts
DO
I$ = UCASE$(INKEY$): I% = 0
IF I$ <> "" THEN
IF LEN(I$) = 2 THEN I% = 128 + ASC(RIGHT$(I$, 1)) ELSE I% = ASC(I$)
IF I% = 27 THEN
FOR I% = 1 TO 9
settings%(I%) = prevsettings%(I%)
NEXT I%
EXIT DO
END IF
IF I% = 13 THEN
ini.speedsettings
IF settings%(10) = 1 THEN settings%(10) = 0: ini.keysettings
save.keysettings
EXIT DO
END IF
IF I% = 72 + 128 THEN j% = j% - 1: IF j% < 1 THEN j% = 10
IF I% = 80 + 128 THEN j% = j% + 1: IF j% > 10 THEN j% = 1
IF j% = 8 OR j% = 9 THEN
IF I% = 77 + 128 THEN settings%(j%) = settings%(j%) - 1: IF settings%(j%) < 0 THEN settings%(j%) = settings.max%(j%)
IF I% = 75 + 128 THEN settings%(j%) = settings%(j%) + 1: IF settings%(j%) > settings.max%(j%) THEN settings%(j%) = 0
ELSEIF j% <= 7 THEN
IF I% = 75 + 128 THEN
1 : settings%(j%) = settings%(j%) - 1
IF settings%(j%) < 0 THEN settings%(j%) = settings.max%(j%)
IF LEN(settings.keyname$(settings%(j%))) < 1 THEN GOTO 1
ELSEIF I% = 77 + 128 THEN
2 : settings%(j%) = settings%(j%) + 1
IF settings%(j%) > settings.max%(j%) THEN settings%(j%) = 0
IF LEN(settings.keyname$(settings%(j%))) < 1 THEN GOTO 2
END IF
ELSEIF j% = 10 THEN
IF I% = 75 + 128 OR I% = 77 + 128 THEN settings%(10) = 1 - settings%(10)
END IF

GOSUB dispsetts
END IF
LOOP
EXIT SUB

dispsetts:
LOCATE 1, n%: PRINT
LOCATE , n%: PRINT
COLOR 3: LOCATE , n%: PRINT "Current Settings": COLOR 2
LOCATE , n%: PRINT
FOR I% = 1 TO 10
IF I% = j% THEN COLOR 15:  ELSE COLOR 7
IF I% <= 7 THEN
LOCATE , n%: PRINT settings.keyname$(settings%(I%)); settings.desc$(I%)
ELSEIF I% = 8 THEN
LOCATE , n%: PRINT
LOCATE , n%: PRINT settings.desc$(I%); speed.str$(settings%(I%))
ELSEIF I% = 9 OR I% = 10 THEN
LOCATE , n%: PRINT settings.desc$(I%); sound.str$(1 - settings%(I%))
END IF
NEXT I%
LINE (5, 5)-(315, 195), 15, B
PCOPY 0, 1: CLS
RETURN

END SUB

SUB pause.game
sleep2
END SUB

SUB play.sound (n%)
SELECT CASE n%
END SELECT
END SUB

SUB print2 (string1$)
slength% = 1 + sentence.max% - sentence.min%

DO
len2% = LEN(string1$)
IF len2% < slength% + 1 THEN
EXIT DO
ELSE
'PRINT LEN(string1$); slength%; sentence.max%; sentence.min%
'PCOPY 0, 1
FOR I% = slength% TO 1 STEP -1
'back up until finding a " " in the last spot.
IF MID$(string1$, I%, 1) = " " THEN EXIT FOR
NEXT I%
stringb$ = LEFT$(string1$, I%)
string1$ = RIGHT$(string1$, len2% - I% + 1)
LOCATE , sentence.min%: PRINT stringb$
END IF
LOOP

LOCATE , sentence.min%: PRINT string1$
END SUB

SUB put.bikester
j% = 34: I% = bikester.x% / j% + 1

adj2.x% = bikester.x%
adj2.y% = 195 - bikester.y%
 
LINE (adj2.x% + 20, adj2.y% + 25 - 37)-(adj2.x% + 20 - 10, adj2.y% + 21 - 37), 4
LINE (adj2.x%, adj2.y% + 25 - 37)-(adj2.x% + 20 - 10, adj2.y% + 21 - 37), 4
LINE (adj2.x%, adj2.y% + 25 - 37)-(adj2.x% + 20 - 10, adj2.y% + 15 - 37), 4
PSET (adj2.x% + 3, adj2.y% + 23 - 37), 4
LINE (adj2.x% + 10, adj2.y% + 15 - 37)-(adj2.x% + 30 - 10, adj2.y% + 15 - 37), 4
LINE (adj2.x% + 20, adj2.y% + 15 - 37)-(adj2.x% + 32 - 10, adj2.y% + 7 - 37), 4
LINE (adj2.x% + 22, adj2.y% + 7 - 37)-(adj2.x% + 40 - 10, adj2.y% + 7 - 37), 4
LINE (adj2.x% + 30, adj2.y% + 7 - 37)-(adj2.x% + 42 - 10, adj2.y% + 15 - 37), 4
LINE (adj2.x% + 32, adj2.y% + 15 - 37)-(adj2.x% + 50 - 10, adj2.y% + 15 - 37), 4
LINE (adj2.x% + 40, adj2.y% + 15 - 37)-(adj2.x% + 60 - 10, adj2.y% + 25 - 37), 4
LINE (adj2.x% + 50, adj2.y% + 25 - 37)-(adj2.x% + 50 - 10, adj2.y% + 21 - 37), 4
LINE (adj2.x% + 40, adj2.y% + 21 - 37)-(adj2.x% + 40 - 10, adj2.y% + 25 - 37), 4
LINE (adj2.x% + 30, adj2.y% + 25 - 37)-(adj2.x% + 40 - 10, adj2.y% + 30 - 37), 4
LINE (adj2.x% + 30, adj2.y% + 30 - 37)-(adj2.x% + 30 - 10, adj2.y% + 30 - 37), 4
LINE (adj2.x% + 20, adj2.y% + 30 - 37)-(adj2.x% + 30 - 10, adj2.y% + 25 - 37), 4
PAINT (adj2.x% + 25, adj2.y% + 25 - 37), 4, 4
CIRCLE (adj2.x% + 10, adj2.y% + 30 - 37), 7, 7
PAINT (adj2.x% + 10, adj2.y% + 30 - 37), 8, 7
CIRCLE (adj2.x% + 10, adj2.y% + 30 - 37), 2, 7
PAINT (adj2.x% + 10, adj2.y% + 30 - 37), 8, 7
CIRCLE (adj2.x% + 40, adj2.y% + 30 - 37), 7, 7
PAINT (adj2.x% + 40, adj2.y% + 30 - 37), 8, 7
CIRCLE (adj2.x% + 40, adj2.y% + 30 - 37), 2, 7
PAINT (adj2.x% + 40, adj2.y% + 30 - 37), 8, 7
PSET (adj2.x% + 28, adj2.y% + 10 - 37), 1
PSET (adj2.x% + 25, adj2.y% + 10 - 37), 1
END SUB

SUB save.keysettings
OPEN "bike.ini" FOR OUTPUT AS #1
FOR I% = 1 TO 9
A$ = LTRIM$(STR$(settings%(I%)))
PRINT #1, A$
NEXT I%
CLOSE
END SUB

SUB sleep2
DO: LOOP UNTIL INKEY$ <> ""
END SUB

SUB speed.adjust
WAIT &H3DA, 8: WAIT &H3DA, 8, 8
'FOR I% = 0 TO 1: FOR j% = 0 TO 10000: NEXT j%, I%
END SUB

