(include "game.sh")

(script 700)

(use "game")
(use "obj")
(use "main")
(use "controls")

(instance public TimeoutRegion of Rgn
  (properties)
  (method (newRoom room)
        (= keep  /* When ego leaves the region, this flag gets set to zero *(
                (EqualsAny(room /* These rooms comprise the TimeoutRegion */
                                1 2 3 4 5 )
        (super:newRoom(room))
  )
  (method (handleEvent event)
        /* Put region-specific Said handling here */
         (if(Said('open>'))
           (if(Said('/doors'))
            Print("You see no doors here to open.")
           )
         )
         (if(Said('look>'))
           (if(Said('/doors'))
            Print("You see no doors here.")
           )
         )
         (if(Said('eat>'))
           (if(Said('/burger'))
            (if(== Hamburger 1)
             Print("You eat your hamburger.")
             (= Hamburger 0)
             (= gScore(- gScore 2))
             (send gEgo:put (INV_HAMBURGER 700))
            )(else
             Print("You don't have a hamburger.")
            )
           )
         )
         (if(Said('drink>'))
           (if(Said('/cola'))
            (if(== Cola 1)
             Print("You drink a cola. How refreshing.")
             (send gEgo:put (INV_COLA 700))
             (= Cola 0)
             (= gScore(- gScore 2))
            )
           )
         )
        (super:handleEvent(event))
  )
  (method (doit)
        (var dyingScript)
                (if(>= gTimeMinutes C64die)
                  = dyingScript ScriptID(DYING_SCRIPT)
                  (send dyingScript:
                            caller(3))
                    Print("The time is run out. It's too late to save your beloved computer Commodore 64. "+
                          "You must be quicker next time.")
                  (send dyingScript:
                            register("Game over! Thank you for playing \"DG: I want my C64 back\"."))
                  (self:dispose()) /* This avoids infinite loops */
                  (send gGame:setScript(dyingScript))
  )
 )
)
/******************************************************************************/
