DEFINT A-Z

'$DYNAMIC
'$INCLUDE: 'DIRECTQB.BI'

DECLARE SUB LoadPic (nfile$, darray())
DECLARE SUB PalLoad (palname$)
DECLARE SUB RunScript (ScriptEntry$)
DECLARE SUB MapAction ()
DECLARE SUB GetMainSprites ()
DECLARE SUB LoadMap (FirstTime)
DECLARE SUB MoveYou ()
DECLARE SUB DrawMap ()
DECLARE SUB LetsGetReadyToRumble (BossAttack)
DECLARE SUB ActivateThatShit (InBattle, ItemSlot)
DECLARE SUB UseThemSpells (InBattle, SpellCode, SubMenu, Boss)
DECLARE SUB BattleDraw (Attacker)
DECLARE SUB EnterOrSpace ()
DECLARE SUB LoadSavedGame (choice)
DECLARE SUB PopText (TextLayer, TextString$, TextX, TextY, TextColor, OuterBox)
DECLARE SUB DelayNow (DelayTime!)
DECLARE SUB HealDude (Dude, Sweet)
DECLARE SUB DamageEnemyDude (Dude, Sweet)

DECLARE FUNCTION Menu (MenuX, MenuY, MenuMax, MenuDefault, SpecialCode)
DECLARE FUNCTION BytesRequired& (Filename$)
DECLARE FUNCTION SelectEnemy ()
DECLARE FUNCTION SelectAlly ()

DECLARE SUB LoadMIDI (Filename$, MIDISegment%, MIDIOffset%)
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB StopMIDI ()

RANDOMIZE TIMER

TYPE ItemProperties
   ItemName AS STRING * 16
   ItemType AS INTEGER
   ItemPrice AS LONG
   ItemPower AS INTEGER
END TYPE

TYPE Guystats
    Level AS INTEGER
    Charname AS STRING * 8
    Weapon AS INTEGER
    Armor AS INTEGER
    Hits AS INTEGER
    MaxHits AS INTEGER
    Magic AS INTEGER
    MaxMagic AS INTEGER
    Agility AS INTEGER
    Wisdom AS INTEGER
    Strength AS INTEGER
    Experience AS LONG
    Spells AS STRING * 20
END TYPE

DIM SHARED MenuArray$(1 TO 20)

DIM SHARED ThePalette AS STRING * 768
DIM SHARED Stats(1 TO 4) AS Guystats
DIM SHARED Items(50) AS ItemProperties
DIM SHARED MusFile$
DIM SHARED OldMusFile$
DIM SHARED ThisMap$
DIM SHARED EntryPoint$
DIM SHARED EnemyCount AS INTEGER
DIM SHARED EnemyAgi AS INTEGER
DIM SHARED EnemyStr AS INTEGER
DIM SHARED EnemyDef AS INTEGER
DIM SHARED EnemyMDef AS INTEGER
DIM SHARED EnemyIntel AS INTEGER
DIM SHARED NumEnemies AS INTEGER
DIM SHARED ExitScript AS INTEGER
DIM SHARED MoveDir AS INTEGER
DIM SHARED Blocker AS INTEGER
DIM SHARED XScroll AS INTEGER: DIM SHARED YScroll AS INTEGER
DIM SHARED OffSetX AS INTEGER: DIM SHARED OffSetY AS INTEGER
DIM SHARED YouX AS INTEGER: DIM SHARED YouY AS INTEGER
DIM SHARED OldX AS INTEGER: DIM SHARED OldY AS INTEGER
DIM SHARED BossX AS INTEGER: DIM SHARED BossY AS INTEGER
DIM SHARED ScreenX AS INTEGER: DIM SHARED ScreenY AS INTEGER
DIM SHARED BodyCount AS INTEGER: DIM SHARED EBodyCount AS INTEGER
DIM SHARED BattleOn AS INTEGER
DIM SHARED InNet AS INTEGER
DIM SHARED CyberPoints AS INTEGER
DIM SHARED Gold AS LONG
DIM SHARED PutArray(2000)
DIM SHARED Defaultile(50)
DIM SHARED LocalFlag(10)
DIM SHARED Invent(100)
DIM SHARED GotBox(100)
DIM SHARED TileCoord(50, 1 TO 2)
DIM SHARED SpriteCoord(100, 1 TO 2)
DIM SHARED EnemyCoord(5, 1 TO 2)
DIM SHARED EnvMap(130, 130)
DIM SHARED EntMap(130, 131)
DIM SHARED Gauge(1 TO 4)
DIM SHARED EnemyGauge(1 TO 5)
DIM SHARED EnemyHP(1 TO 5)
DIM SHARED ObjectName$(100)
DIM SHARED LevUp(1 TO 30) AS LONG

LevUp(1) = 30
FOR x = 2 TO 30
    LevUp(x) = LevUp(x - 1) * 1.8
NEXT x
LevUp(30) = 2147483647


IF DQBinit(4, 0, 0) THEN DQBclose: PRINT DQBerror$: END

DQBinitVGA
DQBprint 0, "LOADING...", 130, 96, 15
DQBinstallKeyboard

DIM SHARED MidiArray%(BytesRequired("MUSIC\BOSS.MID"))

OffSetX = 0: OffSetY = 0
TileCoord(0, 1) = 0: TileCoord(0, 2) = 0

MoveDir = 2
ExitNow = 0

OPEN "DAT\ITEMS.DAT" FOR INPUT AS #1
    CurItem = 0
    Items(0).ItemName = "-"
    Items(0).ItemType = 0
    Items(0).ItemPrice = 0
    Items(0).ItemPower = 0
    LINE INPUT #1, tempstr$
    WHILE tempstr$ <> ""
        CurItem = CurItem + 1
        Items(CurItem).ItemName = tempstr$
        INPUT #1, Items(CurItem).ItemType
        INPUT #1, Items(CurItem).ItemPrice
        INPUT #1, Items(CurItem).ItemPower
        LINE INPUT #1, tempstr$
    WEND
CLOSE #1

LoadSavedGame 1234
LoadMap 1
ScreenX = YouX - 10: ScreenY = YouY - 6
GetMainSprites

DO
   IF ExitScript = 1 THEN DQBpalOff
   IF YScroll = -1 THEN
      FOR OffSetY = -14 TO 0 STEP 2
         DrawMap
         WAIT &H3DA, 8
         DQBcopyLayer 1, 0
      NEXT OffSetY
   ELSEIF XScroll = -1 THEN
      FOR OffSetX = -14 TO 0 STEP 2
         DrawMap
         WAIT &H3DA, 8
         DQBcopyLayer 1, 0
      NEXT OffSetX
   ELSEIF YScroll = 1 THEN
      FOR OffSetY = 14 TO 0 STEP -2
         DrawMap
         WAIT &H3DA, 8
         DQBcopyLayer 1, 0
      NEXT OffSetY
   ELSEIF XScroll = 1 THEN
      FOR OffSetX = 14 TO 0 STEP -2
         DrawMap
         WAIT &H3DA, 8
         DQBcopyLayer 1, 0
      NEXT OffSetX
   ELSE
      DrawMap
      WAIT &H3DA, 8
      DQBcopyLayer 1, 0
   END IF
   IF XScroll OR YScroll THEN
      EnemyCount = EnemyCount - 1
      IF EnemyCount < 1 THEN
         EnemyCount = RND * 35 + 35
         LetsGetReadyToRumble 0
         IF BattleOn = -1 THEN ExitNow = 1
      END IF
   END IF
   IF ExitScript = 1 THEN
      DQBfadeIn ThePalette
      ExitScript = 0
   END IF
   OffSetX = 0: OffSetY = 0
   XScroll = 0: YScroll = 0
   Blocker = 0
   OldX = YouX: OldY = YouY
   MoveYou
   IF DQBkey(KEYESC) THEN
      MainMenu = 1
      DO
         DQBcopyLayer 1, 0
         MenuArray$(1) = "Status"
         MenuArray$(2) = "Items"
         MenuArray$(3) = "Magic"
         IF InNet THEN MenuArray$(3) = "Cyber"
         MenuArray$(4) = "Order"
         MenuArray$(5) = "Save Game"
         MenuArray$(6) = "Exit"
         PopText 0, "Gold:" + STR$(Gold), 16, 69, 94, 1
         MainMenu = Menu(2, 2, 6, MainMenu, 0)
         IF MainMenu = 3 AND InNet THEN MainMenu = 7
         DQBcopyLayer 1, 0
         SELECT CASE MainMenu
            CASE 1
               SubMenu = 1
               DO
                  PopText 0, Stats(SubMenu).Charname, 16, 10, 94, 1
                  LoadPic "BIGPIC\" + RTRIM$(Stats(SubMenu).Charname) + "F.AWD", PutArray()
                  DQBbox 0, 14, 22, 67, 75, 95
                  DQBbox 0, 15, 23, 66, 74, 90
                  DQBboxf 0, 16, 24, 65, 73, 0
                  DQBput 0, 16, 24, VARSEG(PutArray(0)), VARPTR(PutArray(0))
                  DQBbox 0, 98, 8, 312, 89, 95
                  DQBbox 0, 99, 9, 311, 88, 90
                  DQBboxf 0, 100, 10, 310, 87, 88
                  PopText 0, "HP:" + STR$(Stats(SubMenu).Hits) + "/" + LTRIM$(STR$(Stats(SubMenu).MaxHits)), 100, 10, 94, 0
                  PopText 0, "MP:" + STR$(Stats(SubMenu).Magic) + "/" + LTRIM$(STR$(Stats(SubMenu).MaxMagic)), 100, 20, 94, 0
                  PopText 0, "Level:" + STR$(Stats(SubMenu).Level) + " Exp:" + STR$(Stats(SubMenu).Experience) + "/" + LTRIM$(STR$(LevUp(Stats(SubMenu).Level))), 100, 30, 93, 0
                  PopText 0, "Strength:" + STR$(Stats(SubMenu).Strength), 100, 40, 93, 0
                  PopText 0, "Agility:" + STR$(Stats(SubMenu).Agility), 100, 50, 93, 0
                  PopText 0, "Wisdom:" + STR$(Stats(SubMenu).Wisdom), 100, 60, 93, 0
                  PopText 0, "Weapon: " + RTRIM$(Items(Stats(SubMenu).Weapon).ItemName) + " (" + LTRIM$(STR$(Items(Stats(SubMenu).Weapon).ItemPower)) + ")", 100, 70, 93, 0
                  PopText 0, "Armor: " + RTRIM$(Items(Stats(SubMenu).Armor).ItemName) + " (" + LTRIM$(STR$(Items(Stats(SubMenu).Armor).ItemPower)) + ")", 100, 80, 93, 0
                  FOR SubMenu2 = 1 TO 4
                     MenuArray$(SubMenu2) = Stats(SubMenu2).Charname
                  NEXT SubMenu2
                  SubMenu = Menu(2, 10, 4, SubMenu, 0)
               LOOP UNTIL SubMenu = -1
            CASE 2
               SubMenu = 1
               DO
                  DQBcopyLayer 1, 0
                  SubMenu = Menu(12, 2, 100, SubMenu, 1)
                  IF SubMenu = -1 THEN
                  ELSEIF Invent(SubMenu) <> 0 THEN
                     MenuArray$(1) = "Use/Equip"
                     MenuArray$(2) = "Examine"
                     MenuArray$(3) = "Drop"
                     ItemAction = Menu(2, 5, 3, 1, 0)
                     IF ItemAction = 1 THEN
                        ActivateThatShit 0, SubMenu
                        IF MenuArray$(1) = "D" THEN Invent(SubMenu) = 0
                     ELSEIF ItemAction = 2 THEN
                        OPEN "DAT\DESC.DAT" FOR INPUT AS #1
                           FOR g = 1 TO Invent(SubMenu)
                              LINE INPUT #1, MenuArray$(1)
                           NEXT g
                           g = Menu(2, 6, 1, 1, 0)
                        CLOSE #1
                     ELSEIF ItemAction = 3 THEN
                        IF Items(Invent(SubMenu)).ItemType <> 7 THEN
                           MenuArray$(1) = "Drop it"
                           MenuArray$(2) = "No, wait!!!"
                           YorNSubMenu = Menu(2, 9, 2, 2, 0)
                           IF YorNSubMenu = 1 THEN Invent(SubMenu) = 0
                        END IF
                     END IF
                  END IF
               LOOP UNTIL SubMenu = -1
            CASE 3
               SubMenu = 1
               DO
                  DQBcopyLayer 1, 0
                  FOR g = 1 TO 4
                     MenuArray$(g) = Stats(g).Charname + LTRIM$(STR$(Stats(g).Magic)) + "/" + LTRIM$(STR$(Stats(g).MaxMagic))
                  NEXT g
                  SubMenu = Menu(2, 10, 4, SubMenu, 0)
                  IF SubMenu > -1 THEN
                     FOR g = 1 TO 20
                        IF MID$(Stats(SubMenu).Spells, g, 1) = "B" THEN
                           MenuArray$(g) = Items(g + 17).ItemName + STR$(Items(g + 17).ItemPower)
                        ELSE
                           MenuArray$(g) = "-"
                        END IF
                     NEXT g
                     SpellToUse = Menu(18, 4, 20, 1, 0)
                     Stu = SpellToUse + 17
                     IF SpellToUse = -1 THEN
                        'Fall through
                     ELSEIF MenuArray$(SpellToUse) = "-" THEN
                        MenuArray$(1) = "Not a spell!"
                        SpellToUse = Menu(2, 2, 1, 1, 0)
                        SpellToUse = -1
                     ELSEIF Stats(SubMenu).Magic < Items(Stu).ItemPower THEN
                        MenuArray$(1) = "Not enough MP!"
                        SpellToUse = Menu(2, 2, 1, 1, 0)
                        SpellToUse = -1
                     ELSE
                        UseThemSpells 0, SpellToUse, SubMenu, 0
                     END IF
                  END IF
               LOOP UNTIL SubMenu = -1
            CASE 4
               DO
                  FOR SubMenu = 1 TO 4
                     MenuArray$(SubMenu) = " " + Stats(SubMenu).Charname
                  NEXT SubMenu
                  SubMenu = Menu(2, 10, 4, 1, 0)
                  IF SubMenu = -1 THEN EXIT DO
                  FOR SubMenu2 = 1 TO 4
                     IF SubMenu2 = SubMenu THEN
                        MenuArray$(SubMenu2) = ">" + Stats(SubMenu2).Charname
                     ELSE
                        MenuArray$(SubMenu2) = " " + Stats(SubMenu2).Charname
                     END IF
                  NEXT SubMenu2
                  SubMenu2 = Menu(2, 10, 4, SubMenu, 0)
                  IF SubMenu2 = -1 THEN EXIT DO
                  SWAP Stats(SubMenu), Stats(SubMenu2)
               LOOP
               GetMainSprites
            CASE 5
               FOR SubMenu = 1 TO 5
                  MenuArray$(SubMenu) = "SAVE" + LTRIM$(STR$(SubMenu))
               NEXT SubMenu
               choice = Menu(12, 2, 5, 1, 0)
               IF choice < 6 AND choice > 0 THEN
                  OPEN "SAVEGAME\SAVE" + RIGHT$(STR$(choice), 1) FOR OUTPUT AS #1
                     PRINT #1, ThisMap$
                     PRINT #1, YouX
                     PRINT #1, YouY
                     PRINT #1, Gold
                     PRINT #1, CyberPoints
                     FOR SaveMe = 1 TO 100
                        PRINT #1, CHR$(Invent(SaveMe) + 64);
                        PRINT #1, CHR$(GotBox(SaveMe) + 64);
                     NEXT SaveMe
                     PRINT #1, ""
                     FOR SaveMe = 1 TO 4
                        PRINT #1, Stats(SaveMe).Level
                        PRINT #1, Stats(SaveMe).Charname
                        PRINT #1, Stats(SaveMe).Weapon
                        PRINT #1, Stats(SaveMe).Armor
                        PRINT #1, Stats(SaveMe).Hits
                        PRINT #1, Stats(SaveMe).MaxHits
                        PRINT #1, Stats(SaveMe).Magic
                        PRINT #1, Stats(SaveMe).MaxMagic
                        PRINT #1, Stats(SaveMe).Agility
                        PRINT #1, Stats(SaveMe).Wisdom
                        PRINT #1, Stats(SaveMe).Strength
                        PRINT #1, Stats(SaveMe).Experience
                        PRINT #1, Stats(SaveMe).Spells
                     NEXT SaveMe
                     FOR SaveMe = 1 TO 10
                        PRINT #1, LocalFlag(SaveMe)
                     NEXT SaveMe
                  CLOSE #1
               END IF
            CASE 6
               MenuArray$(1) = "Yes"
               MenuArray$(2) = "No"
               PopText 0, "Do you really want to exit?", 70, 70, 95, 1
               YornMenu = Menu(19, 11, 2, 2, 0)
               IF YornMenu = 1 THEN ExitNow = 1
            CASE 7
               MenuArray$(1) = "You have" + STR$(CyberPoints) + " cyber points"
               YornMenu = Menu(9, 11, 1, 1, 0)
               MainMenu = 3
         END SELECT
      LOOP UNTIL ExitNow = 1 OR MainMenu = -1
   END IF
   IF XScroll <> 0 OR YScroll <> 0 THEN MapAction
LOOP UNTIL ExitNow

DQBfadeTo 0, 0, 0

StopMIDI

DQBclose

REM $STATIC
SUB ActivateThatShit (InBattle, ItemSlot)
   ItemCode = Invent(ItemSlot)
   FOR g = 1 TO 4
      MenuArray$(g) = Stats(g).Charname
   NEXT g
   SELECT CASE Items(ItemCode).ItemType
      CASE 1
         IF InBattle THEN
            UseOnWho = SelectAlly
         ELSE
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname + "HP:" + LTRIM$(STR$(Stats(g).Hits)) + "/" + LTRIM$(STR$(Stats(g).MaxHits))
            NEXT g
            PopText 0, "Use on who?", 10, 10, 92, 1
            UseOnWho = Menu(2, 10, 4, 1, 0)
         END IF
         IF UseOnWho > -1 THEN
            HealedYou = Items(ItemCode).ItemPower
            HealDude UseOnWho, HealedYou
            IF InBattle THEN
               PopText 0, STR$(HealedYou), 230 + UseOnWho * 15, UseOnWho * 32 + 40, 23, 0
               DelayNow 1.5
            ELSE
               FOR g = 1 TO 4
                  MenuArray$(g) = Stats(g).Charname + "HP:" + LTRIM$(STR$(Stats(g).Hits)) + "/" + LTRIM$(STR$(Stats(g).MaxHits))
               NEXT g
               g = Menu(2, 10, 4, -1, 0)
               MenuArray$(1) = "Healed " + RTRIM$(Stats(UseOnWho).Charname) + STR$(HealedYou) + " HP"
               UseOnWho = Menu(2, 2, 1, 1, 0)
            END IF
            MenuArray$(1) = "D"
         END IF
      CASE 3
         IF InBattle = 0 THEN
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname + "HP:" + LTRIM$(STR$(Stats(g).Hits)) + "/" + LTRIM$(STR$(Stats(g).MaxHits))
               MenuArray$(g) = MenuArray$(g) + "  MP:" + LTRIM$(STR$(Stats(g).Magic)) + "/" + LTRIM$(STR$(Stats(g).MaxMagic))
            NEXT g
            g = Menu(2, 10, 4, -1, 0)
            MenuArray$(1) = "Time to go to sleep"
            MenuArray$(2) = "No way! We're not tired!"
            UseOnWho = Menu(2, 2, 2, 1, 0)
            IF UseOnWho = 1 THEN
               StopMIDI
               LoadMIDI "MUSIC\GOODNITE.MID", VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
               PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
                                  
               DQBclearLayer 0
               FOR g = 1 TO 4
                  Stats(g).Hits = Stats(g).MaxHits
                  Stats(g).Magic = Stats(g).MaxMagic
               NEXT g
               MenuArray$(1) = "Good night!"
               InnFlag = Menu(10, 10, 1, 1, 0)
               InnFlag = 1
                                  
               StopMIDI
               LoadMIDI "MUSIC\" + MusFile$, VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
               PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
               MenuArray$(1) = "D"
            END IF
         END IF
      CASE 5
         IF InBattle = 0 THEN
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname
            NEXT g
            PopText 0, "Who will equip?", 10, 10, 92, 1
            UseOnWho = Menu(2, 10, 4, 1, 0)
            IF UseOnWho > -1 THEN SWAP Stats(UseOnWho).Weapon, Invent(ItemSlot)
         END IF
      CASE 6
         IF InBattle = 0 THEN
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname
            NEXT g
            PopText 0, "Who will equip?", 10, 10, 92, 1
            UseOnWho = Menu(2, 10, 4, 1, 0)
            IF UseOnWho > -1 AND Stats(UseOnWho).Charname <> "Rydar   " THEN
               SWAP Stats(UseOnWho).Armor, Invent(ItemSlot)
            END IF
         END IF
      CASE 7
         IF InBattle = 0 THEN
            MenuArray$(1) = "It doesn't seem to do anything"
            UseOnWho = Menu(2, 2, 1, 1, 0)
         END IF
      CASE 8
         IF InBattle = 0 THEN
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname
            NEXT g
            PopText 0, "Who will equip?", 10, 10, 92, 1
            UseOnWho = Menu(2, 10, 4, 1, 0)
            IF UseOnWho > -1 AND Stats(UseOnWho).Charname = "Rydar   " THEN
               SWAP Stats(UseOnWho).Armor, Invent(ItemSlot)
            END IF
         END IF
      CASE 9
         IF InBattle THEN
            UseOnWho = SelectAlly
         ELSE
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname + "MP:" + LTRIM$(STR$(Stats(g).Magic)) + "/" + LTRIM$(STR$(Stats(g).MaxMagic))
            NEXT g
            PopText 0, "Use on who?", 10, 10, 92, 1
            UseOnWho = Menu(2, 10, 4, 1, 0)
         END IF
         IF UseOnWho > -1 THEN
            HealedYou = Items(ItemCode).ItemPower
            Stats(UseOnWho).Magic = Stats(UseOnWho).Magic + HealedYou
            IF Stats(UseOnWho).Magic > Stats(UseOnWho).MaxMagic THEN Stats(UseOnWho).Magic = Stats(UseOnWho).MaxMagic
            IF InBattle THEN
               PopText 0, STR$(HealedYou), 230 + UseOnWho * 15, UseOnWho * 32 + 40, 94, 0
               DelayNow 1.5
            ELSE
               FOR g = 1 TO 4
                  MenuArray$(g) = Stats(g).Charname + "MP:" + LTRIM$(STR$(Stats(g).Magic)) + "/" + LTRIM$(STR$(Stats(g).MaxMagic))
               NEXT g
               g = Menu(2, 10, 4, -1, 0)
               MenuArray$(1) = "Healed " + RTRIM$(Stats(UseOnWho).Charname) + STR$(HealedYou) + " MP"
               UseOnWho = Menu(2, 2, 1, 1, 0)
            END IF
            MenuArray$(1) = "D"
         END IF
      CASE IS > 100
         IF InBattle = 0 THEN
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname
            NEXT g
            PopText 0, "Who will learn?", 10, 10, 92, 1
            UseOnWho = Menu(2, 10, 4, 1, 0)
            IF UseOnWho > -1 THEN
               MID$(Stats(UseOnWho).Spells, (Items(ItemCode).ItemType MOD 100), 1) = "B"
               MenuArray$(1) = "Learned the spell!"
               UseOnWho = Menu(2, 2, 1, 1, 0)
               MenuArray$(1) = "D"
            END IF
         END IF
   END SELECT
END SUB

SUB BattleDraw (Attacker)
   DQBcopyLayer 4, 1
  
   'bad guyz
   FOR g = 1 TO NumEnemies
      IF EnemyHP(g) > 0 THEN DQBxPut 2, 260, 140, 310, 190, 1, EnemyCoord(g, 1), EnemyCoord(g, 2)
   NEXT g
  
   'good guyz
   FOR g = 1 TO 4
      IF Stats(g).Hits < 1 THEN
         DQBxPut 3, (g - 1) * 50, 141, g * 50 - 1, 181, 1, 190 + g * 15, g * 32 + 18
      ELSE
         IF g = Attacker THEN
            CALL LoadPic("BIGPIC\" + RTRIM$(Stats(g).Charname) + MenuArray$(1), PutArray())
            DQBput 1, 160 + g * 15, g * 32 + 18, VARSEG(PutArray(0)), VARPTR(PutArray(0))
         ELSE
            DQBxPut 3, (g - 1) * 50, 100, g * 50 - 20, 140, 1, 190 + g * 15, g * 32 + 18
         END IF
         PopText 1, Stats(g).Charname + STR$(Stats(g).Hits) + "/" + LTRIM$(STR$(Stats(g).MaxHits)), 3, (g - 1) * 8, 95, 0
         DQBboxf 1, 218 + g * 15, g * 32 + 20, 258 + g * 15, g * 32 + 21, 19
         DQBboxf 1, 218 + g * 15, g * 32 + 20, 218 + (Stats(g).Hits / Stats(g).MaxHits) * 40 + g * 15, g * 32 + 21, 23
         DQBboxf 1, 218 + g * 15, g * 32 + 23, 258 + g * 15, g * 32 + 24, 163
         DQBboxf 1, 218 + g * 15, g * 32 + 23, 218 + (Stats(g).Magic / Stats(g).MaxMagic) * 40 + g * 15, g * 32 + 24, 167
         DQBboxf 1, 218 + g * 15, g * 32 + 26, 258 + g * 15, g * 32 + 27, 91
         DQBboxf 1, 218 + g * 15, g * 32 + 26, 218 + (Gauge(g) / 100) * 40 + g * 15, g * 32 + 27, 95
      END IF
   NEXT g
   DQBcopyLayer 1, 0
END SUB

SUB DamageEnemyDude (Dude, Sweet)
   EnemyHP(Dude) = EnemyHP(Dude) - Sweet
   IF EnemyHP(Dude) < 1 THEN
      EnemyHP(Dude) = 0
      EnemyGauge(Dude) = 0
      EBodyCount = EBodyCount + 1
   END IF
END SUB

SUB DrawMap
   DQBclearLayer 1
   FOR firsty = ScreenY - 1 TO ScreenY + 13
      FOR firstx = ScreenX - 1 TO ScreenX + 20
         x = firstx: y = firsty
         IF x > 128 THEN x = 128
         IF y > 128 THEN y = 128
         IF x < 1 THEN x = 1
         IF y < 1 THEN y = 1
         xx = TileCoord(EnvMap(x, y), 1)
         yy = TileCoord(EnvMap(x, y), 2)
         DQBxPut 2, xx, yy, xx + 15, yy + 15, 1, ((firstx - ScreenX) * 16) + OffSetX, ((firsty - ScreenY) * 16) + OffSetY
         SELECT CASE Defaultile(EnvMap(x, y))
            CASE 3
               xx = RND * 16
               yy = RND * 16
               DQBpset 1, ((firstx - ScreenX) * 16) + OffSetX + xx, ((firsty - ScreenY) * 16) + OffSetY + yy, 21 + (RND * 2)
            CASE 4
               zz = RND * 10
               IF zz > 8 THEN EnvMap(x, y) = EnvMap(x, y) + 1
            CASE 5
               zz = RND * 10
               IF zz > 8 THEN EnvMap(x, y) = EnvMap(x, y) - 1
            CASE IS > 10
               zz = RND * 10
               IF zz > 8 THEN EnvMap(x, y) = EnvMap(x, y) - (Defaultile(EnvMap(x, y)) - 10)
         END SELECT
      NEXT firstx
   NEXT firsty
   FOR firsty = ScreenY - 1 TO ScreenY + 14
      FOR firstx = ScreenX - 1 TO ScreenX + 20
         x = firstx: y = firsty
         IF x > 128 OR x < 1 THEN x = 1
         IF y > 128 OR y < 1 THEN y = 1
         ObjectTemp$ = ObjectName$(EntMap(x, y))
         SELECT CASE MID$(ObjectTemp$, 1, 1)
            CASE "", "", "", "", "", "", "", "", "", "", ""
               ObjectTemp$ = MID$(ObjectTemp$, 2)
         END SELECT
         IF LEFT$(ObjectTemp$, 7) = "SPRITE\" THEN
            xx = SpriteCoord(EntMap(x, y), 1)
            yy = SpriteCoord(EntMap(x, y), 2)
            DQBxPut 3, xx, yy, xx + 15, yy + 31, 1, ((firstx - ScreenX) * 16) + OffSetX, ((firsty - ScreenY - 1) * 16) + OffSetY
         END IF
         IF YouX = firstx AND YouY = firsty THEN
            SELECT CASE MoveDir
               CASE 2
                  DQBxPut 2, 0, 100, 15, 131, 1, 160, 80
               CASE 8
                  DQBxPut 2, 16, 100, 31, 131, 1, 160, 80
               CASE 4
                  DQBxPut 2, 32, 100, 47, 131, 1, 160, 80
               CASE 6
                  DQBxPut 2, 48, 100, 64, 131, 1, 160, 80
            END SELECT
         END IF
      NEXT firstx
   NEXT firsty
   DQBsetSolidPut
   FOR firsty = ScreenY + 4 TO ScreenY + 7
      FOR firstx = ScreenX + 9 TO ScreenX + 11
         x = firstx: y = firsty
         IF x > 128 OR x < 1 THEN x = 1
         IF y > 128 OR y < 1 THEN y = 1
         IF EntMap(x, y) = 3 OR EntMap(x, y) = 4 THEN
            xx = TileCoord(EnvMap(x, y), 1)
            yy = TileCoord(EnvMap(x, y), 2)
            DQBxPut 2, xx, yy, xx + 15, yy + 15, 1, ((firstx - ScreenX) * 16) + OffSetX, ((firsty - ScreenY) * 16) + OffSetY
         END IF
      NEXT firstx
   NEXT firsty
   DQBsetTransPut

END SUB

SUB GetMainSprites
   DQBsetSolidPut
   LoadPic "SPRITE\" + RTRIM$(Stats(1).Charname) + ".AWD", PutArray()
   DQBput 2, 0, 100, VARSEG(PutArray(0)), VARPTR(PutArray(0))
   LoadPic "SPRITE\" + RTRIM$(Stats(1).Charname) + "B.AWD", PutArray()
   DQBput 2, 16, 100, VARSEG(PutArray(0)), VARPTR(PutArray(0))
   LoadPic "SPRITE\" + RTRIM$(Stats(1).Charname) + "L.AWD", PutArray()
   DQBput 2, 32, 100, VARSEG(PutArray(0)), VARPTR(PutArray(0))
   LoadPic "SPRITE\" + RTRIM$(Stats(1).Charname) + "R.AWD", PutArray()
   DQBput 2, 48, 100, VARSEG(PutArray(0)), VARPTR(PutArray(0))
   DQBsetTransPut
END SUB

SUB HealDude (Dude, Sweet)
   'WHAT DOES MINE SAY? "SWEET!" I love that movie :)
   Stats(Dude).Hits = Stats(Dude).Hits + Sweet
   IF Stats(Dude).Hits > Stats(Dude).MaxHits THEN
      Stats(Dude).Hits = Stats(Dude).MaxHits
   ELSEIF Stats(Dude).Hits < 1 THEN
      Gauge(Dude) = 0
      Stats(Dude).Hits = 0
      BodyCount = BodyCount + 1
   END IF
END SUB

SUB LetsGetReadyToRumble (BossAttack)
   BodyCount = 0
   EBodyCount = 0

   IF BossAttack = 0 THEN
      OPEN "MAPFILES\" + ThisMap$ + ".SCR" FOR INPUT AS #1
      LINE INPUT #1, tempstr$
   ELSE
      tempstr$ = "ENEMIES!!!"
   END IF
   IF tempstr$ <> "ENEMIES!!!" THEN
      EnemyCount = 32000
      CLOSE #1
   ELSE
      FOR g = 1 TO 4
         CALL LoadPic("BIGPIC\" + RTRIM$(Stats(g).Charname) + ".AWD", PutArray())
         DQBsetSolidPut
         DQBput 3, (g - 1) * 50, 100, VARSEG(PutArray(0)), VARPTR(PutArray(0))
         DQBsetTransPut
         CALL LoadPic("BIGPIC\" + RTRIM$(Stats(g).Charname) + "X.AWD", PutArray())
         DQBsetSolidPut
         DQBput 3, (g - 1) * 50, 141, VARSEG(PutArray(0)), VARPTR(PutArray(0))
         DQBsetTransPut
         Gauge(g) = RND * 50
         EnemyGauge(g) = RND * 50
      NEXT g
      EnemyGauge(5) = RND * 50

      IF BossAttack THEN
         EnemyFile$ = ThisMap$
      ELSE
         INPUT #1, NumRandomEnemies
         NumRandomEnemies = INT(RND * NumRandomEnemies) + 1
         FOR g = 1 TO NumRandomEnemies
            LINE INPUT #1, EnemyFile$
         NEXT g
         CLOSE #1
      END IF
     
      OPEN "ENEMY\" + EnemyFile$ + ".NME" FOR INPUT AS #1
         LINE INPUT #1, EnemyName$
         LINE INPUT #1, EnemyPic$
        
         CALL LoadPic("ENEMY\SPRITE\" + EnemyPic$, PutArray())
         DQBsetSolidPut
         DQBput 2, 260, 140, VARSEG(PutArray(0)), VARPTR(PutArray(0))
         DQBsetTransPut
        
         LINE INPUT #1, EnemyBg$
         nothing = DQBloadImage(4, 0, 0, "ENEMY\BACK\" + EnemyBg$, ThePalette, 320, 200)
        
         LINE INPUT #1, EnemyTune$
         StopMIDI
         LoadMIDI "MUSIC\" + EnemyTune$, VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
         PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
        
         INPUT #1, RandNum1
         INPUT #1, RandNum2
         FOR g = 1 TO 5
            INPUT #1, EnemyCoord(g, 1)
            INPUT #1, EnemyCoord(g, 2)
         NEXT g
         INPUT #1, NumAttacks
         INPUT #1, EnemyAgi
         INPUT #1, EnemyHlth
         FOR g = 1 TO 5
            EnemyHP(g) = EnemyHlth
         NEXT g
         INPUT #1, EnemyStr
         INPUT #1, EnemyDef
         INPUT #1, EnemyMDef
         INPUT #1, EnemyIntel
      CLOSE #1
    
      NumEnemies = INT(RND * (RandNum2 - RandNum1 + 1)) + RandNum1
      BattleOn = 1
      
      WHILE BattleOn = 1
         BattleDraw 0
         Timer1! = TIMER
         WHILE TIMER - Timer1! < .2: WEND
         FOR CurPlayer = 1 TO 4
            DidSomething = 0
            IF Gauge(CurPlayer) > 99 THEN
               Gauge(CurPlayer) = 0
               DO
                  DQBcopyLayer 1, 0
                  PopText 0, Stats(CurPlayer).Charname, 190, 0, 95, 1
                  MenuArray$(1) = "Attack"
                  MenuArray$(2) = "Magic"
                  IF InNet THEN MenuArray$(2) = "Cyber"
                  MenuArray$(3) = "Item"
                  MenuArray$(4) = "Run"
                  choice = Menu(33, 0, 4 - BossAttack, 1, 0)
                  IF choice = 2 AND InNet THEN choice = 5
                  SELECT CASE choice
                     CASE 1
                        IF BossAttack THEN
                           EnemyToWhack = 1
                        ELSE
                           EnemyToWhack = SelectEnemy
                        END IF
                        IF EnemyToWhack > -1 THEN
                           Damage! = Stats(CurPlayer).Strength * (RND * Items(Stats(CurPlayer).Weapon).ItemPower + RND * Items(Stats(CurPlayer).Weapon).ItemPower)
                           Damage! = Damage! * ((100 - EnemyDef) / 100)
                           MenuArray$(1) = "A.AWD"
                           BattleDraw CurPlayer
                           PopText 0, STR$(INT(Damage!)), EnemyCoord(EnemyToWhack, 1), EnemyCoord(EnemyToWhack, 2) + 40, 167, 0
                           DelayNow 1.5
                           DamageEnemyDude EnemyToWhack, INT(Damage!)
                           DidSomething = 1
                           BattleDraw 0
                        END IF
                     CASE 2
                        FOR g = 1 TO 20
                           IF MID$(Stats(CurPlayer).Spells, g, 1) = "B" THEN
                              MenuArray$(g) = Items(g + 17).ItemName + LTRIM$(STR$(Items(g + 17).ItemPower))
                           ELSE
                              MenuArray$(g) = "-                 "
                           END IF
                        NEXT g
                        PopText 0, "MP:" + STR$(Stats(CurPlayer).Magic) + "/" + LTRIM$(STR$(Stats(CurPlayer).MaxMagic)), 170, 15, 95, 1
                        SpellToUse = Menu(20, 6, 20, 1, 0)
                        IF SpellToUse <> -1 THEN
                           IF MenuArray$(SpellToUse) <> "-                 " AND Stats(CurPlayer).Magic >= Items(SpellToUse + 17).ItemPower THEN
                              UseThemSpells 1, SpellToUse, CurPlayer, BossAttack
                           END IF
                        END IF
                        IF MenuArray$(1) = "D" THEN
                           DidSomething = 1
                           BattleDraw 0
                        END IF
                     CASE 3
                        BattleItem = Menu(22, 6, 100, 1, 1)
                        IF BattleItem > -1 THEN
                           IF Invent(BattleItem) <> 0 THEN
                              ActivateThatShit 1, BattleItem
                              IF MenuArray$(1) = "D" THEN
                                 Invent(BattleItem) = 0
                                 DidSomething = 1
                              END IF
                           END IF
                        END IF
                     CASE 4
                        BattleOn = 0
                        DidSomething = 1
                     CASE 5
                        tempstr$ = ""
                        FOR g = 1 TO 9
                           MenuArray$(g) = LTRIM$(STR$(g))
                        NEXT g
                        MenuArray$(10) = "A"
                        MenuArray$(11) = "B"
                        MenuArray$(12) = "C"
                        MenuArray$(13) = "D"
                        MenuArray$(14) = "E"
                        MenuArray$(15) = "F"
                        CurNum = 1
                        PopText 0, "    ", 138, 8, 92, 1
                        PopText 0, "CP:" + LTRIM$(STR$(CyberPoints)), 138, 18, 92, 1
                        FOR g = 1 TO 4
                           IF CyberPoints < 1 THEN
                              CurNum = -1
                           ELSE
                              CurNum = Menu(24, 2, 15, CurNum, 0)
                           END IF
                           IF CurNum = -1 THEN EXIT FOR
                           PopText 0, MenuArray$(CurNum), 130 + (g * 8), 8, 92, 0
                           tempstr$ = tempstr$ + MenuArray$(CurNum)
                        NEXT g
                        IF CurNum > -1 THEN
                           DidSomething = 1
                           CyberPoints = CyberPoints - 1
                           OPEN "DAT\CYBER.SCR" FOR INPUT AS #1
                              RunScript tempstr$
                           CLOSE #1
                        END IF
                  END SELECT
               LOOP UNTIL DidSomething
               EXIT FOR
            END IF
         NEXT CurPlayer
         IF EBodyCount = NumEnemies + BossAttack THEN
            StopMIDI
            LoadMIDI "MUSIC\WONBATTL.MID", VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
            PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
            OPEN "ENEMY\" + EnemyFile$ + ".SCR" FOR INPUT AS #1
               RunScript "EVENT WONBATTLE"
            CLOSE #1
            BattleOn = 2
         END IF
         FOR g = 1 TO 4
            IF Stats(g).Hits > 0 THEN
               Gauge(g) = Gauge(g) + (RND * Stats(g).Agility) + (RND * 2)
               IF Gauge(g) > 100 THEN Gauge(g) = 100
            END IF
         NEXT g
         FOR CurEnemy = 1 TO NumEnemies + BossAttack
            IF EnemyHP(CurEnemy) > 0 THEN EnemyGauge(CurEnemy) = EnemyGauge(CurEnemy) + (RND * EnemyAgi)
            IF EnemyGauge(CurEnemy) >= 100 AND DidSomething = 0 THEN
               IF BossAttack = 0 THEN DQBbox 0, EnemyCoord(CurEnemy, 1), EnemyCoord(CurEnemy, 2), EnemyCoord(CurEnemy, 1) + 50, EnemyCoord(CurEnemy, 2) + 50, 90
               EnemyGauge(CurEnemy) = 0
               AttackChoice = INT(RND * (NumAttacks * 2)) + 1
               IF AttackChoice > NumAttacks THEN AttackChoice = 1
               OPEN "ENEMY\" + EnemyFile$ + ".SCR" FOR INPUT AS #1
                  RunScript "EVENT ATTACK" + LTRIM$(STR$(AttackChoice))
               CLOSE #1
               BattleDraw 0
               EXIT FOR
            END IF
         NEXT CurEnemy
         IF BodyCount = 4 THEN
            BattleDraw 0
            StopMIDI
            MenuArray$(1) = "You are dead. GAME OVER!"
            BattleOn = Menu(5, 10, 1, 1, 0)
            BattleOn = -1
         END IF
      WEND
     
      IF BattleOn <> -1 THEN
         StopMIDI
         LoadMIDI "MUSIC\" + MusFile$, VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
         PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
      END IF
    
      FOR g = 1 TO 4
         IF Stats(g).Hits = 0 THEN Stats(g).Hits = 1
      NEXT g
      BodyCount = 0
  
   END IF
END SUB

SUB LoadMap (FirstTime)
   EnemyCount = RND * 35 + 35
   DQBfadeTo 0, 0, 0
   DQBclearLayer 0
   DQBsetSolidPut
   OPEN "MAPFILES\" + ThisMap$ + ".ARC" FOR INPUT AS #1
      INPUT #1, InNet
      IF InNet THEN
         PalLoad "NETWORK.PAL"
      ELSE
         PalLoad "AWDRAW.PAL"
      END IF
      OldMusFile$ = MusFile$
      LINE INPUT #1, MusFile$
      IF MusFile$ <> OldMusFile$ THEN
         StopMIDI
         LoadMIDI "MUSIC\" + MusFile$, VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
         PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
      END IF
      LINE INPUT #1, BossName$
      IF BossName$ <> "BLANK.BSV" THEN
         INPUT #1, BossX
         INPUT #1, BossY
      END IF
      INPUT #1, maxtiles
      XCoord = 0: YCoord = 0
      FOR x = 1 TO maxtiles
         LINE INPUT #1, curtile$
         INPUT #1, Defaultile(x)
         CALL LoadPic("TILES\" + curtile$, PutArray())
         DQBput 2, XCoord, YCoord, VARSEG(PutArray(0)), VARPTR(PutArray(0))
         TileCoord(x, 1) = XCoord
         TileCoord(x, 2) = YCoord
         XCoord = XCoord + 16
         IF XCoord > 304 THEN
            XCoord = 0
            YCoord = YCoord + 16
         END IF
         DEF SEG
      NEXT x
      FOR x = 1 TO 128
         LINE INPUT #1, tempstr$
         FOR y = 1 TO 128
            EnvMap(x, y) = ASC(MID$(tempstr$, y, 1)) - 64
         NEXT y
      NEXT x
      ObjectMax = 4
      FOR x = 1 TO 128
         LINE INPUT #1, tempstr$
         FOR y = 1 TO 128
            EntMap(x, y) = ASC(MID$(tempstr$, y, 1)) - 65
            IF EntMap(x, y) > ObjectMax THEN ObjectMax = EntMap(x, y)
         NEXT y
      NEXT x
      XCoord = 0: YCoord = 0
      FOR x = 5 TO ObjectMax
         LINE INPUT #1, ObjectName$(x)
         ObjectTemp$ = ObjectName$(x)
         SELECT CASE MID$(ObjectTemp$, 1, 1)
            CASE "", "", "", "", "", "", "", "", "", "", ""
               ObjectTemp$ = MID$(ObjectTemp$, 2)
         END SELECT
         IF LEFT$(ObjectTemp$, 7) = "SPRITE\" THEN
            CALL LoadPic(ObjectTemp$ + ".AWD", PutArray())
            DQBput 3, XCoord, YCoord, VARSEG(PutArray(0)), VARPTR(PutArray(0))
            SpriteCoord(x, 1) = XCoord
            SpriteCoord(x, 2) = YCoord
            XCoord = XCoord + 16
            IF XCoord > 304 THEN
               XCoord = 0
               YCoord = YCoord + 32
            END IF
         END IF
      NEXT x
   CLOSE #1
  
   IF FirstTime = 0 THEN
      FOR x = 1 TO 128
         FOR y = 1 TO 128
            IF LEFT$(ObjectName$(EntMap(x, y)), 5) = "ENTER" THEN
               IF MID$(ObjectName$(EntMap(x, y)), 7) = EntryPoint$ THEN
                  YouX = x
                  YouY = y
               END IF
            END IF
         NEXT y
      NEXT x
   END IF
  
   DQBsetTransPut
END SUB

SUB LoadSavedGame (choice)
   FOR Saveslots = 1 TO 5
      MenuArray$(Saveslots) = "SAVE" + RIGHT$(STR$(Saveslots), 1)
   NEXT Saveslots
   IF choice <> 1234 THEN choice = Menu(10, 10, 5, 1, 0)
   IF choice = -1 THEN RETURN
   IF choice < 6 THEN OPEN "SAVEGAME\SAVE" + RIGHT$(STR$(choice), 1) FOR INPUT AS #1
   IF choice = 1234 THEN OPEN "SAVEGAME\START" FOR INPUT AS #1
      LINE INPUT #1, ThisMap$
      INPUT #1, YouX
      INPUT #1, YouY
      OldX = YouX: OldY = YouY
      INPUT #1, Gold
      INPUT #1, CyberPoints
      INPUT #1, tempstr$
      FOR SaveMe = 1 TO 100
         Invent(SaveMe) = ASC(MID$(tempstr$, (SaveMe - 1) * 2 + 1, 1)) - 64
         GotBox(SaveMe) = ASC(MID$(tempstr$, (SaveMe - 1) * 2 + 2, 1)) - 64
      NEXT SaveMe
      FOR SaveMe = 1 TO 4
         INPUT #1, Stats(SaveMe).Level
         LINE INPUT #1, Stats(SaveMe).Charname
         INPUT #1, Stats(SaveMe).Weapon
         INPUT #1, Stats(SaveMe).Armor
         INPUT #1, Stats(SaveMe).Hits
         INPUT #1, Stats(SaveMe).MaxHits
         INPUT #1, Stats(SaveMe).Magic
         INPUT #1, Stats(SaveMe).MaxMagic
         INPUT #1, Stats(SaveMe).Agility
         INPUT #1, Stats(SaveMe).Wisdom
         INPUT #1, Stats(SaveMe).Strength
         INPUT #1, Stats(SaveMe).Experience
         LINE INPUT #1, Stats(SaveMe).Spells
      NEXT SaveMe
      FOR SaveMe = 1 TO 10
         INPUT #1, LocalFlag(SaveMe)
      NEXT SaveMe
   CLOSE #1
   GetMainSprites
END SUB

SUB MapAction
   ExitScript = 0
   IF YouX > 128 THEN
      YouX = 128
      XScroll = 0
   END IF
   IF YouX < 1 THEN
      YouX = 1
      XScroll = 0
   END IF
   IF YouY > 128 THEN
      YouY = 128
      YScroll = 0
   END IF
   IF YouY < 1 THEN
      YouY = 1
      YScroll = 0
   END IF
   IF EntMap(YouX, YouY) = 1 OR EntMap(YouX, YouY) = 3 THEN
      Blocker = 0
   ELSEIF Defaultile(EnvMap(YouX, YouY)) > 1 OR EntMap(YouX, YouY) = 2 OR EntMap(YouX, YouY) = 4 THEN
      Blocker = 1
   END IF
   IF EntMap(YouX, YouY) > 4 THEN
      OPEN "MAPFILES\" + ThisMap$ + ".SCR" FOR INPUT AS #1
         RunScript ObjectName$(EntMap(YouX, YouY))
      CLOSE #1
   END IF
   IF YouX = BossX AND YouY = BossY THEN
      LetsGetReadyToRumble 1
      EntMap(YouX, YouY) = 0
      BossX = 0: BossY = 0
   END IF
   IF Blocker = 1 THEN
      YouX = OldX
      YouY = OldY
      XScroll = 0: YScroll = 0
   END IF
   SELECT CASE ExitScript
      CASE 1
         LoadMap 0
         DQBgetPal ThePalette
      CASE 2
         LoadSavedGame 1
         LoadMap 0
   END SELECT
   ScreenX = YouX - 10: ScreenY = YouY - 6
END SUB

FUNCTION Menu (MenuX, MenuY, MenuMax, MenuDefault, SpecialCode)
   WHILE DQBkey(KEYESC): WEND
   MaxLen = 1
   Selection = MenuDefault
   CurScreen = 1
   MoveScreen = 1
   SELECT CASE SpecialCode
      CASE 0
         FOR x = 1 TO MenuMax
            IF LEN(MenuArray$(x)) > MaxLen THEN MaxLen = LEN(MenuArray$(x))
         NEXT x
      CASE 1
         MaxLen = 16
   END SELECT
   Selected = 0
   IF Selection = -1 THEN Selected = -1
   IF MenuMax > 15 THEN
      ScreenMax = 15
   ELSE
      ScreenMax = MenuMax
   END IF
   DO
      IF MoveScreen THEN
         DQBbox 0, MenuX * 8 - 1, MenuY * 8 - 1, (MenuX + MaxLen) * 8, (MenuY + ScreenMax) * 8, 90
         DQBbox 0, MenuX * 8 - 2, MenuY * 8 - 2, (MenuX + MaxLen) * 8 + 1, (MenuY + ScreenMax) * 8 + 1, 95
         DQBboxf 0, MenuX * 8, MenuY * 8, (MenuX + MaxLen) * 8 - 1, (MenuY + ScreenMax) * 8 - 1, 88
         MoveScreen = 0
      END IF
      IF MenuMax > 15 THEN
         DQBbox 0, (MenuX + MaxLen) * 8 + 3, MenuY * 8 - 1, (MenuX + MaxLen) * 8 + 15, MenuY * 8 + MenuMax + 1, 95
         DQBboxf 0, (MenuX + MaxLen) * 8 + 4, MenuY * 8, (MenuX + MaxLen) * 8 + 14, MenuY * 8 + MenuMax, 88
         DQBbox 0, (MenuX + MaxLen) * 8 + 4, MenuY * 8 + Selection - 1, (MenuX + MaxLen) * 8 + 14, MenuY * 8 + Selection, 90
      END IF
      FOR y = 1 TO ScreenMax
         SELECT CASE SpecialCode
            CASE 0
               tempstr$ = MenuArray$(y + CurScreen - 1)
            CASE 1
               tempstr$ = Items(Invent(y + CurScreen - 1)).ItemName
         END SELECT
         IF (y + CurScreen - 1) = Selection THEN
            DQBprint 0, tempstr$, MenuX * 8 + 1, (y + MenuY - 1) * 8 + 1, 90
            DQBprint 0, tempstr$, MenuX * 8, (y + MenuY - 1) * 8, 95
         ELSE
            DQBprint 0, tempstr$, MenuX * 8 + 1, (y + MenuY - 1) * 8 + 1, 0
            DQBprint 0, tempstr$, MenuX * 8, (y + MenuY - 1) * 8, 92
         END IF
      NEXT y
      Timer1! = TIMER
      WHILE (DQBkey(KEYUP) OR DQBkey(KEYDOWN)) AND (TIMER - Timer1! < .2): WEND
      GotKeyPressed = 0
      IF Selected = -1 THEN GotKeyPressed = 1
      WHILE GotKeyPressed = 0
         IF DQBkey(KEYUP) THEN
            GotKeyPressed = 1
            Selection = Selection - 1
            IF Selection < 1 THEN
               MoveScreen = 1
               CurScreen = MenuMax - ScreenMax + 1
               Selection = MenuMax
            ELSEIF Selection < CurScreen THEN
               MoveScreen = 1
               CurScreen = CurScreen - 1
            END IF
         END IF
         IF DQBkey(KEYDOWN) THEN
            GotKeyPressed = 1
            Selection = Selection + 1
            IF Selection > MenuMax THEN
               MoveScreen = 1
               CurScreen = 1
               Selection = 1
            ELSEIF Selection > CurScreen + 14 THEN
               MoveScreen = 1
               CurScreen = CurScreen + 1
            END IF
         END IF
         IF DQBkey(KEYENTER) OR DQBkey(KEYSPACE) THEN
            GotKeyPressed = 1
            Selected = Selection
         END IF
         IF DQBkey(KEYESC) THEN
            GotKeyPressed = 1
            Selected = -1
         END IF
      WEND
   LOOP UNTIL Selected
   WHILE DQBkey(KEYESC) OR DQBkey(KEYENTER) OR DQBkey(KEYSPACE): WEND
   Menu = Selected
END FUNCTION

SUB MoveYou
   IF DQBkey(KEYLEFT) AND DQBkey(KEYRIGHT) = 0 AND DQBkey(KEYUP) = 0 AND DQBkey(KEYDOWN) = 0 THEN
      MoveDir = 4
      YouX = YouX - 1
      XScroll = -1
   END IF
   IF DQBkey(KEYRIGHT) AND DQBkey(KEYDOWN) = 0 AND DQBkey(KEYLEFT) = 0 AND DQBkey(KEYUP) = 0 THEN
      MoveDir = 6
      YouX = YouX + 1
      XScroll = 1
   END IF
   IF DQBkey(KEYUP) AND DQBkey(KEYDOWN) = 0 AND DQBkey(KEYLEFT) = 0 AND DQBkey(KEYRIGHT) = 0 THEN
      MoveDir = 8
      YouY = YouY - 1
      YScroll = -1
   END IF
   IF DQBkey(KEYDOWN) AND DQBkey(KEYUP) = 0 AND DQBkey(KEYRIGHT) = 0 AND DQBkey(KEYLEFT) = 0 THEN
      MoveDir = 2
      YouY = YouY + 1
      YScroll = 1
   END IF
END SUB

SUB RunScript (ScriptEntry$)
   DIM StoreStuff(1 TO 20) AS INTEGER
   ScriptOn = 0
   EndScripting = 0
   TextPos = 8
   DO
      LINE INPUT #1, CurLine$
      IF EOF(1) THEN EndScripting = 1
      SELECT CASE ScriptOn
         CASE 1
            SELECT CASE CurLine$
               CASE "IFINN"
                  IF InnFlag = 0 THEN ScriptOn = 10
               CASE "IFFLAG"
                  INPUT #1, TempInt
                  IF LocalFlag(TempInt) = 0 THEN ScriptOn = 10
               CASE "IFBOX"
                  INPUT #1, TempInt
                  IF GotBox(TempInt) = 0 THEN ScriptOn = 10
               CASE "IFNOTBOX"
                  INPUT #1, TempInt
                  IF GotBox(TempInt) = 1 THEN ScriptOn = 10
               CASE "IFITEM"
                  INPUT #1, TempInt
                  ScriptOn = 10
                  FOR g = 1 TO 100
                     IF Invent(g) = TempInt THEN ScriptOn = 0
                  NEXT g
               CASE "EXITTO"
                  LINE INPUT #1, ThisMap$
                  LINE INPUT #1, EntryPoint$
                  Blocker = 1
                  ExitScript = 1
                  EndScripting = 1
               CASE "FACE"
                  LINE INPUT #1, tempstr$
                  LoadPic "BIGPIC\" + tempstr$, PutArray()
                  DQBbox 1, 0, 81, 53, 134, 95
                  DQBbox 1, 1, 82, 52, 133, 90
                  DQBboxf 1, 2, 83, 51, 132, 0
                  DQBput 1, 2, 83, VARSEG(PutArray(0)), VARPTR(PutArray(0))
                  DQBcopyLayer 1, 0
               CASE "TEXT"
                  DQBbox 1, 0, 0, 319, 79, 95
                  DQBbox 1, 1, 1, 318, 78, 90
                  DQBboxf 1, 2, 2, 317, 77, 88
                  DQBcopyLayer 1, 0
                  ScriptOn = 2
               CASE "CUTTEXT"
                  ScriptOn = 2
               CASE "SLOWTYPE"
                  StopMIDI
                  DQBbox 0, 0, 0, 319, 199, 95
                  DQBbox 0, 1, 1, 318, 198, 90
                  DQBboxf 0, 2, 2, 317, 197, 88
                  TextPos = 8
                  TextPosY = 8
                  ScriptOn = 3
               CASE "STORE"
                  StoreItems = 0
                  ScriptOn = 4
               CASE "CUTSCENEBG"
                  LINE INPUT #1, tempstr$
                  nothing = DQBloadImage(1, 0, 0, "BIGPIC\" + tempstr$, ThePalette, 320, 200)
                  DQBcopyLayer 1, 0
               CASE "CUTMAP"
                  INPUT #1, SpriteX
                  INPUT #1, SpriteY
                  DQBclearLayer 1
                  FOR firsty = SpriteY - 1 TO SpriteY + 13
                     FOR firstx = SpriteX - 1 TO SpriteX + 20
                        x = firstx: y = firsty
                        xx = TileCoord(EnvMap(x, y), 1)
                        yy = TileCoord(EnvMap(x, y), 2)
                        DQBxPut 2, xx, yy, xx + 15, yy + 15, 1, (firstx - SpriteX) * 16, (firsty - SpriteY) * 16
                     NEXT firstx
                  NEXT firsty
                  DQBcopyLayer 1, 0
               CASE "PUTSPRITE"
                  INPUT #1, SpriteX
                  INPUT #1, SpriteY
                  LINE INPUT #1, tempstr$
                  CALL LoadPic(tempstr$, PutArray())
                  DQBput 0, SpriteX, SpriteY, VARSEG(PutArray(0)), VARPTR(PutArray(0))
                  DQBput 1, SpriteX, SpriteY, VARSEG(PutArray(0)), VARPTR(PutArray(0))
               CASE "DELAY"
                  DelayNow 1.5
               CASE "VARDELAY"
                  INPUT #1, DelayTime!
                  DelayNow DelayTime!
               CASE "PLAYMIDI"
                  LINE INPUT #1, MusFile$
                  StopMIDI
                  LoadMIDI "MUSIC\" + MusFile$, VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
                  PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
               CASE "TAKEITEM"
                  INPUT #1, TempInt
                  FOR g = 1 TO 100
                     IF Invent(g) = TempInt THEN
                        Invent(g) = 0
                        EXIT FOR
                     END IF
                  NEXT g
               CASE "SETFLAG"
                  INPUT #1, TempInt
                  LocalFlag(TempInt) = 1
               CASE "INN"
                  PopText 0, "Gold:" + STR$(Gold), 8, 83, 94, 1
                  InnFlag = 0
                  INPUT #1, TempInt
                  MenuArray$(1) = "Yes"
                  MenuArray$(2) = "No"
                  UseInn = Menu(1, 12, 2, 1, 0)
                  IF TempInt = 1 THEN
                     IF UseInn <> 1 OR Gold < 1 THEN TempInt = 0
                     UseInn = 1
                  END IF
                  IF UseInn = 1 AND Gold >= TempInt THEN
                    
                     StopMIDI
                     LoadMIDI "MUSIC\GOODNITE.MID", VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
                     PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
                    
                     Gold = Gold - TempInt
                     DQBclearLayer 0
                     FOR g = 1 TO 4
                        Stats(g).Hits = Stats(g).MaxHits
                        Stats(g).Magic = Stats(g).MaxMagic
                     NEXT g
                     MenuArray$(1) = "Good night!"
                     InnFlag = Menu(10, 10, 1, 1, 0)
                     InnFlag = 1
                    
                     StopMIDI
                     LoadMIDI "MUSIC\" + MusFile$, VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
                     PlayMIDI VARSEG(MidiArray%(0)), VARPTR(MidiArray%(0))
                 
                  END IF
               CASE "KILLBOX"
                  INPUT #1, TempInt
                  GotBox(TempInt) = 1
               CASE "TEXTPOPUP"
                  LINE INPUT #1, tempstr$
                  INPUT #1, TempInt
                  PopText 0, tempstr$, 40, 50, 94, TempInt
               CASE "BLOCK"
                  Blocker = 1
               CASE "REMOVECYBER"
                  CyberPoints = 0
               CASE "CLS"
                  DQBclearLayer 1
                  DQBcopyLayer 1, 0
               CASE "LOADGAME"
                  Blocker = 1
                  ExitScript = 2
                  EndScripting = 1
               CASE "FADEOUT"
                  DQBfadeTo 0, 0, 0
               CASE "BATTLEDRAW"
                  BattleDraw 0
               CASE "PHYSICALSINGLE"
                  LINE INPUT #1, DamagePic$
                  INPUT #1, AttackPower!
                  IF BodyCount < 4 THEN
                     DO
                        Member = INT(RND * 4) + 1
                     LOOP UNTIL Stats(Member).Hits > 0
                     Damage! = EnemyStr * ((RND * AttackPower!) + (RND * AttackPower!))
                     Damage! = Damage! * ((100 - Items(Stats(Member).Armor).ItemPower) / 100)
                     LoadPic "SPRITE\HITS\" + DamagePic$, PutArray()
                     DQBput 0, 190 + Member * 15, Member * 32 + 18, VARSEG(PutArray(0)), VARPTR(PutArray(0))
                     PopText 0, STR$(INT(Damage!)), 230 + Member * 15, Member * 32 + 40, 167, 0
                     HealDude Member, 0 - INT(Damage!)
                  END IF
               CASE "MAGICMULTI"
                  LINE INPUT #1, DamagePic$
                  INPUT #1, AttackPower!
                  IF BodyCount < 4 THEN
                     FOR Member = 1 TO 4
                        Damage! = EnemyIntel * ((RND * AttackPower!) + (RND * AttackPower!))
                        Damage! = Damage! * ((Stats(Member).Wisdom) / 100)
                        Damage! = Damage! / (5 - BodyCount)
                        LoadPic "SPRITE\HITS\" + DamagePic$, PutArray()
                        DQBput 0, 190 + Member * 15, Member * 32 + 18, VARSEG(PutArray(0)), VARPTR(PutArray(0))
                        PopText 0, STR$(INT(Damage!)), 230 + Member * 15, Member * 32 + 40, 167, 0
                        HealDude Member, 0 - INT(Damage!)
                     NEXT Member
                  END IF
               CASE "WINNINGS"
                  INPUT #1, GetExp
                  INPUT #1, GetGold
                  DQBclearLayer 0
                  IF NumEnemies = 0 THEN NumEnemies = 1
                  GetExp = GetExp * NumEnemies
                  GetGold = GetGold * NumEnemies
                  PopText 0, "You have won the battle!", 5, 105, 92, 0
                  PopText 0, "Gold won:" + STR$(GetGold), 5, 114, 92, 0
                  PopText 0, "Experience won:" + STR$(GetExp), 5, 123, 92, 0
                  GetCyber = InNet * (RND * 6)
                  IF GetCyber <= NumEnemies AND InNet THEN
                     PopText 0, "GOT A CYBER POINT!", 5, 132, 92, 0
                     CyberPoints = CyberPoints + 1
                  END IF
                  FOR Member = 1 TO 4
                     tempstr$ = Stats(Member).Charname + STR$(Stats(Member).Experience) + "/" + LTRIM$(STR$(LevUp(Stats(Member).Level)))
                     PopText 0, tempstr$, 5, Member * 10, 92, 0
                  NEXT Member
                  PopText 0, "Gold:" + STR$(Gold), 5, 50, 92, 0
                  EnterOrSpace
                  DQBclearLayer 0
                  FOR Member = 1 TO 4
                     IF Stats(Member).Hits > 0 THEN Stats(Member).Experience = Stats(Member).Experience + GetExp
                     tempstr$ = Stats(Member).Charname + STR$(Stats(Member).Experience) + "/" + LTRIM$(STR$(LevUp(Stats(Member).Level)))
                     PopText 0, tempstr$, 5, Member * 10, 92, 0
                     IF Stats(Member).Experience >= LevUp(Stats(Member).Level) THEN
                        Stats(Member).Experience = Stats(Member).Experience - LevUp(Stats(Member).Level)
                        Stats(Member).Level = Stats(Member).Level + 1
                        Stats(Member).MaxHits = Stats(Member).MaxHits * 1.2 + 1
                        Stats(Member).MaxMagic = Stats(Member).MaxMagic * 1.2
                        Stats(Member).Strength = Stats(Member).Strength * 1.05 + 1
                        Stats(Member).Agility = Stats(Member).Agility * 1.05 + 1
                        Stats(Member).Wisdom = Stats(Member).Wisdom * 1.05 + 1
                        PopText 0, RTRIM$(Stats(Member).Charname) + " is now at level" + STR$(Stats(Member).Level) + "!", 5, Member * 10, 92, 1
                     END IF
                  NEXT Member
                  Gold = Gold + GetGold
                  PopText 0, "Gold:" + STR$(Gold), 5, 50, 92, 0
                  EnterOrSpace
               CASE "-----", "ENDIF"
                  EndScripting = 1
            END SELECT
         CASE 2
            SELECT CASE CurLine$
               CASE "-"
                  TextPos = 8
                  EnterOrSpace
                  DQBcopyLayer 1, 0
               CASE "END"
                  ScriptOn = 1
               CASE ELSE
                  DQBprint 0, CurLine$, 8, TextPos, 0
                  DQBprint 0, CurLine$, 7, TextPos - 1, 95
                  TextPos = TextPos + 10
            END SELECT
         CASE 3
            SELECT CASE CurLine$
               CASE "END"
                  ScriptOn = 1
               CASE ELSE
                  TypeSound = 0
                  FOR textline = 1 TO LEN(CurLine$)
                     SELECT CASE MID$(CurLine$, textline, 1)
                        CASE ""
                           TypeSound = 200
                        CASE ""
                           Timer1! = TIMER
                           WHILE TIMER - Timer1! < .5: WEND
                        CASE ELSE
                           DQBprint 0, MID$(CurLine$, textline, 1), TextPos, TextPosY, 0
                           DQBprint 0, MID$(CurLine$, textline, 1), TextPos - 1, TextPosY - 1, 95
                           SOUND 500 - (RND * TypeSound) - 200, .1 * (1 + (TypeSound \ 25))
                           Timer1! = TIMER
                           WHILE TIMER - Timer1! < .05: WEND
                           TextPos = TextPos + 8
                     END SELECT
                  NEXT textline
                  TextPosY = TextPosY + 10
                  TextPos = 8
            END SELECT
         CASE 4
            IF CurLine$ = "END" THEN
               PopText 0, "Gold:" + STR$(Gold), 40, 23, 94, 1
               GetItem = Menu(5, 5, StoreItems, 1, 0)
               IF GetItem > 0 THEN
                  IF Gold >= Items(StoreStuff(GetItem)).ItemPrice THEN
                     Gold = Gold - Items(StoreStuff(GetItem)).ItemPrice
                     FOR g = 1 TO 100
                        IF Invent(g) = 0 THEN
                           Invent(g) = StoreStuff(GetItem)
                           EXIT FOR
                        END IF
                     NEXT g
                  END IF
               END IF
               ScriptOn = 1
            ELSE
               StoreItems = StoreItems + 1
               StoreItem = VAL(CurLine$)
               StoreStuff(StoreItems) = StoreItem
               MenuArray$(StoreItems) = Items(StoreItem).ItemName + STR$(Items(StoreItem).ItemPrice)
            END IF
         CASE 10
            IF CurLine$ = "ENDIF" THEN ScriptOn = 1
         CASE ELSE
            IF CurLine$ = ScriptEntry$ OR CurLine$ = "DEFAULT" THEN ScriptOn = 1
      END SELECT
   LOOP UNTIL EndScripting
END SUB

FUNCTION SelectAlly
   Selection = 0
   DO
      Selection = Selection + 1
   LOOP UNTIL Stats(Selection).Hits > 0
   Selected = 0
   DO
      DQBcopyLayer 1, 0
      Timer1! = TIMER
      DQBbox 0, 190 + Selection * 15, Selection * 32 + 17, 220 + Selection * 15, Selection * 32 + 58, 94
      WHILE (DQBkey(KEYUP) OR DQBkey(KEYDOWN)) AND (TIMER - Timer1! < .2): WEND
      GotKeyPressed = 0
      IF Selected = -1 THEN GotKeyPressed = 1
      WHILE GotKeyPressed = 0
         IF DQBkey(KEYUP) THEN
            GotKeyPressed = 1
            DO
               Selection = Selection - 1
               IF Selection < 1 THEN Selection = 4
            LOOP UNTIL Stats(Selection).Hits > 0
         END IF
         IF DQBkey(KEYDOWN) THEN
            GotKeyPressed = 1
            DO
               Selection = Selection + 1
               IF Selection > 4 THEN Selection = 1
            LOOP UNTIL Stats(Selection).Hits > 0
         END IF
         IF DQBkey(KEYENTER) OR DQBkey(KEYSPACE) THEN
            GotKeyPressed = 1
            Selected = Selection
         END IF
         IF DQBkey(KEYESC) THEN
            GotKeyPressed = 1
            Selected = -1
         END IF
      WEND
   LOOP UNTIL Selected
   WHILE DQBkey(KEYESC) OR DQBkey(KEYENTER) OR DQBkey(KEYSPACE): WEND
   SelectAlly = Selected
END FUNCTION

FUNCTION SelectEnemy
   Selection = 0
   DO
      Selection = Selection + 1
   LOOP UNTIL EnemyHP(Selection) > 0
   Selected = 0
   DO
      DQBcopyLayer 1, 0
      Timer1! = TIMER
      DQBbox 0, EnemyCoord(Selection, 1), EnemyCoord(Selection, 2), EnemyCoord(Selection, 1) + 50, EnemyCoord(Selection, 2) + 50, 94
      WHILE (DQBkey(KEYUP) OR DQBkey(KEYDOWN) OR DQBkey(KEYLEFT) OR DQBkey(KEYRIGHT)) AND (TIMER - Timer1! < .2)
      WEND
      GotKeyPressed = 0
      IF Selected = -1 THEN GotKeyPressed = 1
      WHILE GotKeyPressed = 0
         IF DQBkey(KEYUP) OR DQBkey(KEYLEFT) THEN
            GotKeyPressed = 1
            DO
               Selection = Selection - 1
               IF Selection < 1 THEN Selection = NumEnemies
            LOOP UNTIL EnemyHP(Selection) > 0
         END IF
         IF DQBkey(KEYDOWN) OR DQBkey(KEYRIGHT) THEN
            GotKeyPressed = 1
            DO
               Selection = Selection + 1
               IF Selection > NumEnemies THEN Selection = 1
            LOOP UNTIL EnemyHP(Selection) > 0
         END IF
         IF DQBkey(KEYENTER) OR DQBkey(KEYSPACE) THEN
            GotKeyPressed = 1
            Selected = Selection
         END IF
         IF DQBkey(KEYESC) THEN
            GotKeyPressed = 1
            Selected = -1
         END IF
      WEND
   LOOP UNTIL Selected
   WHILE DQBkey(KEYESC) OR DQBkey(KEYENTER) OR DQBkey(KEYSPACE): WEND
   SelectEnemy = Selected
END FUNCTION

SUB UseThemSpells (InBattle, SpellCode, SubMenu, Boss)
   Stu = SpellCode + 17
   SELECT CASE (Items(Stu).ItemType \ 100)
      CASE 1
         IF InBattle THEN
            IF Boss THEN
               UseOnWho = 1
            ELSE
               UseOnWho = SelectAlly
            END IF
         ELSE
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname + "HP:" + LTRIM$(STR$(Stats(g).Hits)) + "/" + LTRIM$(STR$(Stats(g).MaxHits))
            NEXT g
            PopText 0, "Use on who?", 10, 10, 92, 1
            UseOnWho = Menu(2, 10, 4, 1, 0)
         END IF
         IF UseOnWho <> -1 THEN
            HealedYou = Stats(SubMenu).Wisdom * Items(Stu).ItemPower
            Stats(SubMenu).Magic = Stats(SubMenu).Magic - Items(Stu).ItemPower
            IF InBattle THEN
               MenuArray$(1) = ".AWD"
               BattleDraw SubMenu
            END IF
            HealDude UseOnWho, HealedYou
            IF InBattle THEN
               PopText 0, STR$(HealedYou), 230 + UseOnWho * 15, UseOnWho * 32 + 40, 23, 0
               DelayNow 1.5
            ELSE
               FOR g = 1 TO 4
                  MenuArray$(g) = Stats(g).Charname + "HP:" + LTRIM$(STR$(Stats(g).Hits)) + "/" + LTRIM$(STR$(Stats(g).MaxHits))
               NEXT g
               g = Menu(2, 10, 4, -1, 0)
               MenuArray$(1) = "Healed " + RTRIM$(Stats(UseOnWho).Charname) + STR$(HealedYou) + " HP"
               UseOnWho = Menu(2, 2, 1, 1, 0)
            END IF
            MenuArray$(1) = "D"
         END IF
      CASE 2
         IF InBattle THEN
            UseOnWho = SelectEnemy
            IF UseOnWho > -1 THEN
               Stats(SubMenu).Magic = Stats(SubMenu).Magic - Items(Stu).ItemPower
               MenuArray$(1) = ".AWD"
               BattleDraw SubMenu
               Damage! = Stats(SubMenu).Wisdom * Items(Stu).ItemPower
               Damage! = Damage! * ((100 - EnemyMDef) / 100)
               PopText 0, STR$(INT(Damage!)), EnemyCoord(UseOnWho, 1), EnemyCoord(UseOnWho, 2) + 40, 167, 0
               DelayNow 1.5
               DamageEnemyDude UseOnWho, INT(Damage!)
               BattleDraw 0
               MenuArray$(1) = "D"
            END IF
         ELSE
            MenuArray$(1) = "Cannot use outside of battle!"
            UseOnWho = Menu(2, 2, 1, 1, 0)
         END IF
      CASE 3
         IF InBattle THEN
            AreUSure = 1
         ELSE
            FOR g = 1 TO 4
               MenuArray$(g) = Stats(g).Charname + "HP:" + LTRIM$(STR$(Stats(g).Hits)) + "/" + LTRIM$(STR$(Stats(g).MaxHits))
            NEXT g
            UseOnWho = Menu(2, 10, 4, -1, 0)
            MenuArray$(1) = "Are you sure?"
            AreUSure = Menu(2, 2, 1, 1, 0)
         END IF
         IF AreUSure = 1 THEN
            Stats(SubMenu).Magic = Stats(SubMenu).Magic - Items(Stu).ItemPower
            IF InBattle THEN
               MenuArray$(1) = ".AWD"
               BattleDraw SubMenu
            END IF
            HealedYou = (Stats(SubMenu).Wisdom * Items(Stu).ItemPower) / (4 - BodyCount)
            FOR g = 1 TO 4
               IF Stats(g).Hits > 0 OR InBattle = 0 THEN HealDude g, HealedYou
            NEXT g
            IF InBattle THEN
               FOR UseOnWho = 1 TO 4
                  IF Stats(UseOnWho).Hits > 0 OR InBattle = 0 THEN PopText 0, STR$(HealedYou), 230 + UseOnWho * 15, UseOnWho * 32 + 40, 23, 0
               NEXT UseOnWho
               DelayNow 1.5
            ELSE
               FOR g = 1 TO 4
                  MenuArray$(g) = Stats(g).Charname + "HP:" + LTRIM$(STR$(Stats(g).Hits)) + "/" + LTRIM$(STR$(Stats(g).MaxHits))
               NEXT g
               UseOnWho = Menu(2, 10, 4, -1, 0)
               MenuArray$(1) = "Everyone healed" + STR$(HealedYou) + " HP"
               UseOnWho = Menu(2, 2, 1, 1, 0)
            END IF
            MenuArray$(1) = "D"
         END IF
      CASE 4
         IF InBattle THEN
            Stats(SubMenu).Magic = Stats(SubMenu).Magic - Items(Stu).ItemPower
            MenuArray$(1) = ".AWD"
            BattleDraw SubMenu
            Damage! = Stats(SubMenu).Wisdom * Items(Stu).ItemPower
            Damage! = Damage! * ((100 - EnemyMDef) / 100)
            Damage! = Damage! / (NumEnemies + Boss - EBodyCount)
            FOR UseOnWho = 1 TO NumEnemies + Boss
               IF EnemyHP(UseOnWho) > 0 THEN
                  PopText 0, STR$(INT(Damage!)), EnemyCoord(UseOnWho, 1), EnemyCoord(UseOnWho, 2) + 40, 167, 0
                  DamageEnemyDude UseOnWho, INT(Damage!)
                  MenuArray$(1) = "D"
               END IF
            NEXT UseOnWho
            DelayNow 1.5
            BattleDraw 0
         ELSE
            MenuArray$(1) = "Cannot use outside of battle!"
            UseOnWho = Menu(2, 2, 1, 1, 0)
         END IF
   END SELECT
END SUB

