DECLARE SUB Pause (tdelay#)

CONST FALSE = 0
CONST TRUE = NOT FALSE

TYPE FLIheaderType
	Size AS LONG
	ID AS INTEGER
	Frames AS INTEGER
	Xres AS INTEGER
	Yres AS INTEGER
	ColorBits AS INTEGER
	Flags AS INTEGER
	Speed AS INTEGER
	Reserved AS STRING * 110
END TYPE

TYPE FLIframeChunkType
	Size AS LONG
	ID AS INTEGER
	Chunks AS INTEGER
	Reserved AS STRING * 8
END TYPE

TYPE FLIdataChunkType
	Size AS LONG
	ID AS INTEGER
END TYPE


DECLARE SUB FLIplay (FileName$, ErrCode%)


'--- Input File Name ---
	PRINT "Enter FLI or FLC File Name with extension (Enter=Quit):"
	INPUT "> ", FileName$

	IF LTRIM$(RTRIM$(FileName$)) = "" THEN END
	IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".FLI"

'--- Setup Screen ---
	SCREEN 13

'--- Simple File Exist Checking ---
	FileNum% = FREEFILE
	OPEN FileName$ FOR INPUT AS FileNum%
	CLOSE FileNum%

'--- Play Animation Flic ---
	CALL FLIplay(FileName$, ErrCode%)

	IF ErrCode% > 0 THEN
		LOCATE 3, 1
		PRINT "Error Occured! : ErrCode ="; ErrCode%
	END IF


SUB FLIplay (FileName$, ErrCode%)

DIM Header AS FLIheaderType
DIM FrameChunk AS FLIframeChunkType
DIM DataChunk AS FLIdataChunkType
DIM Byte AS STRING * 1

ErrCode% = 0

FileNum% = FREEFILE
OPEN FileName$ FOR BINARY AS FileNum%
	GET #FileNum%, , Header

	IF Header.ID <> &HAF11 AND Header.ID <> &HAF12 THEN
		ErrCode% = 1
		CLOSE FileNum%
		EXIT SUB
	END IF
	IF Header.Xres <> 320 OR Header.Yres <> 200 THEN
		ErrCode% = 2
		LOCATE 21, 1: PRINT "Xres:"; Header.Xres;
		LOCATE 22, 1: PRINT "Yres:"; Header.Yres;
		LOCATE 23, 1: PRINT "ColorBits:"; Header.ColorBits;
		LOCATE 1, 1
		CLOSE FileNum%
		EXIT SUB
	END IF


	DEF SEG = &HA000
	FOR Frame% = 1 TO Header.Frames

	       
		
	  
		FramePos& = LOC(FileNum%)
		GET #FileNum%, , FrameChunk

		IF FrameChunk.ID = &HF1FA THEN
		  
			FOR Chunk% = 1 TO FrameChunk.Chunks
				
				DataPos& = LOC(FileNum%)
				GET #FileNum%, , DataChunk

				SELECT CASE DataChunk.ID
				 CASE 4, 11
				  
					Index% = 0
					GET #FileNum%, , PacketNum%
					FOR A% = 1 TO PacketNum%
						GET #FileNum%, , Byte: SkipByte% = ASC(Byte)
						GET #FileNum%, , Byte: ChangeByte% = ASC(Byte)
						Index% = Index% + SkipByte%
						IF ChangeByte% = 0 THEN ChangeByte% = 256
						FOR B% = 1 TO ChangeByte%
							GET #FileNum%, , Byte: RedByte% = ASC(Byte)
							GET #FileNum%, , Byte: GreenByte% = ASC(Byte)
							GET #FileNum%, , Byte: BlueByte% = ASC(Byte)
							IF DataChunk.ID = 4 THEN
							       
								OUT &H3C8, Index%
								OUT &H3C9, RedByte% \ 4
								OUT &H3C9, GreenByte% \ 4
								OUT &H3C9, BlueByte% \ 4
							ELSE
							       
								OUT &H3C8, Index%
								OUT &H3C9, RedByte%
								OUT &H3C9, GreenByte%
								OUT &H3C9, BlueByte%
							END IF
							Index% = Index% + 1
						NEXT B%
					NEXT A%
				
				 CASE 12

					GET #FileNum%, , StartLine%
					GET #FileNum%, , Byte: NumLines% = ASC(Byte)
					LinePos& = StartLine% * 320&
					GET #FileNum%, , Byte: StartByte% = ASC(Byte)
					FOR Y% = 1 TO NumLines%
						GET #FileNum%, , Byte: PacketByte% = ASC(Byte)
						X% = StartByte%
						FOR A% = 1 TO PacketByte%
							GET #FileNum%, , Byte: SkipByte% = ASC(Byte)
							GET #FileNum%, , Byte: SizeByte% = ASC(Byte)
							X% = X% + SkipByte%
							IF SizeByte% > 127 THEN
								SizeByte% = -(SizeByte% OR &HFF00)
								GET #FileNum%, , Byte: PixelByte% = ASC(Byte)
								FOR B% = 1 TO SizeByte%
								      POKE LinePos& + X%, PixelByte%
								      X% = X% + 1
								NEXT B%
							ELSE
								FOR B% = 1 TO SizeByte%
									GET #FileNum%, , Byte: PixelByte% = ASC(Byte)
									POKE LinePos& + X%, PixelByte%
									X% = X% + 1
								NEXT B%
							END IF
						NEXT A%
						LinePos& = LinePos& + 320
					NEXT Y%
					GET #FileNum%, , Byte
				
				 CASE 7

					LinePos& = 0
					GET #FileNum%, , NumLines%
					FOR Y% = 1 TO NumLines%
					       
						DO
							GET #FileNum%, , Word%
							WordType% = (Word% AND &HC000)
							SELECT CASE WordType%
								CASE 0: PacketCount% = Word%
								CASE &H8000: LastPixel% = (Word% AND &HFF)
								CASE &HC000: LinePos& = LinePos& + (Word% * -320&)
							END SELECT
						LOOP UNTIL WordType% = 0
						X% = 0
						FOR A% = 1 TO PacketCount%
							GET #FileNum%, , Byte: SkipByte% = ASC(Byte)
							GET #FileNum%, , Byte: SizeByte% = ASC(Byte)
							X% = X% + SkipByte%
							IF SizeByte% > 127 THEN
								SizeByte% = -(SizeByte% OR &HFF00)
								GET #FileNum%, , Byte: PixelByte1% = ASC(Byte)
								GET #FileNum%, , Byte: PixelByte2% = ASC(Byte)
								FOR B% = 1 TO SizeByte%
									POKE LinePos& + X%, PixelByte1%
									POKE LinePos& + X% + 1, PixelByte2%
									X% = X% + 2
								NEXT B%
							ELSE
								FOR B% = 1 TO SizeByte%
								       
									GET #FileNum%, , Byte: PixelByte1% = ASC(Byte)
									GET #FileNum%, , Byte: PixelByte2% = ASC(Byte)
									POKE LinePos& + X%, PixelByte1%
									POKE LinePos& + X% + 1, PixelByte2%
									X% = X% + 2
								NEXT B%
							END IF
						NEXT A%
						LinePos& = LinePos& + 320
					NEXT Y%
				
				 CASE 13
					CLS
				
				 CASE 15
				  
					LinePos& = 0
					FOR Y% = 1 TO 200
						GET #FileNum%, , Byte
						X% = 0
						DO
							GET #FileNum%, , Byte: SizeByte% = ASC(Byte)
							IF SizeByte% > 127 THEN
								SizeByte% = -(SizeByte% OR &HFF00)
								FOR B% = 1 TO SizeByte%
									GET #FileNum%, , Byte: PixelByte% = ASC(Byte)
									POKE LinePos& + X%, PixelByte%
									X% = X% + 1
								NEXT B%
						       
							ELSE
								GET #FileNum%, , Byte: PixelByte% = ASC(Byte)
								FOR B% = 1 TO SizeByte%
									POKE LinePos& + X%, PixelByte%
									X% = X% + 1
								NEXT B%
							END IF
						LOOP UNTIL X% >= 320
						LinePos& = LinePos& + 320
					NEXT Y%
					GET #FileNum%, , Byte

				 CASE 16

					FOR P& = 0 TO 64000
						GET #FileNum%, , Byte: PixelByte% = ASC(Byte)
						POKE P&, PixelByte%
					NEXT P&
				
				 CASE ELSE

					SEEK FileNum%, DataPos& + DataChunk.Size + 1

				END SELECT
		  
			NEXT Chunk%


		END IF
	  
		SEEK FileNum%, FramePos& + FrameChunk.Size + 1
	  
		Pause Header.Speed * 1 / 70


	NEXT Frame%
	DEF SEG

CLOSE FileNum%

LOCATE 1, 35:

END SUB

DEFINT A-Z
SUB Pause (tdelay#)
'----------------------------------------------------------------------------
time1# = TIMER
DO
LOOP WHILE (TIMER - time1# < tdelay#) OR (time1# > TIMER)
END SUB

