    '                    CVTEAMON
    '
    '      Convert Sequential Eamon Files to Random
    '
    '                 for the IBM-PC
    '
    '                 by John Nelson
    '
    DECLARE SUB textio (I$, DF$, ESC, BK)
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    CLS
    LOCATE 6, 1
    LINE INPUT "Insert Diskette with sequential files and enter PATH:", PATH.S$
    CLS
    LOCATE 6, 1
    LINE INPUT "Insert Eamon Adventure and enter PATH:", PATH.R$
    OPEN PATH.S$ + "DESC.R0" FOR INPUT AS #1
    INPUT #1, N.ROOM
    INPUT #1, N.ART
    INPUT #1, N.EFF
    INPUT #1, N.MON
    CLOSE 1
    ND = 0
    WHILE ND <> 6 AND ND <> 10
    CLS
    LOCATE 6, 1
    LINE INPUT "Number of directions (6/10):", ND$
    ND = VAL(ND$)
    WEND
    MAX.RM = 100
    MAX.ART = 100
    MAX.EFF = 100
    RM.LEN = 64
    RMN.LEN = 64
    MON.LEN = 128
    ART.LEN = 128
    DESC.LEN = 256
    MON.FLDS = 12
    ART.FLDS = 8
    RM.FLDS = 0
    MN.LEN = 20
    AN.LEN = 20
    GOSUB DISPLAY.CONTROL
    GOSUB EDIT.CONTROL
    GOSUB SET.CONTROLS
    LOCATE 8, 1
    PRINT "Check Max. Artifact Name length? (Y/N) ";
    YN$ = ""
    WHILE UCASE$(YN$) <> "Y" AND UCASE$(YN$) <> "N"
      YN$ = INKEY$
    WEND
    CHK.AN.LEN$ = UCASE$(YN$)
    IF CHK.AN.LEN$ = "Y" THEN GOSUB CHK.AN.LEN
    LOCATE 10, 1
    PRINT "Check Max. Monster Name length? (Y/N) ";
    YN$ = ""
    WHILE UCASE$(YN$) <> "Y" AND UCASE$(YN$) <> "N"
      YN$ = INKEY$
    WEND
    CHK.MN.LEN$ = UCASE$(YN$)
    IF CHK.MN.LEN$ = "Y" THEN GOSUB CHK.MN.LEN
    OPEN PATH.R$ + "DESC.R0" FOR OUTPUT AS #1
    WRITE #1, N.ROOM
    WRITE #1, N.ART
    WRITE #1, N.EFF
    WRITE #1, N.MON
    WRITE #1, ND
    WRITE #1, MAX.RM
    WRITE #1, MAX.ART
    WRITE #1, MAX.EFF
    WRITE #1, RM.LEN
    WRITE #1, RMN.LEN
    WRITE #1, MON.LEN
    WRITE #1, ART.LEN
    WRITE #1, DESC.LEN
    WRITE #1, MON.FLDS
    WRITE #1, ART.FLDS
    WRITE #1, RM.FLDS
    WRITE #1, MN.LEN
    WRITE #1, AN.LEN
    CLOSE
    CLS
    LOCATE 6, 1
    PRINT "Does ROOMS file have a separator record between each rooms"
    PRINT "directions? If so, enter 'Y' else enter 'N' ";
    YN$ = ""
    WHILE UCASE$(YN$) <> "Y" AND UCASE$(YN$) <> "N"
      YN$ = INKEY$
    WEND
    RM.ID$ = UCASE$(YN$)
    CLS
    LOCATE 6, 1
    PRINT "Edit Descriptions (y/n):"
    YN$ = ""
    WHILE UCASE$(YN$) <> "Y" AND UCASE$(YN$) <> "N"
      YN$ = INKEY$
    WEND
    EDIT.MODE$ = UCASE$(YN$)
    CLS
    CVT.ROOM$ = ""
    WHILE CVT.ROOM$ <> "Y" AND CVT.ROOM$ <> "N"
      LOCATE 6, 1
      INPUT "Convert Rooms (Y/N):", CVT.ROOM$
      CVT.ROOM$ = UCASE$(CVT.ROOM$)
    WEND
    CVT.RMN$ = ""
    WHILE CVT.RMN$ <> "Y" AND CVT.RMN$ <> "N"
      LOCATE 8, 1
      INPUT "Convert Room Names :", CVT.RMN$
      CVT.RMN$ = UCASE$(CVT.RMN$)
    WEND
    CVT.ART$ = ""
    WHILE CVT.ART$ <> "Y" AND CVT.ART$ <> "N"
      LOCATE 10, 1
      INPUT "Convert Artifacts  :", CVT.ART$
      CVT.ART$ = UCASE$(CVT.ART$)
    WEND
    CVT.MON$ = ""
    WHILE CVT.MON$ <> "Y" AND CVT.MON$ <> "N"
      LOCATE 12, 1
      INPUT "Convert Monsters   :", CVT.MON$
      CVT.MON$ = UCASE$(CVT.MON$)
    WEND
    CVT.DESC$ = ""
    WHILE CVT.DESC$ <> "Y" AND CVT.DESC$ <> "N"
      LOCATE 14, 1
      INPUT "Convert Descript.  :", CVT.DESC$
      CVT.DESC$ = UCASE$(CVT.DESC$)
    WEND
    CLS
    GOSUB CONVERT.ART
    GOSUB CONVERT.MON
    GOSUB CONVERT.ROOMS
    GOSUB CONVERT.RMNAMES
    GOSUB CONVERT.DESC
    GOTO END.JOB
CONVERT.ART:
    IF CVT.ART$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Artifacts ..."
    LOCATE 4, 10
    PRINT "Artifact"
    OPEN PATH.S$ + "ARTIF.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "ARTIF.TXT", ART.LEN
    DIM ART$(ART.FLDS), AD%(ART.FLDS)
    FIELD #2, AN.LEN AS ARTNAM$
    FOR D = 1 TO ART.FLDS
    FIELD #2, AN.LEN AS X$, (D - 1) * 2 AS X$, 2 AS ART$(D)
    NEXT
    FOR R = 1 TO N.ART
    LOCATE 4, 20
    PRINT USING "###"; R
    LOCATE 4, 25
    PRINT LCASE$(AN$) + SPACE$(20)
    INPUT #1, AN$
    FOR M = 1 TO ART.FLDS
    INPUT #1, AD%(M)
    NEXT
    LSET ARTNAM$ = LCASE$(AN$)
    FOR M = 1 TO ART.FLDS
    LSET ART$(M) = MKI$(AD%(M))
    NEXT
    PUT #2, R
    NEXT
    LOCATE 4, 25
    PRINT "Completed                     "
    CLOSE
    RETURN
CONVERT.MON:
    IF CVT.MON$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Monsters ...                 "
    LOCATE 6, 10
    PRINT "Monster"
    OPEN PATH.S$ + "MONST.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "MONST.TXT", MON.LEN
    DIM MON$(MON.FLDS), MD%(MON.FLDS)
    FIELD #2, MN.LEN AS MONNAM$
    FOR D = 1 TO MON.FLDS
    FIELD #2, MN.LEN AS X$, (D - 1) * 2 AS X$, 2 AS MON$(D)
    NEXT
    FOR R = 1 TO N.MON
        LOCATE 6, 20
        PRINT USING "###"; R
        INPUT #1, MN$
        LOCATE 6, 25
        PRINT UCASE$(LEFT$(MN$, 1)) + LCASE$(MID$(MN$, 2)) + SPACE$(20)
        FOR M = 1 TO MON.FLDS
          INPUT #1, MD%(M)
        NEXT
        LSET MONNAM$ = UCASE$(LEFT$(MN$, 1)) + LCASE$(MID$(MN$, 2))
      FOR M = 1 TO MON.FLDS
        LSET MON$(M) = MKI$(MD%(M))
      NEXT
      PUT #2, R
    NEXT
    CLOSE
    RETURN
CONVERT.RMNAMES:
    IF CVT.RMN$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Room Names ...       "
    LOCATE 8, 10
    PRINT "Room Name"
    OPEN PATH.S$ + "RMNAMES.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "RMNAMES.TXT", RMN.LEN
    FIELD #2, RMN.LEN AS RMNM$
    FOR R = 1 TO N.ROOM
    LOCATE 8, 20
    PRINT USING "###"; R
    INPUT #1, RM$
    LOCATE 8, 25
    PRINT LCASE$(RM$) + SPACE$(55 - LEN(RM$))
    LSET RMNM$ = LCASE$(RM$)
    PUT #2, R
    NEXT
    LOCATE 8, 25
    PRINT "Complete               "
    CLOSE
    RETURN
CONVERT.ROOMS:
    IF CVT.ROOM$ = "N" THEN RETURN
    LOCATE 1, 1
    PRINT "Converting Rooms ...               "
    LOCATE 10, 10
    PRINT "Room "
    OPEN PATH.S$ + "ROOMS.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "ROOMS.TXT", RM.LEN
    DIM RD$(ND + RM.FLDS), RD%(ND + RM.FLDS)
    FOR D = 1 TO ND + RM.FLDS
    FIELD #2, (D - 1) * 2 AS X$, 2 AS RD$(D)
    NEXT
    FOR R = 1 TO N.ROOM
    LOCATE 10, 20
    PRINT USING "###"; R
    IF RM.ID$ = "Y" THEN
        INPUT #1, R.ID$
        LOCATE 10, 25
        PRINT R.ID$
        IF VAL(R.ID$) > 0 THEN PRINT "Error --- Room id is numeric MAY BE MIS-ALIGNED": CLOSE : END
    END IF
    FOR D = 1 TO ND + RM.FLDS
    INPUT #1, RD%(D)
    NEXT
    FOR D = 1 TO ND + RM.FLDS
    RSET RD$(D) = MKI$(RD%(D))
    NEXT
    PUT #2, R
    NEXT
    CLOSE
    LOCATE 10, 25
    PRINT "Complete                        "
    RETURN
CONVERT.DESC:
    IF CVT.DESC$ = "N" THEN RETURN
    OPEN PATH.S$ + "DESC.SEQ" FOR INPUT AS #1
    OPEN "R", #2, PATH.R$ + "DESC.TXT", DESC.LEN
    FIELD #2, DESC.LEN - 1 AS DESC$
' -------------------------------------------------------------------
'                    Convert Room Descriptions
' -------------------------------------------------------------------
    LOCATE 1, 1
    PRINT "Converting Descriptions ... "
    LOCATE 12, 10
    PRINT "Description"
    FOR R = 1 TO N.ROOM
    LOCATE 12, 20
    PRINT USING "###"; R
    INPUT #1, DE$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DESC$ = DE$
    PUT #2, R
    NEXT
' -------------------------------------------------------------------
'                    Convert Artifact Descriptions
' -------------------------------------------------------------------
    FOR R = 1 TO N.ART
    LOCATE 13, 20
    PRINT USING "###"; R
    INPUT #1, DE$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DESC$ = DE$
    PUT #2, R + MAX.RM
    NEXT
' -------------------------------------------------------------------
'                       Convert Effects
' -------------------------------------------------------------------
    FOR R = 1 TO N.EFF
    LOCATE 14, 20
    PRINT USING "###"; R
    INPUT #1, DE$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DESC$ = DE$
    PUT #2, R + MAX.RM + MAX.ART
    NEXT
' -------------------------------------------------------------------
'                    Convert Monster Descriptions
' -------------------------------------------------------------------
    FOR R = 1 TO N.MON
    LOCATE 15, 20
    PRINT USING "###"; R
    INPUT #1, DE$
    IF LEFT$(EDIT.MODE$, 1) = "Y" THEN GOSUB CONVERT.LC
    LSET DESC$ = DE$
    PUT #2, R + MAX.RM + MAX.ART + MAX.EFF
    NEXT
    CLOSE
    RETURN
CONVERT.LC:
    DF$ = DE$
    GOSUB EDIT.IT
    DE$ = I$
    RETURN
EDIT.IT:
    LOCATE 18, 1
    PRINT SPACE$(255)
    LOCATE 18, 1
    ESC = 0
    BK = 0
    textio I$, DF$, ESC, BK
    RETURN
DISPLAY.CONTROL:
      CLS
      LOCATE 4, 10: PRINT "Number of Rooms      ... "; : PRINT USING "###"; NR
      LOCATE 5, 10: PRINT "Number of Artifacts  ... "; : PRINT USING "###"; NA
      LOCATE 6, 10: PRINT "Number of Effects   .... "; : PRINT USING "###"; NE
      LOCATE 7, 10: PRINT "Number of Monsters  .... "; : PRINT USING "###"; NM
      LOCATE 9, 10: PRINT "Number of Directions ... "; : PRINT USING " ##"; ND
      LOCATE 10, 10: PRINT "Maximum Nbr Rooms    ... "; : PRINT USING "###"; MAX.RM
      LOCATE 11, 10: PRINT "Maximum Nbr Artifacts .. "; : PRINT USING "###"; MAX.ART
      LOCATE 12, 10: PRINT "Maximum Nbr Effects .... "; : PRINT USING "###"; MAX.EFF
      LOCATE 14, 10: PRINT "Rooms File Length  ..... "; : PRINT USING " ##"; RM.LEN
      LOCATE 15, 10: PRINT "Room Names Length  ..... "; : PRINT USING " ##"; RMN.LEN
      LOCATE 16, 10: PRINT "Monster File Length  ... "; : PRINT USING "###"; MON.LEN
      LOCATE 17, 10: PRINT "Artifact File Length ... "; : PRINT USING "###"; ART.LEN
      LOCATE 18, 10: PRINT "Description Length ..... "; : PRINT USING "###"; DESC.LEN
      LOCATE 19, 10: PRINT "Number of Mon Fields ... "; : PRINT USING "###"; MON.FLDS
      LOCATE 20, 10: PRINT "Number of Art Fields ... "; : PRINT USING "###"; ART.FLDS
      LOCATE 21, 10: PRINT "Number of Room Fields .. "; : PRINT USING "###"; ART.FLDS
      LOCATE 22, 10: PRINT "Monster Name Length .... "; : PRINT USING "###"; MN.LEN
      LOCATE 23, 10: PRINT "Artifact Name Length ... "; : PRINT USING "###"; AN.LEN
      RETURN
EDIT.CONTROL:
      LOCATE 1, 1
EDIT.NR:
      ESC = 0
      LOCATE 4, 35
      FMT$ = "I3"
      DF = NR
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NR = I.NUM
EDIT.NA:
      LOCATE 5, 35
      FMT$ = "I3"
      DF = NA
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NA = I.NUM
EDIT.NE:
      LOCATE 6, 35
      FMT$ = "I3"
      DF = NE
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NE = I.NUM
EDIT.NM:
      LOCATE 7, 35
      FMT$ = "I3"
      DF = NM
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NM = I.NUM
EDIT.ND:
      LOCATE 9, 35
      FMT$ = "I3"
      DF = ND
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM <> 6 AND I.NUM <> 10 THEN GOTO EDIT.ND
      NEW.ND = I.NUM
EDIT.MAX.RM:
      LOCATE 10, 35
      FMT$ = "I3"
      DF = MAX.RM
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 50 OR I.NUM > 400 THEN BEEP: GOTO EDIT.MAX.RM
      NEW.MAX.RM = I.NUM
EDIT.MAX.ART:
      LOCATE 11, 35
      FMT$ = "I3"
      DF = MAX.ART
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 50 OR I.NUM > 400 THEN BEEP: GOTO EDIT.MAX.ART
      NEW.MAX.ART = I.NUM
EDIT.MAX.EFF:
      LOCATE 12, 35
      FMT$ = "I3"
      DF = MAX.EFF
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 50 OR I.NUM > 400 THEN BEEP: GOTO EDIT.MAX.EFF
      NEW.MAX.EFF = I.NUM
EDIT.RM.LEN:
      LOCATE 14, 35
      FMT$ = "I3"
      DF = RM.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 12 OR I.NUM > 128 THEN BEEP: GOTO EDIT.RM.LEN
      NEW.RM.LEN = I.NUM
EDIT.RMN.LEN:
      LOCATE 15, 35
      FMT$ = "I3"
      DF = RMN.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 36 OR I.NUM > 256 THEN BEEP: GOTO EDIT.RMN.LEN
      NEW.RMN.LEN = I.NUM
EDIT.MON.LEN:
      LOCATE 16, 35
      FMT$ = "I3"
      DF = MON.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 32 OR I.NUM > 256 THEN BEEP: GOTO EDIT.ART.LEN
      NEW.MON.LEN = I.NUM
EDIT.ART.LEN:
      LOCATE 17, 35
      FMT$ = "I3"
      DF = ART.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 36 OR I.NUM > 256 THEN BEEP: GOTO EDIT.ART.LEN
      NEW.ART.LEN = I.NUM
EDIT.DESC.LEN:
      LOCATE 18, 35
      FMT$ = "I3"
      DF = DESC.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 160 OR I.NUM > 1024 THEN PRINT CHR$(7): GOTO EDIT.DESC.LEN
      NEW.DESC.LEN = I.NUM
EDIT.MON.FLDS:
      LOCATE 19, 35
      FMT$ = "I3"
      DF = MON.FLDS
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 12 OR I.NUM > 36 THEN PRINT CHR$(7): GOTO EDIT.MON.FLDS
      NEW.MON.FLDS = I.NUM
EDIT.ART.FLDS:
      LOCATE 20, 35
      FMT$ = "I3"
      DF = ART.FLDS
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 8 OR I.NUM > 12 THEN PRINT CHR$(7): GOTO EDIT.ART.FLDS
      NEW.ART.FLDS = I.NUM
EDIT.RM.FLDS:
      LOCATE 21, 35
      FMT$ = "I3"
      DF = RM.FLDS
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 0 OR I.NUM > 4 THEN PRINT CHR$(7): GOTO EDIT.RM.FLDS
      NEW.RM.FLDS = I.NUM
EDIT.MN.LEN:
      LOCATE 22, 35
      FMT$ = "I3"
      DF = MN.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 20 OR I.NUM > 64 THEN PRINT CHR$(7): GOTO EDIT.MN.LEN
      NEW.MN.LEN = I.NUM
EDIT.AN.LEN:
      LOCATE 23, 35
      FMT$ = "I3"
      DF = AN.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 20 OR I.NUM > 64 THEN PRINT CHR$(7): GOTO EDIT.AN.LEN
      NEW.AN.LEN = I.NUM
      RETURN
FORGET.IT:
      CLOSE
      END
SET.CONTROLS:
      NR = NEW.NR
      NA = NEW.NA
      NE = NEW.NE
      NM = NEW.NM
      ND = NEW.ND
      MAX.RM = NEW.MAX.RM
      MAX.ART = NEW.MAX.ART
      MAX.EFF = NEW.MAX.EFF
      RM.LEN = NEW.RM.LEN
      RMN.LEN = NEW.RMN.LEN
      MON.LEN = NEW.MON.LEN
      ART.LEN = NEW.ART.LEN
      DESC.LEN = NEW.DESC.LEN
      MON.FLDS = NEW.MON.FLDS
      ART.FLDS = NEW.ART.FLDS
      RM.FLDS = NEW.RM.FLDS
      MN.LEN = NEW.MN.LEN
      AN.LEN = NEW.AN.LEN
      GOTO DISPLAY.CONTROL
CHK.MN.LEN:
     OPEN PATH.S$ + "MONST.SEQ" FOR INPUT AS #1
     FOR M = 1 TO N.MON
     INPUT #1, MN$
     IF LEN(MN$) > MAX.MN.LEN THEN MAX.MN.LEN = LEN(MN$)
     FOR D = 1 TO MON.FLDS
     INPUT X$
     NEXT
     NEXT
     CLS
     PRINT "Maximum Monster Name length is "; MAX.MN.LEN; " bytes."
     RETURN
CHK.AN.LEN:
     OPEN PATH.S$ + "ARTIF.SEQ" FOR INPUT AS #1
     FOR A = 1 TO N.ART
     INPUT #1, AN$
     IF LEN(AN$) > MAX.AN.LEN THEN MAX.AN.LEN = LEN(AN$)
     FOR D = 1 TO ART.FLDS
     INPUT X$
     NEXT
     NEXT
     CLS
     PRINT "Maximum Artifact Name length is "; MAX.AN.LEN; " bytes."
     RETURN
END.JOB:
    CLOSE
    LOCATE 20, 10
    PRINT "Conversion Complete"
    END
' =====================================================================
'
'                  SUBROUTINES - NUMERIC I/O ROUTINE
'
' =====================================================================
GET.NUMBER:
      I.L% = VAL(MID$(FMT$, 2))
      I.U$ = RIGHT$("###,###,###,###", I.L% + INT((I.L% - 1) / 3))
      I$ = ""
      V% = CSRLIN
      H% = POS(1)
      INS.KEY$ = CHR$(0)
      EMB.KEY$ = CHR$(0)
      HID.KEY$ = CHR$(0)
      CAR.KEY$ = CHR$(0)
      BURY.KEY$ = CHR$(0)
      IF PFPMT > 0 THEN INS.KEY$ = CHR$(0) + CHR$(59)
      IF PFPMT > 1 THEN EMB.KEY$ = CHR$(0) + CHR$(60)
      IF PFPMT > 2 THEN HID.KEY$ = CHR$(0) + CHR$(61)
      IF PFPMT > 3 THEN CAR.KEY$ = CHR$(0) + CHR$(62)
      IF PFPMT > 4 THEN BURY.KEY$ = CHR$(0) + CHR$(63)
      RES.KEY$ = CHR$(0) + CHR$(68)
NIO.1:
      LOCATE V%, H%
      IF I$ <> "" THEN
          PRINT USING I.U$; VAL(I$);
      ELSE
          PRINT USING I.U$; DF;
      END IF
NIO.2:
      LOCATE V%, H% + LEN(I.U$) - 1
      GOSUB GET.BYTE
      IF A$ = INS.KEY$ AND RAEM = 1 THEN
          PF = 1
          LOCATE V%, 18
          PRINT "Blocks Way";
          GOTO NIO.2
      END IF
      IF A$ = EMB.KEY$ AND RAEM = 1 THEN
          PF = 2
          LOCATE V%, 18
          PRINT "(Secret Pass.)";
          GOTO NIO.2
      END IF
      IF A$ = INS.KEY$ THEN
          PF = 1
          LOCATE V%, 1
          PRINT "Inside Art.#   ";
          GOTO NIO.2
      END IF
      IF A$ = EMB.KEY$ THEN
          PF = 2
          LOCATE V%, 1
          PRINT "Embed. Room#   ";
          GOTO NIO.2
      END IF
      IF A$ = HID.KEY$ THEN
          PF = 3
          LOCATE V%, 1
          PRINT "Hidden Room#   ";
          GOTO NIO.2
      END IF
      IF A$ = CAR.KEY$ THEN
          PF = 4
          LOCATE V%, 1
          PRINT "Carried by Mon#";
          GOTO NIO.2
      END IF
      IF A$ = BURY.KEY$ THEN
          PF = 5
          LOCATE V%, 1
          PRINT "Buried in Room#";
          GOTO NIO.2
      END IF
      IF A$ = RES.KEY$ THEN
          PF = 0
          LOCATE V%, 1
          PRINT "Room           ";
          GOTO NIO.2
      END IF
      IF A$ = CHR$(13) THEN GOTO NIO.RETURN
      IF A$ = CHR$(27) THEN ESC = -1: GOTO NIO.RETURN2
      IF A$ = CHR$(8) AND LEN(I$) > 0 THEN I$ = LEFT$(I$, LEN(I$) - 1): GOTO NIO.1
      IF A$ = CHR$(8) AND I$ = "" THEN BK = -1: GOTO NIO.RETURN2
      IF A$ = "-" AND LEFT$(I$, 1) <> "-" THEN I$ = "-" + I$: GOTO NIO.1
      IF A$ = "-" THEN I$ = MID$(I$, 2): GOTO NIO.1
      IF A$ >= "0" AND A$ <= "9" AND LEN(I$) < I.L% THEN I$ = I$ + A$: GOTO NIO.1
      PRINT CHR$(7);
      GOTO NIO.2
NIO.RETURN:
      IF I$ = "" THEN I$ = STR$(DF):
      I.NUM = VAL(I$)
      BK = 0
NIO.RETURN2:
      LOCATE , , 0
      RETURN
GET.BYTE:  ' get a keystroke & convert to std 1 byte code
      LOCATE , , 1
      A$ = ""
      WHILE A$ = ""
        A$ = INKEY$
      WEND
      IF A$ = CHR$(127) THEN A$ = CHR$(8)
      IF A$ = CHR$(0) + CHR$(75) THEN A$ = CHR$(8)
      IF A$ = CHR$(0) + CHR$(77) THEN A$ = CHR$(21)
      IF CAPS THEN LOCATE , , 0: RETURN
      IF A$ >= "a" THEN A$ = CHR$(ASC(A$) - 32)
      LOCATE , , 0
      RETURN

    SUB textio (I$, DF$, ESC, BK) STATIC
'                This is a generic text build I/O routine
'
'
'
'
' -------------------------------------------------------------------
'                   TEXTIO Routine
' -------------------------------------------------------------------
TEXTIO.RTN:
     V% = CSRLIN: H% = POS(1)
     TRUE = -1
     BK = 0
     INS.CHR$ = CHR$(0) + CHR$(82)
     DEL.CHR$ = CHR$(0) + CHR$(83)
     UP.CHR$ = CHR$(0) + CHR$(72)
     DN.CHR$ = CHR$(0) + CHR$(80)
     END.CHR$ = CHR$(0) + CHR$(79)
     HOME.CHR$ = CHR$(0) + CHR$(71)
     LEFT.CHR$ = CHR$(0) + CHR$(75)
     RIGHT.CHR$ = CHR$(0) + CHR$(77)
     CTL.END$ = CHR$(0) + CHR$(117)
     UPPER.CASE$ = CHR$(21)
     LOWER.CASE$ = CHR$(12)
     SHIFT$ = CHR$(19)
     FIND.CHR$ = CHR$(6)
     ESC.CHR$ = CHR$(27)
BUILD.TEXT:
     LOCATE V%, H%
     PRINT DF$;
     LOCATE V%, H%
     I$ = ""
BLD.TEXT:
     GOSUB TIO.GET.BYTE
     IF A$ = FIND.CHR$ THEN
         STP = 2
         GOSUB FIND.A.CHAR
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(13) THEN
         LOCATE , , 0
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ AND LEN(I$) = 0 THEN
         ESC = TRUE
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ THEN EXIT SUB
     IF A$ >= CHR$(32) THEN
         I$ = I$ + A$
         DF$ = MID$(DF$, 2)
         PRINT A$;
         GOTO BLD.TEXT
     END IF
     IF A$ = END.CHR$ THEN
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CTL.END$ THEN
         S.V = CSRLIN
         S.H = POS(1)
         LOCATE , , 0
         SP = LEN(DF$)
         IF SP > 0 THEN PRINT SPC(SP);
         DF$ = ""
         LOCATE S.V, S.H
         GOTO BLD.TEXT
     END IF
     IF A$ = HOME.CHR$ THEN
         DF$ = I$ + DF$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) > 1 THEN
         DF$ = RIGHT$(I$, 1) + DF$
         I$ = LEFT$(I$, LEN(I$) - 1)
         PRINT CHR$(29);
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) = 1 THEN
         DF$ = I$ + DF$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = LEFT.CHR$ AND LEN(I$) < 1 THEN
         BK = -1
         I$ = I$ + DF$
         EXIT SUB
     END IF
     IF A$ = RIGHT.CHR$ AND LEN(DF$) > 0 THEN
         I$ = I$ + LEFT$(DF$, 1)
         DF$ = MID$(DF$, 2)
         PRINT RIGHT$(I$, 1);
         GOTO BLD.TEXT
     END IF
     IF A$ = DN.CHR$ THEN
         I$ = I$ + LEFT$(DF$ + SPACE$(80), 80)
         DF$ = RTRIM$(MID$(DF$ + SPACE$(80), 81))
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = UP.CHR$ AND LEN(I$) >= 80 THEN
         DF$ = RIGHT$(I$, 80) + DF$
         I$ = LEFT$(I$, LEN(I$) - 80)
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = INS.CHR$ AND LEN(I$) > 0 THEN
         DF$ = " " + DF$
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = INS.CHR$ AND LEN(I$) = 0 THEN
         LOCATE V%, H%
         PRINT " " + DF$;
         DF$ = " " + DF$
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = DEL.CHR$ AND LEN(I$) = 0 THEN
         DF$ = MID$(DF$, 2)
         LOCATE V%, H%
         PRINT DF$ + " " + STRING$(LEN(DF$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = DEL.CHR$ THEN
         DF$ = MID$(DF$, 2)
         LOCATE V%, H%
         PRINT I$ + DF$ + " " + STRING$(LEN(DF$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = UPPER.CASE$ THEN
         I$ = UCASE$(I$)
         DF$ = UCASE$(DF$)
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = LOWER.CASE$ THEN
         I$ = LCASE$(I$)
         DF$ = LCASE$(DF$)
         LOCATE V%, H%
         PRINT I$ + DF$ + STRING$(LEN(DF$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = SHIFT$ THEN
         IF LEFT$(DF$, 1) >= "A" THEN
             DF$ = CHR$(ASC(LEFT$(DF$, 1)) - 32) + MID$(DF$, 2)
             PRINT LEFT$(DF$, 1) + CHR$(29);
             GOTO BLD.TEXT
        ELSE
             IF LEFT$(DF$, 1) >= "A" AND LEFT$(DF$, 1) <= "Z" THEN
                 DF$ = CHR$(ASC(LEFT$(DF$, 1)) + 32) + DF$
                 PRINT LEFT$(DF$, 1) + CHR$(29);
                 GOTO BLD.TEXT
             END IF
        END IF
     END IF
     BEEP
     GOTO BLD.TEXT
FIND.A.CHAR:
     GOSUB TIO.GET.BYTE
     SAVE.FIND$ = A$
LOOK.AGAIN:
     A = INSTR(STP, DF$, SAVE.FIND$)
     IF A = 0 THEN
         I$ = I$ + DF$
         DF$ = ""
         LOCATE V%, H%
         PRINT I$;
         RETURN
     END IF
     I$ = I$ + LEFT$(DF$, A - 1)
     DF$ = MID$(DF$, A)
     LOCATE V%, H%
     PRINT I$;
     GOSUB TIO.GET.BYTE
     IF A$ <> SAVE.FIND$ THEN RETURN
     GOTO LOOK.AGAIN
TIO.GET.BYTE:
     LOCATE , , 1, 4, 7
     A$ = ""
     WHILE A$ = ""
         A$ = INKEY$
     WEND
     RETURN
END SUB

