        '
        '
        '               Convert Applesoft Program to QuickBASIC
        '
        '
        '                        Version 1.00
        '
        '                       by John Nelson
        '
        '
        '              Written from scratch 12-14-91
        '
        DEFINT A-Z
        DECLARE FUNCTION GetCmd$ (Lin$, P)
        DECLARE SUB PrtCenter (Lit$)
        DECLARE SUB Output.Command (Lbl$, ASCmd$, Margin)
        DIM SHARED ViewSw
        DIM SHARED LowerSw
        DIM SHARED P
        DIM Vrb$(25), VT%(25)           ' Variables on input/print stmts
        fgc% = 7
        bgc% = 1
        hfg% = 0
        hbg% = 7
        COLOR fgc%, bgc%
        DISKVAR$ = "DK$"
        CLS
        PrtCenter "Convert Applesoft"
        GOSUB Explain.Page
        CLS
        PrtCenter "Convert Applesoft"
        LOCATE 3, 10
        INPUT "Applesoft  File:", ASFilnam$
        LOCATE 4, 10
        Margin = 6
        INPUT "QuickBasic File:", QBFilnam$
        LOCATE 3, 45
        PRINT "View each line (Y/N):";
        DO
            A$ = INPUT$(1)
            A$ = UCASE$(A$)
        LOOP UNTIL A$ = "Y" OR A$ = "N"
        PRINT A$
        ViewSw = (A$ = "Y")
        LOCATE 4, 45
        PRINT "Lower case Quoted Strings? (Y/N):";
        DO
            A$ = INPUT$(1)
            A$ = UCASE$(A$)
        LOOP UNTIL A$ = "Y" OR A$ = "N"
        PRINT A$
        LowerSw = (A$ = "Y")
        OPEN ASFilnam$ FOR INPUT AS #1
        OPEN QBFilnam$ FOR OUTPUT AS #2
        VIEW PRINT 6 TO 24
Read.ASFil:
        IF EOF(1) THEN GOTO EndofConversion
        LINE INPUT #1, ASLin$
        CLS
        IF ViewSw THEN
            LOCATE 6, 1
            PRINT ASLin$
            PRINT STRING$(80, 196);
            LOCATE 11, 1
        END IF
        IF ASLin$ = "" THEN GOTO Read.ASFil
        IF LEFT$(ASLin$, 1) <> " " THEN
            Lbl$ = LEFT$(ASLin$, INSTR(ASLin$, " ") - 1)
            ASLin$ = MID$(ASLin$, INSTR(ASLin$, " "))
            ASLin$ = LTRIM$(RTRIM$(ASLin$))
        ELSE
            Lbl$ = ""
            ASLin$ = LTRIM$(RTRIM$(ASLin$))
        END IF
        P = 1
        DO
            ASCmd$ = GetCmd$(ASLin$, P)
            GOSUB CONVERT.CMD
            Output.Command Lbl$, ASCmd$, Margin
            Lbl$ = ""
        LOOP UNTIL P < 0
        DO WHILE IfCount > 0
            ASCmd$ = "END IF"
            Margin = Margin - 4
            Output.Command Lbl$, ASCmd$, Margin
            Lbl$ = ""
            IfCount = IfCount - 1
        LOOP
        Margin = 6
        IF ViewSw THEN
            LOCATE 24, 1
            PRINT STRING$(24, 176); " Press Any Key to Continue "; STRING$(24, 176);
            A$ = INPUT$(1)
            IF UCASE$(A$) = "G" THEN ViewSw = 0
        END IF
        GOTO Read.ASFil
CONVERT.CMD:
        IF ASCmd$ = "HOME" THEN ASCmd$ = "CLS": RETURN
        IF LEFT$(ASCmd$, 3) = "IF " THEN GOTO CONVERT.IF
        IF LEFT$(ASCmd$, 4) = "VTAB" THEN ASCmd$ = "LOCATE" + MID$(ASCmd$, 5): RETURN
        IF LEFT$(ASCmd$, 4) = "HTAB" THEN ASCmd$ = "LOCATE ," + MID$(ASCmd$, 5): RETURN
        IF ASCmd$ = "INVERSE" THEN ASCmd$ = "COLOR 0,7": RETURN
        IF ASCmd$ = "NORMAL" THEN ASCmd$ = "COLOR 7,0": RETURN
        IF ASCmd$ = "FLASH" THEN ASCmd$ = "COLOR 23,0": RETURN
        IF LEFT$(ASCmd$, 4) = "GET " THEN ASCmd$ = MID$(ASCmd$, 5) + " = INPUT$(1)": RETURN
        IF LEFT$(ASCmd$, 5) = "PRINT" THEN GOTO CONVERT.PRINT
        IF LEFT$(ASCmd$, 4) = "POKE" THEN GOTO CONVERT.POKE
        IF LEFT$(ASCmd$, 4) = "PEEK" THEN GOTO CONVERT.PEEK
        IF LEFT$(ASCmd$, 4) = "CALL" THEN GOTO CONVERT.CALL
        IF LEFT$(ASCmd$, 5) = "INPUT" THEN GOTO CONVERT.INPUT
        IF ASCmd$ = "TEXT" THEN ASCmd$ = "": RETURN
        IF LEFT$(ASCmd$, 5) = "ONERR" THEN ASCmd$ = "ON ERROR " + MID$(ASCmd$, 7): RETURN
        IF VAL(ASCmd$) > 0 THEN ASCmd$ = "GOTO " + ASCmd$
        RETURN
CONVERT.INPUT:
        IF DISKIO THEN GOTO CONVERT.DISKINPUT
        IF LowerSw THEN Q1 = 7: GOSUB CONVERT.LOWER
        RETURN
CONVERT.DISKINPUT:
        Vrbl$ = MID$(ASCmd$, 7)
        IF RIGHT$(Vrbl$, 1) = "$" THEN VT%(1) = 1 ELSE VT%(1) = 2
        X = 0
        DO WHILE INSTR(Vrbl$, ",") > 0
                X = X + 1
                Vrb$(X) = LEFT$(Vrbl$, INSTR(Vrbl$, ",") - 1)
                Vrbl$ = MID$(Vrbl$, INSTR(Vrbl$, ",") + 1)
                IF RIGHT$(Vrb$(X), 1) = "$" THEN VT%(X) = 1 ELSE VT%(X) = 2
        LOOP
        IF RANDOMSW = 0 THEN
            IF X > 0 THEN
                FOR C = 1 TO X
                    ASCmd$ = "INPUT #n, " + Vrb$(C)
                    Output.Command Lbl$, ASCmd$, Margin
                NEXT
            ELSE
                ASCmd$ = "INPUT #n, " + Vrbl$
            END IF
            RETURN
        END IF
        IF X > 0 THEN
            FOR C = 1 TO X
                IF VT%(C) = 1 THEN CVTyp$ = "" ELSE CVTyp$ = "CVI"
                ASCmd$ = Vrb$(C) + " = " + CVTyp$ + "(" + FPrfix$ + "." + Vrb$(C) + "$" + ")"
            NEXT
        ELSE
            ASCmd$ = Vrbl$ + " = " + CVTyp$ + "(" + FPrfix$ + "." + Vrbl$ + ")"
        END IF
        RETURN
CONVERT.IF:
        IF RIGHT$(RTRIM$(ASCmd$), 4) = "THEN" THEN IfCount = IfCount + 1
        RETURN
CONVERT.PRINT:
        IF INSTR(ASCmd$, " ") > 0 THEN
            PRTSUBJ$ = LTRIM$(MID$(ASCmd$, INSTR(ASCmd$, " ")))
        ELSE
            PRTSUBJ$ = LTRIM$(RTRIM$(ASCmd$))
        END IF
        IF LEFT$(PRTSUBJ$, LEN("CHR$ (4)")) = "CHR$ (4)" THEN GOTO DOS.COMMAND
        IF LEFT$(PRTSUBJ$, LEN(DISKVAR$)) = DISKVAR$ THEN GOTO DOS.COMMAND
        IF DISKIO THEN
            IF RANDOMSW THEN ASCmd$ = "RSET XX." + MID$(ASCmd$, 7) + "$ = MKI$(" + MID$(ASCmd$, 7) + ")": RETURN
            ASCmd$ = "PRINT #, " + MID$(ASCmd$, 7)
        END IF
        IF LowerSw THEN Q1 = 7: GOSUB CONVERT.LOWER
        RETURN
CONVERT.LOWER:
        DO
        Q1 = INSTR(Q1, ASCmd$, CHR$(34))
        IF Q1 > 0 THEN
            Q2 = INSTR(Q1 + 1, ASCmd$, CHR$(34))
            IF Q2 > 0 THEN
                MID$(ASCmd$, Q1 + 1, Q2 - Q1 - 1) = LCASE$(MID$(ASCmd$, Q1 + 1, Q2 - Q1 - 1))
            END IF
            Q1 = Q2 + 1
        END IF
        LOOP UNTIL Q1 = 0 OR Q1 > LEN(ASCmd$)
        RETURN
DOS.COMMAND:
        Q1 = INSTR(PRTSUBJ$, CHR$(34))
        IF Q1 = 0 THEN DISKIO = 0: ASCmd$ = "": RETURN
        IF RIGHT$(PRTSUBJ$, 1) = CHR$(34) THEN PRTSUBJ$ = LEFT$(PRTSUBJ$, LEN(PRTSUBJ$) - 1)
        IF Q1 > LEN(PRTSUBJ$) THEN ASCmd$ = "": RETURN
        DOSCMD$ = MID$(PRTSUBJ$, Q1 + 1)
        Q2 = INSTR(DOSCMD$, CHR$(34))
        IF Q2 THEN
            DOSCMD$ = LEFT$(DOSCMD$, Q2 - 1) + MID$(DOSCMD$, Q2 + 1)
        END IF
        IF LEFT$(DOSCMD$, 4) = "OPEN" THEN GOTO OPEN.COMMAND
        IF LEFT$(DOSCMD$, 4) = "READ" THEN GOTO READ.COMMAND
        IF LEFT$(DOSCMD$, 5) = "WRITE" THEN GOTO WRITE.COMMAND
        IF LEFT$(DOSCMD$, 8) = "MAXFILES" THEN ASCmd$ = "": RETURN
        IF LEFT$(DOSCMD$, 6) = "DELETE" THEN GOTO DELETE.FILE.COMMAND
        IF LEFT$(DOSCMD$, 6) = "VERIFY" THEN GOTO VERIFY.FILE.COMMAND
        IF LEFT$(DOSCMD$, 5) = "BLOAD" THEN ASCmd$ = "BLOAD " + CHR$(34) + MID$(DOSCMD$, 7) + CHR$(34): RETURN
        IF DOSCMD$ = "CLOSE" THEN
            ASCmd$ = "CLOSE "
            DISKIO = 0
            RETURN
        END IF
        IF LEFT$(DOSCMD$, 5) = "CLOSE" THEN ASCmd$ = "CLOSE n": DISKIO = 0: RETURN
        IF LEFT$(DOSCMD$, 3) = "RUN" THEN ASCmd$ = "RUN " + CHR$(34) + MID$(DOSCMD$, 5) + CHR$(34): RETURN
        RETURN
OPEN.COMMAND:
        ASFNAM$ = MID$(DOSCMD$, 6)
        L = INSTR(ASFNAM$, ",L")
        IF L > 0 THEN
            GOSUB GETFILINFO
            ASCmd$ = "OPEN " + CHR$(34) + LEFT$(ASFNAM$, L - 1) + CHR$(34) + " FOR RANDOM AS #" + N$ + " LEN=" + MID$(ASFNAM$, L + 2)
            RANDOMSW = -1
            Output.Command Lbl$, ASCmd$, Margin
            Lbl$ = ""
            ASCmd$ = FldStmt$
        ELSE
            GOSUB GETSEQINFO
            ASCmd$ = "OPEN " + CHR$(34) + ASFNAM$ + CHR$(34) + " FOR " + IO$ + " AS #n"
            RANDOMSW = 0
        END IF
        RETURN
DELETE.FILE.COMMAND:
        ASFNAM$ = MID$(DOSCMD$, 6)
        ASCmd$ = "KILL " + CHR$(34) + ASFNAM$ + CHR$(34)
        RETURN
VERIFY.FILE.COMMAND:
        ASFNAM$ = LTRIM$(MID$(DOSCMD$, 7))
        ASCmd$ = "VERIFY " + CHR$(34) + ASFNAM$ + CHR$(34)
        RETURN
GETFILINFO:
        VIEW PRINT 1 TO 24
        CLS
        PrtCenter "File Information"
        LOCATE 3, 1
        PRINT ASLin$
        LOCATE 10, 1
        INPUT "File Number:", N$
        LOCATE 11, 1
        INPUT "File Prefix:", Pref$
        FldStmt$ = "FIELD #" + N$
        VIEW PRINT 12 TO 24
        Fld = 0
        DO
        CLS
        Fld = Fld + 1
        LOCATE 12, 1
        PRINT FldStmt$
        LOCATE 15, 1
        PRINT "Field "; Fld; "Name:";
        INPUT "", Fldnam$
        IF Fldnam$ = "" THEN EXIT DO
        LOCATE 24, 1
        PRINT "  I-Integer   S-Single FP   D-Double FP   L-Long Integer   $-String   ";
        LOCATE 16, 1
        INPUT "Type:", FldTyp$
        FldTyp$ = UCASE$(FldTyp$)
        LOCATE 24, 1
        PRINT SPC(79);
        IF FldTyp$ = "I" THEN Lngth = 2
        IF FldTyp$ = "S" THEN Lngth = 4
        IF FldTyp$ = "D" THEN Lngth = 8
        IF FldTyp$ = "L" THEN Lngth = 4
        IF FldTyp$ = "$" THEN LOCATE 17, 1: INPUT "Length:", Lngth
        FldStmt$ = FldStmt$ + "," + STR$(Lngth) + " AS " + Pref$ + "." + Fldnam$ + "$"
        LOOP
        VIEW PRINT 6 TO 24
        CLS
        RETURN
GETSEQINFO:
        IO$ = "INPUT"
        RETURN
READ.COMMAND:
        ASFNAM$ = MID$(DOSCMD$, 6)
        L = INSTR(ASFNAM$, ",R")
        IF L > 0 THEN
            REC$ = MID$(ASFNAM$, L + 2)
            IF LEFT$(REC$, 1) = ";" THEN REC$ = MID$(REC$, 2)
            ASCmd$ = "GET #n, " + REC$ + "      ' Read " + ASFNAM$
            RANDOMSW = -1
            DISKIO = -1
        ELSE
            DISKIO = -1
            ASCmd$ = ""
        END IF
        RETURN
WRITE.COMMAND:
        ASFNAM$ = MID$(DOSCMD$, 7)
        L = INSTR(ASFNAM$, ",R")
        IF L > 0 THEN
            ASCmd$ = "PUT #n, " + MID$(ASFNAM$, L + 2)
        ELSE
            DISKIO = -1
            ASCmd$ = ""
        END IF
        RETURN
CONVERT.POKE:
        POKEAT = VAL(MID$(ASCmd$, 5))
        SELECT CASE POKEAT
                CASE 37
                    ASCmd$ = "LOCATE " + MID$(ASCmd$, INSTR(ASCmd$, ",") + 1)
                    RETURN
                CASE 36
                    ASCmd$ = "LOCATE ," + MID$(ASCmd$, INSTR(ASCmd$, ",") + 1)
                    RETURN
                CASE 216
                    ASCmd$ = "ON ERROR GOTO 0"
                CASE ELSE
        END SELECT
        RETURN
CONVERT.PEEK:

        RETURN
CONVERT.CALL:
        CALLADDR = VAL(MID$(ASCmd$, 5))
        SELECT CASE CALLADDR
                CASE -998
                    ASCmd$ = "LOCATE CSRLIN-1"
                    RETURN
                CASE -958
                    ASCmd$ = "PARTCLS CSRLIN, POS(0), 24"
                    RETURN
                CASE -922
                    ASCmd$ = "LOCATE CSRLIN+1"
                    RETURN
                CASE -868
                    ASCmd$ = "PRINT SPACE$(80-POS(1));"
                    RETURN
                CASE -756
                    ASCmd$ = "A$ = INPUT$(1)"
                    RETURN
                CASE ELSE
            END SELECT
            RETURN
EndofConversion:
        CLOSE
        END
Explain.Page:
        PRINT "While a complete Applesoft to QuickBASIC program may be possible for the"
        PRINT "compiler wizards at Microsoft or Borland, it is beyond my capabilities or "
        PRINT "would take more time to create than I have to spare. Instead of trying to"
        PRINT "write the final perfect Applesoft Conversion program, this is merely a tool"
        PRINT "to assist with the partial conversion of a program from Applesoft to "
        PRINT "QuickBASIC."
        PRINT
        PRINT "It will convert the simple statements found in Applesoft to their equivalent"
        PRINT "statements in QuickBASIC. It even attempts to perform portions of the file "
        PRINT "I-O for you. Complete conversion is not possible unless an entire compiler"
        PRINT "were created, and even then it would not be 100% because many programs in"
        PRINT "in Applesoft use assembler sub-routines, little known peek and pokes, and"
        PRINT "some idiosyncracies of the Apple itself. "
        PRINT
        PRINT "Statements this program will not convert and will have to be done manually"
        PRINT "are probably too numerous to mention, but the more common ones you run into"
        PRINT "PEEK statements, many POKE statements, many CALL statements, and file I-O is"
        PRINT "not converted completely."
        PRINT
        PRINT "For file I-O, you will have to add all FIELD statements for random files and"
        PRINT "assign file numbers, and create the necessary interface routines."
        PRINT
        PRINT STRING$(24, 176); " Press any Key to Continue "; STRING$(24, 176)
        A$ = INPUT$(1)
        RETURN

FUNCTION GetCmd$ (Lin$, P)
        IF LEFT$(LTRIM$(MID$(Lin$, P)), 3) = "IF " THEN
            THN = INSTR(P, Lin$, " THEN ")
            IF THN = 0 THEN GetCmd$ = LTRIM$(MID$(Lin$, P)): P = -1: EXIT FUNCTION
            GetCmd$ = LTRIM$(MID$(Lin$, P, INSTR(P, Lin$, " THEN ") - P + 6))
            P = INSTR(P, Lin$, " THEN ") + 6
            ' GetCmd$ = LTRIM$(MID$(Lin$, P))
            ' P = -1
            EXIT FUNCTION
        END IF
        FOR X = P TO LEN(Lin$)
            IF MID$(Lin$, X, 1) = ":" THEN EXIT FOR
            IF MID$(Lin$, X, 1) = CHR$(34) THEN
                DO
                  X = X + 1
                LOOP UNTIL X > LEN(Lin$) OR MID$(Lin$, X, 1) = CHR$(34)
            END IF
        NEXT
        GC$ = MID$(Lin$, P, X - P + 1)
        P = X + 1
        IF P > LEN(Lin$) THEN P = -1
        IF RIGHT$(GC$, 1) = ":" THEN GC$ = LEFT$(GC$, LEN(GC$) - 1)
        GetCmd$ = RTRIM$(LTRIM$(GC$))
            
END FUNCTION

SUB Output.Command (Lbl$, ASCmd$, Margin)
        IF ASCmd$ = "" THEN
            IF Lbl$ = "" THEN
                EXIT SUB
            END IF
            ASCmd$ = "REM"
        END IF
        IF Lbl$ <> "" THEN
            OUTLIN$ = LEFT$(Lbl$ + SPACE$(Margin), Margin) + ASCmd$
        ELSE
            OUTLIN$ = SPACE$(Margin) + ASCmd$
        END IF
        IF LEFT$(ASCmd$, 3) = "IF " THEN Margin = Margin + 4
        PRINT #2, OUTLIN$
        IF ViewSw THEN PRINT OUTLIN$

END SUB

DEFSNG A-Z
SUB PrtCenter (Lit$)
        LOCATE , (80 - LEN(Lit$)) \ 2 + 1
        PRINT Lit$
END SUB

