{ I wrote this program for quick extration of an Apple Basic program stored  }
{ in an image file. This came about from when I was using the APL6502        }
{ emulator and wanted to extract some binary programs. Instead of trying to  }
{ manipulate the DSKs by saving a text version of the program within them, I }
{ created this little program to do the job. It can take in a binary image   }
{ created by a program such as DSK_OUT [you need to do an "mb" transfer].    }
Program Extract;

const
  CommTable: Array [128..234] of String[15] =
    ( 'END',  'FOR',
      'NEXT','DATA','INPUT','DEL','DIM','READ','GR','TEXT','PR#','IN#',
      'CALL','PLOT','HLIN','VLIN','HGR2','HGR','HCOLOR=','HPLOT','HDRAW','XDRAW',
      'HTAB','HOME','ROT=','SCALE=','SHLOAD','TRACE','NOTRACE','NORMAL,','INVERSE','FLASH',
      'COLOR=','POP','VTAB','HIMEM:','LOMEM:','ONERR','RESUME','RECALL','STORE','SPEED=',
      'LET','GOTO','RUN','IF','RESTORE','&','GOSUB','RETURN','REM','STOP',
      'ON','WAIT','LOAD','SAVE','DEF','POKE','PRINT','CONT','LIST','CLEAR',
      'GET','NEW','TAB(','TO','FN','SPC(','THEN','AT','NOT','STEP',
      '+', '-', '*', '/', '^', 'AND', 'OR', '>', '=', '<',
      'SGN','INT','ABS','USR','FRE','SCRN(','PDL','POS','SQR','RND',
      'LOG','EXP','COS','SIN','TAN','ATN','PEEK','LEN','STR$','VAL',
      'ASC','CHR$','LEFT$','RIGHT$','MID$' );

var
  f: File;
  ctr: Word;
  buf: Array [0..511] of Byte;
  code: Word;
  NumRead: Word;
  b: Byte;
  state: Byte;  { 1-2=next addr, 3-4=line num, 5=standard.. }
  linenum: Byte;
begin
  if ParamCount <> 1 then begin
    writeln('Apple diskette BASIC program extractor: EXTRACT filename');
    writeln('Attempts to extract a BASIC program from a stored image file');
    writeln;
    Halt;
  end;

  Assign(F, ParamStr(1));
  Reset(F, 1);

  state := 0;

  BlockRead(f, buf, SizeOf(buf), NumRead);
  while (NumRead <> 0) do begin
    for ctr := 0 to NumRead-1 do begin
      b := buf[ctr];
      case state of
        0: state := 1; { These two states ignore first two bytes of file }
        1: state := 2;
        2: begin
             linenum := b;
             state := 3;
           end;
        3: if (linenum+256*b = 0) then begin
             writeln;
             Halt(0);
           end
           else
             state := 4;
        4: begin
             linenum := b;
             state := 5;
           end;
        5: begin
             write(Word(linenum+256*b), '  ');
             state := 6;
           end;
        6: begin
             if (b <>0) then
               if ((b >= 128) and (b <= 234)) then
                 write(' ', CommTable[b], ' ')
               else
                 write(Chr(b))
             else
             begin
               state := 2;
               writeln;
             end;
           end;
      end;
    end;
    BlockRead(f, buf, SizeOf(buf), NumRead);
  end;

  Close(f);
end.

