	'           EAMON-QB
	'       CHARACTER EDITOR
	'          VERSION II
	'
	'        BY JOHN NELSON
	'
	'
	'
	'
	'================================================================
	'                 Change Log
	'----------------------------------------------------------------
	' 1/30/00  Weapon edit allowed entering an illegal weapon type
	' ===============================================================
	 DEFINT A-Z
	 DECLARE SUB PrtCenter (L$)
	 DECLARE SUB WaitSecs (N!)
	 KEY OFF
	 ON ERROR GOTO NoColors
	 OPEN "EAMCOLOR" FOR INPUT AS #1
	 INPUT #1, fgc%
	 INPUT #1, bgc%
	 INPUT #1, hfg%
	 INPUT #1, hbg%
	 INPUT #1, brt%
	 CLOSE
In.BW:
	 ON ERROR GOTO 0
	 COLOR fgc%, bgc%
	 GOTO Colorset
NoColors:
	  fgc% = 7
	  bgc% = 0
	  hfg% = 0
	  hbg% = 7
	  RESUME In.BW
Colorset:
	' ON ERROR GOTO Error.Handler
	REM $INCLUDE: '\EAMON\COPY\CHARDEF.BAS'
	DIM WN$(4), WR%(4), WT%(4), WC%(4), WD%(4), WS%(4), SA%(4), WA%(5)
	DIM WT$(5), SPL.NAM$(4), ARM$(7), I.X%(4), N#(3)
	GOSUB INITIALIZE
	DEF FNST$ (X) = MID$(STR$(X), 1 + ABS(X >= 0))
	GOSUB OPEN.CHARACTERS
	GOSUB READ.NBR.CHARS
	DIM Nam$(NC + 20)
	FOR X = 1 TO 25
	P$ = P$ + "."
	NEXT
	MAX.DAM = 60
	MAX.HD = 299
	MAX.AG = 199
	MAX.CH = 99
	MAX.WA = 100
	MAX.SA = 600
	MAX.DICE = 6
	MAX.SIDES = 24
	MAX.GOLD& = 32000&
	GOSUB TABLE.NAMES
	IF CHAV = 0 THEN
	CLS
	PRINT "There are no characters to edit on this disk."
	PRINT
	PRINT "(Press any key to continue) ... ";
	A$ = INPUT$(1)
	RUN "WONDERFL"
	END IF
	ON ERROR GOTO NoAdvent
	OPEN "ADVENT" FOR INPUT AS #2
	INPUT #2, Nam$, REC
	CLOSE 2
	GOSUB READ.CHARACTER
	C = REC - 1
	' GOTO Select.Character
' -------------------------------------------------------------------
Main.Menu:
' -------------------------------------------------------------------
	CLS
	EDT.PRIV = 0
	PrtCenter "Eamon"
	PrtCenter "Character Editor"
	PrtCenter "By John Nelson"
	PRINT
	CSR.WNT = 0
	LOCATE , , 0
	LOCATE 11, 29
	PRINT "Select Action:"
	PRINT SPC(26); "  1. Select a character"
	PRINT SPC(26); "  2. Update a character"
	PRINT SPC(26); "  3. Change Weapons/Armour"
	PRINT SPC(26); "  4. Display Characters"
	PRINT SPC(26); "  5. Make a clone"
	PRINT SPC(26); "  6. Quit"
	PRINT SPC(26); "Input a number (1-6)...";
	A$ = ""
	WHILE A$ < "1" OR A$ > "6"
	  A$ = INKEY$
	  ' enter ^P to enter password
	  IF A$ = CHR$(16) THEN
	  PASS$ = INPUT$(1)
	  IF PASS$ = "J" THEN
		  PASS$ = INPUT$(1)
		  IF PASS$ = "O" THEN
		  PASS$ = INPUT$(1)
		  IF PASS$ = "H" THEN
			  PASS$ = INPUT$(1)
			  IF PASS$ = "N" THEN EDT.PRIV = -1
		  END IF
		  END IF
	  END IF
	  END IF
	WEND
	S = VAL(A$)
	ON S GOTO Select.Character, UPDATE.CHARACTER, UPDATE.WEAPONS, DISPLAY.CHARACTER, MAKE.A.CLONE, QUIT.RTN
' -------------------------------------------------------------------
Select.Character:
' -------------------------------------------------------------------
	IF C > 0 THEN
	GOSUB WRITE.CHARACTER
	END IF
	GOSUB NAME.MENU
	IF C < 1 OR C > NC THEN GOTO Select.Character
	IF LEFT$(Nam$(C), 1) = "*" THEN
	REC = C + 1
	GOSUB READ.CHARACTER
	Nam$ = MID$(Nam$, 6)
	GOTO Main.Menu
	END IF
	IF LEFT$(Nam$(C), 1) = "*" THEN BEEP: GOTO Select.Character
	REC = C + 1
	GOSUB READ.CHARACTER
	IF PERFED THEN RETURN
	GOTO Main.Menu
NoAdvent:
	RESUME Main.Menu
' -------------------------------------------------------------------
UPDATE.CHARACTER:
' -------------------------------------------------------------------
	IF C = 0 THEN
		PERFED = -1
		GOSUB Select.Character
		PERFED = 0
	END IF
	GOSUB FORMAT.DISPLAY
	CSR.WNT = -1
	GOSUB EDIT.CHARACTER
	IF ESC THEN GOTO IGNORE.UPDATE
	CSR.WNT = 0
	GOTO Main.Menu
IGNORE.UPDATE:
	CLS
	LOCATE 6, 10
	PRINT "Ignore updates or write record?"
	LOCATE 8, 10
	PRINT "PRESS 'I' OR 'W' ...";
	A$ = ""
	WHILE A$ <> "I" AND A$ <> "W"
	  A$ = UCASE$(INKEY$)
	WEND
	PRINT A$
	CSR.WNT = 0
	IF A$ = "I" THEN GOSUB READ.CHARACTER: GOTO Main.Menu
	GOSUB WRITE.CHARACTER
	GOTO Main.Menu
' -------------------------------------------------------------------
UPDATE.WEAPONS:
' -------------------------------------------------------------------
	IF C = 0 THEN
	PERFED = -1
	GOSUB Select.Character
	PERFED = 0
	END IF
	CLS
	PrtCenter "Select Weapon to Update"
	PrtCenter " (or Add a Weapon) "
	WC = 0
	FOR W = 1 TO 4
	IF RTRIM$(UCASE$(WN$(W))) <> "NONE" THEN
		LOCATE W + 3, 6
		PRINT WN$(W);
		LOCATE W + 3, 35
		PRINT USING "##"; WT%(W);
		LOCATE W + 3, 40
		PRINT USING "###"; WC%(W);
		LOCATE W + 3, 45
		PRINT USING "###"; WD%(W);
		LOCATE W + 3, 50
		PRINT USING "###"; WS%(W);
		PRINT
		WC = WC + 1
	END IF
	NEXT
	IF WC < 4 THEN
	LOCATE WC + 4, 6
	PRINT "(Add a New Weapon)"
	END IF
	C.LIN = 4
	MAX.LIN = 4 + WC
	IF WC = 4 THEN MAX.LIN = MAX.LIN - 1
PICK.WEAPON:
	LOCATE C.LIN, 1
	PRINT CHR$(16);
	GOSUB GET.CTL.BYTE
	IF PG.UP THEN BEEP: GOTO PICK.WEAPON
	IF PG.DN THEN BEEP: GOTO PICK.WEAPON
	IF UCASE$(A$) = "S" OR A$ = CHR$(13) THEN W = C.LIN - 3: GOTO CHANGE.WEAPON
	IF CSR.DN THEN
	LOCATE C.LIN, 1
	PRINT SPC(5);
	C.LIN = C.LIN + 1
	IF C.LIN > MAX.LIN THEN C.LIN = 4
	END IF
	IF CSR.UP THEN
	LOCATE C.LIN, 1
	PRINT SPC(5);
	C.LIN = C.LIN - 1
	IF C.LIN < 4 THEN C.LIN = MAX.LIN
	END IF
	GOTO PICK.WEAPON
CHANGE.WEAPON:
	CSR.WNT = -1
	CLS
	IF W > WC THEN
	W = WC + 1
	PrtCenter "Adding a Weapon"
	ELSE
	PrtCenter "Modifying " + WN$(W)
	END IF
	LOCATE 3, 7
	IF RTRIM$(UCASE$(WN$(W))) = "NONE" THEN WN$(W) = ""
	PRINT "Name: "; WN$(W)
	LOCATE 5, 7
	PRINT "Type: "; WT%(W)
	LBL1$ = "Complexity (%)"
	LBL2$ = "Dice"
	LBL3$ = "Sides"
	LOCATE 7, 7
	PRINT LBL1$;
	LOCATE 7, 29
	PRINT USING "###"; WC%(W)
	LOCATE 9, 7
	PRINT LBL2$;
	LOCATE 9, 29
	PRINT USING "###"; WD%(W)
	LOCATE 11, 7
	PRINT LBL3$;
	LOCATE 11, 29
	PRINT USING "###"; WS%(W)
EDIT.WEAPON:
	LOCATE 3, 13
	FMT$ = "T20"
	DF$ = WN$(W)
	BK = -1
	CAPS = -1
	GOSUB GENERAL.IO
	IF ESC THEN GOTO Main.Menu
	IF BK THEN GOTO Main.Menu
	IF RTRIM$(I$) = "" THEN I$ = "NONE"
	IF RTRIM$(UCASE$(I$)) = "NONE" THEN
	IF WT%(W) < 1 OR WT%(W) > 5 THEN WT%(W) = 3
	I$ = WT$(WT%(W))
	END IF
	WN$(W) = I$
	LOCATE 3, 13
	PRINT LEFT$(WN$(W) + SPACE$(20), 20)
EDIT.WEAPON.FLDS:
	GOSUB SHOW.WEAPON.TYPES
	DO
	LOCATE 5, 14
	FMT$ = "N1"
	DF$ = FNST$(WT%(W))
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN GOTO Main.Menu
	LOOP WHILE NUM# < 1 OR NUM# > 5
	LOCATE 17, 1
	GOSUB CLEAR.TO.BOTTOM
	IF BK THEN GOTO EDIT.WEAPON
	WT%(W) = NUM#
	GOTO EDIT.COMPLEX
SHOW.WEAPON.TYPES:
' === DISPLAY WEAPON TYPES ===
	FOR X = 1 TO 5
	  LOCATE 17 + X, 7
	  PRINT X; "="; WT$(X)
	NEXT
	RETURN
' -------------------------------------------------------------------
DISPLAY.CHARACTER:
' -------------------------------------------------------------------
	IF C = 0 THEN
	CLS
	LOCATE 12, 10
	COLOR hfg%, hbg%
	PrtCenter " No Record Selected "
	COLOR fgc%, bgc%
	GOSUB PAUSE.MESSAGE
	GOTO Main.Menu
	END IF
	GOSUB FORMAT.DISPLAY
	GOSUB PRESS.ANY.KEY
	GOTO Main.Menu
' -------------------------------------------------------------------
MAKE.A.CLONE:
' -------------------------------------------------------------------
	IF C = 0 THEN
	CLS
	LOCATE 12, 10
	COLOR 0, 7
	PRINT "No Record Selected"
	COLOR 7, 0
	GOSUB PAUSE.MESSAGE
	GOTO Main.Menu
	END IF
	SAVNAM$ = Nam$
	CLS
	LOCATE 6, 10
	INPUT "Clone's Name:", Nam$
	SAVREC = REC
	REC = NC + 2
	NC = NC + 1
	Nam$(NC) = Nam$
	GOSUB WRITE.CHARACTER
	REC = SAVREC
	Nam$ = SAVNAM$
	GOSUB WRITE.NBR.CHARS
	GOTO Main.Menu
QUIT.RTN:
	GOSUB WRITE.CHARACTER
	CLOSE
	OPEN "LASTPGM" FOR INPUT AS #5
	INPUT #5, PGM$
	CLOSE 5
	RUN PGM$
	END
INITIALIZE:
	SCRL.AMT = 20
	PAG.SZ = 20
	FILENM$ = "CHARACT"
	FOR X = 1 TO 5
	READ WT$(X)
	NEXT
	FOR X = 1 TO 4
	READ SPL.NAM$(X)
	NEXT
	FOR X = 0 TO 7
	READ ARM$(X)
	NEXT
	RETURN
' === DATA ===
	DATA Axe,Bow,Mace,Spear,Sword
	DATA Blast,Heal,Speed,Power
	DATA Skin,Shield Only,Leather,Leather and Shield,Chain Mail,Chain and Shield,Plate,Plate and Shield
EDIT.COMPLEX:
	LOCATE 7, 7
	PRINT LEFT$(LBL1$ + STRING$(20, "."), 20);
	LOCATE 7, 29
	FMT$ = "N3"
	DF$ = FNST$(WC%(W))
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO EDIT.WEAPON.FLDS
	WC%(W) = NUM#
EDIT.DICE:
	LOCATE 9, 7
	PRINT LEFT$(LBL2$ + STRING$(20, "."), 20);
	LOCATE 9, 29
	FMT$ = "N3"
	DF$ = FNST$(WD%(W))
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN GOTO Main.Menu
	IF BK THEN GOTO EDIT.COMPLEX
	WD%(W) = NUM#
EDIT.SIDES:
	LOCATE 11, 7
	PRINT LEFT$(LBL3$ + STRING$(20, "."), 20)
	LOCATE 11, 29
	FMT$ = "N3"
	DF$ = FNST$(WS%(W))
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN GOTO Main.Menu
	IF BK THEN GOTO EDIT.DICE
	WS%(W) = NUM#
	GOSUB WRITE.CHARACTER
	CSR.WNT = 0
	LOCATE , , 0
	GOTO Main.Menu
NAME.MENU:
'    ===  NAME MENU ===
	C.LIN = 1
	MAX.LIN = 20
	IF MAX.LIN > NC THEN MAX.LIN = NC
	BEG.NO = 1
	END.NO = PAG.SZ
	IF END.NO > NC THEN END.NO = NC
	GOSUB LIST.PLAYERS
READ.MENU.KB:
	LOCATE C.LIN, 1
	PRINT CHR$(16);
	GOSUB GET.CTL.BYTE
	IF PG.UP THEN GOSUB PAGE.UP.RTN: GOTO READ.MENU.KB
	IF PG.DN THEN GOSUB PAGE.DN.RTN: GOTO READ.MENU.KB
	IF UCASE$(A$) = "S" THEN GOSUB PICKED.ONE: RETURN
	IF CSR.DN THEN LOCATE C.LIN, 1: PRINT SPC(5); : C.LIN = C.LIN + 1: IF C.LIN > MAX.LIN THEN C.LIN = 1
	IF CSR.UP THEN LOCATE C.LIN, 1: PRINT SPC(5); : C.LIN = C.LIN - 1: IF C.LIN < 1 THEN C.LIN = MAX.LIN
	GOTO READ.MENU.KB
PICKED.ONE:
' === SELECTED ===
	C = BEG.NO + C.LIN - 1
	RETURN
LIST.PLAYERS:
' === LIST ITEMS ===
	CLS
	FOR R = BEG.NO TO END.NO
	IF LEFT$(Nam$(R), 1) = "*" THEN PRINT USING "     ##. "; R; : PRINT "*** DEAD ***" ELSE PRINT USING "     ##. "; R; : PRINT Nam$(R)
	NEXT
	LOCATE 25, 1
	PRINT "Press  'S' to select record ---- move pointer to line of record ";
	LOCATE C.LIN, 1
	PRINT CHR$(16);
	RETURN
PAGE.UP.RTN:
' === PG.UP --- PAGE UP ROUTINE ===
	MAX.LIN = SCRL.AMT
	BEG.NO = BEG.NO - SCRL.AMT
	END.NO = BEG.NO + PAG.SZ - 1
	IF BEG.NO < 1 THEN BEG.NO = 1
	IF END.NO < BEG.NO THEN END.NO = BEG.NO + PAG.SZ
	IF END.NO > NC THEN END.NO = NC: MAX.LIN = END.NO - BEG.NO + 1
	GOSUB LIST.PLAYERS
	RETURN
PAGE.DN.RTN:
	MAX.LIN = SCRL.AMT
	BEG.NO = BEG.NO + SCRL.AMT
	END.NO = BEG.NO + PAG.SZ - 1
	IF BEG.NO > NC THEN BEG.NO = NC - PAG.SZ
	IF BEG.NO < 1 THEN BEG.NO = 1
	IF END.NO < BEG.NO THEN END.NO = BEG.NO + PAG.SZ
	IF END.NO > NC THEN END.NO = NC: MAX.LIN = END.NO - BEG.NO + 1
	GOSUB LIST.PLAYERS
	RETURN
EDIT.CHARACTER:
' === UPDATE ROUTINE ===
	CSR.WNT = -1
	LOCATE 1, 6
	FMT$ = "T20"
	DF$ = Nam$
	CAPS = -1
	BK = 0
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	Nam$ = I$
	LOCATE 1, 6
	PRINT LEFT$(Nam$ + SPACE$(20), 20)
	Nam$(C) = Nam$
EDIT.HD:
	LOCATE 3, 14
	FMT$ = "N4"
	DF$ = FNST$(HD)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO EDIT.CHARACTER
	IF EDT.PRIV = 0 THEN IF NUM# > MAX.HD THEN BEEP: GOTO EDIT.HD
	HD = NUM#
EDIT.AG:
	LOCATE 3, 30
	FMT$ = "N4"
	DF$ = FNST$(AG)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO EDIT.HD
	IF EDT.PRIV = 0 THEN IF NUM# > MAX.AG THEN BEEP: GOTO EDIT.AG
	AG = NUM#
EDIT.CH:
	LOCATE 3, 47
	FMT$ = "N4"
	DF$ = FNST$(CH)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO EDIT.AG
	IF EDT.PRIV = 0 THEN IF NUM# > MAX.CH THEN BEEP: GOTO EDIT.CH
	CH = NUM#
EDIT.SPELLS:
	S = 1
EDIT.A.SPELL:
	LOCATE 7 + ABS(S > 4), (S - (1 + ABS(S > 4) * 4)) * 15 + 10
	DF$ = FNST$(SA%(S))
	FMT$ = "N4"
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN
	S = S - 1
	IF S < 1 THEN
		GOTO EDIT.CH
	ELSE
		GOTO EDIT.A.SPELL
	END IF
	END IF
	IF EDT.PRIV = 0 THEN IF NUM# > MAX.SA THEN BEEP: GOTO EDIT.A.SPELL
	SA%(S) = NUM#
	S = S + 1
	IF S <= 4 THEN GOTO EDIT.A.SPELL
	W = 1
Edit.Weapon.Abil:
	LOCATE 10, (W - 1) * 13 + 9
	FMT$ = "N3"
	DF$ = FNST$(WA%(W))
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN
	W = W - 1
	IF W < 1 THEN
		S = 4
		GOTO EDIT.A.SPELL
	ELSE
		GOTO Edit.Weapon.Abil
	END IF
	END IF
	IF EDT.PRIV = 0 THEN IF NUM# > MAX.WA THEN BEEP: GOTO Edit.Weapon.Abil
	WA%(W) = NUM#
	W = W + 1
	IF W <= 5 THEN GOTO Edit.Weapon.Abil
Edit.Armour:
	LOCATE 25, 1
	PRINT "Enter Armor name - do not include 'Armor' in name ...";
	LOCATE 12, 9
	CSR.WNT = -1
	FMT$ = "T20"
	DF$ = ArmNam$
	CAPS = -1
	BK = -1
	GOSUB GENERAL.IO
	LOCATE 25, 1
	PRINT SPC(79);
	IF BK THEN
	LOCATE 12, 9
	PRINT LEFT$(ArmNam$ + " Armor" + SPACE$(20), 20)
	W = 5
	GOTO Edit.Weapon.Abil
	END IF
	IF ESC THEN RETURN
	ArmNam$ = I$
	LOCATE 12, 9
	PRINT LEFT$(ArmNam$ + " Armor" + SPACE$(20), 20)
Edit.ArmHit:
	LOCATE 12, 31
	FMT$ = "N2"
	DF$ = FNST$(ArmHit)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO Edit.Armour
	IF EDT.PRIV = 0 THEN IF NUM# > 12 THEN BEEP: GOTO Edit.ArmHit
	ArmHit = NUM#
Edit.ArmAdj:
	LOCATE 12, 36
	FMT$ = "N3"
	DF$ = FNST$(ArmAdj)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO Edit.ArmHit
	IF EDT.PRIV = 0 THEN IF NUM# < 0 THEN BEEP: GOTO Edit.ArmAdj
	ArmAdj = NUM#
Edit.Shield:
	LOCATE 25, 1
	PRINT "Enter Shield name - do not include 'Shield' in name ...";
	LOCATE 12, 40
	CSR.WNT = -1
	FMT$ = "T20"
	DF$ = ShdNam$
	CAPS = -1
	GOSUB GENERAL.IO
	LOCATE 25, 1
	PRINT SPC(79);
	IF BK THEN
	LOCATE 12, 40
	IF ShdNam$ <> "NONE" THEN
		PRINT LEFT$(ShdNam$ + " Shield" + SPACE$(20), 20)
	ELSE
		PRINT SPACE$(20)
	END IF
	GOTO Edit.ArmAdj
	END IF
	IF ESC THEN RETURN
	IF UCASE$(LEFT$(I$, 4)) = "NONE" THEN
	LOCATE 12, 40
	PRINT SPACE$(20)
	GOTO Edit.AE
	END IF
	ShdNam$ = I$
	LOCATE 12, 40
	PRINT LEFT$(ShdNam$ + " Shield" + SPACE$(20), 20)
Edit.ShdHit:
	LOCATE 12, 62
	FMT$ = "N2"
	DF$ = FNST$(ShdHit)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO Edit.Shield
	IF EDT.PRIV = 0 THEN IF NUM# > 10 THEN BEEP: GOTO Edit.ShdHit
	ShdHit = NUM#
Edit.ShdAdj:
	LOCATE 12, 66
	FMT$ = "N3"
	DF$ = FNST$(ShdAdj)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO Edit.ShdHit
	IF EDT.PRIV = 0 THEN IF NUM# < 0 THEN BEEP: GOTO Edit.ShdAdj
	ShdAdj = NUM#
Edit.AE:
	LOCATE 12, 75
	FMT$ = "N3"
	DF$ = FNST$(AE)
	BK = -1
	GOSUB GENERAL.IO
	IF BK THEN GOTO Edit.ShdAdj
	IF ESC THEN RETURN
	IF EDT.PRIV = 0 THEN IF NUM# > 100 THEN BEEP: GOTO Edit.AE
	AE = NUM#
Edit.Gold:
	LOCATE 14, 9
	FMT$ = "C7"
	IF GOLD& > 20000 THEN GOLD& = 12000
	DF$ = FNST$(GOLD&)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO Edit.AE
	IF NUM# > MAX.GOLD& THEN BEEP: GOTO Edit.Gold
	GOLD& = NUM#
EDIT.BANK:
	LOCATE 14, 41
	FMT$ = "C7"
	IF BANK& > 20000 THEN BANK& = 12000
	DF$ = FNST$(BANK&)
	BK = -1
	GOSUB GENERAL.IO
	IF ESC THEN RETURN
	IF BK THEN GOTO Edit.Gold
	IF EDT.PRIV = 0 THEN IF NUM# > MAX.GOLD& THEN BEEP: GOTO EDIT.BANK
	BANK& = NUM#
	RETURN
GET.CTL.BYTE:
	PG.UP = 0
	PG.DN = 0
	CSR.UP = 0
	CSR.DN = 0
GET.CTL:
	A$ = ""
	WHILE A$ = ""
	  A$ = INKEY$
	WEND
	IF A$ = CHR$(0) + CHR$(73) THEN PG.UP = -1: RETURN
	IF A$ = CHR$(0) + CHR$(81) THEN PG.DN = -1: RETURN
	IF A$ = CHR$(0) + CHR$(72) THEN CSR.UP = -1: RETURN
	IF A$ = CHR$(0) + CHR$(80) THEN CSR.DN = -1: RETURN
	IF UCASE$(A$) = "S" THEN RETURN
	IF A$ = CHR$(13) THEN CSR.DN = -1: RETURN
	IF A$ = CHR$(27) THEN ESC = -1: RETURN
	GOTO GET.CTL
FORMAT.DISPLAY:
' === DISPLAY FORMATTED RECORD ===
	CLS
	LOCATE 1, 1
	PRINT "Name:"; Nam$;
	LOCATE 3, 3
	PRINT "Hardiness: ";
	PRINT USING "####"; HD;
	LOCATE 3, 21
	PRINT "Agility: ";
	PRINT USING "####"; AG;
	LOCATE 3, 37
	PRINT "Charisma: ";
	PRINT USING "####"; CH
	FOR S = 1 TO 4
	LOCATE 7, (S - 1) * 15 + 1
	PRINT SPL.NAM$(S);
	LOCATE 7, (S - 1) * 15 + 10
	PRINT USING "####"; SA%(S);
	NEXT
	FOR W = 1 TO 5
	LOCATE 10, (W - 1) * 13 + 1
	PRINT WT$(W); ":";
	LOCATE 10, (W - 1) * 13 + 9
	PRINT USING "###"; WA%(W);
	PRINT "%  ";
	NEXT
	LOCATE 12, 1
	IF AC > 7 THEN AC = 7
	PRINT "Armour: ";
	LOCATE 12, 9
	PRINT ArmNam$;
	LOCATE 12, 31
	PRINT USING "##"; ArmHit;
	LOCATE 12, 36
	PRINT USING "###"; ArmAdj
	LOCATE 12, 40
	PRINT ShdNam$;
	LOCATE 12, 62
	PRINT USING "##"; ShdHit;
	LOCATE 12, 66
	PRINT USING "###"; ShdAdj
	LOCATE 12, 70
	PRINT "Exp:";
	LOCATE 12, 75
	PRINT USING "###"; AE;
	PRINT "%"
	LOCATE 14, 3
	PRINT "Gold: ";
	PRINT USING "#,###,###"; GOLD&;
	LOCATE 14, 35
	PRINT "Bank: ";
	PRINT USING "#,###,###"; BANK&;
	LOCATE 16, 1
	PRINT "Weapons                       Type     Comp.     Dice    Sides"
	FOR W = 1 TO 4
	IF RTRIM$(UCASE$(WN$(W))) <> "NONE" THEN
	LOCATE 16 + W, 6
	PRINT WN$(W);
	LOCATE 16 + W, 30
	IF WT%(W) > 5 THEN WT%(W) = 0
	PRINT WT$(WT%(W));
	LOCATE 16 + W, 40
	PRINT USING "###"; WC%(W);
	LOCATE 16 + W, 50
	PRINT USING "###"; WD%(W);
	LOCATE 16 + W, 60
	PRINT USING "###"; WS%(W);
	PRINT
	END IF
	NEXT
	RETURN
PRESS.ANY.KEY:
	LOCATE 24, 1
	PRINT STRING$(24, 176); " Press Any Key to Continue "; STRING$(24, 176);
	GOSUB GET.BYTE
	CLS
	RETURN
TABLE.NAMES:
	LOCATE 10, 30
	PRINT "RECORD"
	CHAV = 0
	FOR R = 1 TO NC
	LOCATE 10, 37
	PRINT R
	REC = R + 1
	GET #1, REC, Char
	Nam$(R) = RTRIM$(Char.Nam)
	IF LEFT$(Nam$(R), 1) <> "*" THEN CHAV = CHAV + 1
	NEXT
	RETURN
PAUSE.MESSAGE:
' === PAUSE MESSAGE / CLEAR MESSAGE / RETURN
	WaitSecs 10!
	RETURN
' ===    CLEAR TO BOTTOM OF SCREEN
	V = CSRLIN
	FOR X = V TO 24
	LOCATE X, 1
	PRINT STRING$(80, 32);
	NEXT
	LOCATE V, 1
	RETURN
	REM $INCLUDE: '\Eamon\COPY\CharIO.BAS'
CLEAR.TO.BOTTOM:
' /// clear from current line down
	SAVCUR = CSRLIN
	FOR X = CSRLIN TO 24
	PRINT SPC(79);
	NEXT
	LOCATE SAVCUR, 1
	RETURN
' --- CHANGE LOG ---
GENERAL.IO:
	  ' ͻ
	  '    General Input Routine                                      
	  '   passes FMT$ (Tnn=text, In=integer D=date, Nnn.n/Cnn.n=real) 
	  '            BK   = Fast-out: 0 = unallowed -1 = allowed        
	  '            DF$  = Default data if <RETURN> is pressed         
	  '            CAPS = Force caps: 0 = Force Caps; -1 = Not forced 
	  '            ESC  - Escape pressed flag: 0 = no; -1 = yes       
	  ' ͼ
	  IF FMT$ = "YN" THEN
	  CAPS = 0
	  VALID$ = "YN"
	  GOSUB GET.A.CODE
	  RETURN
	  END IF
	  ESC = 0
	  H% = POS(1)
	  V% = CSRLIN
	  I.TY$ = LEFT$(FMT$, 1)
	  I.P = VAL(MID$(FMT$, 2))
	  I.L% = I.P
	  IF I.P <> INT(I.P) THEN
	 I.LD% = INT(I.P)
	 I.RD% = (I.P - I.LD%) * 10
	  ELSE
	 I.LD% = I.P
	 I.RD% = 0
	  END IF
	  IF DF$ = "0" AND I.TY$ = "D" THEN DF$ = ""
	  IF I.TY$ = "D" THEN GOTO DATE.IO
	  IF I.TY$ = "N" OR I.TY$ = "C" THEN GOTO NUMER.IO
	  LOCATE V%, H%
	  PRINT LEFT$(DF$ + STRING$(94, 95), I.L%);
	  FOR I% = 1 TO I.L%: PRINT CHR$(29); : NEXT
STD.IO:
	  I$ = "": ' Standard Text input routine
GET.STRING:
	  GOSUB GET.BYTE
	  IF A$ = CHR$(27) THEN ESC = -1: GOTO RETURN.IO
	  IF A$ = CHR$(28) THEN IF LEN(I$) < LEN(DF$) THEN A$ = MID$(DF$, LEN(I$) + 1, 1)
	  IF ASC(A$) > 31 AND LEN(I$) = 0 THEN LOCATE V%, H%: PRINT STRING$(I.L%, "_"); : FOR I% = 1 TO I.L%: PRINT CHR$(29); : NEXT
	  IF ASC(A$) > 31 AND LEN(I$) < I.L% THEN GOTO BLD.STRING
	  IF ASC(A$) <> 13 THEN GOTO CHK.BACKSPC
	  IF I$ = "" THEN I$ = DF$: PRINT I$;
	  IF I.TY$ = "T" OR LEN(I$) > 0 THEN GOTO NUMER.RETURN
CHK.BACKSPC:
	  IF ASC(A$) <> 29 THEN PRINT CHR$(7); : GOTO GET.STRING
	  IF LEN(I$) THEN PRINT CHR$(29); "_"; CHR$(29); : IF LEN(I$) > 1 THEN I$ = LEFT$(I$, LEN(I$) - 1): GOTO GET.STRING
	  IF BK = 0 OR LEN(I$) THEN GOTO STD.IO
	  GOTO RETURN.IO
BLD.STRING:
	  IF I.TY$ = "I" AND (A$ < "0" OR A$ > "9") THEN GOTO CHK.BACKSPC
	  PRINT A$; : I$ = I$ + A$
	  GOTO GET.STRING
DATE.IO: ' Date Format
	  I.X%(0) = 12
	  I.X%(1) = 31
	  I.X%(2) = 99
	  IF DF$ = "" THEN PRINT "__/__/__"; STRING$(8, 29); : I$ = "": I.PT% = 0 ELSE PRINT MID$(DF$, 3, 2); "/"; RIGHT$(DF$, 2); "/"; LEFT$(DF$, 2); STRING$(8, 29); : I$ = "": I.PT% = 0
GET.DATE.BYTE:
	  GOSUB GET.BYTE
	  IF A$ = CHR$(27) THEN ESC = -1: GOTO RETURN.IO
	  IF ASC(A$) < 32 THEN GOTO CHK.DATE.END
	  IF A$ = " " OR A$ = "," OR A$ = "/" THEN GOTO DATE.DLM
CHK.DATE.NUM:
	  IF (A$ < "0" OR A$ > "9") OR I.PT% > 2 THEN PRINT CHR$(7); : GOTO GET.DATE.BYTE
	  IF I$ = "" AND I.PT% = 0 THEN PRINT "__/__/__"; STRING$(8, 29);
	  I$ = I$ + A$
	  PRINT A$;
	  IF I$ = A$ THEN GOTO GET.DATE.BYTE
DATE.DLM:
	  I = VAL(I$)
	  IF I$ = "" THEN GOTO GET.DATE.BYTE
	  PRINT STRING$(LEN(I$), 29);
	  A$ = STR$(INT(I / 10))
	  PRINT MID$(A$, 2, 1);
	  A$ = STR$(I - VAL(A$) * 10)
	  PRINT MID$(A$, 2, 1);
	  IF I > I.X%(I.PT%) THEN PRINT CHR$(7); : GOTO PRT.DT.MASK
	  N#(I.PT%) = I
	  I$ = ""
	  I.PT% = I.PT% + 1
	  PRINT MID$("/ ", 1 - (I.PT% = 3), 1);
	  GOTO GET.DATE.BYTE
CHK.DATE.END:
	  IF (ASC(A$) = 13) AND I.PT% = 0 AND I$ = "" THEN PRINT : DTE = VAL(DF$): GOTO RETURN.DATA
	  IF NOT (ASC(A$) = 8 OR (ASC(A$) = 13 AND I.PT% = 3)) THEN GOTO CHK.DATE.NUM
	  IF ASC(A$) = 13 THEN PRINT : DTE = N#(2) * 10000 + N#(0) * 100 + N#(1): GOTO RETURN.DATA
PRT.DT.MASK:
	  IF LEN(I$) THEN I$ = LEFT$(" " + I$, LEN(I$)): I$ = MID$(I$, 2): PRINT CHR$(29); "_"; CHR$(29); : GOTO GET.DATE.BYTE
	  IF I.PT% = 0 THEN IF BK <> 0 THEN GOTO RETURN.IO ELSE GOTO CHK.DATE.NUM
	  PRINT CHR$(29); CHR$(29); "_"; CHR$(29);
	  I.PT% = I.PT% - 1
	  I$ = MID$(STR$(INT(N#(I.PT%) / 10)), 2, 1)
	  GOTO GET.DATE.BYTE
NUMER.IO: ' Numeric I/O
	  IF I.TY$ = "C" THEN I.U$ = RIGHT$("###,###,###", I.LD% + ABS(I.LD% > 3) + ABS(I.LD% > 6))
	  IF I.TY$ = "N" THEN I.U$ = STRING$(I.L%, "#")
	  IF I.RD% > 0 THEN I.U$ = I.U$ + "." + STRING$(I.RD%, "#")
	  I$ = ""
	  I.DR% = 0
GET.NUMBER:
	  LOCATE V%, H%
	  IF I$ <> "" THEN PRINT USING I.U$; VAL(I$);  ELSE PRINT USING I.U$; VAL(DF$);
GET.DIGIT:
	  IF I.TY$ = "C" THEN LOCATE V%, H% + I.L% + INT(I.L% / 3) - 1
	  IF I.TY$ = "N" THEN LOCATE V%, H% + I.L% - 1
	  GOSUB GET.BYTE
	  IF A$ = CHR$(13) THEN GOTO END.NUMBER
	  IF A$ = CHR$(27) THEN ESC = -1: GOTO RETURN.IO
	  IF A$ = CHR$(29) AND LEN(I$) > 0 THEN I$ = LEFT$(I$, LEN(I$) - 1): IF INSTR(I$, ".") > 0 THEN I.DR% = I.DR% - 1: GOTO GET.NUMBER ELSE GOTO GET.NUMBER
	  IF A$ = CHR$(29) AND I$ = "" AND BK = -1 THEN GOTO RETURN.IO
	  IF A$ = "-" AND LEFT$(I$, 1) <> "-" THEN I$ = "-" + I$: GOTO GET.NUMBER
	  IF A$ = "-" THEN I$ = MID$(I$, 2): GOTO GET.NUMBER
	  IF A$ >= "0" AND A$ <= "9" THEN
	  IF I.DR% >= I.RD% AND INSTR(I$, ".") > 0 THEN PRINT CHR$(7); : GOTO GET.DIGIT
	  IF INSTR(I$, ".") > 0 THEN I.DR% = I.DR% + 1: I$ = I$ + A$: GOTO GET.NUMBER
	  IF LEN(I$) < I.L% THEN I$ = I$ + A$: GOTO GET.NUMBER
	  END IF
	  IF A$ = "." AND INSTR(I$, ".") = 0 THEN I$ = I$ + ".": GOTO GET.NUMBER
	  PRINT CHR$(7);
	  GOTO GET.DIGIT
END.NUMBER:
	  IF I$ = "" THEN I$ = DF$
NUMER.RETURN:
	  NUM# = VAL(I$)
RETURN.DATA:
	  BK = 0
RETURN.IO:
	  LOCATE , , 0: RETURN
GET.A.CODE:
	  GOSUB GET.BYTE
	  IF A$ = CHR$(13) THEN I$ = DF$: BK = 0: ESC = 0: RETURN
	  IF A$ = CHR$(27) THEN I$ = DF$: ESC = -1: BK = 0: RETURN
	  IF A$ = CHR$(8) THEN I$ = DF$: BK = -1: ESC = 0: RETURN
	  I = INSTR(VALID$, A$)
	  IF I > 0 THEN I$ = MID$(VALID$, I, 1): PRINT A$; : BK = 0: ESC = 0: RETURN
	  BEEP
	  GOTO GET.A.CODE
GET.BYTE: ' get a keystroke & convert to std 1 byte code
	  IF CSR.WNT THEN LOCATE , , 1, 0, 7 ELSE LOCATE , , 0
	  A$ = ""
	  WHILE A$ = ""
	 A$ = INKEY$
	  WEND
	  IF A$ = CHR$(127) THEN A$ = CHR$(29)
	  IF A$ = CHR$(8) THEN A$ = CHR$(29)
	  IF A$ = CHR$(0) + CHR$(75) THEN A$ = CHR$(29): ' CURSOR LEFT
	  IF A$ = CHR$(0) + CHR$(77) THEN A$ = CHR$(28): ' CURSOR RIGHT
	  IF A$ = CHR$(0) + CHR$(80) THEN A$ = CHR$(31): ' CURSOR DOWN
	  IF A$ = CHR$(0) + CHR$(73) THEN A$ = CHR$(24): ' PG UP
	  IF A$ = CHR$(0) + CHR$(72) THEN A$ = CHR$(30): ' CURSOR UP
	  IF A$ = CHR$(0) + CHR$(81) THEN A$ = CHR$(25): ' PG DN
	  A$ = LEFT$(A$, 1)
	  IF CAPS THEN LOCATE , , 0: RETURN
	  IF A$ >= "a" THEN A$ = CHR$(ASC(A$) - 32)
	  LOCATE , , 0: RETURN
Error.Handler:
	  PRINT "Error "; ERR; " has occurred."
	  RESUME
	  ' STOP

SUB PrtCenter (L$)
	LOCATE , (80 - LEN(L$)) \ 2 + 1
	PRINT L$
END SUB

SUB WaitSecs (N!)
	NW! = TIMER + N!
	DO UNTIL NW! < TIMER
	   IF INKEY$ <> "" THEN NW! = 0
	LOOP

END SUB

