     '         Eamon
     '      Dungeon Edit
     '
     '     Version 5.22
     '
     '     By John Nelson
     '
     '    Change Log is at end of Program...
     '
     DEFINT A-Z
     DECLARE SUB NumericIo (Fmt$, Df, I.Num, Bk)
     DECLARE SUB GetByte (A$)
     DECLARE SUB TEXTIO (I$, Df$, Bk)
     DECLARE SUB PrtCenter (L$)
     KEY OFF
     DIM SHARED RAEM AS INTEGER
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     FOR X = 1 TO 10: KEY X, "": NEXT
     ON ERROR GOTO NoAdvPath
     OPEN "DDD\AdvPath.DAT" FOR INPUT AS #1
     INPUT #1, Path$
     CLOSE 1
     IF Path$ <> "" THEN
         IF RIGHT$(Path$, 1) <> "\" THEN Path$ = Path$ + "\"
     END IF
InAdv:
     CLS
     LOCATE 6, 10
     DIM SP.LOC$(5)
     SP.LOC$(0) = "Room Nbr"
     SP.LOC$(1) = "Inside Art #"
     SP.LOC$(2) = "Embed Room #"
     SP.LOC$(3) = "Hidden Room #"
     SP.LOC$(4) = "Buried Room #"
     SP.LOC$(5) = "Carried by Mon#"
     DIM Mon$(36)
     DIM Dirct$(14)
     OPEN "\Eamon\DDD\ARTIF.DEF" FOR INPUT AS #1
     INPUT #1, AD.FLDS         ' normally 8
     INPUT #1, AD.ART.TYPES    ' normally 15
     DIM Art$(8)     ' four entries for expansion
     FOR D = 1 TO AD.FLDS
       INPUT #1, Art$(D)
     NEXT
     CLOSE 1
     OPEN "\Eamon\DDD\MONST.DEF" FOR INPUT AS #1
     INPUT #1, MD.FLDS
     FOR D = 1 TO MD.FLDS
       INPUT #1, Mon$(D)
     NEXT
     CLOSE 1
     OPEN "\Eamon\DDD\ROOMS.DEF" FOR INPUT AS #1
     INPUT #1, NBR.DIR
     FOR D = 1 TO NBR.DIR
       INPUT #1, Dirct$(D)
     NEXT
     CLOSE 1
     OPEN "\Eamon\DDD\ARTTYPE.DEF" FOR RANDOM AS #1 LEN = 128
     DIM ATF.LBL$(4)
     FIELD 1, 15 AS ATF.ART.TYPE$
     FOR D = 1 TO 4
     FIELD 1, 15 AS X$, (D - 1) * 15 AS X$, 15 AS ATF.LBL$(D)
     NEXT
     FIELD 1, 75 AS X$, 2 AS ATF.DEF$, 2 AS ATF.MIN$, 2 AS ATF.MAX$
     DIM A.TYP$(AD.ART.TYPES), A.LBL$(AD.ART.TYPES, 4)
     FOR D = 0 TO AD.ART.TYPES
       GET #1, D + 1
       A.TYP$(D) = ATF.ART.TYPE$
       FOR D2 = 1 TO 4
         A.LBL$(D, D2) = ATF.LBL$(D2)
       NEXT
     NEXT
     CLOSE 1
     DIM RD%(14)
     DIM TOP.NO%(200)
     DIM AD%(12), MD%(36)
     CONST Exit.Bye = -99
GET.ADVENTURE.DISK:
     CLS
     LOCATE 6, 10, 0
     PRINT
     GOSUB READ.CTRL: ' READ NUMBER OF THINGS
' =====================================================================
'
'                  SUBROUTINES - OPEN ROOMS FILE
'
' =====================================================================
OPEN.ROOMS:
      OPEN Path$ + "ROOMS.TXT" FOR RANDOM AS #1 LEN = Rm.Len
      DIM RF.RD$(10 + RM.Flds)
      FOR X = 1 TO 10
      FIELD 1, (X - 1) * 2 AS X$, 2 AS RF.RD$(X)
      NEXT
      FIELD 1, 20 AS X$, 1 AS RF.LT$
      FOR X = 1 TO RM.Flds
      FIELD 1, 21 AS X$, (X - 1) * 2 AS X$, 2 AS RF.RD$(X + 10)
      NEXT
' =====================================================================
'
'                  SUBROUTINES - OPEN RMNAMES FILE
'
' =====================================================================
OPEN.RMNAMES:
      OPEN Path$ + "RMNAMES.TXT" FOR RANDOM AS #2 LEN = Rmn.Len
      FIELD 2, Rmn.Len AS RNF.RN$
' =====================================================================
'
'                  SUBROUTINES - OPEN ARTIFACTS FILE
'
' =====================================================================
OPEN.ARTIFACTS:
      OPEN Path$ + "ARTIF.TXT" FOR RANDOM AS #3 LEN = Art.Len
      FIELD 3, AN.Len AS AF.AN$
      DIM AF.AD$(Art.Flds)
      FOR X = 1 TO Art.Flds
      FIELD 3, AN.Len AS X$, (X - 1) * 2 AS X$, 2 AS AF.AD$(X)
      NEXT
' ==========================================================================
'
'                    SUBROUTINES - OPEN MONSTERS FILE
'
' ==========================================================================
OPEN.MONSTERS:
      OPEN Path$ + "MONST.TXT" FOR RANDOM AS #4 LEN = Mon.Len
      FIELD 4, MN.Len AS MF.MN$
      DIM MF.MD$(Mon.Flds)
      FOR X = 1 TO Mon.Flds
      FIELD 4, MN.Len AS X$, (X - 1) * 2 AS X$, 2 AS MF.MD$(X)
      NEXT
' ==========================================================================
'
'                    SUBROUTINES - OPEN DESCRIPTIONS FILE
'
' ==========================================================================
OPEN.DESC:
     OPEN Path$ + "DESC.TXT" FOR RANDOM AS #5 LEN = Desc.Len
     FIELD 5, Desc.Len - 1 AS DF.DESC$, 1 AS X$
OPEN.NAME:
     OPEN Path$ + "EAMON.NAM" FOR INPUT AS #6
     INPUT #6, Filnm$
     INPUT #6, AdvNam$
     CLOSE 6
Main.Menu:
     CLS
     LOCATE , , 0
     PrtCenter "Eamon Dungeon Edit"
     PrtCenter "Version 5.11"
     LOCATE 6, 4: PRINT "Rooms:"; NR; "    Artifacts:"; NA; "   Effects:"; NE; "   Monsters:"; NM
     LOCATE 4, 1
     PrtCenter AdvNam$
     LOCATE 8, 10
     PRINT "1. Add a Room/Artifact/Effect or Monster"
     LOCATE 9, 10
     PRINT "2. Edit a Room/Artifact/Effect/Monster"
     LOCATE 10, 10
     PRINT "3. List Rooms/Artifacts/Effects/Monsters"
     LOCATE 11, 10
     PRINT "4. Insert Artifact into File"
     LOCATE 12, 10
     PRINT "5. Convert U/L Case Names"
     LOCATE 13, 10
     PRINT "6. Generate Dead Bodies"
     LOCATE 14, 10
     PRINT "7. Duplicate a Room/Artifact/Effect or Monster"
     LOCATE 15, 10
     PRINT "8. Control Lights - turn on or off"
     LOCATE 16, 10
     PRINT "9. Return to Designer Menu"
     A$ = ""
     WHILE VAL(A$) < 1 OR VAL(A$) > 9
       A$ = INPUT$(1)
       IF UCASE$(A$) = "L" THEN LOCK.SW = NOT LOCK.SW: LOCATE 3, 30: PRINT MID$("    LOCK", ABS(LOCK.SW) * 4 + 1, 4);
     WEND
     A = VAL(A$)
     ON A GOTO ADD.A.THING, EDIT.A.THING, List.Menu, INSERT.ARTIFACT
     ON A - 4 GOTO CONVERT.CASE, GENERATE.DEAD, DUPLICATE.RTN, Lighting, QUIT.RTN
' ======================================================================
'
'                      ADD A ROOM/ARTIFACT/EFFECT/MONSTER
'
' ======================================================================
ADD.A.THING:
     CMD$ = "ADD"
     GOSUB GET.TYPE.THING
     IF ESC THEN GOTO Main.Menu
     ON RAEM GOTO ADD.A.ROOM, ADD.ARTIFACT, ADD.EFFECT, ADD.MONSTER
' ---------------------------------------------------------------------
'                    ADD A ROOM
' ---------------------------------------------------------------------
ADD.A.ROOM:
     R = NR + 1
     CLS
     PRINT "Adding Room "; R; " ..."
     RN$ = ""
     Desc$ = ""
     FOR D = 1 TO ND + RM.Flds: RD%(D) = 0: NEXT
     GOSUB SHOW.ROOM
     GOSUB Edit.Room
     IF ESC THEN GOTO Main.Menu
     NR = NR + 1
     GOSUB Write.Room
     GOTO Main.Menu
' --------------------------------------------------------------------
'                       ADD AN ARTIFACT
' --------------------------------------------------------------------
ADD.ARTIFACT:
     R = NA + 1
     CLS
     PRINT "Adding Artifact "; R; " ..."
     AN$ = ""
     Desc$ = ""
     FOR D = 1 TO Art.Flds: AD%(D) = 0: NEXT
     GOSUB SHOW.ARTIFACT
     GOSUB EDIT.ARTIFACT
     IF ESC THEN GOTO Main.Menu
     NA = NA + 1
     GOSUB WRITE.ARTIFACT
     GOTO Main.Menu
' -----------------------------------------------------------------------
'                        ADD AN EFFECT
' -----------------------------------------------------------------------
ADD.EFFECT:
     R = NE + 1
     CLS
     PRINT "Adding Effect "; R; " ..."
     Desc$ = ""
     GOSUB SHOW.EFFECT
     GOSUB EDIT.EFFECT
     IF ESC THEN GOTO Main.Menu
     NE = NE + 1
     GOSUB WRITE.EFFECT
     GOTO Main.Menu
' ----------------------------------------------------------------------
'                         ADD A MONSTER
' ----------------------------------------------------------------------
ADD.MONSTER:
     R = NM + 1
     CLS
     PRINT "Adding Monster "; R; " ..."
     MN$ = ""
     Desc$ = ""
     FOR D = 1 TO Mon.Flds: MD%(D) = 0: NEXT
     GOSUB SHOW.MONSTER
     GOSUB EDIT.MONSTER
     IF ESC THEN GOTO Main.Menu
     NM = NM + 1
     GOSUB WRITE.MONSTER
     GOTO Main.Menu
' ======================================================================
'
'                     EDIT A ROOM/ARTIFACT/EFFECT/MONSTER
'
' ======================================================================
EDIT.A.THING:
     CMD$ = "Edit"
     GOSUB GET.TYPE.THING
     IF ESC THEN GOTO Main.Menu
     ON RAEM GOTO UPDATE.ROOM, UPDATE.ARTIFACT, UPDATE.EFFECT, UPDATE.MONSTER
' ----------------------------------------------------------------------
'                     UPDATE A ROOM
' ----------------------------------------------------------------------
UPDATE.ROOM:
     N = NR
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB Read.Room
     CLS
     PRINT "Editing Room "; A
     GOSUB SHOW.ROOM
     GOSUB Edit.Room
     IF ESC THEN GOTO Main.Menu
     GOSUB Write.Room
     GOTO Main.Menu
Lighting:
     CLS
     PrtCenter "Light Control Panel"
     LOCATE 6, 10
     PRINT "Beginning Room:";
     LOCATE 8, 10
     PRINT "Ending Room:";
     LOCATE 10, 10
     PRINT "Turn On or Off:";
     LOCATE 11, 10
     PRINT "(0 = Off / 1 = On)"
     LOCATE 6, 25
     INPUT "", A$
     IF VAL(A$) > NR OR VAL(A$) < 1 THEN A$ = "0"
     A = VAL(A$)
     IF A = 0 THEN GOTO Main.Menu
     beg = A
     LOCATE 8, 23
     INPUT "", A$
     IF VAL(A$) > NR OR VAL(A$) < 1 THEN A$ = "0"
     A = VAL(A$)
     IF A = 0 THEN GOTO Main.Menu
     IF A < beg THEN BEEP: Endg = beg
     Endg = A
     LOCATE 10, 26
     NL$ = ""
     WHILE NL$ <> "0" AND NL$ <> "1"
         NL$ = INPUT$(1)
     WEND
     FOR R = beg TO Endg
         GOSUB Read.Room
         LT = VAL(NL$)
         GOSUB Write.Room
     NEXT
     GOTO Main.Menu
' ----------------------------------------------------------------------
'                     UPDATE AN ARTIFACT
' ----------------------------------------------------------------------
UPDATE.ARTIFACT:
     N = NA
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB READ.ARTIFACT
     CLS
     PRINT "Editing Artifact "; A
     GOSUB SHOW.ARTIFACT
     GOSUB EDIT.ARTIFACT
     IF ESC THEN GOTO Main.Menu
     GOSUB WRITE.ARTIFACT
     GOTO Main.Menu
DECODE.ROOM:
     IF CODED.ROOM < 0 THEN Room = ABS(CODED.ROOM) - 1: RMCD = -1: RETURN
     IF BURY.ADJ < CODED.ROOM THEN Room = CODED.ROOM - BURY.ADJ: RMCD = 4: RETURN
     IF HID.ADJ < CODED.ROOM THEN Room = CODED.ROOM - HID.ADJ: RMCD = 3: RETURN
     IF EMB.ADJ < CODED.ROOM THEN Room = CODED.ROOM - EMB.ADJ: RMCD = 2: RETURN
     IF INS.ADJ < CODED.ROOM THEN Room = CODED.ROOM - INS.ADJ: RMCD = 1: RETURN
     Room = CODED.ROOM
     RMCD = 0
     RETURN
' ----------------------------------------------------------------------
'                     UPDATE AN EFFECT
' ----------------------------------------------------------------------
UPDATE.EFFECT:
     N = NE
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB READ.EFFECT
     CLS
     PRINT "Editing Effect "; A
     GOSUB SHOW.EFFECT
     GOSUB EDIT.EFFECT
     IF ESC THEN GOTO Main.Menu
     GOSUB WRITE.EFFECT
     GOTO Main.Menu
' ----------------------------------------------------------------------
'                     UPDATE A MONSTER
' ----------------------------------------------------------------------
UPDATE.MONSTER:
     N = NM
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB READ.MONSTER
     CLS
     PRINT "Editing Monster "; A
     GOSUB SHOW.MONSTER
     GOSUB EDIT.MONSTER
     IF ESC THEN GOTO Main.Menu
     GOSUB WRITE.MONSTER
     GOTO Main.Menu
' -------------------------------------------------------------------
'                      EDIT A ROOM
' -------------------------------------------------------------------
Edit.Room:
     LOCATE 3, 1
     Df$ = RN$
     TEXTIO I$, Df$, Bk
     IF Bk = -1 THEN GOTO Edit.Room
     IF Bk = -2 THEN RETURN
     IF LEN(I$) > Rmn.Len THEN
         Df$ = I$
         BEEP
         LOCATE 24, 30
         PRINT "Too Long !!";
         GOSUB PRESS.ANY.KEY
         GOTO Edit.Room
     END IF
     RN$ = I$
Edit.Room.Desc:
     LOCATE 5, 1
     Df$ = Desc$
     TEXTIO I$, Df$, Bk
     IF Bk = -1 THEN GOTO Edit.Room
     IF Bk = -2 THEN RETURN
     IF LEN(I$) > Desc.Len THEN
         BEEP
         Df$ = I$
         LOCATE 24, 30
         PRINT "Too Long !!";
         GOSUB PRESS.ANY.KEY
         GOTO Edit.Room.Desc
     END IF
     Desc$ = I$
     D = 1
Edit.Room.Data:
     LOCATE 25, 2
     COLOR hfg%, hbg%
     PRINT " F1 - Gate / Door ";
     LOCATE 25, 32
     PRINT " F2 - Secret Passage ";
     LOCATE 25, 56
     PRINT " F3 - Exit Home ";
     COLOR fgc%, bgc%
     LOCATE 10 + D - ND * ABS(D > ND), 12 + 40 * ABS(D > ND)
     Bk = 3
     NumericIo "I3", RD%(D), I.Num, Bk
     IF Bk = -3 THEN
         D = D + 1
         IF D > ND THEN GOTO Edit.Rm.Lt
         GOTO Edit.Room.Data
     END IF
     IF Bk = -2 THEN RETURN
     IF Bk = -1 THEN
         D = D - 1
         IF D < 1 THEN GOTO Edit.Room.Desc
         GOTO Edit.Room.Data
     END IF
     IF Bk = 1 THEN Room = I.Num + Max.Rm
     IF Bk = 2 THEN Room = -I.Num
     IF Bk = 3 THEN Room = Exit.Bye
     IF Bk = 0 THEN
         RD%(D) = I.Num
     ELSE
         RD%(D) = Room
     END IF
     LOCATE 10 + D, 12
     PRINT USING "###"; RD%(D)
     D = D + 1
     IF D <= ND + RM.Flds THEN GOTO Edit.Room.Data
Edit.Rm.Lt:
     LOCATE 25, 1
     COLOR fgc%, bgc%
     PRINT SPC(79);
     LOCATE 25, 1
     COLOR hfg%, hbg%
     PRINT " L - Natural Light in the room ";
     LOCATE 25, 40
     PRINT " D - Room is not lit ";
     COLOR fgc%, bgc%
     LOCATE 22, 20
     L$ = INPUT$(1)
     L$ = UCASE$(L$)
     IF L$ = CHR$(13) THEN L$ = MID$("DL", LT + 1, 1)
     IF L$ <> "L" AND L$ <> "D" THEN BEEP: GOTO Edit.Rm.Lt
     LOCATE 22, 20
     PRINT L$
     LOCATE 25, 1
     PRINT SPC(79);
     IF L$ = "L" THEN LT = 1 ELSE LT = 0
     RETURN
' -------------------------------------------------------------------
'                      EDIT AN ARTIFACT
' -------------------------------------------------------------------
EDIT.ARTIFACT:
     LOCATE 3, 1
     Df$ = AN$
     TEXTIO I$, Df$, Bk
     IF Bk = -2 THEN RETURN
     IF LEN(I$) > AN.Len THEN
         BEEP
         LOCATE 24, 30
         PRINT "Too Long !!";
         GOSUB PRESS.ANY.KEY
         GOTO EDIT.ARTIFACT
     END IF
     AN$ = I$
EDIT.ART.DESC:
     LOCATE 5, 1
     Df$ = Desc$
     TEXTIO I$, Df$, Bk
     IF Bk = -1 THEN GOTO EDIT.ARTIFACT
     IF Bk = -2 THEN RETURN
     IF LEN(I$) > Desc.Len THEN
         BEEP
         LOCATE 24, 30
         PRINT "Too Long !!";
         GOSUB PRESS.ANY.KEY
         GOTO EDIT.ART.DESC
     END IF
     Desc$ = I$
     D = 1
EDIT.ART.DATA:
     IF D = 2 THEN GOSUB SHOW.ART.TYPES
     IF D = 4 THEN
         LOCATE 25, 2
         COLOR hfg%, hbg%
         PRINT " F1-Inside ";
         LOCATE 25, 16
         PRINT " F2-Embedded ";
         LOCATE 25, 32
         PRINT " F3-Hidden ";
         LOCATE 25, 46
         PRINT " F4-Carried ";
         LOCATE 25, 61
         PRINT " F5-Buried ";
         COLOR fgc%, bgc%
         CODED.ROOM = AD%(D)
         GOSUB DECODE.ROOM
         Df = Room
         Df.Pf = RMCD
         Bk = 5
     ELSE
         Df = AD%(D)
         Df.Pf = 0
         Bk = 0
     END IF
     LOCATE 10 + D, 27
     NumericIo "I5", Df, I.Num, Bk
     IF Bk = -2 THEN RETURN
     IF D = 4 AND Bk = -3 THEN Bk = Df.Pf: I.Num = Room
     IF D = 4 THEN
        Room = I.Num
        IF Bk = 1 THEN Room = I.Num + INS.ADJ
        IF Bk = 2 THEN Room = I.Num + EMB.ADJ
        IF Bk = 3 THEN Room = I.Num + HID.ADJ
        IF Bk = 4 THEN Room = -I.Num - 1
        IF Bk = 5 THEN Room = I.Num + BURY.ADJ
        LOCATE 25, 1
        PRINT SPC(79);
        I.Num = Room
     END IF
     IF D = 2 THEN GOSUB ERASE.ART.TYPES: IF AD%(D) <> I.Num THEN AD%(D) = I.Num: GOSUB SHOW.ARTIFACT
     IF Bk = -1 THEN D = D - 1: IF D < 1 THEN GOTO EDIT.ART.DESC ELSE GOTO EDIT.ART.DATA
     AD%(D) = I.Num
     D = D + 1
     IF D <= Art.Flds THEN GOTO EDIT.ART.DATA
     RETURN
' -------------------------------------------------------------------
'                      EDIT AN EFFECT
' -------------------------------------------------------------------
EDIT.EFFECT:
     LOCATE 5, 1
     Df$ = Desc$
     TEXTIO I$, Df$, Bk
     IF Bk = -2 THEN RETURN
     IF LEN(I$) > Desc.Len THEN
         BEEP
         LOCATE 24, 30
         PRINT "Too Long !!";
         GOSUB PRESS.ANY.KEY
         GOTO EDIT.EFFECT
     END IF
     Desc$ = I$
     RETURN
' -------------------------------------------------------------------
'                      EDIT A MONSTER
' -------------------------------------------------------------------
EDIT.MONSTER:
     LOCATE 3, 1
     Df$ = MN$
     TEXTIO I$, Df$, Bk
     IF Bk = -2 THEN RETURN
     IF LEN(I$) > MN.Len THEN
         BEEP
         LOCATE 24, 30
         PRINT "Too Long!!";
         GOSUB PRESS.ANY.KEY
         GOTO EDIT.MONSTER
     END IF
     MN$ = I$
GET.MON.DESC:
     LOCATE 5, 1
     Df$ = Desc$
     TEXTIO I$, Df$, Bk
     IF Bk = -1 THEN GOTO EDIT.MONSTER
     IF Bk = -2 THEN RETURN
     Desc$ = I$
     D = 1
GET.MON.DATA:
     IF D = 5 THEN
         LOCATE 25, 2
         COLOR hfg%, hbg%
         PRINT " F1-Inside ";
         LOCATE 25, 16
         PRINT " F2-Embedded ";
         LOCATE 25, 32
         PRINT " F3-Hidden ";
         LOCATE 25, 46
         PRINT " F4-Carried ";
         LOCATE 25, 61
         PRINT " F5-Buried ";
         COLOR fgc%, bgc%
         CODED.ROOM = MD%(D)
         GOSUB DECODE.ROOM
         Df.Pf = RMCD
         Df = Room
         Bk = 5
     ELSE
         Df = MD%(D)
         Df.Pf = 0
         Bk = 0
     END IF
     V = (D - 1) MOD 12
     LOCATE 11 + V, 12 + INT((D - 1) / 12) * 22
     Fmt$ = "I4"
     NumericIo "I4", Df, I.Num, Bk
     IF Bk = -3 AND D = 5 THEN Bk = Df.Pf: I.Num = Df
     IF Bk = -1 THEN
         D = D - 1
         IF D < 1 THEN GOTO GET.MON.DESC ELSE GOTO GET.MON.DATA
     END IF
     IF D = 5 THEN
        Room = I.Num
        IF Bk = 1 THEN Room = I.Num + INS.ADJ
        IF Bk = 2 THEN Room = I.Num + EMB.ADJ
        IF Bk = 3 THEN Room = I.Num + HID.ADJ
        IF Bk = 4 THEN Room = -I.Num - 1
        IF Bk = 5 THEN Room = I.Num + BURY.ADJ
        LOCATE 25, 1
        PRINT SPC(79);
        I.Num = Room
     END IF
     MD%(D) = I.Num
     D = D + 1
     IF D <= Mon.Flds THEN GOTO GET.MON.DATA
     RETURN
' ======================================================================
'
'                        LIST ROUTINE
'
' ======================================================================
List.Menu:
     CLS
     LOCATE , , 0
     PRINT SPC(20); "Eamon-QB Dungeon Edit"
     LOCATE 2, 26: PRINT "Version 4.12"
     LOCATE 3, 26: PRINT "List Options"
     IF PrtSw THEN LOCATE 6, 18: PRINT "To File:"; Filenam$
     LOCATE 10, 10: PRINT "1. List Names of Rooms/Artif/Eff/Monsters"
     LOCATE 12, 10: PRINT "2. Full Display of a Room/Artif/Eff/Monster"
     LOCATE 14, 10: PRINT "3. Full List w/ Update Ability"
     LOCATE 16, 10: PRINT "4. Send Output to printer/file"
     LOCATE 18, 10: PRINT "5. Return to Main Menu"
     A$ = ""
     WHILE VAL(A$) < 1 OR VAL(A$) > 5
       A$ = INPUT$(1)
     WEND
     ON VAL(A$) GOTO LIST.NAMES.THINGS, DISPLAY.A.THING, FULL.VIEW, PrintFile, Main.Menu
PrintFile:
     CLS
     IF PrtSw THEN PrtSw = 0: CLOSE 6: GOTO List.Menu
     LOCATE 6, 10
     INPUT "File Name:", Filenam$
     PrtSw = -1
     OPEN Filenam$ FOR OUTPUT AS #6
     GOTO List.Menu
' -------------------------------------------------------------------
'                       LIST NAMES OF THINGS
' -------------------------------------------------------------------

LIST.NAMES.THINGS:
     CMD$ = "LIST"
     GOSUB GET.TYPE.THING
     IF ESC THEN GOTO Main.Menu
     ON RAEM GOTO LIST.ROOM.NAMES, LIST.ART.NAMES, LIST.EFFECTS, LIST.MON.NAMES
LIST.ROOM.NAMES:
     CLS
     Max = NR
     PG.CNT = 1
     TOP.NO%(PG.CNT) = 1
     FOR R = 1 TO Max
     GET #2, R
     RN$ = RNF.RN$
     IF PrtSw THEN
        PRINT #6, USING "###. "; R;
        PRINT #6, RN$
    ELSE
        PRINT USING "###. "; R;
        PRINT RN$
    END IF
     IF CSRLIN > 22 THEN GOSUB PAGE.LIST
     NEXT
     UP = 0
     GOSUB PRESS.ANY.KEY
     GOTO Main.Menu
LIST.ART.NAMES:  REM === LIST ARTIFACTS
     CLS
     Max = NA
     PG.CNT = 1
     TOP.NO%(PG.CNT) = 1
     FOR R = 1 TO NA
     GET #3, R
     AN$ = AF.AN$
     IF PrtSw THEN
         PRINT #6, USING "###. "; R;
         PRINT #6, AN$
     ELSE
         PRINT USING "###. "; R;
         PRINT AN$
     END IF
     IF CSRLIN > 22 THEN GOSUB PAGE.LIST
     NEXT
     UP = 0
     GOSUB PRESS.ANY.KEY
     GOTO Main.Menu
LIST.EFFECTS:  REM === LIST EFFECTS
     CLS
     Max = NE
     PG.CNT = 1
     TOP.NO%(PG.CNT) = 1
     FOR R = 1 TO Max
     GET #5, R + Max.Rm + Max.Art
     Desc$ = DF.DESC$
     IF PrtSw THEN
        PRINT #6, STRING$(32, "-"); " Effect "; R; " "; STRING$(32, "-")
        FOR X = 1 TO LEN(Desc$) STEP 80
            PRINT #6, MID$(Desc$, X, 80)
        NEXT

     ELSE
        PRINT STRING$(32, "-"); " Effect "; R; " "; STRING$(32, "-")
        PRINT Desc$
     END IF
     IF CSRLIN >= 20 THEN
         GOSUB PAGE.LIST
     END IF
     NEXT
     UP = 0
     GOSUB PRESS.ANY.KEY
     GOTO Main.Menu
LIST.MON.NAMES:   REM === LIST MONSTERS
     CLS
     Max = NM
     PG.CNT = 1
     TOP.NO%(PG.CNT) = 1
     FOR R = 1 TO NM
     GET #4, R
     MN$ = MF.MN$
     IF PrtSw THEN
         PRINT #6, USING "###. "; R;
         PRINT #6, MN$
     ELSE
         PRINT USING "###. "; R;
         PRINT MN$
     END IF
     IF CSRLIN > 22 THEN GOSUB PAGE.LIST
     NEXT
     UP = 0
     GOSUB PRESS.ANY.KEY
     GOTO Main.Menu
PAGE.LIST:
     UP = 0
     Bk = -1
     GOSUB PRESS.ANY.KEY
     CLS
     IF BK.UP THEN
         PG.CNT = PG.CNT - 1
         IF PG.CNT < 1 THEN PG.CNT = 1
         R = TOP.NO%(PG.CNT) - 1
     ELSE
         PG.CNT = PG.CNT + 1
         TOP.NO%(PG.CNT) = R + 1
     END IF
     IF ESC THEN R = Max
     IF NO. > 0 THEN R = NO. - 1
     RETURN
' ----------------------------------------------------------------------
'                      DISPLAY A SINGLE RECORD
' ----------------------------------------------------------------------
DISPLAY.A.THING:
     CMD$ = "Display"
     GOSUB GET.TYPE.THING
     IF ESC THEN GOTO Main.Menu
     ON RAEM GOTO DISPLAY.ROOM, DISPLAY.ARTIFACT, DISPLAY.EFFECT, DISPLAY.MONSTER
DISPLAY.ROOM:  REM === Display ROOM ===
     N = NR
     GOSUB GET.ITEM.NBR
     R = A
DIS.A.ROOM:
     IF R = 0 THEN GOTO Main.Menu
     GOSUB Read.Room
     CLS
     PRINT "Display of Room "; R
     GOSUB SHOW.ROOM
     UP = -1
     Bk = -1
     GOSUB PRESS.ANY.KEY
     IF UPD THEN GOSUB Edit.Room: GOSUB Write.Room
     IF NO. > 0 THEN
         R = NO.
         IF R > NR THEN R = NR
         GOTO DIS.A.ROOM
     END IF
     IF BK.UP THEN R = R - 1: IF R >= 1 THEN GOTO DIS.A.ROOM
     GOTO Main.Menu
DISPLAY.ARTIFACT: REM ======Display ARTIFACT ======
     N = NA
     GOSUB GET.ITEM.NBR
     R = A
DIS.AN.ART:
     IF R = 0 THEN GOTO Main.Menu
     GOSUB READ.ARTIFACT
     CLS
     PRINT "Display of Artifact "; R
     GOSUB SHOW.ARTIFACT
     UP = -1
     Bk = -1
     GOSUB PRESS.ANY.KEY
     IF UPD THEN GOSUB EDIT.ARTIFACT: GOSUB WRITE.ARTIFACT
     IF NO. > 0 THEN
         R = NO.
         IF R > NA THEN R = NA
         GOTO DIS.AN.ART
     END IF
     IF BK.UP THEN R = R - 1: IF R >= 1 THEN GOTO DIS.AN.ART
     GOTO Main.Menu
DISPLAY.EFFECT:  REM ====== Display AN EFFECT ======
     N = NE
     GOSUB GET.ITEM.NBR
     R = A
DIS.AN.EFF:
     IF R = 0 THEN GOTO Main.Menu
     GOSUB READ.EFFECT
     CLS
     PRINT "Display of Effect "; R
     GOSUB SHOW.EFFECT
     UP = -1
     Bk = -1
     GOSUB PRESS.ANY.KEY
     IF UPD THEN GOSUB EDIT.EFFECT: GOSUB WRITE.EFFECT
     IF NO. > 0 THEN
         R = NO.
         IF R > NE THEN R = NE
         GOTO DIS.AN.EFF
     END IF
     IF BK.UP THEN
         R = R - 1
         IF R >= 1 THEN GOTO DIS.AN.EFF
     END IF
     GOTO Main.Menu
DISPLAY.MONSTER:   REM ====== Display A MONSTER ======
     N = NM
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
DIS.A.MON:
     GOSUB READ.MONSTER
     CLS
     PRINT "Display of Monster "; R
     GOSUB SHOW.MONSTER
     UP = -1
     Bk = -1
     GOSUB PRESS.ANY.KEY
     IF UPD THEN GOSUB EDIT.MONSTER: GOSUB WRITE.MONSTER
     IF NO. > 0 THEN
         R = NO.
         IF R > NM THEN R = NM
         GOTO DIS.A.MON
     END IF
     IF BK.UP THEN R = R - 1: IF R >= 1 THEN GOTO DIS.A.MON
     GOTO Main.Menu
' ----------------------------------------------------------------------
'                   VIEW ALL OF A TYPE OR EVERYTHING
' ----------------------------------------------------------------------
FULL.VIEW:
     CLS
     LOCATE 4, 1
     PRINT "Do you want a full display of Rooms, Artifacts, or Monsters"
     PRINT "   Key in R for rooms, A for artifacts, M for Monsters or E for Everyhing"
     A$ = ""
     WHILE A$ <> "R" AND A$ <> "A" AND A$ <> "E" AND A$ <> "M"
       A$ = INKEY$
       A$ = UCASE$(A$)
     WEND
     IF A$ = "R" THEN GOTO VIEW.ROOM
     IF A$ = "A" THEN GOTO VIEW.ARTIFACT
     IF A$ = "E" THEN GOTO VIEW.EVERYTHING
     IF A$ = "M" THEN GOTO VIEW.MONSTER
VIEW.ROOM:  ' === display all rooms ===
     FOR R = 1 TO NR
       GOSUB Read.Room
       CLS
       PRINT "Display of Room "; R
       GOSUB SHOW.ROOM
       UP = -1
       Bk = -1
       GOSUB PRESS.ANY.KEY
       IF UPD THEN GOSUB Edit.Room: GOSUB Write.Room
       IF ESC THEN R = NR
       IF NO. > 0 THEN R = NO. - 1
       IF BK.UP THEN R = R - 2: IF R < 0 THEN R = 0
     NEXT
     GOTO Main.Menu
VIEW.ARTIFACT:  ' ====== DISPLAY ARTIFACTS ======
     FOR R = 1 TO NA
       GOSUB READ.ARTIFACT
       CLS
       PRINT "Display of Artifact "; R
       GOSUB SHOW.ARTIFACT
       UP = -1
       Bk = -1
       GOSUB PRESS.ANY.KEY
       IF UPD THEN GOSUB EDIT.ARTIFACT: GOSUB WRITE.ARTIFACT
       IF ESC THEN R = NA
       IF NO. > 0 THEN R = NO. - 1
       IF BK.UP THEN R = R - 2: IF R < 0 THEN R = 0
     NEXT
     GOTO Main.Menu
VIEW.MONSTER:  ' ====== DISPLAY MONSTERS ======
     FOR R = 1 TO NM
       GOSUB READ.MONSTER
       CLS
       PRINT "Display of Monster "; R
       GOSUB SHOW.MONSTER
       UP = -1
       Bk = -1
       GOSUB PRESS.ANY.KEY
       IF UPD THEN GOSUB EDIT.MONSTER: GOSUB WRITE.MONSTER
       IF ESC THEN R = NM
       IF NO. > 0 THEN R = NO. - 1
       IF BK.UP THEN R = R - 2: IF R < 0 THEN R = 0
     NEXT
     GOTO Main.Menu
VIEW.EVERYTHING:  ' ====== DISPLAY ALL ======
     FOR R = 1 TO NR
       GOSUB Read.Room
       CLS
       PRINT "Display of Room "; R
       GOSUB SHOW.ROOM
       UP = -1
       Bk = -1
       GOSUB PRESS.ANY.KEY
       IF UPD THEN GOSUB Edit.Room: GOSUB Write.Room
       IF ESC THEN R = NR
       IF NO. > 0 THEN R = NO. - 1: IF R > NR THEN R = NR - 1
       IF BK.UP THEN R = R - 2: IF R < 0 THEN R = 0
     NEXT
     FOR R = 1 TO NA
       GOSUB READ.ARTIFACT
       CLS
       PRINT "Display of Artifact "; R
       GOSUB SHOW.ARTIFACT
       UP = -1
       Bk = -1
       GOSUB PRESS.ANY.KEY
       IF UPD THEN GOSUB EDIT.ARTIFACT: GOSUB WRITE.ARTIFACT
       IF ESC THEN R = NA
       IF NO. > 0 THEN R = NO. - 1: IF R > NA THEN R = NA - 1
       IF BK.UP THEN R = R - 2: IF R < 0 THEN R = 0
     NEXT
     FOR R = 1 TO NM
       GOSUB READ.MONSTER
       CLS
       PRINT "Display of Monster "; R
       GOSUB SHOW.MONSTER
       UP = -1
       Bk = -1
       GOSUB PRESS.ANY.KEY
       IF UPD THEN GOSUB EDIT.MONSTER: GOSUB WRITE.MONSTER
       IF ESC THEN R = NM
       IF NO. > 0 THEN R = NO. - 1: IF R > NM THEN R = NM - 1
       IF BK.UP THEN R = R - 2: IF R < 0 THEN R = 0
     NEXT
     GOTO Main.Menu
' ======================================================================
'
'                       INSERT AN ARTIFACT
'
' ======================================================================
INSERT.ARTIFACT:
     CLS
     LOCATE 6, 1
     N = NA
     GOSUB GET.AFTER.NBR
     AFTER = A + 1
     IF A = 0 THEN GOTO Main.Menu
     IF A = NA THEN GOTO ADD.ARTIFACT
     LOCATE 8, 10
     PRINT "Number of Artifacts to insert: ";
     INPUT "", A$
     IF VAL(A$) < 1 THEN A = 0: GOTO Main.Menu
     INO = VAL(A$)
     FOR IR = NA TO AFTER STEP -1
       R = IR
       GOSUB READ.ARTIFACT
       R = R + INO
       GOSUB WRITE.ARTIFACT
     NEXT
     NA = NA + INO
     R = AFTER
     CLS
     PRINT "Insert New Artifact "; R; " ..."
     AN$ = ""
     Desc$ = ""
     FOR D = 1 TO Art.Flds: AD%(D) = 0: NEXT
     GOSUB SHOW.ARTIFACT
     GOSUB EDIT.ARTIFACT
     IF ESC THEN GOTO Main.Menu
     GOSUB WRITE.ARTIFACT
     GOTO Main.Menu
' ======================================================================
'
'                    GENERATE DEAD BODIES FOR MONSTERS
'
' ======================================================================
GENERATE.DEAD:
     CLS
     LOCATE 6, 10
     FOR MR = 1 TO NM
       R = MR
       GOSUB READ.MONSTER
       AN$ = "dead body of " + MN$
       AD%(1) = 0
       AD%(2) = 1
       AD%(3) = MD%(6)
       AD%(4) = 0
       AD%(5) = 0
       AD%(6) = 0
       AD%(7) = 0
       AD%(8) = 0
       Desc$ = "You see the dead body of " + MN$ + "."
       R = MR + NA
       GOSUB WRITE.ARTIFACT
     NEXT
     GOTO Main.Menu
' ======================================================================
'
'                  DUPLICATE A ROOM/ARTIFACT/EFFECT/MONSTER
'
' ======================================================================
DUPLICATE.RTN:
     CMD$ = "Duplicate"
     GOSUB GET.TYPE.THING
     IF ESC THEN GOTO Main.Menu
     ON RAEM GOTO DUPLICATE.ROOM, DUPLICATE.ARTIFACT, DUPLICATE.EFFECT, DUPLICATE.MONSTER
' ----------------------------------------------------------------------
'                    DUPLICATE A ROOM
' ----------------------------------------------------------------------
DUPLICATE.ROOM:
     N = NR
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB Read.Room
     R = NR + 1
     CLS
     PRINT "Duplicating Room "; A; " / Adding as "; R
     GOSUB SHOW.ROOM
     GOSUB Edit.Room
     IF ESC THEN GOTO Main.Menu
     NR = NR + 1
     GOSUB Write.Room
     GOTO Main.Menu
' ----------------------------------------------------------------------
'                     DUPLICATE AN ARTIFACT
' ----------------------------------------------------------------------
DUPLICATE.ARTIFACT:
     N = NA
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB READ.ARTIFACT
     R = NA + 1
     CLS
     PRINT "Duplicating Artifact "; A; " / Adding as "; R
     GOSUB SHOW.ARTIFACT
     GOSUB EDIT.ARTIFACT
     IF ESC THEN GOTO Main.Menu
     GOSUB WRITE.ARTIFACT
     NA = NA + 1
     GOTO Main.Menu
' ----------------------------------------------------------------------
'                     DUPLICATE AN EFFECT
' ----------------------------------------------------------------------
DUPLICATE.EFFECT:
     N = NE
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB READ.EFFECT
     R = NE + 1
     CLS
     PRINT "Duplicating Effect "; A; " / Adding as "; R
     GOSUB SHOW.EFFECT
     GOSUB EDIT.EFFECT
     IF ESC THEN GOTO Main.Menu
     GOSUB WRITE.EFFECT
     NE = NE + 1
     GOTO Main.Menu
Pick.Monster:
     OPEN MonstMast$ FOR RANDOM AS #8 LEN = 128
' ----------------------------------------------------------------------
'                     DUPLICATE A MONSTER
' ----------------------------------------------------------------------
DUPLICATE.MONSTER:
     N = NM
     GOSUB GET.ITEM.NBR
     IF A = 0 THEN GOTO Main.Menu
     R = A
     GOSUB READ.MONSTER
     R = NM + 1
     CLS
     PRINT "Duplicating Monster "; A; " / Adding as "; R
     GOSUB SHOW.MONSTER
     GOSUB EDIT.MONSTER
     IF ESC THEN GOTO Main.Menu
     GOSUB WRITE.MONSTER
     GOTO Main.Menu
' ======================================================================
'
'                       CONVERT CASE OF NAMES
'
' ======================================================================
CONVERT.CASE:
     CMD$ = "Convert"
     GOSUB GET.TYPE.THING
     IF ESC THEN GOTO Main.Menu
     ON RAEM GOTO CONVERT.ROOM, CONVERT.ARTIFACT, CONVERT.DESC, CONVERT.MONSTER
CONVERT.ROOM:
     CLS
     LOCATE 6, 10
     PRINT "Room: ";
     FOR R = 1 TO NR
     LOCATE 6, 16
     PRINT USING "###"; R
     GOSUB Read.Room
     RN$ = LCASE$(RN$)
     GOSUB Write.Room
     NEXT
     GOTO Main.Menu
CONVERT.ARTIFACT:
     CLS
     LOCATE 6, 1
     PRINT "Artifact:";
     FOR R = 1 TO NA
     LOCATE 6, 20
     PRINT USING "###"; R
     GOSUB READ.ARTIFACT
     AN$ = LCASE$(AN$)
     GOSUB WRITE.ARTIFACT
     NEXT
     GOTO Main.Menu
CONVERT.MONSTER:
    CLS
    LOCATE 6, 1
    PRINT "Monster:";
    FOR R = 1 TO NM
    LOCATE 6, 20
    PRINT USING "###"; R
    GOSUB READ.MONSTER
    MN$ = UCASE$(LEFT$(MN$, 1)) + LCASE$(MID$(MN$, 2))
    GOSUB WRITE.MONSTER
    NEXT
    GOTO Main.Menu
CONVERT.DESC:
    CLS
    LOCATE 6, 10
    PRINT "Room Description:";
    RAEM = 1
    FOR R = 1 TO NR
    LOCATE 6, 32
    PRINT USING "###"; R;
    GOSUB READ.DESC
    LOCATE 15, 1
    PRINT Desc$ + SPACE$(255)
    GOSUB PROCESS.DESC
    GOSUB SPACE.DESC
    LOCATE 15, 1
    PRINT Desc$
    GOSUB WRITE.DESC
    NEXT
    RAEM = 2
    LOCATE 8, 10
    PRINT "Artifact Description:";
    FOR R = 1 TO NA
    LOCATE 8, 32
    PRINT USING "###"; R;
    GOSUB READ.DESC
    LOCATE 15, 1
    PRINT Desc$ + SPACE$(255)
    GOSUB PROCESS.DESC
    GOSUB SPACE.DESC
    LOCATE 15, 1
    PRINT Desc$
    GOSUB WRITE.DESC
    NEXT
    RAEM = 3
    LOCATE 10, 10
    PRINT "Effect:"
    IF NE = 0 THEN LOCATE 10, 28: PRINT "(None)";
    FOR R = 1 TO NE
    LOCATE 10, 32
    PRINT USING "###"; R;
    GOSUB READ.DESC
    LOCATE 15, 1
    PRINT Desc$ + SPACE$(255);
    GOSUB PROCESS.DESC
    GOSUB SPACE.DESC
    LOCATE 15, 1
    PRINT Desc$
    GOSUB WRITE.DESC
    NEXT
    RAEM = 4
    LOCATE 12, 10
    PRINT "Monster Description:";
    FOR R = 1 TO NM
    LOCATE 12, 32
    PRINT USING "###"; R;
    GOSUB READ.DESC
    LOCATE 15, 1
    PRINT Desc$ + SPACE$(255)
    GOSUB PROCESS.DESC
    GOSUB SPACE.DESC
    LOCATE 15, 1
    PRINT Desc$
    GOSUB WRITE.DESC
    NEXT
    GOTO Main.Menu
PROCESS.DESC:
    N = 1
    Desc$ = LCASE$(Desc$)
    MID$(Desc$, 1, 1) = UCASE$(MID$(Desc$, 1, 1))
FIND.PER:
    PF = INSTR(N, Desc$, ".")
    XF = INSTR(N, Desc$, "!")
    QF = INSTR(N, Desc$, "?")
    IF PF = 0 AND XF = 0 AND QF = 0 THEN Desc$ = Desc$ + ".": GOTO FIND.PER
    IF PF > 0 THEN P = PF ELSE P = LEN(Desc$)
    IF XF > 0 AND XF < P THEN P = XF
    IF QF > 0 AND QF < P THEN P = QF
    IF P > 0 THEN N = P + 1
    IF N >= LEN(Desc$) THEN RETURN
    WHILE (MID$(Desc$, N, 1) < "a" OR MID$(Desc$, N, 1) > "z") AND N <= LEN(Desc$)
        N = N + 1
    WEND
    IF N >= LEN(Desc$) THEN RETURN
    MID$(Desc$, N, 1) = UCASE$(MID$(Desc$, N, 1))
    GOTO FIND.PER
SPACE.DESC:
    ABD = 0
    FOR X = 40 TO LEN(Desc$) STEP 40
         IF MID$(Desc$, X, 1) <> " " THEN
            Desc$ = LEFT$(Desc$, X + ABD) + " " + MID$(Desc$, X + 1 + ABD)
            ABD = ABD + 1
         END IF
    NEXT
    RETURN
' ======================================================================
'
'                       QUIT ROUTINE
'
' ======================================================================
QUIT.RTN:
     CLOSE
     GOSUB UPDATE.CNTS
     CHDIR "\Eamon"
     RUN "DDD\DUNGMENU"
' =====================================================================
'
'                  SUBROUTINES - GET WHAT TYPE OF THING (R/A/E/M)
'
' =====================================================================
GET.TYPE.THING:
     CLS
     ESC = 0
     LOCATE 6, 5
     PRINT "Do you want to "; CMD$; " Rooms, Artifacts, Effects or Monsters"
     A$ = ""
     WHILE A$ <> "R" AND A$ <> "A" AND A$ <> "E" AND A$ <> "M" AND A$ <> CHR$(27)
       A$ = INKEY$
       A$ = UCASE$(A$)
     WEND
     IF A$ = "R" THEN RAEM = 1: PRINT A$: RETURN
     IF A$ = "A" THEN RAEM = 2: PRINT A$: RETURN
     IF A$ = "E" THEN RAEM = 3: PRINT A$: RETURN
     IF A$ = "M" THEN RAEM = 4: PRINT A$: RETURN
     IF A$ = CHR$(27) THEN ESC = -1: RETURN
     GOTO Main.Menu
' =====================================================================
'
'                  SUBROUTINES - GET NUMBER OF THING
'
' =====================================================================
GET.ITEM.NBR:
     CLS
     LOCATE 6, 10
     PRINT "Enter number of item to work on (1-"; N; "): ";
     INPUT "", A$
     IF VAL(A$) > N OR VAL(A$) < 1 THEN A = 0: RETURN
     A = VAL(A$)
     RETURN
' =====================================================================
'
'                  SUBROUTINES - GET NUMBER OF INSERT
'
' =====================================================================
GET.AFTER.NBR:
     CLS
     LOCATE 6, 10
     PRINT "Enter number to insert after (1-"; N; "): ";
     INPUT "", A$
     IF VAL(A$) > N OR VAL(A$) < 1 THEN A = 0: RETURN
     A = VAL(A$)
     RETURN
' =====================================================================
'
'                  SUBROUTINES - DISPLAY A ROOM'S DATA
'
' =====================================================================
SHOW.ROOM:
      LOCATE 3, 1
      PRINT RN$
      LOCATE 5, 1
      PRINT Desc$
      LOCATE 10, 1
      PRINT "Directions:"
      FOR D = 1 TO ND
          LOCATE 10 + D, 1
          PRINT Dirct$(D);
          LOCATE 10 + D, 12
          PRINT USING "###"; RD%(D);
          X = RD%(D)
          SELECT CASE X
            CASE 0
            CASE 1 TO NR
              GET #2, RD%(D)
              RTo$ = RTRIM$(RNF.RN$)
              PRINT "    ["; RTo$; "]"
            CASE Exit.Bye
              PRINT "    [Exit to Main Hall]"
            CASE IS < 0
               PRINT "    [Secret Passage to ";
               GET #2, ABS(RD%(D))
               RTo$ = RTRIM$(RNF.RN$)
               PRINT RTo$; "]"
             CASE -(NR + 1) TO -Max.Rm
                PRINT "    [Secret Passage to *undefined* ]"
             CASE NR + 1 TO Max.Rm
                PRINT "    [*undefined*]"
             CASE Max.Rm + 1 TO Max.Rm + NA
               GET #3, RD%(D) - Max.Rm
               Door$ = RTRIM$(AF.AN$)
               PRINT "    [Behind "; Door$; "]"
           CASE ELSE
           END SELECT
      NEXT
      FOR D = 1 TO RM.Flds
        LOCATE 10 + D, 41
        PRINT Dirct$(D + ND);
        LOCATE 10 + D, 52
        PRINT USING "###"; RD%(ND + D)
      NEXT
      LOCATE 22, 1
      PRINT "Light / Dark ";
      LOCATE 22, 20
      IF LT = 1 THEN PRINT "L";  ELSE PRINT "D";
      RETURN
' =====================================================================
'
'                  SUBROUTINES - DISPLAY AN ARTIFACT'S DATA
'
' =====================================================================
SHOW.ARTIFACT:
      GOSUB SETUP.LABELS
      LOCATE 3, 1
      PRINT AN$
      LOCATE 5, 1
      PRINT Desc$
      LOCATE 10, 1
      PRINT "Artifact Data:"
      FOR A1 = 1 TO Art.Flds
      IF A1 = 4 THEN
          LBL$ = Art$(A1)
          CODED.ROOM = AD%(A1)
          GOSUB ROOM.CODE
          LOCATE 10 + A1, 1
          PRINT LBL$;
          LOCATE 10 + A1, 27
          PRINT USING "##,###"; Room;
          GOSUB SHOW.EXPROOM
      ELSE
          LOCATE 10 + A1, 1
          PRINT Art$(A1);
          LOCATE 10 + A1, 27
          PRINT USING "##,###"; AD%(A1)
      END IF
      IF A1 = 2 THEN
          IF AD%(A1) >= 0 AND AD%(A1) <= AD.ART.TYPES THEN
              LOCATE 10 + A1, 10
              PRINT A.TYP$(AD%(A1)) + SPACE$(10)
           END IF
      END IF
      NEXT
      RETURN
ROOM.CODE:
      GOSUB DECODE.ROOM
      IF RMCD = 3 THEN
          LBL$ = "Hidden in Room # "
      END IF
      IF RMCD = 2 THEN
          LBL$ = "Embed. Room# "
      END IF
      IF RMCD = 1 THEN
          LBL$ = "Inside Art.# "
      END IF
      IF RMCD = 4 THEN
          LBL$ = "Buried in Room# "
      END IF
      IF RMCD = -1 THEN
          LBL$ = "Carried by Mon.# "
      END IF
      RETURN
SHOW.EXPROOM:
      IF RMCD = 0 OR RMCD = 2 OR RMCD = 3 OR RMCD = 4 THEN
          IF Room < NR AND Room > 0 THEN
              GET #2, Room
              XRN$ = RTRIM$(RNF.RN$)
              PRINT "    ["; XRN$; "]"
              RETURN
          END IF
      END IF
      IF RMCD = 1 THEN
          IF Room < NA AND Room > 0 THEN
          GET #3, Room
          IAN$ = RTRIM$(AF.AN$)
          PRINT "    [Inside "; IAN$; "]"
          RETURN
          END IF
      END IF
      IF RMCD = -1 THEN
          IF Room < NM AND Room > 0 THEN
          GET #4, Room
          CB$ = RTRIM$(MF.MN$)
          PRINT "    [Carried by "; CB$; "]"
          RETURN
          END IF
      END IF
      RETURN
SHOW.ART.TYPES:
      LOCATE 9, 45
      PRINT "Artifact Types ..."
      FOR X = 0 TO AD.ART.TYPES
        LOCATE 10 + (X MOD 13), 40 + 20 * ABS(X > 12)
        PRINT USING "##"; X;
        PRINT "  "; A.TYP$(X);
      NEXT
      RETURN
ERASE.ART.TYPES:
      LOCATE 9, 45
      PRINT "                   "
      FOR X = 0 TO AD.ART.TYPES
        LOCATE 10 + (X MOD 13), 40 + 20 * ABS(X > 12)
        PRINT "                 ";
      NEXT
      RETURN
' =====================================================================
'
'                  SUBROUTINES - SETUP LABELS
'
' =====================================================================
SETUP.LABELS:
      Art$(5) = A.LBL$(AD%(2), 1)
      Art$(6) = A.LBL$(AD%(2), 2)
      Art$(7) = A.LBL$(AD%(2), 3)
      Art$(8) = A.LBL$(AD%(2), 4)
      RETURN
' =====================================================================
'
'                  SUBROUTINES - DISPLAY AN EFFECT
'
' =====================================================================
SHOW.EFFECT:
      LOCATE 5, 1
      PRINT Desc$
      RETURN
' =====================================================================
'
'                  SUBROUTINES - DISPLAY A MONSTER'S DATA
'
' =====================================================================
SHOW.MONSTER:
      LOCATE 3, 1
      PRINT MN$
      LOCATE 5, 1
      PRINT Desc$
      LOCATE 10, 1
      PRINT "Monster Data:"
      FOR A1 = 1 TO Mon.Flds
      IF A1 = 5 THEN
          LBL$ = Mon$(A1)
          CODED.ROOM = MD%(A1)
          GOSUB ROOM.CODE
          LOCATE 15, 1
          PRINT LBL$;
          LOCATE 15, 12
          PRINT USING "#,###"; Room;
          GOSUB SHOW.EXPROOM
      ELSE
          LOCATE 11 + ((A1 - 1) MOD 12), 1 + INT((A1 - 1) / 12) * 22
          PRINT Mon$(A1);
          LOCATE 11 + ((A1 - 1) MOD 12), 12 + INT((A1 - 1) / 12) * 22
          PRINT USING "#,###"; MD%(A1);
          IF A1 = 9 THEN
              IF MD%(A1) < NA AND MD%(A1) > 0 THEN
                  GET #3, MD%(A1)
                  A$ = RTRIM$(AF.AN$)
                  PRINT "    ["; A$; "]"
              END IF
          END IF
      END IF
      NEXT
      RETURN
' =====================================================================
'
'                  SUBROUTINES - WRITE ADVENTURE CONTROL
'
' =====================================================================
UPDATE.CNTS:
      OPEN Path$ + "DESC.R0" FOR OUTPUT AS #1
      WRITE #1, NR
      WRITE #1, NA
      WRITE #1, NE
      WRITE #1, NM
      WRITE #1, ND
      WRITE #1, Max.Rm
      WRITE #1, Max.Art
      WRITE #1, Max.Eff
      WRITE #1, Max.Mon
      WRITE #1, Rm.Len
      WRITE #1, Rmn.Len
      WRITE #1, Mon.Len
      WRITE #1, Art.Len
      WRITE #1, Desc.Len
      WRITE #1, Mon.Flds
      WRITE #1, Art.Flds
      WRITE #1, RM.Flds
      WRITE #1, MN.Len
      WRITE #1, AN.Len
      CLOSE 1
      RETURN
' =====================================================================
'
'                  SUBROUTINES - WRITE ROOM'S DATA
'
' =====================================================================
Write.Room:
      FOR R1 = 1 TO ND + RM.Flds
      RSET RF.RD$(R1) = MKI$(RD%(R1))
      NEXT
      LSET RF.LT$ = RIGHT$(STR$(LT), 1)
      PUT #1, R
      LSET RNF.RN$ = RN$
      PUT #2, R
      RAEM = 1
      GOSUB WRITE.DESC: ' PUT DESC FOR ROOM
      RETURN
' =====================================================================
'
'                  SUBROUTINES - WRITE ARTIFACT
'
' =====================================================================
WRITE.ARTIFACT:
      LSET AF.AN$ = AN$
      FOR A1 = 1 TO Art.Flds
      RSET AF.AD$(A1) = MKI$(AD%(A1))
      NEXT
      PUT #3, R
      RAEM = 2
      GOSUB WRITE.DESC: ' PUT DESC FOR ARTIFACT
      RETURN
' =====================================================================
'
'                  SUBROUTINES - WRITE AN EFFECT
'
' =====================================================================
WRITE.EFFECT:
      RAEM = 3
      GOSUB WRITE.DESC
      RETURN
' =====================================================================
'
'                  SUBROUTINES - WRITE A MONSTER
'
' =====================================================================
WRITE.MONSTER:
      LSET MF.MN$ = MN$
      FOR M1 = 1 TO Mon.Flds
      RSET MF.MD$(M1) = MKI$(MD%(M1))
      NEXT
      PUT #4, R
      RAEM = 4
      GOSUB WRITE.DESC: ' PUT DESC FOR MONSTER
      RETURN
' =====================================================================
'
'                  SUBROUTINES - WRITE A DESCRIPTION
'
' =====================================================================
WRITE.DESC:
      IF RAEM = 1 THEN REC = R
      IF RAEM = 2 THEN REC = Max.Rm + R
      IF RAEM = 3 THEN REC = Max.Rm + Max.Art + R
      IF RAEM = 4 THEN REC = Max.Rm + Max.Art + Max.Eff + R
      LSET DF.DESC$ = Desc$
      PUT #5, REC
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ CONTROL INFORMATION
'
' =====================================================================
READ.CTRL:
      ON ERROR GOTO Display.Control
      OPEN Path$ + "DESC.R0" FOR INPUT AS #1
      INPUT #1, NR
      INPUT #1, NA
      INPUT #1, NE
      INPUT #1, NM
      INPUT #1, ND
      INPUT #1, Max.Rm
      INPUT #1, Max.Art
      INPUT #1, Max.Eff
      INPUT #1, Max.Mon
      INPUT #1, Rm.Len
      INPUT #1, Rmn.Len
      INPUT #1, Mon.Len
      INPUT #1, Art.Len
      INPUT #1, Desc.Len
      INPUT #1, Mon.Flds
      INPUT #1, Art.Flds
      INPUT #1, RM.Flds
      INPUT #1, MN.Len
      INPUT #1, AN.Len
      CLOSE 1
Display.Control:
      ' ON ERROR GOTO 0
      CLS
      PRINT "Control information for this adventure ... IMPORTANT!!! DO NOT PROCEED"
      PRINT "if the information given below is not correct! Press ESC to cancel/correct."
      LOCATE 4, 10
      LOCATE 4, 10: PRINT "Number of Rooms      ... "; : PRINT USING "###"; NR
      LOCATE 5, 10: PRINT "Number of Artifacts  ... "; : PRINT USING "###"; NA
      LOCATE 6, 10: PRINT "Number of Effects   .... "; : PRINT USING "###"; NE
      LOCATE 7, 10: PRINT "Number of Monsters  .... "; : PRINT USING "###"; NM
      PRINT
      LOCATE 9, 10: PRINT "Number of Directions ... "; : PRINT USING "###"; ND
      LOCATE 10, 10: PRINT "Maximum Nbr Rooms    ... "; : PRINT USING "###"; Max.Rm
      LOCATE 11, 10: PRINT "Maximum Nbr Artifacts .. "; : PRINT USING "###"; Max.Art
      LOCATE 12, 10: PRINT "Maximum Nbr Effects .... "; : PRINT USING "###"; Max.Eff
      LOCATE 13, 10: PRINT "Maximum Nbr Monsters ... "; : PRINT USING "###"; Max.Mon
      LOCATE 14, 10: PRINT "Rooms File Length  ..... "; : PRINT USING "###"; Rm.Len
      LOCATE 15, 10: PRINT "Room Names Length  ..... "; : PRINT USING "###"; Rmn.Len
      LOCATE 16, 10: PRINT "Monster File Length  ... "; : PRINT USING "###"; Mon.Len
      LOCATE 17, 10: PRINT "Artifact File Length ... "; : PRINT USING "###"; Art.Len
      LOCATE 18, 10: PRINT "Description Length ..... "; : PRINT USING "###"; Desc.Len
      LOCATE 19, 10: PRINT "Nbr Monster Fields ..... "; : PRINT USING "###"; Mon.Flds
      LOCATE 20, 10: PRINT "Nbr Artifact Fields .... "; : PRINT USING "###"; Art.Flds
      LOCATE 21, 10: PRINT "Nbr Room Fields ........ "; : PRINT USING "###"; RM.Flds
      LOCATE 22, 10: PRINT "Monster Name Length .... "; : PRINT USING "###"; MN.Len
      LOCATE 23, 10: PRINT "Artifact Name Length ... "; : PRINT USING "###"; AN.Len
      GOSUB PRESS.ANY.KEY
      IF ESC THEN GOTO CORRECT.ABORT.RTN
      CLOSE 1
      INS.ADJ = Max.Rm                   ' + 100 - STANDARD
      EMB.ADJ = Max.Rm + Max.Art         ' + 200 - STANDARD
      HID.ADJ = 2 * Max.Rm + Max.Art     ' + 300 - STANDARD
      BURY.ADJ = 3 * Max.Rm + Max.Art    ' + 400 - STANDARD
      IF Mon.Flds > 12 THEN GOSUB READ.MON.FLDS
      IF Art.Flds > 8 THEN GOSUB READ.ART.FLDS
      IF RM.Flds > 0 THEN GOSUB READ.RM.FLDS
      RETURN
CORRECT.ABORT.RTN:
      ESC = 0
      LOCATE 1, 1
      PRINT "You may correct the incorrect values by re-keying them at this time. If you   "
      PRINT "would prefer to abort the program, press the ESC key on any of the values."
      PRINT SPC(79);
      IF NR > 0 OR NA > 0 OR NE > 0 OR NM > 0 THEN ROF.SW = -1 ELSE ROF.SW = 0
Edit.NR:
      LOCATE 4, 35
      NumericIo "I3", NR, I.Num, Bk
      IF Bk = -1 THEN GOTO Edit.NR
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -3 THEN NEW.NR = NR: GOTO Edit.NA
      NEW.NR = I.Num
Edit.NA:
      LOCATE 5, 35
      NumericIo "I3", NA, I.Num, Bk
      IF Bk = -3 THEN NEW.NA = NA: GOTO Edit.NE
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.NR
      NEW.NA = I.Num
Edit.NE:
      LOCATE 6, 35
      Bk = 0
      NumericIo "I3", NE, I.Num, Bk
      IF Bk = -3 THEN NEW.NE = NE: GOTO Edit.NM
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.NA
      NEW.NE = I.Num
Edit.NM:
      LOCATE 7, 35
      Bk = 0
      NumericIo "I3", NM, I.Num, Bk
      IF Bk = -3 THEN NEW.NM = NM: GOTO Edit.ND
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.NE
      NEW.NM = I.Num
Edit.ND:
      IF NR > 0 OR NA > 0 OR NE > 0 OR NM > 0 THEN ROF.SW = -1 ELSE ROF.SW = 0
      LOCATE 9, 35
      Bk = 0
      NumericIo "I3", ND, I.Num, Bk
      IF Bk = -3 THEN NEW.ND = ND: GOTO Edit.Max.Rm
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.NM
      NEW.ND = I.Num
Edit.Max.Rm:
      'IF ROF.SW THEN
      '    NEW.MAX.RM = Max.Rm
      '    New.Max.Art = Max.Art
      '    New.Max.Eff = Max.Eff
      '    New.Rm.Len = Rm.Len
      '    New.RMN.Len = Rmn.Len
      '    New.Mon.Len = Mon.Len
      '    New.Art.Len = Art.Len
      '    New.Desc.Len = Desc.Len
      '    GOTO Edit.Mon.Flds
      'END IF
      LOCATE 10, 35
      Bk = 0
      NumericIo "I3", Max.Rm, I.Num, Bk
      IF Bk = -3 THEN NEW.MAX.RM = Max.Rm: GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.ND
      IF I.Num < 50 OR I.Num > 400 THEN BEEP: GOTO Edit.Max.Rm
      NEW.MAX.RM = I.Num
Edit.Max.Art:
      LOCATE 11, 35
      Bk = 0
      NumericIo "I3", Max.Art, I.Num, Bk
      IF Bk = -3 THEN New.Max.Art = Max.Art: GOTO Edit.Max.Eff
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Max.Rm
      IF I.Num < 50 OR I.Num > 400 THEN BEEP: GOTO Edit.Max.Art
      New.Max.Art = I.Num
Edit.Max.Eff:
      LOCATE 12, 35
      Bk = 0
      NumericIo "I3", Max.Eff, I.Num, Bk
      IF Bk = -3 THEN New.Max.Eff = Max.Eff: GOTO Edit.Rm.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Max.Art
      IF I.Num < 50 OR I.Num > 400 THEN BEEP: GOTO Edit.Max.Eff
      New.Max.Eff = I.Num
Edit.Max.Mon:
      LOCATE 13, 35
      Bk = 0
      NumericIo "I3", Max.Mon, I.Num, Bk
      IF Bk = -3 THEN New.Max.Mon = Max.Mon: GOTO Edit.Rm.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Max.Eff
      IF I.Num < 50 OR I.Num > 400 THEN BEEP: GOTO Edit.Max.Mon
      New.Max.Mon = I.Num
Edit.Rm.Len:
      LOCATE 14, 35
      Bk = 0
      NumericIo "I3", Rm.Len, I.Num, Bk
      IF Bk = -3 THEN New.Rm.Len = Rm.Len: GOTO Edit.Rmn.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Max.Eff
      IF I.Num < 12 OR I.Num > 128 THEN BEEP: GOTO Edit.Rm.Len
      New.Rm.Len = I.Num
Edit.Rmn.Len:
      LOCATE 15, 35
      Bk = 0
      NumericIo "I3", Rmn.Len, I.Num, Bk
      IF Bk = -3 THEN New.RMN.Len = Rmn.Len: GOTO Edit.Mon.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Rm.Len
      IF I.Num < 36 OR I.Num > 256 THEN BEEP: GOTO Edit.Rmn.Len
      New.RMN.Len = I.Num
Edit.Mon.Len:
      LOCATE 16, 35
      Bk = 0
      NumericIo "I3", Mon.Len, I.Num, Bk
      IF Bk = -3 THEN New.Mon.Len = Mon.Len: GOTO Edit.Art.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Rmn.Len
      IF I.Num < 32 OR I.Num > 256 THEN BEEP: GOTO Edit.Art.Len
      New.Mon.Len = I.Num
Edit.Art.Len:
      LOCATE 17, 35
      Bk = 0
      NumericIo "I3", Art.Len, I.Num, Bk
      IF Bk = -3 THEN New.Art.Len = Art.Len: GOTO Edit.Desc.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Mon.Len
      IF I.Num < 36 OR I.Num > 256 THEN BEEP: GOTO Edit.Art.Len
      New.Art.Len = I.Num
Edit.Desc.Len:
      LOCATE 18, 35
      Bk = 0
      NumericIo "I3", Desc.Len, I.Num, Bk
      IF Bk = -3 THEN New.Desc.Len = Desc.Len: GOTO Edit.Mon.Flds
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Art.Len
      IF I.Num < 160 OR I.Num > 1024 THEN PRINT CHR$(7): GOTO Edit.Desc.Len
      New.Desc.Len = I.Num
Edit.Mon.Flds:
      LOCATE 19, 35
      Bk = 0
      NumericIo "I3", Mon.Flds, I.Num, Bk
      IF Bk = -3 THEN New.Mon.Flds = Mon.Flds: GOTO Edit.Art.Flds
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 AND ROF.SW THEN GOTO Edit.ND
      IF Bk = -1 THEN GOTO Edit.Desc.Len
      IF I.Num < 12 OR I.Num > 36 THEN PRINT CHR$(7): GOTO Edit.Mon.Flds
      New.Mon.Flds = I.Num
Edit.Art.Flds:
      LOCATE 20, 35
      Bk = 0
      NumericIo "I3", Art.Flds, I.Num, Bk
      IF Bk = -3 THEN New.Art.Flds = Art.Flds: GOTO Edit.Rm.Flds
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Mon.Flds
      IF I.Num < 8 OR I.Num > 12 THEN PRINT CHR$(7): GOTO Edit.Art.Flds
      New.Art.Flds = I.Num
Edit.Rm.Flds:
      LOCATE 21, 35
      Bk = 0
      NumericIo "I3", RM.Flds, I.Num, Bk
      IF Bk = -3 THEN Bk = 0: New.RM.Flds = RM.Flds: GOTO Edit.Mn.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Art.Flds
      IF I.Num < 0 OR I.Num > 4 THEN PRINT CHR$(7): GOTO Edit.Rm.Flds
      New.RM.Flds = I.Num
Edit.Mn.Len:
'      IF NM > 0 THEN IF Bk THEN GOTO Edit.Rm.Flds ELSE New.MN.Len = MN.Len: GOTO Edit.AN.Len
      LOCATE 22, 35
      Bk = 0
      NumericIo "I3", MN.Len, I.Num, Bk
      IF Bk = -3 THEN New.MN.Len = MN.Len: GOTO Edit.AN.Len
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Rm.Flds
      IF I.Num < 20 OR I.Num > 64 THEN PRINT CHR$(7): GOTO Edit.Mn.Len
      New.MN.Len = I.Num
Edit.AN.Len:
'      IF NA > 0 THEN New.AN.Len = AN.Len: GOTO Edit.Done
      LOCATE 23, 35
      Bk = 0
      NumericIo "I3", AN.Len, I.Num, Bk
      IF Bk = -3 THEN New.AN.Len = AN.Len: GOTO Edit.Done
      IF Bk = -2 THEN GOTO forget.it
      IF Bk = -1 THEN GOTO Edit.Mn.Len
      IF I.Num < 20 OR I.Num > 64 THEN PRINT CHR$(7): GOTO Edit.AN.Len
      New.AN.Len = I.Num
Edit.Done:
      NR = NEW.NR
      NA = NEW.NA
      NE = NEW.NE
      NM = NEW.NM
      ND = NEW.ND
      Max.Rm = NEW.MAX.RM
      Max.Art = New.Max.Art
      Max.Eff = New.Max.Eff
      Max.Mon = New.Max.Mon
      Rm.Len = New.Rm.Len
      Rmn.Len = New.RMN.Len
      Mon.Len = New.Mon.Len
      Art.Len = New.Art.Len
      Desc.Len = New.Desc.Len
      Mon.Flds = New.Mon.Flds
      Art.Flds = New.Art.Flds
      RM.Flds = New.RM.Flds
      MN.Len = New.MN.Len
      AN.Len = New.AN.Len
      GOTO Display.Control
NoAdvPath:
      Path$ = ""
      RESUME InAdv
forget.it:
      CLOSE
      END
' =====================================================================
'
'                  SUBROUTINES - READ MONSTER FIELD LABELS
'
' =====================================================================
READ.MON.FLDS:
      OPEN Path$ + "MONST.CTL" FOR INPUT AS #1
      FOR D = 13 TO Mon.Flds
        INPUT #1, Mon$(D)
      NEXT
      CLOSE
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ ARTIFACT FIELD LABELS
'
' =====================================================================
READ.ART.FLDS:
      OPEN Path$ + "ARTIF.CTL" FOR INPUT AS #1
      FOR D = 9 TO Art.Flds
        INPUT #1, Art$(D)
      NEXT
      CLOSE
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ EXTRA ROOM FIELD LABELS
'
' =====================================================================
READ.RM.FLDS:
      OPEN Path$ + "ROOMS.CTL" FOR INPUT AS #1
      FOR D = ND + 1 TO RM.Flds + ND
        INPUT #1, Dirct$(D)
      NEXT
      CLOSE
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ ROOM'S DATA
'
' =====================================================================
Read.Room:
      GET #1, R
      FOR R1 = 1 TO ND + RM.Flds
      RD = CVI(RF.RD$(R1))
      RD%(R1) = RD
      NEXT
      LT = VAL(RF.LT$)
      IF LT <> 0 AND LT <> 1 THEN LT = 1
      GET #2, R
      RN$ = RTRIM$(RNF.RN$)
      RAEM = 1
      GOSUB READ.DESC: ' GET DESC FOR ROOM
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ ARTIFACT'S DATA
'
' =====================================================================
READ.ARTIFACT:
      GET #3, R
      AN$ = RTRIM$(AF.AN$)
      FOR A1 = 1 TO Art.Flds
      AD%(A1) = CVI(AF.AD$(A1))
      NEXT
      RAEM = 2:
      GOSUB READ.DESC: ' GET DESC FOR ARTIFACT
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ AN EFFECT
'
' =====================================================================
READ.EFFECT:
      RAEM = 3
      GOSUB READ.DESC
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ A MONSTER'S DATA
'
' =====================================================================
READ.MONSTER:
      GET #4, R
      MN$ = RTRIM$(MF.MN$)
      FOR M1 = 1 TO Mon.Flds
      MD%(M1) = CVI(MF.MD$(M1))
      NEXT
      RAEM = 4
      GOSUB READ.DESC: 'GET DESC
      RETURN
' =====================================================================
'
'                  SUBROUTINES - READ A DESCRIPTION
'
' =====================================================================
READ.DESC:
      IF RAEM = 1 THEN REC = R
      IF RAEM = 2 THEN REC = Max.Rm + R
      IF RAEM = 3 THEN REC = Max.Rm + Max.Art + R
      IF RAEM = 4 THEN REC = Max.Rm + Max.Art + Max.Eff + R
      GET #5, REC
      Desc$ = RTRIM$(DF.DESC$)
      RETURN
' =====================================================================
'
'                  SUBROUTINES - GET A KEYPRESS
'
' =====================================================================
PRESS.ANY.KEY:
      LOCATE 25, 1
      ESC = 0
      UPD = 0
      PRINT "      Press any key to continue ";
      IF UP THEN PRINT "(U to Update) ... ";  ELSE PRINT "... ";
      IF Bk THEN PRINT "<- to Back Up ...";
      BK.UP = 0
      N$ = ""
PKEY:
      A$ = ""
      WHILE A$ = ""
      A$ = INKEY$
      WEND
      IF A$ = CHR$(27) THEN ESC = -1
      IF UCASE$(A$) = "U" AND UP <> 0 THEN UPD = -1
      IF A$ >= "0" AND A$ <= "9" THEN N$ = N$ + A$: GOTO PKEY
      IF Bk THEN IF A$ = CHR$(0) + CHR$(75) THEN BK.UP = -1
      LOCATE 25, 1
      PRINT SPC(79);
      NO. = VAL(N$)
      Bk = 0
      RETURN
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
' ==========================================================================
'                          Log of changes
' ==========================================================================
      '  6-22-87  1.01 Corrections made to 1.0 version
      '  7-31-87  1.02 Ten Directions installed
      '  8-01-87  1.02 Installed numeric I/O routine, ability to back up
      '  1-16-88  2.01 Converted to QuickBASIC 4.0 Format
      '                corrected artifact error (effect being destroyed)
      '  2-20-88  2.02 Allow switching adventures w/o terminating program
      '  2-20-88  3.00 Install lower case routines for artifacts and monsters
      '                Move All list functions to a separate menu
      '  3-25-88  3.10 Intelligent Artifact types installed, allow
      '                backing up in displays, Allow changing # in
      '                view routines.
      '  3-26-88  4.00 Variable Length files, control information added
      '                to DESC.R0 record:
      '                    NR/NA/NE/NM/ND/MAX.RM/MAX.ART/RM.LEN/RMN.LEN/
      '                    MON.LEN/ART.LEN/DESC.LEN
      '                This will automatically get pulled in and defaulted if
      '                not on the file. Also a verification routine added to
      '                allow correcting it if it is not correct.
      '  4-2-88   4.01 Install Light variable into room edit
      '  5-14-88  4.02 Correct fwd/bkwd reading, install capitalize of desc.
      '                  change up/dn arrows in textio rtn
      '  6-19-88  4.03 Add additional control parameters for nbr mon.flds,
      '                nbr art fields, len of mon name and len of art name
      '  6-25-88  4.10 New files added to contain artifact types, labels
      '                of fields for monster data and artifact data and
      '                room directions.
      '
      '  7-30-88  4.11 Fix made to Textio routine on find command, monster
      '                room numbers were being zeroed out accidentally because
      '                PF value not set to zero before edit.
      ' 11-20-90  4.12 Added ability to switch case of multiple characters,
      '                ability to escape from room definition / editing.
      '
      '  4-22-91  4.20 Corrected Edit routine to maintain PF value when
      '                return is pressed on a field that originally had
      '                a special coding.
      '  5-03-91  4.20 Fixed a bug in defaulting secret passages - Default
      '                PF key was set, but number was being left as negative
      '                and then the negative of that number caused + result.
      '
      ' 12-3-95   5.00 Add expanded descriptions is show routines
      '                to show rooms, artifacts carried, etc.
      '  5-24-97  5.10 Put Get Number routine in a sub-routine
      '                and shortened the number of parameters needed.
      '
      '  1-22-00  5.11 Add Print to File routine in List routine.
      '  3-04-00  5.20 Change / Fix Light to be in constant spot (21st byte)
      '                and use LT as integer rather than a string
      ' 3-17-00 5.21 Allow manually starting edit process by being in the
      '              adventure directory
      ' 4-06-00 5.22 Messages weren't right for exit home when function key
      '              F3 was pressed. Changed EMB.KEY$, INS.KEY$, etc. to F1$,
      '              F2$, etc. to make the key names more accurate as to
      '              their meaning.

DEFSNG A-Z
SUB GetByte (A$)
      LOCATE , , 1, 0, 7
      A$ = ""
      WHILE A$ = ""
         A$ = INKEY$
      WEND
      IF A$ = CHR$(127) THEN A$ = CHR$(29)
      IF A$ = CHR$(8) THEN A$ = CHR$(29)
      IF A$ = CHR$(0) + CHR$(59) THEN A$ = "F1": ' F1 pressed
      IF A$ = CHR$(0) + CHR$(60) THEN A$ = "F2": ' F2 pressed
      IF A$ = CHR$(0) + CHR$(61) THEN A$ = "F3": ' F3 pressed
      IF A$ = CHR$(0) + CHR$(62) THEN A$ = "F4": ' F4 pressed
      IF A$ = CHR$(0) + CHR$(63) THEN A$ = "F5": ' F5 pressed
      IF A$ = CHR$(0) + CHR$(64) THEN A$ = "F6": ' F6 pressed
      IF A$ = CHR$(0) + CHR$(65) THEN A$ = "F7": ' F7 pressed
      IF A$ = CHR$(0) + CHR$(66) THEN A$ = "F8": ' F8 pressed
      IF A$ = CHR$(0) + CHR$(67) THEN A$ = "F9": ' F9 pressed
      IF A$ = CHR$(0) + CHR$(68) THEN A$ = "F10": ' F10 pressed
      IF A$ = CHR$(0) + CHR$(75) THEN A$ = CHR$(29): ' CURSOR LEFT
      IF A$ = CHR$(0) + CHR$(77) THEN A$ = CHR$(28): ' CURSOR RIGHT
      IF A$ = CHR$(0) + CHR$(80) THEN A$ = CHR$(31): ' CURSOR DOWN
      IF A$ = CHR$(0) + CHR$(73) THEN A$ = CHR$(24): ' PG UP
      IF A$ = CHR$(0) + CHR$(72) THEN A$ = CHR$(30): ' CURSOR UP
      IF A$ = CHR$(0) + CHR$(81) THEN A$ = CHR$(25): ' PG DN
      IF A$ = CHR$(0) + CHR$(82) THEN A$ = CHR$(9): ' INS
      IF A$ = CHR$(0) + CHR$(83) THEN A$ = CHR$(4): ' DEL
      IF A$ = CHR$(0) + CHR$(79) THEN A$ = CHR$(23): ' END
      IF A$ = CHR$(0) + CHR$(71) THEN A$ = CHR$(22): ' HOME
      IF A$ = CHR$(0) + CHR$(117) THEN A$ = CHR$(26): ' CTL-END
'      A$ = LEFT$(A$, 1)
      ' IF CAPS THEN LOCATE , , 0: RETURN
      ' IF A$ >= "a" THEN A$ = CHR$(ASC(A$) - 32)
      LOCATE , , 0
END SUB

DEFINT A-Z
SUB NumericIo (Fmt$, Df, I.Num, Bk)
' =====================================================================
'
'                  SUBROUTINES - NUMERIC I/O ROUTINE
'
' =====================================================================
      I.L% = VAL(MID$(Fmt$, 2))
      I.U$ = RIGHT$("###,###,###,###", I.L% + INT((I.L% - 1) / 3))
      I$ = ""
      V% = CSRLIN
      H% = POS(1)
      PfPmt = Bk
      Bk = 0
      F1$ = ""
      F2$ = ""
      F3$ = ""
      F4$ = ""
      F5$ = ""
      IF PfPmt > 0 THEN F1$ = "F1"
      IF PfPmt > 1 THEN F2$ = "F2"
      IF PfPmt > 2 THEN F3$ = "F3"
      IF PfPmt > 3 THEN F4$ = "F4"
      IF PfPmt > 4 THEN F5$ = "F5"
      RES.KEY$ = "F10"
NIO.1:
      LOCATE V%, H%
      IF I$ <> "" THEN
          PRINT USING I.U$; VAL(I$);
      ELSE
          PRINT USING I.U$; Df;
      END IF
NIO.2:
      LOCATE V%, H% + LEN(I.U$) - 1
      GOSUB GET.BYTE
      IF A$ = F1$ AND RAEM = 1 THEN
          Bk = 1
          LOCATE V%, 18
          PRINT "Blocks Way";
          GOTO NIO.2
      END IF
      IF A$ = F2$ AND RAEM = 1 THEN
          Bk = 2
          LOCATE V%, 18
          PRINT "(Secret Pass.)";
          GOTO NIO.2
      END IF
      IF A$ = F3$ AND RAEM = 1 THEN
          Bk = 3
          LOCATE V%, 18
          PRINT "[Exit to Main Hall]"
          GOTO NIO.2
      END IF
      IF A$ = F1$ THEN
          Bk = 1
          LOCATE V%, 1
          PRINT "Inside Art.#   ";
          GOTO NIO.2
      END IF
      IF A$ = F2$ THEN
          Bk = 2
          LOCATE V%, 1
          PRINT "Embed. Room#   ";
          GOTO NIO.2
      END IF
      IF A$ = F3$ THEN
          Bk = 3
          LOCATE V%, 1
          PRINT "Hidden Room#   ";
          GOTO NIO.2
      END IF
      IF A$ = F4$ THEN
          Bk = 4
          LOCATE V%, 1
          PRINT "Carried by Mon#";
          GOTO NIO.2
      END IF
      IF A$ = F5$ THEN
          Bk = 5
          LOCATE V%, 1
          PRINT "Buried in Room#";
          GOTO NIO.2
      END IF
      IF A$ = RES.KEY$ THEN
          Bk = 0
          LOCATE V%, 1
          PRINT "Room           ";
          GOTO NIO.2
      END IF
      IF A$ = CHR$(13) THEN GOTO NIO.RETURN
      IF A$ = CHR$(27) THEN Bk = -2: GOTO NIO.RETURN2
      IF A$ = CHR$(29) AND LEN(I$) > 0 THEN I$ = LEFT$(I$, LEN(I$) - 1): GOTO NIO.1
      IF A$ = CHR$(29) AND I$ = "" THEN Bk = -1: GOTO NIO.RETURN2
      IF A$ = "-" AND LEFT$(I$, 1) <> "-" THEN I$ = "-" + I$: GOTO NIO.1
      IF A$ = "-" THEN I$ = MID$(I$, 2): GOTO NIO.1
      IF A$ >= "0" AND A$ <= "9" AND LEN(I$) < I.L% THEN I$ = I$ + A$: GOTO NIO.1
      PRINT CHR$(7);
      GOTO NIO.2
NIO.RETURN:
      IF I$ = "" THEN I.Num = Df ELSE I.Num = VAL(I$)
NIO.RETURN2:
      LOCATE , , 0
      EXIT SUB
GET.BYTE:  ' get a keystroke & convert to std 1 byte code
      GetByte A$
      LOCATE , , 0
      RETURN

END SUB

DEFSNG A-Z
SUB PrtCenter (L$)
        LOCATE , (80 - LEN(L$)) \ 2 + 1
        PRINT L$
END SUB

DEFINT A-Z
    SUB TEXTIO (I$, Df$, Bk) STATIC
'                This is a generic text build I/O routine
'
'
'
'
' -------------------------------------------------------------------
'                   TEXTIO Routine
' -------------------------------------------------------------------
TEXTIO.RTN:
     V% = CSRLIN: H% = POS(1)
     Bk = 0
     INS.CHR$ = CHR$(0) + CHR$(82)
     DEL.CHR$ = CHR$(0) + CHR$(83)
     UP.CHR$ = CHR$(0) + CHR$(72)
     DN.CHR$ = CHR$(0) + CHR$(80)
     END.CHR$ = CHR$(0) + CHR$(79)
     HOME.CHR$ = CHR$(0) + CHR$(71)
     LEFT.CHR$ = CHR$(29)
     RIGHT.CHR$ = CHR$(0) + CHR$(77)
     CTL.END$ = CHR$(0) + CHR$(117)
     UPPER.CASE$ = CHR$(21)     ' ctl-u switches to all upper
     LOWER.CASE$ = CHR$(12)     ' ctl-l switches to all lower
     SHIFT$ = CHR$(19)          ' ctl-s switches case
     FIND.CHR$ = CHR$(6)
     ESC.CHR$ = CHR$(27)
     PACK.CHR$ = CHR$(16)
BUILD.TEXT:
     LOCATE V%, H%
     PRINT Df$;
     LOCATE V%, H%
     I$ = ""
BLD.TEXT:
     GOSUB TIO.GET.BYTE
CHK.KEYSTROK:
     IF A$ = CHR$(8) THEN A$ = CHR$(29)
     IF A$ = FIND.CHR$ THEN
         STP = 2
         GOSUB FIND.A.CHAR
         IF FF = 0 THEN GOTO BLD.TEXT
     END IF
     IF A$ = PACK.CHR$ THEN
         WHILE INSTR(Df$, "  ") > 0
             DBLSP = INSTR(Df$, "  ")
             Df$ = LEFT$(Df$, DBLSP) + MID$(Df$, DBLSP + 2)
         WEND
         LOCATE V%, H%
         PRINT LEFT$(I$ + Df$ + SPACE$(255), 320);
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(13) THEN
         LOCATE , , 0
         I$ = I$ + Df$
         Df$ = ""
         LOCATE V%, H%
         PRINT I$;
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ AND LEN(I$) = 0 THEN
         Bk = -2
         I$ = I$ + Df$
         EXIT SUB
     END IF
     IF A$ = ESC.CHR$ THEN I$ = I$ + Df$: EXIT SUB
     IF A$ >= CHR$(32) THEN
         I$ = I$ + A$
         Df$ = MID$(Df$, 2)
         PRINT A$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(23) THEN    ' END key
         I$ = I$ + Df$
         Df$ = ""
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(26) THEN        ' Ctl-End
         S.V = CSRLIN
         S.H = POS(1)
         LOCATE V%, H%, 0
         SP = LEN(Df$)
         IF SP > 0 THEN PRINT I$ + SPACE$(SP);
         Df$ = ""
         LOCATE S.V, S.H
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(22) THEN    ' home key
         Df$ = I$ + Df$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(29) AND LEN(I$) > 1 THEN   '  back
         Df$ = RIGHT$(I$, 1) + Df$
         I$ = LEFT$(I$, LEN(I$) - 1)
         PRINT CHR$(29);
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(29) AND LEN(I$) = 1 THEN   ' back
         Df$ = I$ + Df$
         I$ = ""
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(29) AND LEN(I$) < 1 THEN      ' back
         Bk = -1
         I$ = I$ + Df$
         EXIT SUB
     END IF
     IF A$ = CHR$(28) AND LEN(Df$) > 0 THEN     ' right
         I$ = I$ + LEFT$(Df$, 1)
         Df$ = MID$(Df$, 2)
         PRINT RIGHT$(I$, 1);
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(31) AND LEN(Df$) <= 80 THEN    ' down
         I$ = I$ + Df$
         Df$ = ""
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(31) THEN                  ' down
         I$ = I$ + LEFT$(Df$, 80)
         Df$ = MID$(Df$, 81)
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(30) AND LEN(I$) >= 80 THEN      ' up
         Df$ = RIGHT$(I$, 80) + Df$
         I$ = LEFT$(I$, LEN(I$) - 80)
         LOCATE V%, H%
         PRINT I$;
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(9) AND LEN(I$) > 0 THEN        ' ins
         Df$ = " " + Df$
         LOCATE V%, H%
         PRINT I$ + Df$ + STRING$(LEN(Df$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(9) AND LEN(I$) = 0 THEN
         LOCATE V%, H%
         PRINT " " + Df$;
         Df$ = " " + Df$
         LOCATE V%, H%
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(4) AND LEN(I$) = 0 THEN
         Df$ = MID$(Df$, 2)
         LOCATE V%, H%
         PRINT Df$ + " " + STRING$(LEN(Df$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = CHR$(4) THEN
         Df$ = MID$(Df$, 2)
         LOCATE V%, H%
         PRINT I$ + Df$ + " " + STRING$(LEN(Df$) + 1, 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = UPPER.CASE$ THEN
         I$ = UCASE$(I$)
         Df$ = UCASE$(Df$)
         LOCATE V%, H%
         PRINT I$ + Df$ + STRING$(LEN(Df$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = LOWER.CASE$ THEN
         I$ = LCASE$(I$)
         Df$ = LCASE$(Df$)
         LOCATE V%, H%
         PRINT I$ + Df$ + STRING$(LEN(Df$), 29);
         GOTO BLD.TEXT
     END IF
     IF A$ = SHIFT$ THEN
         IF LEFT$(Df$, 1) >= "a" AND LEFT$(Df$, 1) <= "z" THEN
             I$ = I$ + CHR$(ASC(LEFT$(Df$, 1)) - 32)
             Df$ = MID$(Df$, 2)
             PRINT RIGHT$(I$, 1);
             GOTO BLD.TEXT
         ELSE
             IF LEFT$(Df$, 1) >= "A" AND LEFT$(Df$, 1) <= "Z" THEN
                 I$ = I$ + CHR$(ASC(LEFT$(Df$, 1)) + 32)
                 Df$ = MID$(Df$, 2)
                 PRINT RIGHT$(I$, 1);
                 GOTO BLD.TEXT
             END IF
             A$ = RIGHT.CHR$
             GOTO CHK.KEYSTROK
         END IF
     END IF
     BEEP
     GOTO BLD.TEXT
FIND.A.CHAR:
     GOSUB TIO.GET.BYTE
     SAVE.FIND$ = A$
LOOK.AGAIN:
     A = INSTR(STP, Df$, SAVE.FIND$)
     IF A = 0 THEN
         I$ = I$ + Df$
         Df$ = ""
         LOCATE V%, H%
         PRINT I$;
         FF = 0
         RETURN
     END IF
     I$ = I$ + LEFT$(Df$, A - 1)
     Df$ = MID$(Df$, A)
     LOCATE V%, H%
     PRINT I$;
     FF = -1
     GOSUB TIO.GET.BYTE
     IF A$ <> SAVE.FIND$ THEN RETURN
     GOTO LOOK.AGAIN
TIO.GET.BYTE:
     LOCATE , , 1, 4, 7
     GetByte A$
     RETURN
END SUB

