'           Eamon Adventure # 100
'
'        Sorceror's Spire (a.k.a. The Dark Spire)
'
'             by John Nelson
'
'
'           DDD VERSION 6.2
'
    DECLARE SUB PGPRT (SP, LIT$)
REM $$INCL:'\eamon\copy\chardef.bas'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\eamon\COPY\COLORRTN.BAS'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
    CLS
    DEF FNR (X) = INT(RND(1) * X) + 1
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
    DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
    DIM FWN$(4), FWT$(4), FWC$(4), FWD$(4), FWS$(4), FWA$(5), FSA$(5)
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MN$(NM), MD%(NM, 18)
    GOSUB READ.ART.REC ' LOAD ARTIFACT TABLE
    GOSUB READ.MON.REC ' LOAD MONSTER TABLE
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
    READ C$(C)
    NEXT
    READ NT
    DIM TH$(NT), SP%(8), M$(NM)
    FOR X = 1 TO NT: READ TH$(X): NEXT
    FOR X = 1 TO 8: READ SP%(X): NEXT
    LVL = 170
    R2 = 1
    CONST GOLD.ART = 0
    CONST TREASURE.ART = 1
    CONST WEAPON.ART = 2
    CONST MAG.WEAPON = 3
    CONST CONTAIN.ART = 4
    CONST LIGHT.ART = 5
    CONST HEAL.ART = 6
    CONST READ.ART = 7
    CONST DOOR.ART = 8
    CONST KEY.ART = 9
    CONST BOUND.MON.ART = 10
    CONST ARMOR.ART = 11
    CONST FOOD.ART = 12
    GOTO INITIALIZE
DONT.UNDERSTAND:
    PGPRT 2, "I don't understand."
' ---------------------------------------------------------------------------
MAIN.LOOP:
'    = MAIN =
    IF SPD THEN SPD = SPD - 1: IF SPD = 0 THEN MD%(0, 2) = MD%(0, 2) / 2: MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2): PGPRT 2, "YOUR SPEED SPELL HAS JUST EXPIRED!"
    IF IV THEN PGPRT 2, "You're invisible.": VC = VC + 1: IF VC > 5 THEN VC = 0: D2 = 3: DF = 0: GOSUB APPLY.DAMAGE
SHOW.ROOM:      ' SHOW.ROOM
    IF V%(ROOM) <> 0 THEN GET #3, ROOM: A$ = RTRIM$(RN$): PGPRT 2, "You are " + A$
    IF V%(ROOM) = 0 THEN GOSUB SPECIAL.ROOM.CHK
    IF ROOM = 58 THEN PGPRT 2, "The exits are appearing and disappearing at an amazing pace. You'll have to just make a dash for one and hope you make it through."
    IF RK THEN RK = RK - 1: IF RK = 0 THEN MD%(0, 8) = AR: PGPRT 2, "Your forcefield has just faded!"
    FOR M = 1 TO NM
    IF MD%(M, 5) <> ROOM THEN GOTO NEXT.MON
    IF MD%(M, 15) = 1 THEN PGPRT 2, MN$(M) + " is here."
    IF MD%(M, 15) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
    IF MD%(M, 15) = 0 THEN
	GET #2, M + 300
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	MD%(M, 15) = 1
    END IF
    IF MD%(0, 16) > 0 AND MD%(M, 6) > 300 AND MD%(M, 14) = 3 AND FNR(100) > 70 THEN GOSUB REVERSE.TRANS
NEXT.MON:      ' NEXT.MON
    NEXT
    FOR A = 1 TO NZ
    IF AD%(A, 4) <> ROOM THEN GOTO NEXT.ART
    IF AD%(A, 9) THEN
	PGPRT 2, "You see " + AN$(A) + "."
    ELSE
	GET #2, A + 100
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	AD%(A, 9) = 1
    END IF
NEXT.ART:      ' NEXT.ART
    NEXT
    FOR A = A TO NA
    IF AD%(A, 4) = ROOM THEN
	PGPRT 2, "Your " + AN$(A) + " is here."
    END IF
    NEXT
    PRINT
GET.COMMAND:      ' GET.COMMAND
    PGPRT 0, ""
    PRINT
    COLOR HFG%, HBG%
    PRINT "  Your Command ";
    COLOR FGC%, BGC%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(UCASE$(A$)))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    IF A$ = "EXIT NOW" THEN GOTO Game.Over
    CZ$ = A$
    A = INSTR(A$, " ")
    IF A = 0 THEN A = LEN(A$) + 1
    V$ = LEFT$(A$, A - 1)
    S$ = MID$(A$, A + 1)
    S$ = LTRIM$(S$)
    C = 0
    FOR A = 1 TO ND
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
    NEXT
    IF C <> 0 THEN GOTO BRANCH.RTN
    F = 0
    FOR A = ND + 1 TO NC
    IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	F = F + 1
	C = A
	IF F > 1 THEN C = 0: A = NC
    END IF
    NEXT
    IF C = 0 THEN GOTO LIST.COMMANDS
    GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
    PRINT "Huh? I only understand these commands ... ";
    FOR C = 1 TO NC
    PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 5 GOTO MOVE.RTN, GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN
    ON C - 10 GOTO LOOK.RTN, ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN
    ON C - 15 GOTO BLAST.SPELL, HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN
    ON C - 20 GOTO SMILE.RTN, SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN
    ON C - 25 GOTO PUT.RTN, FREE.RTN, EAT.RTN, DRINK.RTN, WEAR.RTN
    ON C - 30 GOTO PRESS.RTN, THINK.RTN, SAVE.GAME, RESTORE.GAME, QUIT.RTN
GET.BACK:      ' GET.BACK
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
    GOTO MAIN.LOOP
REVERSE.TRANS:		' REVERSE TRANSFORMATION!
    PGPRT 2, MN$(M) + " laughs at your plight, but reverses the spell you are under."
    MD%(0, 16) = 0
    MN$(0) = M$(0)
    MD%(0, 1) = MD%(0, 17)
    RETURN
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
' ---------------------------------------------------------------------------
INITIALIZE:
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
    '------- (end of include file) -------
    GOSUB OPEN.DESC
    GOSUB OPEN.ROOM.NAMES
    GOSUB OPEN.ROOMS
    ROOM = 1
    ND = 6
    IF MD%(0, 1) > 30 THEN MD%(0, 1) = 24
    IF MD%(0, 8) > 7 THEN MD%(0, 8) = 7
    GOSUB CALC.BAL.OF.POWER
    TOT.BAD = BAD.GUYS
    TOT.GOOD = GOOD.GUYS
    FOR X = 1 TO 6
      WX$ = WX$ + CHR$(INT(RND(1) * 26 + 1) + 64)
    NEXT
    GOTO MOVE.IT
CALC.BAL.OF.POWER:
    BAD.GUYS = 0
    GOOD.GUYS = 0
    FOR X = 1 TO NM
    IF MD%(X, 3) < 50 THEN BAD.GUYS = BAD.GUYS + MD%(X, 6)
    IF MD%(X, 3) > 50 THEN GOOD.GUYS = GOOD.GUYS + MD%(X, 6)
    NEXT
    X = ABS(GOOD.GUYS - BAD.GUYS)
    IF X < 300 THEN BOP = 1 ELSE BOP = 0
    RETURN
    DATA 35
    DATA North,South,East,West,Up,Down
    DATA Get,Take,Drop,Look,Examine
    DATA Attack,Flee,Give,Inventory
    DATA Blast,Heal,Power,Speed,Smile
    DATA Wave,Say,Read,Ready,Open
    DATA Put,Free,Eat,Drink,Wear,Press,Think
    DATA Save,Restore,Quit
    DATA 9
    DATA Mosquito,Cockroach,Cricket,Worm,Beetle,Frog,Toad,Mouse,Lizard
    DATA 25,35,45,65,90,108,110,120
' ---------------------------------------------------------------------------
Game.Over:      ' GAME.OVER
    IF DIE AND Testing THEN DIE = 0: MD%(0, 13) = 0: PGPRT 2, "Well, you're not really dead. Just kidding.": GOTO MAIN.LOOP
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    IF SPD THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
    END IF
    KILL PATH$ + "MEAT"
    IF DIE <> 0 THEN GOTO GET.MASTER
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
    LOCATE CSRLIN - 1, 53
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
    IF MD%(0, 8) > AC THEN MD%(0, 8) = AC
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREASURE
    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
    TP = TP + AD%(A, 1)
NEXT.TREASURE:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
 '  PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
 '  PRINT
 '  PRINT "  Enter Path of Master ===> ";
 '  INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN KILL "ADVENT": RUN "WORLD"
    CLOSE
    GOSUB CHK.SUCCESS
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    CH = MD%(0, 3)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
    PRINT #1, MN$(0)
    PRINT #1, REC
    CLOSE
    RUN "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
QUIT.RTN:
    PRINT "Do you want to Quit this game? (Y/N) ";
    A$ = INPUT$(1)
    IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
    CLOSE
    END
CHK.SUCCESS:
    GOSUB CALC.BAL.OF.POWER
    IF BOP THEN RETURN
    PRINT
    PRINT "The balance of power was not corrected and the results were, shall we say   chaotic.": PRINT : PRINT "The kingdom was badly damaged."
    OPEN "CHARACT.DAT" FOR RANDOM AS #3 LEN = 256
    FIELD 3, 2 AS CF.NC$
    RSET CF.NC$ = MKI$(1)
    PUT #3, 1
    CLOSE 3
    RETURN
MISSION.OVER:
    PRINT
    PRINT " (PRESS ANY KEY)      ";
    A$ = INPUT$(1)
    PRINT
    RETURN
' --------------------------------------------------------------------------
MOVE.RTN:
    IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
	    IF TT = 0 THEN
		PGPRT 2, "It's not safe to turn your back here!"
		GOTO MAIN.LOOP
	    END IF
	END IF
    END IF
    D = C
    IF ROOM = 58 THEN XT = FNR(6): R2 = ABS(XT = D) * 59: IF R2 = 0 THEN PGPRT 2, "You bump into the wall.": GOTO MAIN.LOOP
    IF ROOM = 58 THEN GOTO MOVE.IT
    R2 = RD%(D)
    IF R2 > 100 AND R2 < 200 THEN GOTO PASSAGE.BLOCKED
    IF R2 = 78 AND MD%(27, 5) = ROOM THEN GOSUB CHK.IF.ARMED: IF W > 0 THEN PGPRT 2, MN$(27) + " won't let you go that way.": GOTO MAIN.LOOP
CHK.SPECIAL.MOVES:
    IF R2 > 0 AND R2 <= NR THEN GOTO MOVE.IT
'     /// SPECIAL MOVES
    IF R2 = -99 THEN PGPRT 2, "You have left the Dark Spire.": GOTO Game.Over
    IF R2 = 0 THEN GOTO CANT.GO
'    /// INSERT HERE SPECIAL ROOM MOVE CHECKING
    GOTO CANT.GO
CHK.IF.ARMED:
    W = 0:
    FOR X = 1 TO NA
	IF (AD%(X, 2) = 2 OR AD%(X, 2) = 3) AND AD%(X, 4) = -1 THEN W = W + 1
    NEXT
    RETURN
PASSAGE.BLOCKED:
    GT = R2 - 100
    IF AD%(GT, 4) <> ROOM THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You bump into the wall!"
    V%(ROOM) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    R3 = ROOM
    ROOM = R2
    GOSUB CHK.REACTIONS
    GET #1, ROOM
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(ROOM) > 1 THEN RD%(X) = ABS(RD%(X))
COUNT.EXITS:      ' COUNT.EXITS
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    NL = CVI(RF.LT$)
    LT = -1
    GOTO END.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
    IF MD%(M, 15) = 2 AND MD%(M, 5) = ROOM THEN GOTO MONSTER.NOT.HERE
    IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND 200 * RND(1) < MD%(M, 4)) THEN MD%(M, 5) = ROOM: GOTO ADD.SIDES
    IF M = 1 AND MD%(M, 5) = R3 THEN GOSUB PARTING.SHOT
MONSTER.REACTS:      ' MONSTER.REACTS
    IF MD%(M, 5) <> ROOM THEN GOTO MONSTER.NOT.HERE
    IF MD%(M, 14) > 0 THEN GOTO ADD.SIDES
    FR = MD%(M, 3)
    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > (100 * RND(1)) THEN MD%(M, 14) = 2: IF FR > (100 * RND(1)) THEN MD%(M, 14) = 3
ADD.SIDES:      ' ADD.SIDES
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
MONSTER.NOT.HERE:
    NEXT
    GOTO SET.NBTL
SET.NBTL:
    NBTL = (TD%(1) > 0)
    RETURN
PARTING.SHOT:
    PGPRT 2, "Demoniak hurls a fiery blast after you!"
    IF AD%(40, 4) = -1 THEN
	AD%(40, 4) = 0
	PGPRT 2, "The blast causes the mystic wand to crumble into dust."
	IF MD%(0, 9) = 40 THEN
	    MD%(0, 9) = -1
	END IF
    END IF
    RETURN
BRING.IN.BEASTS:
    MD%(M, 5) = ROOM
    MD%(M, 13) = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
    IF S$ = "ALL" THEN GOTO GET.ALL
    EMB = ROOM + 200
    WH = ROOM
    HA = ROOM
    GOSUB LOCATE.ARTIFACT
    IF Found = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
    IF (AD%(A, 2) = 2 OR AD%(A, 2) = 3) AND MD%(0, 9) = -1 THEN GOTO CALCULATE.ODDS
    GOTO GET.BACK
GET.ALL:      ' GET.ALL
    FOR A = 1 TO NA
    IF AD%(A, 4) <> ROOM OR AD%(A, 2) = 10 THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
    NEXT
    GOTO GET.BACK
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN 
    	ArmPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN 
    	ShdPtr = A
    	GOSUB Ready.Armor
    END IF	
    GT = 1
    IF A = 11 AND MD%(21, 5) = ROOM THEN PGPRT 2, "Gurroq gets mad!": MD%(21, 3) = 0: MD%(21, 14) = 0: GOSUB CHK.REACTIONS: A = 11: RETURN
    IF A = 22 THEN GT = 0: RETURN
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
RATTLE.MONSTER:      ' RATTLE.MONSTER
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM THEN
	PGPRT 1, MN$(M) + " is slightly unnerved!"
	MD%(M, 4) = MD%(M, 4) - 10
    END IF
    NEXT
    RETURN
SPECIAL.ROOM.CHK:      ' SPECIAL.ROOM.CHK
'    /// SPECIAL ROOM?
    GET #2, ROOM
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    V%(ROOM) = V%(ROOM) + 1
    RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
    Found = 0
    SL = LEN(S$)
    NM = UBOUND(MN$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN Found = Found + 1: M = X: IF S$ = MN$(X) THEN X = 9999
    NEXT
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
LOCATE.ARTIFACT:
    Found = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA) THEN Found = Found + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ARTIFACT
    IF Found = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
    WT = WT - AD%(A, 3)
    AD%(A, 4) = ROOM
    PGPRT 2, AN$(A) + " dropped."
    GOSUB DROP.SPECIAL
CHK.WGHT:      ' CHK.WGHT
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO GET.BACK
DROP.ALL:       ' DROP.ALL
    SR = ROOM
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 AND A <> ARMPTR THEN
	PGPRT 2, AN$(A) + " dropped."
	AD%(A, 4) = ROOM
	GOSUB DROP.SPECIAL
    END IF
    NEXT
    WT = 0
    GOTO CHK.DROP.WEAPON
DROP.SPECIAL:
    IF A = ARMPTR OR A = SHDPTR THEN GOSUB DROP.ARMOR
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
Drop.Armor:
    IF A = ArmPtr THEN ArmPtr = 0
    IF A = ShdPtr THEN ShdPtr = 0
    MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    EA = EA + AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
Ready.Armor:
    MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
    EA = EA - AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO GET.BACK
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF Found AND AD%(A, 4) = EMB THEN AD%(A, 4) = ROOM
    IF Found THEN GOSUB EXAMINE.ARTIFACT: GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF Found THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    FOR A = 1 TO NA
    IF AD%(A, 4) = 300 + ROOM THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO GET.BACK
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
    NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(ROOM) = 0
    GOTO GET.BACK
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    R = M + 100
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
    RETURN
SECRET.PASSAGE:
    RD%(X) = ABS(RD%(X))
    V%(ROOM) = 2
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:
'     === EXAM ART A
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    IF A = 9 THEN PGPRT 2, "It has a name tag that says 'Sleazak'.": RETURN
    GET #2, A + 100
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, 4) = ROOM
    RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF Found THEN GOTO ATTACK.MON
    TA = 0
    GOTO ASSAULT.ARTIFACT
ATTACK.MON:
    RL = FNR(1000)
    IF MD%(0, 6) > RL THEN PGPRT 2, "A mystic blast strikes out!": OF = 0: DF = M: D = 2: S = 6: A = 0: GOSUB DO.DAMAGE: GOTO GET.BACK
    IF MD%(0, 16) THEN PGPRT 2, "As a " + TH$(MD%(0, 16)) + " you would find that difficult!": GOTO MAIN.LOOP
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
MISSED:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, 10) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = ROOM AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, 4) = 0
    MD%(OF, 9) = A
    MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
    MD%(OF, 4) = MD%(OF, 4) * 2
    RETURN
TAKE.A.SWING:
    RL = FNR(100)
    IF MD%(OF, 9) = -1 THEN RL = 0
    IF MD%(OF, 2) > RL AND MD%(OF, 6) > 0 THEN GOTO MONSTER.MAGIC
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = ROOM
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
    END IF
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  a shard strikes " + MN$(OF) + "!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * INC
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF DF > 8 AND DF < 13 AND OF = 0 AND MD%(0, 9) = 6 THEN D2 = D2 + 2
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO DEAD.RTN
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:
    PGPRT 2, A$ + " is very badly injured."
    RETURN
DEATHS.DOOR:
    PGPRT 2, A$ + " is mortally wounded!!"
    RETURN
DEAD.RTN:
    IF DF = 0 THEN PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
IS.DEAD:
'    /// MONSTER DIES
    PGPRT 2, MN$(DF) + " is dead!"
    IF DF = 1 AND AD%(40, 4) = -1 THEN
	AD%(40, 4) = 0:
	PGPRT 2, "As Demoniak dies, the Mystic Wand loses its glow, and crumbles to dust."
	IF MD%(0, 9) = 40 THEN MD%(0, 9) = -1
    END IF
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF DF = 17 THEN RETURN
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = ROOM
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = ROOM: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
    IF DF = 0 THEN DIE = 1: GOTO Game.Over
    A2 = DF + NZ - NM
    AD%(A2, 4) = ROOM
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: Exit For
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = ROOM: PGPRT 1, " ... but can't find an exit!": RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF Found THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF Found THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF Found THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    IF A = SHDPTR OR A = ARMPTR THEN GOSUB DROP.ARMOR
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN
' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PRINT " " + AN$(A);
	IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
	IF A = Armptr THEN PRINT " (Worn Armour)";
	IF A = Shdptr THEN PRINT " (Your Shield)";
	PgPrt 1, " "
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    GOTO GET.BACK
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF Found = 0 THEN GOTO BLASTED.DOOR
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 5
    D = 2
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
    TA = 1
    GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF MD%(0, 16) THEN PGPRT 2, "A " + TH$(MD%(0, 16)) + " can't cast spells!": SUC = 0: RETURN
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "The spell fizzles.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
HEAL.WOUNDS:
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
    IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    RR = INT(RND(1) * 100 + 1)
    IF S$ = "ALPHA" OR S$ = "OMEGA" THEN GOTO ALPHA.OMEGA
    IF ROOM <> 1 THEN GOTO POWER.2
    PRINT
    FOR A = 1 TO NA
    IF AD%(A, 4) = ROOM THEN RAISE = 1: PGPRT 2, UCASE$(LEFT$(AN$(A), 1)) + MID$(AN$(A), 2) + " vanishes!": AD%(A, 4) = 0
    NEXT: IF RAISE THEN GOTO GET.BACK
POWER.2:
    RR = INT(100 * RND(1) + 1)
    IF S$ = "UP" THEN GOTO POWER.UP
    IF S$ = "DOWN" THEN GOTO POWER.DOWN
    IF RR < 45 THEN PGPRT 2, "You feel a strange mystic power enter your body.": S2%(4) = 2 * S2%(4): GOTO GET.BACK
    IF RR < 60 THEN GOTO POWER.ZOOM
    IF RR > 95 THEN PGPRT 2, "All of your wounds are healed.": MD%(0, 13) = 0: GOTO GET.BACK
    GOTO DO.SPEED
ANTIMAG.SPELL:
    IF AD%(9, 4) = -1 AND AD%(12, 4) = -1 AND AD%(16, 4) = -1 THEN
	PGPRT 2, "The teddy bear's eyes light up and he screams!"
	MD%(2, 6) = MD%(2, 6) / 2     ' was using field 2???
    END IF
    PGPRT 2, "Nothing happens.": GOTO MAIN.LOOP
POWER.ZOOM:
       PGPRT 2, "You feel a shift in magical energy."
       FOR X = 1 TO NM
	 MD%(X, 6) = MD%(X, 6) * 2    ' was using field 2???
       NEXT
       GOTO GET.BACK
POWER.UP:
       FOR X = 1 TO NM
	 MD%(X, 2) = INT(MD%(X, 2) * 1.1 + 2)
       NEXT
       PGPRT 2, "You feel an energy surge!"
       GOTO GET.BACK
POWER.DOWN:
       FOR X = 1 TO NM
	 MD%(X, 6) = INT(MD%(X, 6) * .9 - 2)     ' was using field 2??
       NEXT
       PGPRT 2, "You feel an energy drop!"
       GOTO GET.BACK
ALPHA.OMEGA:
     A = ABS(LEFT$(S$, 1) = "A") * 6 - 3
     FOR X = 1 TO 8:
       SP%(X) = SP%(X) + A
     NEXT
     PGPRT 2, "You feel a strange power fluctuation."
     GOTO GET.BACK
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
DO.SPEED:
    IF SPD THEN PGPRT 2, "Nothing happens.": GOTO GET.BACK
    MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2)
    MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
CONFUSE.SPELL:
    IF AD%(11, 4) <> -1 THEN GOTO MINDLESS.DRIVEL
    S$ = MID$(S$, 9)
    GOSUB MONSTER.SEARCH
    IF Found = 0 THEN S$ = "CONFUSE " + S$: GOTO MINDLESS.DRIVEL
    IF INT(RND(1) * 100 + 1) < 75 THEN PGPRT 2, "Nothing happens.": GOTO GET.BACK
    PGPRT 2, "A wave of strange flickering energy surrounds " + MN$(M) + "!"
    PGPRT 1, " --- confusing them."
    MD%(M, 18) = INT(RND(1) * 5 + 1)
    GOTO GET.BACK
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IV THEN GOTO GET.BACK
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, 5) = ROOM AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GROWLS:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    IF S$ = "ANTIMAG" AND MD%(2, 5) = ROOM THEN GOTO ANTIMAG.SPELL
    IF S$ = "TESTING 1-2-3" THEN Testing = -1
    IF S$ = "END TEST" THEN Testing = 0
    IF S$ = "DESTRAX" AND AD%(15, 4) = -1 AND AD%(11, 4) = -1 THEN
	FOR X = 3 TO NM
	  MD%(X, 6) = MD%(X, 6) / 2
	NEXT
	R = 6
	GOSUB PRINT.EFFECT
	GOTO GET.BACK
    END IF
    IF S$ = "XANARA SHEEN" THEN R = 35: GOSUB PRINT.EFFECT: DIE = -1: GOTO Game.Over
    IF S$ = "HOME" AND AD%(11, 4) = -1 THEN PGPRT 2, "You are mystically teleported to the entrance.": R2 = 1: GOTO MOVE.IT
    IF S$ = "ARMOUR-ON" AND MD%(0, 8) < 10 AND AD%(15, 4) = -1 THEN AR = MD%(0, 8): RK = FNR(15) + 25: MD%(0, 8) = 10: EA = 0: PGPRT 2, "A wall of solid light surrounds you!": GOTO GET.BACK
    IF S$ = "ESCAPE" AND ROOM = 58 THEN PGPRT 2, "Your body is violently wrenched out of place as you are teleported out of the Mystic chamber!": R2 = 59: GOTO MOVE.IT
    IF LEFT$(S$, 8) = "CONFUSE " THEN GOTO CONFUSE.SPELL
    IF S$ = "ELBBUR LA EVOMER" AND (AD%(27, 4) = ROOM OR AD%(28, 4) = ROOM OR AD%(29, 4) = ROOM) THEN AD%(27, 4) = 0: AD%(28, 4) = 0: AD%(29, 4) = 0: PGPRT 2, "The rubble vanishes as though it were an illusion!": GOTO GET.BACK
    IF S$ = WX$ THEN IF AD%(41, 4) = ROOM THEN GOTO BALANCE.POWER
    IF S$ = "SHAZAM" AND MD%(0, 17) > 0 THEN M = 0: GOSUB REVERSE.TRANS: GOTO MAIN.LOOP
    IF S$ = "MONITOR" THEN GOTO MONITOR.POWER
MINDLESS.DRIVEL:
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO GET.BACK
MONITOR.POWER:
    GOSUB CALC.BAL.OF.POWER
    PGPRT 2, "You feel two numbers from the Balance of Power equation pop into your head:"
    PGPRT 1, STR$(GOOD.GUYS) + " /" + STR$(BAD.GUYS)
    GOTO MAIN.LOOP
BALANCE.POWER:
    GOSUB CALC.BAL.OF.POWER
    IF BAD.GUYS = TOT.BAD THEN R = 28: GOSUB PRINT.EFFECT: GOTO GET.BACK
    R = 26
    GOSUB PRINT.EFFECT
    R = 27
    GOSUB PRINT.EFFECT
    GOTO GET.BACK
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = WH
    EMB = HA
    GOSUB LOCATE.ARTIFACT
    IF Found = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
' --------------------------------------------------------------------------
OPEN.RTN:
    GOSUB GET.SUBJ
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF Found = 0 THEN GOTO CHK.OPEN.DOOR
    IF AD%(A, 2) = 4 THEN GOTO OPEN.CONTAINER
    IF AD%(A, 2) = 7 THEN PGPRT 2, "Try reading it.": GOTO MAIN.LOOP
    IF AD%(A, 2) = 1 THEN PGPRT 2, "You'll make a mess. Wait till you leave.": GOTO MAIN.LOOP
    IF AD%(A, 2) = 8 THEN GOTO OPEN.DOOR
    PGPRT 2, "That's not what you do with it."
    GOTO MAIN.LOOP
OPEN.CONTAINER:
    IF AD%(A, 5) THEN IF AD%(AD%(A, 5), 4) <> -1 THEN PGPRT 2, "It's locked!": GOTO MAIN.LOOP
    LK = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = A + 100 THEN AD%(X, 4) = ROOM: LK = -1:
    NEXT
    PGPRT 2, "You find " + MID$("nosome", ABS(LK) * 2 + 1, 2 + 2 * ABS(LK)) + "thing inside."
    GOTO GET.BACK
CHK.OPEN.DOOR:  ' LABEL.CHK.OPEN.DOOR
    IF S$ = "DOOR" OR S$ = "GATE" THEN PGPRT 2, "It will open when you approach.": GOTO MAIN.LOOP
    PGPRT 2, "I don't know how to open " + LCASE$(S$) + "."
    GOTO MAIN.LOOP
OPEN.DOOR:
'    DOOR/GATE
    KEY.NO = AD%(A, 6)
    IF KEY.NO = 99 THEN GOSUB TRY.OPEN: IF OPEN.SW = 0 THEN PGPRT 2, "Mind telling me how?": GOTO MAIN.LOOP
    IF KEY.NO <> 0 THEN IF AD%(KEY.NO, 4) <> -1 THEN PGPRT 2, "It's locked!": GOTO MAIN.LOOP
    AD%(A, 6) = 0
    PGPRT 2, "You've opened the " + AN$(A) + "."
    FOR X = 1 TO ND
    IF RD%(X) = A + 100 THEN RD%(X) = AD%(A, 5)
    NEXT
    GOTO GET.BACK
TRY.OPEN:
    OPEN.SW = 0
    IF AD%(5, 4) = -1 THEN OPEN.SW = -1
    IF OPEN.SW THEN AD%(A, 6) = 0: KEY.NO = 0
    RETURN
ASSAULT.ARTIFACT:
    IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
CHK.OPEN.SPECIAL:
    RETURN
' --------------------------------------------------------------------------
PUT.RTN:
    IF S$ = "" THEN GOTO GET.PUT.DATA
    IF INSTR(S$, " INTO") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 6): GOTO PUT.AWAY
    IF INSTR(S$, " IN") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 3): GOTO PUT.AWAY
GET.PUT.DATA:      ' GET.PUT.DATA
    PGPRT 1, " "
    INPUT "Put what?", A$
    INPUT "Put into what?", B$
    PGPRT 2, ""
    GOTO PUT.AWAY
PUT.AWAY:
    S$ = A$
    GOSUB ARTIFACT.SEARCH
    IF Found = 0 THEN GOTO DONT.UNDERSTAND
    Z = A
    S$ = B$
    GOSUB ARTIFACT.SEARCH
    IF Found = 0 OR A = Z THEN GOTO PUT.WHAT
    IF AD%(A, 2) = 4 THEN AD%(X, 4) = A + 100: PGPRT 2, "Okay.": GOTO GET.BACK
PUT.WHAT:      ' PUT.WHAT
    PGPRT 2, "You can't do that."
    GOTO GET.BACK
' ---------------------------------------------------------------------------
READ.RTN:
    IF IC <> 0 AND DD = 0 THEN PGPRT 2, "You can't see.": GOTO MAIN.LOOP
    GOSUB GET.SUBJ
    WH = ROOM
    HA = -1
    EMB = ROOM + 200
    GOSUB LOCATE.ARTIFACT
    IF Found = 0 THEN GOTO READ.NONART
    IF AD%(A, 2) = 7 THEN GOTO READ.ARTIFACT
    PGPRT 2, "You can't read it."
    GOTO GET.BACK
READ.NONART:
'    /// NON-ART - INSERT HERE SPECIAL READING
'        EXAMPLE: READING WALLS OR CEILING, DOORS, ETC
    GOTO DONT.UNDERSTAND
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
    R = AD%(A, 5) + AD%(A, 7) - 1
    GOSUB PRINT.EFFECT
    AD%(A, 7) = AD%(A, 7) + 1
    IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
    GOTO GET.BACK
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + 200
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
' --------------------------------------------------------------------------
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF Found = 0 THEN GOTO DONT.UNDERSTAND
    IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> ROOM THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = ROOM THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = ROOM
    AD%(A, 4) = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
' ---------------------------------------------------------------------------
EAT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF Found = 0 THEN GOTO NOT.HUNGRY
    IF AD%(A, 2) <> FOOD.ART THEN GOTO NOT.HUNGRY
    PGPRT 2, "Okay. You eat the " + LCASE$(AN$(A)) + "."
    AD%(A, 4) = 0
    GOTO GET.BACK
NOT.HUNGRY:
    PGPRT 2, "You aren't THAT hungry!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
DRINK.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF Found = 0 THEN GOTO NOT.THIRSTY
    IF AD%(A, 2) = HEAL.ART THEN GOTO DRINK.HEAL
    IF AD%(A, 2) <> DRINK.ART THEN GOTO NOT.THIRSTY
    GOTO NOT.THIRSTY
DRINK.HEAL:
    AD%(A, 2) = 1
    AN$(A) = "empty " + AN$(A)
    S$ = ""
    GOTO HEAL.WOUNDS
NOT.THIRSTY:
    PGPRT 2, "You aren't THAT thirsty!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
WEAR.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF Found = 0 THEN GOTO DONT.WEAR
    IF A = 11 OR A = 12 OR A = 15 OR A = 16 THEN PGPRT 2, "Okay.": GOTO GET.BACK
    IF A = 30 THEN AR = MD%(0, 8): MD%(0, 8) = 8: RK = 0: PGPRT 2, "You've put on the armour.": GOTO GET.BACK
    IF A > 16 AND A < 22 THEN PGPRT 2, "Oh isn't that just ducky!!?": GOTO MAIN.LOOP
    IF AD%(A, 2) = ARMOR.ART THEN GOTO WEAR.ARMOR
    GOTO DONT.WEAR
WEAR.ARMOR:
    EA = -AD%(A, 5)
    MD%(0, 8) = AD%(A, 7)
    PGPRT 2, "Okay. You have put on the " + AN$(A) + "."
    GOTO GET.BACK
DONT.WEAR:
    PGPRT 2, "You can't wear that and stay respectable."
    GOTO MAIN.LOOP
PRESS.RTN:
    GOSUB GET.SUBJ
    IF (S$ = "BUTTON" OR S$ = "SECRET BUTTON") AND AD%(22, 4) = ROOM THEN GOTO PRESS.BUTTON
    IF S$ = "FORWARD" OR S$ = "ONWARD" THEN PGPRT 2, "Just give a direction, smart guy.": GOTO MAIN.LOOP
    GOTO DONT.UNDERSTAND
PRESS.BUTTON:
    IF ROOM = 31 AND AD%(3, 4) = ROOM THEN PGPRT 2, "There is a click and a hum. The wall opens ... ": AD%(3, 4) = 0: GOTO MAIN.LOOP
    IF ROOM = 31 THEN PGPRT 2, "The wall closes.": AD%(3, 4) = ROOM: GOTO GET.BACK
    GOTO DONT.UNDERSTAND
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\Eamon\COPY\SAVEGAME.BAS'
'        Eamon Save Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR OUTPUT AS #1
        PRINT #1, LT
        PRINT #1, LM
        PRINT #1, LC
        PRINT #1, LS
        PRINT #1, ROOM
        PRINT #1, SPD
        PRINT #1, TT
        PRINT #1, ArmNam$
        PRINT #1, ArmHit
        PRINT #1, ArmAdj
        PRINT #1, ShdNam$
        PRINT #1, ShdHit
        PRINT #1, ShdAdj
        PRINT #1, AE
        FOR X = 1 TO 4
        PRINT #1, SA%(4)
        NEXT
        FOR X = 1 TO 4
        PRINT #1, S2%(4)
        NEXT
        FOR X = 1 TO 5
        PRINT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        PRINT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        PRINT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        PRINT #1, V%(V)
        NEXT V
        PRINT #1, GOLD&
        PRINT #1, BANK&

    '------- (end of include file) -------    
 ' 
    FOR X = 1 TO NM
    PRINT #1, MN$(X)
    PRINT #1, MD%(X, 6)
    NEXT
    FOR X = 1 TO 8
    PRINT #1, SP%(X)
    NEXT
    PRINT "Game is saved. To restore it, use restore command."
    SAVED = -1
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\Eamon\COPY\RESTGAME.BAS'
'        Eamon Restore Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR INPUT AS #1
        INPUT #1, LT
        INPUT #1, LM
        INPUT #1, LC
        INPUT #1, LS
        INPUT #1, ROOM
        INPUT #1, SPD
        INPUT #1, TT
        INPUT #1, ArmNam$
        INPUT #1, ArmHit
        INPUT #1, ArmAdj
        INPUT #1, ShdNam$
        INPUT #1, ShdHit
        INPUT #1, ShdAdj
        INPUT #1, AE
        FOR X = 1 TO 4
        INPUT #1, SA%(X)
        NEXT
        FOR X = 1 TO 4
        INPUT #1, S2%(X)
        NEXT
        FOR X = 1 TO 5
        INPUT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        INPUT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        INPUT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        INPUT #1, V%(V)
        NEXT V
        INPUT #1, GOLD&
        INPUT #1, BANK&
    CLOSE 1

    '------- (end of include file) -------    
 ' 
    FOR M = 1 TO NM
    INPUT #1, MN$(M)
    INPUT #1, MD%(M, 6)
    NEXT
    FOR X = 1 TO 8
    INPUT #1, SP%(X)
    NEXT
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MOVE.IT
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
MONSTER.MAGIC:
      PGPRT 2, MN$(OF) + " casts a spell at " + MN$(DF) + "!"
      TF = FNR(100)
      ON INT(MD%(OF, 6) / LVL) GOTO LEVEL.1, LEVEL.2, LEVEL.3, LEVEL.4, LEVEL.5
LEVEL.1:
      FOR A = 1 TO 8
	 IF SP%(A) > TF THEN GOTO MONSTER.CASTS
      NEXT
      GOTO CAST.1
LEVEL.2:
     TF = TF + 15
     GOTO LEVEL.1
LEVEL.3:
     TF = TF + 20
     GOTO LEVEL.1
LEVEL.4:
     TF = TF + INT(RND(1) * 40)
     GOTO LEVEL.1
LEVEL.5:
     TF = TF + INT(RND(1) * 55)
     GOTO LEVEL.1
LEVEL.6:
     GOTO GET.BACK
MONSTER.CASTS:
     ON A GOTO CAST.1, CAST.2, CAST.3, CAST.4, CAST.5, CAST.6, CAST.7, CAST.8, CAST.9
CAST.1:
     PGPRT 2, "A burst of bright light strikes " + MN$(DF) + "!"
     D2 = 4
     GOTO APPLY.DAMAGE
CAST.2:
     IF MD%(DF, 9) > 0 THEN PGPRT 2, MN$(DF) + "'s weapon flies from his grasp!": AD%(MD%(DF, 9), 4) = ROOM: MD%(DF, 9) = -1: RETURN
     IF MD%(DF, 9) = 0 AND MD%(DF, 18) = 0 THEN PGPRT 2, MN$(DF) + " seems confused and bewildered!": MD%(DF, 18) = 3: RETURN
     PGPRT 2, MN$(DF) + " seems to slow down."
     MD%(DF, 7) = MD%(DF, 7) - 15
     RETURN
CAST.3:
     IF MD%(DF, 9) < 1 THEN GOTO CAST.2
     PGPRT 2, MN$(DF) + "'s weapon shatters!"
     AD%(MD%(DF, 9), 4) = 0
     MD%(DF, 9) = -1
     RETURN
CAST.4:
     RL = INT(RND(1) * 100 + 1): IF RL > 75 THEN GOTO CAST.5
     PGPRT 2, MN$(DF) + "'s armour creaks and you see cracks begin to form."
     MD%(DF, 8) = MD%(DF, 8) - 1
     IF MD%(DF, 8) < 2 THEN PGPRT 1, "--- it shatters!": MD%(DF, 8) = 0: IF DF = 0 THEN EA = 0
     RETURN
CAST.5:
     IF DF > 0 THEN PGPRT 2, MN$(DF) + " teleports somewhere!"
     MD%(DF, 5) = 58
     IF DF = 0 THEN RO = 58: R = 5: GOSUB PRINT.EFFECT
     GOTO CHK.REACTIONS
CAST.6:
     PGPRT 2, "A tremendous flash of radiant energy strikes " + MN$(DF) + "!"
     D = INT(RND(1) * MD%(OF, 6) / 300 + 1)
     S = INT(RND(1) * MD%(OF, 6) / 200 + 1)
     GOTO DO.DAMAGE
CAST.7:
     IF MD%(DF, 16) > 0 THEN GOTO CAST.6
     X = RND(1) * 9 + 1
     MD%(DF, 16) = X
     PGPRT 2, MN$(DF) + " turns into a " + TH$(X) + "!"
     MD%(DF, 16) = X
     M$(DF) = MN$(DF)
     MN$(DF) = MN$(DF) + " the " + TH$(X)
     R = MD%(DF, 14)
     TD%(R) = TD%(R) - MD%(DF, 1)
     FD%(R) = FD%(R) - MD%(DF, 13)
     MD%(DF, 17) = MD%(DF, 1)
     MD%(DF, 1) = X
     MD%(DF, 7) = 60
     TD%(R) = TD%(R) + MD%(DF, 1)
     MD%(DF, 13) = 0
     RETURN
CAST.8:
     PGPRT 2, " A swirling pillar of flame strikes " + MN$(DF) + "!"
     D = 2
     S = FNR(12)
     GOTO DO.DAMAGE
CAST.9:
     PGPRT 2, MN$(DF) + " suddenly grows old and dies!"
     MD%(DF, 13) = MD%(DF, 1)
     GOTO SHOW.CONDITION
THINK.RTN:
      TH = TH + 1
      IF TH > 11 THEN TH = 1
      R = TH + 13
      GOSUB PRINT.EFFECT
      IF R = 17 THEN PGPRT 2, WX$
      GOTO GET.COMMAND
' ---------------------------------------------------------------------------
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
READ.ART.REC: ' ------------- READ ARTIFACTS ---------------------
       OPEN PATH$ + "ARTIF.TXT" FOR RANDOM AS #3 LEN = 128
       DIM AF.DATA$(8)
       FIELD 3, 20 AS AF.NAME$, 2 AS AF.DATA$(1), 2 AS AF.DATA$(2), 2 AS AF.DATA$(3), 2 AS AF.DATA$(4), 2 AS AF.DATA$(5), 2 AS AF.DATA$(6), 2 AS AF.DATA$(7), 2 AS AF.DATA$(8)
       FOR A = 1 TO NA
       GET #3, A
       AN$(A) = AF.NAME$
       AN$(A) = RTRIM$(AN$(A))
       FOR A2 = 1 TO 8: AD%(A, A2) = CVI(AF.DATA$(A2)): NEXT A2
       IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE
       RETURN
READ.MON.REC: ' ------------- READ MONSTERS ---------------------
       OPEN PATH$ + "MONST.TXT" FOR RANDOM AS #3 LEN = 128
       DIM MF.DATA$(12)
       FIELD 3, 20 AS MF.NAME$
       FOR A2 = 1 TO 12
       FIELD 3, 20 AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM: GET #3, A: MN$(A) = RTRIM$(LEFT$(MF.NAME$, 1) + LCASE$(MID$(MF.NAME$, 2)))
       FOR A2 = 1 TO 12: MD%(A, A2) = CVI(MF.DATA$(A2)): NEXT A2
       IF MD%(A, 3) < 0 THEN MD%(A, 3) = ABS(MD%(A, 3)) - 1: MD%(A, 14) = 2
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC: ' ----------------- OPEN DESC FILE -------------------
       OPEN PATH$ + "DESC.TXT" FOR RANDOM AS #2 LEN = 256
       FIELD 2, 255 AS DESC$
       RETURN
OPEN.ROOM.NAMES: ' ---------------- OPEN ROOM NAMES -------------------
       OPEN PATH$ + "RMNAMES.TXT" FOR RANDOM AS #3 LEN = 64
       FIELD 3, 64 AS RN$
       RETURN
OPEN.ROOMS: ' ---------------- OPEN ROOMS FILE -------------------
       OPEN PATH$ + "ROOMS.TXT" FOR RANDOM AS #1 LEN = 64
       FOR D = 1 TO 6
       FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 12 AS X$, 2 AS RF.LT$
       RETURN

SUB PGPRT (SP, LIT$)

STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

