'                 Eamon Adventure #12
'
'                  Quest For Trezore
'
'                   By Jim Jacobson
'
'          Converted to IBM-PC by John Nelson
'
    ' +--------------------------------------------------------------+
    ' |                  Log of Program Changes                      |
    ' |                  ======================                      |
    ' |   Date     Version      Description of Change                |
    ' | --------   -------    -------------------------------------- |
    ' | 06/25/88    1.01      New  Give Routine installed            |
    ' |                                                              |
    ' | 10/28/89    1.02      Removed Dup Definition DIM MF.DATA$ in |
    ' |                       ADVENIO.BAS include file, put GOTO     |
    ' |                       GET.BACK after Save and Restore Rtns   |
    ' |                       corrected Light usage of LT variable   |
    ' |                       Also corrected inventory (single space)|
    ' |                       and close 3 for monster file (was 2)   |
    ' | 12/08/90    2.00      Added color screens, fixed adventio    |
    ' |                       was using an obsolete version. Also    |
    ' |                       used include file INPCTL which had been|
    ' |                       destroyed.                             |
    ' +--------------------------------------------------------------+
    DEFINT A-Z
    DECLARE SUB PGPRT (SP, LIT$)
REM $$INCL:'\eamon\copy\chardef.bas'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\copy\colorrtn.bas'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
    CLS
    ' LINE INPUT "Path:", PATH$
    RANDOMIZE TIMER
    CONST BRONZE.DOOR = 20
    CONST SCEPTRE = 1
    DEF FNR (X) = INT(X * RND(1) + 1)
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
    DIM AN$(NA + 6), AD%(NA + 6, ART.FLDS + 1)
    DIM AF.DATA$(ART.FLDS), RF.DIR$(ND + 4)
    DIM AX$(4)
    DIM MN$(NM), MD%(NM, 15)
    DIM FD%(3), TD%(3), SA%(4), WA%(5), S2%(4), RD%(6)
    DIM FWN$(4), FWT$(4), FWC$(4), FWD$(4), FWS$(4), FWA$(5), FSA$(4)
    DIM SX%(26): FOR J = 1 TO 26: SX%(J) = 0: NEXT J: CD = 0
    GOSUB READ.ARTIFACTS
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
    READ C$(C)
    NEXT
    DIM V%(NR)
    GOTO INITIALIZE.RTN
' -------------------------------------------------------------------
'
' -------------------------------------------------------------------
MAIN.LOOP:
    PGPRT 1, " "
    IF SPD > 0 THEN SPD = SPD - 1: IF SPD = 0 THEN MD%(0, 2) = MD%(0, 2) / 2: MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2): IF RND(1) > .8 THEN PGPRT 2, "Your Speed spell has just expired!"
' ----------------- SHOW ROOM -------------------
    IF ROOM >= 22 THEN
	IF AD%(17, 4) <> ROOM AND AD%(17, 4) <> -1 THEN
	    PGPRT 2, "It's too dark to see."
	    GOTO GET.COMMAND
	END IF
	IF LP > 0 THEN
	    LP = LP - 1
	    IF LP > 0 AND LP < 10 AND RND(1) > .5 THEN COLOR hfg%, hbg%: PGPRT 1, " The lamp is almost empty. ": COLOR fgc%, bgc%
	ELSE
	    PGPRT 2, "It's too dark to see."
	    GOTO GET.COMMAND
	END IF
    END IF
    IF V%(ROOM) = 0 THEN
	R = ROOM
	GET #2, R
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	V%(ROOM) = 1
    ELSE
	GET #3, ROOM
	A$ = RTRIM$(RN$)
	PGPRT 2, "You are " + A$
    END IF
' --------------------- SHOW MONSTER --------------------
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM THEN
	IF MD%(M, 15) = 0 THEN
	    GET #2, M + MON.ADJ
	    A$ = RTRIM$(DESC$)
	    PGPRT 2, A$
	    MD%(M, 15) = 1
	ELSE
	    PGPRT 2, MN$(M) + " is here."
	END IF
    END IF
    NEXT
' ----------------------- SHOW ARTIFACT ---------------------
    FOR A = 1 TO NZ
    IF AD%(A, 4) = ROOM THEN
	IF AD%(A, 9) = 0 THEN
	    GET #2, A + ART.ADJ
	    A$ = RTRIM$(DESC$)
	    PGPRT 2, A$
	    AD%(A, 9) = 1
	ELSE
	    PGPRT 2, "You see " + AN$(A) + "."
	END IF
    END IF
    NEXT
    FOR A = NZ + 1 TO NA
    IF AD%(A, 4) = ROOM THEN PGPRT 2, "Your " + AN$(A) + " is here."
    NEXT
' ------------------------- GET COMMAND -------------------------
GET.COMMAND:
    PGPRT 1, " "
    PGPRT 0, ""
    COLOR hfg%, hbg%
    PRINT " Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(A$))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 16: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    A$ = UCASE$(A$)
    IF A$ = "EXIT NOW" THEN GOTO Game.Over
    IF A$ = "LISTA" THEN
	FOR A = 1 TO NA
	  PGPRT 1, STR$(A) + ". " + AN$(A)
	NEXT
	GOTO GET.COMMAND
    END IF
    IF A$ = "LISTM" THEN
	FOR A = 1 TO NM
	  PGPRT 1, STR$(A) + ". " + MN$(A)
	NEXT
	GOTO GET.COMMAND
    END IF
    CZ$ = A$
    V$ = ""
    A = INSTR(A$, " ")
    IF A = 0 THEN
	V$ = A$
	S$ = ""
    ELSE
	V$ = LEFT$(A$, A - 1)
	S$ = MID$(A$, A + 1)
    END IF
    S$ = LTRIM$(S$)
    C = 0
    FOR X = 1 TO 6
    IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN C = X
    NEXT
    IF C > 0 THEN GOTO APPROP.RTN
    F = 0
    FOR X = 7 TO NC
    IF UCASE$(C$(X)) = V$ THEN
	C = X
	F = 1
	X = NC
    ELSE
	IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN
	    F = F + 1
	    C = X
	END IF
    END IF
    NEXT
    IF F = 1 THEN GOTO APPROP.RTN
LIST.COMMANDS:
    PRINT
    PRINT "Huh? I only understand these commands --- ";
    FOR C = 1 TO NC
    PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF C$(C) = S$ THEN S$ = V$: V$ = C$(C)
APPROP.RTN:
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 6 GOTO GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN, LOOK.RTN, ATTACK.RTN
    ON C - 12 GOTO FLEE.RTN, GIVE.RTN, INVENTORY.RTN, BLAST.SPELL, HEAL.SPELL
    ON C - 17 GOTO POWER.SPELL, SPEED.SPELL, SMILE.RTN, SMILE.RTN, SAY.SOMETHING
    ON C - 22 GOTO READ.RTN, READY.WEAPON, LIGHT.RTN, OPEN.RTN, USE.RTN
    ON C - 27 GOTO FREE.RTN, SAVE.GAME, RESTORE.GAME
GET.BACK:
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
    GOTO MAIN.LOOP
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
' -------------------------------------------------------------------
'
' -------------------------------------------------------------------
INITIALIZE.RTN:
    GOSUB READ.MONSTERS
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
    ROOM = 1
    ND = 6
    R2 = 1
    LP = 0
    SK = 0
    SC = 1
    AX$(1) = "REDSHOWERS"
    AX$(2) = "GREENGRASS"
    AX$(3) = "TUMBLEWEED"
    AX$(4) = "HOPSCOTCHS"
    CD = INT(RND(1) * 4 + 1)
    CD$ = AX$(CD)
    YY = CD
    CD = 0
    CO$ = ""
GEN.CODE:
    I = INT(RND(1) * 26 + 1)
    IF SX%(I) <> 0 THEN GOTO GEN.CODE
    CO$ = CO$ + CHR$(64 + I)
    SX%(I) = 1
    CD = CD + 1
    IF CD < 26 THEN GOTO GEN.CODE
    X$ = ""
    FOR J = 1 TO LEN(CD$)
      I = ASC(MID$(CD$, J, 1))
      IF I <> 32 THEN I = I - 64: X$ = X$ + MID$(CO$, I, 1)
    NEXT J
    CD$ = X$
    GOTO MOVE.IT
    DATA 30
    DATA North,South,East,West,Up,Down,Get,Take,Drop,Look,Examine,Attack,Flee
    DATA Give,Inventory,Blast,Heal,Power,Speed,Smile,Wave,Say,Read,Ready,Light
    DATA Open,Use,Free,Save,Restore
Game.Over:
    PRINT
    PRINT "     Press any key to continue ...  ";
    A$ = INPUT$(1)
    PRINT
CLOSE.DOWN:
    CLOSE
    IF SPD > 0 THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE THEN GOTO GET.MASTER
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
SELL.WEAPONS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell     (1-"; W2 - 1; ") "
GET.NBR.SELL:
    LOCATE CSRLIN - 1, 52
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO GET.NBR.SELL
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO SELL.WEAPONS
SELL.TREASURE:
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
	IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
	IF AD%(A, 4) = -1 THEN
	    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
	    TP = TP + AD%(A, 1)
	END IF
NEXT.TREASURE:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "     Press any key to continue ...  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
 '  PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
 '  PRINT
 '  PRINT "  Enter Path of Master ===> ";
 '  INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN
	CLOSE
	CLEAR
	OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
	CLOSE 1
	KILL PATH$ + "ADVENT"
	RUN PATH$ + "WORLD"
    END IF
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #2
    WRITE #2, MN$(0)
    WRITE #2, REC
    CLOSE
    CLEAR
    RUN PATH$ + "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
' -------------------------------------------------------------------
'                   Move Routine
' -------------------------------------------------------------------
MOVE.RTN:
    IF NBTL <> 0 THEN PGPRT 2, "You don't want to turn your back here.": PRINT : GOTO MAIN.LOOP
    R2 = RD%(C)
    IF R2 > 100 THEN GOTO PASSAGE.BLOCKED
CHK.MOVE:
    IF R2 > 0 THEN GOTO MOVE.IT
    IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO Game.Over
    IF R2 = 0 THEN GOTO CANT.GO
    GOTO CANT.GO
PASSAGE.BLOCKED:
    PBL = R2 - 100
    IF AD%(PBL, 7) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
    IF AD%(PBL, 6) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
    PGPRT 2, "The " + AN$(PBL) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(ROOM) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    IF ROOM > 46 AND ROOM < 54 AND AD%(6, 4) = ROOM THEN AD%(6, 4) = R2: GOTO CAN.PROCEED
    IF R2 > 46 AND R2 < 54 AND AD%(6, 4) = ROOM THEN AD%(6, 4) = R2: GOTO CAN.PROCEED
    IF R2 > 46 AND R2 < 54 AND AD%(6, 4) <> ROOM THEN PGPRT 2, "You can't walk on water!": GOTO GET.BACK
    IF ROOM = 38 AND MD%(4, 5) = ROOM THEN PGPRT 2, "You can't move!": GOTO GET.BACK
CAN.PROCEED:
    R3 = ROOM
    ROOM = R2
    GOSUB CHK.REACTIONS
    GET #1, ROOM
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(ROOM) > 1 THEN RD%(X) = ABS(RD%(X))
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    GOTO MAIN.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
    IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND FNR(200) < MD%(M, 4)) THEN MD%(M, 5) = ROOM: GOTO ADD.SIDE
    IF MD%(M, 5) <> ROOM THEN GOTO NEXT.REACT
    IF MD%(M, 14) THEN GOTO ADD.SIDE
    FR = MD%(M, 3)
    IF FR AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > FNR(100) THEN MD%(M, 14) = 2: IF FR > FNR(100) THEN MD%(M, 14) = 3
ADD.SIDE:
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
NEXT.REACT:
    NEXT M
    NBTL = (TD%(1) > 0)
    RETURN
GET.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO GET.ALL
    EMB = ROOM + 200
    WH = ROOM
    HA = ROOM
    GOSUB LOCATE.ART
    IF FOUND = 0 THEN PGPRT 2, "I see no " + S$ + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF NOT GT THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "It is too heavy for you.": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    SZ = SZ + AD%(A, 0)
    WT = WT + AD%(A, 3)
    IF AD%(A, 2) >= 2 AND AD%(A, 2) <= 3 AND MD%(0, 9) = -1 THEN GOTO READY.WEAPON
    GOTO GET.BACK
GET.ALL:
    PGPRT 1, " "
    FOR A = 1 TO NA
    IF AD%(A, 4) <> ROOM THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF NOT GT THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 1, AN$(A) + " is too heavy.": GOTO GET.NEXT
    PGPRT 2, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GET.SURPRISE:
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN 
    	ArmPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN 
    	ShdPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF A = 29 THEN XX = A: EF = 4: GOSUB PRINT.EFFECT: A = XX
    IF A = 26 THEN XX = A: EF = 6: GOSUB PRINT.EFFECT: A = XX: AD%(A, 4) = 0
    IF A = 29 OR A = 26 THEN GT = 0: RETURN
    GT = -1
' -1=successful get it ; 0=failure to get it
    RETURN
MONSTER.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = ROOM OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 999
    NEXT
    RETURN
ARTIFACT.SEARCH:
    WH = ROOM
    HA = -1
    EMB = ROOM
LOCATE.ART:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = EMB OR AD%(X, 4) = HA) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 999
    NEXT
    RETURN
GET.SUBJ:
    IF S$ = "" THEN PRINT : PRINT C$(C); " WHAT"; : INPUT S$: PGPRT 2, "": GOTO GET.SUBJ
    RETURN
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ART
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + S$ + "!": GOTO MAIN.LOOP
    GOSUB DROP.IT
CHK.WGHT:
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAP:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO GET.BACK
DROP.ALL:
    FOR A = 1 TO NA
        IF AD%(A, 4) = -1 AND A <> ArmPtr THEN 
            GOSUB DROP.IT	
       	END IF    
    NEXT A
    WT = 0
    GOTO CHK.DROP.WEAP
DROP.IT:
    IF A = ARMPTR OR A = SHDPTR THEN GOSUB DROP.ARMOR
    WT = WT - AD%(A, 3)
    PGPRT 1, AN$(A) + " dropped."
    AD%(A, 4) = ROOM
    RETURN
Drop.Armor:
    MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    EA = EA + AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
Ready.Armor:
    MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
    EA = EA - AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
LOOK.RTN:
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    IF (S$ = "WALL" OR S$ = "WRITING") AND ROOM = 8 THEN EF = 7: GOSUB PRINT.EFFECT: GOTO GET.BACK
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO CHK.LK.MON
    IF A = 21 THEN PGPRT 2, "The note says:": COLOR hfg%, hbg%: PGPRT 2, " " + CD$ + " ": COLOR fgc%, bgc%: PRINT : GOTO GET.BACK
    IF A = BRONZE.DOOR AND ROOM = 4 THEN EF = 8: GOSUB PRINT.EFFECT: GOTO GET.BACK
    IF A = 14 THEN PGPRT 2, "You cleverly avoid the poison dart in the lock on this chest.": AD%(15, 4) = ROOM: AD%(14, 4) = 0: AD%(24, 4) = ROOM: GOTO GET.BACK
    GOSUB EXAM.ART
    LK = -1
    AD%(A, 9) = 1
    IF AD%(A, 4) = EMB THEN AD%(A, 4) = ROOM
    IF LK THEN GOTO GET.BACK
CHK.LK.MON:
    GOSUB MONSTER.SEARCH
    IF FOUND <> 0 THEN GOSUB EXAM.MON: LK = -1
    IF LK THEN GOTO GET.BACK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
GENERAL.LOOK:
    IF ROOM = 8 THEN EF = 1: GOSUB PRINT.EFFECT: GOTO GET.BACK
    IF ROOM = 42 THEN EF = 5: GOSUB PRINT.EFFECT: GOTO GET.BACK
    IF ROOM = 8 THEN EF = 7: GOSUB PRINT.EFFECT
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND ABS(RD%(X)) <= NR THEN
	GOSUB FOUND.SECRET.PASSAGE
    END IF
    NEXT
    WH = ROOM + 300
    HA = WH
    EMB = WH
    GOSUB LOCATE.ART
    IF FOUND <> 0 THEN AD%(A, 4) = ROOM: PGPRT 2, "You found something.": GOTO GET.BACK
    V%(ROOM) = 0
    GOTO GET.BACK
EXAM.ART:
    GET #2, A + ART.DS
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
EXAM.MON:
    GET #2, M + MON.DS
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    RETURN
NOTHIN.TA.SEE:
    V%(ROOM) = 0
    GOTO GET.BACK
FOUND.SECRET.PASSAGE:
    PGPRT 2, "You found a secret passage " + C$(X) + "!"
    RD%(X) = ABS(RD%(X))
    V%(ROOM) = 2
    RETURN
ATTACK.RTN:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO CHK.ATT.ART
    GOTO ATTACK.MONSTER
CHK.ATT.ART:
    WH = ROOM
    HA = ROOM
    EMB = ROOM + 200
    GOSUB LOCATE.ART
    IF FOUND = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    IF AD%(A, 2) <> 8 AND AD%(A, 2) <> 4 THEN PGPRT 2, "Are you crazy?!": GOTO MAIN.LOOP
    S = 7
    K = 6
    IF AD%(A, 2) = 4 THEN S = S - 1: K = K - 1
    D2 = 0
    FOR X = 1 TO MD%(0, 11)
    D2 = D2 + FNR(MD%(0, 12))
    NEXT
    AD%(A, S) = AD%(A, S) - D2
    IF AD%(A, S) <= 0 THEN AD%(A, S) = 0: AD%(A, K) = 0: PGPRT 2, "The " + AN$(A) + " shatters!": GOTO GET.BACK
    PGPRT 2, "WHAM!! You hit the " + AN$(A) + "!"
    GOTO GET.BACK
ATTACK.MONSTER:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF NOT HIT THEN GOTO CHK.ATT.FRIEND
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF FNR(100) <= MD%(0, 10) THEN GOTO CHK.ATT.FRIEND
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
CHK.ATT.FRIEND:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT M
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
MON.GET.GUN:
    IF MD%(OF, 10) = 0 THEN RETURN
    FOR A = 1 TO NA
    IF AD%(A, 4) = ROOM AND (AD%(A, 2) = 2 OR AD%(A, 2) = 3) THEN PGPRT 1, MN$(OF) + " picks up " + AN$(A) + ".": AD%(A, 4) = 0: MD%(OF, 9) = A: MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5): MD%(OF, 4) = MD%(OF, 4) * 2: A = NA
    NEXT
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = FNR(100)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = -1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, "a miss.": RETURN
    PGPRT 1, "a Fumble!"
    FR = FNR(100)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "  fumble recovered.": RETURN
    IF FR < 76 THEN PGPRT 1, "  weapon dropped!": AD%(MD%(OF, 9), 4) = ROOM: MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5): MD%(OF, 9) = -1: MD%(OF, 4) = MD%(OF, 4) / 2: RETURN
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 2, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO HURT.SELF
    PGPRT 1, "  weapon broken!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN PGPRT 1, " ": RETURN
    PGPRT 1, "  broken weapon hurts user!"
HURT.SELF:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = (FNR(100) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * ABS(INC)
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A Critical Hit!"
    R2 = FNR(100)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + FNR(S)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF D2 < 1 THEN PGPRT 1, " blow bounces off armour!": RETURN
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO IS.DEAD
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    PGPRT 1, " "
    PRINT MN$(DF);
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:
    PGPRT 1, " is still in good shape."
    RETURN
HURTING:
    PGPRT 1, " is hurting."
    RETURN
IN.PAIN:
    PGPRT 1, " is in pain."
    RETURN
BADLY.INJURED:
    PGPRT 1, " is very badly injured!"
    RETURN
DEATHS.DOOR:
    PGPRT 1, " is at death's door, knocking loudly!"
    RETURN
IS.DEAD:
    PGPRT 1, MN$(DF) + " is dead!"
    IF DF = 1 THEN PGPRT 2, "As he dies, Zobar drops something!": AD%(12, 4) = ROOM
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = ROOM
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = ROOM: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
    IF DF = 0 THEN DIE = 1: GOTO Game.Over
    A2 = DF + NZ - NM
    AD%(A2, 4) = ROOM  ' PUT DEAD BODY IN ROOM
    RETURN
FLEE.RTN:
    IF NOT NBTL THEN PGPRT 2, "There's no reason to run!": GOTO MAIN.LOOP
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: Exit For
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = ROOM: PGPRT 1, " ... but can't find an exit!": RETURN
    D = FNR(ND)
    R2 = RD%(D)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    IF A = ARMPTR OR A = SHDPTR THEN GOSUB DROP.ARMOR
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN
INVENTORY.RTN:
    PGPRT 2, "You are carrying the following ---"
    A0 = 0
    FOR A = 1 TO NA
        IF AD%(A, 4) = -1 THEN 
            PRINT " " + AN$(A);
            IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
            IF A = ArmPtr THEN PRINT " (Worn Armor)";
            IF A = ShdPtr THEN PRINT " (Your Shield)";
        END IF    
    NEXT
    GOTO GET.BACK
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO CANT.BLAST
    S = 1
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 6
    D = 1
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
CANT.BLAST:
    PGPRT 2, "You can't Blast " + S$ + "!"
    GOTO MAIN.LOOP
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = FNR(100): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN GOTO FORGET.IT
    IF NOT SUC THEN PGPRT 2, "Nothing happened.": RETURN
    RL = FNR(100)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) / 2
    RETURN
FORGET.IT:
    PGPRT 2, "The strain of attempting to cast this spell overloads your brain and you      forget it completely."
    SA%(S) = 0
    RETURN
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
DO.HEAL:
    PGPRT 1, " "
    IF MD%(0, 13) THEN PGPRT 1, "Some of your wounds seem to clear up."
    MD%(0, 13) = MD%(0, 13) - FNR(10)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    DF = 0
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
GEN.POWER:
    X = FNR(8)
    ON X GOTO POW.1, POW.2, POW.3, POW.4, POW.5, POW.6, POW.7, POW.8
POW.1:
    GOTO DO.HEAL
POW.2:
    PGPRT 2, "A strange blue gas filled the room, then disappeared."
    FOR J = 1 TO 3: S2%(J) = SA%(J): NEXT J: GOTO GET.BACK
POW.3:
    IF RND(1) > .4 THEN GOTO POW.10
    PGPRT 2, "A green mist erupted from the floor. It seems to have corroded your armour and weapons."
    FOR J = 1 TO NA
	IF (AD%(J, 4) = ROOM OR AD%(J, 4) = -1) AND AD%(J, 2) > 1 AND RND(1) > .5 THEN
	    AD%(J, 5) = AD%(J, 5) - (INT(RND(1) * 10 + 10))
	    IF AD%(J, 7) = 1 THEN AD%(J, 8) = AD%(J, 8) - INT(RND(1) * 3 + 1): RETURN
	    AD%(J, 7) = AD%(J, 7) - 1
	END IF
    NEXT J
    GOTO GET.BACK
POW.4:
    HIT = 0
    FOR J = 1 TO NM
	IF MD%(J, 14) = 1 AND MD%(J, 5) = ROOM THEN HIT = 1
    NEXT J
    IF HIT = 0 THEN GOTO POW.10
    PGPRT 2, "Something strange happened!"
    FOR J = 1 TO NM
	IF MD%(J, 5) = ROOM AND MD%(J, 14) = 1 THEN MD%(J, 14) = 0: MD%(J, 3) = 5: R3 = ROOM: GOSUB CHK.REACTIONS
    NEXT J
    GOTO GET.BACK
POW.5:
    GOTO DO.SPEED
POW.6:
    PGPRT 2, "Nothing seems to happen."
    MD%(0, 9) = -1
    GOTO GET.BACK
POW.7:
    PGPRT 2, "The scene shifts and you find yourself elsewhere in the dungeon."
    R2 = INT(RND(1) * 40) + 1
    GOTO CAN.PROCEED
POW.8:
    PGPRT 2, "A ball of fire erupts from nowhere, hurting everyone in the room."
    DF = 0
    A = 0
    S = 6
    D = 1
    GOSUB DO.DAMAGE
    FOR J = 1 TO NM
    IF MD%(J, 5) = ROOM THEN DF = J: A = 0: S = 6: D = 1: GOSUB DO.DAMAGE
    NEXT J
    GOTO GET.BACK
POW.9:
    PGPRT 2, "You suddenly drop all your artifacts and weapons!"
    FOR J = 1 TO NA: IF AD%(J, 4) = -1 THEN AD%(J, 4) = ROOM
    NEXT J
    GOTO GET.BACK
POW.10:
    HIT = 0
    FOR J = 1 TO NA
    IF AD%(J, 4) = -1 AND RND(1) > .8 THEN
	PGPRT 1, AN$(J) + " vanishes!"
	AD%(J, 4) = 45
	HIT = 1
	IF ROOM = 45 THEN AD%(J, 4) = INT(RND(1) * 50 + 1)
    END IF
    NEXT J
    IF HIT THEN PGPRT 1, " ": GOTO GET.BACK
    GOTO GEN.POWER
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
DO.SPEED:
    IF SPD = 0 THEN MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2): MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + FNR(25) + 10
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
SMILE.RTN:
    PGPRT 1, " "
    FOR M = 1 TO NM
    IF MD%(M, 5) = ROOM THEN ON MD%(M, 14) GOSUB GROWL, IGNORE, SMILE
    NEXT
    PRINT
    GOTO GET.BACK
GROWL:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORE:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILE:
    PGPRT 1, MN$(M) + " " + LCASE$(V$) + "s back."
    RETURN
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    IF S$ = "SEORK" AND AD%(1, 4) = -1 THEN EF = 2: GOSUB PRINT.EFFECT: GOTO GET.BACK
    IF S$ = "KROES" AND AD%(1, 4) = -1 THEN PGPRT 2, "The glow vanished from the sceptre.": SC = 0: GOTO GET.BACK
    PGPRT 2, "Okay, " + CHR$(34) + LCASE$(S$) + CHR$(34)
    GOTO GET.BACK
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ART
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF A = ZOBARS.SCEPTRE AND SC = 1 THEN EF = 2: GOSUB PRINT.EFFECT: GOTO GET.BACK
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a legal weapon!": GOTO MAIN.LOOP
    MD%(0, 10) = (EA + AE) * (-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
LIGHT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN PGPRT 2, "I don't know what you mean.": GOTO MAIN.LOOP
    IF A = 17 AND LP > 0 THEN PGPRT 2, "The lamp is now off.": LP = -LP: GOTO GET.BACK
    IF A = 17 AND LP < 0 THEN PGPRT 2, "The lamp is now on.": LP = -LP: GOTO GET.BACK
    PGPRT 2, "There is no oil in the lamp."
    GOTO GET.BACK
USE.RTN:
    GOSUB GET.SUBJ
    IF S$ = "RODS" THEN S$ = "ROD"
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN PGPRT 2, "I don't know what you mean.": GOTO MAIN.LOOP
    IF A <> 18 THEN GOTO USE.ROD
    IF A = 18 AND AD%(17, 4) <> ROOM AND AD%(17, 4) <> -1 THEN PGPRT 2, "You don't have anything to use it in!": GOTO GET.BACK
    PGPRT 2, "The lamp is now filled."
    LP = INT(RND(1) * 75) + 85
    AD%(23, 4) = -1
    AD%(18, 4) = 0
    LP = -LP
    GOTO GET.BACK
USE.ROD:
    IF LEFT$(S$, 3) <> "ROD" THEN GOTO USE.PICK
    IF AD%(10, 4) = -1 AND AD%(11, 4) = -1 AND AD%(12, 4) = -1 THEN EF = 3: GOSUB PRINT.EFFECT: GOTO MAGIC.ROOM
    PGPRT 2, "Nothing happened."
    GOTO GET.BACK
USE.PICK:
    IF A <> 2 THEN GOTO USE.SCEPTRE
    IF ROOM = 45 AND AD%(28, 4) = 0 THEN PGPRT 2, "You found something after digging awhile.": AD%(28, 4) = ROOM: AD%(11, 4) = ROOM: GOTO GET.BACK
    IF ROOM < 54 AND ROOM > 46 THEN PGPRT 2, "OOPS! You just punched a hole in the boat. You are drowned!": DIE = -1: GOTO Game.Over
    PGPRT 2, "You find nothing here."
    GOTO GET.BACK
USE.SCEPTRE:
    IF S$ = "TREZORE'S SCEPTER" OR S$ = "ZOBAR'S SCEPTER" THEN A = 1
    IF A = 1 AND AD%(1, 4) = -1 AND SC = 1 THEN EF = 2: GOSUB PRINT.EFFECT: GOTO GET.BACK
    IF A = 1 AND AD%(28, 4) = -1 THEN PGPRT 2, "It doesn't appear to do anything.": GOTO GET.BACK
    PGPRT 2, "I don't know what you mean."
    GOTO GET.BACK
OPEN.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 OR A <> 15 THEN
	PGPRT 2, "Mind telling me how?"
	GOTO GET.BACK
    END IF
    IF AD%(15, 4) = ROOM OR AD%(15, 4) = -1 THEN PGPRT 2, "The chest is already open.": GOTO GET.BACK
    EF = 9
    GOSUB PRINT.EFFECT
    GOTO GET.BACK
MAGIC.ROOM:
    PGPRT 2, "You are in a large room. a glaring light prevents you from seeing very far."
    PGPRT 1, "as you look around, a voice suddenly booms out:"
    PGPRT 1, " "
    COLOR hfg%, hbg%: PGPRT 1, " TELL ME THE CODE! ": COLOR fgc%, bgc%: PGPRT 1, " "
    PGPRT 1, " "
    PRINT "(Enter the code now):"; : INPUT "", A$
    IF UCASE$(A$) = UCASE$(AX$(YY)) THEN GOTO TREZORE.HELPS
    COLOR hfg%, hbg%
    PGPRT 2, "You are wrong!  You obviously are not a crafty adventurer, and Trezore has nothing to do with you!!": COLOR fgc%, bgc%
    FOR J = 1 TO 5: WA%(J) = INT(WA%(J) * .75): NEXT J
    FOR J = 1 TO NA
    IF AD%(J, 4) = -1 AND RND(1) > .7 THEN AD%(J, 4) = 0
    NEXT J
    PGPRT 2, "You suddenly find yourself outside the Main Hall."
    GOTO Game.Over
TREZORE.HELPS:
    COLOR hfg%, hbg%
    PRINT 2, " The mighty Trezore sees that you are a worthy adventurer, and so he will help"
    PRINT 1, "    you. Your captured friend is freed.   ";
    COLOR fgc%, bgc%
    PRINT 2, "You suddenly find yourself outside the Main Hall."
    GOLD& = GOLD& + 1000
    PGPRT 2, "You received 1000 gold pieces for freeing your friend."
    GOTO Game.Over
READ.RTN:
    GOTO LOOK.RTN
PRINT.EFFECT:
    GET #2, EF + EFF.DS
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    ON EF GOSUB NOTHIN.SPECIAL, SCEPTRE.BURNS, RODS, VINES.ALIVE, EXAMINE.42, MOLE.APPEARS, READ.CODE, LOOK.DOOR, OPEN.CHEST
    RETURN
NOTHIN.SPECIAL:
    RETURN
SCEPTRE.BURNS:
    S = 6
    D = 1
    A = 0
    DF = 0
    GOSUB DO.DAMAGE
    AD%(1, 4) = 0
    RETURN
RODS:
    RETURN
VINES.ALIVE:
    MD%(4, 5) = ROOM
    R3 = ROOM
    GOSUB CHK.REACTIONS
    AD%(29, 4) = 0
    RETURN
EXAMINE.42:
    RETURN
MOLE.APPEARS:
    MD%(18, 5) = ROOM: R3 = ROOM: GOSUB CHK.REACTIONS: RETURN
READ.CODE:
    COLOR hfg%, hbg%
    PRINT CO$;
    COLOR fgc%, bgc%
    PRINT
    PRINT
    RETURN
LOOK.DOOR:
    RETURN
OPEN.CHEST:
    S = 4
    D = 2
    A = 0
    DF = 0
    FOR J = 1 TO NM
    IF MD%(J, 5) = ROOM AND RND(1) > .6 THEN DF = J: J = NM
    NEXT
    PGPRT 1, " "
    GOSUB DO.DAMAGE
    AD%(15, 4) = ROOM
    AD%(14, 4) = 0
    AD%(24, 4) = ROOM
    RETURN
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN PGPRT 2, "I don't understand.": GOTO MAIN.LOOP
    IF AD%(A, 2) <> 10 THEN PGPRT 2, "I don't understand.": GOTO MAIN.LOOP
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> ROOM THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = ROOM THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = ROOM
    AD%(A, 4) = 0
    R3 = ROOM
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\Eamon\COPY\ADVENIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVENIO2.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '       Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       uses User defined types to define records, reads records
        '       to input data into variables.
        '    *  This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = LEN(Artifact)
       FOR A = 1 TO NA
       GET #3, A, Artifact
       AN$(A) = RTRIM$(Artifact.Nam$)
       AD%(A, 1) = Artifact.value
       AD%(A, 2) = Artifact.typ
       AD%(A, 3) = Artifact.Weight
       AD%(A, 4) = Artifact.room
       AD%(A, 5) = Artifact.Odds
       AD%(A, 6) = Artifact.wpntyp
       AD%(A, 7) = Artifact.Dice
       AD%(A, 8) = Artifact.Sides
       IF Artifact.typ > 1 AND Artifact.typ < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = 128
       FOR A = 1 TO NM
       GET #3, A, Monster
       IF Monster.Friend < 0 THEN
           Monster.Friend = ABS(Monster.Friend) - 1
           MD%(A, 14) = 2
       END IF
       MN$(A) = RTRIM$(Monster.Nam$)
       MD%(A, 1) = Monster.Hd
       MD%(A, 2) = Monster.Ag
       MD%(A, 3) = Monster.Friend
       MD%(A, 4) = Monster.Courage
       MD%(A, 5) = Monster.Room
       MD%(A, 6) = Monster.Weight
       MD%(A, 7) = Monster.DefOdds
       MD%(A, 8) = Monster.Armor
       MD%(A, 9) = Monster.Weapon
       MD%(A, 10) = Monster.OffOdds
       MD%(A, 11) = Monster.Dice
       MD%(A, 12) = Monster.Sides
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = 256
       FIELD 2, 256 AS DESC$
       RETURN
OPEN.ROOMS:    ' ---------------- OPEN ROOM NAMES -------------------
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = LEN(Rm)
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = 64
       FIELD 3, 64 AS RMN$
       RETURN
Read.Room:
       GET #3, Room
       RN$ = RTRIM$(RMN$)
       GET #1, Room, Rm
       RD%(1) = Rm.North
       RD%(2) = Rm.South
       RD%(3) = Rm.East
       RD%(4) = Rm.West
       RD%(5) = Rm.Up
       RD%(6) = Rm.Down
       RD%(7) = Rm.NE
       RD%(8) = Rm.NW
       RD%(9) = Rm.SE
       RD%(10) = Rm.SW
       RETURN
'------- (end of include file) -------

    '------- (end of include file) -------    
 ' 
SAVE.GAME:
    INPUT "File Name:", GAME.ID$
REM $$INCL:'\Eamon\COPY\SAVEGAME.BAS'
'        Eamon Save Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR OUTPUT AS #1
        PRINT #1, LT
        PRINT #1, LM
        PRINT #1, LC
        PRINT #1, LS
        PRINT #1, ROOM
        PRINT #1, SPD
        PRINT #1, TT
        PRINT #1, ArmNam$
        PRINT #1, ArmHit
        PRINT #1, ArmAdj
        PRINT #1, ShdNam$
        PRINT #1, ShdHit
        PRINT #1, ShdAdj
        PRINT #1, AE
        FOR X = 1 TO 4
        PRINT #1, SA%(4)
        NEXT
        FOR X = 1 TO 4
        PRINT #1, S2%(4)
        NEXT
        FOR X = 1 TO 5
        PRINT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        PRINT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        PRINT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        PRINT #1, V%(V)
        NEXT V
        PRINT #1, GOLD&
        PRINT #1, BANK&

    '------- (end of include file) -------    
 ' 
    CLOSE 1
    GOTO GET.BACK
RESTORE.GAME:
    INPUT "File Name:", GAME.ID$
REM $$INCL:'\Eamon\COPY\RESTGAME.BAS'
'        Eamon Restore Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR INPUT AS #1
        INPUT #1, LT
        INPUT #1, LM
        INPUT #1, LC
        INPUT #1, LS
        INPUT #1, ROOM
        INPUT #1, SPD
        INPUT #1, TT
        INPUT #1, ArmNam$
        INPUT #1, ArmHit
        INPUT #1, ArmAdj
        INPUT #1, ShdNam$
        INPUT #1, ShdHit
        INPUT #1, ShdAdj
        INPUT #1, AE
        FOR X = 1 TO 4
        INPUT #1, SA%(X)
        NEXT
        FOR X = 1 TO 4
        INPUT #1, S2%(X)
        NEXT
        FOR X = 1 TO 5
        INPUT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        INPUT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        INPUT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        INPUT #1, V%(V)
        NEXT V
        INPUT #1, GOLD&
        INPUT #1, BANK&
    CLOSE 1

    '------- (end of include file) -------    
 ' 
    CLOSE 1
    GOTO GET.BACK

SUB PGPRT (SP, LIT$)
    STATIC LINE.PG
    IF SP = 0 THEN LINE.PG = 0: EXIT SUB
    IF LIT$ = "" THEN LINE.PG = LINE.PG + SP: EXIT SUB
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	LINE.PG = LINE.PG + 1
	NEXT
    END IF
    IF LINE.PG > 20 THEN
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-")
	A$ = INPUT$(1)
	LOCATE CSRLIN - 1, 1
	PRINT SPC(79);
	LINE.PG = 0
    END IF
    PRINT LIT$
    LINE.PG = LINE.PG + LEN(LIT$) / 79 + 1
END SUB

