'
'                 Eamon-QB Adventure #7
'                   The Devil's Tomb
'
'                    by Jim Jacobson
'
'
'
'
    DEFINT A-Z
    DECLARE SUB PGPRT (SP, LIT$)
REM $$INCL:'\eamon\copy\chardef.bas'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\Eamon\COPY\COLORRTN.BAS'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
    CLS
    DEF FNR (X) = INT(RND(1) * X) + 1
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
    DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MN$(NM), MD%(NM, 16)
    GOSUB READ.ARTIFACTS ' LOAD ARTIFACT TABLE
    GOSUB READ.MONSTERS ' LOAD MONSTER TABLE
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
    READ C$(C)
    NEXT
    R2 = 1
    CONST KM.HARD = 1
    CONST KM.AGIL = 2
    CONST KM.FRIEND = 3
    CONST KM.COURAGE = 4
    CONST KM.ROOM = 5
    CONST KM.WT = 6
    CONST KM.D.ODDS = 7
    CONST KM.ARMOR = 8
    CONST KM.WEAPON = 9
    CONST KM.O.ODDS = 10
    CONST KM.DICE = 11
    CONST KM.SIDES = 12
    CONST KM.DAMAGE = 13
    CONST KM.REACTION = 14
    CONST KM.STATUS = 15
    CONST KA.VALUE = 1
    CONST KA.TYPE = 2
    CONST KA.WEIGHT = 3
    CONST KA.ROOM = 4
    CONST KH.GOLDEN.APPLE = 6
    CONST KH.DEVILS.TRIDENT = 3
    CONST KH.IRON.DOOR = 2
    CONST GOLD.ART = 0
    CONST TREASURE.ART = 1
    CONST WEAPON.ART = 2
    CONST MAG.WEAPON = 3
    CONST CONTAIN.ART = 4
    CONST LIGHT.ART = 5
    CONST HEAL.ART = 6
    CONST READ.ART = 7
    CONST DOOR.ART = 8
    CONST KEY.ART = 9
    CONST BOUND.MON.ART = 10
    CONST ARMOR.ART = 11
    CONST FOOD.ART = 12
    CONST DRINK.ART = 13            ' DRINKABLE ARTIFACT --- PUT IN YOUR OWN EFFECTS
    CONST KT.MONSTER.DISGUISED = 14
    CONST KT.TRAP = 15
    GOTO INITIALIZE
DONT.UNDERSTAND:
    PGPRT 2, "I don't understand."
' ---------------------------------------------------------------------------
MAIN.LOOP:
'    = MAIN =
    IF SPD THEN
	SPD = SPD - 1
	IF SPD = 0 THEN
	    MD%(0, KM.AGIL) = MD%(0, KM.AGIL) / 2:
	    MD%(0, KM.O.ODDS) = MD%(0, KM.O.ODDS) - 2 * MD%(0, KM.AGIL)
	    PGPRT 2, "Your Speed Spell has just expired!"
	END IF
    END IF
    IF IV THEN
	PGPRT 2, "You're invisible."
	VC = VC + 1
	IF VC > 5 THEN
	   VC = 0
	   D2 = 3
	   DF = 0
	   GOSUB APPLY.DAMAGE
       END IF
   END IF
   IF MD%(0, KM.D.ODDS) > 0 THEN MD%(0, KM.D.ODDS) = MD%(0, KM.D.ODDS) - 1
SHOW.ROOM:      ' SHOW.ROOM
    IF V%(Room) <> 0 THEN GET #3, Room: A$ = RTRIM$(RN$): PGPRT 2, "You are " + A$
    IF V%(Room) = 0 THEN GOSUB SPECIAL.ROOM.CHK
    IF Room = 43 THEN GOTO Game.Over
    IF Room = 44 OR Room = 45 THEN DIE = 1: GOTO Game.Over
    FOR M = 1 TO NM
    IF MD%(M, KM.ROOM) = Room THEN
	IF MD%(M, KM.STATUS) = 1 THEN PGPRT 2, MN$(M) + " is here."
	IF MD%(M, KM.STATUS) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
	IF MD%(M, KM.STATUS) = 0 THEN
	    GET #2, M + MON.ADJ
	    A$ = RTRIM$(Desc$)
	    PGPRT 2, A$
	    MD%(M, KM.STATUS) = 1
	END IF
    END IF
    NEXT
    FOR A = 1 TO NZ
    IF AD%(A, KA.ROOM) <> Room THEN GOTO NEXT.ART
    IF AD%(A, 9) THEN
	PGPRT 2, "You see " + AN$(A) + "."
    ELSE
	GET #2, A + ART.ADJ
	A$ = RTRIM$(Desc$)
	PGPRT 2, A$
	AD%(A, 9) = 1
    END IF
NEXT.ART:      ' NEXT.ART
    NEXT
    FOR A = A TO NA
    IF AD%(A, KA.ROOM) = Room THEN
	PGPRT 2, "Your " + AN$(A) + " is here."
    END IF
    NEXT
    PRINT
GET.COMMAND:      ' GET.COMMAND
    PGPRT 0, ""
    PRINT
    COLOR hfg%, hbg%
    PRINT "  Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
'    IF UCASE$(A$) = "LEAVE" THEN GOTO GAME.OVER
'    IF UCASE$(A$) = "DIE" THEN DIE = 1: GOTO GAME.OVER
    A$ = LTRIM$(RTRIM$(UCASE$(A$)))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    IF A$ = "EXIT NOW" THEN GOTO Game.Over
    CZ$ = A$
    A = INSTR(A$, " ")
    IF A = 0 THEN A = LEN(A$) + 1
    V$ = LEFT$(A$, A - 1)
    S$ = MID$(A$, A + 1)
    S$ = LTRIM$(S$)
    C = 0
    FOR A = 1 TO ND
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
    NEXT
    IF C <> 0 THEN GOTO BRANCH.RTN
    F = 0
    FOR A = ND + 1 + 4 * ABS(ND = 6) TO NC
    IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	F = F + 1
	C = A
	IF F > 1 THEN C = 0: A = NC
    END IF
    NEXT
    IF C = 0 THEN GOTO LIST.COMMANDS
    GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
    PRINT
    PRINT "Huh? I only understand these commands ... "
    FOR C = 1 TO NC
    IF ND = 6 AND C > 6 AND C < 11 THEN C = 11 ELSE PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 5 GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 10 GOTO GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN
    ON C - 14 GOTO LOOK.RTN, ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN
    ON C - 19 GOTO BLAST.SPELL, HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN
    ON C - 24 GOTO SMILE.RTN, SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN
    ON C - 29 GOTO SAVE.GAME, RESTORE.GAME, CASINO.ROOM, QUIT.RTN
GET.BACK:      ' GET.BACK
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
    GOTO MAIN.LOOP
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
' ---------------------------------------------------------------------------
INITIALIZE:
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
    Room = 1
    GOTO MOVE.IT
    DATA 33
    DATA North,South,East,West,Up,Down
    DATA NE,NW,SE,SW
    DATA Get,Take,Drop,Look,Examine
    DATA Attack,Flee,Give,Inventory
    DATA Blast,Heal,Power,Speed,Smile
    DATA Wave,Say,Read,Ready,Open
    DATA Save,Restore,Bet,Quit
' ---------------------------------------------------------------------------
Game.Over:      ' GAME.OVER
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    IF SPD THEN MD%(0, KM.AGIL) = MD%(0, KM.AGIL) / 2
    IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
    END IF
    IF DIE <> 0 THEN GOTO GET.MASTER
    GOSUB CHK.SUCCESS
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, KA.TYPE) > 1 AND AD%(A, KA.TYPE) < 4 AND AD%(A, KA.ROOM) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, KA.ROOM) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
    LOCATE CSRLIN - 1, 53
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
    AD%(WP%(W5), KA.ROOM) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
    IF MD%(0, KM.ARMOR) > AC THEN MD%(0, KM.ARMOR) = AC
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
      IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
      IF AD%(A, KA.ROOM) = -1 THEN
	  IF AD%(A, KA.TYPE) <> 0 THEN AD%(A, KA.VALUE) = AD%(A, KA.VALUE) * CH / 10
	  TP = TP + AD%(A, KA.VALUE)
      END IF
NEXT.TREASURE:      
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
  ' PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
  ' PRINT
  ' PRINT "  Enter Path of Master ===> ";
  ' INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN
	OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
	WRITE #1, "BYE"
	CLOSE
	CLEAR
	KILL PATH$ + "ADVENT":
	RUN PATH$ + "WORLD"
    END IF
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, KM.HARD)
    AG = MD%(0, KM.AGIL)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
    PRINT #1, MN$(0)
    PRINT #1, REC
    CLOSE
    CLEAR
    RUN PATH$ + "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
QUIT.RTN:
    PRINT "Do you want to Quit this game? (Y/N) ";
    A$ = INPUT$(1)
    IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
    CLOSE
    END
CHK.SUCCESS:
'   --------- insert code to check for successful completion --------------
MISSION.OVER:
    PRINT
    PRINT " (PRESS ANY KEY)      ";
    A$ = INPUT$(1)
    PRINT
    RETURN
' --------------------------------------------------------------------------
MOVE.RTN:
    IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
	    IF TT = 0 THEN
		PGPRT 2, "You can't do that with unfriendlies about!"
		GOTO MAIN.LOOP
	    END IF
	END IF
    END IF
    IF Room = 42 AND AD%(2, KA.ROOM) AND C = 4 THEN PGPRT 2, "An iron door blocks the way.": GOTO GET.BACK
    IF Room = 1 AND AD%(1, KA.ROOM) THEN PGPRT 2, "You can't walk through doors, stupid!": GOTO GET.BACK
    D = C
    R2 = RD%(D)
    GOSUB DecodeRoom
    IF Rmcd = 1 THEN GOTO PASSAGE.BLOCKED
CHK.SPECIAL.MOVES:
    IF R2 > 0 AND R2 <= NR THEN GOTO MOVE.IT
    IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO Game.Over
    IF R2 = 0 THEN GOTO CANT.GO
    GOTO CANT.GO
PASSAGE.BLOCKED:
    GT = ACT.ROOM
    IF AD%(GT, KA.ROOM) <> Room THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(Room) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    R3 = Room
    Room = R2
    GOSUB CHK.REACTIONS
    GET #1, Room
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(Room) > 1 THEN RD%(X) = ABS(RD%(X))
COUNT.EXITS:      ' COUNT.EXITS
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    LT = -1
    GOTO END.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, KM.HARD)
    FD%(1) = 0
    FD%(3) = MD%(0, KM.DAMAGE)
    IF IV THEN NBTL = 0: RETURN
    FOR M.1 = 1 TO NM
    IF MD%(M.1, KM.STATUS) = 2 AND MD%(M.1, KM.ROOM) = Room THEN GOTO MONSTER.NOT.HERE
    IF MD%(M.1, KM.ROOM) = R3 THEN
	IF MD%(M.1, KM.REACTION) = 3 OR (MD%(M.1, KM.REACTION) = 1 AND 200 * RND(1) < MD%(M.1, KM.COURAGE)) THEN MD%(M.1, KM.ROOM) = Room: GOTO ADD.SIDES
    END IF
MONSTER.REACTS:
    IF MD%(M.1, KM.ROOM) <> Room THEN GOTO MONSTER.NOT.HERE
    IF MD%(M.1, KM.REACTION) > 0 THEN GOTO ADD.SIDES
    FR = MD%(M.1, KM.FRIEND)
    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M.1, KM.REACTION) = 1
    IF FR > (100 * RND(1)) THEN MD%(M.1, KM.REACTION) = 2: IF FR > (100 * RND(1)) THEN MD%(M.1, KM.REACTION) = 3
ADD.SIDES:
    A = MD%(M.1, KM.REACTION)
    FD%(A) = FD%(A) + MD%(M.1, KM.DAMAGE)
    TD%(A) = TD%(A) + MD%(M.1, KM.HARD)
MONSTER.NOT.HERE:
    NEXT
    GOTO SET.NBTL
SET.NBTL:
    NBTL = (TD%(1) > 0)
    RETURN
BRING.IN.BEASTS:
    MD%(M, KM.ROOM) = Room
    MD%(M, KM.DAMAGE) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    RETURN
DecodeRoom:
    Select Case R2
        Case 1 To Max.Rm
            Rmcd = 0
            R = R2
        Case Ins.Adj + 1 To Ins.Adj + Max.Art
            Rmcd = 1
            R = R2 - Ins.Adj
        Case Emb.Adj + 1 To Emb.Adj + Max.Rm
            Rmcd = 2
            R = R2 - Emb.Adj
        Case Hid.Adj + 1 To Hid.Adj + Max.Rm
            Rmcd = 3
            R = R2 - Hid.Adj
        Case Bury.Adj + 1 To Bury.Adj + Max.Rm
            Rmcd = 4
            R = R2 - Bury.Adj
        Case Is < 0
            Rmcd = -1
            R = Abs(R2) - 1
        Case Else
    End Select
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
    IF S$ = "ALL" THEN GOTO GET.ALL
    EMB = Room + EMB.ADJ
    WH = Room
    HA = Room
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    MON.APP = 0
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, KA.WEIGHT) > 10 * MD%(0, KM.HARD) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, KA.ROOM) = -1
    WT = WT + AD%(A, KA.WEIGHT)
    IF (AD%(A, KA.TYPE) = 2 OR AD%(A, KA.TYPE) = 3) AND MD%(0, KM.WEAPON) = -1 THEN GOTO CALCULATE.ODDS
    GOTO GET.BACK
GET.ALL:
    MON.APP = 0
    FOR A = 1 TO NA
    IF AD%(A, KA.ROOM) <> Room OR AD%(A, KA.TYPE) = 10 THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, KM.HARD) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, KA.ROOM) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
    NEXT
    GOTO GET.BACK
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN 
    	ArmPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN 
    	ShdPtr = A
    	GOSUB Ready.Armor
    END IF	
    GT = 1
    IF AD%(A, KA.TYPE) = KT.MONSTER.DISGUISED THEN
	M = AD%(A, 5)
	R = AD%(A, 6)
	GOSUB PRINT.EFFECT
	AD%(A, KA.ROOM) = 0
	GOSUB FIND.MONSTER
	GT = 0
    END IF
    IF AD%(A, KA.TYPE) = KT.TRAP THEN
	R = AD%(A, 6)
	GOSUB PRINT.EFFECT
	IF FNR(100) > AD%(A, 5) THEN
	    D = AD%(A, 7)
	    S = AD%(A, 8)
	    GOSUB DO.DAMAGE
	END IF
	AD%(A, KA.ROOM) = 0
	GT = 0
    END IF
    IF A = KH.DEVILS.TRIDENT THEN
	 PGPRT 2, "As you touch the pitchfork, it glows bright red and burns you."
	 S = 6
	 D = 1
	 DF = 0
	 A = 0
	 GOSUB DO.DAMAGE
	 GT = 0
	 RETURN
     END IF
     IF A = KH.GOLDEN.APPLE THEN
	 PGPRT 2, "The apple explodes as you touch it!"
	 AD%(A, 4) = 0
	 D = 2
	 S = 4
	 DF = 0
	 EFF.ARM = 0
	 GOSUB DO.DAMAGE
	 GT = 0
	 RETURN
    END IF
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
RATTLE.MONSTER:      ' RATTLE.MONSTER
    FOR M = 1 TO NM
    IF MD%(M, KM.ROOM) = Room THEN
	PGPRT 1, MN$(M) + " is slightly unnerved!"
	MD%(M, KM.COURAGE) = MD%(M, KM.COURAGE) - 10
    END IF
    NEXT
    RETURN
SPECIAL.ROOM.CHK:
    GET #2, Room
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    V%(Room) = V%(Room) + 1
    RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.MONSTER:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, KM.ROOM) = WH OR MD%(X, KM.ROOM) = HA OR MD%(X, KM.ROOM) = EMB) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 9999
    NEXT
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.ARTIFACT:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, KA.ROOM) = WH OR AD%(X, KA.ROOM) = HA OR AD%(X, KA.ROOM) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
    WT = WT - AD%(A, 3)
    AD%(A, KA.ROOM) = Room
    PGPRT 2, AN$(A) + " dropped."
    GOSUB DROP.SPECIAL
CHK.WGHT:      ' CHK.WGHT
    IF WT > 10 * MD%(0, KM.HARD) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
    IF MD%(0, KM.WEAPON) > 0 THEN IF AD%(MD%(0, KM.WEAPON), KA.ROOM) <> -1 THEN MD%(0, KM.WEAPON) = -1
    GOTO GET.BACK
DROP.ALL:       ' DROP.ALL
    SR = Room
    FOR A = 1 TO NA
    IF AD%(A, KA.ROOM) = -1 AND A <> ARMPTR THEN
	PGPRT 2, AN$(A) + " dropped."
	AD%(A, KA.ROOM) = Room
	GOSUB DROP.SPECIAL
    END IF
    NEXT
    WT = 0
    GOTO CHK.DROP.WEAPON
DROP.SPECIAL:
    IF IV THEN GOSUB RATTLE.MONSTER
    IF A = ArmPtr OR A = ShdPtr THEN GOSUB DROP.ARMOR
    IF A = LS THEN LS = 0: LC = 0: LM = 0: LT = NL: PgPrt 2, "The " + AN$(A) + " goes out."
    RETURN
Drop.Armor:
    IF A = ArmPtr THEN ArmPtr = 0
    IF A = ShdPtr THEN ShdPtr = 0
    MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    EA = EA + AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
Ready.Armor:
    MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
    EA = EA - AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO GET.BACK
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND THEN IF AD%(A, KA.ROOM) = EMB THEN AD%(A, KA.ROOM) = Room
    IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO GET.BACK
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.MONSTER
    IF FOUND THEN IF MD%(M, KM.ROOM) = EMB THEN MD%(M, KM.ROOM) = Room: GOSUB CHK.REACTIONS
    IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    IF Room = 33 THEN PGPRT 2, "You see a secret passage to the south!       You push the stone blocks away and are in a stone corridor!": R2 = 39: GOTO MOVE.IT
    FOR A = 1 TO NA
    IF AD%(A, KA.ROOM) = HID.ADJ + Room THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    FOR M = 1 TO NM
	IF MD%(M, KM.ROOM) = HID.ADJ + Room THEN LK = -1: GOSUB FIND.MONSTER
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO GET.BACK
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
    NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(Room) = 0
    GOTO GET.BACK
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    R = M + MAX.EFF
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
    RETURN
SECRET.PASSAGE:
    RD%(X) = ABS(RD%(X))
    V%(Room) = 2
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:
'     === EXAM ART A
    IF AD%(A, KA.TYPE) = KT.MONSTER.DISGUISED THEN
	M = AD%(A, 5)
	R = AD%(A, 6)
	GOSUB PRINT.EFFECT
	GOSUB FIND.MONSTER
    END IF
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    GET #2, A + ART.ADJ
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, KA.ROOM) = Room
    RETURN
FIND.MONSTER:
    LK = -1
    MD%(M, KM.ROOM) = Room
    FR = MD%(M, KM.FRIEND)
    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, KM.REACTION) = 1
    IF FR > (100 * RND(1)) THEN MD%(M, KM.REACTION) = 2: IF FR > (100 * RND(1)) THEN MD%(M, KM.REACTION) = 3
    REAC = MD%(M, KM.REACTION)
    FD%(REAC) = FD%(REAC) + MD%(M, KM.DAMAGE)
    TD%(REAC) = TD%(REAC) + MD%(M, KM.HARD)
    NBTL = (TD%(1) > 0)
    RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOTO ATTACK.MONSTER
    PGPRT 2, "Attack who?": GOTO MAIN.LOOP
ATTACK.MONSTER:
    IF MD%(0, KM.WEAPON) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, KM.WEAPON), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF INT(100 * RND(1) + 1) <= MD%(0, KM.O.ODDS) THEN GOTO MISSED
    EFF.ARM = 2
    IF EA + AE = -1 THEN EFF.ARM = 1
    AE = AE + EFF.ARM
    MD%(0, KM.O.ODDS) = MD%(0, KM.O.ODDS) + EFF.ARM
MISSED:
    IF MD%(DF, KM.REACTION) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, KM.FRIEND) = MD%(DF, KM.FRIEND) / 2
    FOR M = 1 TO NM
    IF MD%(M, KM.ROOM) = Room AND MD%(M, KM.REACTION) > 1 THEN MD%(M, KM.REACTION) = 0
    NEXT
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, KM.O.ODDS) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF AD%(X, KA.ROOM) = Room AND (AD%(X, KA.TYPE) = 2 OR AD%(X, KA.TYPE) = 3) THEN A = X: X = NA
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, KA.ROOM) = 0
    MD%(OF, KM.WEAPON) = A
    MD%(OF, KM.O.ODDS) = MD%(OF, KM.O.ODDS) + AD%(A, 5)
    MD%(OF, KM.COURAGE) = MD%(OF, KM.COURAGE) * 2
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, KM.WEAPON) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, KM.O.ODDS) - MD%(DF, KM.D.ODDS)) AND RL < 96 THEN HIT = 1
    IF HIT = 0 AND MD%(DF, KM.D.ODDS) > MD%(OF, KM.O.ODDS) / 2 THEN PGPRT 1, MN$(DF) + " dodges out of the way!"
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, KM.WEAPON) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, KM.WEAPON), KA.ROOM) = Room
	MD%(OF, KM.O.ODDS) = MD%(OF, KM.O.ODDS) - AD%(MD%(OF, KM.WEAPON), 5)
	MD%(OF, KM.WEAPON) = -1
	MD%(OF, KM.COURAGE) = MD%(OF, KM.COURAGE) / 2
	RETURN
    END IF
    IF MD%(OF, KM.WEAPON) > 0 THEN W = MD%(OF, KM.WEAPON): IF AD%(W, KA.TYPE) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, KM.WEAPON), KA.ROOM) = 0
    MD%(OF, KM.O.ODDS) = MD%(OF, KM.O.ODDS) - AD%(MD%(OF, KM.WEAPON), 5)
    MD%(OF, KM.WEAPON) = -1
    MD%(OF, KM.COURAGE) = MD%(OF, KM.COURAGE) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, KM.DICE)
    S = MD%(OF, KM.SIDES)
    DF = OF
    EFF.ARM = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, KM.DICE) * 2
    S = MD%(OF, KM.SIDES)
    DF = OF
    EFF.ARM = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, KM.O.ODDS))
    MD%(OF, KM.O.ODDS) = MD%(OF, KM.O.ODDS) + 2 * INC
    D = MD%(OF, KM.DICE)
    S = MD%(OF, KM.SIDES)
    EFF.ARM = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN EFF.ARM = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    D2 = D2 - EFF.ARM * MD%(DF, KM.ARMOR)
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, KM.DAMAGE) = MD%(DF, KM.DAMAGE) + D2
    IF MD%(DF, KM.DAMAGE) >= MD%(DF, KM.HARD) THEN GOTO DEAD.RTN
    REAC = MD%(DF, KM.REACTION)
    FD%(REAC) = FD%(REAC) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, KM.DAMAGE) * 5 / MD%(DF, KM.HARD) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:      ' HURTING
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:      ' IN.PAIN
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:      ' BADLY.INJURED
    PGPRT 2, A$ + " is very badly injured."
    RETURN
DEATHS.DOOR:      ' DEATHS.DOOR
    PGPRT 2, A$ + " is at death's door, knocking loudly."
    RETURN
DEAD.RTN:
    IF DF = 0 THEN PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
IS.DEAD:      ' IS.DEAD
'    /// MONSTER DIES
    PGPRT 2, MN$(DF) + " is dead!"
    REAC = MD%(DF, KM.REACTION)
    FD%(REAC) = FD%(REAC) + MD%(DF, KM.HARD) - MD%(DF, KM.DAMAGE) + D2
    MD%(DF, KM.ROOM) = 0
    IF DF = 17 THEN RETURN
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
    NEXT
    IF MD%(DF, KM.WEAPON) > 0 THEN AD%(MD%(DF, KM.WEAPON), KA.ROOM) = Room: MD%(DF, KM.O.ODDS) = MD%(DF, KM.O.ODDS) - AD%(MD%(DF, KM.WEAPON), 5): MD%(DF, KM.WEAPON) = -1: MD%(DF, KM.COURAGE) = MD%(DF, KM.COURAGE) / 2
GET.BODY:
    IF DF = 0 THEN DIE = 1: GOTO Game.Over
    A2 = DF + NZ - NM
    AD%(A2, KA.ROOM) = Room
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    IF Room = 43 THEN R2 = 39: GOTO MOVE.IT
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: Exit For
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    IF A = ARMPTR OR A= SHDPTR THEN GOSUB DROP.ARMOR
    IF A = KH.DEVILS.TRIDENT THEN PGPRT 2, "As " + MN$(M) + " touches it, it burns them!": POP = -1: RETURN
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN

' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PRINT " " + AN$(A);
	IF A = MD%(0,9) THEN PRINT " (Ready weapon)";
	IF A = ArmPtr THEN PRINT " (Worn Armor)";
	IF A = ShdPtr THEN PRINT " (Your Shield)";
	PGPRT 1, " "
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    GOTO GET.BACK
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO CANT.BLAST
BLAST.MONSTER:
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 5
    D = 2
    DF = M
    EFF.ARM = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
CANT.BLAST:
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
HEAL.WOUNDS:
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
    IF MD%(M, KM.DAMAGE) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, KM.DAMAGE) = MD%(M, KM.DAMAGE) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, KM.DAMAGE) < 0 THEN MD%(M, KM.DAMAGE) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    RR = INT(RND(1) * 100 + 1)
    IF RR > 70 THEN GOTO POWER.1
    RAISE = 0
    FOR M = 1 TO NM
      GOSUB RAISE.DEAD
    NEXT M
    IF RAISE THEN R3 = Room: GOSUB CHK.REACTIONS: GOTO GET.BACK
    PGPRT 1, " "
    FOR A = 1 TO NA
      IF AD%(A, 4) = Room THEN RAISE = 1: PGPRT 1, AN$(A) + " vanishes!": AD%(A, 4) = 0
    NEXT A
    IF RAISE THEN PRINT : GOTO GET.BACK
    RR = FNR(100)
    IF RR < 11 THEN PGPRT 2, "The section of tunnel you are in collapses and you die.": DIE = 1: GOTO Game.Over
    IF RR < 86 THEN PGPRT 2, "You hear a very loud sonic boom that echoes through the tunnels.": GOTO GET.BACK
    IF RR > 95 AND MD%(0, KM.DAMAGE) > 0 THEN PGPRT 2, "All of your hits are healed.": MD%(0, KM.DAMAGE) = 0: GOTO GET.BACK
    GOTO DO.SPEED
POWER.1:
    X = INT(RND(1) * 3 + 1)
    ON X GOTO POWER1A, POWER1B, POWER1C
POWER1A:
    PGPRT 2, "A strange hissing noise erupts from the floor beneath you, but you see nothing.": GOTO GET.BACK
POWER1B:
    PGPRT 2, "A flash of light is seen in the distance, but nothing happens.": GOTO GET.BACK
POWER1C:
    PGPRT 2, "A high-pitched whistle whines in your ears, but nothing happens.": GOTO GET.BACK
RAISE.DEAD:
    M2 = NZ - NM + M
    IF AD%(M2, KA.ROOM) = Room OR AD%(M2, KA.ROOM) = -1 THEN
	PGPRT 2, MN$(M) + " comes to life!!"
	RAISE = -1
	MD%(M, KM.DAMAGE) = 0
	MD%(M, KM.ROOM) = Room
	IF AD%(M2, KA.ROOM) = -1 THEN WT = WT - AD%(M2, KA.WEIGHT)
	AD%(M2, KA.ROOM) = 0
     END IF
     RETURN
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    IF SPD <> 0 THEN PGPRT 2, "Nothing Happens.": GOTO MAIN.LOOP
DO.SPEED:
    MD%(0, KM.O.ODDS) = MD%(0, KM.O.ODDS) + 2 * MD%(0, KM.AGIL)
    MD%(0, KM.AGIL) = 2 * MD%(0, KM.AGIL)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IV THEN GOTO GET.BACK
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, KM.ROOM) = Room AND MD%(M, KM.STATUS) <= 1 THEN
	  ON MD%(M, KM.REACTION) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GROWLS:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    IF S$ = "NEAMO" AND Room = 9 THEN
	PGPRT 2, "The red square glows bright red as you say the word. Suddenly, the scene"
	PGPRT 1, "around you changes and you find yourself teleported somewhere in the dungeon."
	R2 = INT(RND(1) * 30 + 1)
	GOTO MOVE.IT
    END IF
    IF S$ = "TREZORE" AND TRZ THEN GOTO TREZORE.SPELL
    PGPRT 2, "Okay, " + CHR$(34) + LCASE$(S$) + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO GET.BACK
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = WH
    EMB = HA
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF A = KH.DEVILS.TRIDENT THEN
	PGPRT 2, "As you touch the Trident, it glows and disappears after frying your hands.":
	S = 6
	D = 1
	DF = 0
	EFF.ARM = 0
	GOSUB DO.DAMAGE
	AD%(3, 4) = 0
	GOTO GET.BACK
    END IF
    IF AD%(A, KA.TYPE) < WEAPON.ART OR AD%(A, KA.TYPE) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, KM.O.ODDS) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, KM.WEAPON) = A
    MD%(0, KM.DICE) = AD%(A, 7)
    MD%(0, KM.SIDES) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
' ---------------------------------------------------------------
CASINO.ROOM:
    BET.ON = 0
    IF Room <> 36 THEN PGPRT 2, "You are not in the casino!": GOTO GET.BACK
    Bet.Amt = VAL(S$)
    WHILE Bet.Amt <= 0
      INPUT "How much to bet?", A$
      Bet.Amt = VAL(A$)
    WEND
CHK.BET:
    BET.ON = 0
    FOR T = 1 TO 3
	 IF MID$("HAC", T, 1) = LEFT$(S$, 1) THEN BET.ON = T: T = 3
    NEXT
    IF BET.ON = 0 THEN GOTO BET.WHAT
    GOTO DO.BET
BET.WHAT:
    PRINT "What to bet on (Hardiness, Agility, or Charisma)";
    INPUT S$
    S$ = UCASE$(S$)
    GOTO CHK.BET
DO.BET:
    IF BET.ON = 3 AND Bet.Amt > CH THEN PRINT "You don't have that much.": GOTO GET.BACK
    IF BET.ON < 3 AND MD%(0, BET.ON) < Bet.Amt THEN PGPRT 2, "You don't have that much.": GOTO GET.BACK
    CLS
    PRINT "------------------- The Wheel is Spinning ----------------"
    X = FNR(10) + 18
    FOR I = 1 TO X
       X = FNR(100)
       X$ = " >> LOSE << ": BR = 0
       IF X > 93 THEN X$ = "    DEATH   ": BR = 99
       IF X > 55 THEN X$ = "  ** WIN ** ": BR = 1
       IF X < 2 THEN X$ = "-- DOUBLE --": BR = 2
       SOUND 610, 1
	LOCATE 5, ((80 - LEN(X$)) / 2)
	IF BR = 99 THEN COLOR 0, 7
	PRINT X$
	COLOR 7, 0
	FOR J = 1 TO I * 40: NEXT J
	LOCATE 5, 35
	PRINT "           ";
	FOR J = 1 TO 5: NEXT J
      NEXT I
      LOCATE 1, 1
      PRINT SPC(69);
      LOCATE 7, 1
      IF BR = 0 THEN PGPRT 2, "You lose!!!!!": GOTO LOSE.BET
      IF BR = 2 THEN PGPRT 2, "You win double!!!": Bet.Amt = Bet.Amt * 2: X$ = "  ** WIN **  "
      IF BR = 99 THEN PGPRT 2, "You have lost your life!!!": DIE = 1: GOTO Game.Over
      LOCATE 10, 1
      PRINT "You have won "; Bet.Amt
      IF BET.ON = 3 THEN
	  CH = CH + Bet.Amt
	  IF CH > 24 THEN CH = 24
	  GOTO GET.BACK
      END IF
      MD%(0, BET.ON) = MD%(0, BET.ON) + Bet.Amt
      IF MD%(0, BET.ON) > 24 THEN MD%(0, BET.ON) = 24
      GOTO GET.BACK
LOSE.BET:
      IF BET.ON = 3 THEN CH = CH - Bet.Amt: GOTO GET.BACK
      MD%(0, BET.ON) = MD%(0, BET.ON) - Bet.Amt
      GOTO GET.BACK
READ.RTN:
     GOSUB GET.SUBJ
     IF S$ = "INSCRIPTION" THEN PGPRT 2, "The inscription is in a foreign tongue that you cannot read.": GOTO GET.BACK
     WH = -1
     HA = -1
     EMB = -1
     GOSUB LOCATE.ARTIFACT
     IF A = 14 THEN PGPRT 2, "The book says:": GOTO READ.TREZORE
     IF A = 18 THEN PGPRT 2, "The book is unreadable.": GOTO GET.BACK
     IF A = 17 THEN PGPRT 2, "The scroll crumbles as you unroll it.": AD%(17, 4) = 0: GOTO GET.BACK
     IF A = 11 THEN PGPRT 2, "The label is worn, but you can make out the letters        'MAG C  G S'.": GOTO GET.BACK
     PGPRT 2, "There are no markings to read!": GOTO GET.BACK
READ.TREZORE:
     COLOR 0, 7
     PGPRT 1, "This book contains the spells fo Trezore the great and powerful. You may use the "
     PRINT 1, "powers of Trezore by saying the magic word 'Trezore'. May the power of Trezore do you no harm.                        "
     COLOR 7, 0
     PGPRT 2, "The book then vanishes before your eyes!"
     AD%(14, 4) = 0
     TRZ = FNR(50) + 25
     GOTO GET.BACK
DOOR.TOO.HEAVY:
     IF WT THEN PGPRT 2, "The door is too heavy for you to open!": GOTO GET.BACK
     PRINT
     COLOR 0, 7
     PRINT "The door swings open!"
     COLOR 7, 0
     AD%(2, 4) = 0
     GOTO GET.BACK
TREZORE.SPELL:
     IF FNR(100) > TRZ THEN PGPRT 2, "Nothing happened.": GOTO GET.BACK
     IF FNR(100) > 98 THEN PGPRT 2, "You suddenly find that you teleported into a wall. You cannot breathe in solid": PGPRT 1, "stone, so you are dead.": DIE = 1: GOTO Game.Over
     X = FNR(6)
     ON X GOTO TREZORE.1, TREZORE.2, TREZORE.3, TREZORE.4, TREZORE.5, TREZORE.6
TREZORE.1:
     PGPRT 2, "Your enemies disappeared!!"
     FOR M = 1 TO NM
       IF MD%(M, 14) = 1 THEN PGPRT 2, MN$(M) + " disappears!"
       MD%(M, 5) = FNR(38)
     NEXT
     GOTO GET.BACK
TREZORE.2:
     PGPRT 2, "A flash explodes beneath you, burning you severely."
     S = 6
     D = 1
     DF = 0
     EFF.ARM = 0
     GOSUB DO.DAMAGE
     GOTO GET.BACK
TREZORE.3:
     PGPRT 2, "You feel your wounds clearing up!"
     MD%(0, KM.DAMAGE) = MD%(0, KM.DAMAGE) - INT(RND(1) * 3)
     IF MD%(0, KM.DAMAGE) < 0 THEN MD%(0, KM.DAMAGE) = 0
     GOTO GET.BACK
TREZORE.4:
     FOR M = 0 TO NM
       IF MD%(M, 5) = Room AND FNR(100) > 50 THEN
	   PGPRT 2, MN$(M) + " is blasted by Trezore!"
	   S = 1
	   D = INT(RND(1) * 5 + 5)
	   DF = M
	   EFF.ARM = 0
	   GOSUB DO.DAMAGE
       END IF
     NEXT M
     GOTO GET.BACK
TREZORE.5:
     IF FNR(100) > 70 THEN PGPRT 2, "Your weapons just disappeared!": GOTO VANISH.STUFF
     IF FNR(100) > 50 THEN PGPRT 2, "Your armour expertise is gone!!!": AE = 0: GOTO GET.BACK
     PGPRT 2, "Your armour just disappeared!!!": AC = 0: GOTO GET.BACK
TREZORE.6:
     IF FNR(100) > 50 THEN GOTO IMPROVE.WEAPON
     A$ = "You forgot all your weapon expertise for a "
     X = FNR(5)
     A$ = A$ + MID$("axe  bow  club spearsword", (X - 1) * 5 + 1, 5)
     PGPRT 2, A$
     WA%(X) = INT(RND(1) * -10) + 5
     GOTO GET.BACK
VANISH.STUFF:
     FOR A = 1 TO NA
     IF AD%(A, 2) > 1 AND AD%(A, 4) = -1 THEN AD%(A, 4) = 0
     NEXT A
     GOTO GET.BACK
IMPROVE.WEAPON:
     FOR A = 1 TO NA
       IF AD%(A, 4) = -1 AND RND(1) > .5 AND AD%(A, 2) > 1 THEN PGPRT 2, "Damage points on your " + AN$(A) + " just went up!!": AD%(A, 8) = AD%(A, 8) + INT(RND(1) * 3 + 1)
     NEXT A
     GOTO GET.BACK
' --------------------------------------------------------------------------
OPEN.RTN:
    GOSUB GET.SUBJ
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO OPEN.WHAT
    IF A = 11 THEN
	PGPRT 2, "As you open the bottle, a gas fills the room and hurts you."
	S = 6
	D = 1
	DF = 0
	EFF.ARM = 0
	GOSUB DO.DAMAGE
	AD%(11, 4) = 0
	GOTO GET.BACK
    END IF
    IF A = 1 THEN PGPRT 2, "The door is locked.": PRINT : GOTO GET.BACK
    IF A = 2 THEN GOTO READ.TREZORE
    IF A = 15 THEN PGPRT 2, "You find two treasures in the chest. Suddenly, the chest disappears!": AD%(15, 4) = 0: AD%(5, 4) = Room: AD%(21, 4) = Room: GOTO GET.BACK
    IF A = 10 THEN PGPRT 2, "The box is empty.": GOTO GET.BACK
OPEN.WHAT:
    PGPRT 2, "I don't know what you mean.": GOTO GET.BACK
    GOTO MAIN.LOOP
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + EFF.ADJ
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    RETURN
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\Eamon\COPY\SAVEGAME.BAS'
'        Eamon Save Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR OUTPUT AS #1
        PRINT #1, LT
        PRINT #1, LM
        PRINT #1, LC
        PRINT #1, LS
        PRINT #1, ROOM
        PRINT #1, SPD
        PRINT #1, TT
        PRINT #1, ArmNam$
        PRINT #1, ArmHit
        PRINT #1, ArmAdj
        PRINT #1, ShdNam$
        PRINT #1, ShdHit
        PRINT #1, ShdAdj
        PRINT #1, AE
        FOR X = 1 TO 4
        PRINT #1, SA%(4)
        NEXT
        FOR X = 1 TO 4
        PRINT #1, S2%(4)
        NEXT
        FOR X = 1 TO 5
        PRINT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        PRINT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        PRINT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        PRINT #1, V%(V)
        NEXT V
        PRINT #1, GOLD&
        PRINT #1, BANK&

    '------- (end of include file) -------    
 ' 
    PRINT #1, VC
    PRINT #1, IC
    PRINT #1, IV
    PRINT "Game is saved. To restore it, use restore command."
    SAVED = -1
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
REM $$INCL:'\eamon\COPY\RESTGAME.BAS'
'        Eamon Restore Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR INPUT AS #1
        INPUT #1, LT
        INPUT #1, LM
        INPUT #1, LC
        INPUT #1, LS
        INPUT #1, ROOM
        INPUT #1, SPD
        INPUT #1, TT
        INPUT #1, ArmNam$
        INPUT #1, ArmHit
        INPUT #1, ArmAdj
        INPUT #1, ShdNam$
        INPUT #1, ShdHit
        INPUT #1, ShdAdj
        INPUT #1, AE
        FOR X = 1 TO 4
        INPUT #1, SA%(X)
        NEXT
        FOR X = 1 TO 4
        INPUT #1, S2%(X)
        NEXT
        FOR X = 1 TO 5
        INPUT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        INPUT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        INPUT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        INPUT #1, V%(V)
        NEXT V
        INPUT #1, GOLD&
        INPUT #1, BANK&
    CLOSE 1

    '------- (end of include file) -------    
 ' 
    INPUT #1, VC
    INPUT #1, IC
    INPUT #1, IV
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MOVE.IT
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" OR LEFT$(GAME.ID$, 1) > "Z" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\COPY\ADVENIO.OLD'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVENIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       uses Field statements for record description
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       IF Art.Len = 0 THEN Art.Len = 128
       IF Art.Flds = 0 THEN Art.Flds = 8
       IF AN.Len = 0 THEN AN.Len = 20
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = Art.Len
       FIELD 3, AN.Len AS AF.NAME$
       DIM AF.DATA$(Art.Flds)
       FOR A2 = 1 TO Art.Flds
       FIELD 3, AN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS AF.DATA$(A2)
       NEXT
       FOR A = 1 TO NA
           GET #3, A
           AN$(A) = RTRIM$(AF.NAME$)
           FOR A2 = 1 TO Art.Flds
               AD%(A, A2) = CVI(AF.DATA$(A2))
           NEXT A2
           IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       IF MON.LEN = 0 THEN MON.LEN = 128
       IF Mon.Flds = 0 THEN Mon.Flds = 12
       IF MN.Len = 0 THEN MN.Len = 20
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = MON.LEN
       FIELD 3, MN.Len AS MF.NAME$
       DIM MF.DATA$(Mon.Flds)
       FOR A2 = 1 TO Mon.Flds
           FIELD 3, MN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM
           GET #3, A
           MN$(A) = RTRIM$(MF.NAME$)
           FOR A2 = 1 TO Mon.Flds
               MD%(A, A2) = CVI(MF.DATA$(A2))
           NEXT A2
           IF MD%(A, 3) < 0 THEN               ' Force nuetral if < 0
              MD%(A, 3) = ABS(MD%(A, 3)) - 1
              MD%(A, 14) = 2
           END IF
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       IF Desc.Len = 0 THEN Desc.Len = 256
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = Desc.Len
       FIELD 2, Desc.Len - 1 AS Desc$
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       IF RMN.Len = 0 THEN RMN.Len = 64
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = RMN.Len
       FIELD 3, RMN.Len AS RN$
       RETURN
OPEN.ROOMS:      ' ---------------- OPEN ROOMS FILE -------------------
       IF RM.LEN = 0 THEN RM.LEN = 64
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = RM.LEN
       FOR D = 1 TO 10
           FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 20 AS X$, 1 AS RF.LT$
       RETURN
Read.Room:
       GET #1, Room
       IF ND = 0 THEN ND = 6
       NX = 0
       FOR X = 1 TO ND
           RD%(X) = CVI(RF.DIR$(X))
           IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
       NEXT
       NL = VAL(RF.LT$)
       GET #3, Room
       RETURN
    '------- (end of include file) -------

    '------- (end of include file) -------    
 ' 
' ---------------------------------------------------------------------------

SUB PGPRT (SP, LIT$)

STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

