'                Eamon-QB - Adventure #3
'
'                   Cave of the Mind
'
'               Original by Jim Jacobson
'              IBM version by John Nelson
'
'
'
     DEFINT A-Z
     DECLARE SUB PGPRT (SP!, LIT$)
     RANDOMIZE TIMER
     REM $INCLUDE: '\EAMON\COPY\CHARDEF.BAS'
     REM $INCLUDE: '\EAMON\COPY\COLORRTN.BAS'
     DEF FNR (X) = INT(RND(1) * X + 1)
     CLS
     REM $INCLUDE: '\EAMON\COPY\READCTL.BAS'	
     DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
     DIM FWN$(4), FWT$(4), FWC$(4), FWD$(4), FWS$(4), FWA$(5), FSA$(5)
     DIM AN$(NA + 6), AD%(NA + 6, 9)
     DIM MN$(NM), MD%(NM, 16)
     GOSUB READ.ARTIFACTS ' LOAD ARTIFACT TABLE
     GOSUB READ.MONSTERS  ' LOAD MONSTER TABLE
     NW = NW + 6
     DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
     READ NC
     DIM C$(NC)
     FOR C = 1 TO NC
	 READ C$(C)
     NEXT
     R2 = 1
     CONST GOLD.ART = 0
     CONST TREASURE.ART = 1
     CONST WEAPON.ART = 2
     CONST MAG.WEAPON = 3
     CONST CONTAIN.ART = 4
     CONST LIGHT.ART = 5
     CONST HEAL.ART = 6
     CONST READ.ART = 7
     CONST DOOR.ART = 8
     CONST KEY.ART = 9
     CONST BOUND.MON.ART = 10
     CONST ARMOR.ART = 11
     CONST FOOD.ART = 12
     CONST DRINK.ART = 13   ' DRINKABLE ARTIFACT --- PUT IN YOUR OWN EFFECTS
     GOTO INITIALIZE
DONT.UNDERSTAND:
     PGPRT 2, "I don't understand."
' ---------------------------------------------------------------------------
MAIN.LOOP:
     IF SPD THEN
	SPD = SPD - 1
	IF SPD = 0 THEN
		MD%(0, 2) = MD%(0, 2) / 2
		MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2)
		PGPRT 2, "Your speed spell has just expired!"
	END IF
     END IF
     IF IV THEN
	PGPRT 2, "You're invisible.":
	VC = VC + 1
	IF VC > 5 THEN
		VC = 0
		D2 = 3
		DF = 0
		GOSUB APPLY.DAMAGE
	END IF
     END IF
SHOW.ROOM:      ' SHOW.ROOM
     IF V%(Room) <> 0 THEN
	GET #3, Room
	A$ = RTRIM$(RN$)
	PGPRT 2, "You are " + A$
     ELSE
	GOSUB SPECIAL.ROOM.CHK
     END IF
     FOR M = 1 TO NM
	 IF MD%(M, 5) = Room THEN
	     IF MD%(M, 15) = 1 THEN PGPRT 2, MN$(M) + " is here."
	     IF MD%(M, 15) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
	     IF MD%(M, 15) = 0 THEN
		 GET #2, M + MON.ADJ
		 A$ = RTRIM$(DESC$)
		 PGPRT 2, A$
		 MD%(M, 15) = 1
	     END IF
	 END IF
     NEXT
     FOR A = 1 TO NZ
	 IF AD%(A, 4) = Room THEN
	     IF AD%(A, 9) THEN
		 PGPRT 2, "You see " + AN$(A) + "."
	     ELSE
		 GET #2, A + ART.ADJ
		 A$ = RTRIM$(DESC$)
		 PGPRT 2, A$
		 AD%(A, 9) = 1
	     END IF
	 END IF
     NEXT
     FOR A = A TO NA
     IF AD%(A, 4) = Room THEN
	 PGPRT 2, "Your " + AN$(A) + " is here."
     END IF
     NEXT
     PGPRT 1, " "
GET.COMMAND:      ' GET.COMMAND
     PGPRT 0, ""
     PRINT
     COLOR hfg%, hbg%
     PRINT "  Your Command ";
     COLOR fgc%, bgc%
     LINE INPUT " ", A$
     A$ = LTRIM$(RTRIM$(UCASE$(A$)))
     IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
     IF A$ = "" THEN GOTO LIST.COMMANDS
     IF A$ = "EXIT NOW" GOTO Game.Over
     CZ$ = A$
     A = INSTR(A$, " ")
     IF A = 0 THEN A = LEN(A$) + 1
     V$ = LEFT$(A$, A - 1)
     S$ = MID$(A$, A + 1)
     S$ = LTRIM$(S$)
     C = 0
     FOR A = 1 TO ND
     IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
     NEXT
     IF C <> 0 THEN GOTO BRANCH.RTN
     F = 0
     FOR A = ND + 1 TO NC
     IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
     IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	 F = F + 1
	 C = A
	 IF F > 1 THEN C = 0: A = NC
     END IF
     NEXT
     IF C = 0 THEN GOTO LIST.COMMANDS
     GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
     PRINT
     PRINT "Huh? I only understand these commands ... "
     FOR C = 1 TO NC
     PRINT C$(C); SPC(20 - LEN(C$(C)));
     NEXT
     PRINT
     PRINT
     GOTO GET.COMMAND
     IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
     ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
     ON C - 5 GOTO MOVE.RTN, GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN
     ON C - 10 GOTO LOOK.RTN, ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN
     ON C - 15 GOTO BLAST.SPELL, HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN
     ON C - 20 GOTO SMILE.RTN, SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN
     ON C - 25 GOTO PUT.RTN, FREE.RTN, EAT.RTN, DRINK.RTN, WEAR.RTN
     ON C - 30 GOTO SAVE.GAME, RESTORE.GAME, QUIT.RTN
GET.BACK:      ' GET.BACK
    REM $INCLUDE: '\EAMON\COPY\NEWBATL.BAS'
    GOTO MAIN.LOOP
    REM $INCLUDE: '\EAMON\COPY\MONLEAVE.BAS'
' ---------------------------------------------------------------------------
INITIALIZE:
    REM $INCLUDE: '\Eamon\COPY\READMEAT.BAS'
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
    Room = 1
    GOTO MOVE.IT
    DATA 33
    DATA North,South,East,West,Up,Down
    DATA Get,Take,Drop,Look,Examine
    DATA Attack,Flee,Give,Inventory
    DATA Blast,Heal,Power,Speed,Smile
    DATA Wave,Say,Read,Ready,Open
    DATA Put,Free,Eat,Drink,Wear
    DATA Save,Restore,Quit
' ---------------------------------------------------------------------------
Game.Over:      ' GAME.OVER
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    IF SPD THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
    END IF
    IF DIE <> 0 THEN GOTO GET.MASTER
    GOSUB CHK.SUCCESS
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
    LOCATE CSRLIN - 1, 53
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
    IF MD%(0, 8) > AC THEN MD%(0, 8) = AC
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREASURE
    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
    TP = TP + AD%(A, 1)
NEXT.TREASURE:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN
	CLOSE
	CLEAR
	KILL PATH$ + "ADVENT"
	RUN PATH$ + "WORLD"
    END IF
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
    PRINT #1, MN$(0)
    PRINT #1, REC
    CLOSE
    CLEAR
    RUN "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
QUIT.RTN:
    PRINT "Do you want to Quit this game? (Y/N) ";
    A$ = INPUT$(1)
    IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
    CLOSE
    END
CHK.SUCCESS:
'    /// SUCCESSFUL?
    GOTO MISSION.OVER
MISSION.OVER:
    PRINT
    RETURN
' --------------------------------------------------------------------------
MOVE.RTN:
    IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
	    IF TT = 0 THEN
		PGPRT 2, "You can't do that with unfriendlies about!"
		GOTO MAIN.LOOP
	    END IF
	END IF
    END IF
    D = C
    R2 = RD%(D)
    IF R2 > 100 AND R2 < 200 THEN GOTO PASSAGE.BLOCKED
CHK.SPECIAL.MOVES:      ' CHK.SPECIAL.MOVES
    IF R2 > 0 AND R2 <= NR THEN GOTO MOVE.IT
'     /// SPECIAL MOVES
    IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO Game.Over
    IF R2 = 0 THEN GOTO CANT.GO
'    /// INSERT HERE SPECIAL ROOM MOVE CHECKING
    GOTO CANT.GO
PASSAGE.BLOCKED:
    GT = R2 - 100
    IF AD%(GT, 4) <> Room THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(Room) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    R3 = Room   ' moving from room r3
    Room = R2   ' into room r2 which now = room
    GOSUB CHK.REACTIONS
    GET #1, Room
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(Room) > 1 THEN RD%(X) = ABS(RD%(X))
COUNT.EXITS:      ' COUNT.EXITS
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    LT = -1
    GOTO END.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
	GOSUB Check.React
    NEXT
    NBTL = (TD%(1) > 0)
    RETURN
Check.React:
    IF MD%(M, 15) = 2 THEN RETURN      ' monster unconscious/asleep
    IF MD%(M, 5) = R3 THEN     '  check if following you
	IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND 200 * RND(1) < MD%(M, 4)) THEN
	    MD%(M, 5) = Room
	ELSE
	    RETURN
	END IF
    END IF
    IF MD%(M, 5) <> Room THEN RETURN
MONSTER.REACTS:      ' MONSTER.REACTS
    IF MD%(M, 14) = 0 THEN GOSUB New.React
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
    RETURN
New.React:              ' Monster first see you - Does he like you?
    IF M = 5 AND MD%(11, 5) = Room THEN
	MD%(M, 14) = MD%(11, 14)
	RETURN
    END IF
    FR = MD%(M, 3)
    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > (100 * RND(1)) THEN
	MD%(M, 14) = 2
	IF FR > (100 * RND(1)) THEN MD%(M, 14) = 3
    END IF
    RETURN
BRING.IN.BEASTS:
    MD%(M, 5) = Room
    MD%(M, 13) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
    IF S$ = "ALL" THEN GOTO GET.ALL
    EMB = Room + 200
    WH = Room
    HA = Room
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
    IF (AD%(A, 2) = 2 OR AD%(A, 2) = 3) AND MD%(0, 9) = -1 THEN GOTO CALCULATE.ODDS
    GOTO GET.BACK
GET.ALL:      ' GET.ALL
    FOR A = 1 TO NA
    IF AD%(A, 4) <> Room OR AD%(A, 2) = 10 THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
    NEXT
    GOTO GET.BACK
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN 
    	ArmPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN 
    	ShdPtr = A
    	GOSUB Ready.Armor
    END IF	
    GT = 1
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
RATTLE.MONSTER:      ' RATTLE.MONSTER
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN
	PGPRT 1, MN$(M) + " is slightly unnerved!"
	MD%(M, 4) = MD%(M, 4) - 10
    END IF
    NEXT
    RETURN
SPECIAL.ROOM.CHK:      ' SPECIAL.ROOM.CHK
'    /// SPECIAL ROOM?
    IF Room = 23 THEN GOTO ELEVATOR.SHAFT
    GET #2, Room
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    V%(Room) = V%(Room) + 1
    RETURN
ELEVATOR.SHAFT:
    PGPRT 2, "You entered an abandoned elevator shaft and fell for ten minutes before hitting"
    PGPRT 1, "the bottom. Needless to say, you did NOT survive!"
    DIE = -1
    GOTO Game.Over
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 9999
    NEXT
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.ARTIFACT:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
    GOSUB DROP.IT
    GOTO CHK.WGHT
DROP.ALL:       ' DROP.ALL
    SR = Room
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 AND A <> ArmPtr THEN
	GOSUB DROP.IT
    END IF
    NEXT
CHK.WGHT:      ' CHK.WGHT
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO Get.Back
DROP.IT:
    IF IV THEN GOSUB RATTLE.MONSTER
    WT = WT - AD%(A, 3)
    AD%(A, 4) = Room
    PGPRT 2, AN$(A) + " dropped."
    IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor
    IF A = LS THEN LS = 0: LC = 0: LM = 0: LT = NL: PgPrt 2, "The " + AN$(A) + " goes out."
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
    RETURN
Drop.Armor:
    IF A = ArmPtr THEN ArmPtr = 0
    IF A = ShdPtr THEN ShdPtr = 0
    MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    EA = EA + AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
Ready.Armor:
    MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
    EA = EA - AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO GET.BACK
    WH = Room
    HA = -1
    EMB = Room + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND AND AD%(A, 4) = EMB THEN AD%(A, 4) = Room
    IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    FOR A = 1 TO NA
    IF AD%(A, 4) = 300 + Room THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO GET.BACK
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
    NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(Room) = 0
    GOTO GET.BACK
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    R = M + 100
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
    RETURN
SECRET.PASSAGE:
    RD%(X) = ABS(RD%(X))
    V%(Room) = 2
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:
'     === EXAM ART A
    IF A = 3 OR A = 13 THEN PGPRT 2, "The bottle says, 'Healing Potion'": RETURN
    IF A = 9 AND AD%(A, 4) = -1 THEN PGPRT 2, "It is a simple silver crucifix.": RETURN
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    GET #2, A + MAX.RM
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, 4) = Room
    RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOTO ATTACK.MON
    TA = 0
    GOTO ASSAULT.ARTIFACT
ATTACK.MON:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
MISSED:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, 10) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = Room AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, 4) = 0
    MD%(OF, 9) = A
    MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
    MD%(OF, 4) = MD%(OF, 4) * 2
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = Room
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
    END IF
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * INC
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF DF > 8 AND DF < 13 AND OF = 0 AND MD%(0, 9) = 6 THEN D2 = D2 + 2
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO DEAD.RTN
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:      ' HURTING
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:      ' IN.PAIN
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:      ' BADLY.INJURED
    PGPRT 2, A$ + " is very badly injured."
    RETURN
DEATHS.DOOR:      ' DEATHS.DOOR
    PGPRT 2, A$ + " is at death's door, knocking loudly."
    RETURN
DEAD.RTN:
    IF DF = 0 THEN PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
IS.DEAD:      ' IS.DEAD
'    /// MONSTER DIES
    PGPRT 2, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF DF = 17 THEN RETURN
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
    IF DF = 0 THEN DIE = 1: GOTO Game.Over
    A2 = DF + NZ - NM
    AD%(A2, 4) = Room
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: Exit For
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor 
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN

' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PRINT " "; AN$(A);
	IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
	IF A = ArmPtr THEN PRINT " (Worn armor)";
	IF A = ShdPtr THEN PRINT " (Your shield)";
	PGPRT 1, " "
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    GOTO GET.BACK
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO BLASTED.DOOR
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 5
    D = 2
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
    TA = 1
    GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
HEAL.WOUNDS:
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
    IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    RR = INT(RND(1) * 100 + 1)
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    IF SPD <> 0 THEN PGPRT 2, "Nothing Happens.": GOTO MAIN.LOOP
    MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2)
    MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IV THEN GOTO GET.BACK
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, 5) = Room AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GROWLS:
    IF M = 2 THEN PGPRT 1, MN$(M) + " hisses at you!": RETURN
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    IF M = 11 THEN PGPRT 1, MN$(M) + " purrs and rubs against your leg.": RETURN
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO GET.BACK
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = WH
    EMB = HA
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
' --------------------------------------------------------------------------
OPEN.RTN:
    GOSUB GET.SUBJ
    POP = 0
    GOSUB CHK.OPEN.SPECIAL
    IF POP THEN GOTO MAIN.LOOP
    WH = Room
    HA = -1
    EMB = Room + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO CHK.OPEN.DOOR
    IF A = 6 THEN IF OBX THEN PGPRT 2, "It's empty." ELSE OBX = -1: GOTO POWER.SPELL
    IF A = 18 THEN GOTO OPEN.SNAKE
    IF AD%(A, 2) = 4 THEN GOTO OPEN.CONTAINER
    IF AD%(A, 2) = 7 THEN PGPRT 2, "Try reading it.": GOTO MAIN.LOOP
    IF AD%(A, 2) = 1 THEN PGPRT 2, "You'll make a mess. Wait till you leave.": GOTO MAIN.LOOP
    IF AD%(A, 2) = 8 THEN GOTO OPEN.DOOR
    PGPRT 2, "That's not what you do with it."
    GOTO MAIN.LOOP
OPEN.CONTAINER:
    IF AD%(A, 5) THEN IF AD%(AD%(A, 5), 4) <> -1 THEN PGPRT 2, "It's locked!": GOTO MAIN.LOOP
    LK = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = A + INS.ADJ THEN AD%(X, 4) = Room: LK = -1:
    NEXT
    PGPRT 2, "You find " + MID$("nosome", ABS(LK) * 2 + 1, 2 + 2 * ABS(LK)) + "thing inside."
    GOTO GET.BACK
OPEN.SNAKE:
    IF MD%(11, 5) = -2 THEN
	PGPRT 2, "As you tear the large snake open, a small kitten clambers out, covered"
	PGPRT 1, "in blood, but still fairly healthy.  She rubs against your legs and purrs."
	PGPRT 1, "You saved her life and she is very grateful."
	MD%(11, 5) = Room
	R2 = Room
	GOSUB CHK.REACTIONS
    ELSE
	PGPRT 2, "You further mutilate the snake!"
    END IF
    GOTO GET.BACK
CHK.OPEN.DOOR:  ' LABEL.CHK.OPEN.DOOR
    IF S$ = "DOOR" OR S$ = "GATE" THEN PGPRT 2, "It will open when you approach.": GOTO MAIN.LOOP
    PGPRT 2, "I don't know how to open " + LCASE$(S$) + "."
    GOTO MAIN.LOOP
OPEN.DOOR:
'    DOOR/GATE
    IF AD%(A, 6) THEN IF AD%(AD%(A, 6), 4) <> -1 THEN PGPRT 2, "It's locked!": GOTO MAIN.LOOP
    AD%(A, 6) = 0
    PGPRT 2, "You've opened the " + AN$(A) + "."
    FOR X = 1 TO ND
    IF RD%(X) = A + 100 THEN RD%(X) = AD%(A, 5)
    NEXT
    GOTO GET.BACK
ASSAULT.ARTIFACT:
    IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
CHK.OPEN.SPECIAL:
    RETURN
' --------------------------------------------------------------------------
PUT.RTN:
    IF S$ = "" THEN GOTO GET.PUT.DATA
    IF INSTR(S$, " INTO") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 6): GOTO PUT.AWAY
    IF INSTR(S$, " IN") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 3): GOTO PUT.AWAY
GET.PUT.DATA:      ' GET.PUT.DATA
    PGPRT 1, " "
    INPUT "Put what?", A$
    INPUT "Put into what?", B$
    PGPRT 2, ""
    GOTO PUT.AWAY
PUT.AWAY:
    S$ = A$
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    Z = A
    S$ = B$
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 OR A = Z THEN GOTO PUT.WHAT
    IF AD%(A, 2) = 4 THEN AD%(X, 4) = A + 100: PGPRT 2, "Okay.": GOTO GET.BACK
PUT.WHAT:      ' PUT.WHAT
    PGPRT 2, "You can't do that."
    GOTO GET.BACK
' ---------------------------------------------------------------------------
READ.RTN:
    IF IC <> 0 AND DD = 0 THEN PGPRT 2, "You can't see.": GOTO MAIN.LOOP
    GOSUB GET.SUBJ
    WH = Room
    HA = -1
    EMB = Room + 200
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO READ.NONART
    IF AD%(A, 2) = 7 THEN GOTO READ.ARTIFACT
    PGPRT 2, "You can't read it."
    GOTO GET.BACK
READ.NONART:
'   ...  NON-ART - INSERT HERE SPECIAL READING ...
'   ...  EXAMPLE: READING WALLS OR CEILING, DOORS, ETC ...
    IF (S$ = "WALL" OR S$ = "INSCRIPTION") AND Room = 12 THEN GOTO READ.WALL
    GOTO DONT.UNDERSTAND
READ.WALL:
    COLOR hfg%, hbg%
    PGPRT 2, " PEACE BEGETS PEACE. Put down your weapons and leave violence behind you."
    COLOR fgc%, bgc%
    FOR X = 1 TO NA:
    IF AD%(X, 4) = -1 AND AD%(X, 2) = 2 THEN AD%(X, 4) = FNR(NR)
    NEXT
    GOTO GET.BACK
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
    R = AD%(A, 5) + AD%(A, 7) - 1
    GOSUB PRINT.EFFECT
    AD%(A, 7) = AD%(A, 7) + 1
    IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
    GOTO GET.BACK
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + 200
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
' --------------------------------------------------------------------------
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> Room THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = Room THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = Room
    AD%(A, 4) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
' ---------------------------------------------------------------------------
EAT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO NOT.HUNGRY
    IF AD%(A, 2) <> FOOD.ART THEN GOTO NOT.HUNGRY
    PGPRT 2, "Okay. You eat the " + LCASE$(AN$(A)) + "."
    AD%(A, 4) = 0
    GOTO GET.BACK
NOT.HUNGRY:
    PGPRT 2, "You aren't THAT hungry!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
DRINK.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN PGPRT 2, "I don't understand.": GOTO MAIN.LOOP
    IF A = 16 THEN GOTO DRINK.SPECIAL
    IF AD%(A, 2) <> 6 THEN PGPRT 2, "You can't do that!": GOTO MAIN.LOOP
    IF AD%(A, 7) <= 0 THEN PGPRT 2, "There isn't any left.": GOTO GET.BACK
    IF AD%(A, 5) > FNR(100) THEN GOTO DRINK.HEAL
    PGPRT 2, "Nothing seems to happen."
    GOTO GET.BACK
DRINK.SPECIAL:
    PGPRT 2, "As you drink the potion, the room gradually fades from your view. When your"
    PGPRT 1, "sight returns to normal, you are on the ground at the very spot where you"
    PGPRT 1, "first drank the potion the little man gave you. You slowly pick yourself up and"
    PGPRT 1, "return to the main hall.": DIE = 0: GOTO Game.Over
DRINK.HEAL:
    AD%(A, 7) = AD%(A, 7) - 1
    MD%(0, 13) = MD%(0, 13) - AD%(A, 6)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    PGPRT 2, "Your wounds seem to " + MID$("openheal", ABS(AD%(A, 6) > 0) * 4 + 1, 4) + "!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
WEAR.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.WEAR
    IF AD%(A, 2) = ARMOR.ART THEN GOTO WEAR.ARMOR
WEAR.SOMETHING:
 ' ..... INSERT HERE SPECIAL WORN ARTIFACTS ...
    GOTO DONT.WEAR
WEAR.ARMOR:
    EA = -AD%(A, 5)
    MD%(0, 8) = AD%(A, 7)
    PGPRT 2, "Okay. You have put on the " + AN$(A) + "."
    GOTO GET.BACK
DONT.WEAR:
    PGPRT 2, "You can't wear that and stay respectable."
    GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\EAMON\COPY\SAVEGAME.BAS'
    PRINT "Game is saved. To restore it, use restore command."
    SAVED = -1
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\EAMON\COPY\RESTGAME.BAS'
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MOVE.IT
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" OR LEFT$(GAME.ID$, 1) > "Z" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
' ---------------------------------------------------------------------------
    REM $INCLUDE: '\Eamon\copy\Chario.BAS'
    REM $INCLUDE: '\EAMON\COPY\ADVENIO.OLD'

DEFSNG A-Z
SUB PGPRT (SP, LIT$)

STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

