'
'                     Eamon Adventure #1
'                    -> Beginners Cave <-
'
'        Original By Donald Brown - IBM Version By John Nelson
'
'                     Revised 12-03-90
'
	DEFINT A-Z
	DECLARE SUB RemoveDups (WN$(), N%)
	DECLARE SUB Pressanykey (A$)
	DECLARE SUB PgPrt (SP, LIT$)
	RANDOMIZE TIMER
REM $$INCL:'\EAMON\COPY\CHARDEF.BAS'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\COPY\COLORRTN.BAS'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
	DEF FNR (X) = (INT(X * RND(1)) + 1)
	CLS
	LOCATE 10, 1
	PRINT "Please wait a short while - (waking up the monsters)"
	REM
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
	DIM AN$(NA + 6), AD%(NA + 6, 9)
	DIM Mon$(12)
	DIM MN$(NM)
	DIM SHARED MD%(NM, 15)
	DIM SHARED FD%(3), TD%(3)
	DIM SA%(4), WA%(5), S2%(4), RD%(6), RF.DIR$(10)
	GOSUB READ.ARTIFACTS
	NW = NW + 6
	DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
	READ NC
	DIM C$(NC)
	FOR C = 1 TO NC
	READ C$(C)
	NEXT
	DIM V%(NR)
	GOTO INITIALIZE.RTN
MAIN.LOOP:
	PgPrt 1, " "
	IF SPD > 0 THEN SPD = SPD - 1: IF SPD = 0 THEN MD%(0, 2) = MD%(0, 2) / 2: MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2): IF RND(1) > .8 THEN PgPrt 2, "Your Speed spell has just expired!"
	IF INT(V%(Room) / 2) <> V%(Room) / 2 THEN
	GET #3, Room
	A$ = RTRIM$(RN$)
	PgPrt 2, "You are standing in " + A$
	ELSE
	R = Room
	GET #2, R
	A$ = RTRIM$(Desc$)
	PgPrt 2, A$
	V%(Room) = V%(Room) + 1
	END IF
	FOR M = 1 TO NM
	IF MD%(M, 5) = Room THEN
		IF MD%(M, 15) = 1 THEN
		PgPrt 2, MN$(M) + " is here."
		ELSE
		IF MD%(M, 15) = 0 THEN
			GET #2, M + MON.ADJ
			A$ = RTRIM$(Desc$)
			PgPrt 2, A$
			MD%(M, 15) = 1
			IF M = 10 THEN R = 2: GOSUB PRINT.EFFECT
		ELSE
			PgPrt 2, MN$(M) + " is lying here."
		END IF
		END IF
	END IF
	NEXT
	FOR A = 1 TO NZ
	   IF AD%(A, 4) = Room THEN
	   IF AD%(A, 9) <> 0 THEN
		   PgPrt 2, "You see " + AN$(A) + "."
	   ELSE
		   GET #2, A + ART.ADJ
		   A$ = RTRIM$(Desc$)
		   PgPrt 2, A$
		   AD%(A, 9) = 1
	   END IF
	   END IF
	NEXT
	FOR A = A TO NA
	   IF AD%(A, 4) = Room THEN PgPrt 2, "Your " + AN$(A) + " is here."
	NEXT
GET.COMMAND:
	PgPrt 0, " "
	PgPrt 1, " "
	COLOR hfg%, hbg%
	PRINT " Your Command ";
	COLOR fgc%, bgc%
	LINE INPUT " ", A$
	A$ = LTRIM$(RTRIM$(A$))
	IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 16: PRINT A$
	IF A$ = "" THEN GOTO LIST.COMMANDS
	A$ = UCASE$(A$)
	CZ$ = A$
	V$ = ""
	A = INSTR(A$, " ")
	IF A > 0 THEN V$ = LEFT$(A$, A - 1): S$ = MID$(A$, A + 1)
	IF A = 0 THEN V$ = A$: S$ = ""
	S$ = LTRIM$(S$)
	C = 0
	FOR X = 1 TO ND
	IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN C = X
	NEXT
	IF C > 0 THEN GOTO APPROP.RTN
	F = 0
	FOR X = ND + 1 TO NC
	IF UCASE$(C$(X)) = V$ THEN C = X: F = 1: X = NC: GOTO NEXT.CMD
	IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN F = F + 1: C = X
NEXT.CMD:
	NEXT
	IF F = 1 THEN GOTO APPROP.RTN
LIST.COMMANDS:
	PRINT
	PRINT "Huh? I only understand these commands --- "
	FOR C = 1 TO NC
	IF C <= ND OR C > 10 THEN PRINT C$(C); SPC(20 - LEN(C$(C)));
	NEXT
	PRINT
	PRINT
	GOTO GET.COMMAND
	IF C$(C) = S$ THEN S$ = V$: V$ = C$(C)
APPROP.RTN:
	ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
	ON C - 10 GOTO GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN, LOOK.RTN, ATTACK.RTN
	ON C - 16 GOTO FLEE.RTN, GIVE.RTN, INVENTORY.RTN, BLAST.SPELL, HEAL.SPELL
	ON C - 21 GOTO POWER.SPELL, SPEED.SPELL, SMILE.RTN, SMILE.RTN, SAY.SOMETHING
	ON C - 26 GOTO READ.RTN, READY.WEAPON, LIGHT.RTN, OPEN.RTN, PUT.RTN
	ON C - 31 GOTO DRINK.RTN, FREE.RTN, ENTER.RTN, TROLLSFIRE
Get.Back:
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
	GOTO MAIN.LOOP
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
INITIALIZE.RTN:
	GOSUB READ.MONSTERS
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
	RemoveDups AN$(), NA
	GOSUB OPEN.DESC
	GOSUB OPEN.ROOMS
	GOSUB OPEN.RMNAMES
	MD%(0, 14) = 3
	FOR S = 1 TO 4
	  S2%(S) = SA%(S)
	NEXT
	Room = 1
	ND = 6
	R2 = 1
	CLS
	PgPrt 2, "You have no trouble finding a horse that you, well -- borrow to take you on"
	PgPrt 1, "your first adventure. You follow several signs that take you to the Beginners"
	PgPrt 1, "Cave."
	PgPrt 2, "As you stand there, you see the local Knight Marshal come out to inspect you."
	IF UCASE$(WN$(1)) = "NONE" THEN
	PgPrt 2, "He shakes his head and says, 'You must have at least one weapon to adventure":
	PgPrt 1, "within the cave. Go back to the Main Hall and prepare yourself."
	GOSUB GET.OVERRIDE:
	IF OV = 0 THEN GOTO GAME.OVER
	END IF
	FOR X = 1 TO 5
	TA = TA + WA%(X)
	NEXT
	IF TA > 30 THEN
	PgPrt 2, "The Knight Marshal shakes his head and says, 'You are not a beginner. You may"
	PgPrt 1, "not adventure here. Return to the Main Hall.'"
	GOSUB GET.OVERRIDE
	IF OV = 0 THEN GOTO CLOSE.DOWN
	END IF
	PgPrt 2, "The Knight Marshal then says, 'You may now proceed.' and walks away."
	PgPrt 1, " "
	Pressanykey A$
	GOTO MOVE.IT
GET.OVERRIDE:
	PRINT
	Pressanykey A$
	IF A$ = CHR$(15) THEN OV = -1: RETURN
	OV = 0
	RETURN
	DATA 35
	DATA north,south,east,west,up,down,NE,NW,SE,SW,get,take,drop
	DATA look,examine,attack,flee,give,inventory,blast
	DATA heal,power,speed,smile,wave,say,read,ready,light,open,put,drink
	DATA free,enter,trollsfire
GAME.OVER:
	Pressanykey A$
	PRINT
CLOSE.DOWN:
	CLOSE
	IF SPD > 0 THEN MD%(0, 2) = MD%(0, 2) / 2
	IF DIE THEN GOTO GET.MASTER
	FOR W = 1 TO 4
	WN$(W) = "NONE"
	NEXT
	W2 = 1
	FOR A = 1 TO NA
	IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
	NEXT A
	IF W2 < 6 THEN GOTO SELL.TREASURE
SELL.WEAPONS:
	CLS
	LOCATE 5, 1
	PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
	PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
	PRINT
	PRINT "Your weapons are--"
	FOR W = 1 TO W2 - 1
	PRINT SPC(4); W; "--"; WN$(W)
	NEXT
	PRINT
	PRINT "Enter the number of the weapon to sell     (1-"; W2 - 1; ") "
GET.NBR.SELL:
	LOCATE CSRLIN - 1, 52
	INPUT A$
	W5 = VAL(A$)
	IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO GET.NBR.SELL
	AD%(WP%(W5), 4) = -1
	WN$(W5) = WN$(W2 - 1)
	WP%(W5) = WP%(W2 - 1)
	W2 = W2 - 1
	IF W2 > 5 THEN GOTO SELL.WEAPONS
SELL.TREASURE:
	FOR W = 1 TO 4
	IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
	NEXT W
	CLS
	LOCATE 5, 1
	PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
	PRINT "things, he examines your goods and pays you ";
	TP = 0
	FOR A = 1 TO NA
	IF A = ArmPtr OR A = ShdPtr THEN GOTO Next.Treas
	IF AD%(A, 4) <> -1 THEN GOTO Next.Treas
	IF AD%(A, 2) <> 0 THEN
	   IF CH > 20 THEN
	   AD%(A, 1) = AD%(A, 1) * 2
	   ELSE
	   AD%(A, 1) = AD%(A, 1) * CH / 10
	   END IF
	END IF
	TP = TP + AD%(A, 1)
Next.Treas:
	NEXT A
	PRINT TP; " gold pieces."
	PRINT
	GOLD& = GOLD& + TP
	IF GOLD& < 0 THEN GOLD& = 0
	PRINT
	IF MD%(9, 5) = Room THEN
	reward = INT(RND(1) * 90 + 15)
	PRINT "You are also given "; reward; " gold pieces for the safe return of"
	PRINT "Cynthia."
	END IF
	Pressanykey A$
	PRINT
GET.MASTER:
	CLS
	LOCATE 5, 1
	IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
	IF MastPath$ <> "" THEN CHDIR MastPath$
	ON ERROR GOTO Invalid.Path
	IF DIE THEN KILL "ADVENT": GOTO RUN.HALL
	CLOSE
	GOSUB OPEN.CHARACTERS
	Nam$ = MN$(0)
	HD = MD%(0, 1)
	AG = MD%(0, 2)
	GOSUB WRITE.CHARACTER
	OPEN Path$ + "ADVENT" FOR OUTPUT AS #2
	WRITE #2, MN$(0)
	WRITE #2, REC
	CLOSE
RUN.HALL:
	RUN "HALL"
Invalid.Path:
	PRINT
	PRINT "Invalid Path, or Master Not Found. Please re-try ..."
	PRINT " (press any key to continue)";
	A$ = INPUT$(1)
	RESUME GET.MASTER
MOVE.RTN:
	IF NBTL <> 0 AND S$ <> "FLEE" THEN PgPrt 2, "You don't want to turn your back here.": GOTO MAIN.LOOP
	R2 = RD%(C)
	IF R2 > 100 THEN GOTO PASSAGE.BLOCKED
CHK.MOVE:
	IF R2 > 0 THEN GOTO MOVE.IT
' ///SPECIAL MOVES
	IF R2 = -99 THEN PgPrt 2, "You successfully ride off into the sunset.": GOTO GAME.OVER
	IF R2 = 0 THEN GOTO CANT.GO
	GOTO CANT.GO
PASSAGE.BLOCKED:
	PBL = R2 - 100
	IF AD%(PBL, 7) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
	IF AD%(PBL, 6) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
	PgPrt 2, "The " + AN$(PBL) + " blocks the way!"
	GOTO MAIN.LOOP
CANT.GO:
	PgPrt 2, "You can't go that way!"
	V%(Room) = 0
	GOTO MAIN.LOOP
MOVE.IT:
	R3 = Room
	Room = R2
	GOSUB CHK.REACTIONS
	GOSUB Read.Room
	NL = -1
	LT = NL OR LM
	GOTO MAIN.LOOP
CHK.REACTIONS:
	TD%(1) = 0
	TD%(3) = MD%(0, 1)
	FD%(1) = 0
	FD%(3) = MD%(0, 13)
	FOR M = 1 TO NM
	IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND FNR(200) < MD%(M, 4)) THEN MD%(M, 5) = Room: GOTO ADD.SIDE
	IF MD%(M, 5) <> Room THEN GOTO NEXT.REACT
	IF MD%(M, 14) THEN GOTO ADD.SIDE
	FR = MD%(M, 3)
	IF FR AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
	MD%(M, 14) = 1
	IF FR > FNR(100) THEN MD%(M, 14) = 2: IF FR > FNR(100) THEN MD%(M, 14) = 3
ADD.SIDE:
	A = MD%(M, 14)
	FD%(A) = FD%(A) + MD%(M, 13)
	TD%(A) = TD%(A) + MD%(M, 1)
NEXT.REACT:
	NEXT M
	NBTL = (TD%(1) > 0)
	RETURN
GET.RTN:
	GOSUB GET.SUBJ
	IF S$ = "ALL" THEN GOTO GET.ALL
	IF S$ = "TORCH" THEN PgPrt 2, "All torches are bolted to the wall and cannot be removed.": GOTO Get.Back
	EMB = Room + 200
	WH = Room
	HA = Room
	GOSUB LOCATE.ART
	IF FOUND = 0 THEN PgPrt 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
	GOSUB GET.SURPRISE
	IF NOT GT THEN GOTO MAIN.LOOP
	IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PgPrt 2, "It is too heavy for you.": GOTO MAIN.LOOP
	PgPrt 2, "Got it."
	AD%(A, 4) = -1
	SZ = SZ + AD%(A, 0)
	WT = WT + AD%(A, 3)
	IF AD%(A, 2) >= 2 AND AD%(A, 2) <= 3 AND MD%(0, 9) = -1 THEN GOTO READY.WEAPON
	IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN
	ArmPtr = A
	GOSUB Ready.Armor
	END IF
	IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN
	ShdPtr = A
	GOSUB Ready.Armor
	END IF
	GOTO Get.Back
GET.ALL:
	PgPrt 1, " "
	FOR A = 1 TO NA
	IF AD%(A, 4) <> Room THEN GOTO GET.NEXT
	GOSUB GET.SURPRISE
	IF NOT GT THEN GOTO GET.NEXT
	IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PgPrt 1, AN$(A) + " is too heavy.": GOTO GET.NEXT
	PgPrt 1, AN$(A) + " taken."
	AD%(A, 4) = -1
	WT = WT + AD%(A, 3)
GET.NEXT:
	NEXT
	GOTO Get.Back
GET.SURPRISE:
	GT = -1
' -1=successful get it ; 0=failure to get it
	RETURN
MONSTER.SEARCH:
	WH = Room
	HA = -1
	EMB = Room
	FOUND = 0
	SL = LEN(S$)
	FOR X = 1 TO NM
	IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = Room OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 999
	NEXT
	RETURN
ARTIFACT.SEARCH:
	WH = Room
	HA = -1
	EMB = Room
LOCATE.ART:
	FOUND = 0
	SL = LEN(S$)
	FOR X = 1 TO NA
	IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = EMB OR AD%(X, 4) = HA) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 999
	NEXT
	RETURN
GET.SUBJ:
	IF S$ = "" THEN PRINT : PRINT C$(C); " what"; : INPUT S$: PgPrt 2, "": GOTO GET.SUBJ
	RETURN
DROP.RTN:
	GOSUB GET.SUBJ
	IF S$ = "ALL" THEN GOTO DROP.ALL
	WH = -1
	HA = -1
	EMB = -1
	GOSUB LOCATE.ART
	IF FOUND = 0 THEN PgPrt 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
	GOSUB DROP.IT
	GOTO CHK.WGHT
DROP.ALL:       ' DROP.ALL
	SR = Room
	FOR A = 1 TO NA
	IF AD%(A, 4) = -1 AND A <> ArmPtr THEN
	PgPrt 2, AN$(A) + " dropped."
	AD%(A, 4) = Room
	GOSUB DROP.IT
	END IF
	NEXT
CHK.WGHT:      ' CHK.WGHT
	IF WT > 10 * MD%(0, 1) THEN PgPrt 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
	IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
	GOTO Get.Back
DROP.IT:
	WT = WT - AD%(A, 3)
	AD%(A, 4) = Room
	PgPrt 2, AN$(A) + " dropped."
	IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor
	IF A = LS THEN LS = 0: LC = 0: LM = 0: LT = NL: PgPrt 2, "The " + AN$(A) + " goes out."
	IF WT > 10 * MD%(0, 1) THEN PgPrt 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
	RETURN
Drop.Armor:
	IF A = ArmPtr THEN ArmPtr = 0
	IF A = ShdPtr THEN ShdPtr = 0
	MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
	EA = EA + AD%(A, 5)
	W = MD%(0, 9)
	MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) + ((EA + AE) * ABS(-EA > AE))
	RETURN
Ready.Armor:
	MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
	EA = EA - AD%(A, 5)
	W = MD%(0, 9)
	MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) + ((EA + AE) * ABS(-EA > AE))
	RETURN
LOOK.RTN:
	LK = 0
	IF S$ = "" THEN GOTO GENERAL.LOOK
	IF S$ = "ME" THEN
	IF MD%(0, 13) = 0 THEN A$ = "no" ELSE A$ = LTRIM$(STR$(MD%(0, 13))) + " points"
	PgPrt 2, "You are " + MN$(0) + ".  You have " + A$ + " damage.": GOTO Get.Back
	END IF
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN GOTO CHK.LK.MON
	GOSUB EXAM.ART
	LK = -1
	AD%(A, 9) = 1
	IF AD%(A, 4) = EMB THEN AD%(A, 4) = Room
	IF LK THEN GOTO Get.Back
CHK.LK.MON:
	GOSUB MONSTER.SEARCH
	IF FOUND <> 0 THEN GOSUB EXAM.MON: LK = -1
	IF LK THEN GOTO Get.Back
	IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
GENERAL.LOOK:
	FOR X = 1 TO ND
	IF RD%(X) < 0 AND ABS(RD%(X)) <= NR THEN PgPrt 2, "You found a secret passage " + LCASE$(C$(X)) + "!": RD%(X) = ABS(RD%(X)): V%(Room) = 2
	NEXT
	WH = Room + 300
	HA = WH
	EMB = WH
	GOSUB LOCATE.ART
	IF FOUND <> 0 THEN AD%(A, 4) = Room: PgPrt 2, "You found something.": GOTO Get.Back
	V%(Room) = V%(Room) + 1
	GOTO Get.Back
EXAM.ART:
	IF A = 3 OR A = 13 THEN PgPrt 2, "The bottle says, 'Healing Potion'": RETURN
	GET #2, A + ART.ADJ
	A$ = RTRIM$(Desc$)
	PgPrt 2, A$
	RETURN
EXAM.MON:
	GET #2, M + MON.ADJ
	A$ = RTRIM$(Desc$)
	PgPrt 2, A$
	LK = -1
	RETURN
NOTHIN.TA.SEE:
	V%(Room) = V%(Room) + 1
	GOTO Get.Back
' Secret Passage - PUT MESSAGE HERE IF NEEDED
	PgPrt 2, "You found a secret passage " + LCASE$(C$(X)) + "!"
	RD%(X) = ABS(RD%(X))
	V%(Room) = 2
	RETURN
ATTACK.RTN:
	GOSUB GET.SUBJ
	IF LT = 0 THEN PgPrt 2, "You swing wild --- nothing hit.": GOTO Get.Back
	GOSUB MONSTER.SEARCH
	IF FOUND = 0 THEN GOTO CHK.ATT.ART
	GOTO ATTACK.MONSTER
CHK.ATT.ART:
	WH = Room
	HA = Room
	EMB = Room + 200
	GOSUB LOCATE.ART
	IF FOUND = 0 THEN PgPrt 2, "Attack who?": GOTO MAIN.LOOP
	'  If we are not attacking a gate/door or a chest:
	IF AD%(A, 2) <> 8 AND AD%(A, 2) <> 4 THEN
	IF A > NZ - NM THEN PgPrt 2, "He's dead, already... let him rest in peace!": GOTO MAIN.LOOP
	PgPrt 2, "Are you crazy?!"
	GOTO MAIN.LOOP
	END IF
	S = 7
	K = 6
	IF AD%(A, 2) = 4 THEN S = S - 1: K = K - 1
	D2 = 0
	FOR X = 1 TO MD%(0, 11)
	D2 = D2 + FNR(MD%(0, 12))
	NEXT
	AD%(A, S) = AD%(A, S) - D2
	IF AD%(A, S) <= 0 THEN AD%(A, S) = 0: AD%(A, K) = 0: PgPrt 2, "The " + AN$(A) + " shatters!": GOTO Get.Back
	PgPrt 2, "WHAM!! You hit the " + AN$(A) + "!"
	GOTO Get.Back
ATTACK.MONSTER:
	IF MD%(0, 9) = -1 THEN PgPrt 2, "You have no weapon ready!": GOTO MAIN.LOOP
	OF = 0
	DF = M
	GOSUB TAKE.A.SWING
	IF NOT HIT THEN GOTO CHK.ATT.FRIEND
	IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
	IF -EA <= AE THEN GOTO Get.Back
	IF FNR(100) <= MD%(0, 10) THEN GOTO CHK.ATT.FRIEND
	A = 2
	IF EA + AE = -1 THEN A = 1
	AE = AE + A
	MD%(0, 10) = MD%(0, 10) + A
CHK.ATT.FRIEND:
	IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO Get.Back
	MD%(DF, 3) = MD%(DF, 3) / 2
	FOR M = 1 TO NM
	IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
	NEXT M
	R3 = Room
	GOSUB CHK.REACTIONS
	GOTO Get.Back
MON.GET.GUN:
	IF MD%(OF, 10) = 0 THEN RETURN
	FOR A = 1 TO NA
	IF AD%(A, 4) = Room AND (AD%(A, 2) = 2 OR AD%(A, 2) = 3) THEN
	PgPrt 2, MN$(OF) + " picks up " + AN$(A) + "."
	AD%(A, 4) = 0
	MD%(OF, 9) = A
	MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
	MD%(OF, 4) = MD%(OF, 4) * 2
	A = NA
	END IF
	NEXT
	RETURN
TAKE.A.SWING:
	HIT = 0
	IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
	PgPrt 2, MN$(OF) + " attacks " + MN$(DF)
	PRINT " --";
	RL = FNR(100)
	HIT = 0
	IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = -1
	IF HIT THEN GOTO A.HIT
	IF RL < 97 THEN PgPrt 1, "a miss.": RETURN
	PgPrt 1, "a Fumble!"
	FR = FNR(100)
	IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PgPrt 1, "  fumble recovered.": RETURN
	IF FR < 76 THEN PgPrt 1, "  weapon dropped!": AD%(MD%(OF, 9), 4) = Room: MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5): MD%(OF, 9) = -1: MD%(OF, 4) = MD%(OF, 4) / 2: RETURN
	IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PgPrt 2, "Sparks fly from " + AN$(W) + "!": RETURN
	IF FR > 95 THEN GOTO HURT.SELF
	PgPrt 1, "  weapon broken!"
	AD%(MD%(OF, 9), 4) = 0
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	IF RND(1) > .5 THEN PgPrt 1, " ": RETURN
	PgPrt 1, "  broken weapon hurts user!"
HURT.SELF:
	IF FR = 100 THEN GOTO SELF.YEOW
	D = MD%(OF, 11)
	S = MD%(OF, 12)
	DF = OF
	A = 1
	GOTO DO.DAMAGE
SELF.YEOW:
	D = MD%(OF, 11) * 2
	S = MD%(OF, 12)
	DF = OF
	A = 0
	GOTO DO.DAMAGE
A.HIT:
	INC = (FNR(100) > MD%(OF, 10))
	MD%(OF, 10) = MD%(OF, 10) + 2 * ABS(INC)
	D = MD%(OF, 11)
	S = MD%(OF, 12)
	A = 1
	IF RL > 5 THEN PgPrt 1, "a Hit!": GOTO DO.DAMAGE
	PgPrt 1, "A Critical Hit!"
	R2 = FNR(100)
	IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
	IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
	IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
	IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
	GOTO IS.DEAD
DO.DAMAGE:
	D2 = 0
	FOR D3 = 1 TO D
	D2 = D2 + FNR(S)
	NEXT
	D2 = D2 - A * MD%(DF, 8)
	IF D2 < 1 THEN PgPrt 1, " blow bounces off armour!": RETURN
	MD%(DF, 13) = MD%(DF, 13) + D2
	IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO IS.DEAD
	A = MD%(DF, 14)
	FD%(A) = FD%(A) + D2
SHOW.CONDITION:
	PRINT MN$(DF);
	ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:
	PgPrt 1, " is still in good shape."
	RETURN
HURTING:
	PgPrt 1, " is hurting."
	RETURN
IN.PAIN:
	PgPrt 1, " is in pain."
	RETURN
BADLY.INJURED:
	PgPrt 1, " is very badly injured!"
	RETURN
DEATHS.DOOR:
	PgPrt 1, " is at death's door, knocking loudly!"
	RETURN
IS.DEAD:
	PgPrt 1, MN$(DF) + " is dead!"
	A = MD%(DF, 14)
	FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
	MD%(DF, 5) = 0
	FOR AJ = 1 TO NA
	IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
	NEXT
	IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
	IF DF = 0 THEN DIE = 1: GOTO GAME.OVER
	A2 = DF + NZ - NM
	AD%(A2, 4) = Room
' PUT DEAD BODY IN ROOM
	IF DF = 10 THEN R = 3: GOSUB PRINT.EFFECT: AD%(10, 8) = 6
	IF DF = 7 THEN PgPrt 2, "As the Mimic dies, it rolls over and you find a ring underneath it.": AD%(6, 4) = Room
	RETURN
FLEE.RTN:
	IF NOT NBTL THEN PgPrt 2, "There's no reason to run!": GOTO MAIN.LOOP
	IF MD%(7, 5) = Room THEN PgPrt 2, "You are held fast by the Mimic and cannot flee!": GOTO Get.Back
	IF MD%(15, 5) = Room THEN PgPrt 2, "You are held tightly by the coils of the snake!": GOTO Get.Back
	IF NX = 0 THEN PgPrt 2, "There's no place to go!": GOTO MAIN.LOOP
	IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
		IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: EXIT FOR
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
	END IF
	GOSUB FIND.EXIT
	GOTO MOVE.IT
FIND.EXIT:
	IF NX = 0 THEN R2 = Room: PgPrt 1, " ... but can't find an exit!": RETURN
	D = FNR(ND)
	R2 = RD%(D)
	IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
	RETURN
GIVE.RTN:
	IF S$ = "" THEN GOSUB GET.SUBJ
	A = 0
	M = 0
	M$ = ""
	A$ = ""
	SEP = INSTR(S$, " TO ")
	IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
	END IF
	SEP = INSTR(S$, " ")
	IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
		  M$ = S$
		  A$ = MID$(SAVE.S$, SP)
		  GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
		A$ = MID$(S$, SEP + 1)
		M$ = LEFT$(S$, SEP - 1)
	ELSE
		GOSUB GIVE.WHO
		GOSUB GIVE.WHAT
	END IF
	ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
		A$ = AN$(A)
	ELSE
		GOSUB MONSTER.SEARCH
		IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
		END IF
	END IF
	END IF
READY.SEARCH.GIVE:
	GOSUB GIVE.WHO
	GOSUB GIVE.WHAT
	IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
	END IF
	IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
		S$ = A$
		GOSUB ARTIFACT.SEARCH
	END IF
	END IF
	IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
	IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
	PgPrt 2, "I don't know what you mean."
	GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
	PgPrt 2, "Okay."
	POP = 0
	GOSUB GIVE.ART.MON
	IF POP <> 0 THEN GOTO MAIN.LOOP
	IF A = MD%(0, 9) THEN MD%(0, 9) = -1
	AD%(A, 4) = -M - 1
	MD%(M, 14) = 0
	IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
	IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
	R3 = Room
	GOSUB CHK.REACTIONS
	GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
	IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor
	RETURN
GIVE.GOLD:
	IF VAL(A$) > GOLD& THEN PgPrt 2, "You aren't carrying that much gold!": GOTO Get.Back
	GOLD& = INT(GOLD& - VAL(A$))
	MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
	MD%(M, 14) = 0
	IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
	GOTO COMPLETE.GIVE
GIVE.WHO:
	IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
	RETURN
GIVE.WHAT:
	IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
	RETURN
INVENTORY.RTN:
	PgPrt 2, "You are carrying the following ---"
	A0 = 0
	FOR A = 1 TO NA
	IF AD%(A, 4) = -1 THEN
	PRINT " " + AN$(A);
	IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
	IF A = ArmPtr THEN PRINT " (Worn Armour)";
	IF A = ShdPtr THEN PRINT " (Your Shield)";
	PgPrt 1, " "
	END IF
	NEXT
	GOTO Get.Back
BLAST.SPELL:
	GOSUB GET.SUBJ
	GOSUB MONSTER.SEARCH
	IF FOUND = 0 THEN GOTO CANT.BLAST
	S = 1
	GOSUB CAST.SPELL
	IF NOT SUC THEN GOTO Get.Back
	PgPrt 2, "Direct Hit!"
	S = 6
	D = 1
	DF = M
	A = 0
	GOSUB DO.DAMAGE
	GOTO Get.Back
CANT.BLAST:
	PgPrt 2, "You can't Blast " + S$ + "!"
	GOTO MAIN.LOOP
CAST.SPELL:
	SUC = 0
	IF SA%(S) THEN RL = FNR(100): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN GOTO FORGET.IT
	IF NOT SUC THEN PgPrt 2, "Nothing happened.": RETURN
	RL = FNR(100)
	IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
	S2%(S) = S2%(S) / 2
	RETURN
FORGET.IT:
	PgPrt 2, "The strain of attempting to cast this spell overloads your brain and you      forget it completely."
	SA%(S) = 0
	RETURN
HEAL.SPELL:
	S = 2
	GOSUB CAST.SPELL
	IF NOT SUC THEN GOTO Get.Back
	IF MD%(0, 13) THEN PgPrt 2, "Some of your wounds seem to clear up."
	MD%(0, 13) = MD%(0, 13) - FNR(10)
	IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
	DF = 0
	GOSUB SHOW.CONDITION
	GOTO Get.Back
POWER.SPELL:
	S = 4
	GOSUB CAST.SPELL
	IF NOT SUC THEN GOTO Get.Back
	RAISE = 0
	FOR M = 1 TO NM
	M2 = NZ - NM + M
	IF AD%(M2, 4) = Room OR AD%(M2, 4) = -1 THEN RAISE = 1: GOSUB RAISE.DEAD
	NEXT M
	IF RAISE THEN R3 = Room: GOSUB CHK.REACTIONS: GOTO Get.Back
	FOR A = 1 TO NA
	IF AD%(A, 4) = Room THEN RAISE = -1: PgPrt 1, AN$(A) + " vanishes!": AD%(A, 4) = 0
	NEXT A
	IF RAISE THEN PgPrt 1, " ": GOTO Get.Back
	RR = FNR(100)
	IF RR < 11 THEN PgPrt 2, "The section of tunnel you are in collapses and you die.": DIE = 1: GOTO GAME.OVER
	IF RR < 86 THEN PgPrt 2, "You hear a very loud sonic boom that echoes through the tunnels.": GOTO Get.Back
	IF RR > 95 THEN PgPrt 2, "All of your wounds are healed.": MD%(0, 13) = 0: GOTO Get.Back
	GOTO DO.SPEED
RAISE.DEAD:
	PgPrt 1, MN$(M) + " comes to life!"
	AD%(M2, 4) = 0
	MD%(M, 5) = Room
	MD%(M, 13) = 0
	IF AD%(M2, 4) = -1 THEN WT = WT - AD%(M2, 3)
	RETURN
SPEED.SPELL:
	S = 3
	GOSUB CAST.SPELL
	IF NOT SUC THEN GOTO Get.Back
DO.SPEED:
	IF SPD = 0 THEN MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2): MD%(0, 2) = 2 * MD%(0, 2)
	SPD = SPD + FNR(25) + 10
	PgPrt 2, "You can feel the new agility flowing through you!"
	GOTO Get.Back
SMILE.RTN:
	PgPrt 1, " "
	FOR M = 1 TO NM
	IF MD%(M, 5) = Room THEN ON MD%(M, 14) GOSUB GROWL, IGNORE, SMILE
	NEXT
	GOTO Get.Back
GROWL:
	PgPrt 1, MN$(M) + " growls at you!"
	RETURN
IGNORE:
	PgPrt 1, MN$(M) + " ignores you."
	RETURN
SMILE:
	PgPrt 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
	RETURN
SAY.SOMETHING:
	GOSUB GET.SUBJ
	IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
	IF S$ = "HEAL" THEN GOTO HEAL.SPELL
	IF S$ = "POWER" THEN GOTO POWER.SPELL
	IF S$ = "SPEED" THEN GOTO SPEED.SPELL
	IF S$ = "TROLLSFIRE" THEN GOTO TROLLSFIRE
	PgPrt 2, "Okay, " + CHR$(34) + UCASE$(LEFT$(S$, 1)) + LCASE$(MID$(S$, 2)) + CHR$(34)
	GOTO Get.Back
READY.WEAPON:
	GOSUB GET.SUBJ
	WH = -1
	HA = -1
	EMB = -1
	GOSUB LOCATE.ART
	IF FOUND = 0 THEN PgPrt 2, "You aren't carrying it!": GOTO MAIN.LOOP
	IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PgPrt 2, "That isn't a legal weapon!": GOTO MAIN.LOOP
	MD%(0, 10) = (EA + AE) * (-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
	MD%(0, 9) = A
	MD%(0, 11) = AD%(A, 7)
	MD%(0, 12) = AD%(A, 8)
	PgPrt 2, "Readied."
	GOTO Get.Back
LIGHT.RTN:
	GOSUB GET.SUBJ
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN PgPrt 2, "I don't know what you mean.": GOTO MAIN.LOOP
	IF AD%(A, 2) <> 5 THEN PgPrt 2, "You burn yourself!": GOTO Get.Back
	IF AD%(A, 4) <> -1 THEN PgPrt 2, "You have to pick it up first.": GOTO MAIN.LOOP
	LT = NL
	IF AD%(A, 5) <= 0 THEN PgPrt 2, "It won't light!": GOTO MAIN.LOOP
	LM = -1
	LT = -1
	LC = AD%(A, 5)
	LS = A
	PgPrt 2, "You've managed to light the " + AN$(A) + "."
	GOTO Get.Back
OPEN.RTN:
	GOSUB GET.SUBJ
	WH = Room
	HA = -1
	EMB = Room + 200
	GOSUB LOCATE.ART
	IF FOUND = 0 THEN GOTO OPEN.WHAT
	IF A = 12 THEN GOTO OPEN.CHEST
	IF AD%(A, 2) = 4 THEN GOTO OPEN.CONTAINER
	IF AD%(A, 2) = 7 THEN PgPrt 2, "Try reading it.": GOTO MAIN.LOOP
	IF AD%(A, 2) = 1 THEN PgPrt 2, "You'll make a mess. Wait till you leave.": GOTO MAIN.LOOP
	IF AD%(A, 2) = 8 THEN GOTO OPEN.DOOR.GATE
	PgPrt 2, "That's not what you do with it."
	GOTO MAIN.LOOP
OPEN.CONTAINER:
	IF AD%(A, 5) THEN IF AD%(AD%(A, 5), 4) <> -1 THEN PgPrt 2, "It's locked!": GOTO MAIN.LOOP
	LK = 0
	WH = A + 100
	HA = WH
	Room = WH
	GOSUB LOCATE.ART
	IF FOUND <> 0 THEN AD%(A, 4) = Room: LK = -1:
	IF LK THEN PgPrt 2, "You found something inside!"
	GOTO Get.Back
OPEN.WHAT:
	IF S$ = "DOOR" OR S$ = "GATE" THEN PgPrt 2, "It should open when you approach.": GOTO MAIN.LOOP
	PgPrt 2, "I don't know how to open " + LCASE$(S$) + "."
	GOTO MAIN.LOOP
OPEN.DOOR.GATE:
	IF AD%(A, 6) THEN IF AD%(AD%(A, 6), 4) <> -1 THEN PgPrt 2, "It's locked.": GOTO MAIN.LOOP
	AD%(A, 6) = 0
	PgPrt 2, "You've opened the " + AN$(A) + "."
	FOR X = 1 TO ND
	IF RD%(X) = A + 100 THEN RD%(X) = AD%(A, 5)
	NEXT
	GOTO Get.Back
OPEN.CHEST:
	PgPrt 1, " "
	R = 1
	GOSUB PRINT.EFFECT
	AD%(12, 4) = 0
	MD%(7, 5) = Room
	R3 = Room
	GOSUB CHK.REACTIONS
	GOTO MAIN.LOOP
PUT.RTN:
	IF S$ = "" THEN GOTO PUT.WHAT.WHERE
	FOR X = 1 TO LEN(S$)
	IF MID$(S$, X, 5) = " INTO" AND X > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 6): GOTO PUT.AWAY
	IF MID$(S$, X, 3) = " IN" AND X > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 3): GOTO PUT.AWAY
	NEXT
PUT.WHAT.WHERE:
	PRINT
	INPUT "Put What?", A$
	INPUT "Put into What?", B$
	PgPrt 3, ""
	GOTO PUT.AWAY
PUT.AWAY:
	S$ = A$
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN PgPrt 2, "I don't know what you mean.": GOTO MAIN.LOOP
	X = A
	S$ = B$
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 OR A = X THEN GOTO PUT.NONSENSE
	AD%(X, 4) = A + 100
	PgPrt 2, "Okay."
	GOTO Get.Back
PUT.NONSENSE:
	PgPrt 2, "You aren't making sense."
	GOTO MAIN.LOOP
DRINK.RTN:
	GOSUB GET.SUBJ
	IF S$ = "POTION" THEN S$ = "BOTTLE"
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN PgPrt 2, "I don't understand.": GOTO MAIN.LOOP
	IF AD%(A, 2) <> 6 THEN PgPrt 2, "You can't do that!": GOTO MAIN.LOOP
	IF AD%(A, 7) <= 0 THEN PgPrt 2, "There isn't any left.": GOTO Get.Back
	IF AD%(A, 5) > FNR(100) THEN GOTO DRINK.HEAL
	PgPrt 2, "Nothing seems to happen."
	GOTO Get.Back
DRINK.HEAL:
	AD%(A, 7) = AD%(A, 7) - 1
	MD%(0, 13) = MD%(0, 13) - AD%(A, 6)
	IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
	PgPrt 2, "Your wounds seem to " + MID$("openheal", ABS(AD%(A, 6) > 0) * 4 + 1, 4) + "!"
	GOTO Get.Back
READ.RTN:
	GOSUB GET.SUBJ
	WH = Room
	HA = -1
	EMB = Room + 200
	GOSUB LOCATE.ART
	IF FOUND = 0 THEN GOTO READ.NON.ART
	IF AD%(A, 2) = 7 THEN GOTO READ.ART
	PgPrt 2, "You can't read that."
	GOTO Get.Back
READ.NON.ART:
	PgPrt 2, "There is nothing to read."
	GOTO MAIN.LOOP
READ.ART:
	IF A = 9 THEN GOTO READ.BOOK
	FOR X = 1 TO AD%(A, 6)
	R = AD%(A, 5) - 1 + X
	GOSUB PRINT.EFFECT
	NEXT
	GOTO Get.Back
READ.BOOK:
	R = 7
	GOSUB PRINT.EFFECT
	IF Room = 26 THEN R = 8: GOSUB PRINT.EFFECT: DIE = 1: GOTO GAME.OVER
	R = 9
	GOSUB PRINT.EFFECT
	DIE = 1
	GOTO GAME.OVER
PRINT.EFFECT:
	GET #2, R + EFF.ADJ
	A$ = RTRIM$(Desc$)
	PgPrt 1, A$
	RETURN
FREE.RTN:
	GOSUB GET.SUBJ
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN PgPrt 2, "I don't understand.": GOTO MAIN.LOOP
	IF AD%(A, 2) <> 10 THEN PgPrt 2, "I don't understand.": GOTO MAIN.LOOP
	M = AD%(A, 5)
	K = AD%(A, 6)
	G = AD%(A, 7)
	IF AD%(A, 4) <> Room THEN PgPrt 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
	IF MD%(G, 5) = Room THEN PgPrt 2, MN$(G) + " won't let you do that!": GOTO Get.Back
	IF AD%(K, 4) <> -1 AND K <> 0 THEN PgPrt 2, "You don't have the key!": GOTO MAIN.LOOP
	PgPrt 2, "You have freed " + MN$(M) + "."
	MD%(M, 5) = Room
	AD%(A, 4) = 0
	R3 = Room
	GOSUB CHK.REACTIONS
	GOTO Get.Back
ENTER.RTN:
	IF (S$ = "WATER" OR S$ = "SEA") AND Room = 26 THEN PgPrt 2, "I'm afraid to go into the water without my life preserver!": GOTO MAIN.LOOP
	IF S$ = "CAVE" AND Room = 1 THEN V$ = "S": GOTO MOVE.RTN
	PgPrt 2, "I'm not sure what you mean by that. Try giving a direction to move in."
	GOTO MAIN.LOOP
TROLLSFIRE:
	IF AD%(10, 4) <> -1 THEN PgPrt 2, "Nothing happens.": GOTO Get.Back
	IF TR = 0 THEN GOTO TF.IGNITE
	PgPrt 1, " "
	R = 6
	GOSUB PRINT.EFFECT
	TR = 0
	AD%(10, 8) = 6
	IF MD%(0, 9) = 10 THEN MD%(0, 12) = 6
	GOTO Get.Back
TF.IGNITE:
	PgPrt 1, " "
	R = 4
	GOSUB PRINT.EFFECT
	IF MD%(0, 9) <> 10 THEN R = 5: GOSUB PRINT.EFFECT: D = 1: S = 5: DF = 0: GOSUB DO.DAMAGE: GOTO Get.Back
	TR = -1
	AD%(10, 8) = 10
	MD%(0, 12) = 10
	GOTO Get.Back
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\Eamon\copy\Advenio.OLD'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVENIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       uses Field statements for record description
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       IF Art.Len = 0 THEN Art.Len = 128
       IF Art.Flds = 0 THEN Art.Flds = 8
       IF AN.Len = 0 THEN AN.Len = 20
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = Art.Len
       FIELD 3, AN.Len AS AF.NAME$
       DIM AF.DATA$(Art.Flds)
       FOR A2 = 1 TO Art.Flds
       FIELD 3, AN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS AF.DATA$(A2)
       NEXT
       FOR A = 1 TO NA
           GET #3, A
           AN$(A) = RTRIM$(AF.NAME$)
           FOR A2 = 1 TO Art.Flds
               AD%(A, A2) = CVI(AF.DATA$(A2))
           NEXT A2
           IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       IF MON.LEN = 0 THEN MON.LEN = 128
       IF Mon.Flds = 0 THEN Mon.Flds = 12
       IF MN.Len = 0 THEN MN.Len = 20
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = MON.LEN
       FIELD 3, MN.Len AS MF.NAME$
       DIM MF.DATA$(Mon.Flds)
       FOR A2 = 1 TO Mon.Flds
           FIELD 3, MN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM
           GET #3, A
           MN$(A) = RTRIM$(MF.NAME$)
           FOR A2 = 1 TO Mon.Flds
               MD%(A, A2) = CVI(MF.DATA$(A2))
           NEXT A2
           IF MD%(A, 3) < 0 THEN               ' Force nuetral if < 0
              MD%(A, 3) = ABS(MD%(A, 3)) - 1
              MD%(A, 14) = 2
           END IF
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       IF Desc.Len = 0 THEN Desc.Len = 256
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = Desc.Len
       FIELD 2, Desc.Len - 1 AS Desc$
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       IF RMN.Len = 0 THEN RMN.Len = 64
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = RMN.Len
       FIELD 3, RMN.Len AS RN$
       RETURN
OPEN.ROOMS:      ' ---------------- OPEN ROOMS FILE -------------------
       IF RM.LEN = 0 THEN RM.LEN = 64
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = RM.LEN
       FOR D = 1 TO 10
           FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 20 AS X$, 1 AS RF.LT$
       RETURN
Read.Room:
       GET #1, Room
       IF ND = 0 THEN ND = 6
       NX = 0
       FOR X = 1 TO ND
           RD%(X) = CVI(RF.DIR$(X))
           IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
       NEXT
       NL = VAL(RF.LT$)
       GET #3, Room
       RETURN
    '------- (end of include file) -------

    '------- (end of include file) -------    
 ' 

SUB PgPrt (SP, LIT$)
	STATIC LINE.PG
	IF SP = 0 THEN LINE.PG = 0: EXIT SUB
	IF LIT$ = "" THEN LINE.PG = LINE.PG + SP: EXIT SUB
	IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	LINE.PG = LINE.PG + 1
	NEXT
	END IF
	IF LINE.PG > 20 THEN
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-")
	A$ = INPUT$(1)
	LOCATE CSRLIN - 1, 1
	PRINT SPC(79);
	LINE.PG = 0
	END IF
	PRINT LIT$
	LINE.PG = LINE.PG + LEN(LIT$) / 79 + 1
END SUB

DEFSNG A-Z
SUB Pressanykey (A$)
	PRINT "(Press any key to continue)";
	A$ = INPUT$(1)
	PRINT

END SUB

SUB RemoveDups (WN$(), N%)
	FOR X = 1 TO N%
	   FOR Y = X TO N%
		   IF UCASE$(WN$(X)) = UCASE$(WN$(Y)) AND X <> Y THEN WN$(Y) = WN$(X) + "#"
	   NEXT
	NEXT

END SUB

