DECLARE SUB Move ()
DECLARE SUB Save ()
DECLARE SUB Load ()
DECLARE SUB PutCar ()
DECLARE SUB PlotTile ()
DECLARE SUB LoadGraphics ()

'$DYNAMIC
DIM SHARED Sprite%(1050), Mask%(104)
DIM SHARED X, Y, Tile
DIM SHARED MapData$(21), TimeLimit%

OnceMore:
FOR I = 1 TO 20
  MapData$(I) = "00000000000000000000"
NEXT I

SCREEN 13
LoadGraphics

Reload:
FOR Ya% = 0 TO 19 STEP 1
  FOR Xa% = 0 TO 19 STEP 1
    PUT (Xa% * 10, Ya% * 10), Sprite%(VAL(MID$(MapData$(Ya% + 1), Xa% + 1, 1)) * 105), PSET
  NEXT Xa%
NEXT Ya%


X = 0: Y = 0: Tile = 1

Refresh:
LINE (X, Y)-(X + 9, Y + 9), 15, B
LOCATE 1, 28: PRINT "X"; X; "Y"; Y
LOCATE 3, 27: PRINT "Now using tile"
LOCATE 6, 27: PRINT TimeLimit%
LOCATE 7, 27: PRINT "Seconds."
LINE (249, 29)-(260, 40), 15, B
PUT (250, 30), Sprite%(Tile * 105), PSET

DO
  Key$ = INKEY$
  IF Key$ = CHR$(0) + "H" AND Y > 0 THEN
    IF MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1) = "9" THEN PutCar: GOTO Skip1
    PUT (X, Y), Sprite%(VAL(MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1)) * 105), PSET
Skip1:
    Y = Y - 10
    GOTO Refresh
  END IF
  IF Key$ = CHR$(0) + "P" AND Y < 190 THEN
    IF MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1) = "9" THEN PutCar: GOTO Skip2
    PUT (X, Y), Sprite%(VAL(MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1)) * 105), PSET
Skip2:
    Y = Y + 10
    GOTO Refresh
  END IF
  IF Key$ = CHR$(0) + "K" AND X > 0 THEN
    IF MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1) = "9" THEN PutCar: GOTO Skip3
    PUT (X, Y), Sprite%(VAL(MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1)) * 105), PSET
Skip3:
    X = X - 10
    GOTO Refresh
  END IF
  IF Key$ = CHR$(0) + "M" AND X < 190 THEN
    IF MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1) = "9" THEN PutCar: GOTO Skip4
    PUT (X, Y), Sprite%(VAL(MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1)) * 105), PSET
Skip4:
    X = X + 10
    GOTO Refresh
  END IF
  IF Key$ = "+" AND Tile < 9 THEN Tile = Tile + 1: GOTO Refresh
  IF Key$ = "=" AND Tile < 9 THEN Tile = Tile + 1: GOTO Refresh
  IF Key$ = "-" AND Tile > 0 THEN Tile = Tile - 1: GOTO Refresh
  IF Key$ = " " OR Key$ = CHR$(13) THEN PlotTile: GOTO Refresh
  IF UCASE$(Key$) = "S" THEN Save: GOTO Reload
  IF UCASE$(Key$) = "L" THEN Load: GOTO Reload
  IF UCASE$(Key$) = "M" THEN Move: GOTO Reload
LOOP UNTIL Key$ = CHR$(27)

CLS
SCREEN 0
PRINT "Make another Map? (Y/N)"
DO
  Key$ = INKEY$
  IF UCASE$(Key$) = "Y" THEN GOTO OnceMore
LOOP UNTIL UCASE$(Key$) = "N"

END

REM $STATIC
SUB Load

CLS
PRINT "Please type the name of your map by the "
PRINT "filename only (Without ext or dir)."
PRINT
INPUT "FILENAME "; A$

OPEN "maps/" + LTRIM$(A$) + ".map" FOR INPUT AS #5
  FOR I = 1 TO 20
    INPUT #5, MapData$(I)
  NEXT I
  INPUT #5, TimeLimit%
CLOSE #5

CLS

END SUB

SUB LoadGraphics

FOR I = 1 TO 10
  X = I
  IF I = 10 THEN X = 0
  A$ = LTRIM$(STR$(X))
  DEF SEG = VARSEG(Sprite%(105 * X))
    BLOAD "graphics\tile" + A$ + ".til", VARPTR(Sprite%(105 * X))
  DEF SEG
NEXT I

DEF SEG = VARSEG(Mask%(0))
  BLOAD "graphics\mask.til", 0
DEF SEG

END SUB

SUB Move

DO
  Key$ = INKEY$
  IF Key$ = CHR$(0) + "H" THEN
    FOR I = 1 TO 20
      MapData$(I - 1) = MapData$(I)
    NEXT I
    MapData$(20) = "00000000000000000000"
    GOTO FinishedThat
  END IF
  IF Key$ = CHR$(0) + "P" THEN
    FOR I = 20 TO 1 STEP -1
      MapData$(I + 1) = MapData$(I)
    NEXT I
    MapData$(1) = "00000000000000000000"
    GOTO FinishedThat
  END IF
  IF Key$ = CHR$(0) + "M" THEN
    FOR I = 1 TO 20
      MapData$(I) = "0" + MapData$(I)
      MapData$(I) = LEFT$(MapData$(I), 20)
    NEXT I
    GOTO FinishedThat
  END IF
  IF Key$ = CHR$(0) + "K" THEN
    FOR I = 1 TO 20
      MapData$(I) = RIGHT$(MapData$(I), 19) + "0"
    NEXT I
    GOTO FinishedThat
  END IF
LOOP UNTIL Key$ = CHR$(27)

FinishedThat:

END SUB

SUB PlotTile

PUT (X, Y), Sprite%(105 * Tile), PSET
MID$(MapData$((Y / 10) + 1), (X / 10) + 1, 1) = LTRIM$(STR$(Tile))

IF Tile = 9 THEN
  PUT (X, Y), Sprite%(105), PSET
  PUT (X, Y), Mask%, OR
  PUT (X, Y), Sprite%(105 * 9), AND
END IF

END SUB

SUB PutCar

PUT (X, Y), Sprite%(105), PSET
PUT (X, Y), Mask%, OR
PUT (X, Y), Sprite%(105 * 9), AND

END SUB

SUB Save

CLS
PRINT "Please type the name of your map by the "
PRINT "filename only (Without ext or dir)."
PRINT
INPUT "FILENAME "; A$
PRINT
PRINT "Please Set a Time Limit for your level"
PRINT "in Seconds."
PRINT
INPUT "TIME LIMIT "; TimeLimit%


OPEN "maps/" + LTRIM$(A$) + ".map" FOR OUTPUT AS #5
  FOR I = 1 TO 20
    PRINT #5, MapData$(I)
  NEXT I
  PRINT #5, TimeLimit%
CLOSE #5

OPEN "maps/" + LTRIM$((LEFT$(A$, 4))) + ".dat" FOR OUTPUT AS #5
  PRINT #5, MID$(A$, 5)
CLOSE #5


CLS

END SUB

